/**
 * @license
 * Copyright 2024 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.tf = global.tf || {}));
})(this, (function (exports) { 'use strict';

	function _mergeNamespaces(n, m) {
		m.forEach(function (e) {
			e && typeof e !== 'string' && !Array.isArray(e) && Object.keys(e).forEach(function (k) {
				if (k !== 'default' && !(k in n)) {
					var d = Object.getOwnPropertyDescriptor(e, k);
					Object.defineProperty(n, k, d.get ? d : {
						enumerable: true,
						get: function () { return e[k]; }
					});
				}
			});
		});
		return n;
	}

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function getDefaultExportFromNamespaceIfPresent (n) {
		return n && Object.prototype.hasOwnProperty.call(n, 'default') ? n['default'] : n;
	}

	function getDefaultExportFromNamespaceIfNotNamed (n) {
		return n && Object.prototype.hasOwnProperty.call(n, 'default') && Object.keys(n).length === 1 ? n['default'] : n;
	}

	function getAugmentedNamespace(n) {
	  if (n.__esModule) return n;
	  var f = n.default;
		if (typeof f == "function") {
			var a = function a () {
				if (this instanceof a) {
					var args = [null];
					args.push.apply(args, arguments);
					var Ctor = Function.bind.apply(f, args);
					return new Ctor();
				}
				return f.apply(this, arguments);
			};
			a.prototype = f.prototype;
	  } else a = {};
	  Object.defineProperty(a, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var es_symbol = {};

	var es_symbol_constructor = {};

	function _AsyncGenerator(gen) {
	  var front, back;
	  function resume(key, arg) {
	    try {
	      var result = gen[key](arg),
	        value = result.value,
	        overloaded = value instanceof _OverloadYield;
	      Promise.resolve(overloaded ? value.v : value).then(function (arg) {
	        if (overloaded) {
	          var nextKey = "return" === key ? "return" : "next";
	          if (!value.k || arg.done) return resume(nextKey, arg);
	          arg = gen[nextKey](arg).value;
	        }
	        settle(result.done ? "return" : "normal", arg);
	      }, function (err) {
	        resume("throw", err);
	      });
	    } catch (err) {
	      settle("throw", err);
	    }
	  }
	  function settle(type, value) {
	    switch (type) {
	      case "return":
	        front.resolve({
	          value: value,
	          done: !0
	        });
	        break;
	      case "throw":
	        front.reject(value);
	        break;
	      default:
	        front.resolve({
	          value: value,
	          done: !1
	        });
	    }
	    (front = front.next) ? resume(front.key, front.arg) : back = null;
	  }
	  this._invoke = function (key, arg) {
	    return new Promise(function (resolve, reject) {
	      var request = {
	        key: key,
	        arg: arg,
	        resolve: resolve,
	        reject: reject,
	        next: null
	      };
	      back ? back = back.next = request : (front = back = request, resume(key, arg));
	    });
	  }, "function" != typeof gen.return && (this.return = void 0);
	}
	_AsyncGenerator.prototype["function" == typeof Symbol && Symbol.asyncIterator || "@@asyncIterator"] = function () {
	  return this;
	}, _AsyncGenerator.prototype.next = function (arg) {
	  return this._invoke("next", arg);
	}, _AsyncGenerator.prototype.throw = function (arg) {
	  return this._invoke("throw", arg);
	}, _AsyncGenerator.prototype.return = function (arg) {
	  return this._invoke("return", arg);
	};
	function _OverloadYield(value, kind) {
	  this.v = value, this.k = kind;
	}
	function old_createMetadataMethodsForProperty(metadataMap, kind, property, decoratorFinishedRef) {
	  return {
	    getMetadata: function (key) {
	      old_assertNotFinished(decoratorFinishedRef, "getMetadata"), old_assertMetadataKey(key);
	      var metadataForKey = metadataMap[key];
	      if (void 0 !== metadataForKey) if (1 === kind) {
	        var pub = metadataForKey.public;
	        if (void 0 !== pub) return pub[property];
	      } else if (2 === kind) {
	        var priv = metadataForKey.private;
	        if (void 0 !== priv) return priv.get(property);
	      } else if (Object.hasOwnProperty.call(metadataForKey, "constructor")) return metadataForKey.constructor;
	    },
	    setMetadata: function (key, value) {
	      old_assertNotFinished(decoratorFinishedRef, "setMetadata"), old_assertMetadataKey(key);
	      var metadataForKey = metadataMap[key];
	      if (void 0 === metadataForKey && (metadataForKey = metadataMap[key] = {}), 1 === kind) {
	        var pub = metadataForKey.public;
	        void 0 === pub && (pub = metadataForKey.public = {}), pub[property] = value;
	      } else if (2 === kind) {
	        var priv = metadataForKey.priv;
	        void 0 === priv && (priv = metadataForKey.private = new Map()), priv.set(property, value);
	      } else metadataForKey.constructor = value;
	    }
	  };
	}
	function old_convertMetadataMapToFinal(obj, metadataMap) {
	  var parentMetadataMap = obj[Symbol.metadata || Symbol.for("Symbol.metadata")],
	    metadataKeys = Object.getOwnPropertySymbols(metadataMap);
	  if (0 !== metadataKeys.length) {
	    for (var i = 0; i < metadataKeys.length; i++) {
	      var key = metadataKeys[i],
	        metaForKey = metadataMap[key],
	        parentMetaForKey = parentMetadataMap ? parentMetadataMap[key] : null,
	        pub = metaForKey.public,
	        parentPub = parentMetaForKey ? parentMetaForKey.public : null;
	      pub && parentPub && Object.setPrototypeOf(pub, parentPub);
	      var priv = metaForKey.private;
	      if (priv) {
	        var privArr = Array.from(priv.values()),
	          parentPriv = parentMetaForKey ? parentMetaForKey.private : null;
	        parentPriv && (privArr = privArr.concat(parentPriv)), metaForKey.private = privArr;
	      }
	      parentMetaForKey && Object.setPrototypeOf(metaForKey, parentMetaForKey);
	    }
	    parentMetadataMap && Object.setPrototypeOf(metadataMap, parentMetadataMap), obj[Symbol.metadata || Symbol.for("Symbol.metadata")] = metadataMap;
	  }
	}
	function old_createAddInitializerMethod(initializers, decoratorFinishedRef) {
	  return function (initializer) {
	    old_assertNotFinished(decoratorFinishedRef, "addInitializer"), old_assertCallable(initializer, "An initializer"), initializers.push(initializer);
	  };
	}
	function old_memberDec(dec, name, desc, metadataMap, initializers, kind, isStatic, isPrivate, value) {
	  var kindStr;
	  switch (kind) {
	    case 1:
	      kindStr = "accessor";
	      break;
	    case 2:
	      kindStr = "method";
	      break;
	    case 3:
	      kindStr = "getter";
	      break;
	    case 4:
	      kindStr = "setter";
	      break;
	    default:
	      kindStr = "field";
	  }
	  var metadataKind,
	    metadataName,
	    ctx = {
	      kind: kindStr,
	      name: isPrivate ? "#" + name : name,
	      isStatic: isStatic,
	      isPrivate: isPrivate
	    },
	    decoratorFinishedRef = {
	      v: !1
	    };
	  if (0 !== kind && (ctx.addInitializer = old_createAddInitializerMethod(initializers, decoratorFinishedRef)), isPrivate) {
	    metadataKind = 2, metadataName = Symbol(name);
	    var access = {};
	    0 === kind ? (access.get = desc.get, access.set = desc.set) : 2 === kind ? access.get = function () {
	      return desc.value;
	    } : (1 !== kind && 3 !== kind || (access.get = function () {
	      return desc.get.call(this);
	    }), 1 !== kind && 4 !== kind || (access.set = function (v) {
	      desc.set.call(this, v);
	    })), ctx.access = access;
	  } else metadataKind = 1, metadataName = name;
	  try {
	    return dec(value, Object.assign(ctx, old_createMetadataMethodsForProperty(metadataMap, metadataKind, metadataName, decoratorFinishedRef)));
	  } finally {
	    decoratorFinishedRef.v = !0;
	  }
	}
	function old_assertNotFinished(decoratorFinishedRef, fnName) {
	  if (decoratorFinishedRef.v) throw new Error("attempted to call " + fnName + " after decoration was finished");
	}
	function old_assertMetadataKey(key) {
	  if ("symbol" != typeof key) throw new TypeError("Metadata keys must be symbols, received: " + key);
	}
	function old_assertCallable(fn, hint) {
	  if ("function" != typeof fn) throw new TypeError(hint + " must be a function");
	}
	function old_assertValidReturnValue(kind, value) {
	  var type = typeof value;
	  if (1 === kind) {
	    if ("object" !== type || null === value) throw new TypeError("accessor decorators must return an object with get, set, or init properties or void 0");
	    void 0 !== value.get && old_assertCallable(value.get, "accessor.get"), void 0 !== value.set && old_assertCallable(value.set, "accessor.set"), void 0 !== value.init && old_assertCallable(value.init, "accessor.init"), void 0 !== value.initializer && old_assertCallable(value.initializer, "accessor.initializer");
	  } else if ("function" !== type) {
	    var hint;
	    throw hint = 0 === kind ? "field" : 10 === kind ? "class" : "method", new TypeError(hint + " decorators must return a function or void 0");
	  }
	}
	function old_getInit(desc) {
	  var initializer;
	  return null == (initializer = desc.init) && (initializer = desc.initializer) && "undefined" != typeof console && console.warn(".initializer has been renamed to .init as of March 2022"), initializer;
	}
	function old_applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, metadataMap, initializers) {
	  var desc,
	    initializer,
	    value,
	    newValue,
	    get,
	    set,
	    decs = decInfo[0];
	  if (isPrivate ? desc = 0 === kind || 1 === kind ? {
	    get: decInfo[3],
	    set: decInfo[4]
	  } : 3 === kind ? {
	    get: decInfo[3]
	  } : 4 === kind ? {
	    set: decInfo[3]
	  } : {
	    value: decInfo[3]
	  } : 0 !== kind && (desc = Object.getOwnPropertyDescriptor(base, name)), 1 === kind ? value = {
	    get: desc.get,
	    set: desc.set
	  } : 2 === kind ? value = desc.value : 3 === kind ? value = desc.get : 4 === kind && (value = desc.set), "function" == typeof decs) void 0 !== (newValue = old_memberDec(decs, name, desc, metadataMap, initializers, kind, isStatic, isPrivate, value)) && (old_assertValidReturnValue(kind, newValue), 0 === kind ? initializer = newValue : 1 === kind ? (initializer = old_getInit(newValue), get = newValue.get || value.get, set = newValue.set || value.set, value = {
	    get: get,
	    set: set
	  }) : value = newValue);else for (var i = decs.length - 1; i >= 0; i--) {
	    var newInit;
	    if (void 0 !== (newValue = old_memberDec(decs[i], name, desc, metadataMap, initializers, kind, isStatic, isPrivate, value))) old_assertValidReturnValue(kind, newValue), 0 === kind ? newInit = newValue : 1 === kind ? (newInit = old_getInit(newValue), get = newValue.get || value.get, set = newValue.set || value.set, value = {
	      get: get,
	      set: set
	    }) : value = newValue, void 0 !== newInit && (void 0 === initializer ? initializer = newInit : "function" == typeof initializer ? initializer = [initializer, newInit] : initializer.push(newInit));
	  }
	  if (0 === kind || 1 === kind) {
	    if (void 0 === initializer) initializer = function (instance, init) {
	      return init;
	    };else if ("function" != typeof initializer) {
	      var ownInitializers = initializer;
	      initializer = function (instance, init) {
	        for (var value = init, i = 0; i < ownInitializers.length; i++) value = ownInitializers[i].call(instance, value);
	        return value;
	      };
	    } else {
	      var originalInitializer = initializer;
	      initializer = function (instance, init) {
	        return originalInitializer.call(instance, init);
	      };
	    }
	    ret.push(initializer);
	  }
	  0 !== kind && (1 === kind ? (desc.get = value.get, desc.set = value.set) : 2 === kind ? desc.value = value : 3 === kind ? desc.get = value : 4 === kind && (desc.set = value), isPrivate ? 1 === kind ? (ret.push(function (instance, args) {
	    return value.get.call(instance, args);
	  }), ret.push(function (instance, args) {
	    return value.set.call(instance, args);
	  })) : 2 === kind ? ret.push(value) : ret.push(function (instance, args) {
	    return value.call(instance, args);
	  }) : Object.defineProperty(base, name, desc));
	}
	function old_applyMemberDecs(ret, Class, protoMetadataMap, staticMetadataMap, decInfos) {
	  for (var protoInitializers, staticInitializers, existingProtoNonFields = new Map(), existingStaticNonFields = new Map(), i = 0; i < decInfos.length; i++) {
	    var decInfo = decInfos[i];
	    if (Array.isArray(decInfo)) {
	      var base,
	        metadataMap,
	        initializers,
	        kind = decInfo[1],
	        name = decInfo[2],
	        isPrivate = decInfo.length > 3,
	        isStatic = kind >= 5;
	      if (isStatic ? (base = Class, metadataMap = staticMetadataMap, 0 !== (kind -= 5) && (initializers = staticInitializers = staticInitializers || [])) : (base = Class.prototype, metadataMap = protoMetadataMap, 0 !== kind && (initializers = protoInitializers = protoInitializers || [])), 0 !== kind && !isPrivate) {
	        var existingNonFields = isStatic ? existingStaticNonFields : existingProtoNonFields,
	          existingKind = existingNonFields.get(name) || 0;
	        if (!0 === existingKind || 3 === existingKind && 4 !== kind || 4 === existingKind && 3 !== kind) throw new Error("Attempted to decorate a public method/accessor that has the same name as a previously decorated public method/accessor. This is not currently supported by the decorators plugin. Property name was: " + name);
	        !existingKind && kind > 2 ? existingNonFields.set(name, kind) : existingNonFields.set(name, !0);
	      }
	      old_applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, metadataMap, initializers);
	    }
	  }
	  old_pushInitializers(ret, protoInitializers), old_pushInitializers(ret, staticInitializers);
	}
	function old_pushInitializers(ret, initializers) {
	  initializers && ret.push(function (instance) {
	    for (var i = 0; i < initializers.length; i++) initializers[i].call(instance);
	    return instance;
	  });
	}
	function old_applyClassDecs(ret, targetClass, metadataMap, classDecs) {
	  if (classDecs.length > 0) {
	    for (var initializers = [], newClass = targetClass, name = targetClass.name, i = classDecs.length - 1; i >= 0; i--) {
	      var decoratorFinishedRef = {
	        v: !1
	      };
	      try {
	        var ctx = Object.assign({
	            kind: "class",
	            name: name,
	            addInitializer: old_createAddInitializerMethod(initializers, decoratorFinishedRef)
	          }, old_createMetadataMethodsForProperty(metadataMap, 0, name, decoratorFinishedRef)),
	          nextNewClass = classDecs[i](newClass, ctx);
	      } finally {
	        decoratorFinishedRef.v = !0;
	      }
	      void 0 !== nextNewClass && (old_assertValidReturnValue(10, nextNewClass), newClass = nextNewClass);
	    }
	    ret.push(newClass, function () {
	      for (var i = 0; i < initializers.length; i++) initializers[i].call(newClass);
	    });
	  }
	}
	function _applyDecs(targetClass, memberDecs, classDecs) {
	  var ret = [],
	    staticMetadataMap = {},
	    protoMetadataMap = {};
	  return old_applyMemberDecs(ret, targetClass, protoMetadataMap, staticMetadataMap, memberDecs), old_convertMetadataMapToFinal(targetClass.prototype, protoMetadataMap), old_applyClassDecs(ret, targetClass, staticMetadataMap, classDecs), old_convertMetadataMapToFinal(targetClass, staticMetadataMap), ret;
	}
	function applyDecs2203Factory() {
	  function createAddInitializerMethod(initializers, decoratorFinishedRef) {
	    return function (initializer) {
	      !function (decoratorFinishedRef, fnName) {
	        if (decoratorFinishedRef.v) throw new Error("attempted to call " + fnName + " after decoration was finished");
	      }(decoratorFinishedRef, "addInitializer"), assertCallable(initializer, "An initializer"), initializers.push(initializer);
	    };
	  }
	  function memberDec(dec, name, desc, initializers, kind, isStatic, isPrivate, value) {
	    var kindStr;
	    switch (kind) {
	      case 1:
	        kindStr = "accessor";
	        break;
	      case 2:
	        kindStr = "method";
	        break;
	      case 3:
	        kindStr = "getter";
	        break;
	      case 4:
	        kindStr = "setter";
	        break;
	      default:
	        kindStr = "field";
	    }
	    var get,
	      set,
	      ctx = {
	        kind: kindStr,
	        name: isPrivate ? "#" + name : name,
	        static: isStatic,
	        private: isPrivate
	      },
	      decoratorFinishedRef = {
	        v: !1
	      };
	    0 !== kind && (ctx.addInitializer = createAddInitializerMethod(initializers, decoratorFinishedRef)), 0 === kind ? isPrivate ? (get = desc.get, set = desc.set) : (get = function () {
	      return this[name];
	    }, set = function (v) {
	      this[name] = v;
	    }) : 2 === kind ? get = function () {
	      return desc.value;
	    } : (1 !== kind && 3 !== kind || (get = function () {
	      return desc.get.call(this);
	    }), 1 !== kind && 4 !== kind || (set = function (v) {
	      desc.set.call(this, v);
	    })), ctx.access = get && set ? {
	      get: get,
	      set: set
	    } : get ? {
	      get: get
	    } : {
	      set: set
	    };
	    try {
	      return dec(value, ctx);
	    } finally {
	      decoratorFinishedRef.v = !0;
	    }
	  }
	  function assertCallable(fn, hint) {
	    if ("function" != typeof fn) throw new TypeError(hint + " must be a function");
	  }
	  function assertValidReturnValue(kind, value) {
	    var type = typeof value;
	    if (1 === kind) {
	      if ("object" !== type || null === value) throw new TypeError("accessor decorators must return an object with get, set, or init properties or void 0");
	      void 0 !== value.get && assertCallable(value.get, "accessor.get"), void 0 !== value.set && assertCallable(value.set, "accessor.set"), void 0 !== value.init && assertCallable(value.init, "accessor.init");
	    } else if ("function" !== type) {
	      var hint;
	      throw hint = 0 === kind ? "field" : 10 === kind ? "class" : "method", new TypeError(hint + " decorators must return a function or void 0");
	    }
	  }
	  function applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers) {
	    var desc,
	      init,
	      value,
	      newValue,
	      get,
	      set,
	      decs = decInfo[0];
	    if (isPrivate ? desc = 0 === kind || 1 === kind ? {
	      get: decInfo[3],
	      set: decInfo[4]
	    } : 3 === kind ? {
	      get: decInfo[3]
	    } : 4 === kind ? {
	      set: decInfo[3]
	    } : {
	      value: decInfo[3]
	    } : 0 !== kind && (desc = Object.getOwnPropertyDescriptor(base, name)), 1 === kind ? value = {
	      get: desc.get,
	      set: desc.set
	    } : 2 === kind ? value = desc.value : 3 === kind ? value = desc.get : 4 === kind && (value = desc.set), "function" == typeof decs) void 0 !== (newValue = memberDec(decs, name, desc, initializers, kind, isStatic, isPrivate, value)) && (assertValidReturnValue(kind, newValue), 0 === kind ? init = newValue : 1 === kind ? (init = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	      get: get,
	      set: set
	    }) : value = newValue);else for (var i = decs.length - 1; i >= 0; i--) {
	      var newInit;
	      if (void 0 !== (newValue = memberDec(decs[i], name, desc, initializers, kind, isStatic, isPrivate, value))) assertValidReturnValue(kind, newValue), 0 === kind ? newInit = newValue : 1 === kind ? (newInit = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	        get: get,
	        set: set
	      }) : value = newValue, void 0 !== newInit && (void 0 === init ? init = newInit : "function" == typeof init ? init = [init, newInit] : init.push(newInit));
	    }
	    if (0 === kind || 1 === kind) {
	      if (void 0 === init) init = function (instance, init) {
	        return init;
	      };else if ("function" != typeof init) {
	        var ownInitializers = init;
	        init = function (instance, init) {
	          for (var value = init, i = 0; i < ownInitializers.length; i++) value = ownInitializers[i].call(instance, value);
	          return value;
	        };
	      } else {
	        var originalInitializer = init;
	        init = function (instance, init) {
	          return originalInitializer.call(instance, init);
	        };
	      }
	      ret.push(init);
	    }
	    0 !== kind && (1 === kind ? (desc.get = value.get, desc.set = value.set) : 2 === kind ? desc.value = value : 3 === kind ? desc.get = value : 4 === kind && (desc.set = value), isPrivate ? 1 === kind ? (ret.push(function (instance, args) {
	      return value.get.call(instance, args);
	    }), ret.push(function (instance, args) {
	      return value.set.call(instance, args);
	    })) : 2 === kind ? ret.push(value) : ret.push(function (instance, args) {
	      return value.call(instance, args);
	    }) : Object.defineProperty(base, name, desc));
	  }
	  function pushInitializers(ret, initializers) {
	    initializers && ret.push(function (instance) {
	      for (var i = 0; i < initializers.length; i++) initializers[i].call(instance);
	      return instance;
	    });
	  }
	  return function (targetClass, memberDecs, classDecs) {
	    var ret = [];
	    return function (ret, Class, decInfos) {
	      for (var protoInitializers, staticInitializers, existingProtoNonFields = new Map(), existingStaticNonFields = new Map(), i = 0; i < decInfos.length; i++) {
	        var decInfo = decInfos[i];
	        if (Array.isArray(decInfo)) {
	          var base,
	            initializers,
	            kind = decInfo[1],
	            name = decInfo[2],
	            isPrivate = decInfo.length > 3,
	            isStatic = kind >= 5;
	          if (isStatic ? (base = Class, 0 != (kind -= 5) && (initializers = staticInitializers = staticInitializers || [])) : (base = Class.prototype, 0 !== kind && (initializers = protoInitializers = protoInitializers || [])), 0 !== kind && !isPrivate) {
	            var existingNonFields = isStatic ? existingStaticNonFields : existingProtoNonFields,
	              existingKind = existingNonFields.get(name) || 0;
	            if (!0 === existingKind || 3 === existingKind && 4 !== kind || 4 === existingKind && 3 !== kind) throw new Error("Attempted to decorate a public method/accessor that has the same name as a previously decorated public method/accessor. This is not currently supported by the decorators plugin. Property name was: " + name);
	            !existingKind && kind > 2 ? existingNonFields.set(name, kind) : existingNonFields.set(name, !0);
	          }
	          applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers);
	        }
	      }
	      pushInitializers(ret, protoInitializers), pushInitializers(ret, staticInitializers);
	    }(ret, targetClass, memberDecs), function (ret, targetClass, classDecs) {
	      if (classDecs.length > 0) {
	        for (var initializers = [], newClass = targetClass, name = targetClass.name, i = classDecs.length - 1; i >= 0; i--) {
	          var decoratorFinishedRef = {
	            v: !1
	          };
	          try {
	            var nextNewClass = classDecs[i](newClass, {
	              kind: "class",
	              name: name,
	              addInitializer: createAddInitializerMethod(initializers, decoratorFinishedRef)
	            });
	          } finally {
	            decoratorFinishedRef.v = !0;
	          }
	          void 0 !== nextNewClass && (assertValidReturnValue(10, nextNewClass), newClass = nextNewClass);
	        }
	        ret.push(newClass, function () {
	          for (var i = 0; i < initializers.length; i++) initializers[i].call(newClass);
	        });
	      }
	    }(ret, targetClass, classDecs), ret;
	  };
	}
	var applyDecs2203Impl;
	function _applyDecs2203(targetClass, memberDecs, classDecs) {
	  return (applyDecs2203Impl = applyDecs2203Impl || applyDecs2203Factory())(targetClass, memberDecs, classDecs);
	}
	function applyDecs2203RFactory() {
	  function createAddInitializerMethod(initializers, decoratorFinishedRef) {
	    return function (initializer) {
	      !function (decoratorFinishedRef, fnName) {
	        if (decoratorFinishedRef.v) throw new Error("attempted to call " + fnName + " after decoration was finished");
	      }(decoratorFinishedRef, "addInitializer"), assertCallable(initializer, "An initializer"), initializers.push(initializer);
	    };
	  }
	  function memberDec(dec, name, desc, initializers, kind, isStatic, isPrivate, value) {
	    var kindStr;
	    switch (kind) {
	      case 1:
	        kindStr = "accessor";
	        break;
	      case 2:
	        kindStr = "method";
	        break;
	      case 3:
	        kindStr = "getter";
	        break;
	      case 4:
	        kindStr = "setter";
	        break;
	      default:
	        kindStr = "field";
	    }
	    var get,
	      set,
	      ctx = {
	        kind: kindStr,
	        name: isPrivate ? "#" + name : name,
	        static: isStatic,
	        private: isPrivate
	      },
	      decoratorFinishedRef = {
	        v: !1
	      };
	    0 !== kind && (ctx.addInitializer = createAddInitializerMethod(initializers, decoratorFinishedRef)), 0 === kind ? isPrivate ? (get = desc.get, set = desc.set) : (get = function () {
	      return this[name];
	    }, set = function (v) {
	      this[name] = v;
	    }) : 2 === kind ? get = function () {
	      return desc.value;
	    } : (1 !== kind && 3 !== kind || (get = function () {
	      return desc.get.call(this);
	    }), 1 !== kind && 4 !== kind || (set = function (v) {
	      desc.set.call(this, v);
	    })), ctx.access = get && set ? {
	      get: get,
	      set: set
	    } : get ? {
	      get: get
	    } : {
	      set: set
	    };
	    try {
	      return dec(value, ctx);
	    } finally {
	      decoratorFinishedRef.v = !0;
	    }
	  }
	  function assertCallable(fn, hint) {
	    if ("function" != typeof fn) throw new TypeError(hint + " must be a function");
	  }
	  function assertValidReturnValue(kind, value) {
	    var type = typeof value;
	    if (1 === kind) {
	      if ("object" !== type || null === value) throw new TypeError("accessor decorators must return an object with get, set, or init properties or void 0");
	      void 0 !== value.get && assertCallable(value.get, "accessor.get"), void 0 !== value.set && assertCallable(value.set, "accessor.set"), void 0 !== value.init && assertCallable(value.init, "accessor.init");
	    } else if ("function" !== type) {
	      var hint;
	      throw hint = 0 === kind ? "field" : 10 === kind ? "class" : "method", new TypeError(hint + " decorators must return a function or void 0");
	    }
	  }
	  function applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers) {
	    var desc,
	      init,
	      value,
	      newValue,
	      get,
	      set,
	      decs = decInfo[0];
	    if (isPrivate ? desc = 0 === kind || 1 === kind ? {
	      get: decInfo[3],
	      set: decInfo[4]
	    } : 3 === kind ? {
	      get: decInfo[3]
	    } : 4 === kind ? {
	      set: decInfo[3]
	    } : {
	      value: decInfo[3]
	    } : 0 !== kind && (desc = Object.getOwnPropertyDescriptor(base, name)), 1 === kind ? value = {
	      get: desc.get,
	      set: desc.set
	    } : 2 === kind ? value = desc.value : 3 === kind ? value = desc.get : 4 === kind && (value = desc.set), "function" == typeof decs) void 0 !== (newValue = memberDec(decs, name, desc, initializers, kind, isStatic, isPrivate, value)) && (assertValidReturnValue(kind, newValue), 0 === kind ? init = newValue : 1 === kind ? (init = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	      get: get,
	      set: set
	    }) : value = newValue);else for (var i = decs.length - 1; i >= 0; i--) {
	      var newInit;
	      if (void 0 !== (newValue = memberDec(decs[i], name, desc, initializers, kind, isStatic, isPrivate, value))) assertValidReturnValue(kind, newValue), 0 === kind ? newInit = newValue : 1 === kind ? (newInit = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	        get: get,
	        set: set
	      }) : value = newValue, void 0 !== newInit && (void 0 === init ? init = newInit : "function" == typeof init ? init = [init, newInit] : init.push(newInit));
	    }
	    if (0 === kind || 1 === kind) {
	      if (void 0 === init) init = function (instance, init) {
	        return init;
	      };else if ("function" != typeof init) {
	        var ownInitializers = init;
	        init = function (instance, init) {
	          for (var value = init, i = 0; i < ownInitializers.length; i++) value = ownInitializers[i].call(instance, value);
	          return value;
	        };
	      } else {
	        var originalInitializer = init;
	        init = function (instance, init) {
	          return originalInitializer.call(instance, init);
	        };
	      }
	      ret.push(init);
	    }
	    0 !== kind && (1 === kind ? (desc.get = value.get, desc.set = value.set) : 2 === kind ? desc.value = value : 3 === kind ? desc.get = value : 4 === kind && (desc.set = value), isPrivate ? 1 === kind ? (ret.push(function (instance, args) {
	      return value.get.call(instance, args);
	    }), ret.push(function (instance, args) {
	      return value.set.call(instance, args);
	    })) : 2 === kind ? ret.push(value) : ret.push(function (instance, args) {
	      return value.call(instance, args);
	    }) : Object.defineProperty(base, name, desc));
	  }
	  function applyMemberDecs(Class, decInfos) {
	    for (var protoInitializers, staticInitializers, ret = [], existingProtoNonFields = new Map(), existingStaticNonFields = new Map(), i = 0; i < decInfos.length; i++) {
	      var decInfo = decInfos[i];
	      if (Array.isArray(decInfo)) {
	        var base,
	          initializers,
	          kind = decInfo[1],
	          name = decInfo[2],
	          isPrivate = decInfo.length > 3,
	          isStatic = kind >= 5;
	        if (isStatic ? (base = Class, 0 !== (kind -= 5) && (initializers = staticInitializers = staticInitializers || [])) : (base = Class.prototype, 0 !== kind && (initializers = protoInitializers = protoInitializers || [])), 0 !== kind && !isPrivate) {
	          var existingNonFields = isStatic ? existingStaticNonFields : existingProtoNonFields,
	            existingKind = existingNonFields.get(name) || 0;
	          if (!0 === existingKind || 3 === existingKind && 4 !== kind || 4 === existingKind && 3 !== kind) throw new Error("Attempted to decorate a public method/accessor that has the same name as a previously decorated public method/accessor. This is not currently supported by the decorators plugin. Property name was: " + name);
	          !existingKind && kind > 2 ? existingNonFields.set(name, kind) : existingNonFields.set(name, !0);
	        }
	        applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers);
	      }
	    }
	    return pushInitializers(ret, protoInitializers), pushInitializers(ret, staticInitializers), ret;
	  }
	  function pushInitializers(ret, initializers) {
	    initializers && ret.push(function (instance) {
	      for (var i = 0; i < initializers.length; i++) initializers[i].call(instance);
	      return instance;
	    });
	  }
	  return function (targetClass, memberDecs, classDecs) {
	    return {
	      e: applyMemberDecs(targetClass, memberDecs),
	      get c() {
	        return function (targetClass, classDecs) {
	          if (classDecs.length > 0) {
	            for (var initializers = [], newClass = targetClass, name = targetClass.name, i = classDecs.length - 1; i >= 0; i--) {
	              var decoratorFinishedRef = {
	                v: !1
	              };
	              try {
	                var nextNewClass = classDecs[i](newClass, {
	                  kind: "class",
	                  name: name,
	                  addInitializer: createAddInitializerMethod(initializers, decoratorFinishedRef)
	                });
	              } finally {
	                decoratorFinishedRef.v = !0;
	              }
	              void 0 !== nextNewClass && (assertValidReturnValue(10, nextNewClass), newClass = nextNewClass);
	            }
	            return [newClass, function () {
	              for (var i = 0; i < initializers.length; i++) initializers[i].call(newClass);
	            }];
	          }
	        }(targetClass, classDecs);
	      }
	    };
	  };
	}
	function _applyDecs2203R(targetClass, memberDecs, classDecs) {
	  return (_applyDecs2203R = applyDecs2203RFactory())(targetClass, memberDecs, classDecs);
	}
	function createAddInitializerMethod(initializers, decoratorFinishedRef) {
	  return function (initializer) {
	    assertNotFinished(decoratorFinishedRef, "addInitializer"), assertCallable(initializer, "An initializer"), initializers.push(initializer);
	  };
	}
	function assertInstanceIfPrivate(has, target) {
	  if (!has(target)) throw new TypeError("Attempted to access private element on non-instance");
	}
	function memberDec(dec, name, desc, initializers, kind, isStatic, isPrivate, value, hasPrivateBrand) {
	  var kindStr;
	  switch (kind) {
	    case 1:
	      kindStr = "accessor";
	      break;
	    case 2:
	      kindStr = "method";
	      break;
	    case 3:
	      kindStr = "getter";
	      break;
	    case 4:
	      kindStr = "setter";
	      break;
	    default:
	      kindStr = "field";
	  }
	  var get,
	    set,
	    ctx = {
	      kind: kindStr,
	      name: isPrivate ? "#" + name : name,
	      static: isStatic,
	      private: isPrivate
	    },
	    decoratorFinishedRef = {
	      v: !1
	    };
	  if (0 !== kind && (ctx.addInitializer = createAddInitializerMethod(initializers, decoratorFinishedRef)), isPrivate || 0 !== kind && 2 !== kind) {
	    if (2 === kind) get = function (target) {
	      return assertInstanceIfPrivate(hasPrivateBrand, target), desc.value;
	    };else {
	      var t = 0 === kind || 1 === kind;
	      (t || 3 === kind) && (get = isPrivate ? function (target) {
	        return assertInstanceIfPrivate(hasPrivateBrand, target), desc.get.call(target);
	      } : function (target) {
	        return desc.get.call(target);
	      }), (t || 4 === kind) && (set = isPrivate ? function (target, value) {
	        assertInstanceIfPrivate(hasPrivateBrand, target), desc.set.call(target, value);
	      } : function (target, value) {
	        desc.set.call(target, value);
	      });
	    }
	  } else get = function (target) {
	    return target[name];
	  }, 0 === kind && (set = function (target, v) {
	    target[name] = v;
	  });
	  var has = isPrivate ? hasPrivateBrand.bind() : function (target) {
	    return name in target;
	  };
	  ctx.access = get && set ? {
	    get: get,
	    set: set,
	    has: has
	  } : get ? {
	    get: get,
	    has: has
	  } : {
	    set: set,
	    has: has
	  };
	  try {
	    return dec(value, ctx);
	  } finally {
	    decoratorFinishedRef.v = !0;
	  }
	}
	function assertNotFinished(decoratorFinishedRef, fnName) {
	  if (decoratorFinishedRef.v) throw new Error("attempted to call " + fnName + " after decoration was finished");
	}
	function assertCallable(fn, hint) {
	  if ("function" != typeof fn) throw new TypeError(hint + " must be a function");
	}
	function assertValidReturnValue(kind, value) {
	  var type = typeof value;
	  if (1 === kind) {
	    if ("object" !== type || null === value) throw new TypeError("accessor decorators must return an object with get, set, or init properties or void 0");
	    void 0 !== value.get && assertCallable(value.get, "accessor.get"), void 0 !== value.set && assertCallable(value.set, "accessor.set"), void 0 !== value.init && assertCallable(value.init, "accessor.init");
	  } else if ("function" !== type) {
	    var hint;
	    throw hint = 0 === kind ? "field" : 10 === kind ? "class" : "method", new TypeError(hint + " decorators must return a function or void 0");
	  }
	}
	function curryThis1(fn) {
	  return function () {
	    return fn(this);
	  };
	}
	function curryThis2(fn) {
	  return function (value) {
	    fn(this, value);
	  };
	}
	function applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers, hasPrivateBrand) {
	  var desc,
	    init,
	    value,
	    newValue,
	    get,
	    set,
	    decs = decInfo[0];
	  if (isPrivate ? desc = 0 === kind || 1 === kind ? {
	    get: curryThis1(decInfo[3]),
	    set: curryThis2(decInfo[4])
	  } : 3 === kind ? {
	    get: decInfo[3]
	  } : 4 === kind ? {
	    set: decInfo[3]
	  } : {
	    value: decInfo[3]
	  } : 0 !== kind && (desc = Object.getOwnPropertyDescriptor(base, name)), 1 === kind ? value = {
	    get: desc.get,
	    set: desc.set
	  } : 2 === kind ? value = desc.value : 3 === kind ? value = desc.get : 4 === kind && (value = desc.set), "function" == typeof decs) void 0 !== (newValue = memberDec(decs, name, desc, initializers, kind, isStatic, isPrivate, value, hasPrivateBrand)) && (assertValidReturnValue(kind, newValue), 0 === kind ? init = newValue : 1 === kind ? (init = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	    get: get,
	    set: set
	  }) : value = newValue);else for (var i = decs.length - 1; i >= 0; i--) {
	    var newInit;
	    if (void 0 !== (newValue = memberDec(decs[i], name, desc, initializers, kind, isStatic, isPrivate, value, hasPrivateBrand))) assertValidReturnValue(kind, newValue), 0 === kind ? newInit = newValue : 1 === kind ? (newInit = newValue.init, get = newValue.get || value.get, set = newValue.set || value.set, value = {
	      get: get,
	      set: set
	    }) : value = newValue, void 0 !== newInit && (void 0 === init ? init = newInit : "function" == typeof init ? init = [init, newInit] : init.push(newInit));
	  }
	  if (0 === kind || 1 === kind) {
	    if (void 0 === init) init = function (instance, init) {
	      return init;
	    };else if ("function" != typeof init) {
	      var ownInitializers = init;
	      init = function (instance, init) {
	        for (var value = init, i = 0; i < ownInitializers.length; i++) value = ownInitializers[i].call(instance, value);
	        return value;
	      };
	    } else {
	      var originalInitializer = init;
	      init = function (instance, init) {
	        return originalInitializer.call(instance, init);
	      };
	    }
	    ret.push(init);
	  }
	  0 !== kind && (1 === kind ? (desc.get = value.get, desc.set = value.set) : 2 === kind ? desc.value = value : 3 === kind ? desc.get = value : 4 === kind && (desc.set = value), isPrivate ? 1 === kind ? (ret.push(function (instance, args) {
	    return value.get.call(instance, args);
	  }), ret.push(function (instance, args) {
	    return value.set.call(instance, args);
	  })) : 2 === kind ? ret.push(value) : ret.push(function (instance, args) {
	    return value.call(instance, args);
	  }) : Object.defineProperty(base, name, desc));
	}
	function applyMemberDecs(Class, decInfos, instanceBrand) {
	  for (var protoInitializers, staticInitializers, staticBrand, ret = [], existingProtoNonFields = new Map(), existingStaticNonFields = new Map(), i = 0; i < decInfos.length; i++) {
	    var decInfo = decInfos[i];
	    if (Array.isArray(decInfo)) {
	      var base,
	        initializers,
	        kind = decInfo[1],
	        name = decInfo[2],
	        isPrivate = decInfo.length > 3,
	        isStatic = kind >= 5,
	        hasPrivateBrand = instanceBrand;
	      if (isStatic ? (base = Class, 0 !== (kind -= 5) && (initializers = staticInitializers = staticInitializers || []), isPrivate && !staticBrand && (staticBrand = function (_) {
	        return _checkInRHS(_) === Class;
	      }), hasPrivateBrand = staticBrand) : (base = Class.prototype, 0 !== kind && (initializers = protoInitializers = protoInitializers || [])), 0 !== kind && !isPrivate) {
	        var existingNonFields = isStatic ? existingStaticNonFields : existingProtoNonFields,
	          existingKind = existingNonFields.get(name) || 0;
	        if (!0 === existingKind || 3 === existingKind && 4 !== kind || 4 === existingKind && 3 !== kind) throw new Error("Attempted to decorate a public method/accessor that has the same name as a previously decorated public method/accessor. This is not currently supported by the decorators plugin. Property name was: " + name);
	        !existingKind && kind > 2 ? existingNonFields.set(name, kind) : existingNonFields.set(name, !0);
	      }
	      applyMemberDec(ret, base, decInfo, name, kind, isStatic, isPrivate, initializers, hasPrivateBrand);
	    }
	  }
	  return pushInitializers(ret, protoInitializers), pushInitializers(ret, staticInitializers), ret;
	}
	function pushInitializers(ret, initializers) {
	  initializers && ret.push(function (instance) {
	    for (var i = 0; i < initializers.length; i++) initializers[i].call(instance);
	    return instance;
	  });
	}
	function applyClassDecs(targetClass, classDecs) {
	  if (classDecs.length > 0) {
	    for (var initializers = [], newClass = targetClass, name = targetClass.name, i = classDecs.length - 1; i >= 0; i--) {
	      var decoratorFinishedRef = {
	        v: !1
	      };
	      try {
	        var nextNewClass = classDecs[i](newClass, {
	          kind: "class",
	          name: name,
	          addInitializer: createAddInitializerMethod(initializers, decoratorFinishedRef)
	        });
	      } finally {
	        decoratorFinishedRef.v = !0;
	      }
	      void 0 !== nextNewClass && (assertValidReturnValue(10, nextNewClass), newClass = nextNewClass);
	    }
	    return [newClass, function () {
	      for (var i = 0; i < initializers.length; i++) initializers[i].call(newClass);
	    }];
	  }
	}
	function _applyDecs2301(targetClass, memberDecs, classDecs, instanceBrand) {
	  return {
	    e: applyMemberDecs(targetClass, memberDecs, instanceBrand),
	    get c() {
	      return applyClassDecs(targetClass, classDecs);
	    }
	  };
	}
	function _asyncGeneratorDelegate(inner) {
	  var iter = {},
	    waiting = !1;
	  function pump(key, value) {
	    return waiting = !0, value = new Promise(function (resolve) {
	      resolve(inner[key](value));
	    }), {
	      done: !1,
	      value: new _OverloadYield(value, 1)
	    };
	  }
	  return iter["undefined" != typeof Symbol && Symbol.iterator || "@@iterator"] = function () {
	    return this;
	  }, iter.next = function (value) {
	    return waiting ? (waiting = !1, value) : pump("next", value);
	  }, "function" == typeof inner.throw && (iter.throw = function (value) {
	    if (waiting) throw waiting = !1, value;
	    return pump("throw", value);
	  }), "function" == typeof inner.return && (iter.return = function (value) {
	    return waiting ? (waiting = !1, value) : pump("return", value);
	  }), iter;
	}
	function _asyncIterator(iterable) {
	  var method,
	    async,
	    sync,
	    retry = 2;
	  for ("undefined" != typeof Symbol && (async = Symbol.asyncIterator, sync = Symbol.iterator); retry--;) {
	    if (async && null != (method = iterable[async])) return method.call(iterable);
	    if (sync && null != (method = iterable[sync])) return new AsyncFromSyncIterator(method.call(iterable));
	    async = "@@asyncIterator", sync = "@@iterator";
	  }
	  throw new TypeError("Object is not async iterable");
	}
	function AsyncFromSyncIterator(s) {
	  function AsyncFromSyncIteratorContinuation(r) {
	    if (Object(r) !== r) return Promise.reject(new TypeError(r + " is not an object."));
	    var done = r.done;
	    return Promise.resolve(r.value).then(function (value) {
	      return {
	        value: value,
	        done: done
	      };
	    });
	  }
	  return AsyncFromSyncIterator = function (s) {
	    this.s = s, this.n = s.next;
	  }, AsyncFromSyncIterator.prototype = {
	    s: null,
	    n: null,
	    next: function () {
	      return AsyncFromSyncIteratorContinuation(this.n.apply(this.s, arguments));
	    },
	    return: function (value) {
	      var ret = this.s.return;
	      return void 0 === ret ? Promise.resolve({
	        value: value,
	        done: !0
	      }) : AsyncFromSyncIteratorContinuation(ret.apply(this.s, arguments));
	    },
	    throw: function (value) {
	      var thr = this.s.return;
	      return void 0 === thr ? Promise.reject(value) : AsyncFromSyncIteratorContinuation(thr.apply(this.s, arguments));
	    }
	  }, new AsyncFromSyncIterator(s);
	}
	function _awaitAsyncGenerator(value) {
	  return new _OverloadYield(value, 0);
	}
	function _checkInRHS(value) {
	  if (Object(value) !== value) throw TypeError("right-hand side of 'in' should be an object, got " + (null !== value ? typeof value : "null"));
	  return value;
	}
	function _defineAccessor(type, obj, key, fn) {
	  var desc = {
	    configurable: !0,
	    enumerable: !0
	  };
	  return desc[type] = fn, Object.defineProperty(obj, key, desc);
	}
	function _iterableToArrayLimit(arr, i) {
	  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
	  if (null != _i) {
	    var _s,
	      _e,
	      _x,
	      _r,
	      _arr = [],
	      _n = !0,
	      _d = !1;
	    try {
	      if (_x = (_i = _i.call(arr)).next, 0 === i) {
	        if (Object(_i) !== _i) return;
	        _n = !1;
	      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
	    } catch (err) {
	      _d = !0, _e = err;
	    } finally {
	      try {
	        if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
	      } finally {
	        if (_d) throw _e;
	      }
	    }
	    return _arr;
	  }
	}
	function _iterableToArrayLimitLoose(arr, i) {
	  var _i = arr && ("undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]);
	  if (null != _i) {
	    var _s,
	      _arr = [];
	    for (_i = _i.call(arr); arr.length < i && !(_s = _i.next()).done;) _arr.push(_s.value);
	    return _arr;
	  }
	}
	var REACT_ELEMENT_TYPE;
	function _jsx(type, props, key, children) {
	  REACT_ELEMENT_TYPE || (REACT_ELEMENT_TYPE = "function" == typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103);
	  var defaultProps = type && type.defaultProps,
	    childrenLength = arguments.length - 3;
	  if (props || 0 === childrenLength || (props = {
	    children: void 0
	  }), 1 === childrenLength) props.children = children;else if (childrenLength > 1) {
	    for (var childArray = new Array(childrenLength), i = 0; i < childrenLength; i++) childArray[i] = arguments[i + 3];
	    props.children = childArray;
	  }
	  if (props && defaultProps) for (var propName in defaultProps) void 0 === props[propName] && (props[propName] = defaultProps[propName]);else props || (props = defaultProps || {});
	  return {
	    $$typeof: REACT_ELEMENT_TYPE,
	    type: type,
	    key: void 0 === key ? null : "" + key,
	    ref: null,
	    props: props,
	    _owner: null
	  };
	}
	function ownKeys$5(object, enumerableOnly) {
	  var keys = Object.keys(object);
	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    enumerableOnly && (symbols = symbols.filter(function (sym) {
	      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	    })), keys.push.apply(keys, symbols);
	  }
	  return keys;
	}
	function _objectSpread2(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = null != arguments[i] ? arguments[i] : {};
	    i % 2 ? ownKeys$5(Object(source), !0).forEach(function (key) {
	      _defineProperty(target, key, source[key]);
	    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$5(Object(source)).forEach(function (key) {
	      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	    });
	  }
	  return target;
	}
	function _regeneratorRuntime() {
	  "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
	  _regeneratorRuntime = function () {
	    return exports;
	  };
	  var exports = {},
	    Op = Object.prototype,
	    hasOwn = Op.hasOwnProperty,
	    defineProperty = Object.defineProperty || function (obj, key, desc) {
	      obj[key] = desc.value;
	    },
	    $Symbol = "function" == typeof Symbol ? Symbol : {},
	    iteratorSymbol = $Symbol.iterator || "@@iterator",
	    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
	    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
	  function define(obj, key, value) {
	    return Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: !0,
	      configurable: !0,
	      writable: !0
	    }), obj[key];
	  }
	  try {
	    define({}, "");
	  } catch (err) {
	    define = function (obj, key, value) {
	      return obj[key] = value;
	    };
	  }
	  function wrap(innerFn, outerFn, self, tryLocsList) {
	    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
	      generator = Object.create(protoGenerator.prototype),
	      context = new Context(tryLocsList || []);
	    return defineProperty(generator, "_invoke", {
	      value: makeInvokeMethod(innerFn, self, context)
	    }), generator;
	  }
	  function tryCatch(fn, obj, arg) {
	    try {
	      return {
	        type: "normal",
	        arg: fn.call(obj, arg)
	      };
	    } catch (err) {
	      return {
	        type: "throw",
	        arg: err
	      };
	    }
	  }
	  exports.wrap = wrap;
	  var ContinueSentinel = {};
	  function Generator() {}
	  function GeneratorFunction() {}
	  function GeneratorFunctionPrototype() {}
	  var IteratorPrototype = {};
	  define(IteratorPrototype, iteratorSymbol, function () {
	    return this;
	  });
	  var getProto = Object.getPrototypeOf,
	    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
	  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	  function defineIteratorMethods(prototype) {
	    ["next", "throw", "return"].forEach(function (method) {
	      define(prototype, method, function (arg) {
	        return this._invoke(method, arg);
	      });
	    });
	  }
	  function AsyncIterator(generator, PromiseImpl) {
	    function invoke(method, arg, resolve, reject) {
	      var record = tryCatch(generator[method], generator, arg);
	      if ("throw" !== record.type) {
	        var result = record.arg,
	          value = result.value;
	        return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
	          invoke("next", value, resolve, reject);
	        }, function (err) {
	          invoke("throw", err, resolve, reject);
	        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
	          result.value = unwrapped, resolve(result);
	        }, function (error) {
	          return invoke("throw", error, resolve, reject);
	        });
	      }
	      reject(record.arg);
	    }
	    var previousPromise;
	    defineProperty(this, "_invoke", {
	      value: function (method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }
	        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      }
	    });
	  }
	  function makeInvokeMethod(innerFn, self, context) {
	    var state = "suspendedStart";
	    return function (method, arg) {
	      if ("executing" === state) throw new Error("Generator is already running");
	      if ("completed" === state) {
	        if ("throw" === method) throw arg;
	        return doneResult();
	      }
	      for (context.method = method, context.arg = arg;;) {
	        var delegate = context.delegate;
	        if (delegate) {
	          var delegateResult = maybeInvokeDelegate(delegate, context);
	          if (delegateResult) {
	            if (delegateResult === ContinueSentinel) continue;
	            return delegateResult;
	          }
	        }
	        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
	          if ("suspendedStart" === state) throw state = "completed", context.arg;
	          context.dispatchException(context.arg);
	        } else "return" === context.method && context.abrupt("return", context.arg);
	        state = "executing";
	        var record = tryCatch(innerFn, self, context);
	        if ("normal" === record.type) {
	          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
	          return {
	            value: record.arg,
	            done: context.done
	          };
	        }
	        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
	      }
	    };
	  }
	  function maybeInvokeDelegate(delegate, context) {
	    var methodName = context.method,
	      method = delegate.iterator[methodName];
	    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
	    var record = tryCatch(method, delegate.iterator, context.arg);
	    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
	    var info = record.arg;
	    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
	  }
	  function pushTryEntry(locs) {
	    var entry = {
	      tryLoc: locs[0]
	    };
	    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
	  }
	  function resetTryEntry(entry) {
	    var record = entry.completion || {};
	    record.type = "normal", delete record.arg, entry.completion = record;
	  }
	  function Context(tryLocsList) {
	    this.tryEntries = [{
	      tryLoc: "root"
	    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
	  }
	  function values(iterable) {
	    if (iterable) {
	      var iteratorMethod = iterable[iteratorSymbol];
	      if (iteratorMethod) return iteratorMethod.call(iterable);
	      if ("function" == typeof iterable.next) return iterable;
	      if (!isNaN(iterable.length)) {
	        var i = -1,
	          next = function next() {
	            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
	            return next.value = undefined, next.done = !0, next;
	          };
	        return next.next = next;
	      }
	    }
	    return {
	      next: doneResult
	    };
	  }
	  function doneResult() {
	    return {
	      value: undefined,
	      done: !0
	    };
	  }
	  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
	    value: GeneratorFunctionPrototype,
	    configurable: !0
	  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
	    value: GeneratorFunction,
	    configurable: !0
	  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
	    var ctor = "function" == typeof genFun && genFun.constructor;
	    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
	  }, exports.mark = function (genFun) {
	    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
	  }, exports.awrap = function (arg) {
	    return {
	      __await: arg
	    };
	  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
	    return this;
	  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	    void 0 === PromiseImpl && (PromiseImpl = Promise);
	    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
	      return result.done ? result.value : iter.next();
	    });
	  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
	    return this;
	  }), define(Gp, "toString", function () {
	    return "[object Generator]";
	  }), exports.keys = function (val) {
	    var object = Object(val),
	      keys = [];
	    for (var key in object) keys.push(key);
	    return keys.reverse(), function next() {
	      for (; keys.length;) {
	        var key = keys.pop();
	        if (key in object) return next.value = key, next.done = !1, next;
	      }
	      return next.done = !0, next;
	    };
	  }, exports.values = values, Context.prototype = {
	    constructor: Context,
	    reset: function (skipTempReset) {
	      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
	    },
	    stop: function () {
	      this.done = !0;
	      var rootRecord = this.tryEntries[0].completion;
	      if ("throw" === rootRecord.type) throw rootRecord.arg;
	      return this.rval;
	    },
	    dispatchException: function (exception) {
	      if (this.done) throw exception;
	      var context = this;
	      function handle(loc, caught) {
	        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
	      }
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i],
	          record = entry.completion;
	        if ("root" === entry.tryLoc) return handle("end");
	        if (entry.tryLoc <= this.prev) {
	          var hasCatch = hasOwn.call(entry, "catchLoc"),
	            hasFinally = hasOwn.call(entry, "finallyLoc");
	          if (hasCatch && hasFinally) {
	            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	          } else if (hasCatch) {
	            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	          } else {
	            if (!hasFinally) throw new Error("try statement without catch or finally");
	            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	          }
	        }
	      }
	    },
	    abrupt: function (type, arg) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	          var finallyEntry = entry;
	          break;
	        }
	      }
	      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
	      var record = finallyEntry ? finallyEntry.completion : {};
	      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
	    },
	    complete: function (record, afterLoc) {
	      if ("throw" === record.type) throw record.arg;
	      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
	    },
	    finish: function (finallyLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
	      }
	    },
	    catch: function (tryLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc === tryLoc) {
	          var record = entry.completion;
	          if ("throw" === record.type) {
	            var thrown = record.arg;
	            resetTryEntry(entry);
	          }
	          return thrown;
	        }
	      }
	      throw new Error("illegal catch attempt");
	    },
	    delegateYield: function (iterable, resultName, nextLoc) {
	      return this.delegate = {
	        iterator: values(iterable),
	        resultName: resultName,
	        nextLoc: nextLoc
	      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
	    }
	  }, exports;
	}
	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
	    return typeof obj;
	  } : function (obj) {
	    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	  }, _typeof(obj);
	}
	function _wrapRegExp() {
	  _wrapRegExp = function (re, groups) {
	    return new BabelRegExp(re, void 0, groups);
	  };
	  var _super = RegExp.prototype,
	    _groups = new WeakMap();
	  function BabelRegExp(re, flags, groups) {
	    var _this = new RegExp(re, flags);
	    return _groups.set(_this, groups || _groups.get(re)), _setPrototypeOf(_this, BabelRegExp.prototype);
	  }
	  function buildGroups(result, re) {
	    var g = _groups.get(re);
	    return Object.keys(g).reduce(function (groups, name) {
	      var i = g[name];
	      if ("number" == typeof i) groups[name] = result[i];else {
	        for (var k = 0; void 0 === result[i[k]] && k + 1 < i.length;) k++;
	        groups[name] = result[i[k]];
	      }
	      return groups;
	    }, Object.create(null));
	  }
	  return _inherits(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (str) {
	    var result = _super.exec.call(this, str);
	    if (result) {
	      result.groups = buildGroups(result, this);
	      var indices = result.indices;
	      indices && (indices.groups = buildGroups(indices, this));
	    }
	    return result;
	  }, BabelRegExp.prototype[Symbol.replace] = function (str, substitution) {
	    if ("string" == typeof substitution) {
	      var groups = _groups.get(this);
	      return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) {
	        var group = groups[name];
	        return "$" + (Array.isArray(group) ? group.join("$") : group);
	      }));
	    }
	    if ("function" == typeof substitution) {
	      var _this = this;
	      return _super[Symbol.replace].call(this, str, function () {
	        var args = arguments;
	        return "object" != typeof args[args.length - 1] && (args = [].slice.call(args)).push(buildGroups(args, _this)), substitution.apply(this, args);
	      });
	    }
	    return _super[Symbol.replace].call(this, str, substitution);
	  }, _wrapRegExp.apply(this, arguments);
	}
	function _AwaitValue(value) {
	  this.wrapped = value;
	}
	function _wrapAsyncGenerator(fn) {
	  return function () {
	    return new _AsyncGenerator(fn.apply(this, arguments));
	  };
	}
	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }
	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}
	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	      args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);
	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }
	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }
	      _next(undefined);
	    });
	  };
	}
	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}
	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
	  }
	}
	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  Object.defineProperty(Constructor, "prototype", {
	    writable: false
	  });
	  return Constructor;
	}
	function _defineEnumerableProperties(obj, descs) {
	  for (var key in descs) {
	    var desc = descs[key];
	    desc.configurable = desc.enumerable = true;
	    if ("value" in desc) desc.writable = true;
	    Object.defineProperty(obj, key, desc);
	  }
	  if (Object.getOwnPropertySymbols) {
	    var objectSymbols = Object.getOwnPropertySymbols(descs);
	    for (var i = 0; i < objectSymbols.length; i++) {
	      var sym = objectSymbols[i];
	      var desc = descs[sym];
	      desc.configurable = desc.enumerable = true;
	      if ("value" in desc) desc.writable = true;
	      Object.defineProperty(obj, sym, desc);
	    }
	  }
	  return obj;
	}
	function _defaults(obj, defaults) {
	  var keys = Object.getOwnPropertyNames(defaults);
	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    var value = Object.getOwnPropertyDescriptor(defaults, key);
	    if (value && value.configurable && obj[key] === undefined) {
	      Object.defineProperty(obj, key, value);
	    }
	  }
	  return obj;
	}
	function _defineProperty(obj, key, value) {
	  key = _toPropertyKey(key);
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}
	function _extends() {
	  _extends = Object.assign ? Object.assign.bind() : function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];
	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }
	    return target;
	  };
	  return _extends.apply(this, arguments);
	}
	function _objectSpread(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? Object(arguments[i]) : {};
	    var ownKeys = Object.keys(source);
	    if (typeof Object.getOwnPropertySymbols === 'function') {
	      ownKeys.push.apply(ownKeys, Object.getOwnPropertySymbols(source).filter(function (sym) {
	        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
	      }));
	    }
	    ownKeys.forEach(function (key) {
	      _defineProperty(target, key, source[key]);
	    });
	  }
	  return target;
	}
	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }
	  subClass.prototype = Object.create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  Object.defineProperty(subClass, "prototype", {
	    writable: false
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}
	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  _setPrototypeOf(subClass, superClass);
	}
	function _getPrototypeOf(o) {
	  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
	    return o.__proto__ || Object.getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}
	function _setPrototypeOf(o, p) {
	  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };
	  return _setPrototypeOf(o, p);
	}
	function _isNativeReflectConstruct() {
	  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
	  if (Reflect.construct.sham) return false;
	  if (typeof Proxy === "function") return true;
	  try {
	    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
	    return true;
	  } catch (e) {
	    return false;
	  }
	}
	function _construct(Parent, args, Class) {
	  if (_isNativeReflectConstruct()) {
	    _construct = Reflect.construct.bind();
	  } else {
	    _construct = function _construct(Parent, args, Class) {
	      var a = [null];
	      a.push.apply(a, args);
	      var Constructor = Function.bind.apply(Parent, a);
	      var instance = new Constructor();
	      if (Class) _setPrototypeOf(instance, Class.prototype);
	      return instance;
	    };
	  }
	  return _construct.apply(null, arguments);
	}
	function _isNativeFunction(fn) {
	  return Function.toString.call(fn).indexOf("[native code]") !== -1;
	}
	function _wrapNativeSuper(Class) {
	  var _cache = typeof Map === "function" ? new Map() : undefined;
	  _wrapNativeSuper = function _wrapNativeSuper(Class) {
	    if (Class === null || !_isNativeFunction(Class)) return Class;
	    if (typeof Class !== "function") {
	      throw new TypeError("Super expression must either be null or a function");
	    }
	    if (typeof _cache !== "undefined") {
	      if (_cache.has(Class)) return _cache.get(Class);
	      _cache.set(Class, Wrapper);
	    }
	    function Wrapper() {
	      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
	    }
	    Wrapper.prototype = Object.create(Class.prototype, {
	      constructor: {
	        value: Wrapper,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    return _setPrototypeOf(Wrapper, Class);
	  };
	  return _wrapNativeSuper(Class);
	}
	function _instanceof(left, right) {
	  if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) {
	    return !!right[Symbol.hasInstance](left);
	  } else {
	    return left instanceof right;
	  }
	}
	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : {
	    default: obj
	  };
	}
	function _getRequireWildcardCache(nodeInterop) {
	  if (typeof WeakMap !== "function") return null;
	  var cacheBabelInterop = new WeakMap();
	  var cacheNodeInterop = new WeakMap();
	  return (_getRequireWildcardCache = function (nodeInterop) {
	    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
	  })(nodeInterop);
	}
	function _interopRequireWildcard(obj, nodeInterop) {
	  if (!nodeInterop && obj && obj.__esModule) {
	    return obj;
	  }
	  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
	    return {
	      default: obj
	    };
	  }
	  var cache = _getRequireWildcardCache(nodeInterop);
	  if (cache && cache.has(obj)) {
	    return cache.get(obj);
	  }
	  var newObj = {};
	  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
	  for (var key in obj) {
	    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
	      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
	      if (desc && (desc.get || desc.set)) {
	        Object.defineProperty(newObj, key, desc);
	      } else {
	        newObj[key] = obj[key];
	      }
	    }
	  }
	  newObj.default = obj;
	  if (cache) {
	    cache.set(obj, newObj);
	  }
	  return newObj;
	}
	function _newArrowCheck(innerThis, boundThis) {
	  if (innerThis !== boundThis) {
	    throw new TypeError("Cannot instantiate an arrow function");
	  }
	}
	function _objectDestructuringEmpty(obj) {
	  if (obj == null) throw new TypeError("Cannot destructure " + obj);
	}
	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;
	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }
	  return target;
	}
	function _objectWithoutProperties(source, excluded) {
	  if (source == null) return {};
	  var target = _objectWithoutPropertiesLoose(source, excluded);
	  var key, i;
	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }
	  return target;
	}
	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }
	  return self;
	}
	function _possibleConstructorReturn(self, call) {
	  if (call && (typeof call === "object" || typeof call === "function")) {
	    return call;
	  } else if (call !== void 0) {
	    throw new TypeError("Derived constructors may only return object or undefined");
	  }
	  return _assertThisInitialized(self);
	}
	function _createSuper(Derived) {
	  var hasNativeReflectConstruct = _isNativeReflectConstruct();
	  return function _createSuperInternal() {
	    var Super = _getPrototypeOf(Derived),
	      result;
	    if (hasNativeReflectConstruct) {
	      var NewTarget = _getPrototypeOf(this).constructor;
	      result = Reflect.construct(Super, arguments, NewTarget);
	    } else {
	      result = Super.apply(this, arguments);
	    }
	    return _possibleConstructorReturn(this, result);
	  };
	}
	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = _getPrototypeOf(object);
	    if (object === null) break;
	  }
	  return object;
	}
	function _get() {
	  if (typeof Reflect !== "undefined" && Reflect.get) {
	    _get = Reflect.get.bind();
	  } else {
	    _get = function _get(target, property, receiver) {
	      var base = _superPropBase(target, property);
	      if (!base) return;
	      var desc = Object.getOwnPropertyDescriptor(base, property);
	      if (desc.get) {
	        return desc.get.call(arguments.length < 3 ? target : receiver);
	      }
	      return desc.value;
	    };
	  }
	  return _get.apply(this, arguments);
	}
	function set$4(target, property, value, receiver) {
	  if (typeof Reflect !== "undefined" && Reflect.set) {
	    set$4 = Reflect.set;
	  } else {
	    set$4 = function set(target, property, value, receiver) {
	      var base = _superPropBase(target, property);
	      var desc;
	      if (base) {
	        desc = Object.getOwnPropertyDescriptor(base, property);
	        if (desc.set) {
	          desc.set.call(receiver, value);
	          return true;
	        } else if (!desc.writable) {
	          return false;
	        }
	      }
	      desc = Object.getOwnPropertyDescriptor(receiver, property);
	      if (desc) {
	        if (!desc.writable) {
	          return false;
	        }
	        desc.value = value;
	        Object.defineProperty(receiver, property, desc);
	      } else {
	        _defineProperty(receiver, property, value);
	      }
	      return true;
	    };
	  }
	  return set$4(target, property, value, receiver);
	}
	function _set(target, property, value, receiver, isStrict) {
	  var s = set$4(target, property, value, receiver || target);
	  if (!s && isStrict) {
	    throw new TypeError('failed to set property');
	  }
	  return value;
	}
	function _taggedTemplateLiteral(strings, raw) {
	  if (!raw) {
	    raw = strings.slice(0);
	  }
	  return Object.freeze(Object.defineProperties(strings, {
	    raw: {
	      value: Object.freeze(raw)
	    }
	  }));
	}
	function _taggedTemplateLiteralLoose(strings, raw) {
	  if (!raw) {
	    raw = strings.slice(0);
	  }
	  strings.raw = raw;
	  return strings;
	}
	function _readOnlyError(name) {
	  throw new TypeError("\"" + name + "\" is read-only");
	}
	function _writeOnlyError(name) {
	  throw new TypeError("\"" + name + "\" is write-only");
	}
	function _classNameTDZError(name) {
	  throw new ReferenceError("Class \"" + name + "\" cannot be referenced in computed property keys.");
	}
	function _temporalUndefined() {}
	function _tdz(name) {
	  throw new ReferenceError(name + " is not defined - temporal dead zone");
	}
	function _temporalRef(val, name) {
	  return val === _temporalUndefined ? _tdz(name) : val;
	}
	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
	}
	function _slicedToArrayLoose(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimitLoose(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
	}
	function _toArray(arr) {
	  return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
	}
	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
	}
	function _arrayWithoutHoles(arr) {
	  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
	}
	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}
	function _maybeArrayLike(next, arr, i) {
	  if (arr && !Array.isArray(arr) && typeof arr.length === "number") {
	    var len = arr.length;
	    return _arrayLikeToArray(arr, i !== void 0 && i < len ? i : len);
	  }
	  return next(arr, i);
	}
	function _iterableToArray(iter) {
	  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
	}
	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
	}
	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;
	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
	  return arr2;
	}
	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}
	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}
	function _createForOfIteratorHelper(o, allowArrayLike) {
	  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
	  if (!it) {
	    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
	      if (it) o = it;
	      var i = 0;
	      var F = function () {};
	      return {
	        s: F,
	        n: function () {
	          if (i >= o.length) return {
	            done: true
	          };
	          return {
	            done: false,
	            value: o[i++]
	          };
	        },
	        e: function (e) {
	          throw e;
	        },
	        f: F
	      };
	    }
	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }
	  var normalCompletion = true,
	    didErr = false,
	    err;
	  return {
	    s: function () {
	      it = it.call(o);
	    },
	    n: function () {
	      var step = it.next();
	      normalCompletion = step.done;
	      return step;
	    },
	    e: function (e) {
	      didErr = true;
	      err = e;
	    },
	    f: function () {
	      try {
	        if (!normalCompletion && it.return != null) it.return();
	      } finally {
	        if (didErr) throw err;
	      }
	    }
	  };
	}
	function _createForOfIteratorHelperLoose(o, allowArrayLike) {
	  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
	  if (it) return (it = it.call(o)).next.bind(it);
	  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
	    if (it) o = it;
	    var i = 0;
	    return function () {
	      if (i >= o.length) return {
	        done: true
	      };
	      return {
	        done: false,
	        value: o[i++]
	      };
	    };
	  }
	  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}
	function _skipFirstGeneratorNext(fn) {
	  return function () {
	    var it = fn.apply(this, arguments);
	    it.next();
	    return it;
	  };
	}
	function _toPrimitive(input, hint) {
	  if (typeof input !== "object" || input === null) return input;
	  var prim = input[Symbol.toPrimitive];
	  if (prim !== undefined) {
	    var res = prim.call(input, hint || "default");
	    if (typeof res !== "object") return res;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }
	  return (hint === "string" ? String : Number)(input);
	}
	function _toPropertyKey(arg) {
	  var key = _toPrimitive(arg, "string");
	  return typeof key === "symbol" ? key : String(key);
	}
	function _initializerWarningHelper(descriptor, context) {
	  throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.');
	}
	function _initializerDefineProperty(target, property, descriptor, context) {
	  if (!descriptor) return;
	  Object.defineProperty(target, property, {
	    enumerable: descriptor.enumerable,
	    configurable: descriptor.configurable,
	    writable: descriptor.writable,
	    value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
	  });
	}
	function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	  var desc = {};
	  Object.keys(descriptor).forEach(function (key) {
	    desc[key] = descriptor[key];
	  });
	  desc.enumerable = !!desc.enumerable;
	  desc.configurable = !!desc.configurable;
	  if ('value' in desc || desc.initializer) {
	    desc.writable = true;
	  }
	  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
	    return decorator(target, property, desc) || desc;
	  }, desc);
	  if (context && desc.initializer !== void 0) {
	    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
	    desc.initializer = undefined;
	  }
	  if (desc.initializer === void 0) {
	    Object.defineProperty(target, property, desc);
	    desc = null;
	  }
	  return desc;
	}
	var id$3 = 0;
	function _classPrivateFieldLooseKey(name) {
	  return "__private_" + id$3++ + "_" + name;
	}
	function _classPrivateFieldLooseBase(receiver, privateKey) {
	  if (!Object.prototype.hasOwnProperty.call(receiver, privateKey)) {
	    throw new TypeError("attempted to use private field on non-instance");
	  }
	  return receiver;
	}
	function _classPrivateFieldGet(receiver, privateMap) {
	  var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "get");
	  return _classApplyDescriptorGet(receiver, descriptor);
	}
	function _classPrivateFieldSet(receiver, privateMap, value) {
	  var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "set");
	  _classApplyDescriptorSet(receiver, descriptor, value);
	  return value;
	}
	function _classPrivateFieldDestructureSet(receiver, privateMap) {
	  var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "set");
	  return _classApplyDescriptorDestructureSet(receiver, descriptor);
	}
	function _classExtractFieldDescriptor(receiver, privateMap, action) {
	  if (!privateMap.has(receiver)) {
	    throw new TypeError("attempted to " + action + " private field on non-instance");
	  }
	  return privateMap.get(receiver);
	}
	function _classStaticPrivateFieldSpecGet(receiver, classConstructor, descriptor) {
	  _classCheckPrivateStaticAccess(receiver, classConstructor);
	  _classCheckPrivateStaticFieldDescriptor(descriptor, "get");
	  return _classApplyDescriptorGet(receiver, descriptor);
	}
	function _classStaticPrivateFieldSpecSet(receiver, classConstructor, descriptor, value) {
	  _classCheckPrivateStaticAccess(receiver, classConstructor);
	  _classCheckPrivateStaticFieldDescriptor(descriptor, "set");
	  _classApplyDescriptorSet(receiver, descriptor, value);
	  return value;
	}
	function _classStaticPrivateMethodGet(receiver, classConstructor, method) {
	  _classCheckPrivateStaticAccess(receiver, classConstructor);
	  return method;
	}
	function _classStaticPrivateMethodSet() {
	  throw new TypeError("attempted to set read only static private field");
	}
	function _classApplyDescriptorGet(receiver, descriptor) {
	  if (descriptor.get) {
	    return descriptor.get.call(receiver);
	  }
	  return descriptor.value;
	}
	function _classApplyDescriptorSet(receiver, descriptor, value) {
	  if (descriptor.set) {
	    descriptor.set.call(receiver, value);
	  } else {
	    if (!descriptor.writable) {
	      throw new TypeError("attempted to set read only private field");
	    }
	    descriptor.value = value;
	  }
	}
	function _classApplyDescriptorDestructureSet(receiver, descriptor) {
	  if (descriptor.set) {
	    if (!("__destrObj" in descriptor)) {
	      descriptor.__destrObj = {
	        set value(v) {
	          descriptor.set.call(receiver, v);
	        }
	      };
	    }
	    return descriptor.__destrObj;
	  } else {
	    if (!descriptor.writable) {
	      throw new TypeError("attempted to set read only private field");
	    }
	    return descriptor;
	  }
	}
	function _classStaticPrivateFieldDestructureSet(receiver, classConstructor, descriptor) {
	  _classCheckPrivateStaticAccess(receiver, classConstructor);
	  _classCheckPrivateStaticFieldDescriptor(descriptor, "set");
	  return _classApplyDescriptorDestructureSet(receiver, descriptor);
	}
	function _classCheckPrivateStaticAccess(receiver, classConstructor) {
	  if (receiver !== classConstructor) {
	    throw new TypeError("Private static access of wrong provenance");
	  }
	}
	function _classCheckPrivateStaticFieldDescriptor(descriptor, action) {
	  if (descriptor === undefined) {
	    throw new TypeError("attempted to " + action + " private static field before its declaration");
	  }
	}
	function _decorate(decorators, factory, superClass, mixins) {
	  var api = _getDecoratorsApi();
	  if (mixins) {
	    for (var i = 0; i < mixins.length; i++) {
	      api = mixins[i](api);
	    }
	  }
	  var r = factory(function initialize(O) {
	    api.initializeInstanceElements(O, decorated.elements);
	  }, superClass);
	  var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators);
	  api.initializeClassElements(r.F, decorated.elements);
	  return api.runClassFinishers(r.F, decorated.finishers);
	}
	function _getDecoratorsApi() {
	  _getDecoratorsApi = function () {
	    return api;
	  };
	  var api = {
	    elementsDefinitionOrder: [["method"], ["field"]],
	    initializeInstanceElements: function (O, elements) {
	      ["method", "field"].forEach(function (kind) {
	        elements.forEach(function (element) {
	          if (element.kind === kind && element.placement === "own") {
	            this.defineClassElement(O, element);
	          }
	        }, this);
	      }, this);
	    },
	    initializeClassElements: function (F, elements) {
	      var proto = F.prototype;
	      ["method", "field"].forEach(function (kind) {
	        elements.forEach(function (element) {
	          var placement = element.placement;
	          if (element.kind === kind && (placement === "static" || placement === "prototype")) {
	            var receiver = placement === "static" ? F : proto;
	            this.defineClassElement(receiver, element);
	          }
	        }, this);
	      }, this);
	    },
	    defineClassElement: function (receiver, element) {
	      var descriptor = element.descriptor;
	      if (element.kind === "field") {
	        var initializer = element.initializer;
	        descriptor = {
	          enumerable: descriptor.enumerable,
	          writable: descriptor.writable,
	          configurable: descriptor.configurable,
	          value: initializer === void 0 ? void 0 : initializer.call(receiver)
	        };
	      }
	      Object.defineProperty(receiver, element.key, descriptor);
	    },
	    decorateClass: function (elements, decorators) {
	      var newElements = [];
	      var finishers = [];
	      var placements = {
	        static: [],
	        prototype: [],
	        own: []
	      };
	      elements.forEach(function (element) {
	        this.addElementPlacement(element, placements);
	      }, this);
	      elements.forEach(function (element) {
	        if (!_hasDecorators(element)) return newElements.push(element);
	        var elementFinishersExtras = this.decorateElement(element, placements);
	        newElements.push(elementFinishersExtras.element);
	        newElements.push.apply(newElements, elementFinishersExtras.extras);
	        finishers.push.apply(finishers, elementFinishersExtras.finishers);
	      }, this);
	      if (!decorators) {
	        return {
	          elements: newElements,
	          finishers: finishers
	        };
	      }
	      var result = this.decorateConstructor(newElements, decorators);
	      finishers.push.apply(finishers, result.finishers);
	      result.finishers = finishers;
	      return result;
	    },
	    addElementPlacement: function (element, placements, silent) {
	      var keys = placements[element.placement];
	      if (!silent && keys.indexOf(element.key) !== -1) {
	        throw new TypeError("Duplicated element (" + element.key + ")");
	      }
	      keys.push(element.key);
	    },
	    decorateElement: function (element, placements) {
	      var extras = [];
	      var finishers = [];
	      for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) {
	        var keys = placements[element.placement];
	        keys.splice(keys.indexOf(element.key), 1);
	        var elementObject = this.fromElementDescriptor(element);
	        var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject);
	        element = elementFinisherExtras.element;
	        this.addElementPlacement(element, placements);
	        if (elementFinisherExtras.finisher) {
	          finishers.push(elementFinisherExtras.finisher);
	        }
	        var newExtras = elementFinisherExtras.extras;
	        if (newExtras) {
	          for (var j = 0; j < newExtras.length; j++) {
	            this.addElementPlacement(newExtras[j], placements);
	          }
	          extras.push.apply(extras, newExtras);
	        }
	      }
	      return {
	        element: element,
	        finishers: finishers,
	        extras: extras
	      };
	    },
	    decorateConstructor: function (elements, decorators) {
	      var finishers = [];
	      for (var i = decorators.length - 1; i >= 0; i--) {
	        var obj = this.fromClassDescriptor(elements);
	        var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj);
	        if (elementsAndFinisher.finisher !== undefined) {
	          finishers.push(elementsAndFinisher.finisher);
	        }
	        if (elementsAndFinisher.elements !== undefined) {
	          elements = elementsAndFinisher.elements;
	          for (var j = 0; j < elements.length - 1; j++) {
	            for (var k = j + 1; k < elements.length; k++) {
	              if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) {
	                throw new TypeError("Duplicated element (" + elements[j].key + ")");
	              }
	            }
	          }
	        }
	      }
	      return {
	        elements: elements,
	        finishers: finishers
	      };
	    },
	    fromElementDescriptor: function (element) {
	      var obj = {
	        kind: element.kind,
	        key: element.key,
	        placement: element.placement,
	        descriptor: element.descriptor
	      };
	      var desc = {
	        value: "Descriptor",
	        configurable: true
	      };
	      Object.defineProperty(obj, Symbol.toStringTag, desc);
	      if (element.kind === "field") obj.initializer = element.initializer;
	      return obj;
	    },
	    toElementDescriptors: function (elementObjects) {
	      if (elementObjects === undefined) return;
	      return _toArray(elementObjects).map(function (elementObject) {
	        var element = this.toElementDescriptor(elementObject);
	        this.disallowProperty(elementObject, "finisher", "An element descriptor");
	        this.disallowProperty(elementObject, "extras", "An element descriptor");
	        return element;
	      }, this);
	    },
	    toElementDescriptor: function (elementObject) {
	      var kind = String(elementObject.kind);
	      if (kind !== "method" && kind !== "field") {
	        throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"');
	      }
	      var key = _toPropertyKey(elementObject.key);
	      var placement = String(elementObject.placement);
	      if (placement !== "static" && placement !== "prototype" && placement !== "own") {
	        throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"');
	      }
	      var descriptor = elementObject.descriptor;
	      this.disallowProperty(elementObject, "elements", "An element descriptor");
	      var element = {
	        kind: kind,
	        key: key,
	        placement: placement,
	        descriptor: Object.assign({}, descriptor)
	      };
	      if (kind !== "field") {
	        this.disallowProperty(elementObject, "initializer", "A method descriptor");
	      } else {
	        this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor");
	        this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor");
	        this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor");
	        element.initializer = elementObject.initializer;
	      }
	      return element;
	    },
	    toElementFinisherExtras: function (elementObject) {
	      var element = this.toElementDescriptor(elementObject);
	      var finisher = _optionalCallableProperty(elementObject, "finisher");
	      var extras = this.toElementDescriptors(elementObject.extras);
	      return {
	        element: element,
	        finisher: finisher,
	        extras: extras
	      };
	    },
	    fromClassDescriptor: function (elements) {
	      var obj = {
	        kind: "class",
	        elements: elements.map(this.fromElementDescriptor, this)
	      };
	      var desc = {
	        value: "Descriptor",
	        configurable: true
	      };
	      Object.defineProperty(obj, Symbol.toStringTag, desc);
	      return obj;
	    },
	    toClassDescriptor: function (obj) {
	      var kind = String(obj.kind);
	      if (kind !== "class") {
	        throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"');
	      }
	      this.disallowProperty(obj, "key", "A class descriptor");
	      this.disallowProperty(obj, "placement", "A class descriptor");
	      this.disallowProperty(obj, "descriptor", "A class descriptor");
	      this.disallowProperty(obj, "initializer", "A class descriptor");
	      this.disallowProperty(obj, "extras", "A class descriptor");
	      var finisher = _optionalCallableProperty(obj, "finisher");
	      var elements = this.toElementDescriptors(obj.elements);
	      return {
	        elements: elements,
	        finisher: finisher
	      };
	    },
	    runClassFinishers: function (constructor, finishers) {
	      for (var i = 0; i < finishers.length; i++) {
	        var newConstructor = (0, finishers[i])(constructor);
	        if (newConstructor !== undefined) {
	          if (typeof newConstructor !== "function") {
	            throw new TypeError("Finishers must return a constructor.");
	          }
	          constructor = newConstructor;
	        }
	      }
	      return constructor;
	    },
	    disallowProperty: function (obj, name, objectType) {
	      if (obj[name] !== undefined) {
	        throw new TypeError(objectType + " can't have a ." + name + " property.");
	      }
	    }
	  };
	  return api;
	}
	function _createElementDescriptor(def) {
	  var key = _toPropertyKey(def.key);
	  var descriptor;
	  if (def.kind === "method") {
	    descriptor = {
	      value: def.value,
	      writable: true,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "get") {
	    descriptor = {
	      get: def.value,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "set") {
	    descriptor = {
	      set: def.value,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "field") {
	    descriptor = {
	      configurable: true,
	      writable: true,
	      enumerable: true
	    };
	  }
	  var element = {
	    kind: def.kind === "field" ? "field" : "method",
	    key: key,
	    placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype",
	    descriptor: descriptor
	  };
	  if (def.decorators) element.decorators = def.decorators;
	  if (def.kind === "field") element.initializer = def.value;
	  return element;
	}
	function _coalesceGetterSetter(element, other) {
	  if (element.descriptor.get !== undefined) {
	    other.descriptor.get = element.descriptor.get;
	  } else {
	    other.descriptor.set = element.descriptor.set;
	  }
	}
	function _coalesceClassElements(elements) {
	  var newElements = [];
	  var isSameElement = function (other) {
	    return other.kind === "method" && other.key === element.key && other.placement === element.placement;
	  };
	  for (var i = 0; i < elements.length; i++) {
	    var element = elements[i];
	    var other;
	    if (element.kind === "method" && (other = newElements.find(isSameElement))) {
	      if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) {
	        if (_hasDecorators(element) || _hasDecorators(other)) {
	          throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated.");
	        }
	        other.descriptor = element.descriptor;
	      } else {
	        if (_hasDecorators(element)) {
	          if (_hasDecorators(other)) {
	            throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ").");
	          }
	          other.decorators = element.decorators;
	        }
	        _coalesceGetterSetter(element, other);
	      }
	    } else {
	      newElements.push(element);
	    }
	  }
	  return newElements;
	}
	function _hasDecorators(element) {
	  return element.decorators && element.decorators.length;
	}
	function _isDataDescriptor(desc) {
	  return desc !== undefined && !(desc.value === undefined && desc.writable === undefined);
	}
	function _optionalCallableProperty(obj, name) {
	  var value = obj[name];
	  if (value !== undefined && typeof value !== "function") {
	    throw new TypeError("Expected '" + name + "' to be a function");
	  }
	  return value;
	}
	function _classPrivateMethodGet(receiver, privateSet, fn) {
	  if (!privateSet.has(receiver)) {
	    throw new TypeError("attempted to get private field on non-instance");
	  }
	  return fn;
	}
	function _checkPrivateRedeclaration(obj, privateCollection) {
	  if (privateCollection.has(obj)) {
	    throw new TypeError("Cannot initialize the same private elements twice on an object");
	  }
	}
	function _classPrivateFieldInitSpec(obj, privateMap, value) {
	  _checkPrivateRedeclaration(obj, privateMap);
	  privateMap.set(obj, value);
	}
	function _classPrivateMethodInitSpec(obj, privateSet) {
	  _checkPrivateRedeclaration(obj, privateSet);
	  privateSet.add(obj);
	}
	function _classPrivateMethodSet() {
	  throw new TypeError("attempted to reassign private method");
	}
	function _identity(x) {
	  return x;
	}

	var check = function check(it) {
	  return it && it.Math == Math && it;
	};

	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global$Z =
	// eslint-disable-next-line es/no-global-this -- safe
	check((typeof globalThis === "undefined" ? "undefined" : _typeof(globalThis)) == 'object' && globalThis) || check((typeof window === "undefined" ? "undefined" : _typeof(window)) == 'object' && window) ||
	// eslint-disable-next-line no-restricted-globals -- safe
	check((typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self) || check(_typeof(commonjsGlobal) == 'object' && commonjsGlobal) ||
	// eslint-disable-next-line no-new-func -- fallback
	function () {
	  return this;
	}() || Function('return this')();
	var global$_ = /*@__PURE__*/getDefaultExportFromCjs(global$Z);

	var objectGetOwnPropertyDescriptor = {};

	var fails$1m = function fails(exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};
	var fails$1n = /*@__PURE__*/getDefaultExportFromCjs(fails$1m);

	var fails$1l = fails$1m;

	// Detect IE8's incomplete defineProperty implementation
	var descriptors = !fails$1l(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty({}, 1, {
	    get: function get() {
	      return 7;
	    }
	  })[1] != 7;
	});
	var descriptors$1 = /*@__PURE__*/getDefaultExportFromCjs(descriptors);

	var fails$1k = fails$1m;
	var functionBindNative = !fails$1k(function () {
	  // eslint-disable-next-line es/no-function-prototype-bind -- safe
	  var test = function () {/* empty */}.bind();
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return typeof test != 'function' || test.hasOwnProperty('prototype');
	});
	var functionBindNative$1 = /*@__PURE__*/getDefaultExportFromCjs(functionBindNative);

	var NATIVE_BIND$4 = functionBindNative;
	var call$E = Function.prototype.call;
	var functionCall = NATIVE_BIND$4 ? call$E.bind(call$E) : function () {
	  return call$E.apply(call$E, arguments);
	};
	var functionCall$1 = /*@__PURE__*/getDefaultExportFromCjs(functionCall);

	var objectPropertyIsEnumerable = {};

	'use strict';
	var $propertyIsEnumerable$2 = {}.propertyIsEnumerable;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor$a = Object.getOwnPropertyDescriptor;

	// Nashorn ~ JDK8 bug
	var NASHORN_BUG = getOwnPropertyDescriptor$a && !$propertyIsEnumerable$2.call({
	  1: 2
	}, 1);

	// `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
	var f$8 = objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor$a(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : $propertyIsEnumerable$2;

	var createPropertyDescriptor$c = function createPropertyDescriptor(bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};
	var createPropertyDescriptor$d = /*@__PURE__*/getDefaultExportFromCjs(createPropertyDescriptor$c);

	var NATIVE_BIND$3 = functionBindNative;
	var FunctionPrototype$4 = Function.prototype;
	var call$D = FunctionPrototype$4.call;
	var uncurryThisWithBind = NATIVE_BIND$3 && FunctionPrototype$4.bind.bind(call$D, call$D);
	var functionUncurryThis = NATIVE_BIND$3 ? uncurryThisWithBind : function (fn) {
	  return function () {
	    return call$D.apply(fn, arguments);
	  };
	};
	var functionUncurryThis$1 = /*@__PURE__*/getDefaultExportFromCjs(functionUncurryThis);

	var uncurryThis$1j = functionUncurryThis;
	var toString$A = uncurryThis$1j({}.toString);
	var stringSlice$i = uncurryThis$1j(''.slice);
	var classofRaw$2 = function classofRaw(it) {
	  return stringSlice$i(toString$A(it), 8, -1);
	};
	var classofRaw$3 = /*@__PURE__*/getDefaultExportFromCjs(classofRaw$2);

	var uncurryThis$1i = functionUncurryThis;
	var fails$1j = fails$1m;
	var classof$o = classofRaw$2;
	var $Object$5 = Object;
	var split$7 = uncurryThis$1i(''.split);

	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var indexedObject = fails$1j(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return !$Object$5('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classof$o(it) == 'String' ? split$7(it, '') : $Object$5(it);
	} : $Object$5;
	var indexedObject$1 = /*@__PURE__*/getDefaultExportFromCjs(indexedObject);

	// we can't use just `it == null` since of `document.all` special case
	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
	var isNullOrUndefined$e = function isNullOrUndefined(it) {
	  return it === null || it === undefined;
	};
	var isNullOrUndefined$f = /*@__PURE__*/getDefaultExportFromCjs(isNullOrUndefined$e);

	var isNullOrUndefined$d = isNullOrUndefined$e;
	var $TypeError$p = TypeError;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.es/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible$j = function requireObjectCoercible(it) {
	  if (isNullOrUndefined$d(it)) throw $TypeError$p("Can't call method on " + it);
	  return it;
	};
	var requireObjectCoercible$k = /*@__PURE__*/getDefaultExportFromCjs(requireObjectCoercible$j);

	// toObject with fallback for non-array-like ES3 strings
	var IndexedObject$5 = indexedObject;
	var requireObjectCoercible$i = requireObjectCoercible$j;
	var toIndexedObject$j = function toIndexedObject(it) {
	  return IndexedObject$5(requireObjectCoercible$i(it));
	};
	var toIndexedObject$k = /*@__PURE__*/getDefaultExportFromCjs(toIndexedObject$j);

	var documentAll$2 = (typeof document === "undefined" ? "undefined" : _typeof(document)) == 'object' && document.all;

	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
	// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
	var IS_HTMLDDA = typeof documentAll$2 == 'undefined' && documentAll$2 !== undefined;
	var documentAll_1 = {
	  all: documentAll$2,
	  IS_HTMLDDA: IS_HTMLDDA
	};
	var documentAll$3 = /*@__PURE__*/getDefaultExportFromCjs(documentAll_1);

	var $documentAll$1 = documentAll_1;
	var documentAll$1 = $documentAll$1.all;

	// `IsCallable` abstract operation
	// https://tc39.es/ecma262/#sec-iscallable
	var isCallable$z = $documentAll$1.IS_HTMLDDA ? function (argument) {
	  return typeof argument == 'function' || argument === documentAll$1;
	} : function (argument) {
	  return typeof argument == 'function';
	};
	var isCallable$A = /*@__PURE__*/getDefaultExportFromCjs(isCallable$z);

	var isCallable$y = isCallable$z;
	var $documentAll = documentAll_1;
	var documentAll = $documentAll.all;
	var isObject$z = $documentAll.IS_HTMLDDA ? function (it) {
	  return _typeof(it) == 'object' ? it !== null : isCallable$y(it) || it === documentAll;
	} : function (it) {
	  return _typeof(it) == 'object' ? it !== null : isCallable$y(it);
	};
	var isObject$A = /*@__PURE__*/getDefaultExportFromCjs(isObject$z);

	var global$Y = global$Z;
	var isCallable$x = isCallable$z;
	var aFunction = function aFunction(argument) {
	  return isCallable$x(argument) ? argument : undefined;
	};
	var getBuiltIn$m = function getBuiltIn(namespace, method) {
	  return arguments.length < 2 ? aFunction(global$Y[namespace]) : global$Y[namespace] && global$Y[namespace][method];
	};
	var getBuiltIn$n = /*@__PURE__*/getDefaultExportFromCjs(getBuiltIn$m);

	var uncurryThis$1h = functionUncurryThis;
	var objectIsPrototypeOf = uncurryThis$1h({}.isPrototypeOf);
	var objectIsPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(objectIsPrototypeOf);

	var engineUserAgent = typeof navigator != 'undefined' && String(navigator.userAgent) || '';
	var engineUserAgent$1 = /*@__PURE__*/getDefaultExportFromCjs(engineUserAgent);

	var global$X = global$Z;
	var userAgent$6 = engineUserAgent;
	var process$5 = global$X.process;
	var Deno$1 = global$X.Deno;
	var versions = process$5 && process$5.versions || Deno$1 && Deno$1.version;
	var v8 = versions && versions.v8;
	var match, version$8;
	if (v8) {
	  match = v8.split('.');
	  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
	  // but their correct versions are not interesting for us
	  version$8 = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
	}

	// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
	// so check `userAgent` even if `.v8` exists, but 0
	if (!version$8 && userAgent$6) {
	  match = userAgent$6.match(/Edge\/(\d+)/);
	  if (!match || match[1] >= 74) {
	    match = userAgent$6.match(/Chrome\/(\d+)/);
	    if (match) version$8 = +match[1];
	  }
	}
	var engineV8Version = version$8;
	var engineV8Version$1 = /*@__PURE__*/getDefaultExportFromCjs(engineV8Version);

	/* eslint-disable es/no-symbol -- required for testing */
	var V8_VERSION$3 = engineV8Version;
	var fails$1i = fails$1m;

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
	var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$1i(function () {
	  var symbol = Symbol();
	  // Chrome 38 Symbol has incorrect toString conversion
	  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
	  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
	  // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
	  !Symbol.sham && V8_VERSION$3 && V8_VERSION$3 < 41;
	});
	var symbolConstructorDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(symbolConstructorDetection);

	var NATIVE_SYMBOL$6 = symbolConstructorDetection;
	var useSymbolAsUid = NATIVE_SYMBOL$6 && !Symbol.sham && _typeof(Symbol.iterator) == 'symbol';
	var useSymbolAsUid$1 = /*@__PURE__*/getDefaultExportFromCjs(useSymbolAsUid);

	var getBuiltIn$l = getBuiltIn$m;
	var isCallable$w = isCallable$z;
	var isPrototypeOf$b = objectIsPrototypeOf;
	var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;
	var $Object$4 = Object;
	var isSymbol$7 = USE_SYMBOL_AS_UID$1 ? function (it) {
	  return _typeof(it) == 'symbol';
	} : function (it) {
	  var $Symbol = getBuiltIn$l('Symbol');
	  return isCallable$w($Symbol) && isPrototypeOf$b($Symbol.prototype, $Object$4(it));
	};
	var isSymbol$8 = /*@__PURE__*/getDefaultExportFromCjs(isSymbol$7);

	var $String$7 = String;
	var tryToString$7 = function tryToString(argument) {
	  try {
	    return $String$7(argument);
	  } catch (error) {
	    return 'Object';
	  }
	};
	var tryToString$8 = /*@__PURE__*/getDefaultExportFromCjs(tryToString$7);

	var isCallable$v = isCallable$z;
	var tryToString$6 = tryToString$7;
	var $TypeError$o = TypeError;

	// `Assert: IsCallable(argument) is true`
	var aCallable$l = function aCallable(argument) {
	  if (isCallable$v(argument)) return argument;
	  throw $TypeError$o(tryToString$6(argument) + ' is not a function');
	};
	var aCallable$m = /*@__PURE__*/getDefaultExportFromCjs(aCallable$l);

	var aCallable$k = aCallable$l;
	var isNullOrUndefined$c = isNullOrUndefined$e;

	// `GetMethod` abstract operation
	// https://tc39.es/ecma262/#sec-getmethod
	var getMethod$9 = function getMethod(V, P) {
	  var func = V[P];
	  return isNullOrUndefined$c(func) ? undefined : aCallable$k(func);
	};
	var getMethod$a = /*@__PURE__*/getDefaultExportFromCjs(getMethod$9);

	var call$C = functionCall;
	var isCallable$u = isCallable$z;
	var isObject$y = isObject$z;
	var $TypeError$n = TypeError;

	// `OrdinaryToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-ordinarytoprimitive
	var ordinaryToPrimitive$2 = function ordinaryToPrimitive(input, pref) {
	  var fn, val;
	  if (pref === 'string' && isCallable$u(fn = input.toString) && !isObject$y(val = call$C(fn, input))) return val;
	  if (isCallable$u(fn = input.valueOf) && !isObject$y(val = call$C(fn, input))) return val;
	  if (pref !== 'string' && isCallable$u(fn = input.toString) && !isObject$y(val = call$C(fn, input))) return val;
	  throw $TypeError$n("Can't convert object to primitive value");
	};
	var ordinaryToPrimitive$3 = /*@__PURE__*/getDefaultExportFromCjs(ordinaryToPrimitive$2);

	var shared$a = {exports: {}};

	var isPure = false;
	var isPure$1 = /*@__PURE__*/getDefaultExportFromCjs(isPure);

	var global$W = global$Z;

	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var defineProperty$e = Object.defineProperty;
	var defineGlobalProperty$3 = function defineGlobalProperty(key, value) {
	  try {
	    defineProperty$e(global$W, key, {
	      value: value,
	      configurable: true,
	      writable: true
	    });
	  } catch (error) {
	    global$W[key] = value;
	  }
	  return value;
	};
	var defineGlobalProperty$4 = /*@__PURE__*/getDefaultExportFromCjs(defineGlobalProperty$3);

	var global$V = global$Z;
	var defineGlobalProperty$2 = defineGlobalProperty$3;
	var SHARED = '__core-js_shared__';
	var store$3 = global$V[SHARED] || defineGlobalProperty$2(SHARED, {});
	var sharedStore = store$3;
	var sharedStore$1 = /*@__PURE__*/getDefaultExportFromCjs(sharedStore);

	var shared$8 = shared$a.exports;
	var IS_PURE$k = isPure;
	var store$2 = sharedStore;
	(shared$a.exports = function (key, value) {
	  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
	})('versions', []).push({
	  version: '3.29.1',
	  mode: IS_PURE$k ? 'pure' : 'global',
	  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
	  license: 'https://github.com/zloirock/core-js/blob/v3.29.1/LICENSE',
	  source: 'https://github.com/zloirock/core-js'
	});
	var sharedExports = shared$a.exports;
	var shared$9 = /*@__PURE__*/getDefaultExportFromCjs(sharedExports);

	var requireObjectCoercible$h = requireObjectCoercible$j;
	var $Object$3 = Object;

	// `ToObject` abstract operation
	// https://tc39.es/ecma262/#sec-toobject
	var toObject$t = function toObject(argument) {
	  return $Object$3(requireObjectCoercible$h(argument));
	};
	var toObject$u = /*@__PURE__*/getDefaultExportFromCjs(toObject$t);

	var uncurryThis$1g = functionUncurryThis;
	var toObject$s = toObject$t;
	var hasOwnProperty = uncurryThis$1g({}.hasOwnProperty);

	// `HasOwnProperty` abstract operation
	// https://tc39.es/ecma262/#sec-hasownproperty
	// eslint-disable-next-line es/no-object-hasown -- safe
	var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
	  return hasOwnProperty(toObject$s(it), key);
	};
	var hasOwnProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(hasOwnProperty_1);

	var uncurryThis$1f = functionUncurryThis;
	var id$2 = 0;
	var postfix = Math.random();
	var toString$z = uncurryThis$1f(1.0.toString);
	var uid$6 = function uid(key) {
	  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$z(++id$2 + postfix, 36);
	};
	var uid$7 = /*@__PURE__*/getDefaultExportFromCjs(uid$6);

	var global$U = global$Z;
	var shared$7 = sharedExports;
	var hasOwn$w = hasOwnProperty_1;
	var uid$5 = uid$6;
	var NATIVE_SYMBOL$5 = symbolConstructorDetection;
	var USE_SYMBOL_AS_UID = useSymbolAsUid;
	var _Symbol$2 = global$U.Symbol;
	var WellKnownSymbolsStore$1 = shared$7('wks');
	var createWellKnownSymbol = USE_SYMBOL_AS_UID ? _Symbol$2['for'] || _Symbol$2 : _Symbol$2 && _Symbol$2.withoutSetter || uid$5;
	var wellKnownSymbol$z = function wellKnownSymbol(name) {
	  if (!hasOwn$w(WellKnownSymbolsStore$1, name)) {
	    WellKnownSymbolsStore$1[name] = NATIVE_SYMBOL$5 && hasOwn$w(_Symbol$2, name) ? _Symbol$2[name] : createWellKnownSymbol('Symbol.' + name);
	  }
	  return WellKnownSymbolsStore$1[name];
	};
	var wellKnownSymbol$A = /*@__PURE__*/getDefaultExportFromCjs(wellKnownSymbol$z);

	var call$B = functionCall;
	var isObject$x = isObject$z;
	var isSymbol$6 = isSymbol$7;
	var getMethod$8 = getMethod$9;
	var ordinaryToPrimitive$1 = ordinaryToPrimitive$2;
	var wellKnownSymbol$y = wellKnownSymbol$z;
	var $TypeError$m = TypeError;
	var TO_PRIMITIVE$1 = wellKnownSymbol$y('toPrimitive');

	// `ToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-toprimitive
	var toPrimitive$4 = function toPrimitive(input, pref) {
	  if (!isObject$x(input) || isSymbol$6(input)) return input;
	  var exoticToPrim = getMethod$8(input, TO_PRIMITIVE$1);
	  var result;
	  if (exoticToPrim) {
	    if (pref === undefined) pref = 'default';
	    result = call$B(exoticToPrim, input, pref);
	    if (!isObject$x(result) || isSymbol$6(result)) return result;
	    throw $TypeError$m("Can't convert object to primitive value");
	  }
	  if (pref === undefined) pref = 'number';
	  return ordinaryToPrimitive$1(input, pref);
	};
	var toPrimitive$5 = /*@__PURE__*/getDefaultExportFromCjs(toPrimitive$4);

	var toPrimitive$3 = toPrimitive$4;
	var isSymbol$5 = isSymbol$7;

	// `ToPropertyKey` abstract operation
	// https://tc39.es/ecma262/#sec-topropertykey
	var toPropertyKey$8 = function toPropertyKey(argument) {
	  var key = toPrimitive$3(argument, 'string');
	  return isSymbol$5(key) ? key : key + '';
	};
	var toPropertyKey$9 = /*@__PURE__*/getDefaultExportFromCjs(toPropertyKey$8);

	var global$T = global$Z;
	var isObject$w = isObject$z;
	var document$3 = global$T.document;
	// typeof document.createElement is 'object' in old IE
	var EXISTS$1 = isObject$w(document$3) && isObject$w(document$3.createElement);
	var documentCreateElement$2 = function documentCreateElement(it) {
	  return EXISTS$1 ? document$3.createElement(it) : {};
	};
	var documentCreateElement$3 = /*@__PURE__*/getDefaultExportFromCjs(documentCreateElement$2);

	var DESCRIPTORS$J = descriptors;
	var fails$1h = fails$1m;
	var createElement$1 = documentCreateElement$2;

	// Thanks to IE8 for its funny defineProperty
	var ie8DomDefine = !DESCRIPTORS$J && !fails$1h(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(createElement$1('div'), 'a', {
	    get: function get() {
	      return 7;
	    }
	  }).a != 7;
	});
	var ie8DomDefine$1 = /*@__PURE__*/getDefaultExportFromCjs(ie8DomDefine);

	var DESCRIPTORS$I = descriptors;
	var call$A = functionCall;
	var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
	var createPropertyDescriptor$b = createPropertyDescriptor$c;
	var toIndexedObject$i = toIndexedObject$j;
	var toPropertyKey$7 = toPropertyKey$8;
	var hasOwn$v = hasOwnProperty_1;
	var IE8_DOM_DEFINE$1 = ie8DomDefine;

	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	var f$7 = objectGetOwnPropertyDescriptor.f = DESCRIPTORS$I ? $getOwnPropertyDescriptor$2 : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject$i(O);
	  P = toPropertyKey$7(P);
	  if (IE8_DOM_DEFINE$1) try {
	    return $getOwnPropertyDescriptor$2(O, P);
	  } catch (error) {/* empty */}
	  if (hasOwn$v(O, P)) return createPropertyDescriptor$b(!call$A(propertyIsEnumerableModule$2.f, O, P), O[P]);
	};

	var objectDefineProperty = {};

	var DESCRIPTORS$H = descriptors;
	var fails$1g = fails$1m;

	// V8 ~ Chrome 36-
	// https://bugs.chromium.org/p/v8/issues/detail?id=3334
	var v8PrototypeDefineBug = DESCRIPTORS$H && fails$1g(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(function () {/* empty */}, 'prototype', {
	    value: 42,
	    writable: false
	  }).prototype != 42;
	});
	var v8PrototypeDefineBug$1 = /*@__PURE__*/getDefaultExportFromCjs(v8PrototypeDefineBug);

	var isObject$v = isObject$z;
	var $String$6 = String;
	var $TypeError$l = TypeError;

	// `Assert: Type(argument) is Object`
	var anObject$D = function anObject(argument) {
	  if (isObject$v(argument)) return argument;
	  throw $TypeError$l($String$6(argument) + ' is not an object');
	};
	var anObject$E = /*@__PURE__*/getDefaultExportFromCjs(anObject$D);

	var DESCRIPTORS$G = descriptors;
	var IE8_DOM_DEFINE = ie8DomDefine;
	var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
	var anObject$C = anObject$D;
	var toPropertyKey$6 = toPropertyKey$8;
	var $TypeError$k = TypeError;
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var $defineProperty$1 = Object.defineProperty;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;
	var ENUMERABLE = 'enumerable';
	var CONFIGURABLE$1 = 'configurable';
	var WRITABLE = 'writable';

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	var f$6 = objectDefineProperty.f = DESCRIPTORS$G ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
	  anObject$C(O);
	  P = toPropertyKey$6(P);
	  anObject$C(Attributes);
	  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
	    var current = $getOwnPropertyDescriptor$1(O, P);
	    if (current && current[WRITABLE]) {
	      O[P] = Attributes.value;
	      Attributes = {
	        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
	        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
	        writable: false
	      };
	    }
	  }
	  return $defineProperty$1(O, P, Attributes);
	} : $defineProperty$1 : function defineProperty(O, P, Attributes) {
	  anObject$C(O);
	  P = toPropertyKey$6(P);
	  anObject$C(Attributes);
	  if (IE8_DOM_DEFINE) try {
	    return $defineProperty$1(O, P, Attributes);
	  } catch (error) {/* empty */}
	  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$k('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};

	var DESCRIPTORS$F = descriptors;
	var definePropertyModule$b = objectDefineProperty;
	var createPropertyDescriptor$a = createPropertyDescriptor$c;
	var createNonEnumerableProperty$f = DESCRIPTORS$F ? function (object, key, value) {
	  return definePropertyModule$b.f(object, key, createPropertyDescriptor$a(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};
	var createNonEnumerableProperty$g = /*@__PURE__*/getDefaultExportFromCjs(createNonEnumerableProperty$f);

	var makeBuiltIn$5 = {exports: {}};

	var DESCRIPTORS$E = descriptors;
	var hasOwn$u = hasOwnProperty_1;
	var FunctionPrototype$3 = Function.prototype;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getDescriptor = DESCRIPTORS$E && Object.getOwnPropertyDescriptor;
	var EXISTS = hasOwn$u(FunctionPrototype$3, 'name');
	// additional protection from minified / mangled / dropped function names
	var PROPER = EXISTS && function something() {/* empty */}.name === 'something';
	var CONFIGURABLE = EXISTS && (!DESCRIPTORS$E || DESCRIPTORS$E && getDescriptor(FunctionPrototype$3, 'name').configurable);
	var functionName = {
	  EXISTS: EXISTS,
	  PROPER: PROPER,
	  CONFIGURABLE: CONFIGURABLE
	};
	var functionName$1 = /*@__PURE__*/getDefaultExportFromCjs(functionName);

	var uncurryThis$1e = functionUncurryThis;
	var isCallable$t = isCallable$z;
	var store$1 = sharedStore;
	var functionToString$1 = uncurryThis$1e(Function.toString);

	// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
	if (!isCallable$t(store$1.inspectSource)) {
	  store$1.inspectSource = function (it) {
	    return functionToString$1(it);
	  };
	}
	var inspectSource$3 = store$1.inspectSource;
	var inspectSource$4 = /*@__PURE__*/getDefaultExportFromCjs(inspectSource$3);

	var global$S = global$Z;
	var isCallable$s = isCallable$z;
	var WeakMap$2 = global$S.WeakMap;
	var weakMapBasicDetection = isCallable$s(WeakMap$2) && /native code/.test(String(WeakMap$2));
	var weakMapBasicDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(weakMapBasicDetection);

	var shared$6 = sharedExports;
	var uid$4 = uid$6;
	var keys$2 = shared$6('keys');
	var sharedKey$4 = function sharedKey(key) {
	  return keys$2[key] || (keys$2[key] = uid$4(key));
	};
	var sharedKey$5 = /*@__PURE__*/getDefaultExportFromCjs(sharedKey$4);

	var hiddenKeys$6 = {};
	var hiddenKeys$7 = /*@__PURE__*/getDefaultExportFromCjs(hiddenKeys$6);

	var NATIVE_WEAK_MAP$1 = weakMapBasicDetection;
	var global$R = global$Z;
	var isObject$u = isObject$z;
	var createNonEnumerableProperty$e = createNonEnumerableProperty$f;
	var hasOwn$t = hasOwnProperty_1;
	var shared$5 = sharedStore;
	var sharedKey$3 = sharedKey$4;
	var hiddenKeys$5 = hiddenKeys$6;
	var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
	var TypeError$8 = global$R.TypeError;
	var WeakMap$1 = global$R.WeakMap;
	var set$3, get$4, has;
	var enforce = function enforce(it) {
	  return has(it) ? get$4(it) : set$3(it, {});
	};
	var getterFor$1 = function getterFor(TYPE) {
	  return function (it) {
	    var state;
	    if (!isObject$u(it) || (state = get$4(it)).type !== TYPE) {
	      throw TypeError$8('Incompatible receiver, ' + TYPE + ' required');
	    }
	    return state;
	  };
	};
	if (NATIVE_WEAK_MAP$1 || shared$5.state) {
	  var store = shared$5.state || (shared$5.state = new WeakMap$1());
	  /* eslint-disable no-self-assign -- prototype methods protection */
	  store.get = store.get;
	  store.has = store.has;
	  store.set = store.set;
	  /* eslint-enable no-self-assign -- prototype methods protection */
	  set$3 = function set(it, metadata) {
	    if (store.has(it)) throw TypeError$8(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    store.set(it, metadata);
	    return metadata;
	  };
	  get$4 = function get(it) {
	    return store.get(it) || {};
	  };
	  has = function has(it) {
	    return store.has(it);
	  };
	} else {
	  var STATE = sharedKey$3('state');
	  hiddenKeys$5[STATE] = true;
	  set$3 = function set(it, metadata) {
	    if (hasOwn$t(it, STATE)) throw TypeError$8(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    createNonEnumerableProperty$e(it, STATE, metadata);
	    return metadata;
	  };
	  get$4 = function get(it) {
	    return hasOwn$t(it, STATE) ? it[STATE] : {};
	  };
	  has = function has(it) {
	    return hasOwn$t(it, STATE);
	  };
	}
	var internalState = {
	  set: set$3,
	  get: get$4,
	  has: has,
	  enforce: enforce,
	  getterFor: getterFor$1
	};
	var internalState$1 = /*@__PURE__*/getDefaultExportFromCjs(internalState);

	var makeBuiltIn_1 = makeBuiltIn$5.exports;
	var uncurryThis$1d = functionUncurryThis;
	var fails$1f = fails$1m;
	var isCallable$r = isCallable$z;
	var hasOwn$s = hasOwnProperty_1;
	var DESCRIPTORS$D = descriptors;
	var CONFIGURABLE_FUNCTION_NAME$2 = functionName.CONFIGURABLE;
	var inspectSource$2 = inspectSource$3;
	var InternalStateModule$d = internalState;
	var enforceInternalState$4 = InternalStateModule$d.enforce;
	var getInternalState$a = InternalStateModule$d.get;
	var $String$5 = String;
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var defineProperty$d = Object.defineProperty;
	var stringSlice$h = uncurryThis$1d(''.slice);
	var replace$d = uncurryThis$1d(''.replace);
	var join$7 = uncurryThis$1d([].join);
	var CONFIGURABLE_LENGTH = DESCRIPTORS$D && !fails$1f(function () {
	  return defineProperty$d(function () {/* empty */}, 'length', {
	    value: 8
	  }).length !== 8;
	});
	var TEMPLATE = String(String).split('String');
	var makeBuiltIn$3 = makeBuiltIn$5.exports = function (value, name, options) {
	  if (stringSlice$h($String$5(name), 0, 7) === 'Symbol(') {
	    name = '[' + replace$d($String$5(name), /^Symbol\(([^)]*)\)/, '$1') + ']';
	  }
	  if (options && options.getter) name = 'get ' + name;
	  if (options && options.setter) name = 'set ' + name;
	  if (!hasOwn$s(value, 'name') || CONFIGURABLE_FUNCTION_NAME$2 && value.name !== name) {
	    if (DESCRIPTORS$D) defineProperty$d(value, 'name', {
	      value: name,
	      configurable: true
	    });else value.name = name;
	  }
	  if (CONFIGURABLE_LENGTH && options && hasOwn$s(options, 'arity') && value.length !== options.arity) {
	    defineProperty$d(value, 'length', {
	      value: options.arity
	    });
	  }
	  try {
	    if (options && hasOwn$s(options, 'constructor') && options.constructor) {
	      if (DESCRIPTORS$D) defineProperty$d(value, 'prototype', {
	        writable: false
	      });
	      // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
	    } else if (value.prototype) value.prototype = undefined;
	  } catch (error) {/* empty */}
	  var state = enforceInternalState$4(value);
	  if (!hasOwn$s(state, 'source')) {
	    state.source = join$7(TEMPLATE, typeof name == 'string' ? name : '');
	  }
	  return value;
	};

	// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
	// eslint-disable-next-line no-extend-native -- required
	Function.prototype.toString = makeBuiltIn$3(function toString() {
	  return isCallable$r(this) && getInternalState$a(this).source || inspectSource$2(this);
	}, 'toString');
	var makeBuiltInExports = makeBuiltIn$5.exports;
	var makeBuiltIn$4 = /*@__PURE__*/getDefaultExportFromCjs(makeBuiltInExports);

	var isCallable$q = isCallable$z;
	var definePropertyModule$a = objectDefineProperty;
	var makeBuiltIn$2 = makeBuiltInExports;
	var defineGlobalProperty$1 = defineGlobalProperty$3;
	var defineBuiltIn$m = function defineBuiltIn(O, key, value, options) {
	  if (!options) options = {};
	  var simple = options.enumerable;
	  var name = options.name !== undefined ? options.name : key;
	  if (isCallable$q(value)) makeBuiltIn$2(value, name, options);
	  if (options.global) {
	    if (simple) O[key] = value;else defineGlobalProperty$1(key, value);
	  } else {
	    try {
	      if (!options.unsafe) delete O[key];else if (O[key]) simple = true;
	    } catch (error) {/* empty */}
	    if (simple) O[key] = value;else definePropertyModule$a.f(O, key, {
	      value: value,
	      enumerable: false,
	      configurable: !options.nonConfigurable,
	      writable: !options.nonWritable
	    });
	  }
	  return O;
	};
	var defineBuiltIn$n = /*@__PURE__*/getDefaultExportFromCjs(defineBuiltIn$m);

	var objectGetOwnPropertyNames = {};

	var ceil$4 = Math.ceil;
	var floor$d = Math.floor;

	// `Math.trunc` method
	// https://tc39.es/ecma262/#sec-math.trunc
	// eslint-disable-next-line es/no-math-trunc -- safe
	var mathTrunc = Math.trunc || function trunc(x) {
	  var n = +x;
	  return (n > 0 ? floor$d : ceil$4)(n);
	};
	var mathTrunc$1 = /*@__PURE__*/getDefaultExportFromCjs(mathTrunc);

	var trunc$1 = mathTrunc;

	// `ToIntegerOrInfinity` abstract operation
	// https://tc39.es/ecma262/#sec-tointegerorinfinity
	var toIntegerOrInfinity$l = function toIntegerOrInfinity(argument) {
	  var number = +argument;
	  // eslint-disable-next-line no-self-compare -- NaN check
	  return number !== number || number === 0 ? 0 : trunc$1(number);
	};
	var toIntegerOrInfinity$m = /*@__PURE__*/getDefaultExportFromCjs(toIntegerOrInfinity$l);

	var toIntegerOrInfinity$k = toIntegerOrInfinity$l;
	var max$b = Math.max;
	var min$e = Math.min;

	// Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
	var toAbsoluteIndex$a = function toAbsoluteIndex(index, length) {
	  var integer = toIntegerOrInfinity$k(index);
	  return integer < 0 ? max$b(integer + length, 0) : min$e(integer, length);
	};
	var toAbsoluteIndex$b = /*@__PURE__*/getDefaultExportFromCjs(toAbsoluteIndex$a);

	var toIntegerOrInfinity$j = toIntegerOrInfinity$l;
	var min$d = Math.min;

	// `ToLength` abstract operation
	// https://tc39.es/ecma262/#sec-tolength
	var toLength$d = function toLength(argument) {
	  return argument > 0 ? min$d(toIntegerOrInfinity$j(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var toLength$e = /*@__PURE__*/getDefaultExportFromCjs(toLength$d);

	var toLength$c = toLength$d;

	// `LengthOfArrayLike` abstract operation
	// https://tc39.es/ecma262/#sec-lengthofarraylike
	var lengthOfArrayLike$t = function lengthOfArrayLike(obj) {
	  return toLength$c(obj.length);
	};
	var lengthOfArrayLike$u = /*@__PURE__*/getDefaultExportFromCjs(lengthOfArrayLike$t);

	var toIndexedObject$h = toIndexedObject$j;
	var toAbsoluteIndex$9 = toAbsoluteIndex$a;
	var lengthOfArrayLike$s = lengthOfArrayLike$t;

	// `Array.prototype.{ indexOf, includes }` methods implementation
	var createMethod$7 = function createMethod(IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject$h($this);
	    var length = lengthOfArrayLike$s(O);
	    var index = toAbsoluteIndex$9(fromIndex, length);
	    var value;
	    // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++];
	      // eslint-disable-next-line no-self-compare -- NaN check
	      if (value != value) return true;
	      // Array#indexOf ignores holes, Array#includes - not
	    } else for (; length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    }
	    return !IS_INCLUDES && -1;
	  };
	};
	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.es/ecma262/#sec-array.prototype.includes
	  includes: createMethod$7(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.es/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod$7(false)
	};
	var arrayIncludes$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayIncludes);

	var uncurryThis$1c = functionUncurryThis;
	var hasOwn$r = hasOwnProperty_1;
	var toIndexedObject$g = toIndexedObject$j;
	var indexOf$2 = arrayIncludes.indexOf;
	var hiddenKeys$4 = hiddenKeys$6;
	var push$e = uncurryThis$1c([].push);
	var objectKeysInternal = function objectKeysInternal(object, names) {
	  var O = toIndexedObject$g(object);
	  var i = 0;
	  var result = [];
	  var key;
	  for (key in O) !hasOwn$r(hiddenKeys$4, key) && hasOwn$r(O, key) && push$e(result, key);
	  // Don't enum bug & hidden keys
	  while (names.length > i) if (hasOwn$r(O, key = names[i++])) {
	    ~indexOf$2(result, key) || push$e(result, key);
	  }
	  return result;
	};
	var objectKeysInternal$1 = /*@__PURE__*/getDefaultExportFromCjs(objectKeysInternal);

	// IE8- don't enum bug keys
	var enumBugKeys$3 = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];
	var enumBugKeys$4 = /*@__PURE__*/getDefaultExportFromCjs(enumBugKeys$3);

	var internalObjectKeys$1 = objectKeysInternal;
	var enumBugKeys$2 = enumBugKeys$3;
	var hiddenKeys$3 = enumBugKeys$2.concat('length', 'prototype');

	// `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	// eslint-disable-next-line es/no-object-getownpropertynames -- safe
	var f$5 = objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return internalObjectKeys$1(O, hiddenKeys$3);
	};

	var objectGetOwnPropertySymbols = {};

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
	var f$4 = objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

	var getBuiltIn$k = getBuiltIn$m;
	var uncurryThis$1b = functionUncurryThis;
	var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
	var getOwnPropertySymbolsModule$3 = objectGetOwnPropertySymbols;
	var anObject$B = anObject$D;
	var concat$6 = uncurryThis$1b([].concat);

	// all object keys, includes non-enumerable and symbols
	var ownKeys$3 = getBuiltIn$k('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = getOwnPropertyNamesModule$2.f(anObject$B(it));
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule$3.f;
	  return getOwnPropertySymbols ? concat$6(keys, getOwnPropertySymbols(it)) : keys;
	};
	var ownKeys$4 = /*@__PURE__*/getDefaultExportFromCjs(ownKeys$3);

	var hasOwn$q = hasOwnProperty_1;
	var ownKeys$2 = ownKeys$3;
	var getOwnPropertyDescriptorModule$6 = objectGetOwnPropertyDescriptor;
	var definePropertyModule$9 = objectDefineProperty;
	var copyConstructorProperties$5 = function copyConstructorProperties(target, source, exceptions) {
	  var keys = ownKeys$2(source);
	  var defineProperty = definePropertyModule$9.f;
	  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$6.f;
	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    if (!hasOwn$q(target, key) && !(exceptions && hasOwn$q(exceptions, key))) {
	      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	    }
	  }
	};
	var copyConstructorProperties$6 = /*@__PURE__*/getDefaultExportFromCjs(copyConstructorProperties$5);

	var fails$1e = fails$1m;
	var isCallable$p = isCallable$z;
	var replacement = /#|\.prototype\./;
	var isForced$5 = function isForced(feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true : value == NATIVE ? false : isCallable$p(detection) ? fails$1e(detection) : !!detection;
	};
	var normalize = isForced$5.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};
	var data = isForced$5.data = {};
	var NATIVE = isForced$5.NATIVE = 'N';
	var POLYFILL = isForced$5.POLYFILL = 'P';
	var isForced_1 = isForced$5;
	var isForced$6 = /*@__PURE__*/getDefaultExportFromCjs(isForced_1);

	var global$Q = global$Z;
	var getOwnPropertyDescriptor$9 = objectGetOwnPropertyDescriptor.f;
	var createNonEnumerableProperty$d = createNonEnumerableProperty$f;
	var defineBuiltIn$l = defineBuiltIn$m;
	var defineGlobalProperty = defineGlobalProperty$3;
	var copyConstructorProperties$4 = copyConstructorProperties$5;
	var isForced$4 = isForced_1;

	/*
	  options.target         - name of the target object
	  options.global         - target is the global object
	  options.stat           - export as static methods of target
	  options.proto          - export as prototype methods of target
	  options.real           - real prototype method for the `pure` version
	  options.forced         - export even if the native feature is available
	  options.bind           - bind methods to the target, required for the `pure` version
	  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
	  options.sham           - add a flag to not completely full polyfills
	  options.enumerable     - export as enumerable property
	  options.dontCallGetSet - prevent calling a getter on target
	  options.name           - the .name of the function if it does not match the key
	*/
	var _export = function _export(options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
	  if (GLOBAL) {
	    target = global$Q;
	  } else if (STATIC) {
	    target = global$Q[TARGET] || defineGlobalProperty(TARGET, {});
	  } else {
	    target = (global$Q[TARGET] || {}).prototype;
	  }
	  if (target) for (key in source) {
	    sourceProperty = source[key];
	    if (options.dontCallGetSet) {
	      descriptor = getOwnPropertyDescriptor$9(target, key);
	      targetProperty = descriptor && descriptor.value;
	    } else targetProperty = target[key];
	    FORCED = isForced$4(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
	    // contained in target
	    if (!FORCED && targetProperty !== undefined) {
	      if (_typeof(sourceProperty) == _typeof(targetProperty)) continue;
	      copyConstructorProperties$4(sourceProperty, targetProperty);
	    }
	    // add a flag to not completely full polyfills
	    if (options.sham || targetProperty && targetProperty.sham) {
	      createNonEnumerableProperty$d(sourceProperty, 'sham', true);
	    }
	    defineBuiltIn$l(target, key, sourceProperty, options);
	  }
	};
	var _export$1 = /*@__PURE__*/getDefaultExportFromCjs(_export);

	var wellKnownSymbol$x = wellKnownSymbol$z;
	var TO_STRING_TAG$5 = wellKnownSymbol$x('toStringTag');
	var test$2 = {};
	test$2[TO_STRING_TAG$5] = 'z';
	var toStringTagSupport = String(test$2) === '[object z]';
	var toStringTagSupport$1 = /*@__PURE__*/getDefaultExportFromCjs(toStringTagSupport);

	var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
	var isCallable$o = isCallable$z;
	var classofRaw$1 = classofRaw$2;
	var wellKnownSymbol$w = wellKnownSymbol$z;
	var TO_STRING_TAG$4 = wellKnownSymbol$w('toStringTag');
	var $Object$2 = Object;

	// ES3 wrong here
	var CORRECT_ARGUMENTS = classofRaw$1(function () {
	  return arguments;
	}()) == 'Arguments';

	// fallback for IE11 Script Access Denied error
	var tryGet = function tryGet(it, key) {
	  try {
	    return it[key];
	  } catch (error) {/* empty */}
	};

	// getting tag from ES6+ `Object.prototype.toString`
	var classof$m = TO_STRING_TAG_SUPPORT$2 ? classofRaw$1 : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	  // @@toStringTag case
	  : typeof (tag = tryGet(O = $Object$2(it), TO_STRING_TAG$4)) == 'string' ? tag
	  // builtinTag case
	  : CORRECT_ARGUMENTS ? classofRaw$1(O)
	  // ES3 arguments fallback
	  : (result = classofRaw$1(O)) == 'Object' && isCallable$o(O.callee) ? 'Arguments' : result;
	};
	var classof$n = /*@__PURE__*/getDefaultExportFromCjs(classof$m);

	var classof$l = classof$m;
	var $String$4 = String;
	var toString$x = function toString(argument) {
	  if (classof$l(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
	  return $String$4(argument);
	};
	var toString$y = /*@__PURE__*/getDefaultExportFromCjs(toString$x);

	var objectDefineProperties = {};

	var internalObjectKeys = objectKeysInternal;
	var enumBugKeys$1 = enumBugKeys$3;

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	// eslint-disable-next-line es/no-object-keys -- safe
	var objectKeys$5 = Object.keys || function keys(O) {
	  return internalObjectKeys(O, enumBugKeys$1);
	};
	var objectKeys$6 = /*@__PURE__*/getDefaultExportFromCjs(objectKeys$5);

	var DESCRIPTORS$C = descriptors;
	var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
	var definePropertyModule$8 = objectDefineProperty;
	var anObject$A = anObject$D;
	var toIndexedObject$f = toIndexedObject$j;
	var objectKeys$4 = objectKeys$5;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	var f$3 = objectDefineProperties.f = DESCRIPTORS$C && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject$A(O);
	  var props = toIndexedObject$f(Properties);
	  var keys = objectKeys$4(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;
	  while (length > index) definePropertyModule$8.f(O, key = keys[index++], props[key]);
	  return O;
	};

	var getBuiltIn$j = getBuiltIn$m;
	var html$2 = getBuiltIn$j('document', 'documentElement');
	var html$3 = /*@__PURE__*/getDefaultExportFromCjs(html$2);

	/* global ActiveXObject -- old IE, WSH */
	var anObject$z = anObject$D;
	var definePropertiesModule$1 = objectDefineProperties;
	var enumBugKeys = enumBugKeys$3;
	var hiddenKeys$2 = hiddenKeys$6;
	var html$1 = html$2;
	var documentCreateElement$1 = documentCreateElement$2;
	var sharedKey$2 = sharedKey$4;
	var GT = '>';
	var LT = '<';
	var PROTOTYPE$2 = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO$1 = sharedKey$2('IE_PROTO');
	var EmptyConstructor = function EmptyConstructor() {/* empty */};
	var scriptTag = function scriptTag(content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	};

	// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
	var NullProtoObjectViaActiveX = function NullProtoObjectViaActiveX(activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak
	  return temp;
	};

	// Create object with fake `null` prototype: use iframe Object with cleared prototype
	var NullProtoObjectViaIFrame = function NullProtoObjectViaIFrame() {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement$1('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html$1.appendChild(iframe);
	  // https://github.com/zloirock/core-js/issues/475
	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	};

	// Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug
	var activeXDocument;
	var _NullProtoObject = function NullProtoObject() {
	  try {
	    activeXDocument = new ActiveXObject('htmlfile');
	  } catch (error) {/* ignore */}
	  _NullProtoObject = typeof document != 'undefined' ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) // old IE
	  : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument); // WSH
	  var length = enumBugKeys.length;
	  while (length--) delete _NullProtoObject[PROTOTYPE$2][enumBugKeys[length]];
	  return _NullProtoObject();
	};
	hiddenKeys$2[IE_PROTO$1] = true;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	// eslint-disable-next-line es/no-object-create -- safe
	var objectCreate = Object.create || function create(O, Properties) {
	  var result;
	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE$2] = anObject$z(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE$2] = null;
	    // add "__proto__" for Object.getPrototypeOf polyfill
	    result[IE_PROTO$1] = O;
	  } else result = _NullProtoObject();
	  return Properties === undefined ? result : definePropertiesModule$1.f(result, Properties);
	};
	var objectCreate$1 = /*@__PURE__*/getDefaultExportFromCjs(objectCreate);

	var objectGetOwnPropertyNamesExternal = {};

	'use strict';
	var toPropertyKey$5 = toPropertyKey$8;
	var definePropertyModule$7 = objectDefineProperty;
	var createPropertyDescriptor$9 = createPropertyDescriptor$c;
	var createProperty$9 = function createProperty(object, key, value) {
	  var propertyKey = toPropertyKey$5(key);
	  if (propertyKey in object) definePropertyModule$7.f(object, propertyKey, createPropertyDescriptor$9(0, value));else object[propertyKey] = value;
	};
	var createProperty$a = /*@__PURE__*/getDefaultExportFromCjs(createProperty$9);

	var toAbsoluteIndex$8 = toAbsoluteIndex$a;
	var lengthOfArrayLike$r = lengthOfArrayLike$t;
	var createProperty$8 = createProperty$9;
	var $Array$9 = Array;
	var max$a = Math.max;
	var arraySliceSimple = function arraySliceSimple(O, start, end) {
	  var length = lengthOfArrayLike$r(O);
	  var k = toAbsoluteIndex$8(start, length);
	  var fin = toAbsoluteIndex$8(end === undefined ? length : end, length);
	  var result = $Array$9(max$a(fin - k, 0));
	  for (var n = 0; k < fin; k++, n++) createProperty$8(result, n, O[k]);
	  result.length = n;
	  return result;
	};
	var arraySliceSimple$1 = /*@__PURE__*/getDefaultExportFromCjs(arraySliceSimple);

	var classof$k = classofRaw$2;
	var toIndexedObject$e = toIndexedObject$j;
	var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var arraySlice$c = arraySliceSimple;
	var windowNames = (typeof window === "undefined" ? "undefined" : _typeof(window)) == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
	var getWindowNames = function getWindowNames(it) {
	  try {
	    return $getOwnPropertyNames$1(it);
	  } catch (error) {
	    return arraySlice$c(windowNames);
	  }
	};

	// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
	var f$2 = objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
	  return windowNames && classof$k(it) == 'Window' ? getWindowNames(it) : $getOwnPropertyNames$1(toIndexedObject$e(it));
	};

	var makeBuiltIn$1 = makeBuiltInExports;
	var defineProperty$c = objectDefineProperty;
	var defineBuiltInAccessor$h = function defineBuiltInAccessor(target, name, descriptor) {
	  if (descriptor.get) makeBuiltIn$1(descriptor.get, name, {
	    getter: true
	  });
	  if (descriptor.set) makeBuiltIn$1(descriptor.set, name, {
	    setter: true
	  });
	  return defineProperty$c.f(target, name, descriptor);
	};
	var defineBuiltInAccessor$i = /*@__PURE__*/getDefaultExportFromCjs(defineBuiltInAccessor$h);

	var wellKnownSymbolWrapped = {};

	var wellKnownSymbol$v = wellKnownSymbol$z;
	var f$1 = wellKnownSymbolWrapped.f = wellKnownSymbol$v;

	var global$P = global$Z;
	var path$2 = global$P;
	var path$3 = /*@__PURE__*/getDefaultExportFromCjs(path$2);

	var path$1 = path$2;
	var hasOwn$p = hasOwnProperty_1;
	var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
	var defineProperty$b = objectDefineProperty.f;
	var wellKnownSymbolDefine = function wellKnownSymbolDefine(NAME) {
	  var _Symbol = path$1.Symbol || (path$1.Symbol = {});
	  if (!hasOwn$p(_Symbol, NAME)) defineProperty$b(_Symbol, NAME, {
	    value: wrappedWellKnownSymbolModule$1.f(NAME)
	  });
	};
	var wellKnownSymbolDefine$1 = /*@__PURE__*/getDefaultExportFromCjs(wellKnownSymbolDefine);

	var call$z = functionCall;
	var getBuiltIn$i = getBuiltIn$m;
	var wellKnownSymbol$u = wellKnownSymbol$z;
	var defineBuiltIn$k = defineBuiltIn$m;
	var symbolDefineToPrimitive = function symbolDefineToPrimitive() {
	  var _Symbol = getBuiltIn$i('Symbol');
	  var SymbolPrototype = _Symbol && _Symbol.prototype;
	  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
	  var TO_PRIMITIVE = wellKnownSymbol$u('toPrimitive');
	  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
	    // `Symbol.prototype[@@toPrimitive]` method
	    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	    // eslint-disable-next-line no-unused-vars -- required for .length
	    defineBuiltIn$k(SymbolPrototype, TO_PRIMITIVE, function (hint) {
	      return call$z(valueOf, this);
	    }, {
	      arity: 1
	    });
	  }
	};
	var symbolDefineToPrimitive$1 = /*@__PURE__*/getDefaultExportFromCjs(symbolDefineToPrimitive);

	var defineProperty$a = objectDefineProperty.f;
	var hasOwn$o = hasOwnProperty_1;
	var wellKnownSymbol$t = wellKnownSymbol$z;
	var TO_STRING_TAG$3 = wellKnownSymbol$t('toStringTag');
	var setToStringTag$d = function setToStringTag(target, TAG, STATIC) {
	  if (target && !STATIC) target = target.prototype;
	  if (target && !hasOwn$o(target, TO_STRING_TAG$3)) {
	    defineProperty$a(target, TO_STRING_TAG$3, {
	      configurable: true,
	      value: TAG
	    });
	  }
	};
	var setToStringTag$e = /*@__PURE__*/getDefaultExportFromCjs(setToStringTag$d);

	var classofRaw = classofRaw$2;
	var uncurryThis$1a = functionUncurryThis;
	var functionUncurryThisClause = function functionUncurryThisClause(fn) {
	  // Nashorn bug:
	  //   https://github.com/zloirock/core-js/issues/1128
	  //   https://github.com/zloirock/core-js/issues/1130
	  if (classofRaw(fn) === 'Function') return uncurryThis$1a(fn);
	};
	var functionUncurryThisClause$1 = /*@__PURE__*/getDefaultExportFromCjs(functionUncurryThisClause);

	var uncurryThis$19 = functionUncurryThisClause;
	var aCallable$j = aCallable$l;
	var NATIVE_BIND$2 = functionBindNative;
	var bind$e = uncurryThis$19(uncurryThis$19.bind);

	// optional / simple context binding
	var functionBindContext = function functionBindContext(fn, that) {
	  aCallable$j(fn);
	  return that === undefined ? fn : NATIVE_BIND$2 ? bind$e(fn, that) : function /* ...args */
	  () {
	    return fn.apply(that, arguments);
	  };
	};
	var functionBindContext$1 = /*@__PURE__*/getDefaultExportFromCjs(functionBindContext);

	var classof$j = classofRaw$2;

	// `IsArray` abstract operation
	// https://tc39.es/ecma262/#sec-isarray
	// eslint-disable-next-line es/no-array-isarray -- safe
	var isArray$9 = Array.isArray || function isArray(argument) {
	  return classof$j(argument) == 'Array';
	};
	var isArray$a = /*@__PURE__*/getDefaultExportFromCjs(isArray$9);

	var uncurryThis$18 = functionUncurryThis;
	var fails$1d = fails$1m;
	var isCallable$n = isCallable$z;
	var classof$i = classof$m;
	var getBuiltIn$h = getBuiltIn$m;
	var inspectSource$1 = inspectSource$3;
	var noop = function noop() {/* empty */};
	var empty = [];
	var construct$1 = getBuiltIn$h('Reflect', 'construct');
	var constructorRegExp = /^\s*(?:class|function)\b/;
	var exec$a = uncurryThis$18(constructorRegExp.exec);
	var INCORRECT_TO_STRING$2 = !constructorRegExp.exec(noop);
	var isConstructorModern = function isConstructor(argument) {
	  if (!isCallable$n(argument)) return false;
	  try {
	    construct$1(noop, empty, argument);
	    return true;
	  } catch (error) {
	    return false;
	  }
	};
	var isConstructorLegacy = function isConstructor(argument) {
	  if (!isCallable$n(argument)) return false;
	  switch (classof$i(argument)) {
	    case 'AsyncFunction':
	    case 'GeneratorFunction':
	    case 'AsyncGeneratorFunction':
	      return false;
	  }
	  try {
	    // we can't check .prototype since constructors produced by .bind haven't it
	    // `Function#toString` throws on some built-it function in some legacy engines
	    // (for example, `DOMQuad` and similar in FF41-)
	    return INCORRECT_TO_STRING$2 || !!exec$a(constructorRegExp, inspectSource$1(argument));
	  } catch (error) {
	    return true;
	  }
	};
	isConstructorLegacy.sham = true;

	// `IsConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-isconstructor
	var isConstructor$6 = !construct$1 || fails$1d(function () {
	  var called;
	  return isConstructorModern(isConstructorModern.call) || !isConstructorModern(Object) || !isConstructorModern(function () {
	    called = true;
	  }) || called;
	}) ? isConstructorLegacy : isConstructorModern;
	var isConstructor$7 = /*@__PURE__*/getDefaultExportFromCjs(isConstructor$6);

	var isArray$8 = isArray$9;
	var isConstructor$5 = isConstructor$6;
	var isObject$t = isObject$z;
	var wellKnownSymbol$s = wellKnownSymbol$z;
	var SPECIES$6 = wellKnownSymbol$s('species');
	var $Array$8 = Array;

	// a part of `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesConstructor$1 = function arraySpeciesConstructor(originalArray) {
	  var C;
	  if (isArray$8(originalArray)) {
	    C = originalArray.constructor;
	    // cross-realm fallback
	    if (isConstructor$5(C) && (C === $Array$8 || isArray$8(C.prototype))) C = undefined;else if (isObject$t(C)) {
	      C = C[SPECIES$6];
	      if (C === null) C = undefined;
	    }
	  }
	  return C === undefined ? $Array$8 : C;
	};
	var arraySpeciesConstructor$2 = /*@__PURE__*/getDefaultExportFromCjs(arraySpeciesConstructor$1);

	var arraySpeciesConstructor = arraySpeciesConstructor$1;

	// `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesCreate$5 = function arraySpeciesCreate(originalArray, length) {
	  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
	};
	var arraySpeciesCreate$6 = /*@__PURE__*/getDefaultExportFromCjs(arraySpeciesCreate$5);

	var bind$d = functionBindContext;
	var uncurryThis$17 = functionUncurryThis;
	var IndexedObject$4 = indexedObject;
	var toObject$r = toObject$t;
	var lengthOfArrayLike$q = lengthOfArrayLike$t;
	var arraySpeciesCreate$4 = arraySpeciesCreate$5;
	var push$d = uncurryThis$17([].push);

	// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
	var createMethod$6 = function createMethod(TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var IS_FILTER_REJECT = TYPE == 7;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject$r($this);
	    var self = IndexedObject$4(O);
	    var boundFunction = bind$d(callbackfn, that);
	    var length = lengthOfArrayLike$q(self);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate$4;
	    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
	    var value, result;
	    for (; length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);
	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	          case 3:
	            return true;
	          // some
	          case 5:
	            return value;
	          // find
	          case 6:
	            return index;
	          // findIndex
	          case 2:
	            push$d(target, value);
	          // filter
	        } else switch (TYPE) {
	          case 4:
	            return false;
	          // every
	          case 7:
	            push$d(target, value);
	          // filterReject
	        }
	      }
	    }

	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};
	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.es/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$6(0),
	  // `Array.prototype.map` method
	  // https://tc39.es/ecma262/#sec-array.prototype.map
	  map: createMethod$6(1),
	  // `Array.prototype.filter` method
	  // https://tc39.es/ecma262/#sec-array.prototype.filter
	  filter: createMethod$6(2),
	  // `Array.prototype.some` method
	  // https://tc39.es/ecma262/#sec-array.prototype.some
	  some: createMethod$6(3),
	  // `Array.prototype.every` method
	  // https://tc39.es/ecma262/#sec-array.prototype.every
	  every: createMethod$6(4),
	  // `Array.prototype.find` method
	  // https://tc39.es/ecma262/#sec-array.prototype.find
	  find: createMethod$6(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$6(6),
	  // `Array.prototype.filterReject` method
	  // https://github.com/tc39/proposal-array-filtering
	  filterReject: createMethod$6(7)
	};
	var arrayIteration$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayIteration);

	'use strict';
	var $$2X = _export;
	var global$O = global$Z;
	var call$y = functionCall;
	var uncurryThis$16 = functionUncurryThis;
	var IS_PURE$j = isPure;
	var DESCRIPTORS$B = descriptors;
	var NATIVE_SYMBOL$4 = symbolConstructorDetection;
	var fails$1c = fails$1m;
	var hasOwn$n = hasOwnProperty_1;
	var isPrototypeOf$a = objectIsPrototypeOf;
	var anObject$y = anObject$D;
	var toIndexedObject$d = toIndexedObject$j;
	var toPropertyKey$4 = toPropertyKey$8;
	var $toString$3 = toString$x;
	var createPropertyDescriptor$8 = createPropertyDescriptor$c;
	var nativeObjectCreate = objectCreate;
	var objectKeys$3 = objectKeys$5;
	var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
	var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
	var getOwnPropertyDescriptorModule$5 = objectGetOwnPropertyDescriptor;
	var definePropertyModule$6 = objectDefineProperty;
	var definePropertiesModule = objectDefineProperties;
	var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
	var defineBuiltIn$j = defineBuiltIn$m;
	var defineBuiltInAccessor$g = defineBuiltInAccessor$h;
	var shared$4 = sharedExports;
	var sharedKey$1 = sharedKey$4;
	var hiddenKeys$1 = hiddenKeys$6;
	var uid$3 = uid$6;
	var wellKnownSymbol$r = wellKnownSymbol$z;
	var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
	var defineWellKnownSymbol$d = wellKnownSymbolDefine;
	var defineSymbolToPrimitive$1 = symbolDefineToPrimitive;
	var setToStringTag$c = setToStringTag$d;
	var InternalStateModule$c = internalState;
	var $forEach$2 = arrayIteration.forEach;
	var HIDDEN = sharedKey$1('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE$1 = 'prototype';
	var setInternalState$b = InternalStateModule$c.set;
	var getInternalState$9 = InternalStateModule$c.getterFor(SYMBOL);
	var ObjectPrototype$5 = Object[PROTOTYPE$1];
	var $Symbol = global$O.Symbol;
	var SymbolPrototype$1 = $Symbol && $Symbol[PROTOTYPE$1];
	var TypeError$7 = global$O.TypeError;
	var QObject = global$O.QObject;
	var nativeGetOwnPropertyDescriptor$2 = getOwnPropertyDescriptorModule$5.f;
	var nativeDefineProperty$1 = definePropertyModule$6.f;
	var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable = propertyIsEnumerableModule$1.f;
	var push$c = uncurryThis$16([].push);
	var AllSymbols = shared$4('symbols');
	var ObjectPrototypeSymbols = shared$4('op-symbols');
	var WellKnownSymbolsStore = shared$4('wks');

	// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
	var USE_SETTER = !QObject || !QObject[PROTOTYPE$1] || !QObject[PROTOTYPE$1].findChild;

	// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
	var setSymbolDescriptor = DESCRIPTORS$B && fails$1c(function () {
	  return nativeObjectCreate(nativeDefineProperty$1({}, 'a', {
	    get: function get() {
	      return nativeDefineProperty$1(this, 'a', {
	        value: 7
	      }).a;
	    }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$2(ObjectPrototype$5, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype$5[P];
	  nativeDefineProperty$1(O, P, Attributes);
	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$5) {
	    nativeDefineProperty$1(ObjectPrototype$5, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty$1;
	var wrap = function wrap(tag, description) {
	  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype$1);
	  setInternalState$b(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!DESCRIPTORS$B) symbol.description = description;
	  return symbol;
	};
	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype$5) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject$y(O);
	  var key = toPropertyKey$4(P);
	  anObject$y(Attributes);
	  if (hasOwn$n(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!hasOwn$n(O, HIDDEN)) nativeDefineProperty$1(O, HIDDEN, createPropertyDescriptor$8(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (hasOwn$n(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = nativeObjectCreate(Attributes, {
	        enumerable: createPropertyDescriptor$8(0, false)
	      });
	    }
	    return setSymbolDescriptor(O, key, Attributes);
	  }
	  return nativeDefineProperty$1(O, key, Attributes);
	};
	var $defineProperties = function defineProperties(O, Properties) {
	  anObject$y(O);
	  var properties = toIndexedObject$d(Properties);
	  var keys = objectKeys$3(properties).concat($getOwnPropertySymbols(properties));
	  $forEach$2(keys, function (key) {
	    if (!DESCRIPTORS$B || call$y($propertyIsEnumerable$1, properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};
	var $create = function create(O, Properties) {
	  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
	};
	var $propertyIsEnumerable$1 = function propertyIsEnumerable(V) {
	  var P = toPropertyKey$4(V);
	  var enumerable = call$y(nativePropertyIsEnumerable, this, P);
	  if (this === ObjectPrototype$5 && hasOwn$n(AllSymbols, P) && !hasOwn$n(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !hasOwn$n(this, P) || !hasOwn$n(AllSymbols, P) || hasOwn$n(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
	};
	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject$d(O);
	  var key = toPropertyKey$4(P);
	  if (it === ObjectPrototype$5 && hasOwn$n(AllSymbols, key) && !hasOwn$n(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$2(it, key);
	  if (descriptor && hasOwn$n(AllSymbols, key) && !(hasOwn$n(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }
	  return descriptor;
	};
	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames(toIndexedObject$d(O));
	  var result = [];
	  $forEach$2(names, function (key) {
	    if (!hasOwn$n(AllSymbols, key) && !hasOwn$n(hiddenKeys$1, key)) push$c(result, key);
	  });
	  return result;
	};
	var $getOwnPropertySymbols = function $getOwnPropertySymbols(O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$5;
	  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$d(O));
	  var result = [];
	  $forEach$2(names, function (key) {
	    if (hasOwn$n(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn$n(ObjectPrototype$5, key))) {
	      push$c(result, AllSymbols[key]);
	    }
	  });
	  return result;
	};

	// `Symbol` constructor
	// https://tc39.es/ecma262/#sec-symbol-constructor
	if (!NATIVE_SYMBOL$4) {
	  $Symbol = function _Symbol() {
	    if (isPrototypeOf$a(SymbolPrototype$1, this)) throw TypeError$7('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString$3(arguments[0]);
	    var tag = uid$3(description);
	    var setter = function setter(value) {
	      if (this === ObjectPrototype$5) call$y(setter, ObjectPrototypeSymbols, value);
	      if (hasOwn$n(this, HIDDEN) && hasOwn$n(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor$8(1, value));
	    };
	    if (DESCRIPTORS$B && USE_SETTER) setSymbolDescriptor(ObjectPrototype$5, tag, {
	      configurable: true,
	      set: setter
	    });
	    return wrap(tag, description);
	  };
	  SymbolPrototype$1 = $Symbol[PROTOTYPE$1];
	  defineBuiltIn$j(SymbolPrototype$1, 'toString', function toString() {
	    return getInternalState$9(this).tag;
	  });
	  defineBuiltIn$j($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid$3(description), description);
	  });
	  propertyIsEnumerableModule$1.f = $propertyIsEnumerable$1;
	  definePropertyModule$6.f = $defineProperty;
	  definePropertiesModule.f = $defineProperties;
	  getOwnPropertyDescriptorModule$5.f = $getOwnPropertyDescriptor;
	  getOwnPropertyNamesModule$1.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  getOwnPropertySymbolsModule$2.f = $getOwnPropertySymbols;
	  wrappedWellKnownSymbolModule.f = function (name) {
	    return wrap(wellKnownSymbol$r(name), name);
	  };
	  if (DESCRIPTORS$B) {
	    // https://github.com/tc39/proposal-Symbol-description
	    defineBuiltInAccessor$g(SymbolPrototype$1, 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState$9(this).description;
	      }
	    });
	    if (!IS_PURE$j) {
	      defineBuiltIn$j(ObjectPrototype$5, 'propertyIsEnumerable', $propertyIsEnumerable$1, {
	        unsafe: true
	      });
	    }
	  }
	}
	$$2X({
	  global: true,
	  constructor: true,
	  wrap: true,
	  forced: !NATIVE_SYMBOL$4,
	  sham: !NATIVE_SYMBOL$4
	}, {
	  Symbol: $Symbol
	});
	$forEach$2(objectKeys$3(WellKnownSymbolsStore), function (name) {
	  defineWellKnownSymbol$d(name);
	});
	$$2X({
	  target: SYMBOL,
	  stat: true,
	  forced: !NATIVE_SYMBOL$4
	}, {
	  useSetter: function useSetter() {
	    USE_SETTER = true;
	  },
	  useSimple: function useSimple() {
	    USE_SETTER = false;
	  }
	});
	$$2X({
	  target: 'Object',
	  stat: true,
	  forced: !NATIVE_SYMBOL$4,
	  sham: !DESCRIPTORS$B
	}, {
	  // `Object.create` method
	  // https://tc39.es/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.es/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.es/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});
	$$2X({
	  target: 'Object',
	  stat: true,
	  forced: !NATIVE_SYMBOL$4
	}, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames
	});

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive$1();

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$c($Symbol, SYMBOL);
	hiddenKeys$1[HIDDEN] = true;

	var es_symbol_for = {};

	var NATIVE_SYMBOL$3 = symbolConstructorDetection;

	/* eslint-disable es/no-symbol -- safe */
	var symbolRegistryDetection = NATIVE_SYMBOL$3 && !!Symbol['for'] && !!Symbol.keyFor;
	var symbolRegistryDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(symbolRegistryDetection);

	var $$2W = _export;
	var getBuiltIn$g = getBuiltIn$m;
	var hasOwn$m = hasOwnProperty_1;
	var toString$w = toString$x;
	var shared$3 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY$1 = symbolRegistryDetection;
	var StringToSymbolRegistry = shared$3('string-to-symbol-registry');
	var SymbolToStringRegistry$1 = shared$3('symbol-to-string-registry');

	// `Symbol.for` method
	// https://tc39.es/ecma262/#sec-symbol.for
	$$2W({
	  target: 'Symbol',
	  stat: true,
	  forced: !NATIVE_SYMBOL_REGISTRY$1
	}, {
	  'for': function _for(key) {
	    var string = toString$w(key);
	    if (hasOwn$m(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = getBuiltIn$g('Symbol')(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry$1[symbol] = string;
	    return symbol;
	  }
	});

	var es_symbol_keyFor = {};

	var $$2V = _export;
	var hasOwn$l = hasOwnProperty_1;
	var isSymbol$4 = isSymbol$7;
	var tryToString$5 = tryToString$7;
	var shared$2 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY = symbolRegistryDetection;
	var SymbolToStringRegistry = shared$2('symbol-to-string-registry');

	// `Symbol.keyFor` method
	// https://tc39.es/ecma262/#sec-symbol.keyfor
	$$2V({
	  target: 'Symbol',
	  stat: true,
	  forced: !NATIVE_SYMBOL_REGISTRY
	}, {
	  keyFor: function keyFor(sym) {
	    if (!isSymbol$4(sym)) throw TypeError(tryToString$5(sym) + ' is not a symbol');
	    if (hasOwn$l(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  }
	});

	var es_json_stringify = {};

	var NATIVE_BIND$1 = functionBindNative;
	var FunctionPrototype$2 = Function.prototype;
	var apply$b = FunctionPrototype$2.apply;
	var call$x = FunctionPrototype$2.call;

	// eslint-disable-next-line es/no-reflect -- safe
	var functionApply$1 = (typeof Reflect === "undefined" ? "undefined" : _typeof(Reflect)) == 'object' && Reflect.apply || (NATIVE_BIND$1 ? call$x.bind(apply$b) : function () {
	  return call$x.apply(apply$b, arguments);
	});
	var functionApply$2 = /*@__PURE__*/getDefaultExportFromCjs(functionApply$1);

	var uncurryThis$15 = functionUncurryThis;
	var arraySlice$a = uncurryThis$15([].slice);
	var arraySlice$b = /*@__PURE__*/getDefaultExportFromCjs(arraySlice$a);

	var uncurryThis$14 = functionUncurryThis;
	var isArray$7 = isArray$9;
	var isCallable$m = isCallable$z;
	var classof$h = classofRaw$2;
	var toString$v = toString$x;
	var push$b = uncurryThis$14([].push);
	var getJsonReplacerFunction = function getJsonReplacerFunction(replacer) {
	  if (isCallable$m(replacer)) return replacer;
	  if (!isArray$7(replacer)) return;
	  var rawLength = replacer.length;
	  var keys = [];
	  for (var i = 0; i < rawLength; i++) {
	    var element = replacer[i];
	    if (typeof element == 'string') push$b(keys, element);else if (typeof element == 'number' || classof$h(element) == 'Number' || classof$h(element) == 'String') push$b(keys, toString$v(element));
	  }
	  var keysLength = keys.length;
	  var root = true;
	  return function (key, value) {
	    if (root) {
	      root = false;
	      return value;
	    }
	    if (isArray$7(this)) return value;
	    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
	  };
	};
	var getJsonReplacerFunction$1 = /*@__PURE__*/getDefaultExportFromCjs(getJsonReplacerFunction);

	var $$2U = _export;
	var getBuiltIn$f = getBuiltIn$m;
	var apply$a = functionApply$1;
	var call$w = functionCall;
	var uncurryThis$13 = functionUncurryThis;
	var fails$1b = fails$1m;
	var isCallable$l = isCallable$z;
	var isSymbol$3 = isSymbol$7;
	var arraySlice$9 = arraySlice$a;
	var getReplacerFunction = getJsonReplacerFunction;
	var NATIVE_SYMBOL$2 = symbolConstructorDetection;
	var $String$3 = String;
	var $stringify = getBuiltIn$f('JSON', 'stringify');
	var exec$9 = uncurryThis$13(/./.exec);
	var charAt$e = uncurryThis$13(''.charAt);
	var charCodeAt$5 = uncurryThis$13(''.charCodeAt);
	var replace$c = uncurryThis$13(''.replace);
	var numberToString$2 = uncurryThis$13(1.0.toString);
	var tester = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;
	var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL$2 || fails$1b(function () {
	  var symbol = getBuiltIn$f('Symbol')();
	  // MS Edge converts symbol values to JSON as {}
	  return $stringify([symbol]) != '[null]'
	  // WebKit converts symbol values to JSON as null
	  || $stringify({
	    a: symbol
	  }) != '{}'
	  // V8 throws on boxed symbols
	  || $stringify(Object(symbol)) != '{}';
	});

	// https://github.com/tc39/proposal-well-formed-stringify
	var ILL_FORMED_UNICODE = fails$1b(function () {
	  return $stringify("\uDF06\uD834") !== "\"\\udf06\\ud834\"" || $stringify("\uDEAD") !== "\"\\udead\"";
	});
	var stringifyWithSymbolsFix = function stringifyWithSymbolsFix(it, replacer) {
	  var args = arraySlice$9(arguments);
	  var $replacer = getReplacerFunction(replacer);
	  if (!isCallable$l($replacer) && (it === undefined || isSymbol$3(it))) return; // IE8 returns string on undefined
	  args[1] = function (key, value) {
	    // some old implementations (like WebKit) could pass numbers as keys
	    if (isCallable$l($replacer)) value = call$w($replacer, this, $String$3(key), value);
	    if (!isSymbol$3(value)) return value;
	  };
	  return apply$a($stringify, null, args);
	};
	var fixIllFormed = function fixIllFormed(match, offset, string) {
	  var prev = charAt$e(string, offset - 1);
	  var next = charAt$e(string, offset + 1);
	  if (exec$9(low, match) && !exec$9(hi, next) || exec$9(hi, match) && !exec$9(low, prev)) {
	    return "\\u" + numberToString$2(charCodeAt$5(match, 0), 16);
	  }
	  return match;
	};
	if ($stringify) {
	  // `JSON.stringify` method
	  // https://tc39.es/ecma262/#sec-json.stringify
	  $$2U({
	    target: 'JSON',
	    stat: true,
	    arity: 3,
	    forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE
	  }, {
	    // eslint-disable-next-line no-unused-vars -- required for `.length`
	    stringify: function stringify(it, replacer, space) {
	      var args = arraySlice$9(arguments);
	      var result = apply$a(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
	      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace$c(result, tester, fixIllFormed) : result;
	    }
	  });
	}

	var es_object_getOwnPropertySymbols = {};

	var $$2T = _export;
	var NATIVE_SYMBOL$1 = symbolConstructorDetection;
	var fails$1a = fails$1m;
	var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
	var toObject$q = toObject$t;

	// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443
	var FORCED$D = !NATIVE_SYMBOL$1 || fails$1a(function () {
	  getOwnPropertySymbolsModule$1.f(1);
	});

	// `Object.getOwnPropertySymbols` method
	// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
	$$2T({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$D
	}, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    var $getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
	    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject$q(it)) : [];
	  }
	});

	var es_symbol_description = {};

	// `Symbol.prototype.description` getter
	// https://tc39.es/ecma262/#sec-symbol.prototype.description
	'use strict';
	var $$2S = _export;
	var DESCRIPTORS$A = descriptors;
	var global$N = global$Z;
	var uncurryThis$12 = functionUncurryThis;
	var hasOwn$k = hasOwnProperty_1;
	var isCallable$k = isCallable$z;
	var isPrototypeOf$9 = objectIsPrototypeOf;
	var toString$u = toString$x;
	var defineBuiltInAccessor$f = defineBuiltInAccessor$h;
	var copyConstructorProperties$3 = copyConstructorProperties$5;
	var NativeSymbol = global$N.Symbol;
	var SymbolPrototype = NativeSymbol && NativeSymbol.prototype;
	if (DESCRIPTORS$A && isCallable$k(NativeSymbol) && (!('description' in SymbolPrototype) ||
	// Safari 12 bug
	NativeSymbol().description !== undefined)) {
	  var EmptyStringDescriptionStore = {};
	  // wrap Symbol constructor for correct work with undefined description
	  var SymbolWrapper = function _Symbol() {
	    var description = arguments.length < 1 || arguments[0] === undefined ? undefined : toString$u(arguments[0]);
	    var result = isPrototypeOf$9(SymbolPrototype, this) ? new NativeSymbol(description)
	    // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
	    : description === undefined ? NativeSymbol() : NativeSymbol(description);
	    if (description === '') EmptyStringDescriptionStore[result] = true;
	    return result;
	  };
	  copyConstructorProperties$3(SymbolWrapper, NativeSymbol);
	  SymbolWrapper.prototype = SymbolPrototype;
	  SymbolPrototype.constructor = SymbolWrapper;
	  var NATIVE_SYMBOL = String(NativeSymbol('test')) == 'Symbol(test)';
	  var thisSymbolValue = uncurryThis$12(SymbolPrototype.valueOf);
	  var symbolDescriptiveString = uncurryThis$12(SymbolPrototype.toString);
	  var regexp = /^Symbol\((.*)\)[^)]+$/;
	  var replace$b = uncurryThis$12(''.replace);
	  var stringSlice$g = uncurryThis$12(''.slice);
	  defineBuiltInAccessor$f(SymbolPrototype, 'description', {
	    configurable: true,
	    get: function description() {
	      var symbol = thisSymbolValue(this);
	      if (hasOwn$k(EmptyStringDescriptionStore, symbol)) return '';
	      var string = symbolDescriptiveString(symbol);
	      var desc = NATIVE_SYMBOL ? stringSlice$g(string, 7, -1) : replace$b(string, regexp, '$1');
	      return desc === '' ? undefined : desc;
	    }
	  });
	  $$2S({
	    global: true,
	    constructor: true,
	    forced: true
	  }, {
	    Symbol: SymbolWrapper
	  });
	}

	var es_symbol_asyncIterator = {};

	var defineWellKnownSymbol$c = wellKnownSymbolDefine;

	// `Symbol.asyncIterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.asynciterator
	defineWellKnownSymbol$c('asyncIterator');

	var es_symbol_hasInstance = {};

	var defineWellKnownSymbol$b = wellKnownSymbolDefine;

	// `Symbol.hasInstance` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.hasinstance
	defineWellKnownSymbol$b('hasInstance');

	var es_symbol_isConcatSpreadable = {};

	var defineWellKnownSymbol$a = wellKnownSymbolDefine;

	// `Symbol.isConcatSpreadable` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
	defineWellKnownSymbol$a('isConcatSpreadable');

	var es_symbol_iterator = {};

	var defineWellKnownSymbol$9 = wellKnownSymbolDefine;

	// `Symbol.iterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.iterator
	defineWellKnownSymbol$9('iterator');

	var es_symbol_match = {};

	var defineWellKnownSymbol$8 = wellKnownSymbolDefine;

	// `Symbol.match` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.match
	defineWellKnownSymbol$8('match');

	var es_symbol_matchAll = {};

	var defineWellKnownSymbol$7 = wellKnownSymbolDefine;

	// `Symbol.matchAll` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.matchall
	defineWellKnownSymbol$7('matchAll');

	var es_symbol_replace = {};

	var defineWellKnownSymbol$6 = wellKnownSymbolDefine;

	// `Symbol.replace` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.replace
	defineWellKnownSymbol$6('replace');

	var es_symbol_search = {};

	var defineWellKnownSymbol$5 = wellKnownSymbolDefine;

	// `Symbol.search` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.search
	defineWellKnownSymbol$5('search');

	var es_symbol_species = {};

	var defineWellKnownSymbol$4 = wellKnownSymbolDefine;

	// `Symbol.species` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.species
	defineWellKnownSymbol$4('species');

	var es_symbol_split = {};

	var defineWellKnownSymbol$3 = wellKnownSymbolDefine;

	// `Symbol.split` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.split
	defineWellKnownSymbol$3('split');

	var es_symbol_toPrimitive = {};

	var defineWellKnownSymbol$2 = wellKnownSymbolDefine;
	var defineSymbolToPrimitive = symbolDefineToPrimitive;

	// `Symbol.toPrimitive` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.toprimitive
	defineWellKnownSymbol$2('toPrimitive');

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive();

	var es_symbol_toStringTag = {};

	var getBuiltIn$e = getBuiltIn$m;
	var defineWellKnownSymbol$1 = wellKnownSymbolDefine;
	var setToStringTag$b = setToStringTag$d;

	// `Symbol.toStringTag` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.tostringtag
	defineWellKnownSymbol$1('toStringTag');

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$b(getBuiltIn$e('Symbol'), 'Symbol');

	var es_symbol_unscopables = {};

	var defineWellKnownSymbol = wellKnownSymbolDefine;

	// `Symbol.unscopables` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.unscopables
	defineWellKnownSymbol('unscopables');

	var es_error_cause = {};

	var uncurryThis$11 = functionUncurryThis;
	var aCallable$i = aCallable$l;
	var functionUncurryThisAccessor = function functionUncurryThisAccessor(object, key, method) {
	  try {
	    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	    return uncurryThis$11(aCallable$i(Object.getOwnPropertyDescriptor(object, key)[method]));
	  } catch (error) {/* empty */}
	};
	var functionUncurryThisAccessor$1 = /*@__PURE__*/getDefaultExportFromCjs(functionUncurryThisAccessor);

	var isCallable$j = isCallable$z;
	var $String$2 = String;
	var $TypeError$j = TypeError;
	var aPossiblePrototype$2 = function aPossiblePrototype(argument) {
	  if (_typeof(argument) == 'object' || isCallable$j(argument)) return argument;
	  throw $TypeError$j("Can't set " + $String$2(argument) + ' as a prototype');
	};
	var aPossiblePrototype$3 = /*@__PURE__*/getDefaultExportFromCjs(aPossiblePrototype$2);

	/* eslint-disable no-proto -- safe */
	var uncurryThisAccessor = functionUncurryThisAccessor;
	var anObject$x = anObject$D;
	var aPossiblePrototype$1 = aPossiblePrototype$2;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.
	// eslint-disable-next-line es/no-object-setprototypeof -- safe
	var objectSetPrototypeOf$1 = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;
	  try {
	    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
	    setter(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {/* empty */}
	  return function setPrototypeOf(O, proto) {
	    anObject$x(O);
	    aPossiblePrototype$1(proto);
	    if (CORRECT_SETTER) setter(O, proto);else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);
	var objectSetPrototypeOf$2 = /*@__PURE__*/getDefaultExportFromCjs(objectSetPrototypeOf$1);

	var defineProperty$9 = objectDefineProperty.f;
	var proxyAccessor$2 = function proxyAccessor(Target, Source, key) {
	  key in Target || defineProperty$9(Target, key, {
	    configurable: true,
	    get: function get() {
	      return Source[key];
	    },
	    set: function set(it) {
	      Source[key] = it;
	    }
	  });
	};
	var proxyAccessor$3 = /*@__PURE__*/getDefaultExportFromCjs(proxyAccessor$2);

	var isCallable$i = isCallable$z;
	var isObject$s = isObject$z;
	var setPrototypeOf$9 = objectSetPrototypeOf$1;

	// makes subclassing work correct for wrapped built-ins
	var inheritIfRequired$6 = function inheritIfRequired($this, dummy, Wrapper) {
	  var NewTarget, NewTargetPrototype;
	  if (
	  // it can work only with native `setPrototypeOf`
	  setPrototypeOf$9 &&
	  // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
	  isCallable$i(NewTarget = dummy.constructor) && NewTarget !== Wrapper && isObject$s(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype) setPrototypeOf$9($this, NewTargetPrototype);
	  return $this;
	};
	var inheritIfRequired$7 = /*@__PURE__*/getDefaultExportFromCjs(inheritIfRequired$6);

	var toString$t = toString$x;
	var normalizeStringArgument$5 = function normalizeStringArgument(argument, $default) {
	  return argument === undefined ? arguments.length < 2 ? '' : $default : toString$t(argument);
	};
	var normalizeStringArgument$6 = /*@__PURE__*/getDefaultExportFromCjs(normalizeStringArgument$5);

	var isObject$r = isObject$z;
	var createNonEnumerableProperty$c = createNonEnumerableProperty$f;

	// `InstallErrorCause` abstract operation
	// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause
	var installErrorCause$2 = function installErrorCause(O, options) {
	  if (isObject$r(options) && 'cause' in options) {
	    createNonEnumerableProperty$c(O, 'cause', options.cause);
	  }
	};
	var installErrorCause$3 = /*@__PURE__*/getDefaultExportFromCjs(installErrorCause$2);

	var uncurryThis$10 = functionUncurryThis;
	var $Error$1 = Error;
	var replace$a = uncurryThis$10(''.replace);
	var TEST = function (arg) {
	  return String($Error$1(arg).stack);
	}('zxcasd');
	// eslint-disable-next-line redos/no-vulnerable -- safe
	var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
	var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);
	var errorStackClear = function errorStackClear(stack, dropEntries) {
	  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error$1.prepareStackTrace) {
	    while (dropEntries--) stack = replace$a(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
	  }
	  return stack;
	};
	var errorStackClear$1 = /*@__PURE__*/getDefaultExportFromCjs(errorStackClear);

	var fails$19 = fails$1m;
	var createPropertyDescriptor$7 = createPropertyDescriptor$c;
	var errorStackInstallable = !fails$19(function () {
	  var error = Error('a');
	  if (!('stack' in error)) return true;
	  // eslint-disable-next-line es/no-object-defineproperty -- safe
	  Object.defineProperty(error, 'stack', createPropertyDescriptor$7(1, 7));
	  return error.stack !== 7;
	});
	var errorStackInstallable$1 = /*@__PURE__*/getDefaultExportFromCjs(errorStackInstallable);

	var createNonEnumerableProperty$b = createNonEnumerableProperty$f;
	var clearErrorStack$2 = errorStackClear;
	var ERROR_STACK_INSTALLABLE$1 = errorStackInstallable;

	// non-standard V8
	var captureStackTrace = Error.captureStackTrace;
	var errorStackInstall = function errorStackInstall(error, C, stack, dropEntries) {
	  if (ERROR_STACK_INSTALLABLE$1) {
	    if (captureStackTrace) captureStackTrace(error, C);else createNonEnumerableProperty$b(error, 'stack', clearErrorStack$2(stack, dropEntries));
	  }
	};
	var errorStackInstall$1 = /*@__PURE__*/getDefaultExportFromCjs(errorStackInstall);

	'use strict';
	var getBuiltIn$d = getBuiltIn$m;
	var hasOwn$j = hasOwnProperty_1;
	var createNonEnumerableProperty$a = createNonEnumerableProperty$f;
	var isPrototypeOf$8 = objectIsPrototypeOf;
	var setPrototypeOf$8 = objectSetPrototypeOf$1;
	var copyConstructorProperties$2 = copyConstructorProperties$5;
	var proxyAccessor$1 = proxyAccessor$2;
	var inheritIfRequired$5 = inheritIfRequired$6;
	var normalizeStringArgument$4 = normalizeStringArgument$5;
	var installErrorCause$1 = installErrorCause$2;
	var installErrorStack$1 = errorStackInstall;
	var DESCRIPTORS$z = descriptors;
	var IS_PURE$i = isPure;
	var wrapErrorConstructorWithCause$2 = function wrapErrorConstructorWithCause(FULL_NAME, wrapper, FORCED, IS_AGGREGATE_ERROR) {
	  var STACK_TRACE_LIMIT = 'stackTraceLimit';
	  var OPTIONS_POSITION = IS_AGGREGATE_ERROR ? 2 : 1;
	  var path = FULL_NAME.split('.');
	  var ERROR_NAME = path[path.length - 1];
	  var OriginalError = getBuiltIn$d.apply(null, path);
	  if (!OriginalError) return;
	  var OriginalErrorPrototype = OriginalError.prototype;

	  // V8 9.3- bug https://bugs.chromium.org/p/v8/issues/detail?id=12006
	  if (!IS_PURE$i && hasOwn$j(OriginalErrorPrototype, 'cause')) delete OriginalErrorPrototype.cause;
	  if (!FORCED) return OriginalError;
	  var BaseError = getBuiltIn$d('Error');
	  var WrappedError = wrapper(function (a, b) {
	    var message = normalizeStringArgument$4(IS_AGGREGATE_ERROR ? b : a, undefined);
	    var result = IS_AGGREGATE_ERROR ? new OriginalError(a) : new OriginalError();
	    if (message !== undefined) createNonEnumerableProperty$a(result, 'message', message);
	    installErrorStack$1(result, WrappedError, result.stack, 2);
	    if (this && isPrototypeOf$8(OriginalErrorPrototype, this)) inheritIfRequired$5(result, this, WrappedError);
	    if (arguments.length > OPTIONS_POSITION) installErrorCause$1(result, arguments[OPTIONS_POSITION]);
	    return result;
	  });
	  WrappedError.prototype = OriginalErrorPrototype;
	  if (ERROR_NAME !== 'Error') {
	    if (setPrototypeOf$8) setPrototypeOf$8(WrappedError, BaseError);else copyConstructorProperties$2(WrappedError, BaseError, {
	      name: true
	    });
	  } else if (DESCRIPTORS$z && STACK_TRACE_LIMIT in OriginalError) {
	    proxyAccessor$1(WrappedError, OriginalError, STACK_TRACE_LIMIT);
	    proxyAccessor$1(WrappedError, OriginalError, 'prepareStackTrace');
	  }
	  copyConstructorProperties$2(WrappedError, OriginalError);
	  if (!IS_PURE$i) try {
	    // Safari 13- bug: WebAssembly errors does not have a proper `.name`
	    if (OriginalErrorPrototype.name !== ERROR_NAME) {
	      createNonEnumerableProperty$a(OriginalErrorPrototype, 'name', ERROR_NAME);
	    }
	    OriginalErrorPrototype.constructor = WrappedError;
	  } catch (error) {/* empty */}
	  return WrappedError;
	};
	var wrapErrorConstructorWithCause$3 = /*@__PURE__*/getDefaultExportFromCjs(wrapErrorConstructorWithCause$2);

	/* eslint-disable no-unused-vars -- required for functions `.length` */
	var $$2R = _export;
	var global$M = global$Z;
	var apply$9 = functionApply$1;
	var wrapErrorConstructorWithCause$1 = wrapErrorConstructorWithCause$2;
	var WEB_ASSEMBLY = 'WebAssembly';
	var WebAssembly$2 = global$M[WEB_ASSEMBLY];
	var FORCED$C = Error('e', {
	  cause: 7
	}).cause !== 7;
	var exportGlobalErrorCauseWrapper = function exportGlobalErrorCauseWrapper(ERROR_NAME, wrapper) {
	  var O = {};
	  O[ERROR_NAME] = wrapErrorConstructorWithCause$1(ERROR_NAME, wrapper, FORCED$C);
	  $$2R({
	    global: true,
	    constructor: true,
	    arity: 1,
	    forced: FORCED$C
	  }, O);
	};
	var exportWebAssemblyErrorCauseWrapper = function exportWebAssemblyErrorCauseWrapper(ERROR_NAME, wrapper) {
	  if (WebAssembly$2 && WebAssembly$2[ERROR_NAME]) {
	    var O = {};
	    O[ERROR_NAME] = wrapErrorConstructorWithCause$1(WEB_ASSEMBLY + '.' + ERROR_NAME, wrapper, FORCED$C);
	    $$2R({
	      target: WEB_ASSEMBLY,
	      stat: true,
	      constructor: true,
	      arity: 1,
	      forced: FORCED$C
	    }, O);
	  }
	};

	// https://tc39.es/ecma262/#sec-nativeerror
	// https://github.com/tc39/proposal-error-cause
	exportGlobalErrorCauseWrapper('Error', function (init) {
	  return function Error(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('EvalError', function (init) {
	  return function EvalError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('RangeError', function (init) {
	  return function RangeError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('ReferenceError', function (init) {
	  return function ReferenceError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('SyntaxError', function (init) {
	  return function SyntaxError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('TypeError', function (init) {
	  return function TypeError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportGlobalErrorCauseWrapper('URIError', function (init) {
	  return function URIError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportWebAssemblyErrorCauseWrapper('CompileError', function (init) {
	  return function CompileError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportWebAssemblyErrorCauseWrapper('LinkError', function (init) {
	  return function LinkError(message) {
	    return apply$9(init, this, arguments);
	  };
	});
	exportWebAssemblyErrorCauseWrapper('RuntimeError', function (init) {
	  return function RuntimeError(message) {
	    return apply$9(init, this, arguments);
	  };
	});

	var es_error_toString = {};

	'use strict';
	var DESCRIPTORS$y = descriptors;
	var fails$18 = fails$1m;
	var anObject$w = anObject$D;
	var create$b = objectCreate;
	var normalizeStringArgument$3 = normalizeStringArgument$5;
	var nativeErrorToString = Error.prototype.toString;
	var INCORRECT_TO_STRING$1 = fails$18(function () {
	  if (DESCRIPTORS$y) {
	    // Chrome 32- incorrectly call accessor
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    var object = create$b(Object.defineProperty({}, 'name', {
	      get: function get() {
	        return this === object;
	      }
	    }));
	    if (nativeErrorToString.call(object) !== 'true') return true;
	  }
	  // FF10- does not properly handle non-strings
	  return nativeErrorToString.call({
	    message: 1,
	    name: 2
	  }) !== '2: 1'
	  // IE8 does not properly handle defaults
	  || nativeErrorToString.call({}) !== 'Error';
	});
	var errorToString$2 = INCORRECT_TO_STRING$1 ? function toString() {
	  var O = anObject$w(this);
	  var name = normalizeStringArgument$3(O.name, 'Error');
	  var message = normalizeStringArgument$3(O.message);
	  return !name ? message : !message ? name : name + ': ' + message;
	} : nativeErrorToString;
	var errorToString$3 = /*@__PURE__*/getDefaultExportFromCjs(errorToString$2);

	var defineBuiltIn$i = defineBuiltIn$m;
	var errorToString$1 = errorToString$2;
	var ErrorPrototype$1 = Error.prototype;

	// `Error.prototype.toString` method fix
	// https://tc39.es/ecma262/#sec-error.prototype.tostring
	if (ErrorPrototype$1.toString !== errorToString$1) {
	  defineBuiltIn$i(ErrorPrototype$1, 'toString', errorToString$1);
	}

	var es_aggregateError = {};

	var es_aggregateError_constructor = {};

	var fails$17 = fails$1m;
	var correctPrototypeGetter = !fails$17(function () {
	  function F() {/* empty */}
	  F.prototype.constructor = null;
	  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});
	var correctPrototypeGetter$1 = /*@__PURE__*/getDefaultExportFromCjs(correctPrototypeGetter);

	var hasOwn$i = hasOwnProperty_1;
	var isCallable$h = isCallable$z;
	var toObject$p = toObject$t;
	var sharedKey = sharedKey$4;
	var CORRECT_PROTOTYPE_GETTER$2 = correctPrototypeGetter;
	var IE_PROTO = sharedKey('IE_PROTO');
	var $Object$1 = Object;
	var ObjectPrototype$4 = $Object$1.prototype;

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	// eslint-disable-next-line es/no-object-getprototypeof -- safe
	var objectGetPrototypeOf$1 = CORRECT_PROTOTYPE_GETTER$2 ? $Object$1.getPrototypeOf : function (O) {
	  var object = toObject$p(O);
	  if (hasOwn$i(object, IE_PROTO)) return object[IE_PROTO];
	  var constructor = object.constructor;
	  if (isCallable$h(constructor) && object instanceof constructor) {
	    return constructor.prototype;
	  }
	  return object instanceof $Object$1 ? ObjectPrototype$4 : null;
	};
	var objectGetPrototypeOf$2 = /*@__PURE__*/getDefaultExportFromCjs(objectGetPrototypeOf$1);

	var iterators = {};
	var iterators$1 = /*@__PURE__*/getDefaultExportFromCjs(iterators);

	var wellKnownSymbol$q = wellKnownSymbol$z;
	var Iterators$4 = iterators;
	var ITERATOR$a = wellKnownSymbol$q('iterator');
	var ArrayPrototype$1 = Array.prototype;

	// check on default Array iterator
	var isArrayIteratorMethod$3 = function isArrayIteratorMethod(it) {
	  return it !== undefined && (Iterators$4.Array === it || ArrayPrototype$1[ITERATOR$a] === it);
	};
	var isArrayIteratorMethod$4 = /*@__PURE__*/getDefaultExportFromCjs(isArrayIteratorMethod$3);

	var classof$g = classof$m;
	var getMethod$7 = getMethod$9;
	var isNullOrUndefined$b = isNullOrUndefined$e;
	var Iterators$3 = iterators;
	var wellKnownSymbol$p = wellKnownSymbol$z;
	var ITERATOR$9 = wellKnownSymbol$p('iterator');
	var getIteratorMethod$5 = function getIteratorMethod(it) {
	  if (!isNullOrUndefined$b(it)) return getMethod$7(it, ITERATOR$9) || getMethod$7(it, '@@iterator') || Iterators$3[classof$g(it)];
	};
	var getIteratorMethod$6 = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethod$5);

	var call$v = functionCall;
	var aCallable$h = aCallable$l;
	var anObject$v = anObject$D;
	var tryToString$4 = tryToString$7;
	var getIteratorMethod$4 = getIteratorMethod$5;
	var $TypeError$i = TypeError;
	var getIterator$4 = function getIterator(argument, usingIterator) {
	  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$4(argument) : usingIterator;
	  if (aCallable$h(iteratorMethod)) return anObject$v(call$v(iteratorMethod, argument));
	  throw $TypeError$i(tryToString$4(argument) + ' is not iterable');
	};
	var getIterator$5 = /*@__PURE__*/getDefaultExportFromCjs(getIterator$4);

	var call$u = functionCall;
	var anObject$u = anObject$D;
	var getMethod$6 = getMethod$9;
	var iteratorClose$2 = function iteratorClose(iterator, kind, value) {
	  var innerResult, innerError;
	  anObject$u(iterator);
	  try {
	    innerResult = getMethod$6(iterator, 'return');
	    if (!innerResult) {
	      if (kind === 'throw') throw value;
	      return value;
	    }
	    innerResult = call$u(innerResult, iterator);
	  } catch (error) {
	    innerError = true;
	    innerResult = error;
	  }
	  if (kind === 'throw') throw value;
	  if (innerError) throw innerResult;
	  anObject$u(innerResult);
	  return value;
	};
	var iteratorClose$3 = /*@__PURE__*/getDefaultExportFromCjs(iteratorClose$2);

	var bind$c = functionBindContext;
	var call$t = functionCall;
	var anObject$t = anObject$D;
	var tryToString$3 = tryToString$7;
	var isArrayIteratorMethod$2 = isArrayIteratorMethod$3;
	var lengthOfArrayLike$p = lengthOfArrayLike$t;
	var isPrototypeOf$7 = objectIsPrototypeOf;
	var getIterator$3 = getIterator$4;
	var getIteratorMethod$3 = getIteratorMethod$5;
	var iteratorClose$1 = iteratorClose$2;
	var $TypeError$h = TypeError;
	var Result = function Result(stopped, result) {
	  this.stopped = stopped;
	  this.result = result;
	};
	var ResultPrototype = Result.prototype;
	var iterate$a = function iterate(iterable, unboundFunction, options) {
	  var that = options && options.that;
	  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
	  var IS_RECORD = !!(options && options.IS_RECORD);
	  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
	  var INTERRUPTED = !!(options && options.INTERRUPTED);
	  var fn = bind$c(unboundFunction, that);
	  var iterator, iterFn, index, length, result, next, step;
	  var stop = function stop(condition) {
	    if (iterator) iteratorClose$1(iterator, 'normal', condition);
	    return new Result(true, condition);
	  };
	  var callFn = function callFn(value) {
	    if (AS_ENTRIES) {
	      anObject$t(value);
	      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
	    }
	    return INTERRUPTED ? fn(value, stop) : fn(value);
	  };
	  if (IS_RECORD) {
	    iterator = iterable.iterator;
	  } else if (IS_ITERATOR) {
	    iterator = iterable;
	  } else {
	    iterFn = getIteratorMethod$3(iterable);
	    if (!iterFn) throw $TypeError$h(tryToString$3(iterable) + ' is not iterable');
	    // optimisation for array iterators
	    if (isArrayIteratorMethod$2(iterFn)) {
	      for (index = 0, length = lengthOfArrayLike$p(iterable); length > index; index++) {
	        result = callFn(iterable[index]);
	        if (result && isPrototypeOf$7(ResultPrototype, result)) return result;
	      }
	      return new Result(false);
	    }
	    iterator = getIterator$3(iterable, iterFn);
	  }
	  next = IS_RECORD ? iterable.next : iterator.next;
	  while (!(step = call$t(next, iterator)).done) {
	    try {
	      result = callFn(step.value);
	    } catch (error) {
	      iteratorClose$1(iterator, 'throw', error);
	    }
	    if (_typeof(result) == 'object' && result && isPrototypeOf$7(ResultPrototype, result)) return result;
	  }
	  return new Result(false);
	};
	var iterate$b = /*@__PURE__*/getDefaultExportFromCjs(iterate$a);

	'use strict';
	var $$2Q = _export;
	var isPrototypeOf$6 = objectIsPrototypeOf;
	var getPrototypeOf$a = objectGetPrototypeOf$1;
	var setPrototypeOf$7 = objectSetPrototypeOf$1;
	var copyConstructorProperties$1 = copyConstructorProperties$5;
	var create$a = objectCreate;
	var createNonEnumerableProperty$9 = createNonEnumerableProperty$f;
	var createPropertyDescriptor$6 = createPropertyDescriptor$c;
	var installErrorCause = installErrorCause$2;
	var installErrorStack = errorStackInstall;
	var iterate$9 = iterate$a;
	var normalizeStringArgument$2 = normalizeStringArgument$5;
	var wellKnownSymbol$o = wellKnownSymbol$z;
	var TO_STRING_TAG$2 = wellKnownSymbol$o('toStringTag');
	var $Error = Error;
	var push$a = [].push;
	var $AggregateError$1 = function AggregateError(errors, message /* , options */) {
	  var isInstance = isPrototypeOf$6(AggregateErrorPrototype, this);
	  var that;
	  if (setPrototypeOf$7) {
	    that = setPrototypeOf$7($Error(), isInstance ? getPrototypeOf$a(this) : AggregateErrorPrototype);
	  } else {
	    that = isInstance ? this : create$a(AggregateErrorPrototype);
	    createNonEnumerableProperty$9(that, TO_STRING_TAG$2, 'Error');
	  }
	  if (message !== undefined) createNonEnumerableProperty$9(that, 'message', normalizeStringArgument$2(message));
	  installErrorStack(that, $AggregateError$1, that.stack, 1);
	  if (arguments.length > 2) installErrorCause(that, arguments[2]);
	  var errorsArray = [];
	  iterate$9(errors, push$a, {
	    that: errorsArray
	  });
	  createNonEnumerableProperty$9(that, 'errors', errorsArray);
	  return that;
	};
	if (setPrototypeOf$7) setPrototypeOf$7($AggregateError$1, $Error);else copyConstructorProperties$1($AggregateError$1, $Error, {
	  name: true
	});
	var AggregateErrorPrototype = $AggregateError$1.prototype = create$a($Error.prototype, {
	  constructor: createPropertyDescriptor$6(1, $AggregateError$1),
	  message: createPropertyDescriptor$6(1, ''),
	  name: createPropertyDescriptor$6(1, 'AggregateError')
	});

	// `AggregateError` constructor
	// https://tc39.es/ecma262/#sec-aggregate-error-constructor
	$$2Q({
	  global: true,
	  constructor: true,
	  arity: 2
	}, {
	  AggregateError: $AggregateError$1
	});

	var es_aggregateError_cause = {};

	var $$2P = _export;
	var getBuiltIn$c = getBuiltIn$m;
	var apply$8 = functionApply$1;
	var fails$16 = fails$1m;
	var wrapErrorConstructorWithCause = wrapErrorConstructorWithCause$2;
	var AGGREGATE_ERROR = 'AggregateError';
	var $AggregateError = getBuiltIn$c(AGGREGATE_ERROR);
	var FORCED$B = !fails$16(function () {
	  return $AggregateError([1]).errors[0] !== 1;
	}) && fails$16(function () {
	  return $AggregateError([1], AGGREGATE_ERROR, {
	    cause: 7
	  }).cause !== 7;
	});

	// https://github.com/tc39/proposal-error-cause
	$$2P({
	  global: true,
	  constructor: true,
	  arity: 2,
	  forced: FORCED$B
	}, {
	  AggregateError: wrapErrorConstructorWithCause(AGGREGATE_ERROR, function (init) {
	    // eslint-disable-next-line no-unused-vars -- required for functions `.length`
	    return function AggregateError(errors, message) {
	      return apply$8(init, this, arguments);
	    };
	  }, FORCED$B, true)
	});

	var es_array_at = {};

	var wellKnownSymbol$n = wellKnownSymbol$z;
	var create$9 = objectCreate;
	var defineProperty$8 = objectDefineProperty.f;
	var UNSCOPABLES = wellKnownSymbol$n('unscopables');
	var ArrayPrototype = Array.prototype;

	// Array.prototype[@@unscopables]
	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	if (ArrayPrototype[UNSCOPABLES] == undefined) {
	  defineProperty$8(ArrayPrototype, UNSCOPABLES, {
	    configurable: true,
	    value: create$9(null)
	  });
	}

	// add a key to Array.prototype[@@unscopables]
	var addToUnscopables$e = function addToUnscopables(key) {
	  ArrayPrototype[UNSCOPABLES][key] = true;
	};
	var addToUnscopables$f = /*@__PURE__*/getDefaultExportFromCjs(addToUnscopables$e);

	'use strict';
	var $$2O = _export;
	var toObject$o = toObject$t;
	var lengthOfArrayLike$o = lengthOfArrayLike$t;
	var toIntegerOrInfinity$i = toIntegerOrInfinity$l;
	var addToUnscopables$d = addToUnscopables$e;

	// `Array.prototype.at` method
	// https://github.com/tc39/proposal-relative-indexing-method
	$$2O({
	  target: 'Array',
	  proto: true
	}, {
	  at: function at(index) {
	    var O = toObject$o(this);
	    var len = lengthOfArrayLike$o(O);
	    var relativeIndex = toIntegerOrInfinity$i(index);
	    var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
	    return k < 0 || k >= len ? undefined : O[k];
	  }
	});
	addToUnscopables$d('at');

	var es_array_concat = {};

	var $TypeError$g = TypeError;
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

	var doesNotExceedSafeInteger$6 = function doesNotExceedSafeInteger(it) {
	  if (it > MAX_SAFE_INTEGER) throw $TypeError$g('Maximum allowed index exceeded');
	  return it;
	};
	var doesNotExceedSafeInteger$7 = /*@__PURE__*/getDefaultExportFromCjs(doesNotExceedSafeInteger$6);

	var fails$15 = fails$1m;
	var wellKnownSymbol$m = wellKnownSymbol$z;
	var V8_VERSION$2 = engineV8Version;
	var SPECIES$5 = wellKnownSymbol$m('species');
	var arrayMethodHasSpeciesSupport$5 = function arrayMethodHasSpeciesSupport(METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return V8_VERSION$2 >= 51 || !fails$15(function () {
	    var array = [];
	    var constructor = array.constructor = {};
	    constructor[SPECIES$5] = function () {
	      return {
	        foo: 1
	      };
	    };
	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};
	var arrayMethodHasSpeciesSupport$6 = /*@__PURE__*/getDefaultExportFromCjs(arrayMethodHasSpeciesSupport$5);

	'use strict';
	var $$2N = _export;
	var fails$14 = fails$1m;
	var isArray$6 = isArray$9;
	var isObject$q = isObject$z;
	var toObject$n = toObject$t;
	var lengthOfArrayLike$n = lengthOfArrayLike$t;
	var doesNotExceedSafeInteger$5 = doesNotExceedSafeInteger$6;
	var createProperty$7 = createProperty$9;
	var arraySpeciesCreate$3 = arraySpeciesCreate$5;
	var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
	var wellKnownSymbol$l = wellKnownSymbol$z;
	var V8_VERSION$1 = engineV8Version;
	var IS_CONCAT_SPREADABLE = wellKnownSymbol$l('isConcatSpreadable');

	// We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679
	var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION$1 >= 51 || !fails$14(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});
	var isConcatSpreadable = function isConcatSpreadable(O) {
	  if (!isObject$q(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray$6(O);
	};
	var FORCED$A = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport$4('concat');

	// `Array.prototype.concat` method
	// https://tc39.es/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species
	$$2N({
	  target: 'Array',
	  proto: true,
	  arity: 1,
	  forced: FORCED$A
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  concat: function concat(arg) {
	    var O = toObject$n(this);
	    var A = arraySpeciesCreate$3(O, 0);
	    var n = 0;
	    var i, k, length, len, E;
	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];
	      if (isConcatSpreadable(E)) {
	        len = lengthOfArrayLike$n(E);
	        doesNotExceedSafeInteger$5(n + len);
	        for (k = 0; k < len; k++, n++) if (k in E) createProperty$7(A, n, E[k]);
	      } else {
	        doesNotExceedSafeInteger$5(n + 1);
	        createProperty$7(A, n++, E);
	      }
	    }
	    A.length = n;
	    return A;
	  }
	});

	var es_array_copyWithin = {};

	'use strict';
	var tryToString$2 = tryToString$7;
	var $TypeError$f = TypeError;
	var deletePropertyOrThrow$4 = function deletePropertyOrThrow(O, P) {
	  if (!delete O[P]) throw $TypeError$f('Cannot delete property ' + tryToString$2(P) + ' of ' + tryToString$2(O));
	};
	var deletePropertyOrThrow$5 = /*@__PURE__*/getDefaultExportFromCjs(deletePropertyOrThrow$4);

	'use strict';
	var toObject$m = toObject$t;
	var toAbsoluteIndex$7 = toAbsoluteIndex$a;
	var lengthOfArrayLike$m = lengthOfArrayLike$t;
	var deletePropertyOrThrow$3 = deletePropertyOrThrow$4;
	var min$c = Math.min;

	// `Array.prototype.copyWithin` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.copywithin
	// eslint-disable-next-line es/no-array-prototype-copywithin -- safe
	var arrayCopyWithin = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
	  var O = toObject$m(this);
	  var len = lengthOfArrayLike$m(O);
	  var to = toAbsoluteIndex$7(target, len);
	  var from = toAbsoluteIndex$7(start, len);
	  var end = arguments.length > 2 ? arguments[2] : undefined;
	  var count = min$c((end === undefined ? len : toAbsoluteIndex$7(end, len)) - from, len - to);
	  var inc = 1;
	  if (from < to && to < from + count) {
	    inc = -1;
	    from += count - 1;
	    to += count - 1;
	  }
	  while (count-- > 0) {
	    if (from in O) O[to] = O[from];else deletePropertyOrThrow$3(O, to);
	    to += inc;
	    from += inc;
	  }
	  return O;
	};
	var arrayCopyWithin$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayCopyWithin);

	var $$2M = _export;
	var copyWithin = arrayCopyWithin;
	var addToUnscopables$c = addToUnscopables$e;

	// `Array.prototype.copyWithin` method
	// https://tc39.es/ecma262/#sec-array.prototype.copywithin
	$$2M({
	  target: 'Array',
	  proto: true
	}, {
	  copyWithin: copyWithin
	});

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$c('copyWithin');

	var es_array_every = {};

	'use strict';
	var fails$13 = fails$1m;
	var arrayMethodIsStrict$9 = function arrayMethodIsStrict(METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails$13(function () {
	    // eslint-disable-next-line no-useless-call -- required for testing
	    method.call(null, argument || function () {
	      return 1;
	    }, 1);
	  });
	};
	var arrayMethodIsStrict$a = /*@__PURE__*/getDefaultExportFromCjs(arrayMethodIsStrict$9);

	'use strict';
	var $$2L = _export;
	var $every$1 = arrayIteration.every;
	var arrayMethodIsStrict$8 = arrayMethodIsStrict$9;
	var STRICT_METHOD$4 = arrayMethodIsStrict$8('every');

	// `Array.prototype.every` method
	// https://tc39.es/ecma262/#sec-array.prototype.every
	$$2L({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$4
	}, {
	  every: function every(callbackfn /* , thisArg */) {
	    return $every$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_fill = {};

	'use strict';
	var toObject$l = toObject$t;
	var toAbsoluteIndex$6 = toAbsoluteIndex$a;
	var lengthOfArrayLike$l = lengthOfArrayLike$t;

	// `Array.prototype.fill` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	var arrayFill$1 = function fill(value /* , start = 0, end = @length */) {
	  var O = toObject$l(this);
	  var length = lengthOfArrayLike$l(O);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex$6(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex$6(end, length);
	  while (endPos > index) O[index++] = value;
	  return O;
	};
	var arrayFill$2 = /*@__PURE__*/getDefaultExportFromCjs(arrayFill$1);

	var $$2K = _export;
	var fill$4 = arrayFill$1;
	var addToUnscopables$b = addToUnscopables$e;

	// `Array.prototype.fill` method
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	$$2K({
	  target: 'Array',
	  proto: true
	}, {
	  fill: fill$4
	});

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$b('fill');

	var es_array_filter = {};

	'use strict';
	var $$2J = _export;
	var $filter$1 = arrayIteration.filter;
	var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('filter');

	// `Array.prototype.filter` method
	// https://tc39.es/ecma262/#sec-array.prototype.filter
	// with adding support of @@species
	$$2J({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$3
	}, {
	  filter: function filter(callbackfn /* , thisArg */) {
	    return $filter$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_find = {};

	'use strict';
	var $$2I = _export;
	var $find$1 = arrayIteration.find;
	var addToUnscopables$a = addToUnscopables$e;
	var FIND = 'find';
	var SKIPS_HOLES$1 = true;

	// Shouldn't skip holes
	if (FIND in []) Array(1)[FIND](function () {
	  SKIPS_HOLES$1 = false;
	});

	// `Array.prototype.find` method
	// https://tc39.es/ecma262/#sec-array.prototype.find
	$$2I({
	  target: 'Array',
	  proto: true,
	  forced: SKIPS_HOLES$1
	}, {
	  find: function find(callbackfn /* , that = undefined */) {
	    return $find$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$a(FIND);

	var es_array_findIndex = {};

	'use strict';
	var $$2H = _export;
	var $findIndex$1 = arrayIteration.findIndex;
	var addToUnscopables$9 = addToUnscopables$e;
	var FIND_INDEX = 'findIndex';
	var SKIPS_HOLES = true;

	// Shouldn't skip holes
	if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () {
	  SKIPS_HOLES = false;
	});

	// `Array.prototype.findIndex` method
	// https://tc39.es/ecma262/#sec-array.prototype.findindex
	$$2H({
	  target: 'Array',
	  proto: true,
	  forced: SKIPS_HOLES
	}, {
	  findIndex: function findIndex(callbackfn /* , that = undefined */) {
	    return $findIndex$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$9(FIND_INDEX);

	var es_array_findLast = {};

	var bind$b = functionBindContext;
	var IndexedObject$3 = indexedObject;
	var toObject$k = toObject$t;
	var lengthOfArrayLike$k = lengthOfArrayLike$t;

	// `Array.prototype.{ findLast, findLastIndex }` methods implementation
	var createMethod$5 = function createMethod(TYPE) {
	  var IS_FIND_LAST_INDEX = TYPE == 1;
	  return function ($this, callbackfn, that) {
	    var O = toObject$k($this);
	    var self = IndexedObject$3(O);
	    var boundFunction = bind$b(callbackfn, that);
	    var index = lengthOfArrayLike$k(self);
	    var value, result;
	    while (index-- > 0) {
	      value = self[index];
	      result = boundFunction(value, index, O);
	      if (result) switch (TYPE) {
	        case 0:
	          return value;
	        // findLast
	        case 1:
	          return index;
	        // findLastIndex
	      }
	    }

	    return IS_FIND_LAST_INDEX ? -1 : undefined;
	  };
	};
	var arrayIterationFromLast = {
	  // `Array.prototype.findLast` method
	  // https://github.com/tc39/proposal-array-find-from-last
	  findLast: createMethod$5(0),
	  // `Array.prototype.findLastIndex` method
	  // https://github.com/tc39/proposal-array-find-from-last
	  findLastIndex: createMethod$5(1)
	};
	var arrayIterationFromLast$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayIterationFromLast);

	'use strict';
	var $$2G = _export;
	var $findLast$1 = arrayIterationFromLast.findLast;
	var addToUnscopables$8 = addToUnscopables$e;

	// `Array.prototype.findLast` method
	// https://github.com/tc39/proposal-array-find-from-last
	$$2G({
	  target: 'Array',
	  proto: true
	}, {
	  findLast: function findLast(callbackfn /* , that = undefined */) {
	    return $findLast$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	addToUnscopables$8('findLast');

	var es_array_findLastIndex = {};

	'use strict';
	var $$2F = _export;
	var $findLastIndex$1 = arrayIterationFromLast.findLastIndex;
	var addToUnscopables$7 = addToUnscopables$e;

	// `Array.prototype.findLastIndex` method
	// https://github.com/tc39/proposal-array-find-from-last
	$$2F({
	  target: 'Array',
	  proto: true
	}, {
	  findLastIndex: function findLastIndex(callbackfn /* , that = undefined */) {
	    return $findLastIndex$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	addToUnscopables$7('findLastIndex');

	var es_array_flat = {};

	'use strict';
	var isArray$5 = isArray$9;
	var lengthOfArrayLike$j = lengthOfArrayLike$t;
	var doesNotExceedSafeInteger$4 = doesNotExceedSafeInteger$6;
	var bind$a = functionBindContext;

	// `FlattenIntoArray` abstract operation
	// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
	var flattenIntoArray$2 = function flattenIntoArray(target, original, source, sourceLen, start, depth, mapper, thisArg) {
	  var targetIndex = start;
	  var sourceIndex = 0;
	  var mapFn = mapper ? bind$a(mapper, thisArg) : false;
	  var element, elementLen;
	  while (sourceIndex < sourceLen) {
	    if (sourceIndex in source) {
	      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];
	      if (depth > 0 && isArray$5(element)) {
	        elementLen = lengthOfArrayLike$j(element);
	        targetIndex = flattenIntoArray(target, original, element, elementLen, targetIndex, depth - 1) - 1;
	      } else {
	        doesNotExceedSafeInteger$4(targetIndex + 1);
	        target[targetIndex] = element;
	      }
	      targetIndex++;
	    }
	    sourceIndex++;
	  }
	  return targetIndex;
	};
	var flattenIntoArray_1 = flattenIntoArray$2;
	var flattenIntoArray$3 = /*@__PURE__*/getDefaultExportFromCjs(flattenIntoArray_1);

	'use strict';
	var $$2E = _export;
	var flattenIntoArray$1 = flattenIntoArray_1;
	var toObject$j = toObject$t;
	var lengthOfArrayLike$i = lengthOfArrayLike$t;
	var toIntegerOrInfinity$h = toIntegerOrInfinity$l;
	var arraySpeciesCreate$2 = arraySpeciesCreate$5;

	// `Array.prototype.flat` method
	// https://tc39.es/ecma262/#sec-array.prototype.flat
	$$2E({
	  target: 'Array',
	  proto: true
	}, {
	  flat: function flat( /* depthArg = 1 */
	  ) {
	    var depthArg = arguments.length ? arguments[0] : undefined;
	    var O = toObject$j(this);
	    var sourceLen = lengthOfArrayLike$i(O);
	    var A = arraySpeciesCreate$2(O, 0);
	    A.length = flattenIntoArray$1(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toIntegerOrInfinity$h(depthArg));
	    return A;
	  }
	});

	var es_array_flatMap = {};

	'use strict';
	var $$2D = _export;
	var flattenIntoArray = flattenIntoArray_1;
	var aCallable$g = aCallable$l;
	var toObject$i = toObject$t;
	var lengthOfArrayLike$h = lengthOfArrayLike$t;
	var arraySpeciesCreate$1 = arraySpeciesCreate$5;

	// `Array.prototype.flatMap` method
	// https://tc39.es/ecma262/#sec-array.prototype.flatmap
	$$2D({
	  target: 'Array',
	  proto: true
	}, {
	  flatMap: function flatMap(callbackfn /* , thisArg */) {
	    var O = toObject$i(this);
	    var sourceLen = lengthOfArrayLike$h(O);
	    var A;
	    aCallable$g(callbackfn);
	    A = arraySpeciesCreate$1(O, 0);
	    A.length = flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    return A;
	  }
	});

	var es_array_forEach = {};

	'use strict';
	var $forEach$1 = arrayIteration.forEach;
	var arrayMethodIsStrict$7 = arrayMethodIsStrict$9;
	var STRICT_METHOD$3 = arrayMethodIsStrict$7('forEach');

	// `Array.prototype.forEach` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	var arrayForEach = !STRICT_METHOD$3 ? function forEach(callbackfn /* , thisArg */) {
	  return $forEach$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  // eslint-disable-next-line es/no-array-prototype-foreach -- safe
	} : [].forEach;
	var arrayForEach$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayForEach);

	'use strict';
	var $$2C = _export;
	var forEach$3 = arrayForEach;

	// `Array.prototype.forEach` method
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe
	$$2C({
	  target: 'Array',
	  proto: true,
	  forced: [].forEach != forEach$3
	}, {
	  forEach: forEach$3
	});

	var es_array_from = {};

	var anObject$s = anObject$D;
	var iteratorClose = iteratorClose$2;

	// call something on iterator step with safe closing on error
	var callWithSafeIterationClosing$1 = function callWithSafeIterationClosing(iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject$s(value)[0], value[1]) : fn(value);
	  } catch (error) {
	    iteratorClose(iterator, 'throw', error);
	  }
	};
	var callWithSafeIterationClosing$2 = /*@__PURE__*/getDefaultExportFromCjs(callWithSafeIterationClosing$1);

	'use strict';
	var bind$9 = functionBindContext;
	var call$s = functionCall;
	var toObject$h = toObject$t;
	var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
	var isArrayIteratorMethod$1 = isArrayIteratorMethod$3;
	var isConstructor$4 = isConstructor$6;
	var lengthOfArrayLike$g = lengthOfArrayLike$t;
	var createProperty$6 = createProperty$9;
	var getIterator$2 = getIterator$4;
	var getIteratorMethod$2 = getIteratorMethod$5;
	var $Array$7 = Array;

	// `Array.from` method implementation
	// https://tc39.es/ecma262/#sec-array.from
	var arrayFrom$1 = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
	  var O = toObject$h(arrayLike);
	  var IS_CONSTRUCTOR = isConstructor$4(this);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  if (mapping) mapfn = bind$9(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
	  var iteratorMethod = getIteratorMethod$2(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  // if the target is not iterable or it's an array with the default iterator - use a simple case
	  if (iteratorMethod && !(this === $Array$7 && isArrayIteratorMethod$1(iteratorMethod))) {
	    iterator = getIterator$2(O, iteratorMethod);
	    next = iterator.next;
	    result = IS_CONSTRUCTOR ? new this() : [];
	    for (; !(step = call$s(next, iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty$6(result, index, value);
	    }
	  } else {
	    length = lengthOfArrayLike$g(O);
	    result = IS_CONSTRUCTOR ? new this(length) : $Array$7(length);
	    for (; length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty$6(result, index, value);
	    }
	  }
	  result.length = index;
	  return result;
	};
	var arrayFrom$2 = /*@__PURE__*/getDefaultExportFromCjs(arrayFrom$1);

	var wellKnownSymbol$k = wellKnownSymbol$z;
	var ITERATOR$8 = wellKnownSymbol$k('iterator');
	var SAFE_CLOSING = false;
	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function next() {
	      return {
	        done: !!called++
	      };
	    },
	    'return': function _return() {
	      SAFE_CLOSING = true;
	    }
	  };
	  iteratorWithReturn[ITERATOR$8] = function () {
	    return this;
	  };
	  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
	  Array.from(iteratorWithReturn, function () {
	    throw 2;
	  });
	} catch (error) {/* empty */}
	var checkCorrectnessOfIteration$4 = function checkCorrectnessOfIteration(exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;
	  try {
	    var object = {};
	    object[ITERATOR$8] = function () {
	      return {
	        next: function next() {
	          return {
	            done: ITERATION_SUPPORT = true
	          };
	        }
	      };
	    };
	    exec(object);
	  } catch (error) {/* empty */}
	  return ITERATION_SUPPORT;
	};
	var checkCorrectnessOfIteration$5 = /*@__PURE__*/getDefaultExportFromCjs(checkCorrectnessOfIteration$4);

	var $$2B = _export;
	var from = arrayFrom$1;
	var checkCorrectnessOfIteration$3 = checkCorrectnessOfIteration$4;
	var INCORRECT_ITERATION = !checkCorrectnessOfIteration$3(function (iterable) {
	  // eslint-disable-next-line es/no-array-from -- required for testing
	  Array.from(iterable);
	});

	// `Array.from` method
	// https://tc39.es/ecma262/#sec-array.from
	$$2B({
	  target: 'Array',
	  stat: true,
	  forced: INCORRECT_ITERATION
	}, {
	  from: from
	});

	var es_array_includes = {};

	'use strict';
	var $$2A = _export;
	var $includes$1 = arrayIncludes.includes;
	var fails$12 = fails$1m;
	var addToUnscopables$6 = addToUnscopables$e;

	// FF99+ bug
	var BROKEN_ON_SPARSE = fails$12(function () {
	  // eslint-disable-next-line es/no-array-prototype-includes -- detection
	  return !Array(1).includes();
	});

	// `Array.prototype.includes` method
	// https://tc39.es/ecma262/#sec-array.prototype.includes
	$$2A({
	  target: 'Array',
	  proto: true,
	  forced: BROKEN_ON_SPARSE
	}, {
	  includes: function includes(el /* , fromIndex = 0 */) {
	    return $includes$1(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$6('includes');

	var es_array_indexOf = {};

	'use strict';
	/* eslint-disable es/no-array-prototype-indexof -- required for testing */
	var $$2z = _export;
	var uncurryThis$$ = functionUncurryThisClause;
	var $indexOf$1 = arrayIncludes.indexOf;
	var arrayMethodIsStrict$6 = arrayMethodIsStrict$9;
	var nativeIndexOf = uncurryThis$$([].indexOf);
	var NEGATIVE_ZERO$1 = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
	var FORCED$z = NEGATIVE_ZERO$1 || !arrayMethodIsStrict$6('indexOf');

	// `Array.prototype.indexOf` method
	// https://tc39.es/ecma262/#sec-array.prototype.indexof
	$$2z({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$z
	}, {
	  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
	    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
	    return NEGATIVE_ZERO$1
	    // convert -0 to +0
	    ? nativeIndexOf(this, searchElement, fromIndex) || 0 : $indexOf$1(this, searchElement, fromIndex);
	  }
	});

	var es_array_isArray = {};

	var $$2y = _export;
	var isArray$4 = isArray$9;

	// `Array.isArray` method
	// https://tc39.es/ecma262/#sec-array.isarray
	$$2y({
	  target: 'Array',
	  stat: true
	}, {
	  isArray: isArray$4
	});

	'use strict';
	var fails$11 = fails$1m;
	var isCallable$g = isCallable$z;
	var isObject$p = isObject$z;
	var create$8 = objectCreate;
	var getPrototypeOf$9 = objectGetPrototypeOf$1;
	var defineBuiltIn$h = defineBuiltIn$m;
	var wellKnownSymbol$j = wellKnownSymbol$z;
	var IS_PURE$h = isPure;
	var ITERATOR$7 = wellKnownSymbol$j('iterator');
	var BUGGY_SAFARI_ITERATORS$1 = false;

	// `%IteratorPrototype%` object
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
	var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;

	/* eslint-disable es/no-array-prototype-keys -- safe */
	if ([].keys) {
	  arrayIterator = [].keys();
	  // Safari 8 has buggy iterators w/o `next`
	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;else {
	    PrototypeOfArrayIteratorPrototype = getPrototypeOf$9(getPrototypeOf$9(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
	  }
	}
	var NEW_ITERATOR_PROTOTYPE = !isObject$p(IteratorPrototype$2) || fails$11(function () {
	  var test = {};
	  // FF44- legacy iterators case
	  return IteratorPrototype$2[ITERATOR$7].call(test) !== test;
	});
	if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {};else if (IS_PURE$h) IteratorPrototype$2 = create$8(IteratorPrototype$2);

	// `%IteratorPrototype%[@@iterator]()` method
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
	if (!isCallable$g(IteratorPrototype$2[ITERATOR$7])) {
	  defineBuiltIn$h(IteratorPrototype$2, ITERATOR$7, function () {
	    return this;
	  });
	}
	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype$2,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
	};
	var iteratorsCore$1 = /*@__PURE__*/getDefaultExportFromCjs(iteratorsCore);

	'use strict';
	var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
	var create$7 = objectCreate;
	var createPropertyDescriptor$5 = createPropertyDescriptor$c;
	var setToStringTag$a = setToStringTag$d;
	var Iterators$2 = iterators;
	var returnThis$1 = function returnThis() {
	  return this;
	};
	var iteratorCreateConstructor = function iteratorCreateConstructor(IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = create$7(IteratorPrototype$1, {
	    next: createPropertyDescriptor$5(+!ENUMERABLE_NEXT, next)
	  });
	  setToStringTag$a(IteratorConstructor, TO_STRING_TAG, false, true);
	  Iterators$2[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};
	var iteratorCreateConstructor$1 = /*@__PURE__*/getDefaultExportFromCjs(iteratorCreateConstructor);

	'use strict';
	var $$2x = _export;
	var call$r = functionCall;
	var IS_PURE$g = isPure;
	var FunctionName$1 = functionName;
	var isCallable$f = isCallable$z;
	var createIteratorConstructor$2 = iteratorCreateConstructor;
	var getPrototypeOf$8 = objectGetPrototypeOf$1;
	var setPrototypeOf$6 = objectSetPrototypeOf$1;
	var setToStringTag$9 = setToStringTag$d;
	var createNonEnumerableProperty$8 = createNonEnumerableProperty$f;
	var defineBuiltIn$g = defineBuiltIn$m;
	var wellKnownSymbol$i = wellKnownSymbol$z;
	var Iterators$1 = iterators;
	var IteratorsCore = iteratorsCore;
	var PROPER_FUNCTION_NAME$3 = FunctionName$1.PROPER;
	var CONFIGURABLE_FUNCTION_NAME$1 = FunctionName$1.CONFIGURABLE;
	var IteratorPrototype = IteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$6 = wellKnownSymbol$i('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';
	var returnThis = function returnThis() {
	  return this;
	};
	var iteratorDefine = function iteratorDefine(Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor$2(IteratorConstructor, NAME, next);
	  var getIterationMethod = function getIterationMethod(KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
	    switch (KIND) {
	      case KEYS:
	        return function keys() {
	          return new IteratorConstructor(this, KIND);
	        };
	      case VALUES:
	        return function values() {
	          return new IteratorConstructor(this, KIND);
	        };
	      case ENTRIES:
	        return function entries() {
	          return new IteratorConstructor(this, KIND);
	        };
	    }
	    return function () {
	      return new IteratorConstructor(this);
	    };
	  };
	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$6] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY;

	  // fix native
	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = getPrototypeOf$8(anyNativeIterator.call(new Iterable()));
	    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
	      if (!IS_PURE$g && getPrototypeOf$8(CurrentIteratorPrototype) !== IteratorPrototype) {
	        if (setPrototypeOf$6) {
	          setPrototypeOf$6(CurrentIteratorPrototype, IteratorPrototype);
	        } else if (!isCallable$f(CurrentIteratorPrototype[ITERATOR$6])) {
	          defineBuiltIn$g(CurrentIteratorPrototype, ITERATOR$6, returnThis);
	        }
	      }
	      // Set @@toStringTag to native iterators
	      setToStringTag$9(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      if (IS_PURE$g) Iterators$1[TO_STRING_TAG] = returnThis;
	    }
	  }

	  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
	  if (PROPER_FUNCTION_NAME$3 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    if (!IS_PURE$g && CONFIGURABLE_FUNCTION_NAME$1) {
	      createNonEnumerableProperty$8(IterablePrototype, 'name', VALUES);
	    } else {
	      INCORRECT_VALUES_NAME = true;
	      defaultIterator = function values() {
	        return call$r(nativeIterator, this);
	      };
	    }
	  }

	  // export additional methods
	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        defineBuiltIn$g(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else $$2x({
	      target: NAME,
	      proto: true,
	      forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
	    }, methods);
	  }

	  // define iterator
	  if ((!IS_PURE$g || FORCED) && IterablePrototype[ITERATOR$6] !== defaultIterator) {
	    defineBuiltIn$g(IterablePrototype, ITERATOR$6, defaultIterator, {
	      name: DEFAULT
	    });
	  }
	  Iterators$1[NAME] = defaultIterator;
	  return methods;
	};
	var iteratorDefine$1 = /*@__PURE__*/getDefaultExportFromCjs(iteratorDefine);

	// `CreateIterResultObject` abstract operation
	// https://tc39.es/ecma262/#sec-createiterresultobject
	var createIterResultObject$4 = function createIterResultObject(value, done) {
	  return {
	    value: value,
	    done: done
	  };
	};
	var createIterResultObject$5 = /*@__PURE__*/getDefaultExportFromCjs(createIterResultObject$4);

	'use strict';
	var toIndexedObject$c = toIndexedObject$j;
	var addToUnscopables$5 = addToUnscopables$e;
	var Iterators = iterators;
	var InternalStateModule$b = internalState;
	var defineProperty$7 = objectDefineProperty.f;
	var defineIterator$2 = iteratorDefine;
	var createIterResultObject$3 = createIterResultObject$4;
	var IS_PURE$f = isPure;
	var DESCRIPTORS$x = descriptors;
	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$a = InternalStateModule$b.set;
	var getInternalState$8 = InternalStateModule$b.getterFor(ARRAY_ITERATOR);

	// `Array.prototype.entries` method
	// https://tc39.es/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.es/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.es/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.es/ecma262/#sec-createarrayiterator
	var es_array_iterator = defineIterator$2(Array, 'Array', function (iterated, kind) {
	  setInternalState$a(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject$c(iterated),
	    // target
	    index: 0,
	    // next index
	    kind: kind // kind
	  });
	  // `%ArrayIteratorPrototype%.next` method
	  // https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$8(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;
	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return createIterResultObject$3(undefined, true);
	  }
	  if (kind == 'keys') return createIterResultObject$3(index, false);
	  if (kind == 'values') return createIterResultObject$3(target[index], false);
	  return createIterResultObject$3([index, target[index]], false);
	}, 'values');

	// argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.es/ecma262/#sec-createmappedargumentsobject
	var values = Iterators.Arguments = Iterators.Array;

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$5('keys');
	addToUnscopables$5('values');
	addToUnscopables$5('entries');

	// V8 ~ Chrome 45- bug
	if (!IS_PURE$f && DESCRIPTORS$x && values.name !== 'values') try {
	  defineProperty$7(values, 'name', {
	    value: 'values'
	  });
	} catch (error) {/* empty */}
	var es_array_iterator$1 = /*@__PURE__*/getDefaultExportFromCjs(es_array_iterator);

	var es_array_join = {};

	'use strict';
	var $$2w = _export;
	var uncurryThis$_ = functionUncurryThis;
	var IndexedObject$2 = indexedObject;
	var toIndexedObject$b = toIndexedObject$j;
	var arrayMethodIsStrict$5 = arrayMethodIsStrict$9;
	var nativeJoin = uncurryThis$_([].join);
	var ES3_STRINGS = IndexedObject$2 != Object;
	var FORCED$y = ES3_STRINGS || !arrayMethodIsStrict$5('join', ',');

	// `Array.prototype.join` method
	// https://tc39.es/ecma262/#sec-array.prototype.join
	$$2w({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$y
	}, {
	  join: function join(separator) {
	    return nativeJoin(toIndexedObject$b(this), separator === undefined ? ',' : separator);
	  }
	});

	var es_array_lastIndexOf = {};

	'use strict';
	/* eslint-disable es/no-array-prototype-lastindexof -- safe */
	var apply$7 = functionApply$1;
	var toIndexedObject$a = toIndexedObject$j;
	var toIntegerOrInfinity$g = toIntegerOrInfinity$l;
	var lengthOfArrayLike$f = lengthOfArrayLike$t;
	var arrayMethodIsStrict$4 = arrayMethodIsStrict$9;
	var min$b = Math.min;
	var $lastIndexOf$1 = [].lastIndexOf;
	var NEGATIVE_ZERO = !!$lastIndexOf$1 && 1 / [1].lastIndexOf(1, -0) < 0;
	var STRICT_METHOD$2 = arrayMethodIsStrict$4('lastIndexOf');
	var FORCED$x = NEGATIVE_ZERO || !STRICT_METHOD$2;

	// `Array.prototype.lastIndexOf` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.lastindexof
	var arrayLastIndexOf = FORCED$x ? function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {
	  // convert -0 to +0
	  if (NEGATIVE_ZERO) return apply$7($lastIndexOf$1, this, arguments) || 0;
	  var O = toIndexedObject$a(this);
	  var length = lengthOfArrayLike$f(O);
	  var index = length - 1;
	  if (arguments.length > 1) index = min$b(index, toIntegerOrInfinity$g(arguments[1]));
	  if (index < 0) index = length + index;
	  for (; index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
	  return -1;
	} : $lastIndexOf$1;
	var arrayLastIndexOf$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayLastIndexOf);

	var $$2v = _export;
	var lastIndexOf = arrayLastIndexOf;

	// `Array.prototype.lastIndexOf` method
	// https://tc39.es/ecma262/#sec-array.prototype.lastindexof
	// eslint-disable-next-line es/no-array-prototype-lastindexof -- required for testing
	$$2v({
	  target: 'Array',
	  proto: true,
	  forced: lastIndexOf !== [].lastIndexOf
	}, {
	  lastIndexOf: lastIndexOf
	});

	var es_array_map = {};

	'use strict';
	var $$2u = _export;
	var $map$1 = arrayIteration.map;
	var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map');

	// `Array.prototype.map` method
	// https://tc39.es/ecma262/#sec-array.prototype.map
	// with adding support of @@species
	$$2u({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$2
	}, {
	  map: function map(callbackfn /* , thisArg */) {
	    return $map$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_of = {};

	'use strict';
	var $$2t = _export;
	var fails$10 = fails$1m;
	var isConstructor$3 = isConstructor$6;
	var createProperty$5 = createProperty$9;
	var $Array$6 = Array;
	var ISNT_GENERIC = fails$10(function () {
	  function F() {/* empty */}
	  // eslint-disable-next-line es/no-array-of -- safe
	  return !($Array$6.of.call(F) instanceof F);
	});

	// `Array.of` method
	// https://tc39.es/ecma262/#sec-array.of
	// WebKit Array.of isn't generic
	$$2t({
	  target: 'Array',
	  stat: true,
	  forced: ISNT_GENERIC
	}, {
	  of: function of( /* ...args */
	  ) {
	    var index = 0;
	    var argumentsLength = arguments.length;
	    var result = new (isConstructor$3(this) ? this : $Array$6)(argumentsLength);
	    while (argumentsLength > index) createProperty$5(result, index, arguments[index++]);
	    result.length = argumentsLength;
	    return result;
	  }
	});

	var es_array_push = {};

	'use strict';
	var DESCRIPTORS$w = descriptors;
	var isArray$3 = isArray$9;
	var $TypeError$e = TypeError;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor$8 = Object.getOwnPropertyDescriptor;

	// Safari < 13 does not throw an error in this case
	var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS$w && !function () {
	  // makes no sense without proper strict mode support
	  if (this !== undefined) return true;
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', {
	      writable: false
	    }).length = 1;
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	}();
	var arraySetLength = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
	  if (isArray$3(O) && !getOwnPropertyDescriptor$8(O, 'length').writable) {
	    throw $TypeError$e('Cannot set read only .length');
	  }
	  return O.length = length;
	} : function (O, length) {
	  return O.length = length;
	};
	var arraySetLength$1 = /*@__PURE__*/getDefaultExportFromCjs(arraySetLength);

	'use strict';
	var $$2s = _export;
	var toObject$g = toObject$t;
	var lengthOfArrayLike$e = lengthOfArrayLike$t;
	var setArrayLength$2 = arraySetLength;
	var doesNotExceedSafeInteger$3 = doesNotExceedSafeInteger$6;
	var fails$$ = fails$1m;
	var INCORRECT_TO_LENGTH = fails$$(function () {
	  return [].push.call({
	    length: 0x100000000
	  }, 1) !== 4294967297;
	});

	// V8 and Safari <= 15.4, FF < 23 throws InternalError
	// https://bugs.chromium.org/p/v8/issues/detail?id=12681
	var properErrorOnNonWritableLength$1 = function properErrorOnNonWritableLength() {
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', {
	      writable: false
	    }).push();
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	};
	var FORCED$w = INCORRECT_TO_LENGTH || !properErrorOnNonWritableLength$1();

	// `Array.prototype.push` method
	// https://tc39.es/ecma262/#sec-array.prototype.push
	$$2s({
	  target: 'Array',
	  proto: true,
	  arity: 1,
	  forced: FORCED$w
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  push: function push(item) {
	    var O = toObject$g(this);
	    var len = lengthOfArrayLike$e(O);
	    var argCount = arguments.length;
	    doesNotExceedSafeInteger$3(len + argCount);
	    for (var i = 0; i < argCount; i++) {
	      O[len] = arguments[i];
	      len++;
	    }
	    setArrayLength$2(O, len);
	    return len;
	  }
	});

	var es_array_reduce = {};

	var aCallable$f = aCallable$l;
	var toObject$f = toObject$t;
	var IndexedObject$1 = indexedObject;
	var lengthOfArrayLike$d = lengthOfArrayLike$t;
	var $TypeError$d = TypeError;

	// `Array.prototype.{ reduce, reduceRight }` methods implementation
	var createMethod$4 = function createMethod(IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aCallable$f(callbackfn);
	    var O = toObject$f(that);
	    var self = IndexedObject$1(O);
	    var length = lengthOfArrayLike$d(O);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }
	      index += i;
	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw $TypeError$d('Reduce of empty array with no initial value');
	      }
	    }
	    for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }
	    return memo;
	  };
	};
	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduce
	  left: createMethod$4(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
	  right: createMethod$4(true)
	};
	var arrayReduce$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayReduce);

	var classof$f = classofRaw$2;
	var engineIsNode = typeof process != 'undefined' && classof$f(process) == 'process';
	var engineIsNode$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsNode);

	'use strict';
	var $$2r = _export;
	var $reduce$1 = arrayReduce.left;
	var arrayMethodIsStrict$3 = arrayMethodIsStrict$9;
	var CHROME_VERSION$1 = engineV8Version;
	var IS_NODE$8 = engineIsNode;

	// Chrome 80-82 has a critical bug
	// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
	var CHROME_BUG$1 = !IS_NODE$8 && CHROME_VERSION$1 > 79 && CHROME_VERSION$1 < 83;
	var FORCED$v = CHROME_BUG$1 || !arrayMethodIsStrict$3('reduce');

	// `Array.prototype.reduce` method
	// https://tc39.es/ecma262/#sec-array.prototype.reduce
	$$2r({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$v
	}, {
	  reduce: function reduce(callbackfn /* , initialValue */) {
	    var length = arguments.length;
	    return $reduce$1(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_reduceRight = {};

	'use strict';
	var $$2q = _export;
	var $reduceRight$1 = arrayReduce.right;
	var arrayMethodIsStrict$2 = arrayMethodIsStrict$9;
	var CHROME_VERSION = engineV8Version;
	var IS_NODE$7 = engineIsNode;

	// Chrome 80-82 has a critical bug
	// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
	var CHROME_BUG = !IS_NODE$7 && CHROME_VERSION > 79 && CHROME_VERSION < 83;
	var FORCED$u = CHROME_BUG || !arrayMethodIsStrict$2('reduceRight');

	// `Array.prototype.reduceRight` method
	// https://tc39.es/ecma262/#sec-array.prototype.reduceright
	$$2q({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$u
	}, {
	  reduceRight: function reduceRight(callbackfn /* , initialValue */) {
	    return $reduceRight$1(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_reverse = {};

	'use strict';
	var $$2p = _export;
	var uncurryThis$Z = functionUncurryThis;
	var isArray$2 = isArray$9;
	var nativeReverse = uncurryThis$Z([].reverse);
	var test$1 = [1, 2];

	// `Array.prototype.reverse` method
	// https://tc39.es/ecma262/#sec-array.prototype.reverse
	// fix for Safari 12.0 bug
	// https://bugs.webkit.org/show_bug.cgi?id=188794
	$$2p({
	  target: 'Array',
	  proto: true,
	  forced: String(test$1) === String(test$1.reverse())
	}, {
	  reverse: function reverse() {
	    // eslint-disable-next-line no-self-assign -- dirty hack
	    if (isArray$2(this)) this.length = this.length;
	    return nativeReverse(this);
	  }
	});

	var es_array_slice = {};

	'use strict';
	var $$2o = _export;
	var isArray$1 = isArray$9;
	var isConstructor$2 = isConstructor$6;
	var isObject$o = isObject$z;
	var toAbsoluteIndex$5 = toAbsoluteIndex$a;
	var lengthOfArrayLike$c = lengthOfArrayLike$t;
	var toIndexedObject$9 = toIndexedObject$j;
	var createProperty$4 = createProperty$9;
	var wellKnownSymbol$h = wellKnownSymbol$z;
	var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;
	var nativeSlice = arraySlice$a;
	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('slice');
	var SPECIES$4 = wellKnownSymbol$h('species');
	var $Array$5 = Array;
	var max$9 = Math.max;

	// `Array.prototype.slice` method
	// https://tc39.es/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects
	$$2o({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$1
	}, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject$9(this);
	    var length = lengthOfArrayLike$c(O);
	    var k = toAbsoluteIndex$5(start, length);
	    var fin = toAbsoluteIndex$5(end === undefined ? length : end, length);
	    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
	    var Constructor, result, n;
	    if (isArray$1(O)) {
	      Constructor = O.constructor;
	      // cross-realm fallback
	      if (isConstructor$2(Constructor) && (Constructor === $Array$5 || isArray$1(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject$o(Constructor)) {
	        Constructor = Constructor[SPECIES$4];
	        if (Constructor === null) Constructor = undefined;
	      }
	      if (Constructor === $Array$5 || Constructor === undefined) {
	        return nativeSlice(O, k, fin);
	      }
	    }
	    result = new (Constructor === undefined ? $Array$5 : Constructor)(max$9(fin - k, 0));
	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$4(result, n, O[k]);
	    result.length = n;
	    return result;
	  }
	});

	var es_array_some = {};

	'use strict';
	var $$2n = _export;
	var $some$1 = arrayIteration.some;
	var arrayMethodIsStrict$1 = arrayMethodIsStrict$9;
	var STRICT_METHOD$1 = arrayMethodIsStrict$1('some');

	// `Array.prototype.some` method
	// https://tc39.es/ecma262/#sec-array.prototype.some
	$$2n({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$1
	}, {
	  some: function some(callbackfn /* , thisArg */) {
	    return $some$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_array_sort = {};

	var arraySlice$8 = arraySliceSimple;
	var floor$c = Math.floor;
	var mergeSort = function mergeSort(array, comparefn) {
	  var length = array.length;
	  var middle = floor$c(length / 2);
	  return length < 8 ? insertionSort(array, comparefn) : merge(array, mergeSort(arraySlice$8(array, 0, middle), comparefn), mergeSort(arraySlice$8(array, middle), comparefn), comparefn);
	};
	var insertionSort = function insertionSort(array, comparefn) {
	  var length = array.length;
	  var i = 1;
	  var element, j;
	  while (i < length) {
	    j = i;
	    element = array[i];
	    while (j && comparefn(array[j - 1], element) > 0) {
	      array[j] = array[--j];
	    }
	    if (j !== i++) array[j] = element;
	  }
	  return array;
	};
	var merge = function merge(array, left, right, comparefn) {
	  var llength = left.length;
	  var rlength = right.length;
	  var lindex = 0;
	  var rindex = 0;
	  while (lindex < llength || rindex < rlength) {
	    array[lindex + rindex] = lindex < llength && rindex < rlength ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++] : lindex < llength ? left[lindex++] : right[rindex++];
	  }
	  return array;
	};
	var arraySort$1 = mergeSort;
	var arraySort$2 = /*@__PURE__*/getDefaultExportFromCjs(arraySort$1);

	var userAgent$5 = engineUserAgent;
	var firefox = userAgent$5.match(/firefox\/(\d+)/i);
	var engineFfVersion = !!firefox && +firefox[1];
	var engineFfVersion$1 = /*@__PURE__*/getDefaultExportFromCjs(engineFfVersion);

	var UA = engineUserAgent;
	var engineIsIeOrEdge = /MSIE|Trident/.test(UA);
	var engineIsIeOrEdge$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsIeOrEdge);

	var userAgent$4 = engineUserAgent;
	var webkit = userAgent$4.match(/AppleWebKit\/(\d+)\./);
	var engineWebkitVersion = !!webkit && +webkit[1];
	var engineWebkitVersion$1 = /*@__PURE__*/getDefaultExportFromCjs(engineWebkitVersion);

	'use strict';
	var $$2m = _export;
	var uncurryThis$Y = functionUncurryThis;
	var aCallable$e = aCallable$l;
	var toObject$e = toObject$t;
	var lengthOfArrayLike$b = lengthOfArrayLike$t;
	var deletePropertyOrThrow$2 = deletePropertyOrThrow$4;
	var toString$s = toString$x;
	var fails$_ = fails$1m;
	var internalSort$1 = arraySort$1;
	var arrayMethodIsStrict = arrayMethodIsStrict$9;
	var FF$1 = engineFfVersion;
	var IE_OR_EDGE$1 = engineIsIeOrEdge;
	var V8$2 = engineV8Version;
	var WEBKIT$2 = engineWebkitVersion;
	var test = [];
	var nativeSort$1 = uncurryThis$Y(test.sort);
	var push$9 = uncurryThis$Y(test.push);

	// IE8-
	var FAILS_ON_UNDEFINED = fails$_(function () {
	  test.sort(undefined);
	});
	// V8 bug
	var FAILS_ON_NULL = fails$_(function () {
	  test.sort(null);
	});
	// Old WebKit
	var STRICT_METHOD = arrayMethodIsStrict('sort');
	var STABLE_SORT$1 = !fails$_(function () {
	  // feature detection can be too slow, so check engines versions
	  if (V8$2) return V8$2 < 70;
	  if (FF$1 && FF$1 > 3) return;
	  if (IE_OR_EDGE$1) return true;
	  if (WEBKIT$2) return WEBKIT$2 < 603;
	  var result = '';
	  var code, chr, value, index;

	  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
	  for (code = 65; code < 76; code++) {
	    chr = String.fromCharCode(code);
	    switch (code) {
	      case 66:
	      case 69:
	      case 70:
	      case 72:
	        value = 3;
	        break;
	      case 68:
	      case 71:
	        value = 4;
	        break;
	      default:
	        value = 2;
	    }
	    for (index = 0; index < 47; index++) {
	      test.push({
	        k: chr + index,
	        v: value
	      });
	    }
	  }
	  test.sort(function (a, b) {
	    return b.v - a.v;
	  });
	  for (index = 0; index < test.length; index++) {
	    chr = test[index].k.charAt(0);
	    if (result.charAt(result.length - 1) !== chr) result += chr;
	  }
	  return result !== 'DGBEFHACIJK';
	});
	var FORCED$t = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT$1;
	var getSortCompare$1 = function getSortCompare(comparefn) {
	  return function (x, y) {
	    if (y === undefined) return -1;
	    if (x === undefined) return 1;
	    if (comparefn !== undefined) return +comparefn(x, y) || 0;
	    return toString$s(x) > toString$s(y) ? 1 : -1;
	  };
	};

	// `Array.prototype.sort` method
	// https://tc39.es/ecma262/#sec-array.prototype.sort
	$$2m({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$t
	}, {
	  sort: function sort(comparefn) {
	    if (comparefn !== undefined) aCallable$e(comparefn);
	    var array = toObject$e(this);
	    if (STABLE_SORT$1) return comparefn === undefined ? nativeSort$1(array) : nativeSort$1(array, comparefn);
	    var items = [];
	    var arrayLength = lengthOfArrayLike$b(array);
	    var itemsLength, index;
	    for (index = 0; index < arrayLength; index++) {
	      if (index in array) push$9(items, array[index]);
	    }
	    internalSort$1(items, getSortCompare$1(comparefn));
	    itemsLength = lengthOfArrayLike$b(items);
	    index = 0;
	    while (index < itemsLength) array[index] = items[index++];
	    while (index < arrayLength) deletePropertyOrThrow$2(array, index++);
	    return array;
	  }
	});

	var es_array_species = {};

	'use strict';
	var getBuiltIn$b = getBuiltIn$m;
	var defineBuiltInAccessor$e = defineBuiltInAccessor$h;
	var wellKnownSymbol$g = wellKnownSymbol$z;
	var DESCRIPTORS$v = descriptors;
	var SPECIES$3 = wellKnownSymbol$g('species');
	var setSpecies$6 = function setSpecies(CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn$b(CONSTRUCTOR_NAME);
	  if (DESCRIPTORS$v && Constructor && !Constructor[SPECIES$3]) {
	    defineBuiltInAccessor$e(Constructor, SPECIES$3, {
	      configurable: true,
	      get: function get() {
	        return this;
	      }
	    });
	  }
	};
	var setSpecies$7 = /*@__PURE__*/getDefaultExportFromCjs(setSpecies$6);

	var setSpecies$5 = setSpecies$6;

	// `Array[@@species]` getter
	// https://tc39.es/ecma262/#sec-get-array-@@species
	setSpecies$5('Array');

	var es_array_splice = {};

	'use strict';
	var $$2l = _export;
	var toObject$d = toObject$t;
	var toAbsoluteIndex$4 = toAbsoluteIndex$a;
	var toIntegerOrInfinity$f = toIntegerOrInfinity$l;
	var lengthOfArrayLike$a = lengthOfArrayLike$t;
	var setArrayLength$1 = arraySetLength;
	var doesNotExceedSafeInteger$2 = doesNotExceedSafeInteger$6;
	var arraySpeciesCreate = arraySpeciesCreate$5;
	var createProperty$3 = createProperty$9;
	var deletePropertyOrThrow$1 = deletePropertyOrThrow$4;
	var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;
	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');
	var max$8 = Math.max;
	var min$a = Math.min;

	// `Array.prototype.splice` method
	// https://tc39.es/ecma262/#sec-array.prototype.splice
	// with adding support of @@species
	$$2l({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT
	}, {
	  splice: function splice(start, deleteCount /* , ...items */) {
	    var O = toObject$d(this);
	    var len = lengthOfArrayLike$a(O);
	    var actualStart = toAbsoluteIndex$4(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;
	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min$a(max$8(toIntegerOrInfinity$f(deleteCount), 0), len - actualStart);
	    }
	    doesNotExceedSafeInteger$2(len + insertCount - actualDeleteCount);
	    A = arraySpeciesCreate(O, actualDeleteCount);
	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty$3(A, k, O[from]);
	    }
	    A.length = actualDeleteCount;
	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];else deletePropertyOrThrow$1(O, to);
	      }
	      for (k = len; k > len - actualDeleteCount + insertCount; k--) deletePropertyOrThrow$1(O, k - 1);
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];else deletePropertyOrThrow$1(O, to);
	      }
	    }
	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }
	    setArrayLength$1(O, len - actualDeleteCount + insertCount);
	    return A;
	  }
	});

	var es_array_toReversed = {};

	var lengthOfArrayLike$9 = lengthOfArrayLike$t;

	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.toReversed
	// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.toReversed
	var arrayToReversed$2 = function arrayToReversed(O, C) {
	  var len = lengthOfArrayLike$9(O);
	  var A = new C(len);
	  var k = 0;
	  for (; k < len; k++) A[k] = O[len - k - 1];
	  return A;
	};
	var arrayToReversed$3 = /*@__PURE__*/getDefaultExportFromCjs(arrayToReversed$2);

	'use strict';
	var $$2k = _export;
	var arrayToReversed$1 = arrayToReversed$2;
	var toIndexedObject$8 = toIndexedObject$j;
	var addToUnscopables$4 = addToUnscopables$e;
	var $Array$4 = Array;

	// `Array.prototype.toReversed` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.toReversed
	$$2k({
	  target: 'Array',
	  proto: true
	}, {
	  toReversed: function toReversed() {
	    return arrayToReversed$1(toIndexedObject$8(this), $Array$4);
	  }
	});
	addToUnscopables$4('toReversed');

	var es_array_toSorted = {};

	var lengthOfArrayLike$8 = lengthOfArrayLike$t;
	var arrayFromConstructorAndList$3 = function arrayFromConstructorAndList(Constructor, list) {
	  var index = 0;
	  var length = lengthOfArrayLike$8(list);
	  var result = new Constructor(length);
	  while (length > index) result[index] = list[index++];
	  return result;
	};
	var arrayFromConstructorAndList$4 = /*@__PURE__*/getDefaultExportFromCjs(arrayFromConstructorAndList$3);

	var global$L = global$Z;
	var entryVirtual = function entryVirtual(CONSTRUCTOR) {
	  return global$L[CONSTRUCTOR].prototype;
	};
	var entryVirtual$1 = /*@__PURE__*/getDefaultExportFromCjs(entryVirtual);

	'use strict';
	var $$2j = _export;
	var uncurryThis$X = functionUncurryThis;
	var aCallable$d = aCallable$l;
	var toIndexedObject$7 = toIndexedObject$j;
	var arrayFromConstructorAndList$2 = arrayFromConstructorAndList$3;
	var getVirtual = entryVirtual;
	var addToUnscopables$3 = addToUnscopables$e;
	var $Array$3 = Array;
	var sort$1 = uncurryThis$X(getVirtual('Array').sort);

	// `Array.prototype.toSorted` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.toSorted
	$$2j({
	  target: 'Array',
	  proto: true
	}, {
	  toSorted: function toSorted(compareFn) {
	    if (compareFn !== undefined) aCallable$d(compareFn);
	    var O = toIndexedObject$7(this);
	    var A = arrayFromConstructorAndList$2($Array$3, O);
	    return sort$1(A, compareFn);
	  }
	});
	addToUnscopables$3('toSorted');

	var es_array_toSpliced = {};

	'use strict';
	var $$2i = _export;
	var addToUnscopables$2 = addToUnscopables$e;
	var doesNotExceedSafeInteger$1 = doesNotExceedSafeInteger$6;
	var lengthOfArrayLike$7 = lengthOfArrayLike$t;
	var toAbsoluteIndex$3 = toAbsoluteIndex$a;
	var toIndexedObject$6 = toIndexedObject$j;
	var toIntegerOrInfinity$e = toIntegerOrInfinity$l;
	var $Array$2 = Array;
	var max$7 = Math.max;
	var min$9 = Math.min;

	// `Array.prototype.toSpliced` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.toSpliced
	$$2i({
	  target: 'Array',
	  proto: true
	}, {
	  toSpliced: function toSpliced(start, deleteCount /* , ...items */) {
	    var O = toIndexedObject$6(this);
	    var len = lengthOfArrayLike$7(O);
	    var actualStart = toAbsoluteIndex$3(start, len);
	    var argumentsLength = arguments.length;
	    var k = 0;
	    var insertCount, actualDeleteCount, newLen, A;
	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min$9(max$7(toIntegerOrInfinity$e(deleteCount), 0), len - actualStart);
	    }
	    newLen = doesNotExceedSafeInteger$1(len + insertCount - actualDeleteCount);
	    A = $Array$2(newLen);
	    for (; k < actualStart; k++) A[k] = O[k];
	    for (; k < actualStart + insertCount; k++) A[k] = arguments[k - actualStart + 2];
	    for (; k < newLen; k++) A[k] = O[k + actualDeleteCount - insertCount];
	    return A;
	  }
	});
	addToUnscopables$2('toSpliced');

	var es_array_unscopables_flat = {};

	// this method was added to unscopables after implementation
	// in popular engines, so it's moved to a separate module
	var addToUnscopables$1 = addToUnscopables$e;

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables$1('flat');

	var es_array_unscopables_flatMap = {};

	// this method was added to unscopables after implementation
	// in popular engines, so it's moved to a separate module
	var addToUnscopables = addToUnscopables$e;

	// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
	addToUnscopables('flatMap');

	var es_array_unshift = {};

	'use strict';
	var $$2h = _export;
	var toObject$c = toObject$t;
	var lengthOfArrayLike$6 = lengthOfArrayLike$t;
	var setArrayLength = arraySetLength;
	var deletePropertyOrThrow = deletePropertyOrThrow$4;
	var doesNotExceedSafeInteger = doesNotExceedSafeInteger$6;

	// IE8-
	var INCORRECT_RESULT = [].unshift(0) !== 1;

	// V8 ~ Chrome < 71 and Safari <= 15.4, FF < 23 throws InternalError
	var properErrorOnNonWritableLength = function properErrorOnNonWritableLength() {
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', {
	      writable: false
	    }).unshift();
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	};
	var FORCED$s = INCORRECT_RESULT || !properErrorOnNonWritableLength();

	// `Array.prototype.unshift` method
	// https://tc39.es/ecma262/#sec-array.prototype.unshift
	$$2h({
	  target: 'Array',
	  proto: true,
	  arity: 1,
	  forced: FORCED$s
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  unshift: function unshift(item) {
	    var O = toObject$c(this);
	    var len = lengthOfArrayLike$6(O);
	    var argCount = arguments.length;
	    if (argCount) {
	      doesNotExceedSafeInteger(len + argCount);
	      var k = len;
	      while (k--) {
	        var to = k + argCount;
	        if (k in O) O[to] = O[k];else deletePropertyOrThrow(O, to);
	      }
	      for (var j = 0; j < argCount; j++) {
	        O[j] = arguments[j];
	      }
	    }
	    return setArrayLength(O, len + argCount);
	  }
	});

	var es_array_with = {};

	var lengthOfArrayLike$5 = lengthOfArrayLike$t;
	var toIntegerOrInfinity$d = toIntegerOrInfinity$l;
	var $RangeError$9 = RangeError;

	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.with
	// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.with
	var arrayWith$2 = function arrayWith(O, C, index, value) {
	  var len = lengthOfArrayLike$5(O);
	  var relativeIndex = toIntegerOrInfinity$d(index);
	  var actualIndex = relativeIndex < 0 ? len + relativeIndex : relativeIndex;
	  if (actualIndex >= len || actualIndex < 0) throw $RangeError$9('Incorrect index');
	  var A = new C(len);
	  var k = 0;
	  for (; k < len; k++) A[k] = k === actualIndex ? value : O[k];
	  return A;
	};
	var arrayWith$3 = /*@__PURE__*/getDefaultExportFromCjs(arrayWith$2);

	'use strict';
	var $$2g = _export;
	var arrayWith$1 = arrayWith$2;
	var toIndexedObject$5 = toIndexedObject$j;
	var $Array$1 = Array;

	// `Array.prototype.with` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.with
	$$2g({
	  target: 'Array',
	  proto: true
	}, {
	  'with': function _with(index, value) {
	    return arrayWith$1(toIndexedObject$5(this), $Array$1, index, value);
	  }
	});

	var es_arrayBuffer_constructor = {};

	// eslint-disable-next-line es/no-typed-arrays -- safe
	var arrayBufferBasicDetection = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';
	var arrayBufferBasicDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayBufferBasicDetection);

	var defineBuiltIn$f = defineBuiltIn$m;
	var defineBuiltIns$5 = function defineBuiltIns(target, src, options) {
	  for (var key in src) defineBuiltIn$f(target, key, src[key], options);
	  return target;
	};
	var defineBuiltIns$6 = /*@__PURE__*/getDefaultExportFromCjs(defineBuiltIns$5);

	var isPrototypeOf$5 = objectIsPrototypeOf;
	var $TypeError$c = TypeError;
	var anInstance$a = function anInstance(it, Prototype) {
	  if (isPrototypeOf$5(Prototype, it)) return it;
	  throw $TypeError$c('Incorrect invocation');
	};
	var anInstance$b = /*@__PURE__*/getDefaultExportFromCjs(anInstance$a);

	var toIntegerOrInfinity$c = toIntegerOrInfinity$l;
	var toLength$b = toLength$d;
	var $RangeError$8 = RangeError;

	// `ToIndex` abstract operation
	// https://tc39.es/ecma262/#sec-toindex
	var toIndex$2 = function toIndex(it) {
	  if (it === undefined) return 0;
	  var number = toIntegerOrInfinity$c(it);
	  var length = toLength$b(number);
	  if (number !== length) throw $RangeError$8('Wrong length or index');
	  return length;
	};
	var toIndex$3 = /*@__PURE__*/getDefaultExportFromCjs(toIndex$2);

	// IEEE754 conversions based on https://github.com/feross/ieee754
	var $Array = Array;
	var abs$b = Math.abs;
	var pow$9 = Math.pow;
	var floor$b = Math.floor;
	var log$c = Math.log;
	var LN2$2 = Math.LN2;
	var pack$2 = function pack(number, mantissaLength, bytes) {
	  var buffer = $Array(bytes);
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var rt = mantissaLength === 23 ? pow$9(2, -24) - pow$9(2, -77) : 0;
	  var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
	  var index = 0;
	  var exponent, mantissa, c;
	  number = abs$b(number);
	  // eslint-disable-next-line no-self-compare -- NaN check
	  if (number != number || number === Infinity) {
	    // eslint-disable-next-line no-self-compare -- NaN check
	    mantissa = number != number ? 1 : 0;
	    exponent = eMax;
	  } else {
	    exponent = floor$b(log$c(number) / LN2$2);
	    c = pow$9(2, -exponent);
	    if (number * c < 1) {
	      exponent--;
	      c *= 2;
	    }
	    if (exponent + eBias >= 1) {
	      number += rt / c;
	    } else {
	      number += rt * pow$9(2, 1 - eBias);
	    }
	    if (number * c >= 2) {
	      exponent++;
	      c /= 2;
	    }
	    if (exponent + eBias >= eMax) {
	      mantissa = 0;
	      exponent = eMax;
	    } else if (exponent + eBias >= 1) {
	      mantissa = (number * c - 1) * pow$9(2, mantissaLength);
	      exponent = exponent + eBias;
	    } else {
	      mantissa = number * pow$9(2, eBias - 1) * pow$9(2, mantissaLength);
	      exponent = 0;
	    }
	  }
	  while (mantissaLength >= 8) {
	    buffer[index++] = mantissa & 255;
	    mantissa /= 256;
	    mantissaLength -= 8;
	  }
	  exponent = exponent << mantissaLength | mantissa;
	  exponentLength += mantissaLength;
	  while (exponentLength > 0) {
	    buffer[index++] = exponent & 255;
	    exponent /= 256;
	    exponentLength -= 8;
	  }
	  buffer[--index] |= sign * 128;
	  return buffer;
	};
	var unpack$2 = function unpack(buffer, mantissaLength) {
	  var bytes = buffer.length;
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var nBits = exponentLength - 7;
	  var index = bytes - 1;
	  var sign = buffer[index--];
	  var exponent = sign & 127;
	  var mantissa;
	  sign >>= 7;
	  while (nBits > 0) {
	    exponent = exponent * 256 + buffer[index--];
	    nBits -= 8;
	  }
	  mantissa = exponent & (1 << -nBits) - 1;
	  exponent >>= -nBits;
	  nBits += mantissaLength;
	  while (nBits > 0) {
	    mantissa = mantissa * 256 + buffer[index--];
	    nBits -= 8;
	  }
	  if (exponent === 0) {
	    exponent = 1 - eBias;
	  } else if (exponent === eMax) {
	    return mantissa ? NaN : sign ? -Infinity : Infinity;
	  } else {
	    mantissa = mantissa + pow$9(2, mantissaLength);
	    exponent = exponent - eBias;
	  }
	  return (sign ? -1 : 1) * mantissa * pow$9(2, exponent - mantissaLength);
	};
	var ieee754 = {
	  pack: pack$2,
	  unpack: unpack$2
	};
	var ieee754$1 = /*@__PURE__*/getDefaultExportFromCjs(ieee754);

	'use strict';
	var global$K = global$Z;
	var uncurryThis$W = functionUncurryThis;
	var DESCRIPTORS$u = descriptors;
	var NATIVE_ARRAY_BUFFER$2 = arrayBufferBasicDetection;
	var FunctionName = functionName;
	var createNonEnumerableProperty$7 = createNonEnumerableProperty$f;
	var defineBuiltInAccessor$d = defineBuiltInAccessor$h;
	var defineBuiltIns$4 = defineBuiltIns$5;
	var fails$Z = fails$1m;
	var anInstance$9 = anInstance$a;
	var toIntegerOrInfinity$b = toIntegerOrInfinity$l;
	var toLength$a = toLength$d;
	var toIndex$1 = toIndex$2;
	var IEEE754 = ieee754;
	var getPrototypeOf$7 = objectGetPrototypeOf$1;
	var setPrototypeOf$5 = objectSetPrototypeOf$1;
	var getOwnPropertyNames$4 = objectGetOwnPropertyNames.f;
	var arrayFill = arrayFill$1;
	var arraySlice$7 = arraySliceSimple;
	var setToStringTag$8 = setToStringTag$d;
	var InternalStateModule$a = internalState;
	var PROPER_FUNCTION_NAME$2 = FunctionName.PROPER;
	var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
	var ARRAY_BUFFER$1 = 'ArrayBuffer';
	var DATA_VIEW = 'DataView';
	var PROTOTYPE = 'prototype';
	var WRONG_LENGTH$1 = 'Wrong length';
	var WRONG_INDEX = 'Wrong index';
	var getInternalArrayBufferState = InternalStateModule$a.getterFor(ARRAY_BUFFER$1);
	var getInternalDataViewState = InternalStateModule$a.getterFor(DATA_VIEW);
	var setInternalState$9 = InternalStateModule$a.set;
	var NativeArrayBuffer$1 = global$K[ARRAY_BUFFER$1];
	var $ArrayBuffer = NativeArrayBuffer$1;
	var ArrayBufferPrototype$1 = $ArrayBuffer && $ArrayBuffer[PROTOTYPE];
	var $DataView = global$K[DATA_VIEW];
	var DataViewPrototype$1 = $DataView && $DataView[PROTOTYPE];
	var ObjectPrototype$3 = Object.prototype;
	var Array$2 = global$K.Array;
	var RangeError$4 = global$K.RangeError;
	var fill$3 = uncurryThis$W(arrayFill);
	var reverse$3 = uncurryThis$W([].reverse);
	var packIEEE754 = IEEE754.pack;
	var unpackIEEE754 = IEEE754.unpack;
	var packInt8 = function packInt8(number) {
	  return [number & 0xFF];
	};
	var packInt16 = function packInt16(number) {
	  return [number & 0xFF, number >> 8 & 0xFF];
	};
	var packInt32 = function packInt32(number) {
	  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
	};
	var unpackInt32 = function unpackInt32(buffer) {
	  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
	};
	var packFloat32 = function packFloat32(number) {
	  return packIEEE754(number, 23, 4);
	};
	var packFloat64 = function packFloat64(number) {
	  return packIEEE754(number, 52, 8);
	};
	var addGetter$1 = function addGetter(Constructor, key, getInternalState) {
	  defineBuiltInAccessor$d(Constructor[PROTOTYPE], key, {
	    configurable: true,
	    get: function get() {
	      return getInternalState(this)[key];
	    }
	  });
	};
	var get$3 = function get(view, count, index, isLittleEndian) {
	  var intIndex = toIndex$1(index);
	  var store = getInternalDataViewState(view);
	  if (intIndex + count > store.byteLength) throw RangeError$4(WRONG_INDEX);
	  var bytes = store.bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = arraySlice$7(bytes, start, start + count);
	  return isLittleEndian ? pack : reverse$3(pack);
	};
	var set$2 = function set(view, count, index, conversion, value, isLittleEndian) {
	  var intIndex = toIndex$1(index);
	  var store = getInternalDataViewState(view);
	  if (intIndex + count > store.byteLength) throw RangeError$4(WRONG_INDEX);
	  var bytes = store.bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = conversion(+value);
	  for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
	};
	if (!NATIVE_ARRAY_BUFFER$2) {
	  $ArrayBuffer = function ArrayBuffer(length) {
	    anInstance$9(this, ArrayBufferPrototype$1);
	    var byteLength = toIndex$1(length);
	    setInternalState$9(this, {
	      type: ARRAY_BUFFER$1,
	      bytes: fill$3(Array$2(byteLength), 0),
	      byteLength: byteLength
	    });
	    if (!DESCRIPTORS$u) {
	      this.byteLength = byteLength;
	      this.detached = false;
	    }
	  };
	  ArrayBufferPrototype$1 = $ArrayBuffer[PROTOTYPE];
	  $DataView = function DataView(buffer, byteOffset, byteLength) {
	    anInstance$9(this, DataViewPrototype$1);
	    anInstance$9(buffer, ArrayBufferPrototype$1);
	    var bufferState = getInternalArrayBufferState(buffer);
	    var bufferLength = bufferState.byteLength;
	    var offset = toIntegerOrInfinity$b(byteOffset);
	    if (offset < 0 || offset > bufferLength) throw RangeError$4('Wrong offset');
	    byteLength = byteLength === undefined ? bufferLength - offset : toLength$a(byteLength);
	    if (offset + byteLength > bufferLength) throw RangeError$4(WRONG_LENGTH$1);
	    setInternalState$9(this, {
	      type: DATA_VIEW,
	      buffer: buffer,
	      byteLength: byteLength,
	      byteOffset: offset,
	      bytes: bufferState.bytes
	    });
	    if (!DESCRIPTORS$u) {
	      this.buffer = buffer;
	      this.byteLength = byteLength;
	      this.byteOffset = offset;
	    }
	  };
	  DataViewPrototype$1 = $DataView[PROTOTYPE];
	  if (DESCRIPTORS$u) {
	    addGetter$1($ArrayBuffer, 'byteLength', getInternalArrayBufferState);
	    addGetter$1($DataView, 'buffer', getInternalDataViewState);
	    addGetter$1($DataView, 'byteLength', getInternalDataViewState);
	    addGetter$1($DataView, 'byteOffset', getInternalDataViewState);
	  }
	  defineBuiltIns$4(DataViewPrototype$1, {
	    getInt8: function getInt8(byteOffset) {
	      return get$3(this, 1, byteOffset)[0] << 24 >> 24;
	    },
	    getUint8: function getUint8(byteOffset) {
	      return get$3(this, 1, byteOffset)[0];
	    },
	    getInt16: function getInt16(byteOffset /* , littleEndian */) {
	      var bytes = get$3(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
	    },
	    getUint16: function getUint16(byteOffset /* , littleEndian */) {
	      var bytes = get$3(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return bytes[1] << 8 | bytes[0];
	    },
	    getInt32: function getInt32(byteOffset /* , littleEndian */) {
	      return unpackInt32(get$3(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
	    },
	    getUint32: function getUint32(byteOffset /* , littleEndian */) {
	      return unpackInt32(get$3(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
	    },
	    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
	      return unpackIEEE754(get$3(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
	    },
	    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
	      return unpackIEEE754(get$3(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
	    },
	    setInt8: function setInt8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
	      set$2(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
	      set$2(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
	    }
	  });
	} else {
	  var INCORRECT_ARRAY_BUFFER_NAME = PROPER_FUNCTION_NAME$2 && NativeArrayBuffer$1.name !== ARRAY_BUFFER$1;
	  /* eslint-disable no-new -- required for testing */
	  if (!fails$Z(function () {
	    NativeArrayBuffer$1(1);
	  }) || !fails$Z(function () {
	    new NativeArrayBuffer$1(-1);
	  }) || fails$Z(function () {
	    new NativeArrayBuffer$1();
	    new NativeArrayBuffer$1(1.5);
	    new NativeArrayBuffer$1(NaN);
	    return NativeArrayBuffer$1.length != 1 || INCORRECT_ARRAY_BUFFER_NAME && !CONFIGURABLE_FUNCTION_NAME;
	  })) {
	    /* eslint-enable no-new -- required for testing */
	    $ArrayBuffer = function ArrayBuffer(length) {
	      anInstance$9(this, ArrayBufferPrototype$1);
	      return new NativeArrayBuffer$1(toIndex$1(length));
	    };
	    $ArrayBuffer[PROTOTYPE] = ArrayBufferPrototype$1;
	    for (var keys$1 = getOwnPropertyNames$4(NativeArrayBuffer$1), j = 0, key$2; keys$1.length > j;) {
	      if (!((key$2 = keys$1[j++]) in $ArrayBuffer)) {
	        createNonEnumerableProperty$7($ArrayBuffer, key$2, NativeArrayBuffer$1[key$2]);
	      }
	    }
	    ArrayBufferPrototype$1.constructor = $ArrayBuffer;
	  } else if (INCORRECT_ARRAY_BUFFER_NAME && CONFIGURABLE_FUNCTION_NAME) {
	    createNonEnumerableProperty$7(NativeArrayBuffer$1, 'name', ARRAY_BUFFER$1);
	  }

	  // WebKit bug - the same parent prototype for typed arrays and data view
	  if (setPrototypeOf$5 && getPrototypeOf$7(DataViewPrototype$1) !== ObjectPrototype$3) {
	    setPrototypeOf$5(DataViewPrototype$1, ObjectPrototype$3);
	  }

	  // iOS Safari 7.x bug
	  var testView = new $DataView(new $ArrayBuffer(2));
	  var $setInt8 = uncurryThis$W(DataViewPrototype$1.setInt8);
	  testView.setInt8(0, 2147483648);
	  testView.setInt8(1, 2147483649);
	  if (testView.getInt8(0) || !testView.getInt8(1)) defineBuiltIns$4(DataViewPrototype$1, {
	    setInt8: function setInt8(byteOffset, value) {
	      $setInt8(this, byteOffset, value << 24 >> 24);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      $setInt8(this, byteOffset, value << 24 >> 24);
	    }
	  }, {
	    unsafe: true
	  });
	}
	setToStringTag$8($ArrayBuffer, ARRAY_BUFFER$1);
	setToStringTag$8($DataView, DATA_VIEW);
	var arrayBuffer = {
	  ArrayBuffer: $ArrayBuffer,
	  DataView: $DataView
	};
	var arrayBuffer$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayBuffer);

	'use strict';
	var $$2f = _export;
	var global$J = global$Z;
	var arrayBufferModule = arrayBuffer;
	var setSpecies$4 = setSpecies$6;
	var ARRAY_BUFFER = 'ArrayBuffer';
	var ArrayBuffer$4 = arrayBufferModule[ARRAY_BUFFER];
	var NativeArrayBuffer = global$J[ARRAY_BUFFER];

	// `ArrayBuffer` constructor
	// https://tc39.es/ecma262/#sec-arraybuffer-constructor
	$$2f({
	  global: true,
	  constructor: true,
	  forced: NativeArrayBuffer !== ArrayBuffer$4
	}, {
	  ArrayBuffer: ArrayBuffer$4
	});
	setSpecies$4(ARRAY_BUFFER);

	var es_arrayBuffer_isView = {};

	'use strict';
	var NATIVE_ARRAY_BUFFER$1 = arrayBufferBasicDetection;
	var DESCRIPTORS$t = descriptors;
	var global$I = global$Z;
	var isCallable$e = isCallable$z;
	var isObject$n = isObject$z;
	var hasOwn$h = hasOwnProperty_1;
	var classof$e = classof$m;
	var tryToString$1 = tryToString$7;
	var createNonEnumerableProperty$6 = createNonEnumerableProperty$f;
	var defineBuiltIn$e = defineBuiltIn$m;
	var defineBuiltInAccessor$c = defineBuiltInAccessor$h;
	var isPrototypeOf$4 = objectIsPrototypeOf;
	var getPrototypeOf$6 = objectGetPrototypeOf$1;
	var setPrototypeOf$4 = objectSetPrototypeOf$1;
	var wellKnownSymbol$f = wellKnownSymbol$z;
	var uid$2 = uid$6;
	var InternalStateModule$9 = internalState;
	var enforceInternalState$3 = InternalStateModule$9.enforce;
	var getInternalState$7 = InternalStateModule$9.get;
	var Int8Array$4 = global$I.Int8Array;
	var Int8ArrayPrototype$1 = Int8Array$4 && Int8Array$4.prototype;
	var Uint8ClampedArray$1 = global$I.Uint8ClampedArray;
	var Uint8ClampedArrayPrototype = Uint8ClampedArray$1 && Uint8ClampedArray$1.prototype;
	var TypedArray$1 = Int8Array$4 && getPrototypeOf$6(Int8Array$4);
	var TypedArrayPrototype$2 = Int8ArrayPrototype$1 && getPrototypeOf$6(Int8ArrayPrototype$1);
	var ObjectPrototype$2 = Object.prototype;
	var TypeError$6 = global$I.TypeError;
	var TO_STRING_TAG$1 = wellKnownSymbol$f('toStringTag');
	var TYPED_ARRAY_TAG$1 = uid$2('TYPED_ARRAY_TAG');
	var TYPED_ARRAY_CONSTRUCTOR = 'TypedArrayConstructor';
	// Fixing native typed arrays in Opera Presto crashes the browser, see #595
	var NATIVE_ARRAY_BUFFER_VIEWS$3 = NATIVE_ARRAY_BUFFER$1 && !!setPrototypeOf$4 && classof$e(global$I.opera) !== 'Opera';
	var TYPED_ARRAY_TAG_REQUIRED = false;
	var NAME$1, Constructor, Prototype;
	var TypedArrayConstructorsList = {
	  Int8Array: 1,
	  Uint8Array: 1,
	  Uint8ClampedArray: 1,
	  Int16Array: 2,
	  Uint16Array: 2,
	  Int32Array: 4,
	  Uint32Array: 4,
	  Float32Array: 4,
	  Float64Array: 8
	};
	var BigIntArrayConstructorsList = {
	  BigInt64Array: 8,
	  BigUint64Array: 8
	};
	var isView = function isView(it) {
	  if (!isObject$n(it)) return false;
	  var klass = classof$e(it);
	  return klass === 'DataView' || hasOwn$h(TypedArrayConstructorsList, klass) || hasOwn$h(BigIntArrayConstructorsList, klass);
	};
	var getTypedArrayConstructor$4 = function getTypedArrayConstructor(it) {
	  var proto = getPrototypeOf$6(it);
	  if (!isObject$n(proto)) return;
	  var state = getInternalState$7(proto);
	  return state && hasOwn$h(state, TYPED_ARRAY_CONSTRUCTOR) ? state[TYPED_ARRAY_CONSTRUCTOR] : getTypedArrayConstructor(proto);
	};
	var isTypedArray$2 = function isTypedArray(it) {
	  if (!isObject$n(it)) return false;
	  var klass = classof$e(it);
	  return hasOwn$h(TypedArrayConstructorsList, klass) || hasOwn$h(BigIntArrayConstructorsList, klass);
	};
	var aTypedArray$s = function aTypedArray(it) {
	  if (isTypedArray$2(it)) return it;
	  throw TypeError$6('Target is not a typed array');
	};
	var aTypedArrayConstructor$4 = function aTypedArrayConstructor(C) {
	  if (isCallable$e(C) && (!setPrototypeOf$4 || isPrototypeOf$4(TypedArray$1, C))) return C;
	  throw TypeError$6(tryToString$1(C) + ' is not a typed array constructor');
	};
	var exportTypedArrayMethod$t = function exportTypedArrayMethod(KEY, property, forced, options) {
	  if (!DESCRIPTORS$t) return;
	  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
	    var TypedArrayConstructor = global$I[ARRAY];
	    if (TypedArrayConstructor && hasOwn$h(TypedArrayConstructor.prototype, KEY)) try {
	      delete TypedArrayConstructor.prototype[KEY];
	    } catch (error) {
	      // old WebKit bug - some methods are non-configurable
	      try {
	        TypedArrayConstructor.prototype[KEY] = property;
	      } catch (error2) {/* empty */}
	    }
	  }
	  if (!TypedArrayPrototype$2[KEY] || forced) {
	    defineBuiltIn$e(TypedArrayPrototype$2, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS$3 && Int8ArrayPrototype$1[KEY] || property, options);
	  }
	};
	var exportTypedArrayStaticMethod$2 = function exportTypedArrayStaticMethod(KEY, property, forced) {
	  var ARRAY, TypedArrayConstructor;
	  if (!DESCRIPTORS$t) return;
	  if (setPrototypeOf$4) {
	    if (forced) for (ARRAY in TypedArrayConstructorsList) {
	      TypedArrayConstructor = global$I[ARRAY];
	      if (TypedArrayConstructor && hasOwn$h(TypedArrayConstructor, KEY)) try {
	        delete TypedArrayConstructor[KEY];
	      } catch (error) {/* empty */}
	    }
	    if (!TypedArray$1[KEY] || forced) {
	      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
	      try {
	        return defineBuiltIn$e(TypedArray$1, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS$3 && TypedArray$1[KEY] || property);
	      } catch (error) {/* empty */}
	    } else return;
	  }
	  for (ARRAY in TypedArrayConstructorsList) {
	    TypedArrayConstructor = global$I[ARRAY];
	    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
	      defineBuiltIn$e(TypedArrayConstructor, KEY, property);
	    }
	  }
	};
	for (NAME$1 in TypedArrayConstructorsList) {
	  Constructor = global$I[NAME$1];
	  Prototype = Constructor && Constructor.prototype;
	  if (Prototype) enforceInternalState$3(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;else NATIVE_ARRAY_BUFFER_VIEWS$3 = false;
	}
	for (NAME$1 in BigIntArrayConstructorsList) {
	  Constructor = global$I[NAME$1];
	  Prototype = Constructor && Constructor.prototype;
	  if (Prototype) enforceInternalState$3(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
	}

	// WebKit bug - typed arrays constructors prototype is Object.prototype
	if (!NATIVE_ARRAY_BUFFER_VIEWS$3 || !isCallable$e(TypedArray$1) || TypedArray$1 === Function.prototype) {
	  // eslint-disable-next-line no-shadow -- safe
	  TypedArray$1 = function TypedArray() {
	    throw TypeError$6('Incorrect invocation');
	  };
	  if (NATIVE_ARRAY_BUFFER_VIEWS$3) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global$I[NAME$1]) setPrototypeOf$4(global$I[NAME$1], TypedArray$1);
	  }
	}
	if (!NATIVE_ARRAY_BUFFER_VIEWS$3 || !TypedArrayPrototype$2 || TypedArrayPrototype$2 === ObjectPrototype$2) {
	  TypedArrayPrototype$2 = TypedArray$1.prototype;
	  if (NATIVE_ARRAY_BUFFER_VIEWS$3) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global$I[NAME$1]) setPrototypeOf$4(global$I[NAME$1].prototype, TypedArrayPrototype$2);
	  }
	}

	// WebKit bug - one more object in Uint8ClampedArray prototype chain
	if (NATIVE_ARRAY_BUFFER_VIEWS$3 && getPrototypeOf$6(Uint8ClampedArrayPrototype) !== TypedArrayPrototype$2) {
	  setPrototypeOf$4(Uint8ClampedArrayPrototype, TypedArrayPrototype$2);
	}
	if (DESCRIPTORS$t && !hasOwn$h(TypedArrayPrototype$2, TO_STRING_TAG$1)) {
	  TYPED_ARRAY_TAG_REQUIRED = true;
	  defineBuiltInAccessor$c(TypedArrayPrototype$2, TO_STRING_TAG$1, {
	    configurable: true,
	    get: function get() {
	      return isObject$n(this) ? this[TYPED_ARRAY_TAG$1] : undefined;
	    }
	  });
	  for (NAME$1 in TypedArrayConstructorsList) if (global$I[NAME$1]) {
	    createNonEnumerableProperty$6(global$I[NAME$1], TYPED_ARRAY_TAG$1, NAME$1);
	  }
	}
	var arrayBufferViewCore = {
	  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS$3,
	  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG$1,
	  aTypedArray: aTypedArray$s,
	  aTypedArrayConstructor: aTypedArrayConstructor$4,
	  exportTypedArrayMethod: exportTypedArrayMethod$t,
	  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod$2,
	  getTypedArrayConstructor: getTypedArrayConstructor$4,
	  isView: isView,
	  isTypedArray: isTypedArray$2,
	  TypedArray: TypedArray$1,
	  TypedArrayPrototype: TypedArrayPrototype$2
	};
	var arrayBufferViewCore$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayBufferViewCore);

	var $$2e = _export;
	var ArrayBufferViewCore$v = arrayBufferViewCore;
	var NATIVE_ARRAY_BUFFER_VIEWS$2 = ArrayBufferViewCore$v.NATIVE_ARRAY_BUFFER_VIEWS;

	// `ArrayBuffer.isView` method
	// https://tc39.es/ecma262/#sec-arraybuffer.isview
	$$2e({
	  target: 'ArrayBuffer',
	  stat: true,
	  forced: !NATIVE_ARRAY_BUFFER_VIEWS$2
	}, {
	  isView: ArrayBufferViewCore$v.isView
	});

	var es_arrayBuffer_slice = {};

	var isConstructor$1 = isConstructor$6;
	var tryToString = tryToString$7;
	var $TypeError$b = TypeError;

	// `Assert: IsConstructor(argument) is true`
	var aConstructor$3 = function aConstructor(argument) {
	  if (isConstructor$1(argument)) return argument;
	  throw $TypeError$b(tryToString(argument) + ' is not a constructor');
	};
	var aConstructor$4 = /*@__PURE__*/getDefaultExportFromCjs(aConstructor$3);

	var anObject$r = anObject$D;
	var aConstructor$2 = aConstructor$3;
	var isNullOrUndefined$a = isNullOrUndefined$e;
	var wellKnownSymbol$e = wellKnownSymbol$z;
	var SPECIES$2 = wellKnownSymbol$e('species');

	// `SpeciesConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-speciesconstructor
	var speciesConstructor$6 = function speciesConstructor(O, defaultConstructor) {
	  var C = anObject$r(O).constructor;
	  var S;
	  return C === undefined || isNullOrUndefined$a(S = anObject$r(C)[SPECIES$2]) ? defaultConstructor : aConstructor$2(S);
	};
	var speciesConstructor$7 = /*@__PURE__*/getDefaultExportFromCjs(speciesConstructor$6);

	'use strict';
	var $$2d = _export;
	var uncurryThis$V = functionUncurryThisClause;
	var fails$Y = fails$1m;
	var ArrayBufferModule$2 = arrayBuffer;
	var anObject$q = anObject$D;
	var toAbsoluteIndex$2 = toAbsoluteIndex$a;
	var toLength$9 = toLength$d;
	var speciesConstructor$5 = speciesConstructor$6;
	var ArrayBuffer$3 = ArrayBufferModule$2.ArrayBuffer;
	var DataView$2 = ArrayBufferModule$2.DataView;
	var DataViewPrototype = DataView$2.prototype;
	var nativeArrayBufferSlice = uncurryThis$V(ArrayBuffer$3.prototype.slice);
	var getUint8 = uncurryThis$V(DataViewPrototype.getUint8);
	var setUint8 = uncurryThis$V(DataViewPrototype.setUint8);
	var INCORRECT_SLICE = fails$Y(function () {
	  return !new ArrayBuffer$3(2).slice(1, undefined).byteLength;
	});

	// `ArrayBuffer.prototype.slice` method
	// https://tc39.es/ecma262/#sec-arraybuffer.prototype.slice
	$$2d({
	  target: 'ArrayBuffer',
	  proto: true,
	  unsafe: true,
	  forced: INCORRECT_SLICE
	}, {
	  slice: function slice(start, end) {
	    if (nativeArrayBufferSlice && end === undefined) {
	      return nativeArrayBufferSlice(anObject$q(this), start); // FF fix
	    }

	    var length = anObject$q(this).byteLength;
	    var first = toAbsoluteIndex$2(start, length);
	    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length);
	    var result = new (speciesConstructor$5(this, ArrayBuffer$3))(toLength$9(fin - first));
	    var viewSource = new DataView$2(this);
	    var viewTarget = new DataView$2(result);
	    var index = 0;
	    while (first < fin) {
	      setUint8(viewTarget, index++, getUint8(viewSource, first++));
	    }
	    return result;
	  }
	});

	var es_dataView = {};

	var es_dataView_constructor = {};

	var $$2c = _export;
	var ArrayBufferModule$1 = arrayBuffer;
	var NATIVE_ARRAY_BUFFER = arrayBufferBasicDetection;

	// `DataView` constructor
	// https://tc39.es/ecma262/#sec-dataview-constructor
	$$2c({
	  global: true,
	  constructor: true,
	  forced: !NATIVE_ARRAY_BUFFER
	}, {
	  DataView: ArrayBufferModule$1.DataView
	});

	var es_date_getYear = {};

	'use strict';
	var $$2b = _export;
	var uncurryThis$U = functionUncurryThis;
	var fails$X = fails$1m;

	// IE8- non-standard case
	var FORCED$r = fails$X(function () {
	  // eslint-disable-next-line es/no-date-prototype-getyear-setyear -- detection
	  return new Date(16e11).getYear() !== 120;
	});
	var getFullYear = uncurryThis$U(Date.prototype.getFullYear);

	// `Date.prototype.getYear` method
	// https://tc39.es/ecma262/#sec-date.prototype.getyear
	$$2b({
	  target: 'Date',
	  proto: true,
	  forced: FORCED$r
	}, {
	  getYear: function getYear() {
	    return getFullYear(this) - 1900;
	  }
	});

	var es_date_now = {};

	// TODO: Remove from `core-js@4`
	var $$2a = _export;
	var uncurryThis$T = functionUncurryThis;
	var $Date = Date;
	var thisTimeValue$4 = uncurryThis$T($Date.prototype.getTime);

	// `Date.now` method
	// https://tc39.es/ecma262/#sec-date.now
	$$2a({
	  target: 'Date',
	  stat: true
	}, {
	  now: function now() {
	    return thisTimeValue$4(new $Date());
	  }
	});

	var es_date_setYear = {};

	'use strict';
	var $$29 = _export;
	var uncurryThis$S = functionUncurryThis;
	var toIntegerOrInfinity$a = toIntegerOrInfinity$l;
	var DatePrototype$3 = Date.prototype;
	var thisTimeValue$3 = uncurryThis$S(DatePrototype$3.getTime);
	var setFullYear = uncurryThis$S(DatePrototype$3.setFullYear);

	// `Date.prototype.setYear` method
	// https://tc39.es/ecma262/#sec-date.prototype.setyear
	$$29({
	  target: 'Date',
	  proto: true
	}, {
	  setYear: function setYear(year) {
	    // validate
	    thisTimeValue$3(this);
	    var yi = toIntegerOrInfinity$a(year);
	    var yyyy = 0 <= yi && yi <= 99 ? yi + 1900 : yi;
	    return setFullYear(this, yyyy);
	  }
	});

	var es_date_toGmtString = {};

	var $$28 = _export;

	// `Date.prototype.toGMTString` method
	// https://tc39.es/ecma262/#sec-date.prototype.togmtstring
	$$28({
	  target: 'Date',
	  proto: true
	}, {
	  toGMTString: Date.prototype.toUTCString
	});

	var es_date_toIsoString = {};

	'use strict';
	var toIntegerOrInfinity$9 = toIntegerOrInfinity$l;
	var toString$r = toString$x;
	var requireObjectCoercible$g = requireObjectCoercible$j;
	var $RangeError$7 = RangeError;

	// `String.prototype.repeat` method implementation
	// https://tc39.es/ecma262/#sec-string.prototype.repeat
	var stringRepeat = function repeat(count) {
	  var str = toString$r(requireObjectCoercible$g(this));
	  var result = '';
	  var n = toIntegerOrInfinity$9(count);
	  if (n < 0 || n == Infinity) throw $RangeError$7('Wrong number of repetitions');
	  for (; n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
	  return result;
	};
	var stringRepeat$1 = /*@__PURE__*/getDefaultExportFromCjs(stringRepeat);

	// https://github.com/tc39/proposal-string-pad-start-end
	var uncurryThis$R = functionUncurryThis;
	var toLength$8 = toLength$d;
	var toString$q = toString$x;
	var $repeat$2 = stringRepeat;
	var requireObjectCoercible$f = requireObjectCoercible$j;
	var repeat$4 = uncurryThis$R($repeat$2);
	var stringSlice$f = uncurryThis$R(''.slice);
	var ceil$3 = Math.ceil;

	// `String.prototype.{ padStart, padEnd }` methods implementation
	var createMethod$3 = function createMethod(IS_END) {
	  return function ($this, maxLength, fillString) {
	    var S = toString$q(requireObjectCoercible$f($this));
	    var intMaxLength = toLength$8(maxLength);
	    var stringLength = S.length;
	    var fillStr = fillString === undefined ? ' ' : toString$q(fillString);
	    var fillLen, stringFiller;
	    if (intMaxLength <= stringLength || fillStr == '') return S;
	    fillLen = intMaxLength - stringLength;
	    stringFiller = repeat$4(fillStr, ceil$3(fillLen / fillStr.length));
	    if (stringFiller.length > fillLen) stringFiller = stringSlice$f(stringFiller, 0, fillLen);
	    return IS_END ? S + stringFiller : stringFiller + S;
	  };
	};
	var stringPad = {
	  // `String.prototype.padStart` method
	  // https://tc39.es/ecma262/#sec-string.prototype.padstart
	  start: createMethod$3(false),
	  // `String.prototype.padEnd` method
	  // https://tc39.es/ecma262/#sec-string.prototype.padend
	  end: createMethod$3(true)
	};
	var stringPad$1 = /*@__PURE__*/getDefaultExportFromCjs(stringPad);

	'use strict';
	var uncurryThis$Q = functionUncurryThis;
	var fails$W = fails$1m;
	var padStart = stringPad.start;
	var $RangeError$6 = RangeError;
	var $isFinite$1 = isFinite;
	var abs$a = Math.abs;
	var DatePrototype$2 = Date.prototype;
	var nativeDateToISOString = DatePrototype$2.toISOString;
	var thisTimeValue$2 = uncurryThis$Q(DatePrototype$2.getTime);
	var getUTCDate = uncurryThis$Q(DatePrototype$2.getUTCDate);
	var getUTCFullYear = uncurryThis$Q(DatePrototype$2.getUTCFullYear);
	var getUTCHours = uncurryThis$Q(DatePrototype$2.getUTCHours);
	var getUTCMilliseconds = uncurryThis$Q(DatePrototype$2.getUTCMilliseconds);
	var getUTCMinutes = uncurryThis$Q(DatePrototype$2.getUTCMinutes);
	var getUTCMonth = uncurryThis$Q(DatePrototype$2.getUTCMonth);
	var getUTCSeconds = uncurryThis$Q(DatePrototype$2.getUTCSeconds);

	// `Date.prototype.toISOString` method implementation
	// https://tc39.es/ecma262/#sec-date.prototype.toisostring
	// PhantomJS / old WebKit fails here:
	var dateToIsoString = fails$W(function () {
	  return nativeDateToISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
	}) || !fails$W(function () {
	  nativeDateToISOString.call(new Date(NaN));
	}) ? function toISOString() {
	  if (!$isFinite$1(thisTimeValue$2(this))) throw $RangeError$6('Invalid time value');
	  var date = this;
	  var year = getUTCFullYear(date);
	  var milliseconds = getUTCMilliseconds(date);
	  var sign = year < 0 ? '-' : year > 9999 ? '+' : '';
	  return sign + padStart(abs$a(year), sign ? 6 : 4, 0) + '-' + padStart(getUTCMonth(date) + 1, 2, 0) + '-' + padStart(getUTCDate(date), 2, 0) + 'T' + padStart(getUTCHours(date), 2, 0) + ':' + padStart(getUTCMinutes(date), 2, 0) + ':' + padStart(getUTCSeconds(date), 2, 0) + '.' + padStart(milliseconds, 3, 0) + 'Z';
	} : nativeDateToISOString;
	var dateToIsoString$1 = /*@__PURE__*/getDefaultExportFromCjs(dateToIsoString);

	var $$27 = _export;
	var toISOString = dateToIsoString;

	// `Date.prototype.toISOString` method
	// https://tc39.es/ecma262/#sec-date.prototype.toisostring
	// PhantomJS / old WebKit has a broken implementations
	$$27({
	  target: 'Date',
	  proto: true,
	  forced: Date.prototype.toISOString !== toISOString
	}, {
	  toISOString: toISOString
	});

	var es_date_toJson = {};

	'use strict';
	var $$26 = _export;
	var fails$V = fails$1m;
	var toObject$b = toObject$t;
	var toPrimitive$2 = toPrimitive$4;
	var FORCED$q = fails$V(function () {
	  return new Date(NaN).toJSON() !== null || Date.prototype.toJSON.call({
	    toISOString: function toISOString() {
	      return 1;
	    }
	  }) !== 1;
	});

	// `Date.prototype.toJSON` method
	// https://tc39.es/ecma262/#sec-date.prototype.tojson
	$$26({
	  target: 'Date',
	  proto: true,
	  arity: 1,
	  forced: FORCED$q
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  toJSON: function toJSON(key) {
	    var O = toObject$b(this);
	    var pv = toPrimitive$2(O, 'number');
	    return typeof pv == 'number' && !isFinite(pv) ? null : O.toISOString();
	  }
	});

	var es_date_toPrimitive = {};

	'use strict';
	var anObject$p = anObject$D;
	var ordinaryToPrimitive = ordinaryToPrimitive$2;
	var $TypeError$a = TypeError;

	// `Date.prototype[@@toPrimitive](hint)` method implementation
	// https://tc39.es/ecma262/#sec-date.prototype-@@toprimitive
	var dateToPrimitive$1 = function dateToPrimitive(hint) {
	  anObject$p(this);
	  if (hint === 'string' || hint === 'default') hint = 'string';else if (hint !== 'number') throw $TypeError$a('Incorrect hint');
	  return ordinaryToPrimitive(this, hint);
	};
	var dateToPrimitive$2 = /*@__PURE__*/getDefaultExportFromCjs(dateToPrimitive$1);

	var hasOwn$g = hasOwnProperty_1;
	var defineBuiltIn$d = defineBuiltIn$m;
	var dateToPrimitive = dateToPrimitive$1;
	var wellKnownSymbol$d = wellKnownSymbol$z;
	var TO_PRIMITIVE = wellKnownSymbol$d('toPrimitive');
	var DatePrototype$1 = Date.prototype;

	// `Date.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-date.prototype-@@toprimitive
	if (!hasOwn$g(DatePrototype$1, TO_PRIMITIVE)) {
	  defineBuiltIn$d(DatePrototype$1, TO_PRIMITIVE, dateToPrimitive);
	}

	var es_date_toString = {};

	// TODO: Remove from `core-js@4`
	var uncurryThis$P = functionUncurryThis;
	var defineBuiltIn$c = defineBuiltIn$m;
	var DatePrototype = Date.prototype;
	var INVALID_DATE = 'Invalid Date';
	var TO_STRING$1 = 'toString';
	var nativeDateToString = uncurryThis$P(DatePrototype[TO_STRING$1]);
	var thisTimeValue$1 = uncurryThis$P(DatePrototype.getTime);

	// `Date.prototype.toString` method
	// https://tc39.es/ecma262/#sec-date.prototype.tostring
	if (String(new Date(NaN)) != INVALID_DATE) {
	  defineBuiltIn$c(DatePrototype, TO_STRING$1, function toString() {
	    var value = thisTimeValue$1(this);
	    // eslint-disable-next-line no-self-compare -- NaN check
	    return value === value ? nativeDateToString(this) : INVALID_DATE;
	  });
	}

	var es_escape = {};

	'use strict';
	var $$25 = _export;
	var uncurryThis$O = functionUncurryThis;
	var toString$p = toString$x;
	var charAt$d = uncurryThis$O(''.charAt);
	var charCodeAt$4 = uncurryThis$O(''.charCodeAt);
	var exec$8 = uncurryThis$O(/./.exec);
	var numberToString$1 = uncurryThis$O(1.0.toString);
	var toUpperCase = uncurryThis$O(''.toUpperCase);
	var raw = /[\w*+\-./@]/;
	var hex$1 = function hex(code, length) {
	  var result = numberToString$1(code, 16);
	  while (result.length < length) result = '0' + result;
	  return result;
	};

	// `escape` method
	// https://tc39.es/ecma262/#sec-escape-string
	$$25({
	  global: true
	}, {
	  escape: function escape(string) {
	    var str = toString$p(string);
	    var result = '';
	    var length = str.length;
	    var index = 0;
	    var chr, code;
	    while (index < length) {
	      chr = charAt$d(str, index++);
	      if (exec$8(raw, chr)) {
	        result += chr;
	      } else {
	        code = charCodeAt$4(chr, 0);
	        if (code < 256) {
	          result += '%' + hex$1(code, 2);
	        } else {
	          result += '%u' + toUpperCase(hex$1(code, 4));
	        }
	      }
	    }
	    return result;
	  }
	});

	var es_function_bind = {};

	'use strict';
	var uncurryThis$N = functionUncurryThis;
	var aCallable$c = aCallable$l;
	var isObject$m = isObject$z;
	var hasOwn$f = hasOwnProperty_1;
	var arraySlice$6 = arraySlice$a;
	var NATIVE_BIND = functionBindNative;
	var $Function = Function;
	var concat$5 = uncurryThis$N([].concat);
	var join$6 = uncurryThis$N([].join);
	var factories = {};
	var construct = function construct(C, argsLength, args) {
	  if (!hasOwn$f(factories, argsLength)) {
	    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']';
	    factories[argsLength] = $Function('C,a', 'return new C(' + join$6(list, ',') + ')');
	  }
	  return factories[argsLength](C, args);
	};

	// `Function.prototype.bind` method implementation
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	var functionBind = NATIVE_BIND ? $Function.bind : function bind(that /* , ...args */) {
	  var F = aCallable$c(this);
	  var Prototype = F.prototype;
	  var partArgs = arraySlice$6(arguments, 1);
	  var boundFunction = function bound( /* args... */
	  ) {
	    var args = concat$5(partArgs, arraySlice$6(arguments));
	    return this instanceof boundFunction ? construct(F, args.length, args) : F.apply(that, args);
	  };
	  if (isObject$m(Prototype)) boundFunction.prototype = Prototype;
	  return boundFunction;
	};
	var functionBind$1 = /*@__PURE__*/getDefaultExportFromCjs(functionBind);

	// TODO: Remove from `core-js@4`
	var $$24 = _export;
	var bind$8 = functionBind;

	// `Function.prototype.bind` method
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	$$24({
	  target: 'Function',
	  proto: true,
	  forced: Function.bind !== bind$8
	}, {
	  bind: bind$8
	});

	var es_function_hasInstance = {};

	'use strict';
	var isCallable$d = isCallable$z;
	var isObject$l = isObject$z;
	var definePropertyModule$5 = objectDefineProperty;
	var getPrototypeOf$5 = objectGetPrototypeOf$1;
	var wellKnownSymbol$c = wellKnownSymbol$z;
	var makeBuiltIn = makeBuiltInExports;
	var HAS_INSTANCE = wellKnownSymbol$c('hasInstance');
	var FunctionPrototype$1 = Function.prototype;

	// `Function.prototype[@@hasInstance]` method
	// https://tc39.es/ecma262/#sec-function.prototype-@@hasinstance
	if (!(HAS_INSTANCE in FunctionPrototype$1)) {
	  definePropertyModule$5.f(FunctionPrototype$1, HAS_INSTANCE, {
	    value: makeBuiltIn(function (O) {
	      if (!isCallable$d(this) || !isObject$l(O)) return false;
	      var P = this.prototype;
	      if (!isObject$l(P)) return O instanceof this;
	      // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:
	      while (O = getPrototypeOf$5(O)) if (P === O) return true;
	      return false;
	    }, HAS_INSTANCE)
	  });
	}

	var es_function_name = {};

	var DESCRIPTORS$s = descriptors;
	var FUNCTION_NAME_EXISTS = functionName.EXISTS;
	var uncurryThis$M = functionUncurryThis;
	var defineBuiltInAccessor$b = defineBuiltInAccessor$h;
	var FunctionPrototype = Function.prototype;
	var functionToString = uncurryThis$M(FunctionPrototype.toString);
	var nameRE = /function\b(?:\s|\/\*[\S\s]*?\*\/|\/\/[^\n\r]*[\n\r]+)*([^\s(/]*)/;
	var regExpExec$4 = uncurryThis$M(nameRE.exec);
	var NAME = 'name';

	// Function instances `.name` property
	// https://tc39.es/ecma262/#sec-function-instances-name
	if (DESCRIPTORS$s && !FUNCTION_NAME_EXISTS) {
	  defineBuiltInAccessor$b(FunctionPrototype, NAME, {
	    configurable: true,
	    get: function get() {
	      try {
	        return regExpExec$4(nameRE, functionToString(this))[1];
	      } catch (error) {
	        return '';
	      }
	    }
	  });
	}

	var es_globalThis = {};

	var $$23 = _export;
	var global$H = global$Z;

	// `globalThis` object
	// https://tc39.es/ecma262/#sec-globalthis
	$$23({
	  global: true,
	  forced: global$H.globalThis !== global$H
	}, {
	  globalThis: global$H
	});

	var es_json_toStringTag = {};

	var global$G = global$Z;
	var setToStringTag$7 = setToStringTag$d;

	// JSON[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-json-@@tostringtag
	setToStringTag$7(global$G.JSON, 'JSON', true);

	var es_map = {};

	var es_map_constructor = {};

	var internalMetadata$2 = {exports: {}};

	// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
	var fails$U = fails$1m;
	var arrayBufferNonExtensible = fails$U(function () {
	  if (typeof ArrayBuffer == 'function') {
	    var buffer = new ArrayBuffer(8);
	    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
	    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', {
	      value: 8
	    });
	  }
	});
	var arrayBufferNonExtensible$1 = /*@__PURE__*/getDefaultExportFromCjs(arrayBufferNonExtensible);

	var fails$T = fails$1m;
	var isObject$k = isObject$z;
	var classof$d = classofRaw$2;
	var ARRAY_BUFFER_NON_EXTENSIBLE$2 = arrayBufferNonExtensible;

	// eslint-disable-next-line es/no-object-isextensible -- safe
	var $isExtensible$2 = Object.isExtensible;
	var FAILS_ON_PRIMITIVES$6 = fails$T(function () {
	  $isExtensible$2(1);
	});

	// `Object.isExtensible` method
	// https://tc39.es/ecma262/#sec-object.isextensible
	var objectIsExtensible = FAILS_ON_PRIMITIVES$6 || ARRAY_BUFFER_NON_EXTENSIBLE$2 ? function isExtensible(it) {
	  if (!isObject$k(it)) return false;
	  if (ARRAY_BUFFER_NON_EXTENSIBLE$2 && classof$d(it) == 'ArrayBuffer') return false;
	  return $isExtensible$2 ? $isExtensible$2(it) : true;
	} : $isExtensible$2;
	var objectIsExtensible$1 = /*@__PURE__*/getDefaultExportFromCjs(objectIsExtensible);

	var fails$S = fails$1m;
	var freezing = !fails$S(function () {
	  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
	  return Object.isExtensible(Object.preventExtensions({}));
	});
	var freezing$1 = /*@__PURE__*/getDefaultExportFromCjs(freezing);

	var internalMetadata = internalMetadata$2.exports;
	var $$22 = _export;
	var uncurryThis$L = functionUncurryThis;
	var hiddenKeys = hiddenKeys$6;
	var isObject$j = isObject$z;
	var hasOwn$e = hasOwnProperty_1;
	var defineProperty$6 = objectDefineProperty.f;
	var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
	var isExtensible$1 = objectIsExtensible;
	var uid$1 = uid$6;
	var FREEZING$5 = freezing;
	var REQUIRED = false;
	var METADATA = uid$1('meta');
	var id$1 = 0;
	var setMetadata = function setMetadata(it) {
	  defineProperty$6(it, METADATA, {
	    value: {
	      objectID: 'O' + id$1++,
	      // object ID
	      weakData: {} // weak collections IDs
	    }
	  });
	};

	var fastKey$1 = function fastKey(it, create) {
	  // return a primitive with prefix
	  if (!isObject$j(it)) return _typeof(it) == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
	  if (!hasOwn$e(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible$1(it)) return 'F';
	    // not necessary to add metadata
	    if (!create) return 'E';
	    // add missing metadata
	    setMetadata(it);
	    // return object ID
	  }
	  return it[METADATA].objectID;
	};
	var getWeakData$1 = function getWeakData(it, create) {
	  if (!hasOwn$e(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible$1(it)) return true;
	    // not necessary to add metadata
	    if (!create) return false;
	    // add missing metadata
	    setMetadata(it);
	    // return the store of weak collections IDs
	  }
	  return it[METADATA].weakData;
	};

	// add metadata on freeze-family methods calling
	var onFreeze$3 = function onFreeze(it) {
	  if (FREEZING$5 && REQUIRED && isExtensible$1(it) && !hasOwn$e(it, METADATA)) setMetadata(it);
	  return it;
	};
	var enable = function enable() {
	  meta.enable = function () {/* empty */};
	  REQUIRED = true;
	  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
	  var splice = uncurryThis$L([].splice);
	  var test = {};
	  test[METADATA] = 1;

	  // prevent exposing of metadata key
	  if (getOwnPropertyNames(test).length) {
	    getOwnPropertyNamesModule.f = function (it) {
	      var result = getOwnPropertyNames(it);
	      for (var i = 0, length = result.length; i < length; i++) {
	        if (result[i] === METADATA) {
	          splice(result, i, 1);
	          break;
	        }
	      }
	      return result;
	    };
	    $$22({
	      target: 'Object',
	      stat: true,
	      forced: true
	    }, {
	      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
	    });
	  }
	};
	var meta = internalMetadata$2.exports = {
	  enable: enable,
	  fastKey: fastKey$1,
	  getWeakData: getWeakData$1,
	  onFreeze: onFreeze$3
	};
	hiddenKeys[METADATA] = true;
	var internalMetadataExports = internalMetadata$2.exports;
	var internalMetadata$1 = /*@__PURE__*/getDefaultExportFromCjs(internalMetadataExports);

	'use strict';
	var $$21 = _export;
	var global$F = global$Z;
	var uncurryThis$K = functionUncurryThis;
	var isForced$3 = isForced_1;
	var defineBuiltIn$b = defineBuiltIn$m;
	var InternalMetadataModule$1 = internalMetadataExports;
	var iterate$8 = iterate$a;
	var anInstance$8 = anInstance$a;
	var isCallable$c = isCallable$z;
	var isNullOrUndefined$9 = isNullOrUndefined$e;
	var isObject$i = isObject$z;
	var fails$R = fails$1m;
	var checkCorrectnessOfIteration$2 = checkCorrectnessOfIteration$4;
	var setToStringTag$6 = setToStringTag$d;
	var inheritIfRequired$4 = inheritIfRequired$6;
	var collection$4 = function collection(CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global$F[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var Constructor = NativeConstructor;
	  var exported = {};
	  var fixMethod = function fixMethod(KEY) {
	    var uncurriedNativeMethod = uncurryThis$K(NativePrototype[KEY]);
	    defineBuiltIn$b(NativePrototype, KEY, KEY == 'add' ? function add(value) {
	      uncurriedNativeMethod(this, value === 0 ? 0 : value);
	      return this;
	    } : KEY == 'delete' ? function (key) {
	      return IS_WEAK && !isObject$i(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
	    } : KEY == 'get' ? function get(key) {
	      return IS_WEAK && !isObject$i(key) ? undefined : uncurriedNativeMethod(this, key === 0 ? 0 : key);
	    } : KEY == 'has' ? function has(key) {
	      return IS_WEAK && !isObject$i(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
	    } : function set(key, value) {
	      uncurriedNativeMethod(this, key === 0 ? 0 : key, value);
	      return this;
	    });
	  };
	  var REPLACE = isForced$3(CONSTRUCTOR_NAME, !isCallable$c(NativeConstructor) || !(IS_WEAK || NativePrototype.forEach && !fails$R(function () {
	    new NativeConstructor().entries().next();
	  })));
	  if (REPLACE) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    InternalMetadataModule$1.enable();
	  } else if (isForced$3(CONSTRUCTOR_NAME, true)) {
	    var instance = new Constructor();
	    // early implementations not supports chaining
	    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
	    // V8 ~ Chromium 40- weak-collections throws on primitives, but should return false
	    var THROWS_ON_PRIMITIVES = fails$R(function () {
	      instance.has(1);
	    });
	    // most early implementations doesn't supports iterables, most modern - not close it correctly
	    // eslint-disable-next-line no-new -- required for testing
	    var ACCEPT_ITERABLES = checkCorrectnessOfIteration$2(function (iterable) {
	      new NativeConstructor(iterable);
	    });
	    // for early implementations -0 and +0 not the same
	    var BUGGY_ZERO = !IS_WEAK && fails$R(function () {
	      // V8 ~ Chromium 42- fails only with 5+ elements
	      var $instance = new NativeConstructor();
	      var index = 5;
	      while (index--) $instance[ADDER](index, index);
	      return !$instance.has(-0);
	    });
	    if (!ACCEPT_ITERABLES) {
	      Constructor = wrapper(function (dummy, iterable) {
	        anInstance$8(dummy, NativePrototype);
	        var that = inheritIfRequired$4(new NativeConstructor(), dummy, Constructor);
	        if (!isNullOrUndefined$9(iterable)) iterate$8(iterable, that[ADDER], {
	          that: that,
	          AS_ENTRIES: IS_MAP
	        });
	        return that;
	      });
	      Constructor.prototype = NativePrototype;
	      NativePrototype.constructor = Constructor;
	    }
	    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
	      fixMethod('delete');
	      fixMethod('has');
	      IS_MAP && fixMethod('get');
	    }
	    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);

	    // weak collections should not contains .clear method
	    if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
	  }
	  exported[CONSTRUCTOR_NAME] = Constructor;
	  $$21({
	    global: true,
	    constructor: true,
	    forced: Constructor != NativeConstructor
	  }, exported);
	  setToStringTag$6(Constructor, CONSTRUCTOR_NAME);
	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
	  return Constructor;
	};
	var collection$5 = /*@__PURE__*/getDefaultExportFromCjs(collection$4);

	'use strict';
	var create$6 = objectCreate;
	var defineBuiltInAccessor$a = defineBuiltInAccessor$h;
	var defineBuiltIns$3 = defineBuiltIns$5;
	var bind$7 = functionBindContext;
	var anInstance$7 = anInstance$a;
	var isNullOrUndefined$8 = isNullOrUndefined$e;
	var iterate$7 = iterate$a;
	var defineIterator$1 = iteratorDefine;
	var createIterResultObject$2 = createIterResultObject$4;
	var setSpecies$3 = setSpecies$6;
	var DESCRIPTORS$r = descriptors;
	var fastKey = internalMetadataExports.fastKey;
	var InternalStateModule$8 = internalState;
	var setInternalState$8 = InternalStateModule$8.set;
	var internalStateGetterFor$1 = InternalStateModule$8.getterFor;
	var collectionStrong$2 = {
	  getConstructor: function getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var Constructor = wrapper(function (that, iterable) {
	      anInstance$7(that, Prototype);
	      setInternalState$8(that, {
	        type: CONSTRUCTOR_NAME,
	        index: create$6(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!DESCRIPTORS$r) that.size = 0;
	      if (!isNullOrUndefined$8(iterable)) iterate$7(iterable, that[ADDER], {
	        that: that,
	        AS_ENTRIES: IS_MAP
	      });
	    });
	    var Prototype = Constructor.prototype;
	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
	    var define = function define(that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index;
	      // change existing entry
	      if (entry) {
	        entry.value = value;
	        // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (DESCRIPTORS$r) state.size++;else that.size++;
	        // add to index
	        if (index !== 'F') state.index[index] = entry;
	      }
	      return that;
	    };
	    var getEntry = function getEntry(that, key) {
	      var state = getInternalState(that);
	      // fast case
	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index];
	      // frozen object case
	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };
	    defineBuiltIns$3(Prototype, {
	      // `{ Map, Set }.prototype.clear()` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.clear
	      // https://tc39.es/ecma262/#sec-set.prototype.clear
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;
	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }
	        state.first = state.last = undefined;
	        if (DESCRIPTORS$r) state.size = 0;else that.size = 0;
	      },
	      // `{ Map, Set }.prototype.delete(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.delete
	      // https://tc39.es/ecma262/#sec-set.prototype.delete
	      'delete': function _delete(key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);
	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (DESCRIPTORS$r) state.size--;else that.size--;
	        }
	        return !!entry;
	      },
	      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.foreach
	      // https://tc39.es/ecma262/#sec-set.prototype.foreach
	      forEach: function forEach(callbackfn /* , that = undefined */) {
	        var state = getInternalState(this);
	        var boundFunction = bind$7(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	        var entry;
	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this);
	          // revert to the last existing entry
	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // `{ Map, Set}.prototype.has(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.has
	      // https://tc39.es/ecma262/#sec-set.prototype.has
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });
	    defineBuiltIns$3(Prototype, IS_MAP ? {
	      // `Map.prototype.get(key)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.get
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // `Map.prototype.set(key, value)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.set
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // `Set.prototype.add(value)` method
	      // https://tc39.es/ecma262/#sec-set.prototype.add
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (DESCRIPTORS$r) defineBuiltInAccessor$a(Prototype, 'size', {
	      configurable: true,
	      get: function get() {
	        return getInternalState(this).size;
	      }
	    });
	    return Constructor;
	  },
	  setStrong: function setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor$1(ITERATOR_NAME);
	    // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
	    // https://tc39.es/ecma262/#sec-map.prototype.entries
	    // https://tc39.es/ecma262/#sec-map.prototype.keys
	    // https://tc39.es/ecma262/#sec-map.prototype.values
	    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
	    // https://tc39.es/ecma262/#sec-set.prototype.entries
	    // https://tc39.es/ecma262/#sec-set.prototype.keys
	    // https://tc39.es/ecma262/#sec-set.prototype.values
	    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator
	    defineIterator$1(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState$8(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last;
	      // revert to the last existing entry
	      while (entry && entry.removed) entry = entry.previous;
	      // get next entry
	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return createIterResultObject$2(undefined, true);
	      }
	      // return step by kind
	      if (kind == 'keys') return createIterResultObject$2(entry.key, false);
	      if (kind == 'values') return createIterResultObject$2(entry.value, false);
	      return createIterResultObject$2([entry.key, entry.value], false);
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

	    // `{ Map, Set }.prototype[@@species]` accessors
	    // https://tc39.es/ecma262/#sec-get-map-@@species
	    // https://tc39.es/ecma262/#sec-get-set-@@species
	    setSpecies$3(CONSTRUCTOR_NAME);
	  }
	};
	var collectionStrong$3 = /*@__PURE__*/getDefaultExportFromCjs(collectionStrong$2);

	'use strict';
	var collection$3 = collection$4;
	var collectionStrong$1 = collectionStrong$2;

	// `Map` constructor
	// https://tc39.es/ecma262/#sec-map-objects
	collection$3('Map', function (init) {
	  return function Map() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong$1);

	var es_math_acosh = {};

	var log$b = Math.log;

	// `Math.log1p` method implementation
	// https://tc39.es/ecma262/#sec-math.log1p
	// eslint-disable-next-line es/no-math-log1p -- safe
	var mathLog1p = Math.log1p || function log1p(x) {
	  var n = +x;
	  return n > -1e-8 && n < 1e-8 ? n - n * n / 2 : log$b(1 + n);
	};
	var mathLog1p$1 = /*@__PURE__*/getDefaultExportFromCjs(mathLog1p);

	var $$20 = _export;
	var log1p$4 = mathLog1p;

	// eslint-disable-next-line es/no-math-acosh -- required for testing
	var $acosh = Math.acosh;
	var log$a = Math.log;
	var sqrt$5 = Math.sqrt;
	var LN2$1 = Math.LN2;
	var FORCED$p = !$acosh
	// V8 bug: https://code.google.com/p/v8/issues/detail?id=3509
	|| Math.floor($acosh(Number.MAX_VALUE)) != 710
	// Tor Browser bug: Math.acosh(Infinity) -> NaN
	|| $acosh(Infinity) != Infinity;

	// `Math.acosh` method
	// https://tc39.es/ecma262/#sec-math.acosh
	$$20({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$p
	}, {
	  acosh: function acosh(x) {
	    var n = +x;
	    return n < 1 ? NaN : n > 94906265.62425156 ? log$a(n) + LN2$1 : log1p$4(n - 1 + sqrt$5(n - 1) * sqrt$5(n + 1));
	  }
	});

	var es_math_asinh = {};

	var $$1$ = _export;

	// eslint-disable-next-line es/no-math-asinh -- required for testing
	var $asinh = Math.asinh;
	var log$9 = Math.log;
	var sqrt$4 = Math.sqrt;
	function asinh$3(x) {
	  var n = +x;
	  return !isFinite(n) || n == 0 ? n : n < 0 ? -asinh$3(-n) : log$9(n + sqrt$4(n * n + 1));
	}
	var FORCED$o = !($asinh && 1 / $asinh(0) > 0);

	// `Math.asinh` method
	// https://tc39.es/ecma262/#sec-math.asinh
	// Tor Browser bug: Math.asinh(0) -> -0
	$$1$({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$o
	}, {
	  asinh: asinh$3
	});

	var es_math_atanh = {};

	var $$1_ = _export;

	// eslint-disable-next-line es/no-math-atanh -- required for testing
	var $atanh = Math.atanh;
	var log$8 = Math.log;
	var FORCED$n = !($atanh && 1 / $atanh(-0) < 0);

	// `Math.atanh` method
	// https://tc39.es/ecma262/#sec-math.atanh
	// Tor Browser bug: Math.atanh(-0) -> 0
	$$1_({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$n
	}, {
	  atanh: function atanh(x) {
	    var n = +x;
	    return n == 0 ? n : log$8((1 + n) / (1 - n)) / 2;
	  }
	});

	var es_math_cbrt = {};

	// `Math.sign` method implementation
	// https://tc39.es/ecma262/#sec-math.sign
	// eslint-disable-next-line es/no-math-sign -- safe
	var mathSign = Math.sign || function sign(x) {
	  var n = +x;
	  // eslint-disable-next-line no-self-compare -- NaN check
	  return n == 0 || n != n ? n : n < 0 ? -1 : 1;
	};
	var mathSign$1 = /*@__PURE__*/getDefaultExportFromCjs(mathSign);

	var $$1Z = _export;
	var sign$6 = mathSign;
	var abs$9 = Math.abs;
	var pow$8 = Math.pow;

	// `Math.cbrt` method
	// https://tc39.es/ecma262/#sec-math.cbrt
	$$1Z({
	  target: 'Math',
	  stat: true
	}, {
	  cbrt: function cbrt(x) {
	    var n = +x;
	    return sign$6(n) * pow$8(abs$9(n), 1 / 3);
	  }
	});

	var es_math_clz32 = {};

	var $$1Y = _export;
	var floor$a = Math.floor;
	var log$7 = Math.log;
	var LOG2E = Math.LOG2E;

	// `Math.clz32` method
	// https://tc39.es/ecma262/#sec-math.clz32
	$$1Y({
	  target: 'Math',
	  stat: true
	}, {
	  clz32: function clz32(x) {
	    var n = x >>> 0;
	    return n ? 31 - floor$a(log$7(n + 0.5) * LOG2E) : 32;
	  }
	});

	var es_math_cosh = {};

	// eslint-disable-next-line es/no-math-expm1 -- safe
	var $expm1 = Math.expm1;
	var exp$5 = Math.exp;

	// `Math.expm1` method implementation
	// https://tc39.es/ecma262/#sec-math.expm1
	var mathExpm1 = !$expm1
	// Old FF bug
	|| $expm1(10) > 22025.465794806719 || $expm1(10) < 22025.4657948067165168
	// Tor Browser bug
	|| $expm1(-2e-17) != -2e-17 ? function expm1(x) {
	  var n = +x;
	  return n == 0 ? n : n > -1e-6 && n < 1e-6 ? n + n * n / 2 : exp$5(n) - 1;
	} : $expm1;
	var mathExpm1$1 = /*@__PURE__*/getDefaultExportFromCjs(mathExpm1);

	var $$1X = _export;
	var expm1$6 = mathExpm1;

	// eslint-disable-next-line es/no-math-cosh -- required for testing
	var $cosh = Math.cosh;
	var abs$8 = Math.abs;
	var E$1 = Math.E;
	var FORCED$m = !$cosh || $cosh(710) === Infinity;

	// `Math.cosh` method
	// https://tc39.es/ecma262/#sec-math.cosh
	$$1X({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$m
	}, {
	  cosh: function cosh(x) {
	    var t = expm1$6(abs$8(x) - 1) + 1;
	    return (t + 1 / (t * E$1 * E$1)) * (E$1 / 2);
	  }
	});

	var es_math_expm1 = {};

	var $$1W = _export;
	var expm1$5 = mathExpm1;

	// `Math.expm1` method
	// https://tc39.es/ecma262/#sec-math.expm1
	// eslint-disable-next-line es/no-math-expm1 -- required for testing
	$$1W({
	  target: 'Math',
	  stat: true,
	  forced: expm1$5 != Math.expm1
	}, {
	  expm1: expm1$5
	});

	var es_math_fround = {};

	var sign$5 = mathSign;
	var abs$7 = Math.abs;
	var pow$7 = Math.pow;
	var EPSILON = pow$7(2, -52);
	var EPSILON32 = pow$7(2, -23);
	var MAX32 = pow$7(2, 127) * (2 - EPSILON32);
	var MIN32 = pow$7(2, -126);
	var roundTiesToEven = function roundTiesToEven(n) {
	  return n + 1 / EPSILON - 1 / EPSILON;
	};

	// `Math.fround` method implementation
	// https://tc39.es/ecma262/#sec-math.fround
	// eslint-disable-next-line es/no-math-fround -- safe
	var mathFround = Math.fround || function fround(x) {
	  var n = +x;
	  var $abs = abs$7(n);
	  var $sign = sign$5(n);
	  var a, result;
	  if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
	  a = (1 + EPSILON32 / EPSILON) * $abs;
	  result = a - (a - $abs);
	  // eslint-disable-next-line no-self-compare -- NaN check
	  if (result > MAX32 || result != result) return $sign * Infinity;
	  return $sign * result;
	};
	var mathFround$1 = /*@__PURE__*/getDefaultExportFromCjs(mathFround);

	var $$1V = _export;
	var fround = mathFround;

	// `Math.fround` method
	// https://tc39.es/ecma262/#sec-math.fround
	$$1V({
	  target: 'Math',
	  stat: true
	}, {
	  fround: fround
	});

	var es_math_hypot = {};

	var $$1U = _export;

	// eslint-disable-next-line es/no-math-hypot -- required for testing
	var $hypot = Math.hypot;
	var abs$6 = Math.abs;
	var sqrt$3 = Math.sqrt;

	// Chrome 77 bug
	// https://bugs.chromium.org/p/v8/issues/detail?id=9546
	var FORCED$l = !!$hypot && $hypot(Infinity, NaN) !== Infinity;

	// `Math.hypot` method
	// https://tc39.es/ecma262/#sec-math.hypot
	$$1U({
	  target: 'Math',
	  stat: true,
	  arity: 2,
	  forced: FORCED$l
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  hypot: function hypot(value1, value2) {
	    var sum = 0;
	    var i = 0;
	    var aLen = arguments.length;
	    var larg = 0;
	    var arg, div;
	    while (i < aLen) {
	      arg = abs$6(arguments[i++]);
	      if (larg < arg) {
	        div = larg / arg;
	        sum = sum * div * div + 1;
	        larg = arg;
	      } else if (arg > 0) {
	        div = arg / larg;
	        sum += div * div;
	      } else sum += arg;
	    }
	    return larg === Infinity ? Infinity : larg * sqrt$3(sum);
	  }
	});

	var es_math_imul = {};

	var $$1T = _export;
	var fails$Q = fails$1m;

	// eslint-disable-next-line es/no-math-imul -- required for testing
	var $imul = Math.imul;
	var FORCED$k = fails$Q(function () {
	  return $imul(0xFFFFFFFF, 5) != -5 || $imul.length != 2;
	});

	// `Math.imul` method
	// https://tc39.es/ecma262/#sec-math.imul
	// some WebKit versions fails with big numbers, some has wrong arity
	$$1T({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$k
	}, {
	  imul: function imul(x, y) {
	    var UINT16 = 0xFFFF;
	    var xn = +x;
	    var yn = +y;
	    var xl = UINT16 & xn;
	    var yl = UINT16 & yn;
	    return 0 | xl * yl + ((UINT16 & xn >>> 16) * yl + xl * (UINT16 & yn >>> 16) << 16 >>> 0);
	  }
	});

	var es_math_log10 = {};

	var log$6 = Math.log;
	var LOG10E = Math.LOG10E;

	// eslint-disable-next-line es/no-math-log10 -- safe
	var mathLog10 = Math.log10 || function log10(x) {
	  return log$6(x) * LOG10E;
	};
	var mathLog10$1 = /*@__PURE__*/getDefaultExportFromCjs(mathLog10);

	var $$1S = _export;
	var log10$1 = mathLog10;

	// `Math.log10` method
	// https://tc39.es/ecma262/#sec-math.log10
	$$1S({
	  target: 'Math',
	  stat: true
	}, {
	  log10: log10$1
	});

	var es_math_log1p = {};

	var $$1R = _export;
	var log1p$3 = mathLog1p;

	// `Math.log1p` method
	// https://tc39.es/ecma262/#sec-math.log1p
	$$1R({
	  target: 'Math',
	  stat: true
	}, {
	  log1p: log1p$3
	});

	var es_math_log2 = {};

	var $$1Q = _export;
	var log$5 = Math.log;
	var LN2 = Math.LN2;

	// `Math.log2` method
	// https://tc39.es/ecma262/#sec-math.log2
	$$1Q({
	  target: 'Math',
	  stat: true
	}, {
	  log2: function log2(x) {
	    return log$5(x) / LN2;
	  }
	});

	var es_math_sign = {};

	var $$1P = _export;
	var sign$4 = mathSign;

	// `Math.sign` method
	// https://tc39.es/ecma262/#sec-math.sign
	$$1P({
	  target: 'Math',
	  stat: true
	}, {
	  sign: sign$4
	});

	var es_math_sinh = {};

	var $$1O = _export;
	var fails$P = fails$1m;
	var expm1$4 = mathExpm1;
	var abs$5 = Math.abs;
	var exp$4 = Math.exp;
	var E = Math.E;
	var FORCED$j = fails$P(function () {
	  // eslint-disable-next-line es/no-math-sinh -- required for testing
	  return Math.sinh(-2e-17) != -2e-17;
	});

	// `Math.sinh` method
	// https://tc39.es/ecma262/#sec-math.sinh
	// V8 near Chromium 38 has a problem with very small numbers
	$$1O({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$j
	}, {
	  sinh: function sinh(x) {
	    var n = +x;
	    return abs$5(n) < 1 ? (expm1$4(n) - expm1$4(-n)) / 2 : (exp$4(n - 1) - exp$4(-n - 1)) * (E / 2);
	  }
	});

	var es_math_tanh = {};

	var $$1N = _export;
	var expm1$3 = mathExpm1;
	var exp$3 = Math.exp;

	// `Math.tanh` method
	// https://tc39.es/ecma262/#sec-math.tanh
	$$1N({
	  target: 'Math',
	  stat: true
	}, {
	  tanh: function tanh(x) {
	    var n = +x;
	    var a = expm1$3(n);
	    var b = expm1$3(-n);
	    return a == Infinity ? 1 : b == Infinity ? -1 : (a - b) / (exp$3(n) + exp$3(-n));
	  }
	});

	var es_math_toStringTag = {};

	var setToStringTag$5 = setToStringTag$d;

	// Math[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-math-@@tostringtag
	setToStringTag$5(Math, 'Math', true);

	var es_math_trunc = {};

	var $$1M = _export;
	var trunc = mathTrunc;

	// `Math.trunc` method
	// https://tc39.es/ecma262/#sec-math.trunc
	$$1M({
	  target: 'Math',
	  stat: true
	}, {
	  trunc: trunc
	});

	var es_number_constructor = {};

	var uncurryThis$J = functionUncurryThis;

	// `thisNumberValue` abstract operation
	// https://tc39.es/ecma262/#sec-thisnumbervalue
	var thisNumberValue$5 = uncurryThis$J(1.0.valueOf);
	var thisNumberValue$6 = /*@__PURE__*/getDefaultExportFromCjs(thisNumberValue$5);

	// a string of all valid unicode whitespaces
	var whitespaces$5 = "\t\n\x0B\f\r \xA0\u1680\u2000\u2001\u2002" + "\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF";
	var whitespaces$6 = /*@__PURE__*/getDefaultExportFromCjs(whitespaces$5);

	var uncurryThis$I = functionUncurryThis;
	var requireObjectCoercible$e = requireObjectCoercible$j;
	var toString$o = toString$x;
	var whitespaces$4 = whitespaces$5;
	var replace$9 = uncurryThis$I(''.replace);
	var ltrim = RegExp('^[' + whitespaces$4 + ']+');
	var rtrim = RegExp('(^|[^' + whitespaces$4 + '])[' + whitespaces$4 + ']+$');

	// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
	var createMethod$2 = function createMethod(TYPE) {
	  return function ($this) {
	    var string = toString$o(requireObjectCoercible$e($this));
	    if (TYPE & 1) string = replace$9(string, ltrim, '');
	    if (TYPE & 2) string = replace$9(string, rtrim, '$1');
	    return string;
	  };
	};
	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$2(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimend
	  end: createMethod$2(2),
	  // `String.prototype.trim` method
	  // https://tc39.es/ecma262/#sec-string.prototype.trim
	  trim: createMethod$2(3)
	};
	var stringTrim$1 = /*@__PURE__*/getDefaultExportFromCjs(stringTrim);

	'use strict';
	var $$1L = _export;
	var IS_PURE$e = isPure;
	var DESCRIPTORS$q = descriptors;
	var global$E = global$Z;
	var path = path$2;
	var uncurryThis$H = functionUncurryThis;
	var isForced$2 = isForced_1;
	var hasOwn$d = hasOwnProperty_1;
	var inheritIfRequired$3 = inheritIfRequired$6;
	var isPrototypeOf$3 = objectIsPrototypeOf;
	var isSymbol$2 = isSymbol$7;
	var toPrimitive$1 = toPrimitive$4;
	var fails$O = fails$1m;
	var getOwnPropertyNames$3 = objectGetOwnPropertyNames.f;
	var getOwnPropertyDescriptor$7 = objectGetOwnPropertyDescriptor.f;
	var defineProperty$5 = objectDefineProperty.f;
	var thisNumberValue$4 = thisNumberValue$5;
	var trim$2 = stringTrim.trim;
	var NUMBER = 'Number';
	var NativeNumber = global$E[NUMBER];
	var PureNumberNamespace = path[NUMBER];
	var NumberPrototype = NativeNumber.prototype;
	var TypeError$5 = global$E.TypeError;
	var stringSlice$e = uncurryThis$H(''.slice);
	var charCodeAt$3 = uncurryThis$H(''.charCodeAt);

	// `ToNumeric` abstract operation
	// https://tc39.es/ecma262/#sec-tonumeric
	var toNumeric = function toNumeric(value) {
	  var primValue = toPrimitive$1(value, 'number');
	  return typeof primValue == 'bigint' ? primValue : toNumber(primValue);
	};

	// `ToNumber` abstract operation
	// https://tc39.es/ecma262/#sec-tonumber
	var toNumber = function toNumber(argument) {
	  var it = toPrimitive$1(argument, 'number');
	  var first, third, radix, maxCode, digits, length, index, code;
	  if (isSymbol$2(it)) throw TypeError$5('Cannot convert a Symbol value to a number');
	  if (typeof it == 'string' && it.length > 2) {
	    it = trim$2(it);
	    first = charCodeAt$3(it, 0);
	    if (first === 43 || first === 45) {
	      third = charCodeAt$3(it, 2);
	      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
	    } else if (first === 48) {
	      switch (charCodeAt$3(it, 1)) {
	        case 66:
	        case 98:
	          radix = 2;
	          maxCode = 49;
	          break;
	        // fast equal of /^0b[01]+$/i
	        case 79:
	        case 111:
	          radix = 8;
	          maxCode = 55;
	          break;
	        // fast equal of /^0o[0-7]+$/i
	        default:
	          return +it;
	      }
	      digits = stringSlice$e(it, 2);
	      length = digits.length;
	      for (index = 0; index < length; index++) {
	        code = charCodeAt$3(digits, index);
	        // parseInt parses a string to a first unavailable symbol
	        // but ToNumber should return NaN if a string contains unavailable symbols
	        if (code < 48 || code > maxCode) return NaN;
	      }
	      return parseInt(digits, radix);
	    }
	  }
	  return +it;
	};
	var FORCED$i = isForced$2(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'));
	var calledWithNew = function calledWithNew(dummy) {
	  // includes check on 1..constructor(foo) case
	  return isPrototypeOf$3(NumberPrototype, dummy) && fails$O(function () {
	    thisNumberValue$4(dummy);
	  });
	};

	// `Number` constructor
	// https://tc39.es/ecma262/#sec-number-constructor
	var NumberWrapper = function Number(value) {
	  var n = arguments.length < 1 ? 0 : NativeNumber(toNumeric(value));
	  return calledWithNew(this) ? inheritIfRequired$3(Object(n), this, NumberWrapper) : n;
	};
	NumberWrapper.prototype = NumberPrototype;
	if (FORCED$i && !IS_PURE$e) NumberPrototype.constructor = NumberWrapper;
	$$1L({
	  global: true,
	  constructor: true,
	  wrap: true,
	  forced: FORCED$i
	}, {
	  Number: NumberWrapper
	});

	// Use `internal/copy-constructor-properties` helper in `core-js@4`
	var copyConstructorProperties = function copyConstructorProperties(target, source) {
	  for (var keys = DESCRIPTORS$q ? getOwnPropertyNames$3(source) : (
	    // ES3:
	    'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
	    // ES2015 (in case, if modules with ES2015 Number statics required before):
	    'EPSILON,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,isFinite,isInteger,isNaN,isSafeInteger,parseFloat,parseInt,' +
	    // ESNext
	    'fromString,range').split(','), j = 0, key; keys.length > j; j++) {
	    if (hasOwn$d(source, key = keys[j]) && !hasOwn$d(target, key)) {
	      defineProperty$5(target, key, getOwnPropertyDescriptor$7(source, key));
	    }
	  }
	};
	if (IS_PURE$e && PureNumberNamespace) copyConstructorProperties(path[NUMBER], PureNumberNamespace);
	if (FORCED$i || IS_PURE$e) copyConstructorProperties(path[NUMBER], NativeNumber);

	var es_number_epsilon = {};

	var $$1K = _export;

	// `Number.EPSILON` constant
	// https://tc39.es/ecma262/#sec-number.epsilon
	$$1K({
	  target: 'Number',
	  stat: true,
	  nonConfigurable: true,
	  nonWritable: true
	}, {
	  EPSILON: Math.pow(2, -52)
	});

	var es_number_isFinite = {};

	var global$D = global$Z;
	var globalIsFinite = global$D.isFinite;

	// `Number.isFinite` method
	// https://tc39.es/ecma262/#sec-number.isfinite
	// eslint-disable-next-line es/no-number-isfinite -- safe
	var numberIsFinite$1 = Number.isFinite || function isFinite(it) {
	  return typeof it == 'number' && globalIsFinite(it);
	};
	var numberIsFinite$2 = /*@__PURE__*/getDefaultExportFromCjs(numberIsFinite$1);

	var $$1J = _export;
	var numberIsFinite = numberIsFinite$1;

	// `Number.isFinite` method
	// https://tc39.es/ecma262/#sec-number.isfinite
	$$1J({
	  target: 'Number',
	  stat: true
	}, {
	  isFinite: numberIsFinite
	});

	var es_number_isInteger = {};

	var isObject$h = isObject$z;
	var floor$9 = Math.floor;

	// `IsIntegralNumber` abstract operation
	// https://tc39.es/ecma262/#sec-isintegralnumber
	// eslint-disable-next-line es/no-number-isinteger -- safe
	var isIntegralNumber$3 = Number.isInteger || function isInteger(it) {
	  return !isObject$h(it) && isFinite(it) && floor$9(it) === it;
	};
	var isIntegralNumber$4 = /*@__PURE__*/getDefaultExportFromCjs(isIntegralNumber$3);

	var $$1I = _export;
	var isIntegralNumber$2 = isIntegralNumber$3;

	// `Number.isInteger` method
	// https://tc39.es/ecma262/#sec-number.isinteger
	$$1I({
	  target: 'Number',
	  stat: true
	}, {
	  isInteger: isIntegralNumber$2
	});

	var es_number_isNan = {};

	var $$1H = _export;

	// `Number.isNaN` method
	// https://tc39.es/ecma262/#sec-number.isnan
	$$1H({
	  target: 'Number',
	  stat: true
	}, {
	  isNaN: function isNaN(number) {
	    // eslint-disable-next-line no-self-compare -- NaN check
	    return number != number;
	  }
	});

	var es_number_isSafeInteger = {};

	var $$1G = _export;
	var isIntegralNumber$1 = isIntegralNumber$3;
	var abs$4 = Math.abs;

	// `Number.isSafeInteger` method
	// https://tc39.es/ecma262/#sec-number.issafeinteger
	$$1G({
	  target: 'Number',
	  stat: true
	}, {
	  isSafeInteger: function isSafeInteger(number) {
	    return isIntegralNumber$1(number) && abs$4(number) <= 0x1FFFFFFFFFFFFF;
	  }
	});

	var es_number_maxSafeInteger = {};

	var $$1F = _export;

	// `Number.MAX_SAFE_INTEGER` constant
	// https://tc39.es/ecma262/#sec-number.max_safe_integer
	$$1F({
	  target: 'Number',
	  stat: true,
	  nonConfigurable: true,
	  nonWritable: true
	}, {
	  MAX_SAFE_INTEGER: 0x1FFFFFFFFFFFFF
	});

	var es_number_minSafeInteger = {};

	var $$1E = _export;

	// `Number.MIN_SAFE_INTEGER` constant
	// https://tc39.es/ecma262/#sec-number.min_safe_integer
	$$1E({
	  target: 'Number',
	  stat: true,
	  nonConfigurable: true,
	  nonWritable: true
	}, {
	  MIN_SAFE_INTEGER: -0x1FFFFFFFFFFFFF
	});

	var es_number_parseFloat = {};

	var global$C = global$Z;
	var fails$N = fails$1m;
	var uncurryThis$G = functionUncurryThis;
	var toString$n = toString$x;
	var trim$1 = stringTrim.trim;
	var whitespaces$3 = whitespaces$5;
	var charAt$c = uncurryThis$G(''.charAt);
	var $parseFloat$1 = global$C.parseFloat;
	var _Symbol$1 = global$C.Symbol;
	var ITERATOR$5 = _Symbol$1 && _Symbol$1.iterator;
	var FORCED$h = 1 / $parseFloat$1(whitespaces$3 + '-0') !== -Infinity
	// MS Edge 18- broken with boxed symbols
	|| ITERATOR$5 && !fails$N(function () {
	  $parseFloat$1(Object(ITERATOR$5));
	});

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	var numberParseFloat = FORCED$h ? function parseFloat(string) {
	  var trimmedString = trim$1(toString$n(string));
	  var result = $parseFloat$1(trimmedString);
	  return result === 0 && charAt$c(trimmedString, 0) == '-' ? -0 : result;
	} : $parseFloat$1;
	var numberParseFloat$1 = /*@__PURE__*/getDefaultExportFromCjs(numberParseFloat);

	var $$1D = _export;
	var parseFloat$1 = numberParseFloat;

	// `Number.parseFloat` method
	// https://tc39.es/ecma262/#sec-number.parseFloat
	// eslint-disable-next-line es/no-number-parsefloat -- required for testing
	$$1D({
	  target: 'Number',
	  stat: true,
	  forced: Number.parseFloat != parseFloat$1
	}, {
	  parseFloat: parseFloat$1
	});

	var es_number_parseInt = {};

	var global$B = global$Z;
	var fails$M = fails$1m;
	var uncurryThis$F = functionUncurryThis;
	var toString$m = toString$x;
	var trim = stringTrim.trim;
	var whitespaces$2 = whitespaces$5;
	var $parseInt$1 = global$B.parseInt;
	var _Symbol = global$B.Symbol;
	var ITERATOR$4 = _Symbol && _Symbol.iterator;
	var hex = /^[+-]?0x/i;
	var exec$7 = uncurryThis$F(hex.exec);
	var FORCED$g = $parseInt$1(whitespaces$2 + '08') !== 8 || $parseInt$1(whitespaces$2 + '0x16') !== 22
	// MS Edge 18- broken with boxed symbols
	|| ITERATOR$4 && !fails$M(function () {
	  $parseInt$1(Object(ITERATOR$4));
	});

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	var numberParseInt = FORCED$g ? function parseInt(string, radix) {
	  var S = trim(toString$m(string));
	  return $parseInt$1(S, radix >>> 0 || (exec$7(hex, S) ? 16 : 10));
	} : $parseInt$1;
	var numberParseInt$1 = /*@__PURE__*/getDefaultExportFromCjs(numberParseInt);

	var $$1C = _export;
	var parseInt$2 = numberParseInt;

	// `Number.parseInt` method
	// https://tc39.es/ecma262/#sec-number.parseint
	// eslint-disable-next-line es/no-number-parseint -- required for testing
	$$1C({
	  target: 'Number',
	  stat: true,
	  forced: Number.parseInt != parseInt$2
	}, {
	  parseInt: parseInt$2
	});

	var es_number_toExponential = {};

	'use strict';
	var $$1B = _export;
	var uncurryThis$E = functionUncurryThis;
	var toIntegerOrInfinity$8 = toIntegerOrInfinity$l;
	var thisNumberValue$3 = thisNumberValue$5;
	var $repeat$1 = stringRepeat;
	var log10 = mathLog10;
	var fails$L = fails$1m;
	var $RangeError$5 = RangeError;
	var $String$1 = String;
	var $isFinite = isFinite;
	var abs$3 = Math.abs;
	var floor$8 = Math.floor;
	var pow$6 = Math.pow;
	var round$5 = Math.round;
	var nativeToExponential = uncurryThis$E(1.0.toExponential);
	var repeat$3 = uncurryThis$E($repeat$1);
	var stringSlice$d = uncurryThis$E(''.slice);

	// Edge 17-
	var ROUNDS_PROPERLY = nativeToExponential(-6.9e-11, 4) === '-6.9000e-11'
	// IE11- && Edge 14-
	&& nativeToExponential(1.255, 2) === '1.25e+0'
	// FF86-, V8 ~ Chrome 49-50
	&& nativeToExponential(12345, 3) === '1.235e+4'
	// FF86-, V8 ~ Chrome 49-50
	&& nativeToExponential(25, 0) === '3e+1';

	// IE8-
	var throwsOnInfinityFraction = function throwsOnInfinityFraction() {
	  return fails$L(function () {
	    nativeToExponential(1, Infinity);
	  }) && fails$L(function () {
	    nativeToExponential(1, -Infinity);
	  });
	};

	// Safari <11 && FF <50
	var properNonFiniteThisCheck = function properNonFiniteThisCheck() {
	  return !fails$L(function () {
	    nativeToExponential(Infinity, Infinity);
	    nativeToExponential(NaN, Infinity);
	  });
	};
	var FORCED$f = !ROUNDS_PROPERLY || !throwsOnInfinityFraction() || !properNonFiniteThisCheck();

	// `Number.prototype.toExponential` method
	// https://tc39.es/ecma262/#sec-number.prototype.toexponential
	$$1B({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$f
	}, {
	  toExponential: function toExponential(fractionDigits) {
	    var x = thisNumberValue$3(this);
	    if (fractionDigits === undefined) return nativeToExponential(x);
	    var f = toIntegerOrInfinity$8(fractionDigits);
	    if (!$isFinite(x)) return String(x);
	    // TODO: ES2018 increased the maximum number of fraction digits to 100, need to improve the implementation
	    if (f < 0 || f > 20) throw $RangeError$5('Incorrect fraction digits');
	    if (ROUNDS_PROPERLY) return nativeToExponential(x, f);
	    var s = '';
	    var m = '';
	    var e = 0;
	    var c = '';
	    var d = '';
	    if (x < 0) {
	      s = '-';
	      x = -x;
	    }
	    if (x === 0) {
	      e = 0;
	      m = repeat$3('0', f + 1);
	    } else {
	      // this block is based on https://gist.github.com/SheetJSDev/1100ad56b9f856c95299ed0e068eea08
	      // TODO: improve accuracy with big fraction digits
	      var l = log10(x);
	      e = floor$8(l);
	      var n = 0;
	      var w = pow$6(10, e - f);
	      n = round$5(x / w);
	      if (2 * x >= (2 * n + 1) * w) {
	        n += 1;
	      }
	      if (n >= pow$6(10, f + 1)) {
	        n /= 10;
	        e += 1;
	      }
	      m = $String$1(n);
	    }
	    if (f !== 0) {
	      m = stringSlice$d(m, 0, 1) + '.' + stringSlice$d(m, 1);
	    }
	    if (e === 0) {
	      c = '+';
	      d = '0';
	    } else {
	      c = e > 0 ? '+' : '-';
	      d = $String$1(abs$3(e));
	    }
	    m += 'e' + c + d;
	    return s + m;
	  }
	});

	var es_number_toFixed = {};

	'use strict';
	var $$1A = _export;
	var uncurryThis$D = functionUncurryThis;
	var toIntegerOrInfinity$7 = toIntegerOrInfinity$l;
	var thisNumberValue$2 = thisNumberValue$5;
	var $repeat = stringRepeat;
	var fails$K = fails$1m;
	var $RangeError$4 = RangeError;
	var $String = String;
	var floor$7 = Math.floor;
	var repeat$2 = uncurryThis$D($repeat);
	var stringSlice$c = uncurryThis$D(''.slice);
	var nativeToFixed = uncurryThis$D(1.0.toFixed);
	var pow$5 = function pow(x, n, acc) {
	  return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
	};
	var log$4 = function log(x) {
	  var n = 0;
	  var x2 = x;
	  while (x2 >= 4096) {
	    n += 12;
	    x2 /= 4096;
	  }
	  while (x2 >= 2) {
	    n += 1;
	    x2 /= 2;
	  }
	  return n;
	};
	var multiply$4 = function multiply(data, n, c) {
	  var index = -1;
	  var c2 = c;
	  while (++index < 6) {
	    c2 += n * data[index];
	    data[index] = c2 % 1e7;
	    c2 = floor$7(c2 / 1e7);
	  }
	};
	var divide = function divide(data, n) {
	  var index = 6;
	  var c = 0;
	  while (--index >= 0) {
	    c += data[index];
	    data[index] = floor$7(c / n);
	    c = c % n * 1e7;
	  }
	};
	var dataToString = function dataToString(data) {
	  var index = 6;
	  var s = '';
	  while (--index >= 0) {
	    if (s !== '' || index === 0 || data[index] !== 0) {
	      var t = $String(data[index]);
	      s = s === '' ? t : s + repeat$2('0', 7 - t.length) + t;
	    }
	  }
	  return s;
	};
	var FORCED$e = fails$K(function () {
	  return nativeToFixed(0.00008, 3) !== '0.000' || nativeToFixed(0.9, 0) !== '1' || nativeToFixed(1.255, 2) !== '1.25' || nativeToFixed(1000000000000000128.0, 0) !== '1000000000000000128';
	}) || !fails$K(function () {
	  // V8 ~ Android 4.3-
	  nativeToFixed({});
	});

	// `Number.prototype.toFixed` method
	// https://tc39.es/ecma262/#sec-number.prototype.tofixed
	$$1A({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$e
	}, {
	  toFixed: function toFixed(fractionDigits) {
	    var number = thisNumberValue$2(this);
	    var fractDigits = toIntegerOrInfinity$7(fractionDigits);
	    var data = [0, 0, 0, 0, 0, 0];
	    var sign = '';
	    var result = '0';
	    var e, z, j, k;

	    // TODO: ES2018 increased the maximum number of fraction digits to 100, need to improve the implementation
	    if (fractDigits < 0 || fractDigits > 20) throw $RangeError$4('Incorrect fraction digits');
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (number != number) return 'NaN';
	    if (number <= -1e21 || number >= 1e21) return $String(number);
	    if (number < 0) {
	      sign = '-';
	      number = -number;
	    }
	    if (number > 1e-21) {
	      e = log$4(number * pow$5(2, 69, 1)) - 69;
	      z = e < 0 ? number * pow$5(2, -e, 1) : number / pow$5(2, e, 1);
	      z *= 0x10000000000000;
	      e = 52 - e;
	      if (e > 0) {
	        multiply$4(data, 0, z);
	        j = fractDigits;
	        while (j >= 7) {
	          multiply$4(data, 1e7, 0);
	          j -= 7;
	        }
	        multiply$4(data, pow$5(10, j, 1), 0);
	        j = e - 1;
	        while (j >= 23) {
	          divide(data, 1 << 23);
	          j -= 23;
	        }
	        divide(data, 1 << j);
	        multiply$4(data, 1, 1);
	        divide(data, 2);
	        result = dataToString(data);
	      } else {
	        multiply$4(data, 0, z);
	        multiply$4(data, 1 << -e, 0);
	        result = dataToString(data) + repeat$2('0', fractDigits);
	      }
	    }
	    if (fractDigits > 0) {
	      k = result.length;
	      result = sign + (k <= fractDigits ? '0.' + repeat$2('0', fractDigits - k) + result : stringSlice$c(result, 0, k - fractDigits) + '.' + stringSlice$c(result, k - fractDigits));
	    } else {
	      result = sign + result;
	    }
	    return result;
	  }
	});

	var es_number_toPrecision = {};

	'use strict';
	var $$1z = _export;
	var uncurryThis$C = functionUncurryThis;
	var fails$J = fails$1m;
	var thisNumberValue$1 = thisNumberValue$5;
	var nativeToPrecision = uncurryThis$C(1.0.toPrecision);
	var FORCED$d = fails$J(function () {
	  // IE7-
	  return nativeToPrecision(1, undefined) !== '1';
	}) || !fails$J(function () {
	  // V8 ~ Android 4.3-
	  nativeToPrecision({});
	});

	// `Number.prototype.toPrecision` method
	// https://tc39.es/ecma262/#sec-number.prototype.toprecision
	$$1z({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$d
	}, {
	  toPrecision: function toPrecision(precision) {
	    return precision === undefined ? nativeToPrecision(thisNumberValue$1(this)) : nativeToPrecision(thisNumberValue$1(this), precision);
	  }
	});

	var es_object_assign = {};

	'use strict';
	var DESCRIPTORS$p = descriptors;
	var uncurryThis$B = functionUncurryThis;
	var call$q = functionCall;
	var fails$I = fails$1m;
	var objectKeys$2 = objectKeys$5;
	var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
	var propertyIsEnumerableModule = objectPropertyIsEnumerable;
	var toObject$a = toObject$t;
	var IndexedObject = indexedObject;

	// eslint-disable-next-line es/no-object-assign -- safe
	var $assign = Object.assign;
	// eslint-disable-next-line es/no-object-defineproperty -- required for testing
	var defineProperty$4 = Object.defineProperty;
	var concat$4 = uncurryThis$B([].concat);

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	var objectAssign = !$assign || fails$I(function () {
	  // should have correct order of operations (Edge bug)
	  if (DESCRIPTORS$p && $assign({
	    b: 1
	  }, $assign(defineProperty$4({}, 'a', {
	    enumerable: true,
	    get: function get() {
	      defineProperty$4(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), {
	    b: 2
	  })).b !== 1) return true;
	  // should work with symbols and should have deterministic property order (V8 bug)
	  var A = {};
	  var B = {};
	  // eslint-disable-next-line es/no-symbol -- safe
	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) {
	    B[chr] = chr;
	  });
	  return $assign({}, A)[symbol] != 7 || objectKeys$2($assign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) {
	  // eslint-disable-line no-unused-vars -- required for `.length`
	  var T = toObject$a(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
	  var propertyIsEnumerable = propertyIsEnumerableModule.f;
	  while (argumentsLength > index) {
	    var S = IndexedObject(arguments[index++]);
	    var keys = getOwnPropertySymbols ? concat$4(objectKeys$2(S), getOwnPropertySymbols(S)) : objectKeys$2(S);
	    var length = keys.length;
	    var j = 0;
	    var key;
	    while (length > j) {
	      key = keys[j++];
	      if (!DESCRIPTORS$p || call$q(propertyIsEnumerable, S, key)) T[key] = S[key];
	    }
	  }
	  return T;
	} : $assign;
	var objectAssign$1 = /*@__PURE__*/getDefaultExportFromCjs(objectAssign);

	var $$1y = _export;
	var assign$1 = objectAssign;

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	// eslint-disable-next-line es/no-object-assign -- required for testing
	$$1y({
	  target: 'Object',
	  stat: true,
	  arity: 2,
	  forced: Object.assign !== assign$1
	}, {
	  assign: assign$1
	});

	var es_object_create = {};

	// TODO: Remove from `core-js@4`
	var $$1x = _export;
	var DESCRIPTORS$o = descriptors;
	var create$5 = objectCreate;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	$$1x({
	  target: 'Object',
	  stat: true,
	  sham: !DESCRIPTORS$o
	}, {
	  create: create$5
	});

	var es_object_defineGetter = {};

	'use strict';
	var IS_PURE$d = isPure;
	var global$A = global$Z;
	var fails$H = fails$1m;
	var WEBKIT$1 = engineWebkitVersion;

	// Forced replacement object prototype accessors methods
	var objectPrototypeAccessorsForced = IS_PURE$d || !fails$H(function () {
	  // This feature detection crashes old WebKit
	  // https://github.com/zloirock/core-js/issues/232
	  if (WEBKIT$1 && WEBKIT$1 < 535) return;
	  var key = Math.random();
	  // In FF throws only define methods
	  // eslint-disable-next-line no-undef, no-useless-call, es/no-legacy-object-prototype-accessor-methods -- required for testing
	  __defineSetter__.call(null, key, function () {/* empty */});
	  delete global$A[key];
	});
	var objectPrototypeAccessorsForced$1 = /*@__PURE__*/getDefaultExportFromCjs(objectPrototypeAccessorsForced);

	'use strict';
	var $$1w = _export;
	var DESCRIPTORS$n = descriptors;
	var FORCED$c = objectPrototypeAccessorsForced;
	var aCallable$b = aCallable$l;
	var toObject$9 = toObject$t;
	var definePropertyModule$4 = objectDefineProperty;

	// `Object.prototype.__defineGetter__` method
	// https://tc39.es/ecma262/#sec-object.prototype.__defineGetter__
	if (DESCRIPTORS$n) {
	  $$1w({
	    target: 'Object',
	    proto: true,
	    forced: FORCED$c
	  }, {
	    __defineGetter__: function __defineGetter__(P, getter) {
	      definePropertyModule$4.f(toObject$9(this), P, {
	        get: aCallable$b(getter),
	        enumerable: true,
	        configurable: true
	      });
	    }
	  });
	}

	var es_object_defineProperties = {};

	var $$1v = _export;
	var DESCRIPTORS$m = descriptors;
	var defineProperties = objectDefineProperties.f;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	$$1v({
	  target: 'Object',
	  stat: true,
	  forced: Object.defineProperties !== defineProperties,
	  sham: !DESCRIPTORS$m
	}, {
	  defineProperties: defineProperties
	});

	var es_object_defineProperty = {};

	var $$1u = _export;
	var DESCRIPTORS$l = descriptors;
	var defineProperty$3 = objectDefineProperty.f;

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	$$1u({
	  target: 'Object',
	  stat: true,
	  forced: Object.defineProperty !== defineProperty$3,
	  sham: !DESCRIPTORS$l
	}, {
	  defineProperty: defineProperty$3
	});

	var es_object_defineSetter = {};

	'use strict';
	var $$1t = _export;
	var DESCRIPTORS$k = descriptors;
	var FORCED$b = objectPrototypeAccessorsForced;
	var aCallable$a = aCallable$l;
	var toObject$8 = toObject$t;
	var definePropertyModule$3 = objectDefineProperty;

	// `Object.prototype.__defineSetter__` method
	// https://tc39.es/ecma262/#sec-object.prototype.__defineSetter__
	if (DESCRIPTORS$k) {
	  $$1t({
	    target: 'Object',
	    proto: true,
	    forced: FORCED$b
	  }, {
	    __defineSetter__: function __defineSetter__(P, setter) {
	      definePropertyModule$3.f(toObject$8(this), P, {
	        set: aCallable$a(setter),
	        enumerable: true,
	        configurable: true
	      });
	    }
	  });
	}

	var es_object_entries = {};

	var DESCRIPTORS$j = descriptors;
	var uncurryThis$A = functionUncurryThis;
	var objectKeys$1 = objectKeys$5;
	var toIndexedObject$4 = toIndexedObject$j;
	var $propertyIsEnumerable = objectPropertyIsEnumerable.f;
	var propertyIsEnumerable = uncurryThis$A($propertyIsEnumerable);
	var push$8 = uncurryThis$A([].push);

	// `Object.{ entries, values }` methods implementation
	var createMethod$1 = function createMethod(TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject$4(it);
	    var keys = objectKeys$1(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;
	    while (length > i) {
	      key = keys[i++];
	      if (!DESCRIPTORS$j || propertyIsEnumerable(O, key)) {
	        push$8(result, TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }
	    return result;
	  };
	};
	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.es/ecma262/#sec-object.entries
	  entries: createMethod$1(true),
	  // `Object.values` method
	  // https://tc39.es/ecma262/#sec-object.values
	  values: createMethod$1(false)
	};
	var objectToArray$1 = /*@__PURE__*/getDefaultExportFromCjs(objectToArray);

	var $$1s = _export;
	var $entries = objectToArray.entries;

	// `Object.entries` method
	// https://tc39.es/ecma262/#sec-object.entries
	$$1s({
	  target: 'Object',
	  stat: true
	}, {
	  entries: function entries(O) {
	    return $entries(O);
	  }
	});

	var es_object_freeze = {};

	var $$1r = _export;
	var FREEZING$4 = freezing;
	var fails$G = fails$1m;
	var isObject$g = isObject$z;
	var onFreeze$2 = internalMetadataExports.onFreeze;

	// eslint-disable-next-line es/no-object-freeze -- safe
	var $freeze = Object.freeze;
	var FAILS_ON_PRIMITIVES$5 = fails$G(function () {
	  $freeze(1);
	});

	// `Object.freeze` method
	// https://tc39.es/ecma262/#sec-object.freeze
	$$1r({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$5,
	  sham: !FREEZING$4
	}, {
	  freeze: function freeze(it) {
	    return $freeze && isObject$g(it) ? $freeze(onFreeze$2(it)) : it;
	  }
	});

	var es_object_fromEntries = {};

	var $$1q = _export;
	var iterate$6 = iterate$a;
	var createProperty$2 = createProperty$9;

	// `Object.fromEntries` method
	// https://github.com/tc39/proposal-object-from-entries
	$$1q({
	  target: 'Object',
	  stat: true
	}, {
	  fromEntries: function fromEntries(iterable) {
	    var obj = {};
	    iterate$6(iterable, function (k, v) {
	      createProperty$2(obj, k, v);
	    }, {
	      AS_ENTRIES: true
	    });
	    return obj;
	  }
	});

	var es_object_getOwnPropertyDescriptor = {};

	var $$1p = _export;
	var fails$F = fails$1m;
	var toIndexedObject$3 = toIndexedObject$j;
	var nativeGetOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	var DESCRIPTORS$i = descriptors;
	var FORCED$a = !DESCRIPTORS$i || fails$F(function () {
	  nativeGetOwnPropertyDescriptor$1(1);
	});

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	$$1p({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$a,
	  sham: !DESCRIPTORS$i
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor$1(toIndexedObject$3(it), key);
	  }
	});

	var es_object_getOwnPropertyDescriptors = {};

	var $$1o = _export;
	var DESCRIPTORS$h = descriptors;
	var ownKeys$1 = ownKeys$3;
	var toIndexedObject$2 = toIndexedObject$j;
	var getOwnPropertyDescriptorModule$4 = objectGetOwnPropertyDescriptor;
	var createProperty$1 = createProperty$9;

	// `Object.getOwnPropertyDescriptors` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	$$1o({
	  target: 'Object',
	  stat: true,
	  sham: !DESCRIPTORS$h
	}, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject$2(object);
	    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$4.f;
	    var keys = ownKeys$1(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;
	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty$1(result, key, descriptor);
	    }
	    return result;
	  }
	});

	var es_object_getOwnPropertyNames = {};

	var $$1n = _export;
	var fails$E = fails$1m;
	var getOwnPropertyNames$2 = objectGetOwnPropertyNamesExternal.f;

	// eslint-disable-next-line es/no-object-getownpropertynames -- required for testing
	var FAILS_ON_PRIMITIVES$4 = fails$E(function () {
	  return !Object.getOwnPropertyNames(1);
	});

	// `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	$$1n({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$4
	}, {
	  getOwnPropertyNames: getOwnPropertyNames$2
	});

	var es_object_getPrototypeOf = {};

	var $$1m = _export;
	var fails$D = fails$1m;
	var toObject$7 = toObject$t;
	var nativeGetPrototypeOf = objectGetPrototypeOf$1;
	var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;
	var FAILS_ON_PRIMITIVES$3 = fails$D(function () {
	  nativeGetPrototypeOf(1);
	});

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	$$1m({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$3,
	  sham: !CORRECT_PROTOTYPE_GETTER$1
	}, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return nativeGetPrototypeOf(toObject$7(it));
	  }
	});

	var es_object_hasOwn = {};

	var $$1l = _export;
	var hasOwn$c = hasOwnProperty_1;

	// `Object.hasOwn` method
	// https://github.com/tc39/proposal-accessible-object-hasownproperty
	$$1l({
	  target: 'Object',
	  stat: true
	}, {
	  hasOwn: hasOwn$c
	});

	var es_object_is = {};

	// `SameValue` abstract operation
	// https://tc39.es/ecma262/#sec-samevalue
	// eslint-disable-next-line es/no-object-is -- safe
	var sameValue$1 = Object.is || function is(x, y) {
	  // eslint-disable-next-line no-self-compare -- NaN check
	  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
	};
	var sameValue$2 = /*@__PURE__*/getDefaultExportFromCjs(sameValue$1);

	var $$1k = _export;
	var is = sameValue$1;

	// `Object.is` method
	// https://tc39.es/ecma262/#sec-object.is
	$$1k({
	  target: 'Object',
	  stat: true
	}, {
	  is: is
	});

	var es_object_isExtensible = {};

	var $$1j = _export;
	var $isExtensible$1 = objectIsExtensible;

	// `Object.isExtensible` method
	// https://tc39.es/ecma262/#sec-object.isextensible
	// eslint-disable-next-line es/no-object-isextensible -- safe
	$$1j({
	  target: 'Object',
	  stat: true,
	  forced: Object.isExtensible !== $isExtensible$1
	}, {
	  isExtensible: $isExtensible$1
	});

	var es_object_isFrozen = {};

	var $$1i = _export;
	var fails$C = fails$1m;
	var isObject$f = isObject$z;
	var classof$c = classofRaw$2;
	var ARRAY_BUFFER_NON_EXTENSIBLE$1 = arrayBufferNonExtensible;

	// eslint-disable-next-line es/no-object-isfrozen -- safe
	var $isFrozen = Object.isFrozen;
	var FORCED$9 = ARRAY_BUFFER_NON_EXTENSIBLE$1 || fails$C(function () {
	  $isFrozen(1);
	});

	// `Object.isFrozen` method
	// https://tc39.es/ecma262/#sec-object.isfrozen
	$$1i({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$9
	}, {
	  isFrozen: function isFrozen(it) {
	    if (!isObject$f(it)) return true;
	    if (ARRAY_BUFFER_NON_EXTENSIBLE$1 && classof$c(it) == 'ArrayBuffer') return true;
	    return $isFrozen ? $isFrozen(it) : false;
	  }
	});

	var es_object_isSealed = {};

	var $$1h = _export;
	var fails$B = fails$1m;
	var isObject$e = isObject$z;
	var classof$b = classofRaw$2;
	var ARRAY_BUFFER_NON_EXTENSIBLE = arrayBufferNonExtensible;

	// eslint-disable-next-line es/no-object-issealed -- safe
	var $isSealed = Object.isSealed;
	var FORCED$8 = ARRAY_BUFFER_NON_EXTENSIBLE || fails$B(function () {
	  $isSealed(1);
	});

	// `Object.isSealed` method
	// https://tc39.es/ecma262/#sec-object.issealed
	$$1h({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$8
	}, {
	  isSealed: function isSealed(it) {
	    if (!isObject$e(it)) return true;
	    if (ARRAY_BUFFER_NON_EXTENSIBLE && classof$b(it) == 'ArrayBuffer') return true;
	    return $isSealed ? $isSealed(it) : false;
	  }
	});

	var es_object_keys = {};

	var $$1g = _export;
	var toObject$6 = toObject$t;
	var nativeKeys = objectKeys$5;
	var fails$A = fails$1m;
	var FAILS_ON_PRIMITIVES$2 = fails$A(function () {
	  nativeKeys(1);
	});

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	$$1g({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$2
	}, {
	  keys: function keys(it) {
	    return nativeKeys(toObject$6(it));
	  }
	});

	var es_object_lookupGetter = {};

	'use strict';
	var $$1f = _export;
	var DESCRIPTORS$g = descriptors;
	var FORCED$7 = objectPrototypeAccessorsForced;
	var toObject$5 = toObject$t;
	var toPropertyKey$3 = toPropertyKey$8;
	var getPrototypeOf$4 = objectGetPrototypeOf$1;
	var getOwnPropertyDescriptor$6 = objectGetOwnPropertyDescriptor.f;

	// `Object.prototype.__lookupGetter__` method
	// https://tc39.es/ecma262/#sec-object.prototype.__lookupGetter__
	if (DESCRIPTORS$g) {
	  $$1f({
	    target: 'Object',
	    proto: true,
	    forced: FORCED$7
	  }, {
	    __lookupGetter__: function __lookupGetter__(P) {
	      var O = toObject$5(this);
	      var key = toPropertyKey$3(P);
	      var desc;
	      do {
	        if (desc = getOwnPropertyDescriptor$6(O, key)) return desc.get;
	      } while (O = getPrototypeOf$4(O));
	    }
	  });
	}

	var es_object_lookupSetter = {};

	'use strict';
	var $$1e = _export;
	var DESCRIPTORS$f = descriptors;
	var FORCED$6 = objectPrototypeAccessorsForced;
	var toObject$4 = toObject$t;
	var toPropertyKey$2 = toPropertyKey$8;
	var getPrototypeOf$3 = objectGetPrototypeOf$1;
	var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;

	// `Object.prototype.__lookupSetter__` method
	// https://tc39.es/ecma262/#sec-object.prototype.__lookupSetter__
	if (DESCRIPTORS$f) {
	  $$1e({
	    target: 'Object',
	    proto: true,
	    forced: FORCED$6
	  }, {
	    __lookupSetter__: function __lookupSetter__(P) {
	      var O = toObject$4(this);
	      var key = toPropertyKey$2(P);
	      var desc;
	      do {
	        if (desc = getOwnPropertyDescriptor$5(O, key)) return desc.set;
	      } while (O = getPrototypeOf$3(O));
	    }
	  });
	}

	var es_object_preventExtensions = {};

	var $$1d = _export;
	var isObject$d = isObject$z;
	var onFreeze$1 = internalMetadataExports.onFreeze;
	var FREEZING$3 = freezing;
	var fails$z = fails$1m;

	// eslint-disable-next-line es/no-object-preventextensions -- safe
	var $preventExtensions = Object.preventExtensions;
	var FAILS_ON_PRIMITIVES$1 = fails$z(function () {
	  $preventExtensions(1);
	});

	// `Object.preventExtensions` method
	// https://tc39.es/ecma262/#sec-object.preventextensions
	$$1d({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$1,
	  sham: !FREEZING$3
	}, {
	  preventExtensions: function preventExtensions(it) {
	    return $preventExtensions && isObject$d(it) ? $preventExtensions(onFreeze$1(it)) : it;
	  }
	});

	var es_object_proto = {};

	'use strict';
	var DESCRIPTORS$e = descriptors;
	var defineBuiltInAccessor$9 = defineBuiltInAccessor$h;
	var isObject$c = isObject$z;
	var toObject$3 = toObject$t;
	var requireObjectCoercible$d = requireObjectCoercible$j;

	// eslint-disable-next-line es/no-object-getprototypeof -- safe
	var getPrototypeOf$2 = Object.getPrototypeOf;
	// eslint-disable-next-line es/no-object-setprototypeof -- safe
	var setPrototypeOf$3 = Object.setPrototypeOf;
	var ObjectPrototype$1 = Object.prototype;
	var PROTO = '__proto__';

	// `Object.prototype.__proto__` accessor
	// https://tc39.es/ecma262/#sec-object.prototype.__proto__
	if (DESCRIPTORS$e && getPrototypeOf$2 && setPrototypeOf$3 && !(PROTO in ObjectPrototype$1)) try {
	  defineBuiltInAccessor$9(ObjectPrototype$1, PROTO, {
	    configurable: true,
	    get: function __proto__() {
	      return getPrototypeOf$2(toObject$3(this));
	    },
	    set: function __proto__(proto) {
	      var O = requireObjectCoercible$d(this);
	      if (!isObject$c(proto) && proto !== null || !isObject$c(O)) return;
	      setPrototypeOf$3(O, proto);
	    }
	  });
	} catch (error) {/* empty */}

	var es_object_seal = {};

	var $$1c = _export;
	var isObject$b = isObject$z;
	var onFreeze = internalMetadataExports.onFreeze;
	var FREEZING$2 = freezing;
	var fails$y = fails$1m;

	// eslint-disable-next-line es/no-object-seal -- safe
	var $seal = Object.seal;
	var FAILS_ON_PRIMITIVES = fails$y(function () {
	  $seal(1);
	});

	// `Object.seal` method
	// https://tc39.es/ecma262/#sec-object.seal
	$$1c({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES,
	  sham: !FREEZING$2
	}, {
	  seal: function seal(it) {
	    return $seal && isObject$b(it) ? $seal(onFreeze(it)) : it;
	  }
	});

	var es_object_setPrototypeOf = {};

	var $$1b = _export;
	var setPrototypeOf$2 = objectSetPrototypeOf$1;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	$$1b({
	  target: 'Object',
	  stat: true
	}, {
	  setPrototypeOf: setPrototypeOf$2
	});

	var es_object_toString = {};

	'use strict';
	var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
	var classof$a = classof$m;

	// `Object.prototype.toString` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.tostring
	var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
	  return '[object ' + classof$a(this) + ']';
	};
	var objectToString$1 = /*@__PURE__*/getDefaultExportFromCjs(objectToString);

	var TO_STRING_TAG_SUPPORT = toStringTagSupport;
	var defineBuiltIn$a = defineBuiltIn$m;
	var toString$l = objectToString;

	// `Object.prototype.toString` method
	// https://tc39.es/ecma262/#sec-object.prototype.tostring
	if (!TO_STRING_TAG_SUPPORT) {
	  defineBuiltIn$a(Object.prototype, 'toString', toString$l, {
	    unsafe: true
	  });
	}

	var es_object_values = {};

	var $$1a = _export;
	var $values = objectToArray.values;

	// `Object.values` method
	// https://tc39.es/ecma262/#sec-object.values
	$$1a({
	  target: 'Object',
	  stat: true
	}, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var es_parseFloat = {};

	var $$19 = _export;
	var $parseFloat = numberParseFloat;

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	$$19({
	  global: true,
	  forced: parseFloat != $parseFloat
	}, {
	  parseFloat: $parseFloat
	});

	var es_parseInt = {};

	var $$18 = _export;
	var $parseInt = numberParseInt;

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	$$18({
	  global: true,
	  forced: parseInt != $parseInt
	}, {
	  parseInt: $parseInt
	});

	var es_promise = {};

	var es_promise_constructor = {};

	var $TypeError$9 = TypeError;
	var validateArgumentsLength$8 = function validateArgumentsLength(passed, required) {
	  if (passed < required) throw $TypeError$9('Not enough arguments');
	  return passed;
	};
	var validateArgumentsLength$9 = /*@__PURE__*/getDefaultExportFromCjs(validateArgumentsLength$8);

	var userAgent$3 = engineUserAgent;

	// eslint-disable-next-line redos/no-vulnerable -- safe
	var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$3);
	var engineIsIos$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsIos);

	var global$z = global$Z;
	var apply$6 = functionApply$1;
	var bind$6 = functionBindContext;
	var isCallable$b = isCallable$z;
	var hasOwn$b = hasOwnProperty_1;
	var fails$x = fails$1m;
	var html = html$2;
	var arraySlice$5 = arraySlice$a;
	var createElement = documentCreateElement$2;
	var validateArgumentsLength$7 = validateArgumentsLength$8;
	var IS_IOS$1 = engineIsIos;
	var IS_NODE$6 = engineIsNode;
	var set$1 = global$z.setImmediate;
	var clear = global$z.clearImmediate;
	var process$4 = global$z.process;
	var Dispatch = global$z.Dispatch;
	var Function$2 = global$z.Function;
	var MessageChannel = global$z.MessageChannel;
	var String$1 = global$z.String;
	var counter = 0;
	var queue$3 = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var $location, defer$1, channel, port;
	fails$x(function () {
	  // Deno throws a ReferenceError on `location` access without `--location` flag
	  $location = global$z.location;
	});
	var run = function run(id) {
	  if (hasOwn$b(queue$3, id)) {
	    var fn = queue$3[id];
	    delete queue$3[id];
	    fn();
	  }
	};
	var runner = function runner(id) {
	  return function () {
	    run(id);
	  };
	};
	var eventListener = function eventListener(event) {
	  run(event.data);
	};
	var globalPostMessageDefer = function globalPostMessageDefer(id) {
	  // old engines have not location.origin
	  global$z.postMessage(String$1(id), $location.protocol + '//' + $location.host);
	};

	// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
	if (!set$1 || !clear) {
	  set$1 = function setImmediate(handler) {
	    validateArgumentsLength$7(arguments.length, 1);
	    var fn = isCallable$b(handler) ? handler : Function$2(handler);
	    var args = arraySlice$5(arguments, 1);
	    queue$3[++counter] = function () {
	      apply$6(fn, undefined, args);
	    };
	    defer$1(counter);
	    return counter;
	  };
	  clear = function clearImmediate(id) {
	    delete queue$3[id];
	  };
	  // Node.js 0.8-
	  if (IS_NODE$6) {
	    defer$1 = function defer(id) {
	      process$4.nextTick(runner(id));
	    };
	    // Sphere (JS game engine) Dispatch API
	  } else if (Dispatch && Dispatch.now) {
	    defer$1 = function defer(id) {
	      Dispatch.now(runner(id));
	    };
	    // Browsers with MessageChannel, includes WebWorkers
	    // except iOS - https://github.com/zloirock/core-js/issues/624
	  } else if (MessageChannel && !IS_IOS$1) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = eventListener;
	    defer$1 = bind$6(port.postMessage, port);
	    // Browsers with postMessage, skip WebWorkers
	    // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (global$z.addEventListener && isCallable$b(global$z.postMessage) && !global$z.importScripts && $location && $location.protocol !== 'file:' && !fails$x(globalPostMessageDefer)) {
	    defer$1 = globalPostMessageDefer;
	    global$z.addEventListener('message', eventListener, false);
	    // IE8-
	  } else if (ONREADYSTATECHANGE in createElement('script')) {
	    defer$1 = function defer(id) {
	      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    };
	    // Rest old browsers
	  } else {
	    defer$1 = function defer(id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}
	var task$1 = {
	  set: set$1,
	  clear: clear
	};
	var task$2 = /*@__PURE__*/getDefaultExportFromCjs(task$1);

	var Queue$2 = function Queue() {
	  this.head = null;
	  this.tail = null;
	};
	Queue$2.prototype = {
	  add: function add(item) {
	    var entry = {
	      item: item,
	      next: null
	    };
	    var tail = this.tail;
	    if (tail) tail.next = entry;else this.head = entry;
	    this.tail = entry;
	  },
	  get: function get() {
	    var entry = this.head;
	    if (entry) {
	      var next = this.head = entry.next;
	      if (next === null) this.tail = null;
	      return entry.item;
	    }
	  }
	};
	var queue$1 = Queue$2;
	var queue$2 = /*@__PURE__*/getDefaultExportFromCjs(queue$1);

	var userAgent$2 = engineUserAgent;
	var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$2) && typeof Pebble != 'undefined';
	var engineIsIosPebble$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsIosPebble);

	var userAgent$1 = engineUserAgent;
	var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent$1);
	var engineIsWebosWebkit$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsWebosWebkit);

	var global$y = global$Z;
	var bind$5 = functionBindContext;
	var getOwnPropertyDescriptor$4 = objectGetOwnPropertyDescriptor.f;
	var macrotask = task$1.set;
	var Queue$1 = queue$1;
	var IS_IOS = engineIsIos;
	var IS_IOS_PEBBLE = engineIsIosPebble;
	var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
	var IS_NODE$5 = engineIsNode;
	var MutationObserver = global$y.MutationObserver || global$y.WebKitMutationObserver;
	var document$2 = global$y.document;
	var process$3 = global$y.process;
	var Promise$1 = global$y.Promise;
	// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
	var queueMicrotaskDescriptor = getOwnPropertyDescriptor$4(global$y, 'queueMicrotask');
	var microtask$2 = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
	var notify$1, toggle, node, promise, then;

	// modern engines have queueMicrotask method
	if (!microtask$2) {
	  var queue = new Queue$1();
	  var flush = function flush() {
	    var parent, fn;
	    if (IS_NODE$5 && (parent = process$3.domain)) parent.exit();
	    while (fn = queue.get()) try {
	      fn();
	    } catch (error) {
	      if (queue.head) notify$1();
	      throw error;
	    }
	    if (parent) parent.enter();
	  };

	  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
	  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
	  if (!IS_IOS && !IS_NODE$5 && !IS_WEBOS_WEBKIT && MutationObserver && document$2) {
	    toggle = true;
	    node = document$2.createTextNode('');
	    new MutationObserver(flush).observe(node, {
	      characterData: true
	    });
	    notify$1 = function notify() {
	      node.data = toggle = !toggle;
	    };
	    // environments with maybe non-completely correct, but existent Promise
	  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    promise = Promise$1.resolve(undefined);
	    // workaround of WebKit ~ iOS Safari 10.1 bug
	    promise.constructor = Promise$1;
	    then = bind$5(promise.then, promise);
	    notify$1 = function notify() {
	      then(flush);
	    };
	    // Node.js without promises
	  } else if (IS_NODE$5) {
	    notify$1 = function notify() {
	      process$3.nextTick(flush);
	    };
	    // for other environments - macrotask based on:
	    // - setImmediate
	    // - MessageChannel
	    // - window.postMessage
	    // - onreadystatechange
	    // - setTimeout
	  } else {
	    // `webpack` dev server bug on IE global methods - use bind(fn, global)
	    macrotask = bind$5(macrotask, global$y);
	    notify$1 = function notify() {
	      macrotask(flush);
	    };
	  }
	  microtask$2 = function microtask(fn) {
	    if (!queue.head) notify$1();
	    queue.add(fn);
	  };
	}
	var microtask_1 = microtask$2;
	var microtask$3 = /*@__PURE__*/getDefaultExportFromCjs(microtask_1);

	var hostReportErrors$1 = function hostReportErrors(a, b) {
	  try {
	    // eslint-disable-next-line no-console -- safe
	    arguments.length == 1 ? console.error(a) : console.error(a, b);
	  } catch (error) {/* empty */}
	};
	var hostReportErrors$2 = /*@__PURE__*/getDefaultExportFromCjs(hostReportErrors$1);

	var perform$5 = function perform(exec) {
	  try {
	    return {
	      error: false,
	      value: exec()
	    };
	  } catch (error) {
	    return {
	      error: true,
	      value: error
	    };
	  }
	};
	var perform$6 = /*@__PURE__*/getDefaultExportFromCjs(perform$5);

	var global$x = global$Z;
	var promiseNativeConstructor = global$x.Promise;
	var promiseNativeConstructor$1 = /*@__PURE__*/getDefaultExportFromCjs(promiseNativeConstructor);

	var engineIsDeno = (typeof Deno === "undefined" ? "undefined" : _typeof(Deno)) == 'object' && Deno && _typeof(Deno.version) == 'object';
	var engineIsDeno$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsDeno);

	var IS_DENO$2 = engineIsDeno;
	var IS_NODE$4 = engineIsNode;
	var engineIsBrowser = !IS_DENO$2 && !IS_NODE$4 && (typeof window === "undefined" ? "undefined" : _typeof(window)) == 'object' && (typeof document === "undefined" ? "undefined" : _typeof(document)) == 'object';
	var engineIsBrowser$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsBrowser);

	var global$w = global$Z;
	var NativePromiseConstructor$5 = promiseNativeConstructor;
	var isCallable$a = isCallable$z;
	var isForced$1 = isForced_1;
	var inspectSource = inspectSource$3;
	var wellKnownSymbol$b = wellKnownSymbol$z;
	var IS_BROWSER$1 = engineIsBrowser;
	var IS_DENO$1 = engineIsDeno;
	var IS_PURE$c = isPure;
	var V8_VERSION = engineV8Version;
	var NativePromisePrototype$3 = NativePromiseConstructor$5 && NativePromiseConstructor$5.prototype;
	var SPECIES$1 = wellKnownSymbol$b('species');
	var SUBCLASSING = false;
	var NATIVE_PROMISE_REJECTION_EVENT$1 = isCallable$a(global$w.PromiseRejectionEvent);
	var FORCED_PROMISE_CONSTRUCTOR$5 = isForced$1('Promise', function () {
	  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor$5);
	  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor$5);
	  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	  // We can't detect it synchronously, so just check versions
	  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
	  // We need Promise#{ catch, finally } in the pure version for preventing prototype pollution
	  if (IS_PURE$c && !(NativePromisePrototype$3['catch'] && NativePromisePrototype$3['finally'])) return true;
	  // We can't use @@species feature detection in V8 since it causes
	  // deoptimization and performance degradation
	  // https://github.com/zloirock/core-js/issues/679
	  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
	    // Detect correctness of subclassing with @@species support
	    var promise = new NativePromiseConstructor$5(function (resolve) {
	      resolve(1);
	    });
	    var FakePromise = function FakePromise(exec) {
	      exec(function () {/* empty */}, function () {/* empty */});
	    };
	    var constructor = promise.constructor = {};
	    constructor[SPECIES$1] = FakePromise;
	    SUBCLASSING = promise.then(function () {/* empty */}) instanceof FakePromise;
	    if (!SUBCLASSING) return true;
	    // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
	  }
	  return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER$1 || IS_DENO$1) && !NATIVE_PROMISE_REJECTION_EVENT$1;
	});
	var promiseConstructorDetection = {
	  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR$5,
	  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT$1,
	  SUBCLASSING: SUBCLASSING
	};
	var promiseConstructorDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(promiseConstructorDetection);

	var newPromiseCapability$2 = {};

	'use strict';
	var aCallable$9 = aCallable$l;
	var $TypeError$8 = TypeError;
	var PromiseCapability = function PromiseCapability(C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw $TypeError$8('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aCallable$9(resolve);
	  this.reject = aCallable$9(reject);
	};

	// `NewPromiseCapability` abstract operation
	// https://tc39.es/ecma262/#sec-newpromisecapability
	var f = newPromiseCapability$2.f = function (C) {
	  return new PromiseCapability(C);
	};

	'use strict';
	var $$17 = _export;
	var IS_PURE$b = isPure;
	var IS_NODE$3 = engineIsNode;
	var global$v = global$Z;
	var call$p = functionCall;
	var defineBuiltIn$9 = defineBuiltIn$m;
	var setPrototypeOf$1 = objectSetPrototypeOf$1;
	var setToStringTag$4 = setToStringTag$d;
	var setSpecies$2 = setSpecies$6;
	var aCallable$8 = aCallable$l;
	var isCallable$9 = isCallable$z;
	var isObject$a = isObject$z;
	var anInstance$6 = anInstance$a;
	var speciesConstructor$4 = speciesConstructor$6;
	var task = task$1.set;
	var microtask$1 = microtask_1;
	var hostReportErrors = hostReportErrors$1;
	var perform$4 = perform$5;
	var Queue = queue$1;
	var InternalStateModule$7 = internalState;
	var NativePromiseConstructor$4 = promiseNativeConstructor;
	var PromiseConstructorDetection = promiseConstructorDetection;
	var newPromiseCapabilityModule$5 = newPromiseCapability$2;
	var PROMISE = 'Promise';
	var FORCED_PROMISE_CONSTRUCTOR$4 = PromiseConstructorDetection.CONSTRUCTOR;
	var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
	var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
	var getInternalPromiseState = InternalStateModule$7.getterFor(PROMISE);
	var setInternalState$7 = InternalStateModule$7.set;
	var NativePromisePrototype$2 = NativePromiseConstructor$4 && NativePromiseConstructor$4.prototype;
	var PromiseConstructor = NativePromiseConstructor$4;
	var PromisePrototype = NativePromisePrototype$2;
	var TypeError$4 = global$v.TypeError;
	var document$1 = global$v.document;
	var process$2 = global$v.process;
	var newPromiseCapability$1 = newPromiseCapabilityModule$5.f;
	var newGenericPromiseCapability = newPromiseCapability$1;
	var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$v.dispatchEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;
	var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

	// helpers
	var isThenable = function isThenable(it) {
	  var then;
	  return isObject$a(it) && isCallable$9(then = it.then) ? then : false;
	};
	var callReaction = function callReaction(reaction, state) {
	  var value = state.value;
	  var ok = state.state == FULFILLED;
	  var handler = ok ? reaction.ok : reaction.fail;
	  var resolve = reaction.resolve;
	  var reject = reaction.reject;
	  var domain = reaction.domain;
	  var result, then, exited;
	  try {
	    if (handler) {
	      if (!ok) {
	        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
	        state.rejection = HANDLED;
	      }
	      if (handler === true) result = value;else {
	        if (domain) domain.enter();
	        result = handler(value); // can throw
	        if (domain) {
	          domain.exit();
	          exited = true;
	        }
	      }
	      if (result === reaction.promise) {
	        reject(TypeError$4('Promise-chain cycle'));
	      } else if (then = isThenable(result)) {
	        call$p(then, result, resolve, reject);
	      } else resolve(result);
	    } else reject(value);
	  } catch (error) {
	    if (domain && !exited) domain.exit();
	    reject(error);
	  }
	};
	var notify = function notify(state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  microtask$1(function () {
	    var reactions = state.reactions;
	    var reaction;
	    while (reaction = reactions.get()) {
	      callReaction(reaction, state);
	    }
	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(state);
	  });
	};
	var dispatchEvent = function dispatchEvent(name, promise, reason) {
	  var event, handler;
	  if (DISPATCH_EVENT) {
	    event = document$1.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    global$v.dispatchEvent(event);
	  } else event = {
	    promise: promise,
	    reason: reason
	  };
	  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global$v['on' + name])) handler(event);else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};
	var onUnhandled = function onUnhandled(state) {
	  call$p(task, global$v, function () {
	    var promise = state.facade;
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;
	    if (IS_UNHANDLED) {
	      result = perform$4(function () {
	        if (IS_NODE$3) {
	          process$2.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      });
	      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
	      state.rejection = IS_NODE$3 || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};
	var isUnhandled = function isUnhandled(state) {
	  return state.rejection !== HANDLED && !state.parent;
	};
	var onHandleUnhandled = function onHandleUnhandled(state) {
	  call$p(task, global$v, function () {
	    var promise = state.facade;
	    if (IS_NODE$3) {
	      process$2.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};
	var bind$4 = function bind(fn, state, unwrap) {
	  return function (value) {
	    fn(state, value, unwrap);
	  };
	};
	var internalReject = function internalReject(state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify(state, true);
	};
	var internalResolve = function internalResolve(state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  try {
	    if (state.facade === value) throw TypeError$4("Promise can't be resolved itself");
	    var then = isThenable(value);
	    if (then) {
	      microtask$1(function () {
	        var wrapper = {
	          done: false
	        };
	        try {
	          call$p(then, value, bind$4(internalResolve, wrapper, state), bind$4(internalReject, wrapper, state));
	        } catch (error) {
	          internalReject(wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify(state, false);
	    }
	  } catch (error) {
	    internalReject({
	      done: false
	    }, error, state);
	  }
	};

	// constructor polyfill
	if (FORCED_PROMISE_CONSTRUCTOR$4) {
	  // 25.4.3.1 Promise(executor)
	  PromiseConstructor = function Promise(executor) {
	    anInstance$6(this, PromisePrototype);
	    aCallable$8(executor);
	    call$p(Internal, this);
	    var state = getInternalPromiseState(this);
	    try {
	      executor(bind$4(internalResolve, state), bind$4(internalReject, state));
	    } catch (error) {
	      internalReject(state, error);
	    }
	  };
	  PromisePrototype = PromiseConstructor.prototype;

	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  Internal = function Promise(executor) {
	    setInternalState$7(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: new Queue(),
	      rejection: false,
	      state: PENDING,
	      value: undefined
	    });
	  };

	  // `Promise.prototype.then` method
	  // https://tc39.es/ecma262/#sec-promise.prototype.then
	  Internal.prototype = defineBuiltIn$9(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
	    var state = getInternalPromiseState(this);
	    var reaction = newPromiseCapability$1(speciesConstructor$4(this, PromiseConstructor));
	    state.parent = true;
	    reaction.ok = isCallable$9(onFulfilled) ? onFulfilled : true;
	    reaction.fail = isCallable$9(onRejected) && onRejected;
	    reaction.domain = IS_NODE$3 ? process$2.domain : undefined;
	    if (state.state == PENDING) state.reactions.add(reaction);else microtask$1(function () {
	      callReaction(reaction, state);
	    });
	    return reaction.promise;
	  });
	  OwnPromiseCapability = function OwnPromiseCapability() {
	    var promise = new Internal();
	    var state = getInternalPromiseState(promise);
	    this.promise = promise;
	    this.resolve = bind$4(internalResolve, state);
	    this.reject = bind$4(internalReject, state);
	  };
	  newPromiseCapabilityModule$5.f = newPromiseCapability$1 = function newPromiseCapability(C) {
	    return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
	  };
	  if (!IS_PURE$b && isCallable$9(NativePromiseConstructor$4) && NativePromisePrototype$2 !== Object.prototype) {
	    nativeThen = NativePromisePrototype$2.then;
	    if (!NATIVE_PROMISE_SUBCLASSING) {
	      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
	      defineBuiltIn$9(NativePromisePrototype$2, 'then', function then(onFulfilled, onRejected) {
	        var that = this;
	        return new PromiseConstructor(function (resolve, reject) {
	          call$p(nativeThen, that, resolve, reject);
	        }).then(onFulfilled, onRejected);
	        // https://github.com/zloirock/core-js/issues/640
	      }, {
	        unsafe: true
	      });
	    }

	    // make `.constructor === Promise` work for native promise-based APIs
	    try {
	      delete NativePromisePrototype$2.constructor;
	    } catch (error) {/* empty */}

	    // make `instanceof Promise` work for native promise-based APIs
	    if (setPrototypeOf$1) {
	      setPrototypeOf$1(NativePromisePrototype$2, PromisePrototype);
	    }
	  }
	}
	$$17({
	  global: true,
	  constructor: true,
	  wrap: true,
	  forced: FORCED_PROMISE_CONSTRUCTOR$4
	}, {
	  Promise: PromiseConstructor
	});
	setToStringTag$4(PromiseConstructor, PROMISE, false, true);
	setSpecies$2(PROMISE);

	var es_promise_all = {};

	var NativePromiseConstructor$3 = promiseNativeConstructor;
	var checkCorrectnessOfIteration$1 = checkCorrectnessOfIteration$4;
	var FORCED_PROMISE_CONSTRUCTOR$3 = promiseConstructorDetection.CONSTRUCTOR;
	var promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR$3 || !checkCorrectnessOfIteration$1(function (iterable) {
	  NativePromiseConstructor$3.all(iterable).then(undefined, function () {/* empty */});
	});
	var promiseStaticsIncorrectIteration$1 = /*@__PURE__*/getDefaultExportFromCjs(promiseStaticsIncorrectIteration);

	'use strict';
	var $$16 = _export;
	var call$o = functionCall;
	var aCallable$7 = aCallable$l;
	var newPromiseCapabilityModule$4 = newPromiseCapability$2;
	var perform$3 = perform$5;
	var iterate$5 = iterate$a;
	var PROMISE_STATICS_INCORRECT_ITERATION$3 = promiseStaticsIncorrectIteration;

	// `Promise.all` method
	// https://tc39.es/ecma262/#sec-promise.all
	$$16({
	  target: 'Promise',
	  stat: true,
	  forced: PROMISE_STATICS_INCORRECT_ITERATION$3
	}, {
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$4.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$3(function () {
	      var $promiseResolve = aCallable$7(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$5(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$o($promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var es_promise_catch = {};

	'use strict';
	var $$15 = _export;
	var IS_PURE$a = isPure;
	var FORCED_PROMISE_CONSTRUCTOR$2 = promiseConstructorDetection.CONSTRUCTOR;
	var NativePromiseConstructor$2 = promiseNativeConstructor;
	var getBuiltIn$a = getBuiltIn$m;
	var isCallable$8 = isCallable$z;
	var defineBuiltIn$8 = defineBuiltIn$m;
	var NativePromisePrototype$1 = NativePromiseConstructor$2 && NativePromiseConstructor$2.prototype;

	// `Promise.prototype.catch` method
	// https://tc39.es/ecma262/#sec-promise.prototype.catch
	$$15({
	  target: 'Promise',
	  proto: true,
	  forced: FORCED_PROMISE_CONSTRUCTOR$2,
	  real: true
	}, {
	  'catch': function _catch(onRejected) {
	    return this.then(undefined, onRejected);
	  }
	});

	// makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
	if (!IS_PURE$a && isCallable$8(NativePromiseConstructor$2)) {
	  var method$1 = getBuiltIn$a('Promise').prototype['catch'];
	  if (NativePromisePrototype$1['catch'] !== method$1) {
	    defineBuiltIn$8(NativePromisePrototype$1, 'catch', method$1, {
	      unsafe: true
	    });
	  }
	}

	var es_promise_race = {};

	'use strict';
	var $$14 = _export;
	var call$n = functionCall;
	var aCallable$6 = aCallable$l;
	var newPromiseCapabilityModule$3 = newPromiseCapability$2;
	var perform$2 = perform$5;
	var iterate$4 = iterate$a;
	var PROMISE_STATICS_INCORRECT_ITERATION$2 = promiseStaticsIncorrectIteration;

	// `Promise.race` method
	// https://tc39.es/ecma262/#sec-promise.race
	$$14({
	  target: 'Promise',
	  stat: true,
	  forced: PROMISE_STATICS_INCORRECT_ITERATION$2
	}, {
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$3.f(C);
	    var reject = capability.reject;
	    var result = perform$2(function () {
	      var $promiseResolve = aCallable$6(C.resolve);
	      iterate$4(iterable, function (promise) {
	        call$n($promiseResolve, C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var es_promise_reject = {};

	'use strict';
	var $$13 = _export;
	var call$m = functionCall;
	var newPromiseCapabilityModule$2 = newPromiseCapability$2;
	var FORCED_PROMISE_CONSTRUCTOR$1 = promiseConstructorDetection.CONSTRUCTOR;

	// `Promise.reject` method
	// https://tc39.es/ecma262/#sec-promise.reject
	$$13({
	  target: 'Promise',
	  stat: true,
	  forced: FORCED_PROMISE_CONSTRUCTOR$1
	}, {
	  reject: function reject(r) {
	    var capability = newPromiseCapabilityModule$2.f(this);
	    call$m(capability.reject, undefined, r);
	    return capability.promise;
	  }
	});

	var es_promise_resolve = {};

	var anObject$o = anObject$D;
	var isObject$9 = isObject$z;
	var newPromiseCapability = newPromiseCapability$2;
	var promiseResolve$2 = function promiseResolve(C, x) {
	  anObject$o(C);
	  if (isObject$9(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};
	var promiseResolve$3 = /*@__PURE__*/getDefaultExportFromCjs(promiseResolve$2);

	'use strict';
	var $$12 = _export;
	var getBuiltIn$9 = getBuiltIn$m;
	var IS_PURE$9 = isPure;
	var NativePromiseConstructor$1 = promiseNativeConstructor;
	var FORCED_PROMISE_CONSTRUCTOR = promiseConstructorDetection.CONSTRUCTOR;
	var promiseResolve$1 = promiseResolve$2;
	var PromiseConstructorWrapper = getBuiltIn$9('Promise');
	var CHECK_WRAPPER = IS_PURE$9 && !FORCED_PROMISE_CONSTRUCTOR;

	// `Promise.resolve` method
	// https://tc39.es/ecma262/#sec-promise.resolve
	$$12({
	  target: 'Promise',
	  stat: true,
	  forced: IS_PURE$9 || FORCED_PROMISE_CONSTRUCTOR
	}, {
	  resolve: function resolve(x) {
	    return promiseResolve$1(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor$1 : this, x);
	  }
	});

	var es_promise_allSettled = {};

	'use strict';
	var $$11 = _export;
	var call$l = functionCall;
	var aCallable$5 = aCallable$l;
	var newPromiseCapabilityModule$1 = newPromiseCapability$2;
	var perform$1 = perform$5;
	var iterate$3 = iterate$a;
	var PROMISE_STATICS_INCORRECT_ITERATION$1 = promiseStaticsIncorrectIteration;

	// `Promise.allSettled` method
	// https://tc39.es/ecma262/#sec-promise.allsettled
	$$11({
	  target: 'Promise',
	  stat: true,
	  forced: PROMISE_STATICS_INCORRECT_ITERATION$1
	}, {
	  allSettled: function allSettled(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$1.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$1(function () {
	      var promiseResolve = aCallable$5(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$3(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$l(promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'fulfilled',
	            value: value
	          };
	          --remaining || resolve(values);
	        }, function (error) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'rejected',
	            reason: error
	          };
	          --remaining || resolve(values);
	        });
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var es_promise_any = {};

	'use strict';
	var $$10 = _export;
	var call$k = functionCall;
	var aCallable$4 = aCallable$l;
	var getBuiltIn$8 = getBuiltIn$m;
	var newPromiseCapabilityModule = newPromiseCapability$2;
	var perform = perform$5;
	var iterate$2 = iterate$a;
	var PROMISE_STATICS_INCORRECT_ITERATION = promiseStaticsIncorrectIteration;
	var PROMISE_ANY_ERROR = 'No one promise resolved';

	// `Promise.any` method
	// https://tc39.es/ecma262/#sec-promise.any
	$$10({
	  target: 'Promise',
	  stat: true,
	  forced: PROMISE_STATICS_INCORRECT_ITERATION
	}, {
	  any: function any(iterable) {
	    var C = this;
	    var AggregateError = getBuiltIn$8('AggregateError');
	    var capability = newPromiseCapabilityModule.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var promiseResolve = aCallable$4(C.resolve);
	      var errors = [];
	      var counter = 0;
	      var remaining = 1;
	      var alreadyResolved = false;
	      iterate$2(iterable, function (promise) {
	        var index = counter++;
	        var alreadyRejected = false;
	        remaining++;
	        call$k(promiseResolve, C, promise).then(function (value) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyResolved = true;
	          resolve(value);
	        }, function (error) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyRejected = true;
	          errors[index] = error;
	          --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	        });
	      });
	      --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var es_promise_finally = {};

	'use strict';
	var $$$ = _export;
	var IS_PURE$8 = isPure;
	var NativePromiseConstructor = promiseNativeConstructor;
	var fails$w = fails$1m;
	var getBuiltIn$7 = getBuiltIn$m;
	var isCallable$7 = isCallable$z;
	var speciesConstructor$3 = speciesConstructor$6;
	var promiseResolve = promiseResolve$2;
	var defineBuiltIn$7 = defineBuiltIn$m;
	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

	// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
	var NON_GENERIC = !!NativePromiseConstructor && fails$w(function () {
	  // eslint-disable-next-line unicorn/no-thenable -- required for testing
	  NativePromisePrototype['finally'].call({
	    then: function then() {/* empty */}
	  }, function () {/* empty */});
	});

	// `Promise.prototype.finally` method
	// https://tc39.es/ecma262/#sec-promise.prototype.finally
	$$$({
	  target: 'Promise',
	  proto: true,
	  real: true,
	  forced: NON_GENERIC
	}, {
	  'finally': function _finally(onFinally) {
	    var C = speciesConstructor$3(this, getBuiltIn$7('Promise'));
	    var isFunction = isCallable$7(onFinally);
	    return this.then(isFunction ? function (x) {
	      return promiseResolve(C, onFinally()).then(function () {
	        return x;
	      });
	    } : onFinally, isFunction ? function (e) {
	      return promiseResolve(C, onFinally()).then(function () {
	        throw e;
	      });
	    } : onFinally);
	  }
	});

	// makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`
	if (!IS_PURE$8 && isCallable$7(NativePromiseConstructor)) {
	  var method = getBuiltIn$7('Promise').prototype['finally'];
	  if (NativePromisePrototype['finally'] !== method) {
	    defineBuiltIn$7(NativePromisePrototype, 'finally', method, {
	      unsafe: true
	    });
	  }
	}

	var es_reflect_apply = {};

	var $$_ = _export;
	var functionApply = functionApply$1;
	var aCallable$3 = aCallable$l;
	var anObject$n = anObject$D;
	var fails$v = fails$1m;

	// MS Edge argumentsList argument is optional
	var OPTIONAL_ARGUMENTS_LIST = !fails$v(function () {
	  // eslint-disable-next-line es/no-reflect -- required for testing
	  Reflect.apply(function () {/* empty */});
	});

	// `Reflect.apply` method
	// https://tc39.es/ecma262/#sec-reflect.apply
	$$_({
	  target: 'Reflect',
	  stat: true,
	  forced: OPTIONAL_ARGUMENTS_LIST
	}, {
	  apply: function apply(target, thisArgument, argumentsList) {
	    return functionApply(aCallable$3(target), thisArgument, anObject$n(argumentsList));
	  }
	});

	var es_reflect_construct = {};

	var $$Z = _export;
	var getBuiltIn$6 = getBuiltIn$m;
	var apply$5 = functionApply$1;
	var bind$3 = functionBind;
	var aConstructor$1 = aConstructor$3;
	var anObject$m = anObject$D;
	var isObject$8 = isObject$z;
	var create$4 = objectCreate;
	var fails$u = fails$1m;
	var nativeConstruct = getBuiltIn$6('Reflect', 'construct');
	var ObjectPrototype = Object.prototype;
	var push$7 = [].push;

	// `Reflect.construct` method
	// https://tc39.es/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it
	var NEW_TARGET_BUG = fails$u(function () {
	  function F() {/* empty */}
	  return !(nativeConstruct(function () {/* empty */}, [], F) instanceof F);
	});
	var ARGS_BUG = !fails$u(function () {
	  nativeConstruct(function () {/* empty */});
	});
	var FORCED$5 = NEW_TARGET_BUG || ARGS_BUG;
	$$Z({
	  target: 'Reflect',
	  stat: true,
	  forced: FORCED$5,
	  sham: FORCED$5
	}, {
	  construct: function construct(Target, args /* , newTarget */) {
	    aConstructor$1(Target);
	    anObject$m(args);
	    var newTarget = arguments.length < 3 ? Target : aConstructor$1(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0:
	          return new Target();
	        case 1:
	          return new Target(args[0]);
	        case 2:
	          return new Target(args[0], args[1]);
	        case 3:
	          return new Target(args[0], args[1], args[2]);
	        case 4:
	          return new Target(args[0], args[1], args[2], args[3]);
	      }
	      // w/o altered newTarget, lot of arguments case
	      var $args = [null];
	      apply$5(push$7, $args, args);
	      return new (apply$5(bind$3, Target, $args))();
	    }
	    // with altered newTarget, not support built-in constructors
	    var proto = newTarget.prototype;
	    var instance = create$4(isObject$8(proto) ? proto : ObjectPrototype);
	    var result = apply$5(Target, instance, args);
	    return isObject$8(result) ? result : instance;
	  }
	});

	var es_reflect_defineProperty = {};

	var $$Y = _export;
	var DESCRIPTORS$d = descriptors;
	var anObject$l = anObject$D;
	var toPropertyKey$1 = toPropertyKey$8;
	var definePropertyModule$2 = objectDefineProperty;
	var fails$t = fails$1m;

	// MS Edge has broken Reflect.defineProperty - throwing instead of returning false
	var ERROR_INSTEAD_OF_FALSE = fails$t(function () {
	  // eslint-disable-next-line es/no-reflect -- required for testing
	  Reflect.defineProperty(definePropertyModule$2.f({}, 1, {
	    value: 1
	  }), 1, {
	    value: 2
	  });
	});

	// `Reflect.defineProperty` method
	// https://tc39.es/ecma262/#sec-reflect.defineproperty
	$$Y({
	  target: 'Reflect',
	  stat: true,
	  forced: ERROR_INSTEAD_OF_FALSE,
	  sham: !DESCRIPTORS$d
	}, {
	  defineProperty: function defineProperty(target, propertyKey, attributes) {
	    anObject$l(target);
	    var key = toPropertyKey$1(propertyKey);
	    anObject$l(attributes);
	    try {
	      definePropertyModule$2.f(target, key, attributes);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});

	var es_reflect_deleteProperty = {};

	var $$X = _export;
	var anObject$k = anObject$D;
	var getOwnPropertyDescriptor$3 = objectGetOwnPropertyDescriptor.f;

	// `Reflect.deleteProperty` method
	// https://tc39.es/ecma262/#sec-reflect.deleteproperty
	$$X({
	  target: 'Reflect',
	  stat: true
	}, {
	  deleteProperty: function deleteProperty(target, propertyKey) {
	    var descriptor = getOwnPropertyDescriptor$3(anObject$k(target), propertyKey);
	    return descriptor && !descriptor.configurable ? false : delete target[propertyKey];
	  }
	});

	var es_reflect_get = {};

	var hasOwn$a = hasOwnProperty_1;
	var isDataDescriptor$2 = function isDataDescriptor(descriptor) {
	  return descriptor !== undefined && (hasOwn$a(descriptor, 'value') || hasOwn$a(descriptor, 'writable'));
	};
	var isDataDescriptor$3 = /*@__PURE__*/getDefaultExportFromCjs(isDataDescriptor$2);

	var $$W = _export;
	var call$j = functionCall;
	var isObject$7 = isObject$z;
	var anObject$j = anObject$D;
	var isDataDescriptor$1 = isDataDescriptor$2;
	var getOwnPropertyDescriptorModule$3 = objectGetOwnPropertyDescriptor;
	var getPrototypeOf$1 = objectGetPrototypeOf$1;

	// `Reflect.get` method
	// https://tc39.es/ecma262/#sec-reflect.get
	function get$2(target, propertyKey /* , receiver */) {
	  var receiver = arguments.length < 3 ? target : arguments[2];
	  var descriptor, prototype;
	  if (anObject$j(target) === receiver) return target[propertyKey];
	  descriptor = getOwnPropertyDescriptorModule$3.f(target, propertyKey);
	  if (descriptor) return isDataDescriptor$1(descriptor) ? descriptor.value : descriptor.get === undefined ? undefined : call$j(descriptor.get, receiver);
	  if (isObject$7(prototype = getPrototypeOf$1(target))) return get$2(prototype, propertyKey, receiver);
	}
	$$W({
	  target: 'Reflect',
	  stat: true
	}, {
	  get: get$2
	});

	var es_reflect_getOwnPropertyDescriptor = {};

	var $$V = _export;
	var DESCRIPTORS$c = descriptors;
	var anObject$i = anObject$D;
	var getOwnPropertyDescriptorModule$2 = objectGetOwnPropertyDescriptor;

	// `Reflect.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-reflect.getownpropertydescriptor
	$$V({
	  target: 'Reflect',
	  stat: true,
	  sham: !DESCRIPTORS$c
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(target, propertyKey) {
	    return getOwnPropertyDescriptorModule$2.f(anObject$i(target), propertyKey);
	  }
	});

	var es_reflect_getPrototypeOf = {};

	var $$U = _export;
	var anObject$h = anObject$D;
	var objectGetPrototypeOf = objectGetPrototypeOf$1;
	var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

	// `Reflect.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-reflect.getprototypeof
	$$U({
	  target: 'Reflect',
	  stat: true,
	  sham: !CORRECT_PROTOTYPE_GETTER
	}, {
	  getPrototypeOf: function getPrototypeOf(target) {
	    return objectGetPrototypeOf(anObject$h(target));
	  }
	});

	var es_reflect_has = {};

	var $$T = _export;

	// `Reflect.has` method
	// https://tc39.es/ecma262/#sec-reflect.has
	$$T({
	  target: 'Reflect',
	  stat: true
	}, {
	  has: function has(target, propertyKey) {
	    return propertyKey in target;
	  }
	});

	var es_reflect_isExtensible = {};

	var $$S = _export;
	var anObject$g = anObject$D;
	var $isExtensible = objectIsExtensible;

	// `Reflect.isExtensible` method
	// https://tc39.es/ecma262/#sec-reflect.isextensible
	$$S({
	  target: 'Reflect',
	  stat: true
	}, {
	  isExtensible: function isExtensible(target) {
	    anObject$g(target);
	    return $isExtensible(target);
	  }
	});

	var es_reflect_ownKeys = {};

	var $$R = _export;
	var ownKeys = ownKeys$3;

	// `Reflect.ownKeys` method
	// https://tc39.es/ecma262/#sec-reflect.ownkeys
	$$R({
	  target: 'Reflect',
	  stat: true
	}, {
	  ownKeys: ownKeys
	});

	var es_reflect_preventExtensions = {};

	var $$Q = _export;
	var getBuiltIn$5 = getBuiltIn$m;
	var anObject$f = anObject$D;
	var FREEZING$1 = freezing;

	// `Reflect.preventExtensions` method
	// https://tc39.es/ecma262/#sec-reflect.preventextensions
	$$Q({
	  target: 'Reflect',
	  stat: true,
	  sham: !FREEZING$1
	}, {
	  preventExtensions: function preventExtensions(target) {
	    anObject$f(target);
	    try {
	      var objectPreventExtensions = getBuiltIn$5('Object', 'preventExtensions');
	      if (objectPreventExtensions) objectPreventExtensions(target);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});

	var es_reflect_set = {};

	var $$P = _export;
	var call$i = functionCall;
	var anObject$e = anObject$D;
	var isObject$6 = isObject$z;
	var isDataDescriptor = isDataDescriptor$2;
	var fails$s = fails$1m;
	var definePropertyModule$1 = objectDefineProperty;
	var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
	var getPrototypeOf = objectGetPrototypeOf$1;
	var createPropertyDescriptor$4 = createPropertyDescriptor$c;

	// `Reflect.set` method
	// https://tc39.es/ecma262/#sec-reflect.set
	function set(target, propertyKey, V /* , receiver */) {
	  var receiver = arguments.length < 4 ? target : arguments[3];
	  var ownDescriptor = getOwnPropertyDescriptorModule$1.f(anObject$e(target), propertyKey);
	  var existingDescriptor, prototype, setter;
	  if (!ownDescriptor) {
	    if (isObject$6(prototype = getPrototypeOf(target))) {
	      return set(prototype, propertyKey, V, receiver);
	    }
	    ownDescriptor = createPropertyDescriptor$4(0);
	  }
	  if (isDataDescriptor(ownDescriptor)) {
	    if (ownDescriptor.writable === false || !isObject$6(receiver)) return false;
	    if (existingDescriptor = getOwnPropertyDescriptorModule$1.f(receiver, propertyKey)) {
	      if (existingDescriptor.get || existingDescriptor.set || existingDescriptor.writable === false) return false;
	      existingDescriptor.value = V;
	      definePropertyModule$1.f(receiver, propertyKey, existingDescriptor);
	    } else definePropertyModule$1.f(receiver, propertyKey, createPropertyDescriptor$4(0, V));
	  } else {
	    setter = ownDescriptor.set;
	    if (setter === undefined) return false;
	    call$i(setter, receiver, V);
	  }
	  return true;
	}

	// MS Edge 17-18 Reflect.set allows setting the property to object
	// with non-writable property on the prototype
	var MS_EDGE_BUG = fails$s(function () {
	  var Constructor = function Constructor() {/* empty */};
	  var object = definePropertyModule$1.f(new Constructor(), 'a', {
	    configurable: true
	  });
	  // eslint-disable-next-line es/no-reflect -- required for testing
	  return Reflect.set(Constructor.prototype, 'a', 1, object) !== false;
	});
	$$P({
	  target: 'Reflect',
	  stat: true,
	  forced: MS_EDGE_BUG
	}, {
	  set: set
	});

	var es_reflect_setPrototypeOf = {};

	var $$O = _export;
	var anObject$d = anObject$D;
	var aPossiblePrototype = aPossiblePrototype$2;
	var objectSetPrototypeOf = objectSetPrototypeOf$1;

	// `Reflect.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-reflect.setprototypeof
	if (objectSetPrototypeOf) $$O({
	  target: 'Reflect',
	  stat: true
	}, {
	  setPrototypeOf: function setPrototypeOf(target, proto) {
	    anObject$d(target);
	    aPossiblePrototype(proto);
	    try {
	      objectSetPrototypeOf(target, proto);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});

	var es_reflect_toStringTag = {};

	var $$N = _export;
	var global$u = global$Z;
	var setToStringTag$3 = setToStringTag$d;
	$$N({
	  global: true
	}, {
	  Reflect: {}
	});

	// Reflect[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-reflect-@@tostringtag
	setToStringTag$3(global$u.Reflect, 'Reflect', true);

	var es_regexp_constructor = {};

	var isObject$5 = isObject$z;
	var classof$9 = classofRaw$2;
	var wellKnownSymbol$a = wellKnownSymbol$z;
	var MATCH$2 = wellKnownSymbol$a('match');

	// `IsRegExp` abstract operation
	// https://tc39.es/ecma262/#sec-isregexp
	var isRegexp = function isRegexp(it) {
	  var isRegExp;
	  return isObject$5(it) && ((isRegExp = it[MATCH$2]) !== undefined ? !!isRegExp : classof$9(it) == 'RegExp');
	};
	var isRegexp$1 = /*@__PURE__*/getDefaultExportFromCjs(isRegexp);

	'use strict';
	var anObject$c = anObject$D;

	// `RegExp.prototype.flags` getter implementation
	// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
	var regexpFlags$1 = function regexpFlags() {
	  var that = anObject$c(this);
	  var result = '';
	  if (that.hasIndices) result += 'd';
	  if (that.global) result += 'g';
	  if (that.ignoreCase) result += 'i';
	  if (that.multiline) result += 'm';
	  if (that.dotAll) result += 's';
	  if (that.unicode) result += 'u';
	  if (that.unicodeSets) result += 'v';
	  if (that.sticky) result += 'y';
	  return result;
	};
	var regexpFlags$2 = /*@__PURE__*/getDefaultExportFromCjs(regexpFlags$1);

	var call$h = functionCall;
	var hasOwn$9 = hasOwnProperty_1;
	var isPrototypeOf$2 = objectIsPrototypeOf;
	var regExpFlags$1 = regexpFlags$1;
	var RegExpPrototype$7 = RegExp.prototype;
	var regexpGetFlags = function regexpGetFlags(R) {
	  var flags = R.flags;
	  return flags === undefined && !('flags' in RegExpPrototype$7) && !hasOwn$9(R, 'flags') && isPrototypeOf$2(RegExpPrototype$7, R) ? call$h(regExpFlags$1, R) : flags;
	};
	var regexpGetFlags$1 = /*@__PURE__*/getDefaultExportFromCjs(regexpGetFlags);

	var fails$r = fails$1m;
	var global$t = global$Z;

	// babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
	var $RegExp$2 = global$t.RegExp;
	var UNSUPPORTED_Y$3 = fails$r(function () {
	  var re = $RegExp$2('a', 'y');
	  re.lastIndex = 2;
	  return re.exec('abcd') != null;
	});

	// UC Browser bug
	// https://github.com/zloirock/core-js/issues/1008
	var MISSED_STICKY$2 = UNSUPPORTED_Y$3 || fails$r(function () {
	  return !$RegExp$2('a', 'y').sticky;
	});
	var BROKEN_CARET = UNSUPPORTED_Y$3 || fails$r(function () {
	  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
	  var re = $RegExp$2('^r', 'gy');
	  re.lastIndex = 2;
	  return re.exec('str') != null;
	});
	var regexpStickyHelpers = {
	  BROKEN_CARET: BROKEN_CARET,
	  MISSED_STICKY: MISSED_STICKY$2,
	  UNSUPPORTED_Y: UNSUPPORTED_Y$3
	};
	var regexpStickyHelpers$1 = /*@__PURE__*/getDefaultExportFromCjs(regexpStickyHelpers);

	var fails$q = fails$1m;
	var global$s = global$Z;

	// babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
	var $RegExp$1 = global$s.RegExp;
	var regexpUnsupportedDotAll = fails$q(function () {
	  var re = $RegExp$1('.', 's');
	  return !(re.dotAll && re.exec('\n') && re.flags === 's');
	});
	var regexpUnsupportedDotAll$1 = /*@__PURE__*/getDefaultExportFromCjs(regexpUnsupportedDotAll);

	var fails$p = fails$1m;
	var global$r = global$Z;

	// babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
	var $RegExp = global$r.RegExp;
	var regexpUnsupportedNcg = fails$p(function () {
	  var re = $RegExp('(?<a>b)', 'g');
	  return re.exec('b').groups.a !== 'b' || 'b'.replace(re, '$<a>c') !== 'bc';
	});
	var regexpUnsupportedNcg$1 = /*@__PURE__*/getDefaultExportFromCjs(regexpUnsupportedNcg);

	var DESCRIPTORS$b = descriptors;
	var global$q = global$Z;
	var uncurryThis$z = functionUncurryThis;
	var isForced = isForced_1;
	var inheritIfRequired$2 = inheritIfRequired$6;
	var createNonEnumerableProperty$5 = createNonEnumerableProperty$f;
	var getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var isPrototypeOf$1 = objectIsPrototypeOf;
	var isRegExp$4 = isRegexp;
	var toString$k = toString$x;
	var getRegExpFlags$4 = regexpGetFlags;
	var stickyHelpers$2 = regexpStickyHelpers;
	var proxyAccessor = proxyAccessor$2;
	var defineBuiltIn$6 = defineBuiltIn$m;
	var fails$o = fails$1m;
	var hasOwn$8 = hasOwnProperty_1;
	var enforceInternalState$2 = internalState.enforce;
	var setSpecies$1 = setSpecies$6;
	var wellKnownSymbol$9 = wellKnownSymbol$z;
	var UNSUPPORTED_DOT_ALL$2 = regexpUnsupportedDotAll;
	var UNSUPPORTED_NCG$1 = regexpUnsupportedNcg;
	var MATCH$1 = wellKnownSymbol$9('match');
	var NativeRegExp = global$q.RegExp;
	var RegExpPrototype$6 = NativeRegExp.prototype;
	var SyntaxError$1 = global$q.SyntaxError;
	var exec$6 = uncurryThis$z(RegExpPrototype$6.exec);
	var charAt$b = uncurryThis$z(''.charAt);
	var replace$8 = uncurryThis$z(''.replace);
	var stringIndexOf$4 = uncurryThis$z(''.indexOf);
	var stringSlice$b = uncurryThis$z(''.slice);
	// TODO: Use only proper RegExpIdentifierName
	var IS_NCG = /^\?<[^\s\d!#%&*+<=>@^][^\s!#%&*+<=>@^]*>/;
	var re1 = /a/g;
	var re2 = /a/g;

	// "new" should create a new object, old webkit bug
	var CORRECT_NEW = new NativeRegExp(re1) !== re1;
	var MISSED_STICKY$1 = stickyHelpers$2.MISSED_STICKY;
	var UNSUPPORTED_Y$2 = stickyHelpers$2.UNSUPPORTED_Y;
	var BASE_FORCED = DESCRIPTORS$b && (!CORRECT_NEW || MISSED_STICKY$1 || UNSUPPORTED_DOT_ALL$2 || UNSUPPORTED_NCG$1 || fails$o(function () {
	  re2[MATCH$1] = false;
	  // RegExp constructor can alter flags and IsRegExp works correct with @@match
	  return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
	}));
	var handleDotAll = function handleDotAll(string) {
	  var length = string.length;
	  var index = 0;
	  var result = '';
	  var brackets = false;
	  var chr;
	  for (; index <= length; index++) {
	    chr = charAt$b(string, index);
	    if (chr === '\\') {
	      result += chr + charAt$b(string, ++index);
	      continue;
	    }
	    if (!brackets && chr === '.') {
	      result += '[\\s\\S]';
	    } else {
	      if (chr === '[') {
	        brackets = true;
	      } else if (chr === ']') {
	        brackets = false;
	      }
	      result += chr;
	    }
	  }
	  return result;
	};
	var handleNCG = function handleNCG(string) {
	  var length = string.length;
	  var index = 0;
	  var result = '';
	  var named = [];
	  var names = {};
	  var brackets = false;
	  var ncg = false;
	  var groupid = 0;
	  var groupname = '';
	  var chr;
	  for (; index <= length; index++) {
	    chr = charAt$b(string, index);
	    if (chr === '\\') {
	      chr = chr + charAt$b(string, ++index);
	    } else if (chr === ']') {
	      brackets = false;
	    } else if (!brackets) switch (true) {
	      case chr === '[':
	        brackets = true;
	        break;
	      case chr === '(':
	        if (exec$6(IS_NCG, stringSlice$b(string, index + 1))) {
	          index += 2;
	          ncg = true;
	        }
	        result += chr;
	        groupid++;
	        continue;
	      case chr === '>' && ncg:
	        if (groupname === '' || hasOwn$8(names, groupname)) {
	          throw new SyntaxError$1('Invalid capture group name');
	        }
	        names[groupname] = true;
	        named[named.length] = [groupname, groupid];
	        ncg = false;
	        groupname = '';
	        continue;
	    }
	    if (ncg) groupname += chr;else result += chr;
	  }
	  return [result, named];
	};

	// `RegExp` constructor
	// https://tc39.es/ecma262/#sec-regexp-constructor
	if (isForced('RegExp', BASE_FORCED)) {
	  var RegExpWrapper = function RegExp(pattern, flags) {
	    var thisIsRegExp = isPrototypeOf$1(RegExpPrototype$6, this);
	    var patternIsRegExp = isRegExp$4(pattern);
	    var flagsAreUndefined = flags === undefined;
	    var groups = [];
	    var rawPattern = pattern;
	    var rawFlags, dotAll, sticky, handled, result, state;
	    if (!thisIsRegExp && patternIsRegExp && flagsAreUndefined && pattern.constructor === RegExpWrapper) {
	      return pattern;
	    }
	    if (patternIsRegExp || isPrototypeOf$1(RegExpPrototype$6, pattern)) {
	      pattern = pattern.source;
	      if (flagsAreUndefined) flags = getRegExpFlags$4(rawPattern);
	    }
	    pattern = pattern === undefined ? '' : toString$k(pattern);
	    flags = flags === undefined ? '' : toString$k(flags);
	    rawPattern = pattern;
	    if (UNSUPPORTED_DOT_ALL$2 && 'dotAll' in re1) {
	      dotAll = !!flags && stringIndexOf$4(flags, 's') > -1;
	      if (dotAll) flags = replace$8(flags, /s/g, '');
	    }
	    rawFlags = flags;
	    if (MISSED_STICKY$1 && 'sticky' in re1) {
	      sticky = !!flags && stringIndexOf$4(flags, 'y') > -1;
	      if (sticky && UNSUPPORTED_Y$2) flags = replace$8(flags, /y/g, '');
	    }
	    if (UNSUPPORTED_NCG$1) {
	      handled = handleNCG(pattern);
	      pattern = handled[0];
	      groups = handled[1];
	    }
	    result = inheritIfRequired$2(NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype$6, RegExpWrapper);
	    if (dotAll || sticky || groups.length) {
	      state = enforceInternalState$2(result);
	      if (dotAll) {
	        state.dotAll = true;
	        state.raw = RegExpWrapper(handleDotAll(pattern), rawFlags);
	      }
	      if (sticky) state.sticky = true;
	      if (groups.length) state.groups = groups;
	    }
	    if (pattern !== rawPattern) try {
	      // fails in old engines, but we have no alternatives for unsupported regex syntax
	      createNonEnumerableProperty$5(result, 'source', rawPattern === '' ? '(?:)' : rawPattern);
	    } catch (error) {/* empty */}
	    return result;
	  };
	  for (var keys = getOwnPropertyNames$1(NativeRegExp), index$4 = 0; keys.length > index$4;) {
	    proxyAccessor(RegExpWrapper, NativeRegExp, keys[index$4++]);
	  }
	  RegExpPrototype$6.constructor = RegExpWrapper;
	  RegExpWrapper.prototype = RegExpPrototype$6;
	  defineBuiltIn$6(global$q, 'RegExp', RegExpWrapper, {
	    constructor: true
	  });
	}

	// https://tc39.es/ecma262/#sec-get-regexp-@@species
	setSpecies$1('RegExp');

	var es_regexp_dotAll = {};

	var DESCRIPTORS$a = descriptors;
	var UNSUPPORTED_DOT_ALL$1 = regexpUnsupportedDotAll;
	var classof$8 = classofRaw$2;
	var defineBuiltInAccessor$8 = defineBuiltInAccessor$h;
	var getInternalState$6 = internalState.get;
	var RegExpPrototype$5 = RegExp.prototype;
	var $TypeError$7 = TypeError;

	// `RegExp.prototype.dotAll` getter
	// https://tc39.es/ecma262/#sec-get-regexp.prototype.dotall
	if (DESCRIPTORS$a && UNSUPPORTED_DOT_ALL$1) {
	  defineBuiltInAccessor$8(RegExpPrototype$5, 'dotAll', {
	    configurable: true,
	    get: function dotAll() {
	      if (this === RegExpPrototype$5) return undefined;
	      // We can't use InternalStateModule.getterFor because
	      // we don't add metadata for regexps created by a literal.
	      if (classof$8(this) === 'RegExp') {
	        return !!getInternalState$6(this).dotAll;
	      }
	      throw $TypeError$7('Incompatible receiver, RegExp required');
	    }
	  });
	}

	var es_regexp_exec = {};

	'use strict';
	/* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
	/* eslint-disable regexp/no-useless-quantifier -- testing */
	var call$g = functionCall;
	var uncurryThis$y = functionUncurryThis;
	var toString$j = toString$x;
	var regexpFlags = regexpFlags$1;
	var stickyHelpers$1 = regexpStickyHelpers;
	var shared$1 = sharedExports;
	var create$3 = objectCreate;
	var getInternalState$5 = internalState.get;
	var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
	var UNSUPPORTED_NCG = regexpUnsupportedNcg;
	var nativeReplace = shared$1('native-string-replace', String.prototype.replace);
	var nativeExec = RegExp.prototype.exec;
	var patchedExec = nativeExec;
	var charAt$a = uncurryThis$y(''.charAt);
	var indexOf$1 = uncurryThis$y(''.indexOf);
	var replace$7 = uncurryThis$y(''.replace);
	var stringSlice$a = uncurryThis$y(''.slice);
	var UPDATES_LAST_INDEX_WRONG = function () {
	  var re1 = /a/;
	  var re2 = /b*/g;
	  call$g(nativeExec, re1, 'a');
	  call$g(nativeExec, re2, 'a');
	  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
	}();
	var UNSUPPORTED_Y$1 = stickyHelpers$1.BROKEN_CARET;

	// nonparticipating capturing group, copied from es5-shim's String#split patch.
	var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;
	var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1 || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;
	if (PATCH) {
	  patchedExec = function exec(string) {
	    var re = this;
	    var state = getInternalState$5(re);
	    var str = toString$j(string);
	    var raw = state.raw;
	    var result, reCopy, lastIndex, match, i, object, group;
	    if (raw) {
	      raw.lastIndex = re.lastIndex;
	      result = call$g(patchedExec, raw, str);
	      re.lastIndex = raw.lastIndex;
	      return result;
	    }
	    var groups = state.groups;
	    var sticky = UNSUPPORTED_Y$1 && re.sticky;
	    var flags = call$g(regexpFlags, re);
	    var source = re.source;
	    var charsAdded = 0;
	    var strCopy = str;
	    if (sticky) {
	      flags = replace$7(flags, 'y', '');
	      if (indexOf$1(flags, 'g') === -1) {
	        flags += 'g';
	      }
	      strCopy = stringSlice$a(str, re.lastIndex);
	      // Support anchored sticky behavior.
	      if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt$a(str, re.lastIndex - 1) !== '\n')) {
	        source = '(?: ' + source + ')';
	        strCopy = ' ' + strCopy;
	        charsAdded++;
	      }
	      // ^(? + rx + ) is needed, in combination with some str slicing, to
	      // simulate the 'y' flag.
	      reCopy = new RegExp('^(?:' + source + ')', flags);
	    }
	    if (NPCG_INCLUDED) {
	      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
	    }
	    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
	    match = call$g(nativeExec, sticky ? reCopy : re, strCopy);
	    if (sticky) {
	      if (match) {
	        match.input = stringSlice$a(match.input, charsAdded);
	        match[0] = stringSlice$a(match[0], charsAdded);
	        match.index = re.lastIndex;
	        re.lastIndex += match[0].length;
	      } else re.lastIndex = 0;
	    } else if (UPDATES_LAST_INDEX_WRONG && match) {
	      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
	    }
	    if (NPCG_INCLUDED && match && match.length > 1) {
	      // Fix browsers whose `exec` methods don't consistently return `undefined`
	      // for NPCG, like IE8. NOTE: This doesn't work for /(.?)?/
	      call$g(nativeReplace, match[0], reCopy, function () {
	        for (i = 1; i < arguments.length - 2; i++) {
	          if (arguments[i] === undefined) match[i] = undefined;
	        }
	      });
	    }
	    if (match && groups) {
	      match.groups = object = create$3(null);
	      for (i = 0; i < groups.length; i++) {
	        group = groups[i];
	        object[group[0]] = match[group[1]];
	      }
	    }
	    return match;
	  };
	}
	var regexpExec$3 = patchedExec;
	var regexpExec$4 = /*@__PURE__*/getDefaultExportFromCjs(regexpExec$3);

	'use strict';
	var $$M = _export;
	var exec$5 = regexpExec$3;

	// `RegExp.prototype.exec` method
	// https://tc39.es/ecma262/#sec-regexp.prototype.exec
	$$M({
	  target: 'RegExp',
	  proto: true,
	  forced: /./.exec !== exec$5
	}, {
	  exec: exec$5
	});

	var es_regexp_flags = {};

	var global$p = global$Z;
	var DESCRIPTORS$9 = descriptors;
	var defineBuiltInAccessor$7 = defineBuiltInAccessor$h;
	var regExpFlags = regexpFlags$1;
	var fails$n = fails$1m;

	// babel-minify and Closure Compiler transpiles RegExp('.', 'd') -> /./d and it causes SyntaxError
	var RegExp$2 = global$p.RegExp;
	var RegExpPrototype$4 = RegExp$2.prototype;
	var FORCED$4 = DESCRIPTORS$9 && fails$n(function () {
	  var INDICES_SUPPORT = true;
	  try {
	    RegExp$2('.', 'd');
	  } catch (error) {
	    INDICES_SUPPORT = false;
	  }
	  var O = {};
	  // modern V8 bug
	  var calls = '';
	  var expected = INDICES_SUPPORT ? 'dgimsy' : 'gimsy';
	  var addGetter = function addGetter(key, chr) {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty(O, key, {
	      get: function get() {
	        calls += chr;
	        return true;
	      }
	    });
	  };
	  var pairs = {
	    dotAll: 's',
	    global: 'g',
	    ignoreCase: 'i',
	    multiline: 'm',
	    sticky: 'y'
	  };
	  if (INDICES_SUPPORT) pairs.hasIndices = 'd';
	  for (var key in pairs) addGetter(key, pairs[key]);

	  // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	  var result = Object.getOwnPropertyDescriptor(RegExpPrototype$4, 'flags').get.call(O);
	  return result !== expected || calls !== expected;
	});

	// `RegExp.prototype.flags` getter
	// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
	if (FORCED$4) defineBuiltInAccessor$7(RegExpPrototype$4, 'flags', {
	  configurable: true,
	  get: regExpFlags
	});

	var es_regexp_sticky = {};

	var DESCRIPTORS$8 = descriptors;
	var MISSED_STICKY = regexpStickyHelpers.MISSED_STICKY;
	var classof$7 = classofRaw$2;
	var defineBuiltInAccessor$6 = defineBuiltInAccessor$h;
	var getInternalState$4 = internalState.get;
	var RegExpPrototype$3 = RegExp.prototype;
	var $TypeError$6 = TypeError;

	// `RegExp.prototype.sticky` getter
	// https://tc39.es/ecma262/#sec-get-regexp.prototype.sticky
	if (DESCRIPTORS$8 && MISSED_STICKY) {
	  defineBuiltInAccessor$6(RegExpPrototype$3, 'sticky', {
	    configurable: true,
	    get: function sticky() {
	      if (this === RegExpPrototype$3) return;
	      // We can't use InternalStateModule.getterFor because
	      // we don't add metadata for regexps created by a literal.
	      if (classof$7(this) === 'RegExp') {
	        return !!getInternalState$4(this).sticky;
	      }
	      throw $TypeError$6('Incompatible receiver, RegExp required');
	    }
	  });
	}

	var es_regexp_test = {};

	'use strict';
	// TODO: Remove from `core-js@4` since it's moved to entry points

	var $$L = _export;
	var call$f = functionCall;
	var isCallable$6 = isCallable$z;
	var anObject$b = anObject$D;
	var toString$i = toString$x;
	var DELEGATES_TO_EXEC = function () {
	  var execCalled = false;
	  var re = /[ac]/;
	  re.exec = function () {
	    execCalled = true;
	    return /./.exec.apply(this, arguments);
	  };
	  return re.test('abc') === true && execCalled;
	}();
	var nativeTest = /./.test;

	// `RegExp.prototype.test` method
	// https://tc39.es/ecma262/#sec-regexp.prototype.test
	$$L({
	  target: 'RegExp',
	  proto: true,
	  forced: !DELEGATES_TO_EXEC
	}, {
	  test: function test(S) {
	    var R = anObject$b(this);
	    var string = toString$i(S);
	    var exec = R.exec;
	    if (!isCallable$6(exec)) return call$f(nativeTest, R, string);
	    var result = call$f(exec, R, string);
	    if (result === null) return false;
	    anObject$b(result);
	    return true;
	  }
	});

	var es_regexp_toString = {};

	'use strict';
	var PROPER_FUNCTION_NAME$1 = functionName.PROPER;
	var defineBuiltIn$5 = defineBuiltIn$m;
	var anObject$a = anObject$D;
	var $toString$2 = toString$x;
	var fails$m = fails$1m;
	var getRegExpFlags$3 = regexpGetFlags;
	var TO_STRING = 'toString';
	var RegExpPrototype$2 = RegExp.prototype;
	var nativeToString = RegExpPrototype$2[TO_STRING];
	var NOT_GENERIC = fails$m(function () {
	  return nativeToString.call({
	    source: 'a',
	    flags: 'b'
	  }) != '/a/b';
	});
	// FF44- RegExp#toString has a wrong name
	var INCORRECT_NAME = PROPER_FUNCTION_NAME$1 && nativeToString.name != TO_STRING;

	// `RegExp.prototype.toString` method
	// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
	if (NOT_GENERIC || INCORRECT_NAME) {
	  defineBuiltIn$5(RegExp.prototype, TO_STRING, function toString() {
	    var R = anObject$a(this);
	    var pattern = $toString$2(R.source);
	    var flags = $toString$2(getRegExpFlags$3(R));
	    return '/' + pattern + '/' + flags;
	  }, {
	    unsafe: true
	  });
	}

	var es_set = {};

	var es_set_constructor = {};

	'use strict';
	var collection$2 = collection$4;
	var collectionStrong = collectionStrong$2;

	// `Set` constructor
	// https://tc39.es/ecma262/#sec-set-objects
	collection$2('Set', function (init) {
	  return function Set() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	var es_string_atAlternative = {};

	'use strict';
	var $$K = _export;
	var uncurryThis$x = functionUncurryThis;
	var requireObjectCoercible$c = requireObjectCoercible$j;
	var toIntegerOrInfinity$6 = toIntegerOrInfinity$l;
	var toString$h = toString$x;
	var fails$l = fails$1m;
	var charAt$9 = uncurryThis$x(''.charAt);
	var FORCED$3 = fails$l(function () {
	  // eslint-disable-next-line es/no-array-string-prototype-at -- safe
	  return '𠮷'.at(-2) !== "\uD842";
	});

	// `String.prototype.at` method
	// https://github.com/tc39/proposal-relative-indexing-method
	$$K({
	  target: 'String',
	  proto: true,
	  forced: FORCED$3
	}, {
	  at: function at(index) {
	    var S = toString$h(requireObjectCoercible$c(this));
	    var len = S.length;
	    var relativeIndex = toIntegerOrInfinity$6(index);
	    var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
	    return k < 0 || k >= len ? undefined : charAt$9(S, k);
	  }
	});

	var es_string_codePointAt = {};

	var uncurryThis$w = functionUncurryThis;
	var toIntegerOrInfinity$5 = toIntegerOrInfinity$l;
	var toString$g = toString$x;
	var requireObjectCoercible$b = requireObjectCoercible$j;
	var charAt$8 = uncurryThis$w(''.charAt);
	var charCodeAt$2 = uncurryThis$w(''.charCodeAt);
	var stringSlice$9 = uncurryThis$w(''.slice);
	var createMethod = function createMethod(CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = toString$g(requireObjectCoercible$b($this));
	    var position = toIntegerOrInfinity$5(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = charCodeAt$2(S, position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = charCodeAt$2(S, position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? charAt$8(S, position) : first : CONVERT_TO_STRING ? stringSlice$9(S, position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};
	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod(true)
	};
	var stringMultibyte$1 = /*@__PURE__*/getDefaultExportFromCjs(stringMultibyte);

	'use strict';
	var $$J = _export;
	var codeAt$1 = stringMultibyte.codeAt;

	// `String.prototype.codePointAt` method
	// https://tc39.es/ecma262/#sec-string.prototype.codepointat
	$$J({
	  target: 'String',
	  proto: true
	}, {
	  codePointAt: function codePointAt(pos) {
	    return codeAt$1(this, pos);
	  }
	});

	var es_string_endsWith = {};

	var isRegExp$3 = isRegexp;
	var $TypeError$5 = TypeError;
	var notARegexp = function notARegexp(it) {
	  if (isRegExp$3(it)) {
	    throw $TypeError$5("The method doesn't accept regular expressions");
	  }
	  return it;
	};
	var notARegexp$1 = /*@__PURE__*/getDefaultExportFromCjs(notARegexp);

	var wellKnownSymbol$8 = wellKnownSymbol$z;
	var MATCH = wellKnownSymbol$8('match');
	var correctIsRegexpLogic = function correctIsRegexpLogic(METHOD_NAME) {
	  var regexp = /./;
	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (error1) {
	    try {
	      regexp[MATCH] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (error2) {/* empty */}
	  }
	  return false;
	};
	var correctIsRegexpLogic$1 = /*@__PURE__*/getDefaultExportFromCjs(correctIsRegexpLogic);

	'use strict';
	var $$I = _export;
	var uncurryThis$v = functionUncurryThisClause;
	var getOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
	var toLength$7 = toLength$d;
	var toString$f = toString$x;
	var notARegExp$2 = notARegexp;
	var requireObjectCoercible$a = requireObjectCoercible$j;
	var correctIsRegExpLogic$2 = correctIsRegexpLogic;
	var IS_PURE$7 = isPure;

	// eslint-disable-next-line es/no-string-prototype-endswith -- safe
	var nativeEndsWith = uncurryThis$v(''.endsWith);
	var slice$4 = uncurryThis$v(''.slice);
	var min$8 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC$1 = correctIsRegExpLogic$2('endsWith');
	// https://github.com/zloirock/core-js/pull/702
	var MDN_POLYFILL_BUG$1 = !IS_PURE$7 && !CORRECT_IS_REGEXP_LOGIC$1 && !!function () {
	  var descriptor = getOwnPropertyDescriptor$2(String.prototype, 'endsWith');
	  return descriptor && !descriptor.writable;
	}();

	// `String.prototype.endsWith` method
	// https://tc39.es/ecma262/#sec-string.prototype.endswith
	$$I({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG$1 && !CORRECT_IS_REGEXP_LOGIC$1
	}, {
	  endsWith: function endsWith(searchString /* , endPosition = @length */) {
	    var that = toString$f(requireObjectCoercible$a(this));
	    notARegExp$2(searchString);
	    var endPosition = arguments.length > 1 ? arguments[1] : undefined;
	    var len = that.length;
	    var end = endPosition === undefined ? len : min$8(toLength$7(endPosition), len);
	    var search = toString$f(searchString);
	    return nativeEndsWith ? nativeEndsWith(that, search, end) : slice$4(that, end - search.length, end) === search;
	  }
	});

	var es_string_fromCodePoint = {};

	var $$H = _export;
	var uncurryThis$u = functionUncurryThis;
	var toAbsoluteIndex$1 = toAbsoluteIndex$a;
	var $RangeError$3 = RangeError;
	var fromCharCode$3 = String.fromCharCode;
	// eslint-disable-next-line es/no-string-fromcodepoint -- required for testing
	var $fromCodePoint = String.fromCodePoint;
	var join$5 = uncurryThis$u([].join);

	// length should be 1, old FF problem
	var INCORRECT_LENGTH = !!$fromCodePoint && $fromCodePoint.length != 1;

	// `String.fromCodePoint` method
	// https://tc39.es/ecma262/#sec-string.fromcodepoint
	$$H({
	  target: 'String',
	  stat: true,
	  arity: 1,
	  forced: INCORRECT_LENGTH
	}, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  fromCodePoint: function fromCodePoint(x) {
	    var elements = [];
	    var length = arguments.length;
	    var i = 0;
	    var code;
	    while (length > i) {
	      code = +arguments[i++];
	      if (toAbsoluteIndex$1(code, 0x10FFFF) !== code) throw $RangeError$3(code + ' is not a valid code point');
	      elements[i] = code < 0x10000 ? fromCharCode$3(code) : fromCharCode$3(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00);
	    }
	    return join$5(elements, '');
	  }
	});

	var es_string_includes = {};

	'use strict';
	var $$G = _export;
	var uncurryThis$t = functionUncurryThis;
	var notARegExp$1 = notARegexp;
	var requireObjectCoercible$9 = requireObjectCoercible$j;
	var toString$e = toString$x;
	var correctIsRegExpLogic$1 = correctIsRegexpLogic;
	var stringIndexOf$3 = uncurryThis$t(''.indexOf);

	// `String.prototype.includes` method
	// https://tc39.es/ecma262/#sec-string.prototype.includes
	$$G({
	  target: 'String',
	  proto: true,
	  forced: !correctIsRegExpLogic$1('includes')
	}, {
	  includes: function includes(searchString /* , position = 0 */) {
	    return !!~stringIndexOf$3(toString$e(requireObjectCoercible$9(this)), toString$e(notARegExp$1(searchString)), arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_string_iterator = {};

	'use strict';
	var charAt$7 = stringMultibyte.charAt;
	var toString$d = toString$x;
	var InternalStateModule$6 = internalState;
	var defineIterator = iteratorDefine;
	var createIterResultObject$1 = createIterResultObject$4;
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$6 = InternalStateModule$6.set;
	var getInternalState$3 = InternalStateModule$6.getterFor(STRING_ITERATOR);

	// `String.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
	defineIterator(String, 'String', function (iterated) {
	  setInternalState$6(this, {
	    type: STRING_ITERATOR,
	    string: toString$d(iterated),
	    index: 0
	  });
	  // `%StringIteratorPrototype%.next` method
	  // https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$3(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return createIterResultObject$1(undefined, true);
	  point = charAt$7(string, index);
	  state.index += point.length;
	  return createIterResultObject$1(point, false);
	});

	var es_string_match = {};

	'use strict';
	// TODO: Remove from `core-js@4` since it's moved to entry points

	var uncurryThis$s = functionUncurryThisClause;
	var defineBuiltIn$4 = defineBuiltIn$m;
	var regexpExec$2 = regexpExec$3;
	var fails$k = fails$1m;
	var wellKnownSymbol$7 = wellKnownSymbol$z;
	var createNonEnumerableProperty$4 = createNonEnumerableProperty$f;
	var SPECIES = wellKnownSymbol$7('species');
	var RegExpPrototype$1 = RegExp.prototype;
	var fixRegexpWellKnownSymbolLogic = function fixRegexpWellKnownSymbolLogic(KEY, exec, FORCED, SHAM) {
	  var SYMBOL = wellKnownSymbol$7(KEY);
	  var DELEGATES_TO_SYMBOL = !fails$k(function () {
	    // String methods call symbol-named RegEp methods
	    var O = {};
	    O[SYMBOL] = function () {
	      return 7;
	    };
	    return ''[KEY](O) != 7;
	  });
	  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$k(function () {
	    // Symbol-named RegExp methods call .exec
	    var execCalled = false;
	    var re = /a/;
	    if (KEY === 'split') {
	      // We can't use real regex here since it causes deoptimization
	      // and serious performance degradation in V8
	      // https://github.com/zloirock/core-js/issues/306
	      re = {};
	      // RegExp[@@split] doesn't call the regex's exec method, but first creates
	      // a new one. We need to return the patched regex when creating the new one.
	      re.constructor = {};
	      re.constructor[SPECIES] = function () {
	        return re;
	      };
	      re.flags = '';
	      re[SYMBOL] = /./[SYMBOL];
	    }
	    re.exec = function () {
	      execCalled = true;
	      return null;
	    };
	    re[SYMBOL]('');
	    return !execCalled;
	  });
	  if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || FORCED) {
	    var uncurriedNativeRegExpMethod = uncurryThis$s(/./[SYMBOL]);
	    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
	      var uncurriedNativeMethod = uncurryThis$s(nativeMethod);
	      var $exec = regexp.exec;
	      if ($exec === regexpExec$2 || $exec === RegExpPrototype$1.exec) {
	        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
	          // The native String method already delegates to @@method (this
	          // polyfilled function), leasing to infinite recursion.
	          // We avoid it by directly calling the native @@method method.
	          return {
	            done: true,
	            value: uncurriedNativeRegExpMethod(regexp, str, arg2)
	          };
	        }
	        return {
	          done: true,
	          value: uncurriedNativeMethod(str, regexp, arg2)
	        };
	      }
	      return {
	        done: false
	      };
	    });
	    defineBuiltIn$4(String.prototype, KEY, methods[0]);
	    defineBuiltIn$4(RegExpPrototype$1, SYMBOL, methods[1]);
	  }
	  if (SHAM) createNonEnumerableProperty$4(RegExpPrototype$1[SYMBOL], 'sham', true);
	};
	var fixRegexpWellKnownSymbolLogic$1 = /*@__PURE__*/getDefaultExportFromCjs(fixRegexpWellKnownSymbolLogic);

	'use strict';
	var charAt$6 = stringMultibyte.charAt;

	// `AdvanceStringIndex` abstract operation
	// https://tc39.es/ecma262/#sec-advancestringindex
	var advanceStringIndex$4 = function advanceStringIndex(S, index, unicode) {
	  return index + (unicode ? charAt$6(S, index).length : 1);
	};
	var advanceStringIndex$5 = /*@__PURE__*/getDefaultExportFromCjs(advanceStringIndex$4);

	var call$e = functionCall;
	var anObject$9 = anObject$D;
	var isCallable$5 = isCallable$z;
	var classof$6 = classofRaw$2;
	var regexpExec$1 = regexpExec$3;
	var $TypeError$4 = TypeError;

	// `RegExpExec` abstract operation
	// https://tc39.es/ecma262/#sec-regexpexec
	var regexpExecAbstract = function regexpExecAbstract(R, S) {
	  var exec = R.exec;
	  if (isCallable$5(exec)) {
	    var result = call$e(exec, R, S);
	    if (result !== null) anObject$9(result);
	    return result;
	  }
	  if (classof$6(R) === 'RegExp') return call$e(regexpExec$1, R, S);
	  throw $TypeError$4('RegExp#exec called on incompatible receiver');
	};
	var regexpExecAbstract$1 = /*@__PURE__*/getDefaultExportFromCjs(regexpExecAbstract);

	'use strict';
	var call$d = functionCall;
	var fixRegExpWellKnownSymbolLogic$3 = fixRegexpWellKnownSymbolLogic;
	var anObject$8 = anObject$D;
	var isNullOrUndefined$7 = isNullOrUndefined$e;
	var toLength$6 = toLength$d;
	var toString$c = toString$x;
	var requireObjectCoercible$8 = requireObjectCoercible$j;
	var getMethod$5 = getMethod$9;
	var advanceStringIndex$3 = advanceStringIndex$4;
	var regExpExec$3 = regexpExecAbstract;

	// @@match logic
	fixRegExpWellKnownSymbolLogic$3('match', function (MATCH, nativeMatch, maybeCallNative) {
	  return [
	  // `String.prototype.match` method
	  // https://tc39.es/ecma262/#sec-string.prototype.match
	  function match(regexp) {
	    var O = requireObjectCoercible$8(this);
	    var matcher = isNullOrUndefined$7(regexp) ? undefined : getMethod$5(regexp, MATCH);
	    return matcher ? call$d(matcher, regexp, O) : new RegExp(regexp)[MATCH](toString$c(O));
	  },
	  // `RegExp.prototype[@@match]` method
	  // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
	  function (string) {
	    var rx = anObject$8(this);
	    var S = toString$c(string);
	    var res = maybeCallNative(nativeMatch, rx, S);
	    if (res.done) return res.value;
	    if (!rx.global) return regExpExec$3(rx, S);
	    var fullUnicode = rx.unicode;
	    rx.lastIndex = 0;
	    var A = [];
	    var n = 0;
	    var result;
	    while ((result = regExpExec$3(rx, S)) !== null) {
	      var matchStr = toString$c(result[0]);
	      A[n] = matchStr;
	      if (matchStr === '') rx.lastIndex = advanceStringIndex$3(S, toLength$6(rx.lastIndex), fullUnicode);
	      n++;
	    }
	    return n === 0 ? null : A;
	  }];
	});

	var es_string_matchAll = {};

	'use strict';
	/* eslint-disable es/no-string-prototype-matchall -- safe */
	var $$F = _export;
	var call$c = functionCall;
	var uncurryThis$r = functionUncurryThisClause;
	var createIteratorConstructor$1 = iteratorCreateConstructor;
	var createIterResultObject = createIterResultObject$4;
	var requireObjectCoercible$7 = requireObjectCoercible$j;
	var toLength$5 = toLength$d;
	var toString$b = toString$x;
	var anObject$7 = anObject$D;
	var isNullOrUndefined$6 = isNullOrUndefined$e;
	var classof$5 = classofRaw$2;
	var isRegExp$2 = isRegexp;
	var getRegExpFlags$2 = regexpGetFlags;
	var getMethod$4 = getMethod$9;
	var defineBuiltIn$3 = defineBuiltIn$m;
	var fails$j = fails$1m;
	var wellKnownSymbol$6 = wellKnownSymbol$z;
	var speciesConstructor$2 = speciesConstructor$6;
	var advanceStringIndex$2 = advanceStringIndex$4;
	var regExpExec$2 = regexpExecAbstract;
	var InternalStateModule$5 = internalState;
	var IS_PURE$6 = isPure;
	var MATCH_ALL = wellKnownSymbol$6('matchAll');
	var REGEXP_STRING = 'RegExp String';
	var REGEXP_STRING_ITERATOR = REGEXP_STRING + ' Iterator';
	var setInternalState$5 = InternalStateModule$5.set;
	var getInternalState$2 = InternalStateModule$5.getterFor(REGEXP_STRING_ITERATOR);
	var RegExpPrototype = RegExp.prototype;
	var $TypeError$3 = TypeError;
	var stringIndexOf$2 = uncurryThis$r(''.indexOf);
	var nativeMatchAll = uncurryThis$r(''.matchAll);
	var WORKS_WITH_NON_GLOBAL_REGEX = !!nativeMatchAll && !fails$j(function () {
	  nativeMatchAll('a', /./);
	});
	var $RegExpStringIterator = createIteratorConstructor$1(function RegExpStringIterator(regexp, string, $global, fullUnicode) {
	  setInternalState$5(this, {
	    type: REGEXP_STRING_ITERATOR,
	    regexp: regexp,
	    string: string,
	    global: $global,
	    unicode: fullUnicode,
	    done: false
	  });
	}, REGEXP_STRING, function next() {
	  var state = getInternalState$2(this);
	  if (state.done) return createIterResultObject(undefined, true);
	  var R = state.regexp;
	  var S = state.string;
	  var match = regExpExec$2(R, S);
	  if (match === null) {
	    state.done = true;
	    return createIterResultObject(undefined, true);
	  }
	  if (state.global) {
	    if (toString$b(match[0]) === '') R.lastIndex = advanceStringIndex$2(S, toLength$5(R.lastIndex), state.unicode);
	    return createIterResultObject(match, false);
	  }
	  state.done = true;
	  return createIterResultObject(match, false);
	});
	var $matchAll = function $matchAll(string) {
	  var R = anObject$7(this);
	  var S = toString$b(string);
	  var C = speciesConstructor$2(R, RegExp);
	  var flags = toString$b(getRegExpFlags$2(R));
	  var matcher, $global, fullUnicode;
	  matcher = new C(C === RegExp ? R.source : R, flags);
	  $global = !!~stringIndexOf$2(flags, 'g');
	  fullUnicode = !!~stringIndexOf$2(flags, 'u');
	  matcher.lastIndex = toLength$5(R.lastIndex);
	  return new $RegExpStringIterator(matcher, S, $global, fullUnicode);
	};

	// `String.prototype.matchAll` method
	// https://tc39.es/ecma262/#sec-string.prototype.matchall
	$$F({
	  target: 'String',
	  proto: true,
	  forced: WORKS_WITH_NON_GLOBAL_REGEX
	}, {
	  matchAll: function matchAll(regexp) {
	    var O = requireObjectCoercible$7(this);
	    var flags, S, matcher, rx;
	    if (!isNullOrUndefined$6(regexp)) {
	      if (isRegExp$2(regexp)) {
	        flags = toString$b(requireObjectCoercible$7(getRegExpFlags$2(regexp)));
	        if (!~stringIndexOf$2(flags, 'g')) throw $TypeError$3('`.matchAll` does not allow non-global regexes');
	      }
	      if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll(O, regexp);
	      matcher = getMethod$4(regexp, MATCH_ALL);
	      if (matcher === undefined && IS_PURE$6 && classof$5(regexp) == 'RegExp') matcher = $matchAll;
	      if (matcher) return call$c(matcher, regexp, O);
	    } else if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll(O, regexp);
	    S = toString$b(O);
	    rx = new RegExp(regexp, 'g');
	    return IS_PURE$6 ? call$c($matchAll, rx, S) : rx[MATCH_ALL](S);
	  }
	});
	IS_PURE$6 || MATCH_ALL in RegExpPrototype || defineBuiltIn$3(RegExpPrototype, MATCH_ALL, $matchAll);

	var es_string_padEnd = {};

	// https://github.com/zloirock/core-js/issues/280
	var userAgent = engineUserAgent;
	var stringPadWebkitBug = /Version\/10(?:\.\d+){1,2}(?: [\w./]+)?(?: Mobile\/\w+)? Safari\//.test(userAgent);
	var stringPadWebkitBug$1 = /*@__PURE__*/getDefaultExportFromCjs(stringPadWebkitBug);

	'use strict';
	var $$E = _export;
	var $padEnd = stringPad.end;
	var WEBKIT_BUG$1 = stringPadWebkitBug;

	// `String.prototype.padEnd` method
	// https://tc39.es/ecma262/#sec-string.prototype.padend
	$$E({
	  target: 'String',
	  proto: true,
	  forced: WEBKIT_BUG$1
	}, {
	  padEnd: function padEnd(maxLength /* , fillString = ' ' */) {
	    return $padEnd(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_string_padStart = {};

	'use strict';
	var $$D = _export;
	var $padStart = stringPad.start;
	var WEBKIT_BUG = stringPadWebkitBug;

	// `String.prototype.padStart` method
	// https://tc39.es/ecma262/#sec-string.prototype.padstart
	$$D({
	  target: 'String',
	  proto: true,
	  forced: WEBKIT_BUG
	}, {
	  padStart: function padStart(maxLength /* , fillString = ' ' */) {
	    return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var es_string_raw = {};

	var $$C = _export;
	var uncurryThis$q = functionUncurryThis;
	var toIndexedObject$1 = toIndexedObject$j;
	var toObject$2 = toObject$t;
	var toString$a = toString$x;
	var lengthOfArrayLike$4 = lengthOfArrayLike$t;
	var push$6 = uncurryThis$q([].push);
	var join$4 = uncurryThis$q([].join);

	// `String.raw` method
	// https://tc39.es/ecma262/#sec-string.raw
	$$C({
	  target: 'String',
	  stat: true
	}, {
	  raw: function raw(template) {
	    var rawTemplate = toIndexedObject$1(toObject$2(template).raw);
	    var literalSegments = lengthOfArrayLike$4(rawTemplate);
	    if (!literalSegments) return '';
	    var argumentsLength = arguments.length;
	    var elements = [];
	    var i = 0;
	    while (true) {
	      push$6(elements, toString$a(rawTemplate[i++]));
	      if (i === literalSegments) return join$4(elements, '');
	      if (i < argumentsLength) push$6(elements, toString$a(arguments[i]));
	    }
	  }
	});

	var es_string_repeat = {};

	var $$B = _export;
	var repeat$1 = stringRepeat;

	// `String.prototype.repeat` method
	// https://tc39.es/ecma262/#sec-string.prototype.repeat
	$$B({
	  target: 'String',
	  proto: true
	}, {
	  repeat: repeat$1
	});

	var es_string_replace = {};

	var uncurryThis$p = functionUncurryThis;
	var toObject$1 = toObject$t;
	var floor$6 = Math.floor;
	var charAt$5 = uncurryThis$p(''.charAt);
	var replace$6 = uncurryThis$p(''.replace);
	var stringSlice$8 = uncurryThis$p(''.slice);
	// eslint-disable-next-line redos/no-vulnerable -- safe
	var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
	var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;

	// `GetSubstitution` abstract operation
	// https://tc39.es/ecma262/#sec-getsubstitution
	var getSubstitution$2 = function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
	  var tailPos = position + matched.length;
	  var m = captures.length;
	  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
	  if (namedCaptures !== undefined) {
	    namedCaptures = toObject$1(namedCaptures);
	    symbols = SUBSTITUTION_SYMBOLS;
	  }
	  return replace$6(replacement, symbols, function (match, ch) {
	    var capture;
	    switch (charAt$5(ch, 0)) {
	      case '$':
	        return '$';
	      case '&':
	        return matched;
	      case '`':
	        return stringSlice$8(str, 0, position);
	      case "'":
	        return stringSlice$8(str, tailPos);
	      case '<':
	        capture = namedCaptures[stringSlice$8(ch, 1, -1)];
	        break;
	      default:
	        // \d\d?
	        var n = +ch;
	        if (n === 0) return match;
	        if (n > m) {
	          var f = floor$6(n / 10);
	          if (f === 0) return match;
	          if (f <= m) return captures[f - 1] === undefined ? charAt$5(ch, 1) : captures[f - 1] + charAt$5(ch, 1);
	          return match;
	        }
	        capture = captures[n - 1];
	    }
	    return capture === undefined ? '' : capture;
	  });
	};
	var getSubstitution$3 = /*@__PURE__*/getDefaultExportFromCjs(getSubstitution$2);

	'use strict';
	var apply$4 = functionApply$1;
	var call$b = functionCall;
	var uncurryThis$o = functionUncurryThis;
	var fixRegExpWellKnownSymbolLogic$2 = fixRegexpWellKnownSymbolLogic;
	var fails$i = fails$1m;
	var anObject$6 = anObject$D;
	var isCallable$4 = isCallable$z;
	var isNullOrUndefined$5 = isNullOrUndefined$e;
	var toIntegerOrInfinity$4 = toIntegerOrInfinity$l;
	var toLength$4 = toLength$d;
	var toString$9 = toString$x;
	var requireObjectCoercible$6 = requireObjectCoercible$j;
	var advanceStringIndex$1 = advanceStringIndex$4;
	var getMethod$3 = getMethod$9;
	var getSubstitution$1 = getSubstitution$2;
	var regExpExec$1 = regexpExecAbstract;
	var wellKnownSymbol$5 = wellKnownSymbol$z;
	var REPLACE$1 = wellKnownSymbol$5('replace');
	var max$6 = Math.max;
	var min$7 = Math.min;
	var concat$3 = uncurryThis$o([].concat);
	var push$5 = uncurryThis$o([].push);
	var stringIndexOf$1 = uncurryThis$o(''.indexOf);
	var stringSlice$7 = uncurryThis$o(''.slice);
	var maybeToString = function maybeToString(it) {
	  return it === undefined ? it : String(it);
	};

	// IE <= 11 replaces $0 with the whole match, as if it was $&
	// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
	var REPLACE_KEEPS_$0 = function () {
	  // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
	  return 'a'.replace(/./, '$0') === '$0';
	}();

	// Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
	var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = function () {
	  if (/./[REPLACE$1]) {
	    return /./[REPLACE$1]('a', '$0') === '';
	  }
	  return false;
	}();
	var REPLACE_SUPPORTS_NAMED_GROUPS = !fails$i(function () {
	  var re = /./;
	  re.exec = function () {
	    var result = [];
	    result.groups = {
	      a: '7'
	    };
	    return result;
	  };
	  // eslint-disable-next-line regexp/no-useless-dollar-replacements -- false positive
	  return ''.replace(re, '$<a>') !== '7';
	});

	// @@replace logic
	fixRegExpWellKnownSymbolLogic$2('replace', function (_, nativeReplace, maybeCallNative) {
	  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
	  return [
	  // `String.prototype.replace` method
	  // https://tc39.es/ecma262/#sec-string.prototype.replace
	  function replace(searchValue, replaceValue) {
	    var O = requireObjectCoercible$6(this);
	    var replacer = isNullOrUndefined$5(searchValue) ? undefined : getMethod$3(searchValue, REPLACE$1);
	    return replacer ? call$b(replacer, searchValue, O, replaceValue) : call$b(nativeReplace, toString$9(O), searchValue, replaceValue);
	  },
	  // `RegExp.prototype[@@replace]` method
	  // https://tc39.es/ecma262/#sec-regexp.prototype-@@replace
	  function (string, replaceValue) {
	    var rx = anObject$6(this);
	    var S = toString$9(string);
	    if (typeof replaceValue == 'string' && stringIndexOf$1(replaceValue, UNSAFE_SUBSTITUTE) === -1 && stringIndexOf$1(replaceValue, '$<') === -1) {
	      var res = maybeCallNative(nativeReplace, rx, S, replaceValue);
	      if (res.done) return res.value;
	    }
	    var functionalReplace = isCallable$4(replaceValue);
	    if (!functionalReplace) replaceValue = toString$9(replaceValue);
	    var global = rx.global;
	    if (global) {
	      var fullUnicode = rx.unicode;
	      rx.lastIndex = 0;
	    }
	    var results = [];
	    while (true) {
	      var result = regExpExec$1(rx, S);
	      if (result === null) break;
	      push$5(results, result);
	      if (!global) break;
	      var matchStr = toString$9(result[0]);
	      if (matchStr === '') rx.lastIndex = advanceStringIndex$1(S, toLength$4(rx.lastIndex), fullUnicode);
	    }
	    var accumulatedResult = '';
	    var nextSourcePosition = 0;
	    for (var i = 0; i < results.length; i++) {
	      result = results[i];
	      var matched = toString$9(result[0]);
	      var position = max$6(min$7(toIntegerOrInfinity$4(result.index), S.length), 0);
	      var captures = [];
	      // NOTE: This is equivalent to
	      //   captures = result.slice(1).map(maybeToString)
	      // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
	      // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
	      // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
	      for (var j = 1; j < result.length; j++) push$5(captures, maybeToString(result[j]));
	      var namedCaptures = result.groups;
	      if (functionalReplace) {
	        var replacerArgs = concat$3([matched], captures, position, S);
	        if (namedCaptures !== undefined) push$5(replacerArgs, namedCaptures);
	        var replacement = toString$9(apply$4(replaceValue, undefined, replacerArgs));
	      } else {
	        replacement = getSubstitution$1(matched, S, position, captures, namedCaptures, replaceValue);
	      }
	      if (position >= nextSourcePosition) {
	        accumulatedResult += stringSlice$7(S, nextSourcePosition, position) + replacement;
	        nextSourcePosition = position + matched.length;
	      }
	    }
	    return accumulatedResult + stringSlice$7(S, nextSourcePosition);
	  }];
	}, !REPLACE_SUPPORTS_NAMED_GROUPS || !REPLACE_KEEPS_$0 || REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE);

	var es_string_replaceAll = {};

	'use strict';
	var $$A = _export;
	var call$a = functionCall;
	var uncurryThis$n = functionUncurryThis;
	var requireObjectCoercible$5 = requireObjectCoercible$j;
	var isCallable$3 = isCallable$z;
	var isNullOrUndefined$4 = isNullOrUndefined$e;
	var isRegExp$1 = isRegexp;
	var toString$8 = toString$x;
	var getMethod$2 = getMethod$9;
	var getRegExpFlags$1 = regexpGetFlags;
	var getSubstitution = getSubstitution$2;
	var wellKnownSymbol$4 = wellKnownSymbol$z;
	var IS_PURE$5 = isPure;
	var REPLACE = wellKnownSymbol$4('replace');
	var $TypeError$2 = TypeError;
	var indexOf = uncurryThis$n(''.indexOf);
	var replace$5 = uncurryThis$n(''.replace);
	var stringSlice$6 = uncurryThis$n(''.slice);
	var max$5 = Math.max;
	var stringIndexOf = function stringIndexOf(string, searchValue, fromIndex) {
	  if (fromIndex > string.length) return -1;
	  if (searchValue === '') return fromIndex;
	  return indexOf(string, searchValue, fromIndex);
	};

	// `String.prototype.replaceAll` method
	// https://tc39.es/ecma262/#sec-string.prototype.replaceall
	$$A({
	  target: 'String',
	  proto: true
	}, {
	  replaceAll: function replaceAll(searchValue, replaceValue) {
	    var O = requireObjectCoercible$5(this);
	    var IS_REG_EXP, flags, replacer, string, searchString, functionalReplace, searchLength, advanceBy, replacement;
	    var position = 0;
	    var endOfLastMatch = 0;
	    var result = '';
	    if (!isNullOrUndefined$4(searchValue)) {
	      IS_REG_EXP = isRegExp$1(searchValue);
	      if (IS_REG_EXP) {
	        flags = toString$8(requireObjectCoercible$5(getRegExpFlags$1(searchValue)));
	        if (!~indexOf(flags, 'g')) throw $TypeError$2('`.replaceAll` does not allow non-global regexes');
	      }
	      replacer = getMethod$2(searchValue, REPLACE);
	      if (replacer) {
	        return call$a(replacer, searchValue, O, replaceValue);
	      } else if (IS_PURE$5 && IS_REG_EXP) {
	        return replace$5(toString$8(O), searchValue, replaceValue);
	      }
	    }
	    string = toString$8(O);
	    searchString = toString$8(searchValue);
	    functionalReplace = isCallable$3(replaceValue);
	    if (!functionalReplace) replaceValue = toString$8(replaceValue);
	    searchLength = searchString.length;
	    advanceBy = max$5(1, searchLength);
	    position = stringIndexOf(string, searchString, 0);
	    while (position !== -1) {
	      replacement = functionalReplace ? toString$8(replaceValue(searchString, position, string)) : getSubstitution(searchString, string, position, [], undefined, replaceValue);
	      result += stringSlice$6(string, endOfLastMatch, position) + replacement;
	      endOfLastMatch = position + searchLength;
	      position = stringIndexOf(string, searchString, position + advanceBy);
	    }
	    if (endOfLastMatch < string.length) {
	      result += stringSlice$6(string, endOfLastMatch);
	    }
	    return result;
	  }
	});

	var es_string_search = {};

	'use strict';
	var call$9 = functionCall;
	var fixRegExpWellKnownSymbolLogic$1 = fixRegexpWellKnownSymbolLogic;
	var anObject$5 = anObject$D;
	var isNullOrUndefined$3 = isNullOrUndefined$e;
	var requireObjectCoercible$4 = requireObjectCoercible$j;
	var sameValue = sameValue$1;
	var toString$7 = toString$x;
	var getMethod$1 = getMethod$9;
	var regExpExec = regexpExecAbstract;

	// @@search logic
	fixRegExpWellKnownSymbolLogic$1('search', function (SEARCH, nativeSearch, maybeCallNative) {
	  return [
	  // `String.prototype.search` method
	  // https://tc39.es/ecma262/#sec-string.prototype.search
	  function search(regexp) {
	    var O = requireObjectCoercible$4(this);
	    var searcher = isNullOrUndefined$3(regexp) ? undefined : getMethod$1(regexp, SEARCH);
	    return searcher ? call$9(searcher, regexp, O) : new RegExp(regexp)[SEARCH](toString$7(O));
	  },
	  // `RegExp.prototype[@@search]` method
	  // https://tc39.es/ecma262/#sec-regexp.prototype-@@search
	  function (string) {
	    var rx = anObject$5(this);
	    var S = toString$7(string);
	    var res = maybeCallNative(nativeSearch, rx, S);
	    if (res.done) return res.value;
	    var previousLastIndex = rx.lastIndex;
	    if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
	    var result = regExpExec(rx, S);
	    if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
	    return result === null ? -1 : result.index;
	  }];
	});

	var es_string_split = {};

	'use strict';
	var apply$3 = functionApply$1;
	var call$8 = functionCall;
	var uncurryThis$m = functionUncurryThis;
	var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
	var anObject$4 = anObject$D;
	var isNullOrUndefined$2 = isNullOrUndefined$e;
	var isRegExp = isRegexp;
	var requireObjectCoercible$3 = requireObjectCoercible$j;
	var speciesConstructor$1 = speciesConstructor$6;
	var advanceStringIndex = advanceStringIndex$4;
	var toLength$3 = toLength$d;
	var toString$6 = toString$x;
	var getMethod = getMethod$9;
	var arraySlice$4 = arraySliceSimple;
	var callRegExpExec = regexpExecAbstract;
	var regexpExec = regexpExec$3;
	var stickyHelpers = regexpStickyHelpers;
	var fails$h = fails$1m;
	var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
	var MAX_UINT32 = 0xFFFFFFFF;
	var min$6 = Math.min;
	var $push = [].push;
	var exec$4 = uncurryThis$m(/./.exec);
	var push$4 = uncurryThis$m($push);
	var stringSlice$5 = uncurryThis$m(''.slice);

	// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
	// Weex JS has frozen built-in prototypes, so use try / catch wrapper
	var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails$h(function () {
	  // eslint-disable-next-line regexp/no-empty-group -- required for testing
	  var re = /(?:)/;
	  var originalExec = re.exec;
	  re.exec = function () {
	    return originalExec.apply(this, arguments);
	  };
	  var result = 'ab'.split(re);
	  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
	});

	// @@split logic
	fixRegExpWellKnownSymbolLogic('split', function (SPLIT, nativeSplit, maybeCallNative) {
	  var internalSplit;
	  if ('abbc'.split(/(b)*/)[1] == 'c' ||
	  // eslint-disable-next-line regexp/no-empty-group -- required for testing
	  'test'.split(/(?:)/, -1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 ||
	  // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
	  '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
	    // based on es5-shim implementation, need to rework it
	    internalSplit = function internalSplit(separator, limit) {
	      var string = toString$6(requireObjectCoercible$3(this));
	      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	      if (lim === 0) return [];
	      if (separator === undefined) return [string];
	      // If `separator` is not a regex, use native split
	      if (!isRegExp(separator)) {
	        return call$8(nativeSplit, string, separator, lim);
	      }
	      var output = [];
	      var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
	      var lastLastIndex = 0;
	      // Make `global` and avoid `lastIndex` issues by working with a copy
	      var separatorCopy = new RegExp(separator.source, flags + 'g');
	      var match, lastIndex, lastLength;
	      while (match = call$8(regexpExec, separatorCopy, string)) {
	        lastIndex = separatorCopy.lastIndex;
	        if (lastIndex > lastLastIndex) {
	          push$4(output, stringSlice$5(string, lastLastIndex, match.index));
	          if (match.length > 1 && match.index < string.length) apply$3($push, output, arraySlice$4(match, 1));
	          lastLength = match[0].length;
	          lastLastIndex = lastIndex;
	          if (output.length >= lim) break;
	        }
	        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
	      }

	      if (lastLastIndex === string.length) {
	        if (lastLength || !exec$4(separatorCopy, '')) push$4(output, '');
	      } else push$4(output, stringSlice$5(string, lastLastIndex));
	      return output.length > lim ? arraySlice$4(output, 0, lim) : output;
	    };
	    // Chakra, V8
	  } else if ('0'.split(undefined, 0).length) {
	    internalSplit = function internalSplit(separator, limit) {
	      return separator === undefined && limit === 0 ? [] : call$8(nativeSplit, this, separator, limit);
	    };
	  } else internalSplit = nativeSplit;
	  return [
	  // `String.prototype.split` method
	  // https://tc39.es/ecma262/#sec-string.prototype.split
	  function split(separator, limit) {
	    var O = requireObjectCoercible$3(this);
	    var splitter = isNullOrUndefined$2(separator) ? undefined : getMethod(separator, SPLIT);
	    return splitter ? call$8(splitter, separator, O, limit) : call$8(internalSplit, toString$6(O), separator, limit);
	  },
	  // `RegExp.prototype[@@split]` method
	  // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
	  //
	  // NOTE: This cannot be properly polyfilled in engines that don't support
	  // the 'y' flag.
	  function (string, limit) {
	    var rx = anObject$4(this);
	    var S = toString$6(string);
	    var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);
	    if (res.done) return res.value;
	    var C = speciesConstructor$1(rx, RegExp);
	    var unicodeMatching = rx.unicode;
	    var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (UNSUPPORTED_Y ? 'g' : 'y');

	    // ^(? + rx + ) is needed, in combination with some S slicing, to
	    // simulate the 'y' flag.
	    var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
	    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	    if (lim === 0) return [];
	    if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
	    var p = 0;
	    var q = 0;
	    var A = [];
	    while (q < S.length) {
	      splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
	      var z = callRegExpExec(splitter, UNSUPPORTED_Y ? stringSlice$5(S, q) : S);
	      var e;
	      if (z === null || (e = min$6(toLength$3(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p) {
	        q = advanceStringIndex(S, q, unicodeMatching);
	      } else {
	        push$4(A, stringSlice$5(S, p, q));
	        if (A.length === lim) return A;
	        for (var i = 1; i <= z.length - 1; i++) {
	          push$4(A, z[i]);
	          if (A.length === lim) return A;
	        }
	        q = p = e;
	      }
	    }
	    push$4(A, stringSlice$5(S, p));
	    return A;
	  }];
	}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y);

	var es_string_startsWith = {};

	'use strict';
	var $$z = _export;
	var uncurryThis$l = functionUncurryThisClause;
	var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	var toLength$2 = toLength$d;
	var toString$5 = toString$x;
	var notARegExp = notARegexp;
	var requireObjectCoercible$2 = requireObjectCoercible$j;
	var correctIsRegExpLogic = correctIsRegexpLogic;
	var IS_PURE$4 = isPure;

	// eslint-disable-next-line es/no-string-prototype-startswith -- safe
	var nativeStartsWith = uncurryThis$l(''.startsWith);
	var stringSlice$4 = uncurryThis$l(''.slice);
	var min$5 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('startsWith');
	// https://github.com/zloirock/core-js/pull/702
	var MDN_POLYFILL_BUG = !IS_PURE$4 && !CORRECT_IS_REGEXP_LOGIC && !!function () {
	  var descriptor = getOwnPropertyDescriptor$1(String.prototype, 'startsWith');
	  return descriptor && !descriptor.writable;
	}();

	// `String.prototype.startsWith` method
	// https://tc39.es/ecma262/#sec-string.prototype.startswith
	$$z({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
	}, {
	  startsWith: function startsWith(searchString /* , position = 0 */) {
	    var that = toString$5(requireObjectCoercible$2(this));
	    notARegExp(searchString);
	    var index = toLength$2(min$5(arguments.length > 1 ? arguments[1] : undefined, that.length));
	    var search = toString$5(searchString);
	    return nativeStartsWith ? nativeStartsWith(that, search, index) : stringSlice$4(that, index, index + search.length) === search;
	  }
	});

	var es_string_substr = {};

	'use strict';
	var $$y = _export;
	var uncurryThis$k = functionUncurryThis;
	var requireObjectCoercible$1 = requireObjectCoercible$j;
	var toIntegerOrInfinity$3 = toIntegerOrInfinity$l;
	var toString$4 = toString$x;
	var stringSlice$3 = uncurryThis$k(''.slice);
	var max$4 = Math.max;
	var min$4 = Math.min;

	// eslint-disable-next-line unicorn/prefer-string-slice -- required for testing
	var FORCED$2 = !''.substr || 'ab'.substr(-1) !== 'b';

	// `String.prototype.substr` method
	// https://tc39.es/ecma262/#sec-string.prototype.substr
	$$y({
	  target: 'String',
	  proto: true,
	  forced: FORCED$2
	}, {
	  substr: function substr(start, length) {
	    var that = toString$4(requireObjectCoercible$1(this));
	    var size = that.length;
	    var intStart = toIntegerOrInfinity$3(start);
	    var intLength, intEnd;
	    if (intStart === Infinity) intStart = 0;
	    if (intStart < 0) intStart = max$4(size + intStart, 0);
	    intLength = length === undefined ? size : toIntegerOrInfinity$3(length);
	    if (intLength <= 0 || intLength === Infinity) return '';
	    intEnd = min$4(intStart + intLength, size);
	    return intStart >= intEnd ? '' : stringSlice$3(that, intStart, intEnd);
	  }
	});

	var es_string_trim = {};

	var PROPER_FUNCTION_NAME = functionName.PROPER;
	var fails$g = fails$1m;
	var whitespaces$1 = whitespaces$5;
	var non = "\u200B\x85\u180E";

	// check that a method works with the correct list
	// of whitespaces and has a correct name
	var stringTrimForced = function stringTrimForced(METHOD_NAME) {
	  return fails$g(function () {
	    return !!whitespaces$1[METHOD_NAME]() || non[METHOD_NAME]() !== non || PROPER_FUNCTION_NAME && whitespaces$1[METHOD_NAME].name !== METHOD_NAME;
	  });
	};
	var stringTrimForced$1 = /*@__PURE__*/getDefaultExportFromCjs(stringTrimForced);

	'use strict';
	var $$x = _export;
	var $trim = stringTrim.trim;
	var forcedStringTrimMethod$2 = stringTrimForced;

	// `String.prototype.trim` method
	// https://tc39.es/ecma262/#sec-string.prototype.trim
	$$x({
	  target: 'String',
	  proto: true,
	  forced: forcedStringTrimMethod$2('trim')
	}, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});

	var es_string_trimEnd = {};

	var es_string_trimRight = {};

	'use strict';
	var $trimEnd = stringTrim.end;
	var forcedStringTrimMethod$1 = stringTrimForced;

	// `String.prototype.{ trimEnd, trimRight }` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimend
	// https://tc39.es/ecma262/#String.prototype.trimright
	var stringTrimEnd = forcedStringTrimMethod$1('trimEnd') ? function trimEnd() {
	  return $trimEnd(this);
	  // eslint-disable-next-line es/no-string-prototype-trimstart-trimend -- safe
	} : ''.trimEnd;
	var stringTrimEnd$1 = /*@__PURE__*/getDefaultExportFromCjs(stringTrimEnd);

	var $$w = _export;
	var trimEnd$1 = stringTrimEnd;

	// `String.prototype.trimRight` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimend
	// eslint-disable-next-line es/no-string-prototype-trimleft-trimright -- safe
	$$w({
	  target: 'String',
	  proto: true,
	  name: 'trimEnd',
	  forced: ''.trimRight !== trimEnd$1
	}, {
	  trimRight: trimEnd$1
	});

	// TODO: Remove this line from `core-js@4`

	var $$v = _export;
	var trimEnd = stringTrimEnd;

	// `String.prototype.trimEnd` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimend
	// eslint-disable-next-line es/no-string-prototype-trimstart-trimend -- safe
	$$v({
	  target: 'String',
	  proto: true,
	  name: 'trimEnd',
	  forced: ''.trimEnd !== trimEnd
	}, {
	  trimEnd: trimEnd
	});

	var es_string_trimStart = {};

	var es_string_trimLeft = {};

	'use strict';
	var $trimStart = stringTrim.start;
	var forcedStringTrimMethod = stringTrimForced;

	// `String.prototype.{ trimStart, trimLeft }` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimstart
	// https://tc39.es/ecma262/#String.prototype.trimleft
	var stringTrimStart = forcedStringTrimMethod('trimStart') ? function trimStart() {
	  return $trimStart(this);
	  // eslint-disable-next-line es/no-string-prototype-trimstart-trimend -- safe
	} : ''.trimStart;
	var stringTrimStart$1 = /*@__PURE__*/getDefaultExportFromCjs(stringTrimStart);

	var $$u = _export;
	var trimStart$1 = stringTrimStart;

	// `String.prototype.trimLeft` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimleft
	// eslint-disable-next-line es/no-string-prototype-trimleft-trimright -- safe
	$$u({
	  target: 'String',
	  proto: true,
	  name: 'trimStart',
	  forced: ''.trimLeft !== trimStart$1
	}, {
	  trimLeft: trimStart$1
	});

	// TODO: Remove this line from `core-js@4`

	var $$t = _export;
	var trimStart = stringTrimStart;

	// `String.prototype.trimStart` method
	// https://tc39.es/ecma262/#sec-string.prototype.trimstart
	// eslint-disable-next-line es/no-string-prototype-trimstart-trimend -- safe
	$$t({
	  target: 'String',
	  proto: true,
	  name: 'trimStart',
	  forced: ''.trimStart !== trimStart
	}, {
	  trimStart: trimStart
	});

	var es_string_anchor = {};

	var uncurryThis$j = functionUncurryThis;
	var requireObjectCoercible = requireObjectCoercible$j;
	var toString$3 = toString$x;
	var quot = /"/g;
	var replace$4 = uncurryThis$j(''.replace);

	// `CreateHTML` abstract operation
	// https://tc39.es/ecma262/#sec-createhtml
	var createHtml = function createHtml(string, tag, attribute, value) {
	  var S = toString$3(requireObjectCoercible(string));
	  var p1 = '<' + tag;
	  if (attribute !== '') p1 += ' ' + attribute + '="' + replace$4(toString$3(value), quot, '&quot;') + '"';
	  return p1 + '>' + S + '</' + tag + '>';
	};
	var createHtml$1 = /*@__PURE__*/getDefaultExportFromCjs(createHtml);

	var fails$f = fails$1m;

	// check the existence of a method, lowercase
	// of a tag and escaping quotes in arguments
	var stringHtmlForced = function stringHtmlForced(METHOD_NAME) {
	  return fails$f(function () {
	    var test = ''[METHOD_NAME]('"');
	    return test !== test.toLowerCase() || test.split('"').length > 3;
	  });
	};
	var stringHtmlForced$1 = /*@__PURE__*/getDefaultExportFromCjs(stringHtmlForced);

	'use strict';
	var $$s = _export;
	var createHTML$c = createHtml;
	var forcedStringHTMLMethod$c = stringHtmlForced;

	// `String.prototype.anchor` method
	// https://tc39.es/ecma262/#sec-string.prototype.anchor
	$$s({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$c('anchor')
	}, {
	  anchor: function anchor(name) {
	    return createHTML$c(this, 'a', 'name', name);
	  }
	});

	var es_string_big = {};

	'use strict';
	var $$r = _export;
	var createHTML$b = createHtml;
	var forcedStringHTMLMethod$b = stringHtmlForced;

	// `String.prototype.big` method
	// https://tc39.es/ecma262/#sec-string.prototype.big
	$$r({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$b('big')
	}, {
	  big: function big() {
	    return createHTML$b(this, 'big', '', '');
	  }
	});

	var es_string_blink = {};

	'use strict';
	var $$q = _export;
	var createHTML$a = createHtml;
	var forcedStringHTMLMethod$a = stringHtmlForced;

	// `String.prototype.blink` method
	// https://tc39.es/ecma262/#sec-string.prototype.blink
	$$q({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$a('blink')
	}, {
	  blink: function blink() {
	    return createHTML$a(this, 'blink', '', '');
	  }
	});

	var es_string_bold = {};

	'use strict';
	var $$p = _export;
	var createHTML$9 = createHtml;
	var forcedStringHTMLMethod$9 = stringHtmlForced;

	// `String.prototype.bold` method
	// https://tc39.es/ecma262/#sec-string.prototype.bold
	$$p({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$9('bold')
	}, {
	  bold: function bold() {
	    return createHTML$9(this, 'b', '', '');
	  }
	});

	var es_string_fixed = {};

	'use strict';
	var $$o = _export;
	var createHTML$8 = createHtml;
	var forcedStringHTMLMethod$8 = stringHtmlForced;

	// `String.prototype.fixed` method
	// https://tc39.es/ecma262/#sec-string.prototype.fixed
	$$o({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$8('fixed')
	}, {
	  fixed: function fixed() {
	    return createHTML$8(this, 'tt', '', '');
	  }
	});

	var es_string_fontcolor = {};

	'use strict';
	var $$n = _export;
	var createHTML$7 = createHtml;
	var forcedStringHTMLMethod$7 = stringHtmlForced;

	// `String.prototype.fontcolor` method
	// https://tc39.es/ecma262/#sec-string.prototype.fontcolor
	$$n({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$7('fontcolor')
	}, {
	  fontcolor: function fontcolor(color) {
	    return createHTML$7(this, 'font', 'color', color);
	  }
	});

	var es_string_fontsize = {};

	'use strict';
	var $$m = _export;
	var createHTML$6 = createHtml;
	var forcedStringHTMLMethod$6 = stringHtmlForced;

	// `String.prototype.fontsize` method
	// https://tc39.es/ecma262/#sec-string.prototype.fontsize
	$$m({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$6('fontsize')
	}, {
	  fontsize: function fontsize(size) {
	    return createHTML$6(this, 'font', 'size', size);
	  }
	});

	var es_string_italics = {};

	'use strict';
	var $$l = _export;
	var createHTML$5 = createHtml;
	var forcedStringHTMLMethod$5 = stringHtmlForced;

	// `String.prototype.italics` method
	// https://tc39.es/ecma262/#sec-string.prototype.italics
	$$l({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$5('italics')
	}, {
	  italics: function italics() {
	    return createHTML$5(this, 'i', '', '');
	  }
	});

	var es_string_link = {};

	'use strict';
	var $$k = _export;
	var createHTML$4 = createHtml;
	var forcedStringHTMLMethod$4 = stringHtmlForced;

	// `String.prototype.link` method
	// https://tc39.es/ecma262/#sec-string.prototype.link
	$$k({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$4('link')
	}, {
	  link: function link(url) {
	    return createHTML$4(this, 'a', 'href', url);
	  }
	});

	var es_string_small = {};

	'use strict';
	var $$j = _export;
	var createHTML$3 = createHtml;
	var forcedStringHTMLMethod$3 = stringHtmlForced;

	// `String.prototype.small` method
	// https://tc39.es/ecma262/#sec-string.prototype.small
	$$j({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$3('small')
	}, {
	  small: function small() {
	    return createHTML$3(this, 'small', '', '');
	  }
	});

	var es_string_strike = {};

	'use strict';
	var $$i = _export;
	var createHTML$2 = createHtml;
	var forcedStringHTMLMethod$2 = stringHtmlForced;

	// `String.prototype.strike` method
	// https://tc39.es/ecma262/#sec-string.prototype.strike
	$$i({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$2('strike')
	}, {
	  strike: function strike() {
	    return createHTML$2(this, 'strike', '', '');
	  }
	});

	var es_string_sub = {};

	'use strict';
	var $$h = _export;
	var createHTML$1 = createHtml;
	var forcedStringHTMLMethod$1 = stringHtmlForced;

	// `String.prototype.sub` method
	// https://tc39.es/ecma262/#sec-string.prototype.sub
	$$h({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod$1('sub')
	}, {
	  sub: function sub() {
	    return createHTML$1(this, 'sub', '', '');
	  }
	});

	var es_string_sup = {};

	'use strict';
	var $$g = _export;
	var createHTML = createHtml;
	var forcedStringHTMLMethod = stringHtmlForced;

	// `String.prototype.sup` method
	// https://tc39.es/ecma262/#sec-string.prototype.sup
	$$g({
	  target: 'String',
	  proto: true,
	  forced: forcedStringHTMLMethod('sup')
	}, {
	  sup: function sup() {
	    return createHTML(this, 'sup', '', '');
	  }
	});

	var es_typedArray_float32Array = {};

	var typedArrayConstructor$2 = {exports: {}};

	/* eslint-disable no-new -- required for testing */
	var global$o = global$Z;
	var fails$e = fails$1m;
	var checkCorrectnessOfIteration = checkCorrectnessOfIteration$4;
	var NATIVE_ARRAY_BUFFER_VIEWS$1 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	var ArrayBuffer$2 = global$o.ArrayBuffer;
	var Int8Array$3 = global$o.Int8Array;
	var typedArrayConstructorsRequireWrappers = !NATIVE_ARRAY_BUFFER_VIEWS$1 || !fails$e(function () {
	  Int8Array$3(1);
	}) || !fails$e(function () {
	  new Int8Array$3(-1);
	}) || !checkCorrectnessOfIteration(function (iterable) {
	  new Int8Array$3();
	  new Int8Array$3(null);
	  new Int8Array$3(1.5);
	  new Int8Array$3(iterable);
	}, true) || fails$e(function () {
	  // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
	  return new Int8Array$3(new ArrayBuffer$2(2), 1, undefined).length !== 1;
	});
	var typedArrayConstructorsRequireWrappers$1 = /*@__PURE__*/getDefaultExportFromCjs(typedArrayConstructorsRequireWrappers);

	var toIntegerOrInfinity$2 = toIntegerOrInfinity$l;
	var $RangeError$2 = RangeError;
	var toPositiveInteger$1 = function toPositiveInteger(it) {
	  var result = toIntegerOrInfinity$2(it);
	  if (result < 0) throw $RangeError$2("The argument can't be less than 0");
	  return result;
	};
	var toPositiveInteger$2 = /*@__PURE__*/getDefaultExportFromCjs(toPositiveInteger$1);

	var toPositiveInteger = toPositiveInteger$1;
	var $RangeError$1 = RangeError;
	var toOffset$2 = function toOffset(it, BYTES) {
	  var offset = toPositiveInteger(it);
	  if (offset % BYTES) throw $RangeError$1('Wrong offset');
	  return offset;
	};
	var toOffset$3 = /*@__PURE__*/getDefaultExportFromCjs(toOffset$2);

	var classof$4 = classof$m;
	var isBigIntArray$2 = function isBigIntArray(it) {
	  var klass = classof$4(it);
	  return klass == 'BigInt64Array' || klass == 'BigUint64Array';
	};
	var isBigIntArray$3 = /*@__PURE__*/getDefaultExportFromCjs(isBigIntArray$2);

	var toPrimitive = toPrimitive$4;
	var $TypeError$1 = TypeError;

	// `ToBigInt` abstract operation
	// https://tc39.es/ecma262/#sec-tobigint
	var toBigInt$3 = function toBigInt(argument) {
	  var prim = toPrimitive(argument, 'number');
	  if (typeof prim == 'number') throw $TypeError$1("Can't convert number to bigint");
	  // eslint-disable-next-line es/no-bigint -- safe
	  return BigInt(prim);
	};
	var toBigInt$4 = /*@__PURE__*/getDefaultExportFromCjs(toBigInt$3);

	var bind$2 = functionBindContext;
	var call$7 = functionCall;
	var aConstructor = aConstructor$3;
	var toObject = toObject$t;
	var lengthOfArrayLike$3 = lengthOfArrayLike$t;
	var getIterator$1 = getIterator$4;
	var getIteratorMethod$1 = getIteratorMethod$5;
	var isArrayIteratorMethod = isArrayIteratorMethod$3;
	var isBigIntArray$1 = isBigIntArray$2;
	var aTypedArrayConstructor$3 = arrayBufferViewCore.aTypedArrayConstructor;
	var toBigInt$2 = toBigInt$3;
	var typedArrayFrom$2 = function from(source /* , mapfn, thisArg */) {
	  var C = aConstructor(this);
	  var O = toObject(source);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod$1(O);
	  var i, length, result, thisIsBigIntArray, value, step, iterator, next;
	  if (iteratorMethod && !isArrayIteratorMethod(iteratorMethod)) {
	    iterator = getIterator$1(O, iteratorMethod);
	    next = iterator.next;
	    O = [];
	    while (!(step = call$7(next, iterator)).done) {
	      O.push(step.value);
	    }
	  }
	  if (mapping && argumentsLength > 2) {
	    mapfn = bind$2(mapfn, arguments[2]);
	  }
	  length = lengthOfArrayLike$3(O);
	  result = new (aTypedArrayConstructor$3(C))(length);
	  thisIsBigIntArray = isBigIntArray$1(result);
	  for (i = 0; length > i; i++) {
	    value = mapping ? mapfn(O[i], i) : O[i];
	    // FF30- typed arrays doesn't properly convert objects to typed array values
	    result[i] = thisIsBigIntArray ? toBigInt$2(value) : +value;
	  }
	  return result;
	};
	var typedArrayFrom$3 = /*@__PURE__*/getDefaultExportFromCjs(typedArrayFrom$2);

	var typedArrayConstructor = typedArrayConstructor$2.exports;
	'use strict';
	var $$f = _export;
	var global$n = global$Z;
	var call$6 = functionCall;
	var DESCRIPTORS$7 = descriptors;
	var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS$2 = typedArrayConstructorsRequireWrappers;
	var ArrayBufferViewCore$u = arrayBufferViewCore;
	var ArrayBufferModule = arrayBuffer;
	var anInstance$5 = anInstance$a;
	var createPropertyDescriptor$3 = createPropertyDescriptor$c;
	var createNonEnumerableProperty$3 = createNonEnumerableProperty$f;
	var isIntegralNumber = isIntegralNumber$3;
	var toLength$1 = toLength$d;
	var toIndex = toIndex$2;
	var toOffset$1 = toOffset$2;
	var toPropertyKey = toPropertyKey$8;
	var hasOwn$7 = hasOwnProperty_1;
	var classof$3 = classof$m;
	var isObject$4 = isObject$z;
	var isSymbol$1 = isSymbol$7;
	var create$2 = objectCreate;
	var isPrototypeOf = objectIsPrototypeOf;
	var setPrototypeOf = objectSetPrototypeOf$1;
	var getOwnPropertyNames = objectGetOwnPropertyNames.f;
	var typedArrayFrom$1 = typedArrayFrom$2;
	var forEach$2 = arrayIteration.forEach;
	var setSpecies = setSpecies$6;
	var defineBuiltInAccessor$5 = defineBuiltInAccessor$h;
	var definePropertyModule = objectDefineProperty;
	var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
	var InternalStateModule$4 = internalState;
	var inheritIfRequired$1 = inheritIfRequired$6;
	var getInternalState$1 = InternalStateModule$4.get;
	var setInternalState$4 = InternalStateModule$4.set;
	var enforceInternalState$1 = InternalStateModule$4.enforce;
	var nativeDefineProperty = definePropertyModule.f;
	var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
	var round$4 = Math.round;
	var RangeError$3 = global$n.RangeError;
	var ArrayBuffer$1 = ArrayBufferModule.ArrayBuffer;
	var ArrayBufferPrototype = ArrayBuffer$1.prototype;
	var DataView$1 = ArrayBufferModule.DataView;
	var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore$u.NATIVE_ARRAY_BUFFER_VIEWS;
	var TYPED_ARRAY_TAG = ArrayBufferViewCore$u.TYPED_ARRAY_TAG;
	var TypedArray = ArrayBufferViewCore$u.TypedArray;
	var TypedArrayPrototype$1 = ArrayBufferViewCore$u.TypedArrayPrototype;
	var aTypedArrayConstructor$2 = ArrayBufferViewCore$u.aTypedArrayConstructor;
	var isTypedArray$1 = ArrayBufferViewCore$u.isTypedArray;
	var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
	var WRONG_LENGTH = 'Wrong length';
	var fromList = function fromList(C, list) {
	  aTypedArrayConstructor$2(C);
	  var index = 0;
	  var length = list.length;
	  var result = new C(length);
	  while (length > index) result[index] = list[index++];
	  return result;
	};
	var addGetter = function addGetter(it, key) {
	  defineBuiltInAccessor$5(it, key, {
	    configurable: true,
	    get: function get() {
	      return getInternalState$1(this)[key];
	    }
	  });
	};
	var isArrayBuffer = function isArrayBuffer(it) {
	  var klass;
	  return isPrototypeOf(ArrayBufferPrototype, it) || (klass = classof$3(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
	};
	var isTypedArrayIndex = function isTypedArrayIndex(target, key) {
	  return isTypedArray$1(target) && !isSymbol$1(key) && key in target && isIntegralNumber(+key) && key >= 0;
	};
	var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
	  key = toPropertyKey(key);
	  return isTypedArrayIndex(target, key) ? createPropertyDescriptor$3(2, target[key]) : nativeGetOwnPropertyDescriptor(target, key);
	};
	var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
	  key = toPropertyKey(key);
	  if (isTypedArrayIndex(target, key) && isObject$4(descriptor) && hasOwn$7(descriptor, 'value') && !hasOwn$7(descriptor, 'get') && !hasOwn$7(descriptor, 'set')
	  // TODO: add validation descriptor w/o calling accessors
	  && !descriptor.configurable && (!hasOwn$7(descriptor, 'writable') || descriptor.writable) && (!hasOwn$7(descriptor, 'enumerable') || descriptor.enumerable)) {
	    target[key] = descriptor.value;
	    return target;
	  }
	  return nativeDefineProperty(target, key, descriptor);
	};
	if (DESCRIPTORS$7) {
	  if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	    getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
	    definePropertyModule.f = wrappedDefineProperty;
	    addGetter(TypedArrayPrototype$1, 'buffer');
	    addGetter(TypedArrayPrototype$1, 'byteOffset');
	    addGetter(TypedArrayPrototype$1, 'byteLength');
	    addGetter(TypedArrayPrototype$1, 'length');
	  }
	  $$f({
	    target: 'Object',
	    stat: true,
	    forced: !NATIVE_ARRAY_BUFFER_VIEWS
	  }, {
	    getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
	    defineProperty: wrappedDefineProperty
	  });
	  typedArrayConstructor$2.exports = function (TYPE, wrapper, CLAMPED) {
	    var BYTES = TYPE.match(/\d+/)[0] / 8;
	    var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
	    var GETTER = 'get' + TYPE;
	    var SETTER = 'set' + TYPE;
	    var NativeTypedArrayConstructor = global$n[CONSTRUCTOR_NAME];
	    var TypedArrayConstructor = NativeTypedArrayConstructor;
	    var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
	    var exported = {};
	    var getter = function getter(that, index) {
	      var data = getInternalState$1(that);
	      return data.view[GETTER](index * BYTES + data.byteOffset, true);
	    };
	    var setter = function setter(that, index, value) {
	      var data = getInternalState$1(that);
	      if (CLAMPED) value = (value = round$4(value)) < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
	      data.view[SETTER](index * BYTES + data.byteOffset, value, true);
	    };
	    var addElement = function addElement(that, index) {
	      nativeDefineProperty(that, index, {
	        get: function get() {
	          return getter(this, index);
	        },
	        set: function set(value) {
	          return setter(this, index, value);
	        },
	        enumerable: true
	      });
	    };
	    if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	      TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
	        anInstance$5(that, TypedArrayConstructorPrototype);
	        var index = 0;
	        var byteOffset = 0;
	        var buffer, byteLength, length;
	        if (!isObject$4(data)) {
	          length = toIndex(data);
	          byteLength = length * BYTES;
	          buffer = new ArrayBuffer$1(byteLength);
	        } else if (isArrayBuffer(data)) {
	          buffer = data;
	          byteOffset = toOffset$1(offset, BYTES);
	          var $len = data.byteLength;
	          if ($length === undefined) {
	            if ($len % BYTES) throw RangeError$3(WRONG_LENGTH);
	            byteLength = $len - byteOffset;
	            if (byteLength < 0) throw RangeError$3(WRONG_LENGTH);
	          } else {
	            byteLength = toLength$1($length) * BYTES;
	            if (byteLength + byteOffset > $len) throw RangeError$3(WRONG_LENGTH);
	          }
	          length = byteLength / BYTES;
	        } else if (isTypedArray$1(data)) {
	          return fromList(TypedArrayConstructor, data);
	        } else {
	          return call$6(typedArrayFrom$1, TypedArrayConstructor, data);
	        }
	        setInternalState$4(that, {
	          buffer: buffer,
	          byteOffset: byteOffset,
	          byteLength: byteLength,
	          length: length,
	          view: new DataView$1(buffer)
	        });
	        while (index < length) addElement(that, index++);
	      });
	      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
	      TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create$2(TypedArrayPrototype$1);
	    } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS$2) {
	      TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
	        anInstance$5(dummy, TypedArrayConstructorPrototype);
	        return inheritIfRequired$1(function () {
	          if (!isObject$4(data)) return new NativeTypedArrayConstructor(toIndex(data));
	          if (isArrayBuffer(data)) return $length !== undefined ? new NativeTypedArrayConstructor(data, toOffset$1(typedArrayOffset, BYTES), $length) : typedArrayOffset !== undefined ? new NativeTypedArrayConstructor(data, toOffset$1(typedArrayOffset, BYTES)) : new NativeTypedArrayConstructor(data);
	          if (isTypedArray$1(data)) return fromList(TypedArrayConstructor, data);
	          return call$6(typedArrayFrom$1, TypedArrayConstructor, data);
	        }(), dummy, TypedArrayConstructor);
	      });
	      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
	      forEach$2(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
	        if (!(key in TypedArrayConstructor)) {
	          createNonEnumerableProperty$3(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
	        }
	      });
	      TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
	    }
	    if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
	      createNonEnumerableProperty$3(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
	    }
	    enforceInternalState$1(TypedArrayConstructorPrototype).TypedArrayConstructor = TypedArrayConstructor;
	    if (TYPED_ARRAY_TAG) {
	      createNonEnumerableProperty$3(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
	    }
	    var FORCED = TypedArrayConstructor != NativeTypedArrayConstructor;
	    exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;
	    $$f({
	      global: true,
	      constructor: true,
	      forced: FORCED,
	      sham: !NATIVE_ARRAY_BUFFER_VIEWS
	    }, exported);
	    if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
	      createNonEnumerableProperty$3(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
	    }
	    if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
	      createNonEnumerableProperty$3(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
	    }
	    setSpecies(CONSTRUCTOR_NAME);
	  };
	} else typedArrayConstructor$2.exports = function () {/* empty */};
	var typedArrayConstructorExports = typedArrayConstructor$2.exports;
	var typedArrayConstructor$1 = /*@__PURE__*/getDefaultExportFromCjs(typedArrayConstructorExports);

	var createTypedArrayConstructor$8 = typedArrayConstructorExports;

	// `Float32Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$8('Float32', function (init) {
	  return function Float32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_float64Array = {};

	var createTypedArrayConstructor$7 = typedArrayConstructorExports;

	// `Float64Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$7('Float64', function (init) {
	  return function Float64Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_int8Array = {};

	var createTypedArrayConstructor$6 = typedArrayConstructorExports;

	// `Int8Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$6('Int8', function (init) {
	  return function Int8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_int16Array = {};

	var createTypedArrayConstructor$5 = typedArrayConstructorExports;

	// `Int16Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$5('Int16', function (init) {
	  return function Int16Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_int32Array = {};

	var createTypedArrayConstructor$4 = typedArrayConstructorExports;

	// `Int32Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$4('Int32', function (init) {
	  return function Int32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_uint8Array = {};

	var createTypedArrayConstructor$3 = typedArrayConstructorExports;

	// `Uint8Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$3('Uint8', function (init) {
	  return function Uint8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_uint8ClampedArray = {};

	var createTypedArrayConstructor$2 = typedArrayConstructorExports;

	// `Uint8ClampedArray` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$2('Uint8', function (init) {
	  return function Uint8ClampedArray(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	}, true);

	var es_typedArray_uint16Array = {};

	var createTypedArrayConstructor$1 = typedArrayConstructorExports;

	// `Uint16Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor$1('Uint16', function (init) {
	  return function Uint16Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_uint32Array = {};

	var createTypedArrayConstructor = typedArrayConstructorExports;

	// `Uint32Array` constructor
	// https://tc39.es/ecma262/#sec-typedarray-objects
	createTypedArrayConstructor('Uint32', function (init) {
	  return function Uint32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	var es_typedArray_at = {};

	'use strict';
	var ArrayBufferViewCore$t = arrayBufferViewCore;
	var lengthOfArrayLike$2 = lengthOfArrayLike$t;
	var toIntegerOrInfinity$1 = toIntegerOrInfinity$l;
	var aTypedArray$r = ArrayBufferViewCore$t.aTypedArray;
	var exportTypedArrayMethod$s = ArrayBufferViewCore$t.exportTypedArrayMethod;

	// `%TypedArray%.prototype.at` method
	// https://github.com/tc39/proposal-relative-indexing-method
	exportTypedArrayMethod$s('at', function at(index) {
	  var O = aTypedArray$r(this);
	  var len = lengthOfArrayLike$2(O);
	  var relativeIndex = toIntegerOrInfinity$1(index);
	  var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
	  return k < 0 || k >= len ? undefined : O[k];
	});

	var es_typedArray_copyWithin = {};

	'use strict';
	var uncurryThis$i = functionUncurryThis;
	var ArrayBufferViewCore$s = arrayBufferViewCore;
	var $ArrayCopyWithin = arrayCopyWithin;
	var u$ArrayCopyWithin = uncurryThis$i($ArrayCopyWithin);
	var aTypedArray$q = ArrayBufferViewCore$s.aTypedArray;
	var exportTypedArrayMethod$r = ArrayBufferViewCore$s.exportTypedArrayMethod;

	// `%TypedArray%.prototype.copyWithin` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.copywithin
	exportTypedArrayMethod$r('copyWithin', function copyWithin(target, start /* , end */) {
	  return u$ArrayCopyWithin(aTypedArray$q(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
	});

	var es_typedArray_every = {};

	'use strict';
	var ArrayBufferViewCore$r = arrayBufferViewCore;
	var $every = arrayIteration.every;
	var aTypedArray$p = ArrayBufferViewCore$r.aTypedArray;
	var exportTypedArrayMethod$q = ArrayBufferViewCore$r.exportTypedArrayMethod;

	// `%TypedArray%.prototype.every` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.every
	exportTypedArrayMethod$q('every', function every(callbackfn /* , thisArg */) {
	  return $every(aTypedArray$p(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_fill = {};

	'use strict';
	var ArrayBufferViewCore$q = arrayBufferViewCore;
	var $fill = arrayFill$1;
	var toBigInt$1 = toBigInt$3;
	var classof$2 = classof$m;
	var call$5 = functionCall;
	var uncurryThis$h = functionUncurryThis;
	var fails$d = fails$1m;
	var aTypedArray$o = ArrayBufferViewCore$q.aTypedArray;
	var exportTypedArrayMethod$p = ArrayBufferViewCore$q.exportTypedArrayMethod;
	var slice$3 = uncurryThis$h(''.slice);

	// V8 ~ Chrome < 59, Safari < 14.1, FF < 55, Edge <=18
	var CONVERSION_BUG = fails$d(function () {
	  var count = 0;
	  // eslint-disable-next-line es/no-typed-arrays -- safe
	  new Int8Array(2).fill({
	    valueOf: function valueOf() {
	      return count++;
	    }
	  });
	  return count !== 1;
	});

	// `%TypedArray%.prototype.fill` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.fill
	exportTypedArrayMethod$p('fill', function fill(value /* , start, end */) {
	  var length = arguments.length;
	  aTypedArray$o(this);
	  var actualValue = slice$3(classof$2(this), 0, 3) === 'Big' ? toBigInt$1(value) : +value;
	  return call$5($fill, this, actualValue, length > 1 ? arguments[1] : undefined, length > 2 ? arguments[2] : undefined);
	}, CONVERSION_BUG);

	var es_typedArray_filter = {};

	var ArrayBufferViewCore$p = arrayBufferViewCore;
	var speciesConstructor = speciesConstructor$6;
	var aTypedArrayConstructor$1 = ArrayBufferViewCore$p.aTypedArrayConstructor;
	var getTypedArrayConstructor$3 = ArrayBufferViewCore$p.getTypedArrayConstructor;

	// a part of `TypedArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#typedarray-species-create
	var typedArraySpeciesConstructor$4 = function typedArraySpeciesConstructor(originalArray) {
	  return aTypedArrayConstructor$1(speciesConstructor(originalArray, getTypedArrayConstructor$3(originalArray)));
	};
	var typedArraySpeciesConstructor$5 = /*@__PURE__*/getDefaultExportFromCjs(typedArraySpeciesConstructor$4);

	var arrayFromConstructorAndList$1 = arrayFromConstructorAndList$3;
	var typedArraySpeciesConstructor$3 = typedArraySpeciesConstructor$4;
	var typedArrayFromSpeciesAndList = function typedArrayFromSpeciesAndList(instance, list) {
	  return arrayFromConstructorAndList$1(typedArraySpeciesConstructor$3(instance), list);
	};
	var typedArrayFromSpeciesAndList$1 = /*@__PURE__*/getDefaultExportFromCjs(typedArrayFromSpeciesAndList);

	'use strict';
	var ArrayBufferViewCore$o = arrayBufferViewCore;
	var $filter = arrayIteration.filter;
	var fromSpeciesAndList = typedArrayFromSpeciesAndList;
	var aTypedArray$n = ArrayBufferViewCore$o.aTypedArray;
	var exportTypedArrayMethod$o = ArrayBufferViewCore$o.exportTypedArrayMethod;

	// `%TypedArray%.prototype.filter` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.filter
	exportTypedArrayMethod$o('filter', function filter(callbackfn /* , thisArg */) {
	  var list = $filter(aTypedArray$n(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  return fromSpeciesAndList(this, list);
	});

	var es_typedArray_find = {};

	'use strict';
	var ArrayBufferViewCore$n = arrayBufferViewCore;
	var $find = arrayIteration.find;
	var aTypedArray$m = ArrayBufferViewCore$n.aTypedArray;
	var exportTypedArrayMethod$n = ArrayBufferViewCore$n.exportTypedArrayMethod;

	// `%TypedArray%.prototype.find` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.find
	exportTypedArrayMethod$n('find', function find(predicate /* , thisArg */) {
	  return $find(aTypedArray$m(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_findIndex = {};

	'use strict';
	var ArrayBufferViewCore$m = arrayBufferViewCore;
	var $findIndex = arrayIteration.findIndex;
	var aTypedArray$l = ArrayBufferViewCore$m.aTypedArray;
	var exportTypedArrayMethod$m = ArrayBufferViewCore$m.exportTypedArrayMethod;

	// `%TypedArray%.prototype.findIndex` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.findindex
	exportTypedArrayMethod$m('findIndex', function findIndex(predicate /* , thisArg */) {
	  return $findIndex(aTypedArray$l(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_findLast = {};

	'use strict';
	var ArrayBufferViewCore$l = arrayBufferViewCore;
	var $findLast = arrayIterationFromLast.findLast;
	var aTypedArray$k = ArrayBufferViewCore$l.aTypedArray;
	var exportTypedArrayMethod$l = ArrayBufferViewCore$l.exportTypedArrayMethod;

	// `%TypedArray%.prototype.findLast` method
	// https://github.com/tc39/proposal-array-find-from-last
	exportTypedArrayMethod$l('findLast', function findLast(predicate /* , thisArg */) {
	  return $findLast(aTypedArray$k(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_findLastIndex = {};

	'use strict';
	var ArrayBufferViewCore$k = arrayBufferViewCore;
	var $findLastIndex = arrayIterationFromLast.findLastIndex;
	var aTypedArray$j = ArrayBufferViewCore$k.aTypedArray;
	var exportTypedArrayMethod$k = ArrayBufferViewCore$k.exportTypedArrayMethod;

	// `%TypedArray%.prototype.findLastIndex` method
	// https://github.com/tc39/proposal-array-find-from-last
	exportTypedArrayMethod$k('findLastIndex', function findLastIndex(predicate /* , thisArg */) {
	  return $findLastIndex(aTypedArray$j(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_forEach = {};

	'use strict';
	var ArrayBufferViewCore$j = arrayBufferViewCore;
	var $forEach = arrayIteration.forEach;
	var aTypedArray$i = ArrayBufferViewCore$j.aTypedArray;
	var exportTypedArrayMethod$j = ArrayBufferViewCore$j.exportTypedArrayMethod;

	// `%TypedArray%.prototype.forEach` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.foreach
	exportTypedArrayMethod$j('forEach', function forEach(callbackfn /* , thisArg */) {
	  $forEach(aTypedArray$i(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_from = {};

	'use strict';
	var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS$1 = typedArrayConstructorsRequireWrappers;
	var exportTypedArrayStaticMethod$1 = arrayBufferViewCore.exportTypedArrayStaticMethod;
	var typedArrayFrom = typedArrayFrom$2;

	// `%TypedArray%.from` method
	// https://tc39.es/ecma262/#sec-%typedarray%.from
	exportTypedArrayStaticMethod$1('from', typedArrayFrom, TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS$1);

	var es_typedArray_includes = {};

	'use strict';
	var ArrayBufferViewCore$i = arrayBufferViewCore;
	var $includes = arrayIncludes.includes;
	var aTypedArray$h = ArrayBufferViewCore$i.aTypedArray;
	var exportTypedArrayMethod$i = ArrayBufferViewCore$i.exportTypedArrayMethod;

	// `%TypedArray%.prototype.includes` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.includes
	exportTypedArrayMethod$i('includes', function includes(searchElement /* , fromIndex */) {
	  return $includes(aTypedArray$h(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_indexOf = {};

	'use strict';
	var ArrayBufferViewCore$h = arrayBufferViewCore;
	var $indexOf = arrayIncludes.indexOf;
	var aTypedArray$g = ArrayBufferViewCore$h.aTypedArray;
	var exportTypedArrayMethod$h = ArrayBufferViewCore$h.exportTypedArrayMethod;

	// `%TypedArray%.prototype.indexOf` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.indexof
	exportTypedArrayMethod$h('indexOf', function indexOf(searchElement /* , fromIndex */) {
	  return $indexOf(aTypedArray$g(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_iterator = {};

	'use strict';
	var global$m = global$Z;
	var fails$c = fails$1m;
	var uncurryThis$g = functionUncurryThis;
	var ArrayBufferViewCore$g = arrayBufferViewCore;
	var ArrayIterators = es_array_iterator;
	var wellKnownSymbol$3 = wellKnownSymbol$z;
	var ITERATOR$3 = wellKnownSymbol$3('iterator');
	var Uint8Array$2 = global$m.Uint8Array;
	var arrayValues = uncurryThis$g(ArrayIterators.values);
	var arrayKeys = uncurryThis$g(ArrayIterators.keys);
	var arrayEntries = uncurryThis$g(ArrayIterators.entries);
	var aTypedArray$f = ArrayBufferViewCore$g.aTypedArray;
	var exportTypedArrayMethod$g = ArrayBufferViewCore$g.exportTypedArrayMethod;
	var TypedArrayPrototype = Uint8Array$2 && Uint8Array$2.prototype;
	var GENERIC = !fails$c(function () {
	  TypedArrayPrototype[ITERATOR$3].call([1]);
	});
	var ITERATOR_IS_VALUES = !!TypedArrayPrototype && TypedArrayPrototype.values && TypedArrayPrototype[ITERATOR$3] === TypedArrayPrototype.values && TypedArrayPrototype.values.name === 'values';
	var typedArrayValues = function values() {
	  return arrayValues(aTypedArray$f(this));
	};

	// `%TypedArray%.prototype.entries` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.entries
	exportTypedArrayMethod$g('entries', function entries() {
	  return arrayEntries(aTypedArray$f(this));
	}, GENERIC);
	// `%TypedArray%.prototype.keys` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.keys
	exportTypedArrayMethod$g('keys', function keys() {
	  return arrayKeys(aTypedArray$f(this));
	}, GENERIC);
	// `%TypedArray%.prototype.values` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.values
	exportTypedArrayMethod$g('values', typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, {
	  name: 'values'
	});
	// `%TypedArray%.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype-@@iterator
	exportTypedArrayMethod$g(ITERATOR$3, typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, {
	  name: 'values'
	});

	var es_typedArray_join = {};

	'use strict';
	var ArrayBufferViewCore$f = arrayBufferViewCore;
	var uncurryThis$f = functionUncurryThis;
	var aTypedArray$e = ArrayBufferViewCore$f.aTypedArray;
	var exportTypedArrayMethod$f = ArrayBufferViewCore$f.exportTypedArrayMethod;
	var $join = uncurryThis$f([].join);

	// `%TypedArray%.prototype.join` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.join
	exportTypedArrayMethod$f('join', function join(separator) {
	  return $join(aTypedArray$e(this), separator);
	});

	var es_typedArray_lastIndexOf = {};

	'use strict';
	var ArrayBufferViewCore$e = arrayBufferViewCore;
	var apply$2 = functionApply$1;
	var $lastIndexOf = arrayLastIndexOf;
	var aTypedArray$d = ArrayBufferViewCore$e.aTypedArray;
	var exportTypedArrayMethod$e = ArrayBufferViewCore$e.exportTypedArrayMethod;

	// `%TypedArray%.prototype.lastIndexOf` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.lastindexof
	exportTypedArrayMethod$e('lastIndexOf', function lastIndexOf(searchElement /* , fromIndex */) {
	  var length = arguments.length;
	  return apply$2($lastIndexOf, aTypedArray$d(this), length > 1 ? [searchElement, arguments[1]] : [searchElement]);
	});

	var es_typedArray_map = {};

	'use strict';
	var ArrayBufferViewCore$d = arrayBufferViewCore;
	var $map = arrayIteration.map;
	var typedArraySpeciesConstructor$2 = typedArraySpeciesConstructor$4;
	var aTypedArray$c = ArrayBufferViewCore$d.aTypedArray;
	var exportTypedArrayMethod$d = ArrayBufferViewCore$d.exportTypedArrayMethod;

	// `%TypedArray%.prototype.map` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.map
	exportTypedArrayMethod$d('map', function map(mapfn /* , thisArg */) {
	  return $map(aTypedArray$c(this), mapfn, arguments.length > 1 ? arguments[1] : undefined, function (O, length) {
	    return new (typedArraySpeciesConstructor$2(O))(length);
	  });
	});

	var es_typedArray_of = {};

	'use strict';
	var ArrayBufferViewCore$c = arrayBufferViewCore;
	var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = typedArrayConstructorsRequireWrappers;
	var aTypedArrayConstructor = ArrayBufferViewCore$c.aTypedArrayConstructor;
	var exportTypedArrayStaticMethod = ArrayBufferViewCore$c.exportTypedArrayStaticMethod;

	// `%TypedArray%.of` method
	// https://tc39.es/ecma262/#sec-%typedarray%.of
	exportTypedArrayStaticMethod('of', function of( /* ...items */
	) {
	  var index = 0;
	  var length = arguments.length;
	  var result = new (aTypedArrayConstructor(this))(length);
	  while (length > index) result[index] = arguments[index++];
	  return result;
	}, TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS);

	var es_typedArray_reduce = {};

	'use strict';
	var ArrayBufferViewCore$b = arrayBufferViewCore;
	var $reduce = arrayReduce.left;
	var aTypedArray$b = ArrayBufferViewCore$b.aTypedArray;
	var exportTypedArrayMethod$c = ArrayBufferViewCore$b.exportTypedArrayMethod;

	// `%TypedArray%.prototype.reduce` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.reduce
	exportTypedArrayMethod$c('reduce', function reduce(callbackfn /* , initialValue */) {
	  var length = arguments.length;
	  return $reduce(aTypedArray$b(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_reduceRight = {};

	'use strict';
	var ArrayBufferViewCore$a = arrayBufferViewCore;
	var $reduceRight = arrayReduce.right;
	var aTypedArray$a = ArrayBufferViewCore$a.aTypedArray;
	var exportTypedArrayMethod$b = ArrayBufferViewCore$a.exportTypedArrayMethod;

	// `%TypedArray%.prototype.reduceRight` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.reduceright
	exportTypedArrayMethod$b('reduceRight', function reduceRight(callbackfn /* , initialValue */) {
	  var length = arguments.length;
	  return $reduceRight(aTypedArray$a(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_reverse = {};

	'use strict';
	var ArrayBufferViewCore$9 = arrayBufferViewCore;
	var aTypedArray$9 = ArrayBufferViewCore$9.aTypedArray;
	var exportTypedArrayMethod$a = ArrayBufferViewCore$9.exportTypedArrayMethod;
	var floor$5 = Math.floor;

	// `%TypedArray%.prototype.reverse` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.reverse
	exportTypedArrayMethod$a('reverse', function reverse() {
	  var that = this;
	  var length = aTypedArray$9(that).length;
	  var middle = floor$5(length / 2);
	  var index = 0;
	  var value;
	  while (index < middle) {
	    value = that[index];
	    that[index++] = that[--length];
	    that[length] = value;
	  }
	  return that;
	});

	var es_typedArray_set = {};

	'use strict';
	var global$l = global$Z;
	var call$4 = functionCall;
	var ArrayBufferViewCore$8 = arrayBufferViewCore;
	var lengthOfArrayLike$1 = lengthOfArrayLike$t;
	var toOffset = toOffset$2;
	var toIndexedObject = toObject$t;
	var fails$b = fails$1m;
	var RangeError$2 = global$l.RangeError;
	var Int8Array$2 = global$l.Int8Array;
	var Int8ArrayPrototype = Int8Array$2 && Int8Array$2.prototype;
	var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
	var aTypedArray$8 = ArrayBufferViewCore$8.aTypedArray;
	var exportTypedArrayMethod$9 = ArrayBufferViewCore$8.exportTypedArrayMethod;
	var WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS = !fails$b(function () {
	  // eslint-disable-next-line es/no-typed-arrays -- required for testing
	  var array = new Uint8ClampedArray(2);
	  call$4($set, array, {
	    length: 1,
	    0: 3
	  }, 1);
	  return array[1] !== 3;
	});

	// https://bugs.chromium.org/p/v8/issues/detail?id=11294 and other
	var TO_OBJECT_BUG = WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS && ArrayBufferViewCore$8.NATIVE_ARRAY_BUFFER_VIEWS && fails$b(function () {
	  var array = new Int8Array$2(2);
	  array.set(1);
	  array.set('2', 1);
	  return array[0] !== 0 || array[1] !== 2;
	});

	// `%TypedArray%.prototype.set` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.set
	exportTypedArrayMethod$9('set', function set(arrayLike /* , offset */) {
	  aTypedArray$8(this);
	  var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
	  var src = toIndexedObject(arrayLike);
	  if (WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS) return call$4($set, this, src, offset);
	  var length = this.length;
	  var len = lengthOfArrayLike$1(src);
	  var index = 0;
	  if (len + offset > length) throw RangeError$2('Wrong length');
	  while (index < len) this[offset + index] = src[index++];
	}, !WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG);

	var es_typedArray_slice = {};

	'use strict';
	var ArrayBufferViewCore$7 = arrayBufferViewCore;
	var typedArraySpeciesConstructor$1 = typedArraySpeciesConstructor$4;
	var fails$a = fails$1m;
	var arraySlice$3 = arraySlice$a;
	var aTypedArray$7 = ArrayBufferViewCore$7.aTypedArray;
	var exportTypedArrayMethod$8 = ArrayBufferViewCore$7.exportTypedArrayMethod;
	var FORCED$1 = fails$a(function () {
	  // eslint-disable-next-line es/no-typed-arrays -- required for testing
	  new Int8Array(1).slice();
	});

	// `%TypedArray%.prototype.slice` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.slice
	exportTypedArrayMethod$8('slice', function slice(start, end) {
	  var list = arraySlice$3(aTypedArray$7(this), start, end);
	  var C = typedArraySpeciesConstructor$1(this);
	  var index = 0;
	  var length = list.length;
	  var result = new C(length);
	  while (length > index) result[index] = list[index++];
	  return result;
	}, FORCED$1);

	var es_typedArray_some = {};

	'use strict';
	var ArrayBufferViewCore$6 = arrayBufferViewCore;
	var $some = arrayIteration.some;
	var aTypedArray$6 = ArrayBufferViewCore$6.aTypedArray;
	var exportTypedArrayMethod$7 = ArrayBufferViewCore$6.exportTypedArrayMethod;

	// `%TypedArray%.prototype.some` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.some
	exportTypedArrayMethod$7('some', function some(callbackfn /* , thisArg */) {
	  return $some(aTypedArray$6(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});

	var es_typedArray_sort = {};

	'use strict';
	var global$k = global$Z;
	var uncurryThis$e = functionUncurryThisClause;
	var fails$9 = fails$1m;
	var aCallable$2 = aCallable$l;
	var internalSort = arraySort$1;
	var ArrayBufferViewCore$5 = arrayBufferViewCore;
	var FF = engineFfVersion;
	var IE_OR_EDGE = engineIsIeOrEdge;
	var V8$1 = engineV8Version;
	var WEBKIT = engineWebkitVersion;
	var aTypedArray$5 = ArrayBufferViewCore$5.aTypedArray;
	var exportTypedArrayMethod$6 = ArrayBufferViewCore$5.exportTypedArrayMethod;
	var Uint16Array$1 = global$k.Uint16Array;
	var nativeSort = Uint16Array$1 && uncurryThis$e(Uint16Array$1.prototype.sort);

	// WebKit
	var ACCEPT_INCORRECT_ARGUMENTS = !!nativeSort && !(fails$9(function () {
	  nativeSort(new Uint16Array$1(2), null);
	}) && fails$9(function () {
	  nativeSort(new Uint16Array$1(2), {});
	}));
	var STABLE_SORT = !!nativeSort && !fails$9(function () {
	  // feature detection can be too slow, so check engines versions
	  if (V8$1) return V8$1 < 74;
	  if (FF) return FF < 67;
	  if (IE_OR_EDGE) return true;
	  if (WEBKIT) return WEBKIT < 602;
	  var array = new Uint16Array$1(516);
	  var expected = Array(516);
	  var index, mod;
	  for (index = 0; index < 516; index++) {
	    mod = index % 4;
	    array[index] = 515 - index;
	    expected[index] = index - 2 * mod + 3;
	  }
	  nativeSort(array, function (a, b) {
	    return (a / 4 | 0) - (b / 4 | 0);
	  });
	  for (index = 0; index < 516; index++) {
	    if (array[index] !== expected[index]) return true;
	  }
	});
	var getSortCompare = function getSortCompare(comparefn) {
	  return function (x, y) {
	    if (comparefn !== undefined) return +comparefn(x, y) || 0;
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (y !== y) return -1;
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (x !== x) return 1;
	    if (x === 0 && y === 0) return 1 / x > 0 && 1 / y < 0 ? 1 : -1;
	    return x > y;
	  };
	};

	// `%TypedArray%.prototype.sort` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.sort
	exportTypedArrayMethod$6('sort', function sort(comparefn) {
	  if (comparefn !== undefined) aCallable$2(comparefn);
	  if (STABLE_SORT) return nativeSort(this, comparefn);
	  return internalSort(aTypedArray$5(this), getSortCompare(comparefn));
	}, !STABLE_SORT || ACCEPT_INCORRECT_ARGUMENTS);

	var es_typedArray_subarray = {};

	'use strict';
	var ArrayBufferViewCore$4 = arrayBufferViewCore;
	var toLength = toLength$d;
	var toAbsoluteIndex = toAbsoluteIndex$a;
	var typedArraySpeciesConstructor = typedArraySpeciesConstructor$4;
	var aTypedArray$4 = ArrayBufferViewCore$4.aTypedArray;
	var exportTypedArrayMethod$5 = ArrayBufferViewCore$4.exportTypedArrayMethod;

	// `%TypedArray%.prototype.subarray` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.subarray
	exportTypedArrayMethod$5('subarray', function subarray(begin, end) {
	  var O = aTypedArray$4(this);
	  var length = O.length;
	  var beginIndex = toAbsoluteIndex(begin, length);
	  var C = typedArraySpeciesConstructor(O);
	  return new C(O.buffer, O.byteOffset + beginIndex * O.BYTES_PER_ELEMENT, toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - beginIndex));
	});

	var es_typedArray_toLocaleString = {};

	'use strict';
	var global$j = global$Z;
	var apply$1 = functionApply$1;
	var ArrayBufferViewCore$3 = arrayBufferViewCore;
	var fails$8 = fails$1m;
	var arraySlice$2 = arraySlice$a;
	var Int8Array$1 = global$j.Int8Array;
	var aTypedArray$3 = ArrayBufferViewCore$3.aTypedArray;
	var exportTypedArrayMethod$4 = ArrayBufferViewCore$3.exportTypedArrayMethod;
	var $toLocaleString = [].toLocaleString;

	// iOS Safari 6.x fails here
	var TO_LOCALE_STRING_BUG = !!Int8Array$1 && fails$8(function () {
	  $toLocaleString.call(new Int8Array$1(1));
	});
	var FORCED = fails$8(function () {
	  return [1, 2].toLocaleString() != new Int8Array$1([1, 2]).toLocaleString();
	}) || !fails$8(function () {
	  Int8Array$1.prototype.toLocaleString.call([1, 2]);
	});

	// `%TypedArray%.prototype.toLocaleString` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.tolocalestring
	exportTypedArrayMethod$4('toLocaleString', function toLocaleString() {
	  return apply$1($toLocaleString, TO_LOCALE_STRING_BUG ? arraySlice$2(aTypedArray$3(this)) : aTypedArray$3(this), arraySlice$2(arguments));
	}, FORCED);

	var es_typedArray_toReversed = {};

	'use strict';
	var arrayToReversed = arrayToReversed$2;
	var ArrayBufferViewCore$2 = arrayBufferViewCore;
	var aTypedArray$2 = ArrayBufferViewCore$2.aTypedArray;
	var exportTypedArrayMethod$3 = ArrayBufferViewCore$2.exportTypedArrayMethod;
	var getTypedArrayConstructor$2 = ArrayBufferViewCore$2.getTypedArrayConstructor;

	// `%TypedArray%.prototype.toReversed` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.toReversed
	exportTypedArrayMethod$3('toReversed', function toReversed() {
	  return arrayToReversed(aTypedArray$2(this), getTypedArrayConstructor$2(this));
	});

	var es_typedArray_toSorted = {};

	'use strict';
	var ArrayBufferViewCore$1 = arrayBufferViewCore;
	var uncurryThis$d = functionUncurryThis;
	var aCallable$1 = aCallable$l;
	var arrayFromConstructorAndList = arrayFromConstructorAndList$3;
	var aTypedArray$1 = ArrayBufferViewCore$1.aTypedArray;
	var getTypedArrayConstructor$1 = ArrayBufferViewCore$1.getTypedArrayConstructor;
	var exportTypedArrayMethod$2 = ArrayBufferViewCore$1.exportTypedArrayMethod;
	var sort = uncurryThis$d(ArrayBufferViewCore$1.TypedArrayPrototype.sort);

	// `%TypedArray%.prototype.toSorted` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.toSorted
	exportTypedArrayMethod$2('toSorted', function toSorted(compareFn) {
	  if (compareFn !== undefined) aCallable$1(compareFn);
	  var O = aTypedArray$1(this);
	  var A = arrayFromConstructorAndList(getTypedArrayConstructor$1(O), O);
	  return sort(A, compareFn);
	});

	var es_typedArray_toString = {};

	'use strict';
	var exportTypedArrayMethod$1 = arrayBufferViewCore.exportTypedArrayMethod;
	var fails$7 = fails$1m;
	var global$i = global$Z;
	var uncurryThis$c = functionUncurryThis;
	var Uint8Array$1 = global$i.Uint8Array;
	var Uint8ArrayPrototype = Uint8Array$1 && Uint8Array$1.prototype || {};
	var arrayToString = [].toString;
	var join$3 = uncurryThis$c([].join);
	if (fails$7(function () {
	  arrayToString.call({});
	})) {
	  arrayToString = function toString() {
	    return join$3(this);
	  };
	}
	var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString;

	// `%TypedArray%.prototype.toString` method
	// https://tc39.es/ecma262/#sec-%typedarray%.prototype.tostring
	exportTypedArrayMethod$1('toString', arrayToString, IS_NOT_ARRAY_METHOD);

	var es_typedArray_with = {};

	'use strict';
	var arrayWith = arrayWith$2;
	var ArrayBufferViewCore = arrayBufferViewCore;
	var isBigIntArray = isBigIntArray$2;
	var toIntegerOrInfinity = toIntegerOrInfinity$l;
	var toBigInt = toBigInt$3;
	var aTypedArray = ArrayBufferViewCore.aTypedArray;
	var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
	var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
	var PROPER_ORDER = !!function () {
	  try {
	    // eslint-disable-next-line no-throw-literal, es/no-typed-arrays, es/no-array-prototype-with -- required for testing
	    new Int8Array(1)['with'](2, {
	      valueOf: function valueOf() {
	        throw 8;
	      }
	    });
	  } catch (error) {
	    // some early implementations, like WebKit, does not follow the final semantic
	    // https://github.com/tc39/proposal-change-array-by-copy/pull/86
	    return error === 8;
	  }
	}();

	// `%TypedArray%.prototype.with` method
	// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.with
	exportTypedArrayMethod('with', {
	  'with': function _with(index, value) {
	    var O = aTypedArray(this);
	    var relativeIndex = toIntegerOrInfinity(index);
	    var actualValue = isBigIntArray(O) ? toBigInt(value) : +value;
	    return arrayWith(O, getTypedArrayConstructor(O), relativeIndex, actualValue);
	  }
	}['with'], !PROPER_ORDER);

	var es_unescape = {};

	'use strict';
	var $$e = _export;
	var uncurryThis$b = functionUncurryThis;
	var toString$2 = toString$x;
	var fromCharCode$2 = String.fromCharCode;
	var charAt$4 = uncurryThis$b(''.charAt);
	var exec$3 = uncurryThis$b(/./.exec);
	var stringSlice$2 = uncurryThis$b(''.slice);
	var hex2 = /^[\da-f]{2}$/i;
	var hex4 = /^[\da-f]{4}$/i;

	// `unescape` method
	// https://tc39.es/ecma262/#sec-unescape-string
	$$e({
	  global: true
	}, {
	  unescape: function unescape(string) {
	    var str = toString$2(string);
	    var result = '';
	    var length = str.length;
	    var index = 0;
	    var chr, part;
	    while (index < length) {
	      chr = charAt$4(str, index++);
	      if (chr === '%') {
	        if (charAt$4(str, index) === 'u') {
	          part = stringSlice$2(str, index + 1, index + 5);
	          if (exec$3(hex4, part)) {
	            result += fromCharCode$2(parseInt(part, 16));
	            index += 5;
	            continue;
	          }
	        } else {
	          part = stringSlice$2(str, index, index + 2);
	          if (exec$3(hex2, part)) {
	            result += fromCharCode$2(parseInt(part, 16));
	            index += 2;
	            continue;
	          }
	        }
	      }
	      result += chr;
	    }
	    return result;
	  }
	});

	var es_weakMap = {};

	var es_weakMap_constructor = {};

	'use strict';
	var uncurryThis$a = functionUncurryThis;
	var defineBuiltIns$2 = defineBuiltIns$5;
	var getWeakData = internalMetadataExports.getWeakData;
	var anInstance$4 = anInstance$a;
	var anObject$3 = anObject$D;
	var isNullOrUndefined$1 = isNullOrUndefined$e;
	var isObject$3 = isObject$z;
	var iterate$1 = iterate$a;
	var ArrayIterationModule = arrayIteration;
	var hasOwn$6 = hasOwnProperty_1;
	var InternalStateModule$3 = internalState;
	var setInternalState$3 = InternalStateModule$3.set;
	var internalStateGetterFor = InternalStateModule$3.getterFor;
	var find$1 = ArrayIterationModule.find;
	var findIndex = ArrayIterationModule.findIndex;
	var splice$1 = uncurryThis$a([].splice);
	var id = 0;

	// fallback for uncaught frozen keys
	var uncaughtFrozenStore = function uncaughtFrozenStore(state) {
	  return state.frozen || (state.frozen = new UncaughtFrozenStore());
	};
	var UncaughtFrozenStore = function UncaughtFrozenStore() {
	  this.entries = [];
	};
	var findUncaughtFrozen = function findUncaughtFrozen(store, key) {
	  return find$1(store.entries, function (it) {
	    return it[0] === key;
	  });
	};
	UncaughtFrozenStore.prototype = {
	  get: function get(key) {
	    var entry = findUncaughtFrozen(this, key);
	    if (entry) return entry[1];
	  },
	  has: function has(key) {
	    return !!findUncaughtFrozen(this, key);
	  },
	  set: function set(key, value) {
	    var entry = findUncaughtFrozen(this, key);
	    if (entry) entry[1] = value;else this.entries.push([key, value]);
	  },
	  'delete': function _delete(key) {
	    var index = findIndex(this.entries, function (it) {
	      return it[0] === key;
	    });
	    if (~index) splice$1(this.entries, index, 1);
	    return !!~index;
	  }
	};
	var collectionWeak$2 = {
	  getConstructor: function getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var Constructor = wrapper(function (that, iterable) {
	      anInstance$4(that, Prototype);
	      setInternalState$3(that, {
	        type: CONSTRUCTOR_NAME,
	        id: id++,
	        frozen: undefined
	      });
	      if (!isNullOrUndefined$1(iterable)) iterate$1(iterable, that[ADDER], {
	        that: that,
	        AS_ENTRIES: IS_MAP
	      });
	    });
	    var Prototype = Constructor.prototype;
	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    var define = function define(that, key, value) {
	      var state = getInternalState(that);
	      var data = getWeakData(anObject$3(key), true);
	      if (data === true) uncaughtFrozenStore(state).set(key, value);else data[state.id] = value;
	      return that;
	    };
	    defineBuiltIns$2(Prototype, {
	      // `{ WeakMap, WeakSet }.prototype.delete(key)` methods
	      // https://tc39.es/ecma262/#sec-weakmap.prototype.delete
	      // https://tc39.es/ecma262/#sec-weakset.prototype.delete
	      'delete': function _delete(key) {
	        var state = getInternalState(this);
	        if (!isObject$3(key)) return false;
	        var data = getWeakData(key);
	        if (data === true) return uncaughtFrozenStore(state)['delete'](key);
	        return data && hasOwn$6(data, state.id) && delete data[state.id];
	      },
	      // `{ WeakMap, WeakSet }.prototype.has(key)` methods
	      // https://tc39.es/ecma262/#sec-weakmap.prototype.has
	      // https://tc39.es/ecma262/#sec-weakset.prototype.has
	      has: function has(key) {
	        var state = getInternalState(this);
	        if (!isObject$3(key)) return false;
	        var data = getWeakData(key);
	        if (data === true) return uncaughtFrozenStore(state).has(key);
	        return data && hasOwn$6(data, state.id);
	      }
	    });
	    defineBuiltIns$2(Prototype, IS_MAP ? {
	      // `WeakMap.prototype.get(key)` method
	      // https://tc39.es/ecma262/#sec-weakmap.prototype.get
	      get: function get(key) {
	        var state = getInternalState(this);
	        if (isObject$3(key)) {
	          var data = getWeakData(key);
	          if (data === true) return uncaughtFrozenStore(state).get(key);
	          return data ? data[state.id] : undefined;
	        }
	      },
	      // `WeakMap.prototype.set(key, value)` method
	      // https://tc39.es/ecma262/#sec-weakmap.prototype.set
	      set: function set(key, value) {
	        return define(this, key, value);
	      }
	    } : {
	      // `WeakSet.prototype.add(value)` method
	      // https://tc39.es/ecma262/#sec-weakset.prototype.add
	      add: function add(value) {
	        return define(this, value, true);
	      }
	    });
	    return Constructor;
	  }
	};
	var collectionWeak$3 = /*@__PURE__*/getDefaultExportFromCjs(collectionWeak$2);

	'use strict';
	var FREEZING = freezing;
	var global$h = global$Z;
	var uncurryThis$9 = functionUncurryThis;
	var defineBuiltIns$1 = defineBuiltIns$5;
	var InternalMetadataModule = internalMetadataExports;
	var collection$1 = collection$4;
	var collectionWeak$1 = collectionWeak$2;
	var isObject$2 = isObject$z;
	var enforceInternalState = internalState.enforce;
	var fails$6 = fails$1m;
	var NATIVE_WEAK_MAP = weakMapBasicDetection;
	var $Object = Object;
	// eslint-disable-next-line es/no-array-isarray -- safe
	var isArray = Array.isArray;
	// eslint-disable-next-line es/no-object-isextensible -- safe
	var isExtensible = $Object.isExtensible;
	// eslint-disable-next-line es/no-object-isfrozen -- safe
	var isFrozen = $Object.isFrozen;
	// eslint-disable-next-line es/no-object-issealed -- safe
	var isSealed = $Object.isSealed;
	// eslint-disable-next-line es/no-object-freeze -- safe
	var freeze = $Object.freeze;
	// eslint-disable-next-line es/no-object-seal -- safe
	var seal = $Object.seal;
	var FROZEN = {};
	var SEALED = {};
	var IS_IE11 = !global$h.ActiveXObject && 'ActiveXObject' in global$h;
	var InternalWeakMap;
	var wrapper = function wrapper(init) {
	  return function WeakMap() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	};

	// `WeakMap` constructor
	// https://tc39.es/ecma262/#sec-weakmap-constructor
	var $WeakMap = collection$1('WeakMap', wrapper, collectionWeak$1);
	var WeakMapPrototype = $WeakMap.prototype;
	var nativeSet = uncurryThis$9(WeakMapPrototype.set);

	// Chakra Edge bug: adding frozen arrays to WeakMap unfreeze them
	var hasMSEdgeFreezingBug = function hasMSEdgeFreezingBug() {
	  return FREEZING && fails$6(function () {
	    var frozenArray = freeze([]);
	    nativeSet(new $WeakMap(), frozenArray, 1);
	    return !isFrozen(frozenArray);
	  });
	};

	// IE11 WeakMap frozen keys fix
	// We can't use feature detection because it crash some old IE builds
	// https://github.com/zloirock/core-js/issues/485
	if (NATIVE_WEAK_MAP) if (IS_IE11) {
	  InternalWeakMap = collectionWeak$1.getConstructor(wrapper, 'WeakMap', true);
	  InternalMetadataModule.enable();
	  var nativeDelete = uncurryThis$9(WeakMapPrototype['delete']);
	  var nativeHas = uncurryThis$9(WeakMapPrototype.has);
	  var nativeGet = uncurryThis$9(WeakMapPrototype.get);
	  defineBuiltIns$1(WeakMapPrototype, {
	    'delete': function _delete(key) {
	      if (isObject$2(key) && !isExtensible(key)) {
	        var state = enforceInternalState(this);
	        if (!state.frozen) state.frozen = new InternalWeakMap();
	        return nativeDelete(this, key) || state.frozen['delete'](key);
	      }
	      return nativeDelete(this, key);
	    },
	    has: function has(key) {
	      if (isObject$2(key) && !isExtensible(key)) {
	        var state = enforceInternalState(this);
	        if (!state.frozen) state.frozen = new InternalWeakMap();
	        return nativeHas(this, key) || state.frozen.has(key);
	      }
	      return nativeHas(this, key);
	    },
	    get: function get(key) {
	      if (isObject$2(key) && !isExtensible(key)) {
	        var state = enforceInternalState(this);
	        if (!state.frozen) state.frozen = new InternalWeakMap();
	        return nativeHas(this, key) ? nativeGet(this, key) : state.frozen.get(key);
	      }
	      return nativeGet(this, key);
	    },
	    set: function set(key, value) {
	      if (isObject$2(key) && !isExtensible(key)) {
	        var state = enforceInternalState(this);
	        if (!state.frozen) state.frozen = new InternalWeakMap();
	        nativeHas(this, key) ? nativeSet(this, key, value) : state.frozen.set(key, value);
	      } else nativeSet(this, key, value);
	      return this;
	    }
	  });
	  // Chakra Edge frozen keys fix
	} else if (hasMSEdgeFreezingBug()) {
	  defineBuiltIns$1(WeakMapPrototype, {
	    set: function set(key, value) {
	      var arrayIntegrityLevel;
	      if (isArray(key)) {
	        if (isFrozen(key)) arrayIntegrityLevel = FROZEN;else if (isSealed(key)) arrayIntegrityLevel = SEALED;
	      }
	      nativeSet(this, key, value);
	      if (arrayIntegrityLevel == FROZEN) freeze(key);
	      if (arrayIntegrityLevel == SEALED) seal(key);
	      return this;
	    }
	  });
	}

	var es_weakSet = {};

	var es_weakSet_constructor = {};

	'use strict';
	var collection = collection$4;
	var collectionWeak = collectionWeak$2;

	// `WeakSet` constructor
	// https://tc39.es/ecma262/#sec-weakset-constructor
	collection('WeakSet', function (init) {
	  return function WeakSet() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionWeak);

	var web_atob = {};

	var itoc$1 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var ctoi$1 = {};
	for (var index$3 = 0; index$3 < 66; index$3++) ctoi$1[itoc$1.charAt(index$3)] = index$3;
	var base64Map = {
	  itoc: itoc$1,
	  ctoi: ctoi$1
	};
	var base64Map$1 = /*@__PURE__*/getDefaultExportFromCjs(base64Map);

	var $$d = _export;
	var global$g = global$Z;
	var getBuiltIn$4 = getBuiltIn$m;
	var uncurryThis$8 = functionUncurryThis;
	var call$3 = functionCall;
	var fails$5 = fails$1m;
	var toString$1 = toString$x;
	var hasOwn$5 = hasOwnProperty_1;
	var validateArgumentsLength$6 = validateArgumentsLength$8;
	var ctoi = base64Map.ctoi;
	var disallowed = /[^\d+/a-z]/i;
	var whitespaces = /[\t\n\f\r ]+/g;
	var finalEq = /[=]{1,2}$/;
	var $atob = getBuiltIn$4('atob');
	var fromCharCode$1 = String.fromCharCode;
	var charAt$3 = uncurryThis$8(''.charAt);
	var replace$3 = uncurryThis$8(''.replace);
	var exec$2 = uncurryThis$8(disallowed.exec);
	var NO_SPACES_IGNORE = fails$5(function () {
	  return $atob(' ') !== '';
	});
	var NO_ENCODING_CHECK = !fails$5(function () {
	  $atob('a');
	});
	var NO_ARG_RECEIVING_CHECK$1 = !NO_SPACES_IGNORE && !NO_ENCODING_CHECK && !fails$5(function () {
	  $atob();
	});
	var WRONG_ARITY$1 = !NO_SPACES_IGNORE && !NO_ENCODING_CHECK && $atob.length !== 1;

	// `atob` method
	// https://html.spec.whatwg.org/multipage/webappapis.html#dom-atob
	$$d({
	  global: true,
	  bind: true,
	  enumerable: true,
	  forced: NO_SPACES_IGNORE || NO_ENCODING_CHECK || NO_ARG_RECEIVING_CHECK$1 || WRONG_ARITY$1
	}, {
	  atob: function atob(data) {
	    validateArgumentsLength$6(arguments.length, 1);
	    // `webpack` dev server bug on IE global methods - use call(fn, global, ...)
	    if (NO_ARG_RECEIVING_CHECK$1 || WRONG_ARITY$1) return call$3($atob, global$g, data);
	    var string = replace$3(toString$1(data), whitespaces, '');
	    var output = '';
	    var position = 0;
	    var bc = 0;
	    var chr, bs;
	    if (string.length % 4 == 0) {
	      string = replace$3(string, finalEq, '');
	    }
	    if (string.length % 4 == 1 || exec$2(disallowed, string)) {
	      throw new (getBuiltIn$4('DOMException'))('The string is not correctly encoded', 'InvalidCharacterError');
	    }
	    while (chr = charAt$3(string, position++)) {
	      if (hasOwn$5(ctoi, chr)) {
	        bs = bc % 4 ? bs * 64 + ctoi[chr] : ctoi[chr];
	        if (bc++ % 4) output += fromCharCode$1(255 & bs >> (-2 * bc & 6));
	      }
	    }
	    return output;
	  }
	});

	var web_btoa = {};

	var $$c = _export;
	var global$f = global$Z;
	var getBuiltIn$3 = getBuiltIn$m;
	var uncurryThis$7 = functionUncurryThis;
	var call$2 = functionCall;
	var fails$4 = fails$1m;
	var toString = toString$x;
	var validateArgumentsLength$5 = validateArgumentsLength$8;
	var itoc = base64Map.itoc;
	var $btoa = getBuiltIn$3('btoa');
	var charAt$2 = uncurryThis$7(''.charAt);
	var charCodeAt$1 = uncurryThis$7(''.charCodeAt);
	var NO_ARG_RECEIVING_CHECK = !!$btoa && !fails$4(function () {
	  $btoa();
	});
	var WRONG_ARG_CONVERSION = !!$btoa && fails$4(function () {
	  return $btoa(null) !== 'bnVsbA==';
	});
	var WRONG_ARITY = !!$btoa && $btoa.length !== 1;

	// `btoa` method
	// https://html.spec.whatwg.org/multipage/webappapis.html#dom-btoa
	$$c({
	  global: true,
	  bind: true,
	  enumerable: true,
	  forced: NO_ARG_RECEIVING_CHECK || WRONG_ARG_CONVERSION || WRONG_ARITY
	}, {
	  btoa: function btoa(data) {
	    validateArgumentsLength$5(arguments.length, 1);
	    // `webpack` dev server bug on IE global methods - use call(fn, global, ...)
	    if (NO_ARG_RECEIVING_CHECK || WRONG_ARG_CONVERSION || WRONG_ARITY) return call$2($btoa, global$f, toString(data));
	    var string = toString(data);
	    var output = '';
	    var position = 0;
	    var map = itoc;
	    var block, charCode;
	    while (charAt$2(string, position) || (map = '=', position % 1)) {
	      charCode = charCodeAt$1(string, position += 3 / 4);
	      if (charCode > 0xFF) {
	        throw new (getBuiltIn$3('DOMException'))('The string contains characters outside of the Latin1 range', 'InvalidCharacterError');
	      }
	      block = block << 8 | charCode;
	      output += charAt$2(map, 63 & block >> 8 - position % 1 * 8);
	    }
	    return output;
	  }
	});

	var web_domCollections_forEach = {};

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};
	var domIterables$1 = /*@__PURE__*/getDefaultExportFromCjs(domIterables);

	// in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
	var documentCreateElement = documentCreateElement$2;
	var classList = documentCreateElement('span').classList;
	var DOMTokenListPrototype$2 = classList && classList.constructor && classList.constructor.prototype;
	var domTokenListPrototype = DOMTokenListPrototype$2 === Object.prototype ? undefined : DOMTokenListPrototype$2;
	var domTokenListPrototype$1 = /*@__PURE__*/getDefaultExportFromCjs(domTokenListPrototype);

	var global$e = global$Z;
	var DOMIterables$1 = domIterables;
	var DOMTokenListPrototype$1 = domTokenListPrototype;
	var forEach$1 = arrayForEach;
	var createNonEnumerableProperty$2 = createNonEnumerableProperty$f;
	var handlePrototype$1 = function handlePrototype(CollectionPrototype) {
	  // some Chrome versions have non-configurable methods on DOMTokenList
	  if (CollectionPrototype && CollectionPrototype.forEach !== forEach$1) try {
	    createNonEnumerableProperty$2(CollectionPrototype, 'forEach', forEach$1);
	  } catch (error) {
	    CollectionPrototype.forEach = forEach$1;
	  }
	};
	for (var COLLECTION_NAME$1 in DOMIterables$1) {
	  if (DOMIterables$1[COLLECTION_NAME$1]) {
	    handlePrototype$1(global$e[COLLECTION_NAME$1] && global$e[COLLECTION_NAME$1].prototype);
	  }
	}
	handlePrototype$1(DOMTokenListPrototype$1);

	var web_domCollections_iterator = {};

	var global$d = global$Z;
	var DOMIterables = domIterables;
	var DOMTokenListPrototype = domTokenListPrototype;
	var ArrayIteratorMethods = es_array_iterator;
	var createNonEnumerableProperty$1 = createNonEnumerableProperty$f;
	var wellKnownSymbol$2 = wellKnownSymbol$z;
	var ITERATOR$2 = wellKnownSymbol$2('iterator');
	var TO_STRING_TAG = wellKnownSymbol$2('toStringTag');
	var ArrayValues = ArrayIteratorMethods.values;
	var handlePrototype = function handlePrototype(CollectionPrototype, COLLECTION_NAME) {
	  if (CollectionPrototype) {
	    // some Chrome versions have non-configurable methods on DOMTokenList
	    if (CollectionPrototype[ITERATOR$2] !== ArrayValues) try {
	      createNonEnumerableProperty$1(CollectionPrototype, ITERATOR$2, ArrayValues);
	    } catch (error) {
	      CollectionPrototype[ITERATOR$2] = ArrayValues;
	    }
	    if (!CollectionPrototype[TO_STRING_TAG]) {
	      createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
	    }
	    if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
	      // some Chrome versions have non-configurable methods on DOMTokenList
	      if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
	        createNonEnumerableProperty$1(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
	      } catch (error) {
	        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
	      }
	    }
	  }
	};
	for (var COLLECTION_NAME in DOMIterables) {
	  handlePrototype(global$d[COLLECTION_NAME] && global$d[COLLECTION_NAME].prototype, COLLECTION_NAME);
	}
	handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

	var web_domException_constructor = {};

	var IS_NODE$2 = engineIsNode;
	var tryNodeRequire$1 = function tryNodeRequire(name) {
	  try {
	    // eslint-disable-next-line no-new-func -- safe
	    if (IS_NODE$2) return Function('return require("' + name + '")')();
	  } catch (error) {/* empty */}
	};
	var tryNodeRequire$2 = /*@__PURE__*/getDefaultExportFromCjs(tryNodeRequire$1);

	var domExceptionConstants = {
	  IndexSizeError: {
	    s: 'INDEX_SIZE_ERR',
	    c: 1,
	    m: 1
	  },
	  DOMStringSizeError: {
	    s: 'DOMSTRING_SIZE_ERR',
	    c: 2,
	    m: 0
	  },
	  HierarchyRequestError: {
	    s: 'HIERARCHY_REQUEST_ERR',
	    c: 3,
	    m: 1
	  },
	  WrongDocumentError: {
	    s: 'WRONG_DOCUMENT_ERR',
	    c: 4,
	    m: 1
	  },
	  InvalidCharacterError: {
	    s: 'INVALID_CHARACTER_ERR',
	    c: 5,
	    m: 1
	  },
	  NoDataAllowedError: {
	    s: 'NO_DATA_ALLOWED_ERR',
	    c: 6,
	    m: 0
	  },
	  NoModificationAllowedError: {
	    s: 'NO_MODIFICATION_ALLOWED_ERR',
	    c: 7,
	    m: 1
	  },
	  NotFoundError: {
	    s: 'NOT_FOUND_ERR',
	    c: 8,
	    m: 1
	  },
	  NotSupportedError: {
	    s: 'NOT_SUPPORTED_ERR',
	    c: 9,
	    m: 1
	  },
	  InUseAttributeError: {
	    s: 'INUSE_ATTRIBUTE_ERR',
	    c: 10,
	    m: 1
	  },
	  InvalidStateError: {
	    s: 'INVALID_STATE_ERR',
	    c: 11,
	    m: 1
	  },
	  SyntaxError: {
	    s: 'SYNTAX_ERR',
	    c: 12,
	    m: 1
	  },
	  InvalidModificationError: {
	    s: 'INVALID_MODIFICATION_ERR',
	    c: 13,
	    m: 1
	  },
	  NamespaceError: {
	    s: 'NAMESPACE_ERR',
	    c: 14,
	    m: 1
	  },
	  InvalidAccessError: {
	    s: 'INVALID_ACCESS_ERR',
	    c: 15,
	    m: 1
	  },
	  ValidationError: {
	    s: 'VALIDATION_ERR',
	    c: 16,
	    m: 0
	  },
	  TypeMismatchError: {
	    s: 'TYPE_MISMATCH_ERR',
	    c: 17,
	    m: 1
	  },
	  SecurityError: {
	    s: 'SECURITY_ERR',
	    c: 18,
	    m: 1
	  },
	  NetworkError: {
	    s: 'NETWORK_ERR',
	    c: 19,
	    m: 1
	  },
	  AbortError: {
	    s: 'ABORT_ERR',
	    c: 20,
	    m: 1
	  },
	  URLMismatchError: {
	    s: 'URL_MISMATCH_ERR',
	    c: 21,
	    m: 1
	  },
	  QuotaExceededError: {
	    s: 'QUOTA_EXCEEDED_ERR',
	    c: 22,
	    m: 1
	  },
	  TimeoutError: {
	    s: 'TIMEOUT_ERR',
	    c: 23,
	    m: 1
	  },
	  InvalidNodeTypeError: {
	    s: 'INVALID_NODE_TYPE_ERR',
	    c: 24,
	    m: 1
	  },
	  DataCloneError: {
	    s: 'DATA_CLONE_ERR',
	    c: 25,
	    m: 1
	  }
	};
	var domExceptionConstants$1 = /*@__PURE__*/getDefaultExportFromCjs(domExceptionConstants);

	'use strict';
	var $$b = _export;
	var tryNodeRequire = tryNodeRequire$1;
	var getBuiltIn$2 = getBuiltIn$m;
	var fails$3 = fails$1m;
	var create$1 = objectCreate;
	var createPropertyDescriptor$2 = createPropertyDescriptor$c;
	var defineProperty$2 = objectDefineProperty.f;
	var defineBuiltIn$2 = defineBuiltIn$m;
	var defineBuiltInAccessor$4 = defineBuiltInAccessor$h;
	var hasOwn$4 = hasOwnProperty_1;
	var anInstance$3 = anInstance$a;
	var anObject$2 = anObject$D;
	var errorToString = errorToString$2;
	var normalizeStringArgument$1 = normalizeStringArgument$5;
	var DOMExceptionConstants$1 = domExceptionConstants;
	var clearErrorStack$1 = errorStackClear;
	var InternalStateModule$2 = internalState;
	var DESCRIPTORS$6 = descriptors;
	var IS_PURE$3 = isPure;
	var DOM_EXCEPTION$2 = 'DOMException';
	var DATA_CLONE_ERR = 'DATA_CLONE_ERR';
	var Error$3 = getBuiltIn$2('Error');
	// NodeJS < 17.0 does not expose `DOMException` to global
	var NativeDOMException$1 = getBuiltIn$2(DOM_EXCEPTION$2) || function () {
	  try {
	    // NodeJS < 15.0 does not expose `MessageChannel` to global
	    var MessageChannel = getBuiltIn$2('MessageChannel') || tryNodeRequire('worker_threads').MessageChannel;
	    // eslint-disable-next-line es/no-weak-map, unicorn/require-post-message-target-origin -- safe
	    new MessageChannel().port1.postMessage(new WeakMap());
	  } catch (error) {
	    if (error.name == DATA_CLONE_ERR && error.code == 25) return error.constructor;
	  }
	}();
	var NativeDOMExceptionPrototype = NativeDOMException$1 && NativeDOMException$1.prototype;
	var ErrorPrototype = Error$3.prototype;
	var setInternalState$2 = InternalStateModule$2.set;
	var getInternalState = InternalStateModule$2.getterFor(DOM_EXCEPTION$2);
	var HAS_STACK = ('stack' in Error$3(DOM_EXCEPTION$2));
	var codeFor = function codeFor(name) {
	  return hasOwn$4(DOMExceptionConstants$1, name) && DOMExceptionConstants$1[name].m ? DOMExceptionConstants$1[name].c : 0;
	};
	var $DOMException$1 = function DOMException() {
	  anInstance$3(this, DOMExceptionPrototype$1);
	  var argumentsLength = arguments.length;
	  var message = normalizeStringArgument$1(argumentsLength < 1 ? undefined : arguments[0]);
	  var name = normalizeStringArgument$1(argumentsLength < 2 ? undefined : arguments[1], 'Error');
	  var code = codeFor(name);
	  setInternalState$2(this, {
	    type: DOM_EXCEPTION$2,
	    name: name,
	    message: message,
	    code: code
	  });
	  if (!DESCRIPTORS$6) {
	    this.name = name;
	    this.message = message;
	    this.code = code;
	  }
	  if (HAS_STACK) {
	    var error = Error$3(message);
	    error.name = DOM_EXCEPTION$2;
	    defineProperty$2(this, 'stack', createPropertyDescriptor$2(1, clearErrorStack$1(error.stack, 1)));
	  }
	};
	var DOMExceptionPrototype$1 = $DOMException$1.prototype = create$1(ErrorPrototype);
	var createGetterDescriptor = function createGetterDescriptor(get) {
	  return {
	    enumerable: true,
	    configurable: true,
	    get: get
	  };
	};
	var getterFor = function getterFor(key) {
	  return createGetterDescriptor(function () {
	    return getInternalState(this)[key];
	  });
	};
	if (DESCRIPTORS$6) {
	  // `DOMException.prototype.code` getter
	  defineBuiltInAccessor$4(DOMExceptionPrototype$1, 'code', getterFor('code'));
	  // `DOMException.prototype.message` getter
	  defineBuiltInAccessor$4(DOMExceptionPrototype$1, 'message', getterFor('message'));
	  // `DOMException.prototype.name` getter
	  defineBuiltInAccessor$4(DOMExceptionPrototype$1, 'name', getterFor('name'));
	}
	defineProperty$2(DOMExceptionPrototype$1, 'constructor', createPropertyDescriptor$2(1, $DOMException$1));

	// FF36- DOMException is a function, but can't be constructed
	var INCORRECT_CONSTRUCTOR = fails$3(function () {
	  return !(new NativeDOMException$1() instanceof Error$3);
	});

	// Safari 10.1 / Chrome 32- / IE8- DOMException.prototype.toString bugs
	var INCORRECT_TO_STRING = INCORRECT_CONSTRUCTOR || fails$3(function () {
	  return ErrorPrototype.toString !== errorToString || String(new NativeDOMException$1(1, 2)) !== '2: 1';
	});

	// Deno 1.6.3- DOMException.prototype.code just missed
	var INCORRECT_CODE = INCORRECT_CONSTRUCTOR || fails$3(function () {
	  return new NativeDOMException$1(1, 'DataCloneError').code !== 25;
	});

	// Deno 1.6.3- DOMException constants just missed
	var MISSED_CONSTANTS = INCORRECT_CONSTRUCTOR || NativeDOMException$1[DATA_CLONE_ERR] !== 25 || NativeDOMExceptionPrototype[DATA_CLONE_ERR] !== 25;
	var FORCED_CONSTRUCTOR$1 = IS_PURE$3 ? INCORRECT_TO_STRING || INCORRECT_CODE || MISSED_CONSTANTS : INCORRECT_CONSTRUCTOR;

	// `DOMException` constructor
	// https://webidl.spec.whatwg.org/#idl-DOMException
	$$b({
	  global: true,
	  constructor: true,
	  forced: FORCED_CONSTRUCTOR$1
	}, {
	  DOMException: FORCED_CONSTRUCTOR$1 ? $DOMException$1 : NativeDOMException$1
	});
	var PolyfilledDOMException$1 = getBuiltIn$2(DOM_EXCEPTION$2);
	var PolyfilledDOMExceptionPrototype$1 = PolyfilledDOMException$1.prototype;
	if (INCORRECT_TO_STRING && (IS_PURE$3 || NativeDOMException$1 === PolyfilledDOMException$1)) {
	  defineBuiltIn$2(PolyfilledDOMExceptionPrototype$1, 'toString', errorToString);
	}
	if (INCORRECT_CODE && DESCRIPTORS$6 && NativeDOMException$1 === PolyfilledDOMException$1) {
	  defineBuiltInAccessor$4(PolyfilledDOMExceptionPrototype$1, 'code', createGetterDescriptor(function () {
	    return codeFor(anObject$2(this).name);
	  }));
	}

	// `DOMException` constants
	for (var key$1 in DOMExceptionConstants$1) if (hasOwn$4(DOMExceptionConstants$1, key$1)) {
	  var constant$2 = DOMExceptionConstants$1[key$1];
	  var constantName$1 = constant$2.s;
	  var descriptor$2 = createPropertyDescriptor$2(6, constant$2.c);
	  if (!hasOwn$4(PolyfilledDOMException$1, constantName$1)) {
	    defineProperty$2(PolyfilledDOMException$1, constantName$1, descriptor$2);
	  }
	  if (!hasOwn$4(PolyfilledDOMExceptionPrototype$1, constantName$1)) {
	    defineProperty$2(PolyfilledDOMExceptionPrototype$1, constantName$1, descriptor$2);
	  }
	}

	var web_domException_stack = {};

	'use strict';
	var $$a = _export;
	var global$c = global$Z;
	var getBuiltIn$1 = getBuiltIn$m;
	var createPropertyDescriptor$1 = createPropertyDescriptor$c;
	var defineProperty$1 = objectDefineProperty.f;
	var hasOwn$3 = hasOwnProperty_1;
	var anInstance$2 = anInstance$a;
	var inheritIfRequired = inheritIfRequired$6;
	var normalizeStringArgument = normalizeStringArgument$5;
	var DOMExceptionConstants = domExceptionConstants;
	var clearErrorStack = errorStackClear;
	var DESCRIPTORS$5 = descriptors;
	var IS_PURE$2 = isPure;
	var DOM_EXCEPTION$1 = 'DOMException';
	var Error$2 = getBuiltIn$1('Error');
	var NativeDOMException = getBuiltIn$1(DOM_EXCEPTION$1);
	var $DOMException = function DOMException() {
	  anInstance$2(this, DOMExceptionPrototype);
	  var argumentsLength = arguments.length;
	  var message = normalizeStringArgument(argumentsLength < 1 ? undefined : arguments[0]);
	  var name = normalizeStringArgument(argumentsLength < 2 ? undefined : arguments[1], 'Error');
	  var that = new NativeDOMException(message, name);
	  var error = Error$2(message);
	  error.name = DOM_EXCEPTION$1;
	  defineProperty$1(that, 'stack', createPropertyDescriptor$1(1, clearErrorStack(error.stack, 1)));
	  inheritIfRequired(that, this, $DOMException);
	  return that;
	};
	var DOMExceptionPrototype = $DOMException.prototype = NativeDOMException.prototype;
	var ERROR_HAS_STACK = ('stack' in Error$2(DOM_EXCEPTION$1));
	var DOM_EXCEPTION_HAS_STACK = ('stack' in new NativeDOMException(1, 2));

	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var descriptor$1 = NativeDOMException && DESCRIPTORS$5 && Object.getOwnPropertyDescriptor(global$c, DOM_EXCEPTION$1);

	// Bun ~ 0.1.1 DOMException have incorrect descriptor and we can't redefine it
	// https://github.com/Jarred-Sumner/bun/issues/399
	var BUGGY_DESCRIPTOR = !!descriptor$1 && !(descriptor$1.writable && descriptor$1.configurable);
	var FORCED_CONSTRUCTOR = ERROR_HAS_STACK && !BUGGY_DESCRIPTOR && !DOM_EXCEPTION_HAS_STACK;

	// `DOMException` constructor patch for `.stack` where it's required
	// https://webidl.spec.whatwg.org/#es-DOMException-specialness
	$$a({
	  global: true,
	  constructor: true,
	  forced: IS_PURE$2 || FORCED_CONSTRUCTOR
	}, {
	  // TODO: fix export logic
	  DOMException: FORCED_CONSTRUCTOR ? $DOMException : NativeDOMException
	});
	var PolyfilledDOMException = getBuiltIn$1(DOM_EXCEPTION$1);
	var PolyfilledDOMExceptionPrototype = PolyfilledDOMException.prototype;
	if (PolyfilledDOMExceptionPrototype.constructor !== PolyfilledDOMException) {
	  if (!IS_PURE$2) {
	    defineProperty$1(PolyfilledDOMExceptionPrototype, 'constructor', createPropertyDescriptor$1(1, PolyfilledDOMException));
	  }
	  for (var key in DOMExceptionConstants) if (hasOwn$3(DOMExceptionConstants, key)) {
	    var constant$1 = DOMExceptionConstants[key];
	    var constantName = constant$1.s;
	    if (!hasOwn$3(PolyfilledDOMException, constantName)) {
	      defineProperty$1(PolyfilledDOMException, constantName, createPropertyDescriptor$1(6, constant$1.c));
	    }
	  }
	}

	var web_domException_toStringTag = {};

	var getBuiltIn = getBuiltIn$m;
	var setToStringTag$2 = setToStringTag$d;
	var DOM_EXCEPTION = 'DOMException';

	// `DOMException.prototype[@@toStringTag]` property
	setToStringTag$2(getBuiltIn(DOM_EXCEPTION), DOM_EXCEPTION);

	var web_immediate = {};

	var web_clearImmediate = {};

	var $$9 = _export;
	var global$b = global$Z;
	var clearImmediate = task$1.clear;

	// `clearImmediate` method
	// http://w3c.github.io/setImmediate/#si-clearImmediate
	$$9({
	  global: true,
	  bind: true,
	  enumerable: true,
	  forced: global$b.clearImmediate !== clearImmediate
	}, {
	  clearImmediate: clearImmediate
	});

	var web_setImmediate = {};

	/* global Bun -- Deno case */
	var engineIsBun = typeof Bun == 'function' && Bun && typeof Bun.version == 'string';
	var engineIsBun$1 = /*@__PURE__*/getDefaultExportFromCjs(engineIsBun);

	'use strict';
	var global$a = global$Z;
	var apply = functionApply$1;
	var isCallable$2 = isCallable$z;
	var ENGINE_IS_BUN = engineIsBun;
	var USER_AGENT = engineUserAgent;
	var arraySlice$1 = arraySlice$a;
	var validateArgumentsLength$4 = validateArgumentsLength$8;
	var Function$1 = global$a.Function;
	// dirty IE9- and Bun 0.3.0- checks
	var WRAP = /MSIE .\./.test(USER_AGENT) || ENGINE_IS_BUN && function () {
	  var version = global$a.Bun.version.split('.');
	  return version.length < 3 || version[0] == 0 && (version[1] < 3 || version[1] == 3 && version[2] == 0);
	}();

	// IE9- / Bun 0.3.0- setTimeout / setInterval / setImmediate additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers
	// https://github.com/oven-sh/bun/issues/1633
	var schedulersFix$3 = function schedulersFix(scheduler, hasTimeArg) {
	  var firstParamIndex = hasTimeArg ? 2 : 1;
	  return WRAP ? function (handler, timeout /* , ...arguments */) {
	    var boundArgs = validateArgumentsLength$4(arguments.length, 1) > firstParamIndex;
	    var fn = isCallable$2(handler) ? handler : Function$1(handler);
	    var params = boundArgs ? arraySlice$1(arguments, firstParamIndex) : [];
	    var callback = boundArgs ? function () {
	      apply(fn, this, params);
	    } : fn;
	    return hasTimeArg ? scheduler(callback, timeout) : scheduler(callback);
	  } : scheduler;
	};
	var schedulersFix$4 = /*@__PURE__*/getDefaultExportFromCjs(schedulersFix$3);

	var $$8 = _export;
	var global$9 = global$Z;
	var setTask = task$1.set;
	var schedulersFix$2 = schedulersFix$3;

	// https://github.com/oven-sh/bun/issues/1633
	var setImmediate$1 = global$9.setImmediate ? schedulersFix$2(setTask, false) : setTask;

	// `setImmediate` method
	// http://w3c.github.io/setImmediate/#si-setImmediate
	$$8({
	  global: true,
	  bind: true,
	  enumerable: true,
	  forced: global$9.setImmediate !== setImmediate$1
	}, {
	  setImmediate: setImmediate$1
	});

	var web_queueMicrotask = {};

	var $$7 = _export;
	var global$8 = global$Z;
	var microtask = microtask_1;
	var aCallable = aCallable$l;
	var validateArgumentsLength$3 = validateArgumentsLength$8;
	var IS_NODE$1 = engineIsNode;
	var process$1 = global$8.process;

	// `queueMicrotask` method
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-queuemicrotask
	$$7({
	  global: true,
	  enumerable: true,
	  dontCallGetSet: true
	}, {
	  queueMicrotask: function queueMicrotask(fn) {
	    validateArgumentsLength$3(arguments.length, 1);
	    aCallable(fn);
	    var domain = IS_NODE$1 && process$1.domain;
	    microtask(domain ? domain.bind(fn) : fn);
	  }
	});

	var web_self = {};

	'use strict';
	var $$6 = _export;
	var global$7 = global$Z;
	var defineBuiltInAccessor$3 = defineBuiltInAccessor$h;
	var DESCRIPTORS$4 = descriptors;
	var $TypeError = TypeError;
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var defineProperty = Object.defineProperty;
	var INCORRECT_VALUE = global$7.self !== global$7;

	// `self` getter
	// https://html.spec.whatwg.org/multipage/window-object.html#dom-self
	try {
	  if (DESCRIPTORS$4) {
	    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	    var descriptor = Object.getOwnPropertyDescriptor(global$7, 'self');
	    // some engines have `self`, but with incorrect descriptor
	    // https://github.com/denoland/deno/issues/15765
	    if (INCORRECT_VALUE || !descriptor || !descriptor.get || !descriptor.enumerable) {
	      defineBuiltInAccessor$3(global$7, 'self', {
	        get: function self() {
	          return global$7;
	        },
	        set: function self(value) {
	          if (this !== global$7) throw $TypeError('Illegal invocation');
	          defineProperty(global$7, 'self', {
	            value: value,
	            writable: true,
	            configurable: true,
	            enumerable: true
	          });
	        },
	        configurable: true,
	        enumerable: true
	      });
	    }
	  } else $$6({
	    global: true,
	    simple: true,
	    forced: INCORRECT_VALUE
	  }, {
	    self: global$7
	  });
	} catch (error) {/* empty */}

	var web_structuredClone = {};

	var uncurryThis$6 = functionUncurryThis;

	// eslint-disable-next-line es/no-map -- safe
	var MapPrototype = Map.prototype;
	var mapHelpers = {
	  // eslint-disable-next-line es/no-map -- safe
	  Map: Map,
	  set: uncurryThis$6(MapPrototype.set),
	  get: uncurryThis$6(MapPrototype.get),
	  has: uncurryThis$6(MapPrototype.has),
	  remove: uncurryThis$6(MapPrototype['delete']),
	  proto: MapPrototype
	};
	var mapHelpers$1 = /*@__PURE__*/getDefaultExportFromCjs(mapHelpers);

	var uncurryThis$5 = functionUncurryThis;

	// eslint-disable-next-line es/no-set -- safe
	var SetPrototype = Set.prototype;
	var setHelpers = {
	  // eslint-disable-next-line es/no-set -- safe
	  Set: Set,
	  add: uncurryThis$5(SetPrototype.add),
	  has: uncurryThis$5(SetPrototype.has),
	  remove: uncurryThis$5(SetPrototype['delete']),
	  proto: SetPrototype,
	  $has: SetPrototype.has,
	  $keys: SetPrototype.keys
	};
	var setHelpers$1 = /*@__PURE__*/getDefaultExportFromCjs(setHelpers);

	var global$6 = global$Z;
	var fails$2 = fails$1m;
	var V8 = engineV8Version;
	var IS_BROWSER = engineIsBrowser;
	var IS_DENO = engineIsDeno;
	var IS_NODE = engineIsNode;
	var structuredClone = global$6.structuredClone;
	var structuredCloneProperTransfer = !!structuredClone && !fails$2(function () {
	  // prevent V8 ArrayBufferDetaching protector cell invalidation and performance degradation
	  // https://github.com/zloirock/core-js/issues/679
	  if (IS_DENO && V8 > 92 || IS_NODE && V8 > 94 || IS_BROWSER && V8 > 97) return false;
	  var buffer = new ArrayBuffer(8);
	  var clone = structuredClone(buffer, {
	    transfer: [buffer]
	  });
	  return buffer.byteLength != 0 || clone.byteLength != 8;
	});
	var structuredCloneProperTransfer$1 = /*@__PURE__*/getDefaultExportFromCjs(structuredCloneProperTransfer);

	var IS_PURE$1 = isPure;
	var $$5 = _export;
	var global$5 = global$Z;
	var getBuiltin = getBuiltIn$m;
	var uncurryThis$4 = functionUncurryThis;
	var fails$1 = fails$1m;
	var uid = uid$6;
	var isCallable$1 = isCallable$z;
	var isConstructor = isConstructor$6;
	var isNullOrUndefined = isNullOrUndefined$e;
	var isObject$1 = isObject$z;
	var isSymbol = isSymbol$7;
	var iterate = iterate$a;
	var anObject$1 = anObject$D;
	var classof$1 = classof$m;
	var hasOwn$2 = hasOwnProperty_1;
	var createProperty = createProperty$9;
	var createNonEnumerableProperty = createNonEnumerableProperty$f;
	var lengthOfArrayLike = lengthOfArrayLike$t;
	var validateArgumentsLength$2 = validateArgumentsLength$8;
	var getRegExpFlags = regexpGetFlags;
	var MapHelpers = mapHelpers;
	var SetHelpers = setHelpers;
	var ERROR_STACK_INSTALLABLE = errorStackInstallable;
	var PROPER_TRANSFER = structuredCloneProperTransfer;
	var Object$1 = global$5.Object;
	var Array$1 = global$5.Array;
	var Date$1 = global$5.Date;
	var Error$1 = global$5.Error;
	var EvalError = global$5.EvalError;
	var RangeError$1 = global$5.RangeError;
	var ReferenceError$1 = global$5.ReferenceError;
	var SyntaxError = global$5.SyntaxError;
	var TypeError$3 = global$5.TypeError;
	var URIError = global$5.URIError;
	var PerformanceMark = global$5.PerformanceMark;
	var WebAssembly$1 = global$5.WebAssembly;
	var CompileError = WebAssembly$1 && WebAssembly$1.CompileError || Error$1;
	var LinkError = WebAssembly$1 && WebAssembly$1.LinkError || Error$1;
	var RuntimeError$1 = WebAssembly$1 && WebAssembly$1.RuntimeError || Error$1;
	var DOMException = getBuiltin('DOMException');
	var Map$1 = MapHelpers.Map;
	var mapHas = MapHelpers.has;
	var mapGet = MapHelpers.get;
	var mapSet = MapHelpers.set;
	var Set$1 = SetHelpers.Set;
	var setAdd = SetHelpers.add;
	var objectKeys = getBuiltin('Object', 'keys');
	var push$3 = uncurryThis$4([].push);
	var thisBooleanValue = uncurryThis$4(true.valueOf);
	var thisNumberValue = uncurryThis$4(1.0.valueOf);
	var thisStringValue = uncurryThis$4(''.valueOf);
	var thisTimeValue = uncurryThis$4(Date$1.prototype.getTime);
	var PERFORMANCE_MARK = uid('structuredClone');
	var DATA_CLONE_ERROR = 'DataCloneError';
	var TRANSFERRING = 'Transferring';
	var checkBasicSemantic = function checkBasicSemantic(structuredCloneImplementation) {
	  return !fails$1(function () {
	    var set1 = new global$5.Set([7]);
	    var set2 = structuredCloneImplementation(set1);
	    var number = structuredCloneImplementation(Object$1(7));
	    return set2 == set1 || !set2.has(7) || _typeof(number) != 'object' || number != 7;
	  }) && structuredCloneImplementation;
	};
	var checkErrorsCloning = function checkErrorsCloning(structuredCloneImplementation, $Error) {
	  return !fails$1(function () {
	    var error = new $Error();
	    var test = structuredCloneImplementation({
	      a: error,
	      b: error
	    });
	    return !(test && test.a === test.b && test.a instanceof $Error && test.a.stack === error.stack);
	  });
	};

	// https://github.com/whatwg/html/pull/5749
	var checkNewErrorsCloningSemantic = function checkNewErrorsCloningSemantic(structuredCloneImplementation) {
	  return !fails$1(function () {
	    var test = structuredCloneImplementation(new global$5.AggregateError([1], PERFORMANCE_MARK, {
	      cause: 3
	    }));
	    return test.name != 'AggregateError' || test.errors[0] != 1 || test.message != PERFORMANCE_MARK || test.cause != 3;
	  });
	};

	// FF94+, Safari 15.4+, Chrome 98+, NodeJS 17.0+, Deno 1.13+
	// FF<103 and Safari implementations can't clone errors
	// https://bugzilla.mozilla.org/show_bug.cgi?id=1556604
	// FF103 can clone errors, but `.stack` of clone is an empty string
	// https://bugzilla.mozilla.org/show_bug.cgi?id=1778762
	// FF104+ fixed it on usual errors, but not on DOMExceptions
	// https://bugzilla.mozilla.org/show_bug.cgi?id=1777321
	// Chrome <102 returns `null` if cloned object contains multiple references to one error
	// https://bugs.chromium.org/p/v8/issues/detail?id=12542
	// NodeJS implementation can't clone DOMExceptions
	// https://github.com/nodejs/node/issues/41038
	// only FF103+ supports new (html/5749) error cloning semantic
	var nativeStructuredClone = global$5.structuredClone;
	var FORCED_REPLACEMENT = IS_PURE$1 || !checkErrorsCloning(nativeStructuredClone, Error$1) || !checkErrorsCloning(nativeStructuredClone, DOMException) || !checkNewErrorsCloningSemantic(nativeStructuredClone);

	// Chrome 82+, Safari 14.1+, Deno 1.11+
	// Chrome 78-81 implementation swaps `.name` and `.message` of cloned `DOMException`
	// Chrome returns `null` if cloned object contains multiple references to one error
	// Safari 14.1 implementation doesn't clone some `RegExp` flags, so requires a workaround
	// Safari implementation can't clone errors
	// Deno 1.2-1.10 implementations too naive
	// NodeJS 16.0+ does not have `PerformanceMark` constructor
	// NodeJS <17.2 structured cloning implementation from `performance.mark` is too naive
	// and can't clone, for example, `RegExp` or some boxed primitives
	// https://github.com/nodejs/node/issues/40840
	// no one of those implementations supports new (html/5749) error cloning semantic
	var structuredCloneFromMark = !nativeStructuredClone && checkBasicSemantic(function (value) {
	  return new PerformanceMark(PERFORMANCE_MARK, {
	    detail: value
	  }).detail;
	});
	var nativeRestrictedStructuredClone = checkBasicSemantic(nativeStructuredClone) || structuredCloneFromMark;
	var throwUncloneable = function throwUncloneable(type) {
	  throw new DOMException('Uncloneable type: ' + type, DATA_CLONE_ERROR);
	};
	var throwUnpolyfillable = function throwUnpolyfillable(type, action) {
	  throw new DOMException((action || 'Cloning') + ' of ' + type + ' cannot be properly polyfilled in this engine', DATA_CLONE_ERROR);
	};
	var createDataTransfer = function createDataTransfer() {
	  var dataTransfer;
	  try {
	    dataTransfer = new global$5.DataTransfer();
	  } catch (error) {
	    try {
	      dataTransfer = new global$5.ClipboardEvent('').clipboardData;
	    } catch (error2) {/* empty */}
	  }
	  return dataTransfer && dataTransfer.items && dataTransfer.files ? dataTransfer : null;
	};
	var structuredCloneInternal = function structuredCloneInternal(value, map) {
	  if (isSymbol(value)) throwUncloneable('Symbol');
	  if (!isObject$1(value)) return value;
	  // effectively preserves circular references
	  if (map) {
	    if (mapHas(map, value)) return mapGet(map, value);
	  } else map = new Map$1();
	  var type = classof$1(value);
	  var deep = false;
	  var C, name, cloned, dataTransfer, i, length, keys, key, source, target, options;
	  switch (type) {
	    case 'Array':
	      cloned = Array$1(lengthOfArrayLike(value));
	      deep = true;
	      break;
	    case 'Object':
	      cloned = {};
	      deep = true;
	      break;
	    case 'Map':
	      cloned = new Map$1();
	      deep = true;
	      break;
	    case 'Set':
	      cloned = new Set$1();
	      deep = true;
	      break;
	    case 'RegExp':
	      // in this block because of a Safari 14.1 bug
	      // old FF does not clone regexes passed to the constructor, so get the source and flags directly
	      cloned = new RegExp(value.source, getRegExpFlags(value));
	      break;
	    case 'Error':
	      name = value.name;
	      switch (name) {
	        case 'AggregateError':
	          cloned = getBuiltin('AggregateError')([]);
	          break;
	        case 'EvalError':
	          cloned = EvalError();
	          break;
	        case 'RangeError':
	          cloned = RangeError$1();
	          break;
	        case 'ReferenceError':
	          cloned = ReferenceError$1();
	          break;
	        case 'SyntaxError':
	          cloned = SyntaxError();
	          break;
	        case 'TypeError':
	          cloned = TypeError$3();
	          break;
	        case 'URIError':
	          cloned = URIError();
	          break;
	        case 'CompileError':
	          cloned = CompileError();
	          break;
	        case 'LinkError':
	          cloned = LinkError();
	          break;
	        case 'RuntimeError':
	          cloned = RuntimeError$1();
	          break;
	        default:
	          cloned = Error$1();
	      }
	      deep = true;
	      break;
	    case 'DOMException':
	      cloned = new DOMException(value.message, value.name);
	      deep = true;
	      break;
	    case 'DataView':
	    case 'Int8Array':
	    case 'Uint8Array':
	    case 'Uint8ClampedArray':
	    case 'Int16Array':
	    case 'Uint16Array':
	    case 'Int32Array':
	    case 'Uint32Array':
	    case 'Float32Array':
	    case 'Float64Array':
	    case 'BigInt64Array':
	    case 'BigUint64Array':
	      C = global$5[type];
	      // in some old engines like Safari 9, typeof C is 'object'
	      // on Uint8ClampedArray or some other constructors
	      if (!isObject$1(C)) throwUnpolyfillable(type);
	      cloned = new C(
	      // this is safe, since arraybuffer cannot have circular references
	      structuredCloneInternal(value.buffer, map), value.byteOffset, type === 'DataView' ? value.byteLength : value.length);
	      break;
	    case 'DOMQuad':
	      try {
	        cloned = new DOMQuad(structuredCloneInternal(value.p1, map), structuredCloneInternal(value.p2, map), structuredCloneInternal(value.p3, map), structuredCloneInternal(value.p4, map));
	      } catch (error) {
	        if (nativeRestrictedStructuredClone) {
	          cloned = nativeRestrictedStructuredClone(value);
	        } else throwUnpolyfillable(type);
	      }
	      break;
	    case 'FileList':
	      dataTransfer = createDataTransfer();
	      if (dataTransfer) {
	        for (i = 0, length = lengthOfArrayLike(value); i < length; i++) {
	          dataTransfer.items.add(structuredCloneInternal(value[i], map));
	        }
	        cloned = dataTransfer.files;
	      } else if (nativeRestrictedStructuredClone) {
	        cloned = nativeRestrictedStructuredClone(value);
	      } else throwUnpolyfillable(type);
	      break;
	    case 'ImageData':
	      // Safari 9 ImageData is a constructor, but typeof ImageData is 'object'
	      try {
	        cloned = new ImageData(structuredCloneInternal(value.data, map), value.width, value.height, {
	          colorSpace: value.colorSpace
	        });
	      } catch (error) {
	        if (nativeRestrictedStructuredClone) {
	          cloned = nativeRestrictedStructuredClone(value);
	        } else throwUnpolyfillable(type);
	      }
	      break;
	    default:
	      if (nativeRestrictedStructuredClone) {
	        cloned = nativeRestrictedStructuredClone(value);
	      } else switch (type) {
	        case 'BigInt':
	          // can be a 3rd party polyfill
	          cloned = Object$1(value.valueOf());
	          break;
	        case 'Boolean':
	          cloned = Object$1(thisBooleanValue(value));
	          break;
	        case 'Number':
	          cloned = Object$1(thisNumberValue(value));
	          break;
	        case 'String':
	          cloned = Object$1(thisStringValue(value));
	          break;
	        case 'Date':
	          cloned = new Date$1(thisTimeValue(value));
	          break;
	        case 'ArrayBuffer':
	          C = global$5.DataView;
	          // `ArrayBuffer#slice` is not available in IE10
	          // `ArrayBuffer#slice` and `DataView` are not available in old FF
	          if (!C && typeof value.slice != 'function') throwUnpolyfillable(type);
	          // detached buffers throws in `DataView` and `.slice`
	          try {
	            if (typeof value.slice == 'function' && !value.resizable) {
	              cloned = value.slice(0);
	            } else {
	              length = value.byteLength;
	              options = 'maxByteLength' in value ? {
	                maxByteLength: value.maxByteLength
	              } : undefined;
	              cloned = new ArrayBuffer(length, options);
	              source = new C(value);
	              target = new C(cloned);
	              for (i = 0; i < length; i++) {
	                target.setUint8(i, source.getUint8(i));
	              }
	            }
	          } catch (error) {
	            throw new DOMException('ArrayBuffer is detached', DATA_CLONE_ERROR);
	          }
	          break;
	        case 'SharedArrayBuffer':
	          // SharedArrayBuffer should use shared memory, we can't polyfill it, so return the original
	          cloned = value;
	          break;
	        case 'Blob':
	          try {
	            cloned = value.slice(0, value.size, value.type);
	          } catch (error) {
	            throwUnpolyfillable(type);
	          }
	          break;
	        case 'DOMPoint':
	        case 'DOMPointReadOnly':
	          C = global$5[type];
	          try {
	            cloned = C.fromPoint ? C.fromPoint(value) : new C(value.x, value.y, value.z, value.w);
	          } catch (error) {
	            throwUnpolyfillable(type);
	          }
	          break;
	        case 'DOMRect':
	        case 'DOMRectReadOnly':
	          C = global$5[type];
	          try {
	            cloned = C.fromRect ? C.fromRect(value) : new C(value.x, value.y, value.width, value.height);
	          } catch (error) {
	            throwUnpolyfillable(type);
	          }
	          break;
	        case 'DOMMatrix':
	        case 'DOMMatrixReadOnly':
	          C = global$5[type];
	          try {
	            cloned = C.fromMatrix ? C.fromMatrix(value) : new C(value);
	          } catch (error) {
	            throwUnpolyfillable(type);
	          }
	          break;
	        case 'AudioData':
	        case 'VideoFrame':
	          if (!isCallable$1(value.clone)) throwUnpolyfillable(type);
	          try {
	            cloned = value.clone();
	          } catch (error) {
	            throwUncloneable(type);
	          }
	          break;
	        case 'File':
	          try {
	            cloned = new File([value], value.name, value);
	          } catch (error) {
	            throwUnpolyfillable(type);
	          }
	          break;
	        case 'CropTarget':
	        case 'CryptoKey':
	        case 'FileSystemDirectoryHandle':
	        case 'FileSystemFileHandle':
	        case 'FileSystemHandle':
	        case 'GPUCompilationInfo':
	        case 'GPUCompilationMessage':
	        case 'ImageBitmap':
	        case 'RTCCertificate':
	        case 'WebAssembly.Module':
	          throwUnpolyfillable(type);
	        // break omitted
	        default:
	          throwUncloneable(type);
	      }
	  }
	  mapSet(map, value, cloned);
	  if (deep) switch (type) {
	    case 'Array':
	    case 'Object':
	      keys = objectKeys(value);
	      for (i = 0, length = lengthOfArrayLike(keys); i < length; i++) {
	        key = keys[i];
	        createProperty(cloned, key, structuredCloneInternal(value[key], map));
	      }
	      break;
	    case 'Map':
	      value.forEach(function (v, k) {
	        mapSet(cloned, structuredCloneInternal(k, map), structuredCloneInternal(v, map));
	      });
	      break;
	    case 'Set':
	      value.forEach(function (v) {
	        setAdd(cloned, structuredCloneInternal(v, map));
	      });
	      break;
	    case 'Error':
	      createNonEnumerableProperty(cloned, 'message', structuredCloneInternal(value.message, map));
	      if (hasOwn$2(value, 'cause')) {
	        createNonEnumerableProperty(cloned, 'cause', structuredCloneInternal(value.cause, map));
	      }
	      if (name == 'AggregateError') {
	        cloned.errors = structuredCloneInternal(value.errors, map);
	      }
	    // break omitted
	    case 'DOMException':
	      if (ERROR_STACK_INSTALLABLE) {
	        createNonEnumerableProperty(cloned, 'stack', structuredCloneInternal(value.stack, map));
	      }
	  }
	  return cloned;
	};
	var tryToTransfer = function tryToTransfer(rawTransfer, map) {
	  if (!isObject$1(rawTransfer)) throw TypeError$3('Transfer option cannot be converted to a sequence');
	  var transfer = [];
	  iterate(rawTransfer, function (value) {
	    push$3(transfer, anObject$1(value));
	  });
	  var i = 0;
	  var length = lengthOfArrayLike(transfer);
	  var value, type, C, transferredArray, transferred, canvas, context;
	  if (PROPER_TRANSFER) {
	    transferredArray = nativeStructuredClone(transfer, {
	      transfer: transfer
	    });
	    while (i < length) mapSet(map, transfer[i], transferredArray[i++]);
	  } else while (i < length) {
	    value = transfer[i++];
	    if (mapHas(map, value)) throw new DOMException('Duplicate transferable', DATA_CLONE_ERROR);
	    type = classof$1(value);
	    switch (type) {
	      case 'ImageBitmap':
	        C = global$5.OffscreenCanvas;
	        if (!isConstructor(C)) throwUnpolyfillable(type, TRANSFERRING);
	        try {
	          canvas = new C(value.width, value.height);
	          context = canvas.getContext('bitmaprenderer');
	          context.transferFromImageBitmap(value);
	          transferred = canvas.transferToImageBitmap();
	        } catch (error) {/* empty */}
	        break;
	      case 'AudioData':
	      case 'VideoFrame':
	        if (!isCallable$1(value.clone) || !isCallable$1(value.close)) throwUnpolyfillable(type, TRANSFERRING);
	        try {
	          transferred = value.clone();
	          value.close();
	        } catch (error) {/* empty */}
	        break;
	      case 'ArrayBuffer':
	        if (!isCallable$1(value.transfer)) throwUnpolyfillable(type, TRANSFERRING);
	        transferred = value.transfer();
	        break;
	      case 'MediaSourceHandle':
	      case 'MessagePort':
	      case 'OffscreenCanvas':
	      case 'ReadableStream':
	      case 'TransformStream':
	      case 'WritableStream':
	        throwUnpolyfillable(type, TRANSFERRING);
	    }
	    if (transferred === undefined) throw new DOMException('This object cannot be transferred: ' + type, DATA_CLONE_ERROR);
	    mapSet(map, value, transferred);
	  }
	};

	// `structuredClone` method
	// https://html.spec.whatwg.org/multipage/structured-data.html#dom-structuredclone
	$$5({
	  global: true,
	  enumerable: true,
	  sham: !PROPER_TRANSFER,
	  forced: FORCED_REPLACEMENT
	}, {
	  structuredClone: function structuredClone(value /* , { transfer } */) {
	    var options = validateArgumentsLength$2(arguments.length, 1) > 1 && !isNullOrUndefined(arguments[1]) ? anObject$1(arguments[1]) : undefined;
	    var transfer = options ? options.transfer : undefined;
	    var map;
	    if (transfer !== undefined) {
	      map = new Map$1();
	      tryToTransfer(transfer, map);
	    }
	    return structuredCloneInternal(value, map);
	  }
	});

	var web_timers = {};

	var web_setInterval = {};

	var $$4 = _export;
	var global$4 = global$Z;
	var schedulersFix$1 = schedulersFix$3;
	var setInterval$1 = schedulersFix$1(global$4.setInterval, true);

	// Bun / IE9- setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	$$4({
	  global: true,
	  bind: true,
	  forced: global$4.setInterval !== setInterval$1
	}, {
	  setInterval: setInterval$1
	});

	var web_setTimeout = {};

	var $$3 = _export;
	var global$3 = global$Z;
	var schedulersFix = schedulersFix$3;
	var setTimeout$1 = schedulersFix(global$3.setTimeout, true);

	// Bun / IE9- setTimeout additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	$$3({
	  global: true,
	  bind: true,
	  forced: global$3.setTimeout !== setTimeout$1
	}, {
	  setTimeout: setTimeout$1
	});

	var web_url = {};

	var web_url_constructor = {};

	var fails = fails$1m;
	var wellKnownSymbol$1 = wellKnownSymbol$z;
	var DESCRIPTORS$3 = descriptors;
	var IS_PURE = isPure;
	var ITERATOR$1 = wellKnownSymbol$1('iterator');
	var urlConstructorDetection = !fails(function () {
	  // eslint-disable-next-line unicorn/relative-url-style -- required for testing
	  var url = new URL('b?a=1&b=2&c=3', 'http://a');
	  var searchParams = url.searchParams;
	  var result = '';
	  url.pathname = 'c%20d';
	  searchParams.forEach(function (value, key) {
	    searchParams['delete']('b');
	    result += key + value;
	  });
	  return IS_PURE && !url.toJSON || !searchParams.size && (IS_PURE || !DESCRIPTORS$3) || !searchParams.sort || url.href !== 'http://a/c%20d?a=1&c=3' || searchParams.get('c') !== '3' || String(new URLSearchParams('?a=1')) !== 'a=1' || !searchParams[ITERATOR$1]
	  // throws in Edge
	  || new URL('https://a@b').username !== 'a' || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b'
	  // not punycoded in Edge
	  || new URL('http://тест').host !== 'xn--e1aybc'
	  // not escaped in Chrome 62-
	  || new URL('http://a#б').hash !== '#%D0%B1'
	  // fails in Chrome 66-
	  || result !== 'a1c3'
	  // throws in Safari
	  || new URL('http://x', undefined).host !== 'x';
	});
	var urlConstructorDetection$1 = /*@__PURE__*/getDefaultExportFromCjs(urlConstructorDetection);

	// based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js
	var uncurryThis$3 = functionUncurryThis;
	var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1
	var base = 36;
	var tMin = 1;
	var tMax = 26;
	var skew = 38;
	var damp = 700;
	var initialBias = 72;
	var initialN = 128; // 0x80
	var delimiter = '-'; // '\x2D'
	var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars
	var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators
	var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
	var baseMinusTMin = base - tMin;
	var $RangeError = RangeError;
	var exec$1 = uncurryThis$3(regexSeparators.exec);
	var floor$4 = Math.floor;
	var fromCharCode = String.fromCharCode;
	var charCodeAt = uncurryThis$3(''.charCodeAt);
	var join$2 = uncurryThis$3([].join);
	var push$2 = uncurryThis$3([].push);
	var replace$2 = uncurryThis$3(''.replace);
	var split$6 = uncurryThis$3(''.split);
	var toLowerCase$1 = uncurryThis$3(''.toLowerCase);

	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 */
	var ucs2decode = function ucs2decode(string) {
	  var output = [];
	  var counter = 0;
	  var length = string.length;
	  while (counter < length) {
	    var value = charCodeAt(string, counter++);
	    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
	      // It's a high surrogate, and there is a next character.
	      var extra = charCodeAt(string, counter++);
	      if ((extra & 0xFC00) == 0xDC00) {
	        // Low surrogate.
	        push$2(output, ((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
	      } else {
	        // It's an unmatched surrogate; only append this code unit, in case the
	        // next code unit is the high surrogate of a surrogate pair.
	        push$2(output, value);
	        counter--;
	      }
	    } else {
	      push$2(output, value);
	    }
	  }
	  return output;
	};

	/**
	 * Converts a digit/integer into a basic code point.
	 */
	var digitToBasic = function digitToBasic(digit) {
	  //  0..25 map to ASCII a..z or A..Z
	  // 26..35 map to ASCII 0..9
	  return digit + 22 + 75 * (digit < 26);
	};

	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * https://tools.ietf.org/html/rfc3492#section-3.4
	 */
	var adapt = function adapt(delta, numPoints, firstTime) {
	  var k = 0;
	  delta = firstTime ? floor$4(delta / damp) : delta >> 1;
	  delta += floor$4(delta / numPoints);
	  while (delta > baseMinusTMin * tMax >> 1) {
	    delta = floor$4(delta / baseMinusTMin);
	    k += base;
	  }
	  return floor$4(k + (baseMinusTMin + 1) * delta / (delta + skew));
	};

	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 */
	var encode = function encode(input) {
	  var output = [];

	  // Convert the input in UCS-2 to an array of Unicode code points.
	  input = ucs2decode(input);

	  // Cache the length.
	  var inputLength = input.length;

	  // Initialize the state.
	  var n = initialN;
	  var delta = 0;
	  var bias = initialBias;
	  var i, currentValue;

	  // Handle the basic code points.
	  for (i = 0; i < input.length; i++) {
	    currentValue = input[i];
	    if (currentValue < 0x80) {
	      push$2(output, fromCharCode(currentValue));
	    }
	  }
	  var basicLength = output.length; // number of basic code points.
	  var handledCPCount = basicLength; // number of code points that have been handled;

	  // Finish the basic string with a delimiter unless it's empty.
	  if (basicLength) {
	    push$2(output, delimiter);
	  }

	  // Main encoding loop:
	  while (handledCPCount < inputLength) {
	    // All non-basic code points < n have been handled already. Find the next larger one:
	    var m = maxInt;
	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];
	      if (currentValue >= n && currentValue < m) {
	        m = currentValue;
	      }
	    }

	    // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.
	    var handledCPCountPlusOne = handledCPCount + 1;
	    if (m - n > floor$4((maxInt - delta) / handledCPCountPlusOne)) {
	      throw $RangeError(OVERFLOW_ERROR);
	    }
	    delta += (m - n) * handledCPCountPlusOne;
	    n = m;
	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];
	      if (currentValue < n && ++delta > maxInt) {
	        throw $RangeError(OVERFLOW_ERROR);
	      }
	      if (currentValue == n) {
	        // Represent delta as a generalized variable-length integer.
	        var q = delta;
	        var k = base;
	        while (true) {
	          var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
	          if (q < t) break;
	          var qMinusT = q - t;
	          var baseMinusT = base - t;
	          push$2(output, fromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
	          q = floor$4(qMinusT / baseMinusT);
	          k += base;
	        }
	        push$2(output, fromCharCode(digitToBasic(q)));
	        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
	        delta = 0;
	        handledCPCount++;
	      }
	    }
	    delta++;
	    n++;
	  }
	  return join$2(output, '');
	};
	var stringPunycodeToAscii = function stringPunycodeToAscii(input) {
	  var encoded = [];
	  var labels = split$6(replace$2(toLowerCase$1(input), regexSeparators, "."), '.');
	  var i, label;
	  for (i = 0; i < labels.length; i++) {
	    label = labels[i];
	    push$2(encoded, exec$1(regexNonASCII, label) ? 'xn--' + encode(label) : label);
	  }
	  return join$2(encoded, '.');
	};
	var stringPunycodeToAscii$1 = /*@__PURE__*/getDefaultExportFromCjs(stringPunycodeToAscii);

	'use strict';
	// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`

	var $$2 = _export;
	var global$2 = global$Z;
	var call$1 = functionCall;
	var uncurryThis$2 = functionUncurryThis;
	var DESCRIPTORS$2 = descriptors;
	var USE_NATIVE_URL$1 = urlConstructorDetection;
	var defineBuiltIn$1 = defineBuiltIn$m;
	var defineBuiltInAccessor$2 = defineBuiltInAccessor$h;
	var defineBuiltIns = defineBuiltIns$5;
	var setToStringTag$1 = setToStringTag$d;
	var createIteratorConstructor = iteratorCreateConstructor;
	var InternalStateModule$1 = internalState;
	var anInstance$1 = anInstance$a;
	var isCallable = isCallable$z;
	var hasOwn$1 = hasOwnProperty_1;
	var bind$1 = functionBindContext;
	var classof = classof$m;
	var anObject = anObject$D;
	var isObject = isObject$z;
	var $toString$1 = toString$x;
	var create = objectCreate;
	var createPropertyDescriptor = createPropertyDescriptor$c;
	var getIterator = getIterator$4;
	var getIteratorMethod = getIteratorMethod$5;
	var validateArgumentsLength$1 = validateArgumentsLength$8;
	var wellKnownSymbol = wellKnownSymbol$z;
	var arraySort = arraySort$1;
	var ITERATOR = wellKnownSymbol('iterator');
	var URL_SEARCH_PARAMS = 'URLSearchParams';
	var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
	var setInternalState$1 = InternalStateModule$1.set;
	var getInternalParamsState = InternalStateModule$1.getterFor(URL_SEARCH_PARAMS);
	var getInternalIteratorState = InternalStateModule$1.getterFor(URL_SEARCH_PARAMS_ITERATOR);
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

	// Avoid NodeJS experimental warning
	var safeGetBuiltIn = function safeGetBuiltIn(name) {
	  if (!DESCRIPTORS$2) return global$2[name];
	  var descriptor = getOwnPropertyDescriptor(global$2, name);
	  return descriptor && descriptor.value;
	};
	var nativeFetch = safeGetBuiltIn('fetch');
	var NativeRequest = safeGetBuiltIn('Request');
	var Headers = safeGetBuiltIn('Headers');
	var RequestPrototype = NativeRequest && NativeRequest.prototype;
	var HeadersPrototype = Headers && Headers.prototype;
	var RegExp$1 = global$2.RegExp;
	var TypeError$2 = global$2.TypeError;
	var decodeURIComponent$1 = global$2.decodeURIComponent;
	var encodeURIComponent$1 = global$2.encodeURIComponent;
	var charAt$1 = uncurryThis$2(''.charAt);
	var join$1 = uncurryThis$2([].join);
	var push$1 = uncurryThis$2([].push);
	var replace$1 = uncurryThis$2(''.replace);
	var shift$1 = uncurryThis$2([].shift);
	var splice = uncurryThis$2([].splice);
	var split$5 = uncurryThis$2(''.split);
	var stringSlice$1 = uncurryThis$2(''.slice);
	var plus = /\+/g;
	var sequences = Array(4);
	var percentSequence = function percentSequence(bytes) {
	  return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp$1('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
	};
	var percentDecode = function percentDecode(sequence) {
	  try {
	    return decodeURIComponent$1(sequence);
	  } catch (error) {
	    return sequence;
	  }
	};
	var deserialize$1 = function deserialize(it) {
	  var result = replace$1(it, plus, ' ');
	  var bytes = 4;
	  try {
	    return decodeURIComponent$1(result);
	  } catch (error) {
	    while (bytes) {
	      result = replace$1(result, percentSequence(bytes--), percentDecode);
	    }
	    return result;
	  }
	};
	var find = /[!'()~]|%20/g;
	var replacements = {
	  '!': '%21',
	  "'": '%27',
	  '(': '%28',
	  ')': '%29',
	  '~': '%7E',
	  '%20': '+'
	};
	var replacer = function replacer(match) {
	  return replacements[match];
	};
	var _serialize = function serialize(it) {
	  return replace$1(encodeURIComponent$1(it), find, replacer);
	};
	var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
	  setInternalState$1(this, {
	    type: URL_SEARCH_PARAMS_ITERATOR,
	    iterator: getIterator(getInternalParamsState(params).entries),
	    kind: kind
	  });
	}, 'Iterator', function next() {
	  var state = getInternalIteratorState(this);
	  var kind = state.kind;
	  var step = state.iterator.next();
	  var entry = step.value;
	  if (!step.done) {
	    step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [entry.key, entry.value];
	  }
	  return step;
	}, true);
	var URLSearchParamsState = function URLSearchParamsState(init) {
	  this.entries = [];
	  this.url = null;
	  if (init !== undefined) {
	    if (isObject(init)) this.parseObject(init);else this.parseQuery(typeof init == 'string' ? charAt$1(init, 0) === '?' ? stringSlice$1(init, 1) : init : $toString$1(init));
	  }
	};
	URLSearchParamsState.prototype = {
	  type: URL_SEARCH_PARAMS,
	  bindURL: function bindURL(url) {
	    this.url = url;
	    this.update();
	  },
	  parseObject: function parseObject(object) {
	    var iteratorMethod = getIteratorMethod(object);
	    var iterator, next, step, entryIterator, entryNext, first, second;
	    if (iteratorMethod) {
	      iterator = getIterator(object, iteratorMethod);
	      next = iterator.next;
	      while (!(step = call$1(next, iterator)).done) {
	        entryIterator = getIterator(anObject(step.value));
	        entryNext = entryIterator.next;
	        if ((first = call$1(entryNext, entryIterator)).done || (second = call$1(entryNext, entryIterator)).done || !call$1(entryNext, entryIterator).done) throw TypeError$2('Expected sequence with length 2');
	        push$1(this.entries, {
	          key: $toString$1(first.value),
	          value: $toString$1(second.value)
	        });
	      }
	    } else for (var key in object) if (hasOwn$1(object, key)) {
	      push$1(this.entries, {
	        key: key,
	        value: $toString$1(object[key])
	      });
	    }
	  },
	  parseQuery: function parseQuery(query) {
	    if (query) {
	      var attributes = split$5(query, '&');
	      var index = 0;
	      var attribute, entry;
	      while (index < attributes.length) {
	        attribute = attributes[index++];
	        if (attribute.length) {
	          entry = split$5(attribute, '=');
	          push$1(this.entries, {
	            key: deserialize$1(shift$1(entry)),
	            value: deserialize$1(join$1(entry, '='))
	          });
	        }
	      }
	    }
	  },
	  serialize: function serialize() {
	    var entries = this.entries;
	    var result = [];
	    var index = 0;
	    var entry;
	    while (index < entries.length) {
	      entry = entries[index++];
	      push$1(result, _serialize(entry.key) + '=' + _serialize(entry.value));
	    }
	    return join$1(result, '&');
	  },
	  update: function update() {
	    this.entries.length = 0;
	    this.parseQuery(this.url.query);
	  },
	  updateURL: function updateURL() {
	    if (this.url) this.url.update();
	  }
	};

	// `URLSearchParams` constructor
	// https://url.spec.whatwg.org/#interface-urlsearchparams
	var URLSearchParamsConstructor = function URLSearchParams( /* init */
	) {
	  anInstance$1(this, URLSearchParamsPrototype$1);
	  var init = arguments.length > 0 ? arguments[0] : undefined;
	  var state = setInternalState$1(this, new URLSearchParamsState(init));
	  if (!DESCRIPTORS$2) this.length = state.entries.length;
	};
	var URLSearchParamsPrototype$1 = URLSearchParamsConstructor.prototype;
	defineBuiltIns(URLSearchParamsPrototype$1, {
	  // `URLSearchParams.prototype.append` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-append
	  append: function append(name, value) {
	    validateArgumentsLength$1(arguments.length, 2);
	    var state = getInternalParamsState(this);
	    push$1(state.entries, {
	      key: $toString$1(name),
	      value: $toString$1(value)
	    });
	    if (!DESCRIPTORS$2) this.length++;
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.delete` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
	  'delete': function _delete(name) {
	    validateArgumentsLength$1(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var key = $toString$1(name);
	    var index = 0;
	    while (index < entries.length) {
	      if (entries[index].key === key) splice(entries, index, 1);else index++;
	    }
	    if (!DESCRIPTORS$2) this.length = entries.length;
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.get` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-get
	  get: function get(name) {
	    validateArgumentsLength$1(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = $toString$1(name);
	    var index = 0;
	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) return entries[index].value;
	    }
	    return null;
	  },
	  // `URLSearchParams.prototype.getAll` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
	  getAll: function getAll(name) {
	    validateArgumentsLength$1(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = $toString$1(name);
	    var result = [];
	    var index = 0;
	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) push$1(result, entries[index].value);
	    }
	    return result;
	  },
	  // `URLSearchParams.prototype.has` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-has
	  has: function has(name) {
	    validateArgumentsLength$1(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = $toString$1(name);
	    var index = 0;
	    while (index < entries.length) {
	      if (entries[index++].key === key) return true;
	    }
	    return false;
	  },
	  // `URLSearchParams.prototype.set` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-set
	  set: function set(name, value) {
	    validateArgumentsLength$1(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var found = false;
	    var key = $toString$1(name);
	    var val = $toString$1(value);
	    var index = 0;
	    var entry;
	    for (; index < entries.length; index++) {
	      entry = entries[index];
	      if (entry.key === key) {
	        if (found) splice(entries, index--, 1);else {
	          found = true;
	          entry.value = val;
	        }
	      }
	    }
	    if (!found) push$1(entries, {
	      key: key,
	      value: val
	    });
	    if (!DESCRIPTORS$2) this.length = entries.length;
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.sort` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-sort
	  sort: function sort() {
	    var state = getInternalParamsState(this);
	    arraySort(state.entries, function (a, b) {
	      return a.key > b.key ? 1 : -1;
	    });
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.forEach` method
	  forEach: function forEach(callback /* , thisArg */) {
	    var entries = getInternalParamsState(this).entries;
	    var boundFunction = bind$1(callback, arguments.length > 1 ? arguments[1] : undefined);
	    var index = 0;
	    var entry;
	    while (index < entries.length) {
	      entry = entries[index++];
	      boundFunction(entry.value, entry.key, this);
	    }
	  },
	  // `URLSearchParams.prototype.keys` method
	  keys: function keys() {
	    return new URLSearchParamsIterator(this, 'keys');
	  },
	  // `URLSearchParams.prototype.values` method
	  values: function values() {
	    return new URLSearchParamsIterator(this, 'values');
	  },
	  // `URLSearchParams.prototype.entries` method
	  entries: function entries() {
	    return new URLSearchParamsIterator(this, 'entries');
	  }
	}, {
	  enumerable: true
	});

	// `URLSearchParams.prototype[@@iterator]` method
	defineBuiltIn$1(URLSearchParamsPrototype$1, ITERATOR, URLSearchParamsPrototype$1.entries, {
	  name: 'entries'
	});

	// `URLSearchParams.prototype.toString` method
	// https://url.spec.whatwg.org/#urlsearchparams-stringification-behavior
	defineBuiltIn$1(URLSearchParamsPrototype$1, 'toString', function toString() {
	  return getInternalParamsState(this).serialize();
	}, {
	  enumerable: true
	});

	// `URLSearchParams.prototype.size` getter
	// https://github.com/whatwg/url/pull/734
	if (DESCRIPTORS$2) defineBuiltInAccessor$2(URLSearchParamsPrototype$1, 'size', {
	  get: function size() {
	    return getInternalParamsState(this).entries.length;
	  },
	  configurable: true,
	  enumerable: true
	});
	setToStringTag$1(URLSearchParamsConstructor, URL_SEARCH_PARAMS);
	$$2({
	  global: true,
	  constructor: true,
	  forced: !USE_NATIVE_URL$1
	}, {
	  URLSearchParams: URLSearchParamsConstructor
	});

	// Wrap `fetch` and `Request` for correct work with polyfilled `URLSearchParams`
	if (!USE_NATIVE_URL$1 && isCallable(Headers)) {
	  var headersHas = uncurryThis$2(HeadersPrototype.has);
	  var headersSet = uncurryThis$2(HeadersPrototype.set);
	  var wrapRequestOptions = function wrapRequestOptions(init) {
	    if (isObject(init)) {
	      var body = init.body;
	      var headers;
	      if (classof(body) === URL_SEARCH_PARAMS) {
	        headers = init.headers ? new Headers(init.headers) : new Headers();
	        if (!headersHas(headers, 'content-type')) {
	          headersSet(headers, 'content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
	        }
	        return create(init, {
	          body: createPropertyDescriptor(0, $toString$1(body)),
	          headers: createPropertyDescriptor(0, headers)
	        });
	      }
	    }
	    return init;
	  };
	  if (isCallable(nativeFetch)) {
	    $$2({
	      global: true,
	      enumerable: true,
	      dontCallGetSet: true,
	      forced: true
	    }, {
	      fetch: function fetch(input /* , init */) {
	        return nativeFetch(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
	      }
	    });
	  }
	  if (isCallable(NativeRequest)) {
	    var RequestConstructor = function Request(input /* , init */) {
	      anInstance$1(this, RequestPrototype);
	      return new NativeRequest(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
	    };
	    RequestPrototype.constructor = RequestConstructor;
	    RequestConstructor.prototype = RequestPrototype;
	    $$2({
	      global: true,
	      constructor: true,
	      dontCallGetSet: true,
	      forced: true
	    }, {
	      Request: RequestConstructor
	    });
	  }
	}
	var web_urlSearchParams_constructor = {
	  URLSearchParams: URLSearchParamsConstructor,
	  getState: getInternalParamsState
	};
	var web_urlSearchParams_constructor$1 = /*@__PURE__*/getDefaultExportFromCjs(web_urlSearchParams_constructor);

	'use strict';
	// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`

	var $$1 = _export;
	var DESCRIPTORS$1 = descriptors;
	var USE_NATIVE_URL = urlConstructorDetection;
	var global$1 = global$Z;
	var bind = functionBindContext;
	var uncurryThis$1 = functionUncurryThis;
	var defineBuiltIn = defineBuiltIn$m;
	var defineBuiltInAccessor$1 = defineBuiltInAccessor$h;
	var anInstance = anInstance$a;
	var hasOwn = hasOwnProperty_1;
	var assign = objectAssign;
	var arrayFrom = arrayFrom$1;
	var arraySlice = arraySliceSimple;
	var codeAt = stringMultibyte.codeAt;
	var toASCII = stringPunycodeToAscii;
	var $toString = toString$x;
	var setToStringTag = setToStringTag$d;
	var validateArgumentsLength = validateArgumentsLength$8;
	var URLSearchParamsModule = web_urlSearchParams_constructor;
	var InternalStateModule = internalState;
	var setInternalState = InternalStateModule.set;
	var getInternalURLState = InternalStateModule.getterFor('URL');
	var URLSearchParams$1 = URLSearchParamsModule.URLSearchParams;
	var getInternalSearchParamsState = URLSearchParamsModule.getState;
	var NativeURL = global$1.URL;
	var TypeError$1 = global$1.TypeError;
	var parseInt$1 = global$1.parseInt;
	var floor$3 = Math.floor;
	var pow$4 = Math.pow;
	var charAt = uncurryThis$1(''.charAt);
	var exec = uncurryThis$1(/./.exec);
	var join = uncurryThis$1([].join);
	var numberToString = uncurryThis$1(1.0.toString);
	var pop = uncurryThis$1([].pop);
	var push = uncurryThis$1([].push);
	var replace = uncurryThis$1(''.replace);
	var shift = uncurryThis$1([].shift);
	var split$4 = uncurryThis$1(''.split);
	var stringSlice = uncurryThis$1(''.slice);
	var toLowerCase = uncurryThis$1(''.toLowerCase);
	var unshift = uncurryThis$1([].unshift);
	var INVALID_AUTHORITY = 'Invalid authority';
	var INVALID_SCHEME = 'Invalid scheme';
	var INVALID_HOST = 'Invalid host';
	var INVALID_PORT = 'Invalid port';
	var ALPHA = /[a-z]/i;
	// eslint-disable-next-line regexp/no-obscure-range -- safe
	var ALPHANUMERIC = /[\d+-.a-z]/i;
	var DIGIT = /\d/;
	var HEX_START = /^0x/i;
	var OCT = /^[0-7]+$/;
	var DEC = /^\d+$/;
	var HEX = /^[\da-f]+$/i;
	/* eslint-disable regexp/no-control-character -- safe */
	var FORBIDDEN_HOST_CODE_POINT = /[\0\t\n\r #%/:<>?@[\\\]^|]/;
	var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\0\t\n\r #/:<>?@[\\\]^|]/;
	var LEADING_C0_CONTROL_OR_SPACE = /^[\u0000-\u0020]+/;
	var TRAILING_C0_CONTROL_OR_SPACE = /(^|[^\u0000-\u0020])[\u0000-\u0020]+$/;
	var TAB_AND_NEW_LINE = /[\t\n\r]/g;
	/* eslint-enable regexp/no-control-character -- safe */
	var EOF;

	// https://url.spec.whatwg.org/#ipv4-number-parser
	var parseIPv4 = function parseIPv4(input) {
	  var parts = split$4(input, '.');
	  var partsLength, numbers, index, part, radix, number, ipv4;
	  if (parts.length && parts[parts.length - 1] == '') {
	    parts.length--;
	  }
	  partsLength = parts.length;
	  if (partsLength > 4) return input;
	  numbers = [];
	  for (index = 0; index < partsLength; index++) {
	    part = parts[index];
	    if (part == '') return input;
	    radix = 10;
	    if (part.length > 1 && charAt(part, 0) == '0') {
	      radix = exec(HEX_START, part) ? 16 : 8;
	      part = stringSlice(part, radix == 8 ? 1 : 2);
	    }
	    if (part === '') {
	      number = 0;
	    } else {
	      if (!exec(radix == 10 ? DEC : radix == 8 ? OCT : HEX, part)) return input;
	      number = parseInt$1(part, radix);
	    }
	    push(numbers, number);
	  }
	  for (index = 0; index < partsLength; index++) {
	    number = numbers[index];
	    if (index == partsLength - 1) {
	      if (number >= pow$4(256, 5 - partsLength)) return null;
	    } else if (number > 255) return null;
	  }
	  ipv4 = pop(numbers);
	  for (index = 0; index < numbers.length; index++) {
	    ipv4 += numbers[index] * pow$4(256, 3 - index);
	  }
	  return ipv4;
	};

	// https://url.spec.whatwg.org/#concept-ipv6-parser
	// eslint-disable-next-line max-statements -- TODO
	var parseIPv6 = function parseIPv6(input) {
	  var address = [0, 0, 0, 0, 0, 0, 0, 0];
	  var pieceIndex = 0;
	  var compress = null;
	  var pointer = 0;
	  var value, length, numbersSeen, ipv4Piece, number, swaps, swap;
	  var chr = function chr() {
	    return charAt(input, pointer);
	  };
	  if (chr() == ':') {
	    if (charAt(input, 1) != ':') return;
	    pointer += 2;
	    pieceIndex++;
	    compress = pieceIndex;
	  }
	  while (chr()) {
	    if (pieceIndex == 8) return;
	    if (chr() == ':') {
	      if (compress !== null) return;
	      pointer++;
	      pieceIndex++;
	      compress = pieceIndex;
	      continue;
	    }
	    value = length = 0;
	    while (length < 4 && exec(HEX, chr())) {
	      value = value * 16 + parseInt$1(chr(), 16);
	      pointer++;
	      length++;
	    }
	    if (chr() == '.') {
	      if (length == 0) return;
	      pointer -= length;
	      if (pieceIndex > 6) return;
	      numbersSeen = 0;
	      while (chr()) {
	        ipv4Piece = null;
	        if (numbersSeen > 0) {
	          if (chr() == '.' && numbersSeen < 4) pointer++;else return;
	        }
	        if (!exec(DIGIT, chr())) return;
	        while (exec(DIGIT, chr())) {
	          number = parseInt$1(chr(), 10);
	          if (ipv4Piece === null) ipv4Piece = number;else if (ipv4Piece == 0) return;else ipv4Piece = ipv4Piece * 10 + number;
	          if (ipv4Piece > 255) return;
	          pointer++;
	        }
	        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
	        numbersSeen++;
	        if (numbersSeen == 2 || numbersSeen == 4) pieceIndex++;
	      }
	      if (numbersSeen != 4) return;
	      break;
	    } else if (chr() == ':') {
	      pointer++;
	      if (!chr()) return;
	    } else if (chr()) return;
	    address[pieceIndex++] = value;
	  }
	  if (compress !== null) {
	    swaps = pieceIndex - compress;
	    pieceIndex = 7;
	    while (pieceIndex != 0 && swaps > 0) {
	      swap = address[pieceIndex];
	      address[pieceIndex--] = address[compress + swaps - 1];
	      address[compress + --swaps] = swap;
	    }
	  } else if (pieceIndex != 8) return;
	  return address;
	};
	var findLongestZeroSequence = function findLongestZeroSequence(ipv6) {
	  var maxIndex = null;
	  var maxLength = 1;
	  var currStart = null;
	  var currLength = 0;
	  var index = 0;
	  for (; index < 8; index++) {
	    if (ipv6[index] !== 0) {
	      if (currLength > maxLength) {
	        maxIndex = currStart;
	        maxLength = currLength;
	      }
	      currStart = null;
	      currLength = 0;
	    } else {
	      if (currStart === null) currStart = index;
	      ++currLength;
	    }
	  }
	  if (currLength > maxLength) {
	    maxIndex = currStart;
	    maxLength = currLength;
	  }
	  return maxIndex;
	};

	// https://url.spec.whatwg.org/#host-serializing
	var serializeHost = function serializeHost(host) {
	  var result, index, compress, ignore0;
	  // ipv4
	  if (typeof host == 'number') {
	    result = [];
	    for (index = 0; index < 4; index++) {
	      unshift(result, host % 256);
	      host = floor$3(host / 256);
	    }
	    return join(result, '.');
	    // ipv6
	  } else if (_typeof(host) == 'object') {
	    result = '';
	    compress = findLongestZeroSequence(host);
	    for (index = 0; index < 8; index++) {
	      if (ignore0 && host[index] === 0) continue;
	      if (ignore0) ignore0 = false;
	      if (compress === index) {
	        result += index ? ':' : '::';
	        ignore0 = true;
	      } else {
	        result += numberToString(host[index], 16);
	        if (index < 7) result += ':';
	      }
	    }
	    return '[' + result + ']';
	  }
	  return host;
	};
	var C0ControlPercentEncodeSet = {};
	var fragmentPercentEncodeSet = assign({}, C0ControlPercentEncodeSet, {
	  ' ': 1,
	  '"': 1,
	  '<': 1,
	  '>': 1,
	  '`': 1
	});
	var pathPercentEncodeSet = assign({}, fragmentPercentEncodeSet, {
	  '#': 1,
	  '?': 1,
	  '{': 1,
	  '}': 1
	});
	var userinfoPercentEncodeSet = assign({}, pathPercentEncodeSet, {
	  '/': 1,
	  ':': 1,
	  ';': 1,
	  '=': 1,
	  '@': 1,
	  '[': 1,
	  '\\': 1,
	  ']': 1,
	  '^': 1,
	  '|': 1
	});
	var percentEncode = function percentEncode(chr, set) {
	  var code = codeAt(chr, 0);
	  return code > 0x20 && code < 0x7F && !hasOwn(set, chr) ? chr : encodeURIComponent(chr);
	};

	// https://url.spec.whatwg.org/#special-scheme
	var specialSchemes = {
	  ftp: 21,
	  file: null,
	  http: 80,
	  https: 443,
	  ws: 80,
	  wss: 443
	};

	// https://url.spec.whatwg.org/#windows-drive-letter
	var isWindowsDriveLetter = function isWindowsDriveLetter(string, normalized) {
	  var second;
	  return string.length == 2 && exec(ALPHA, charAt(string, 0)) && ((second = charAt(string, 1)) == ':' || !normalized && second == '|');
	};

	// https://url.spec.whatwg.org/#start-with-a-windows-drive-letter
	var startsWithWindowsDriveLetter = function startsWithWindowsDriveLetter(string) {
	  var third;
	  return string.length > 1 && isWindowsDriveLetter(stringSlice(string, 0, 2)) && (string.length == 2 || (third = charAt(string, 2)) === '/' || third === '\\' || third === '?' || third === '#');
	};

	// https://url.spec.whatwg.org/#single-dot-path-segment
	var isSingleDot = function isSingleDot(segment) {
	  return segment === '.' || toLowerCase(segment) === '%2e';
	};

	// https://url.spec.whatwg.org/#double-dot-path-segment
	var isDoubleDot = function isDoubleDot(segment) {
	  segment = toLowerCase(segment);
	  return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
	};

	// States:
	var SCHEME_START = {};
	var SCHEME = {};
	var NO_SCHEME = {};
	var SPECIAL_RELATIVE_OR_AUTHORITY = {};
	var PATH_OR_AUTHORITY = {};
	var RELATIVE = {};
	var RELATIVE_SLASH = {};
	var SPECIAL_AUTHORITY_SLASHES = {};
	var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
	var AUTHORITY = {};
	var HOST = {};
	var HOSTNAME = {};
	var PORT = {};
	var FILE = {};
	var FILE_SLASH = {};
	var FILE_HOST = {};
	var PATH_START = {};
	var PATH = {};
	var CANNOT_BE_A_BASE_URL_PATH = {};
	var QUERY = {};
	var FRAGMENT = {};
	var URLState = function URLState(url, isBase, base) {
	  var urlString = $toString(url);
	  var baseState, failure, searchParams;
	  if (isBase) {
	    failure = this.parse(urlString);
	    if (failure) throw TypeError$1(failure);
	    this.searchParams = null;
	  } else {
	    if (base !== undefined) baseState = new URLState(base, true);
	    failure = this.parse(urlString, null, baseState);
	    if (failure) throw TypeError$1(failure);
	    searchParams = getInternalSearchParamsState(new URLSearchParams$1());
	    searchParams.bindURL(this);
	    this.searchParams = searchParams;
	  }
	};
	URLState.prototype = {
	  type: 'URL',
	  // https://url.spec.whatwg.org/#url-parsing
	  // eslint-disable-next-line max-statements -- TODO
	  parse: function parse(input, stateOverride, base) {
	    var url = this;
	    var state = stateOverride || SCHEME_START;
	    var pointer = 0;
	    var buffer = '';
	    var seenAt = false;
	    var seenBracket = false;
	    var seenPasswordToken = false;
	    var codePoints, chr, bufferCodePoints, failure;
	    input = $toString(input);
	    if (!stateOverride) {
	      url.scheme = '';
	      url.username = '';
	      url.password = '';
	      url.host = null;
	      url.port = null;
	      url.path = [];
	      url.query = null;
	      url.fragment = null;
	      url.cannotBeABaseURL = false;
	      input = replace(input, LEADING_C0_CONTROL_OR_SPACE, '');
	      input = replace(input, TRAILING_C0_CONTROL_OR_SPACE, '$1');
	    }
	    input = replace(input, TAB_AND_NEW_LINE, '');
	    codePoints = arrayFrom(input);
	    while (pointer <= codePoints.length) {
	      chr = codePoints[pointer];
	      switch (state) {
	        case SCHEME_START:
	          if (chr && exec(ALPHA, chr)) {
	            buffer += toLowerCase(chr);
	            state = SCHEME;
	          } else if (!stateOverride) {
	            state = NO_SCHEME;
	            continue;
	          } else return INVALID_SCHEME;
	          break;
	        case SCHEME:
	          if (chr && (exec(ALPHANUMERIC, chr) || chr == '+' || chr == '-' || chr == '.')) {
	            buffer += toLowerCase(chr);
	          } else if (chr == ':') {
	            if (stateOverride && (url.isSpecial() != hasOwn(specialSchemes, buffer) || buffer == 'file' && (url.includesCredentials() || url.port !== null) || url.scheme == 'file' && !url.host)) return;
	            url.scheme = buffer;
	            if (stateOverride) {
	              if (url.isSpecial() && specialSchemes[url.scheme] == url.port) url.port = null;
	              return;
	            }
	            buffer = '';
	            if (url.scheme == 'file') {
	              state = FILE;
	            } else if (url.isSpecial() && base && base.scheme == url.scheme) {
	              state = SPECIAL_RELATIVE_OR_AUTHORITY;
	            } else if (url.isSpecial()) {
	              state = SPECIAL_AUTHORITY_SLASHES;
	            } else if (codePoints[pointer + 1] == '/') {
	              state = PATH_OR_AUTHORITY;
	              pointer++;
	            } else {
	              url.cannotBeABaseURL = true;
	              push(url.path, '');
	              state = CANNOT_BE_A_BASE_URL_PATH;
	            }
	          } else if (!stateOverride) {
	            buffer = '';
	            state = NO_SCHEME;
	            pointer = 0;
	            continue;
	          } else return INVALID_SCHEME;
	          break;
	        case NO_SCHEME:
	          if (!base || base.cannotBeABaseURL && chr != '#') return INVALID_SCHEME;
	          if (base.cannotBeABaseURL && chr == '#') {
	            url.scheme = base.scheme;
	            url.path = arraySlice(base.path);
	            url.query = base.query;
	            url.fragment = '';
	            url.cannotBeABaseURL = true;
	            state = FRAGMENT;
	            break;
	          }
	          state = base.scheme == 'file' ? FILE : RELATIVE;
	          continue;
	        case SPECIAL_RELATIVE_OR_AUTHORITY:
	          if (chr == '/' && codePoints[pointer + 1] == '/') {
	            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	            pointer++;
	          } else {
	            state = RELATIVE;
	            continue;
	          }
	          break;
	        case PATH_OR_AUTHORITY:
	          if (chr == '/') {
	            state = AUTHORITY;
	            break;
	          } else {
	            state = PATH;
	            continue;
	          }
	        case RELATIVE:
	          url.scheme = base.scheme;
	          if (chr == EOF) {
	            url.username = base.username;
	            url.password = base.password;
	            url.host = base.host;
	            url.port = base.port;
	            url.path = arraySlice(base.path);
	            url.query = base.query;
	          } else if (chr == '/' || chr == '\\' && url.isSpecial()) {
	            state = RELATIVE_SLASH;
	          } else if (chr == '?') {
	            url.username = base.username;
	            url.password = base.password;
	            url.host = base.host;
	            url.port = base.port;
	            url.path = arraySlice(base.path);
	            url.query = '';
	            state = QUERY;
	          } else if (chr == '#') {
	            url.username = base.username;
	            url.password = base.password;
	            url.host = base.host;
	            url.port = base.port;
	            url.path = arraySlice(base.path);
	            url.query = base.query;
	            url.fragment = '';
	            state = FRAGMENT;
	          } else {
	            url.username = base.username;
	            url.password = base.password;
	            url.host = base.host;
	            url.port = base.port;
	            url.path = arraySlice(base.path);
	            url.path.length--;
	            state = PATH;
	            continue;
	          }
	          break;
	        case RELATIVE_SLASH:
	          if (url.isSpecial() && (chr == '/' || chr == '\\')) {
	            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	          } else if (chr == '/') {
	            state = AUTHORITY;
	          } else {
	            url.username = base.username;
	            url.password = base.password;
	            url.host = base.host;
	            url.port = base.port;
	            state = PATH;
	            continue;
	          }
	          break;
	        case SPECIAL_AUTHORITY_SLASHES:
	          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	          if (chr != '/' || charAt(buffer, pointer + 1) != '/') continue;
	          pointer++;
	          break;
	        case SPECIAL_AUTHORITY_IGNORE_SLASHES:
	          if (chr != '/' && chr != '\\') {
	            state = AUTHORITY;
	            continue;
	          }
	          break;
	        case AUTHORITY:
	          if (chr == '@') {
	            if (seenAt) buffer = '%40' + buffer;
	            seenAt = true;
	            bufferCodePoints = arrayFrom(buffer);
	            for (var i = 0; i < bufferCodePoints.length; i++) {
	              var codePoint = bufferCodePoints[i];
	              if (codePoint == ':' && !seenPasswordToken) {
	                seenPasswordToken = true;
	                continue;
	              }
	              var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
	              if (seenPasswordToken) url.password += encodedCodePoints;else url.username += encodedCodePoints;
	            }
	            buffer = '';
	          } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial()) {
	            if (seenAt && buffer == '') return INVALID_AUTHORITY;
	            pointer -= arrayFrom(buffer).length + 1;
	            buffer = '';
	            state = HOST;
	          } else buffer += chr;
	          break;
	        case HOST:
	        case HOSTNAME:
	          if (stateOverride && url.scheme == 'file') {
	            state = FILE_HOST;
	            continue;
	          } else if (chr == ':' && !seenBracket) {
	            if (buffer == '') return INVALID_HOST;
	            failure = url.parseHost(buffer);
	            if (failure) return failure;
	            buffer = '';
	            state = PORT;
	            if (stateOverride == HOSTNAME) return;
	          } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial()) {
	            if (url.isSpecial() && buffer == '') return INVALID_HOST;
	            if (stateOverride && buffer == '' && (url.includesCredentials() || url.port !== null)) return;
	            failure = url.parseHost(buffer);
	            if (failure) return failure;
	            buffer = '';
	            state = PATH_START;
	            if (stateOverride) return;
	            continue;
	          } else {
	            if (chr == '[') seenBracket = true;else if (chr == ']') seenBracket = false;
	            buffer += chr;
	          }
	          break;
	        case PORT:
	          if (exec(DIGIT, chr)) {
	            buffer += chr;
	          } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial() || stateOverride) {
	            if (buffer != '') {
	              var port = parseInt$1(buffer, 10);
	              if (port > 0xFFFF) return INVALID_PORT;
	              url.port = url.isSpecial() && port === specialSchemes[url.scheme] ? null : port;
	              buffer = '';
	            }
	            if (stateOverride) return;
	            state = PATH_START;
	            continue;
	          } else return INVALID_PORT;
	          break;
	        case FILE:
	          url.scheme = 'file';
	          if (chr == '/' || chr == '\\') state = FILE_SLASH;else if (base && base.scheme == 'file') {
	            if (chr == EOF) {
	              url.host = base.host;
	              url.path = arraySlice(base.path);
	              url.query = base.query;
	            } else if (chr == '?') {
	              url.host = base.host;
	              url.path = arraySlice(base.path);
	              url.query = '';
	              state = QUERY;
	            } else if (chr == '#') {
	              url.host = base.host;
	              url.path = arraySlice(base.path);
	              url.query = base.query;
	              url.fragment = '';
	              state = FRAGMENT;
	            } else {
	              if (!startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
	                url.host = base.host;
	                url.path = arraySlice(base.path);
	                url.shortenPath();
	              }
	              state = PATH;
	              continue;
	            }
	          } else {
	            state = PATH;
	            continue;
	          }
	          break;
	        case FILE_SLASH:
	          if (chr == '/' || chr == '\\') {
	            state = FILE_HOST;
	            break;
	          }
	          if (base && base.scheme == 'file' && !startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
	            if (isWindowsDriveLetter(base.path[0], true)) push(url.path, base.path[0]);else url.host = base.host;
	          }
	          state = PATH;
	          continue;
	        case FILE_HOST:
	          if (chr == EOF || chr == '/' || chr == '\\' || chr == '?' || chr == '#') {
	            if (!stateOverride && isWindowsDriveLetter(buffer)) {
	              state = PATH;
	            } else if (buffer == '') {
	              url.host = '';
	              if (stateOverride) return;
	              state = PATH_START;
	            } else {
	              failure = url.parseHost(buffer);
	              if (failure) return failure;
	              if (url.host == 'localhost') url.host = '';
	              if (stateOverride) return;
	              buffer = '';
	              state = PATH_START;
	            }
	            continue;
	          } else buffer += chr;
	          break;
	        case PATH_START:
	          if (url.isSpecial()) {
	            state = PATH;
	            if (chr != '/' && chr != '\\') continue;
	          } else if (!stateOverride && chr == '?') {
	            url.query = '';
	            state = QUERY;
	          } else if (!stateOverride && chr == '#') {
	            url.fragment = '';
	            state = FRAGMENT;
	          } else if (chr != EOF) {
	            state = PATH;
	            if (chr != '/') continue;
	          }
	          break;
	        case PATH:
	          if (chr == EOF || chr == '/' || chr == '\\' && url.isSpecial() || !stateOverride && (chr == '?' || chr == '#')) {
	            if (isDoubleDot(buffer)) {
	              url.shortenPath();
	              if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
	                push(url.path, '');
	              }
	            } else if (isSingleDot(buffer)) {
	              if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
	                push(url.path, '');
	              }
	            } else {
	              if (url.scheme == 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
	                if (url.host) url.host = '';
	                buffer = charAt(buffer, 0) + ':'; // normalize windows drive letter
	              }

	              push(url.path, buffer);
	            }
	            buffer = '';
	            if (url.scheme == 'file' && (chr == EOF || chr == '?' || chr == '#')) {
	              while (url.path.length > 1 && url.path[0] === '') {
	                shift(url.path);
	              }
	            }
	            if (chr == '?') {
	              url.query = '';
	              state = QUERY;
	            } else if (chr == '#') {
	              url.fragment = '';
	              state = FRAGMENT;
	            }
	          } else {
	            buffer += percentEncode(chr, pathPercentEncodeSet);
	          }
	          break;
	        case CANNOT_BE_A_BASE_URL_PATH:
	          if (chr == '?') {
	            url.query = '';
	            state = QUERY;
	          } else if (chr == '#') {
	            url.fragment = '';
	            state = FRAGMENT;
	          } else if (chr != EOF) {
	            url.path[0] += percentEncode(chr, C0ControlPercentEncodeSet);
	          }
	          break;
	        case QUERY:
	          if (!stateOverride && chr == '#') {
	            url.fragment = '';
	            state = FRAGMENT;
	          } else if (chr != EOF) {
	            if (chr == "'" && url.isSpecial()) url.query += '%27';else if (chr == '#') url.query += '%23';else url.query += percentEncode(chr, C0ControlPercentEncodeSet);
	          }
	          break;
	        case FRAGMENT:
	          if (chr != EOF) url.fragment += percentEncode(chr, fragmentPercentEncodeSet);
	          break;
	      }
	      pointer++;
	    }
	  },
	  // https://url.spec.whatwg.org/#host-parsing
	  parseHost: function parseHost(input) {
	    var result, codePoints, index;
	    if (charAt(input, 0) == '[') {
	      if (charAt(input, input.length - 1) != ']') return INVALID_HOST;
	      result = parseIPv6(stringSlice(input, 1, -1));
	      if (!result) return INVALID_HOST;
	      this.host = result;
	      // opaque host
	    } else if (!this.isSpecial()) {
	      if (exec(FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT, input)) return INVALID_HOST;
	      result = '';
	      codePoints = arrayFrom(input);
	      for (index = 0; index < codePoints.length; index++) {
	        result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
	      }
	      this.host = result;
	    } else {
	      input = toASCII(input);
	      if (exec(FORBIDDEN_HOST_CODE_POINT, input)) return INVALID_HOST;
	      result = parseIPv4(input);
	      if (result === null) return INVALID_HOST;
	      this.host = result;
	    }
	  },
	  // https://url.spec.whatwg.org/#cannot-have-a-username-password-port
	  cannotHaveUsernamePasswordPort: function cannotHaveUsernamePasswordPort() {
	    return !this.host || this.cannotBeABaseURL || this.scheme == 'file';
	  },
	  // https://url.spec.whatwg.org/#include-credentials
	  includesCredentials: function includesCredentials() {
	    return this.username != '' || this.password != '';
	  },
	  // https://url.spec.whatwg.org/#is-special
	  isSpecial: function isSpecial() {
	    return hasOwn(specialSchemes, this.scheme);
	  },
	  // https://url.spec.whatwg.org/#shorten-a-urls-path
	  shortenPath: function shortenPath() {
	    var path = this.path;
	    var pathSize = path.length;
	    if (pathSize && (this.scheme != 'file' || pathSize != 1 || !isWindowsDriveLetter(path[0], true))) {
	      path.length--;
	    }
	  },
	  // https://url.spec.whatwg.org/#concept-url-serializer
	  serialize: function serialize() {
	    var url = this;
	    var scheme = url.scheme;
	    var username = url.username;
	    var password = url.password;
	    var host = url.host;
	    var port = url.port;
	    var path = url.path;
	    var query = url.query;
	    var fragment = url.fragment;
	    var output = scheme + ':';
	    if (host !== null) {
	      output += '//';
	      if (url.includesCredentials()) {
	        output += username + (password ? ':' + password : '') + '@';
	      }
	      output += serializeHost(host);
	      if (port !== null) output += ':' + port;
	    } else if (scheme == 'file') output += '//';
	    output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
	    if (query !== null) output += '?' + query;
	    if (fragment !== null) output += '#' + fragment;
	    return output;
	  },
	  // https://url.spec.whatwg.org/#dom-url-href
	  setHref: function setHref(href) {
	    var failure = this.parse(href);
	    if (failure) throw TypeError$1(failure);
	    this.searchParams.update();
	  },
	  // https://url.spec.whatwg.org/#dom-url-origin
	  getOrigin: function getOrigin() {
	    var scheme = this.scheme;
	    var port = this.port;
	    if (scheme == 'blob') try {
	      return new URLConstructor(scheme.path[0]).origin;
	    } catch (error) {
	      return 'null';
	    }
	    if (scheme == 'file' || !this.isSpecial()) return 'null';
	    return scheme + '://' + serializeHost(this.host) + (port !== null ? ':' + port : '');
	  },
	  // https://url.spec.whatwg.org/#dom-url-protocol
	  getProtocol: function getProtocol() {
	    return this.scheme + ':';
	  },
	  setProtocol: function setProtocol(protocol) {
	    this.parse($toString(protocol) + ':', SCHEME_START);
	  },
	  // https://url.spec.whatwg.org/#dom-url-username
	  getUsername: function getUsername() {
	    return this.username;
	  },
	  setUsername: function setUsername(username) {
	    var codePoints = arrayFrom($toString(username));
	    if (this.cannotHaveUsernamePasswordPort()) return;
	    this.username = '';
	    for (var i = 0; i < codePoints.length; i++) {
	      this.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	    }
	  },
	  // https://url.spec.whatwg.org/#dom-url-password
	  getPassword: function getPassword() {
	    return this.password;
	  },
	  setPassword: function setPassword(password) {
	    var codePoints = arrayFrom($toString(password));
	    if (this.cannotHaveUsernamePasswordPort()) return;
	    this.password = '';
	    for (var i = 0; i < codePoints.length; i++) {
	      this.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	    }
	  },
	  // https://url.spec.whatwg.org/#dom-url-host
	  getHost: function getHost() {
	    var host = this.host;
	    var port = this.port;
	    return host === null ? '' : port === null ? serializeHost(host) : serializeHost(host) + ':' + port;
	  },
	  setHost: function setHost(host) {
	    if (this.cannotBeABaseURL) return;
	    this.parse(host, HOST);
	  },
	  // https://url.spec.whatwg.org/#dom-url-hostname
	  getHostname: function getHostname() {
	    var host = this.host;
	    return host === null ? '' : serializeHost(host);
	  },
	  setHostname: function setHostname(hostname) {
	    if (this.cannotBeABaseURL) return;
	    this.parse(hostname, HOSTNAME);
	  },
	  // https://url.spec.whatwg.org/#dom-url-port
	  getPort: function getPort() {
	    var port = this.port;
	    return port === null ? '' : $toString(port);
	  },
	  setPort: function setPort(port) {
	    if (this.cannotHaveUsernamePasswordPort()) return;
	    port = $toString(port);
	    if (port == '') this.port = null;else this.parse(port, PORT);
	  },
	  // https://url.spec.whatwg.org/#dom-url-pathname
	  getPathname: function getPathname() {
	    var path = this.path;
	    return this.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
	  },
	  setPathname: function setPathname(pathname) {
	    if (this.cannotBeABaseURL) return;
	    this.path = [];
	    this.parse(pathname, PATH_START);
	  },
	  // https://url.spec.whatwg.org/#dom-url-search
	  getSearch: function getSearch() {
	    var query = this.query;
	    return query ? '?' + query : '';
	  },
	  setSearch: function setSearch(search) {
	    search = $toString(search);
	    if (search == '') {
	      this.query = null;
	    } else {
	      if ('?' == charAt(search, 0)) search = stringSlice(search, 1);
	      this.query = '';
	      this.parse(search, QUERY);
	    }
	    this.searchParams.update();
	  },
	  // https://url.spec.whatwg.org/#dom-url-searchparams
	  getSearchParams: function getSearchParams() {
	    return this.searchParams.facade;
	  },
	  // https://url.spec.whatwg.org/#dom-url-hash
	  getHash: function getHash() {
	    var fragment = this.fragment;
	    return fragment ? '#' + fragment : '';
	  },
	  setHash: function setHash(hash) {
	    hash = $toString(hash);
	    if (hash == '') {
	      this.fragment = null;
	      return;
	    }
	    if ('#' == charAt(hash, 0)) hash = stringSlice(hash, 1);
	    this.fragment = '';
	    this.parse(hash, FRAGMENT);
	  },
	  update: function update() {
	    this.query = this.searchParams.serialize() || null;
	  }
	};

	// `URL` constructor
	// https://url.spec.whatwg.org/#url-class
	var URLConstructor = function URL(url /* , base */) {
	  var that = anInstance(this, URLPrototype);
	  var base = validateArgumentsLength(arguments.length, 1) > 1 ? arguments[1] : undefined;
	  var state = setInternalState(that, new URLState(url, false, base));
	  if (!DESCRIPTORS$1) {
	    that.href = state.serialize();
	    that.origin = state.getOrigin();
	    that.protocol = state.getProtocol();
	    that.username = state.getUsername();
	    that.password = state.getPassword();
	    that.host = state.getHost();
	    that.hostname = state.getHostname();
	    that.port = state.getPort();
	    that.pathname = state.getPathname();
	    that.search = state.getSearch();
	    that.searchParams = state.getSearchParams();
	    that.hash = state.getHash();
	  }
	};
	var URLPrototype = URLConstructor.prototype;
	var accessorDescriptor = function accessorDescriptor(getter, setter) {
	  return {
	    get: function get() {
	      return getInternalURLState(this)[getter]();
	    },
	    set: setter && function (value) {
	      return getInternalURLState(this)[setter](value);
	    },
	    configurable: true,
	    enumerable: true
	  };
	};
	if (DESCRIPTORS$1) {
	  // `URL.prototype.href` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-href
	  defineBuiltInAccessor$1(URLPrototype, 'href', accessorDescriptor('serialize', 'setHref'));
	  // `URL.prototype.origin` getter
	  // https://url.spec.whatwg.org/#dom-url-origin
	  defineBuiltInAccessor$1(URLPrototype, 'origin', accessorDescriptor('getOrigin'));
	  // `URL.prototype.protocol` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-protocol
	  defineBuiltInAccessor$1(URLPrototype, 'protocol', accessorDescriptor('getProtocol', 'setProtocol'));
	  // `URL.prototype.username` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-username
	  defineBuiltInAccessor$1(URLPrototype, 'username', accessorDescriptor('getUsername', 'setUsername'));
	  // `URL.prototype.password` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-password
	  defineBuiltInAccessor$1(URLPrototype, 'password', accessorDescriptor('getPassword', 'setPassword'));
	  // `URL.prototype.host` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-host
	  defineBuiltInAccessor$1(URLPrototype, 'host', accessorDescriptor('getHost', 'setHost'));
	  // `URL.prototype.hostname` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-hostname
	  defineBuiltInAccessor$1(URLPrototype, 'hostname', accessorDescriptor('getHostname', 'setHostname'));
	  // `URL.prototype.port` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-port
	  defineBuiltInAccessor$1(URLPrototype, 'port', accessorDescriptor('getPort', 'setPort'));
	  // `URL.prototype.pathname` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-pathname
	  defineBuiltInAccessor$1(URLPrototype, 'pathname', accessorDescriptor('getPathname', 'setPathname'));
	  // `URL.prototype.search` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-search
	  defineBuiltInAccessor$1(URLPrototype, 'search', accessorDescriptor('getSearch', 'setSearch'));
	  // `URL.prototype.searchParams` getter
	  // https://url.spec.whatwg.org/#dom-url-searchparams
	  defineBuiltInAccessor$1(URLPrototype, 'searchParams', accessorDescriptor('getSearchParams'));
	  // `URL.prototype.hash` accessors pair
	  // https://url.spec.whatwg.org/#dom-url-hash
	  defineBuiltInAccessor$1(URLPrototype, 'hash', accessorDescriptor('getHash', 'setHash'));
	}

	// `URL.prototype.toJSON` method
	// https://url.spec.whatwg.org/#dom-url-tojson
	defineBuiltIn(URLPrototype, 'toJSON', function toJSON() {
	  return getInternalURLState(this).serialize();
	}, {
	  enumerable: true
	});

	// `URL.prototype.toString` method
	// https://url.spec.whatwg.org/#URL-stringification-behavior
	defineBuiltIn(URLPrototype, 'toString', function toString() {
	  return getInternalURLState(this).serialize();
	}, {
	  enumerable: true
	});
	if (NativeURL) {
	  var nativeCreateObjectURL = NativeURL.createObjectURL;
	  var nativeRevokeObjectURL = NativeURL.revokeObjectURL;
	  // `URL.createObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/createObjectURL
	  if (nativeCreateObjectURL) defineBuiltIn(URLConstructor, 'createObjectURL', bind(nativeCreateObjectURL, NativeURL));
	  // `URL.revokeObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/revokeObjectURL
	  if (nativeRevokeObjectURL) defineBuiltIn(URLConstructor, 'revokeObjectURL', bind(nativeRevokeObjectURL, NativeURL));
	}
	setToStringTag(URLConstructor, 'URL');
	$$1({
	  global: true,
	  constructor: true,
	  forced: !USE_NATIVE_URL,
	  sham: !DESCRIPTORS$1
	}, {
	  URL: URLConstructor
	});

	var web_url_toJson = {};

	'use strict';
	var $ = _export;
	var call = functionCall;

	// `URL.prototype.toJSON` method
	// https://url.spec.whatwg.org/#dom-url-tojson
	$({
	  target: 'URL',
	  proto: true,
	  enumerable: true
	}, {
	  toJSON: function toJSON() {
	    return call(URL.prototype.toString, this);
	  }
	});

	var web_urlSearchParams = {};

	var web_urlSearchParams_size = {};

	'use strict';
	var DESCRIPTORS = descriptors;
	var uncurryThis = functionUncurryThis;
	var defineBuiltInAccessor = defineBuiltInAccessor$h;
	var URLSearchParamsPrototype = URLSearchParams.prototype;
	var forEach = uncurryThis(URLSearchParamsPrototype.forEach);

	// `URLSearchParams.prototype.size` getter
	// https://github.com/whatwg/url/pull/734
	if (DESCRIPTORS && !('size' in URLSearchParamsPrototype)) {
	  defineBuiltInAccessor(URLSearchParamsPrototype, 'size', {
	    get: function size() {
	      var count = 0;
	      forEach(this, function () {
	        count++;
	      });
	      return count;
	    },
	    configurable: true,
	    enumerable: true
	  });
	}

	var stable = path$2;
	var index$2 = /*@__PURE__*/getDefaultExportFromCjs(stable);

	var runtime$1 = {exports: {}};

	var runtime_1 = runtime$1.exports;
	(function (module) {
	  var runtime = function (exports) {
	    "use strict";

	    var Op = Object.prototype;
	    var hasOwn = Op.hasOwnProperty;
	    var undefined$1; // More compressible than void 0.
	    var $Symbol = typeof Symbol === "function" ? Symbol : {};
	    var iteratorSymbol = $Symbol.iterator || "@@iterator";
	    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
	    function define(obj, key, value) {
	      Object.defineProperty(obj, key, {
	        value: value,
	        enumerable: true,
	        configurable: true,
	        writable: true
	      });
	      return obj[key];
	    }
	    try {
	      // IE 8 has a broken Object.defineProperty that only works on DOM objects.
	      define({}, "");
	    } catch (err) {
	      define = function define(obj, key, value) {
	        return obj[key] = value;
	      };
	    }
	    function wrap(innerFn, outerFn, self, tryLocsList) {
	      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	      var generator = Object.create(protoGenerator.prototype);
	      var context = new Context(tryLocsList || []);

	      // The ._invoke method unifies the implementations of the .next,
	      // .throw, and .return methods.
	      generator._invoke = makeInvokeMethod(innerFn, self, context);
	      return generator;
	    }
	    exports.wrap = wrap;

	    // Try/catch helper to minimize deoptimizations. Returns a completion
	    // record like context.tryEntries[i].completion. This interface could
	    // have been (and was previously) designed to take a closure to be
	    // invoked without arguments, but in all the cases we care about we
	    // already have an existing method we want to call, so there's no need
	    // to create a new function object. We can even get away with assuming
	    // the method takes exactly one argument, since that happens to be true
	    // in every case, so we don't have to touch the arguments object. The
	    // only additional allocation required is the completion record, which
	    // has a stable shape and so hopefully should be cheap to allocate.
	    function tryCatch(fn, obj, arg) {
	      try {
	        return {
	          type: "normal",
	          arg: fn.call(obj, arg)
	        };
	      } catch (err) {
	        return {
	          type: "throw",
	          arg: err
	        };
	      }
	    }
	    var GenStateSuspendedStart = "suspendedStart";
	    var GenStateSuspendedYield = "suspendedYield";
	    var GenStateExecuting = "executing";
	    var GenStateCompleted = "completed";

	    // Returning this object from the innerFn has the same effect as
	    // breaking out of the dispatch switch statement.
	    var ContinueSentinel = {};

	    // Dummy constructor functions that we use as the .constructor and
	    // .constructor.prototype properties for functions that return Generator
	    // objects. For full spec compliance, you may wish to configure your
	    // minifier not to mangle the names of these two functions.
	    function Generator() {}
	    function GeneratorFunction() {}
	    function GeneratorFunctionPrototype() {}

	    // This is a polyfill for %IteratorPrototype% for environments that
	    // don't natively support it.
	    var IteratorPrototype = {};
	    IteratorPrototype[iteratorSymbol] = function () {
	      return this;
	    };
	    var getProto = Object.getPrototypeOf;
	    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	      // This environment has a native %IteratorPrototype%; use it instead
	      // of the polyfill.
	      IteratorPrototype = NativeIteratorPrototype;
	    }
	    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	    GeneratorFunctionPrototype.constructor = GeneratorFunction;
	    GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");

	    // Helper for defining the .next, .throw, and .return methods of the
	    // Iterator interface in terms of a single ._invoke method.
	    function defineIteratorMethods(prototype) {
	      ["next", "throw", "return"].forEach(function (method) {
	        define(prototype, method, function (arg) {
	          return this._invoke(method, arg);
	        });
	      });
	    }
	    exports.isGeneratorFunction = function (genFun) {
	      var ctor = typeof genFun === "function" && genFun.constructor;
	      return ctor ? ctor === GeneratorFunction ||
	      // For the native GeneratorFunction constructor, the best we can
	      // do is to check its .name property.
	      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
	    };
	    exports.mark = function (genFun) {
	      if (Object.setPrototypeOf) {
	        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	      } else {
	        genFun.__proto__ = GeneratorFunctionPrototype;
	        define(genFun, toStringTagSymbol, "GeneratorFunction");
	      }
	      genFun.prototype = Object.create(Gp);
	      return genFun;
	    };

	    // Within the body of any async function, `await x` is transformed to
	    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	    // `hasOwn.call(value, "__await")` to determine if the yielded value is
	    // meant to be awaited.
	    exports.awrap = function (arg) {
	      return {
	        __await: arg
	      };
	    };
	    function AsyncIterator(generator, PromiseImpl) {
	      function invoke(method, arg, resolve, reject) {
	        var record = tryCatch(generator[method], generator, arg);
	        if (record.type === "throw") {
	          reject(record.arg);
	        } else {
	          var result = record.arg;
	          var value = result.value;
	          if (value && _typeof(value) === "object" && hasOwn.call(value, "__await")) {
	            return PromiseImpl.resolve(value.__await).then(function (value) {
	              invoke("next", value, resolve, reject);
	            }, function (err) {
	              invoke("throw", err, resolve, reject);
	            });
	          }
	          return PromiseImpl.resolve(value).then(function (unwrapped) {
	            // When a yielded Promise is resolved, its final value becomes
	            // the .value of the Promise<{value,done}> result for the
	            // current iteration.
	            result.value = unwrapped;
	            resolve(result);
	          }, function (error) {
	            // If a rejected Promise was yielded, throw the rejection back
	            // into the async generator function so it can be handled there.
	            return invoke("throw", error, resolve, reject);
	          });
	        }
	      }
	      var previousPromise;
	      function enqueue(method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }
	        return previousPromise =
	        // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(callInvokeWithMethodAndArg,
	        // Avoid propagating failures to Promises returned by later
	        // invocations of the iterator.
	        callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      }

	      // Define the unified helper method that is used to implement .next,
	      // .throw, and .return (see defineIteratorMethods).
	      this._invoke = enqueue;
	    }
	    defineIteratorMethods(AsyncIterator.prototype);
	    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	      return this;
	    };
	    exports.AsyncIterator = AsyncIterator;

	    // Note that simple async functions are implemented on top of
	    // AsyncIterator objects; they just return a Promise for the value of
	    // the final result produced by the iterator.
	    exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	      if (PromiseImpl === void 0) PromiseImpl = Promise;
	      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	      return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function (result) {
	        return result.done ? result.value : iter.next();
	      });
	    };
	    function makeInvokeMethod(innerFn, self, context) {
	      var state = GenStateSuspendedStart;
	      return function invoke(method, arg) {
	        if (state === GenStateExecuting) {
	          throw new Error("Generator is already running");
	        }
	        if (state === GenStateCompleted) {
	          if (method === "throw") {
	            throw arg;
	          }

	          // Be forgiving, per 25.3.3.3.3 of the spec:
	          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
	          return doneResult();
	        }
	        context.method = method;
	        context.arg = arg;
	        while (true) {
	          var delegate = context.delegate;
	          if (delegate) {
	            var delegateResult = maybeInvokeDelegate(delegate, context);
	            if (delegateResult) {
	              if (delegateResult === ContinueSentinel) continue;
	              return delegateResult;
	            }
	          }
	          if (context.method === "next") {
	            // Setting context._sent for legacy support of Babel's
	            // function.sent implementation.
	            context.sent = context._sent = context.arg;
	          } else if (context.method === "throw") {
	            if (state === GenStateSuspendedStart) {
	              state = GenStateCompleted;
	              throw context.arg;
	            }
	            context.dispatchException(context.arg);
	          } else if (context.method === "return") {
	            context.abrupt("return", context.arg);
	          }
	          state = GenStateExecuting;
	          var record = tryCatch(innerFn, self, context);
	          if (record.type === "normal") {
	            // If an exception is thrown from innerFn, we leave state ===
	            // GenStateExecuting and loop back for another invocation.
	            state = context.done ? GenStateCompleted : GenStateSuspendedYield;
	            if (record.arg === ContinueSentinel) {
	              continue;
	            }
	            return {
	              value: record.arg,
	              done: context.done
	            };
	          } else if (record.type === "throw") {
	            state = GenStateCompleted;
	            // Dispatch the exception by looping back around to the
	            // context.dispatchException(context.arg) call above.
	            context.method = "throw";
	            context.arg = record.arg;
	          }
	        }
	      };
	    }

	    // Call delegate.iterator[context.method](context.arg) and handle the
	    // result, either by returning a { value, done } result from the
	    // delegate iterator, or by modifying context.method and context.arg,
	    // setting context.delegate to null, and returning the ContinueSentinel.
	    function maybeInvokeDelegate(delegate, context) {
	      var method = delegate.iterator[context.method];
	      if (method === undefined$1) {
	        // A .throw or .return when the delegate iterator has no .throw
	        // method always terminates the yield* loop.
	        context.delegate = null;
	        if (context.method === "throw") {
	          // Note: ["return"] must be used for ES3 parsing compatibility.
	          if (delegate.iterator["return"]) {
	            // If the delegate iterator has a return method, give it a
	            // chance to clean up.
	            context.method = "return";
	            context.arg = undefined$1;
	            maybeInvokeDelegate(delegate, context);
	            if (context.method === "throw") {
	              // If maybeInvokeDelegate(context) changed context.method from
	              // "return" to "throw", let that override the TypeError below.
	              return ContinueSentinel;
	            }
	          }
	          context.method = "throw";
	          context.arg = new TypeError("The iterator does not provide a 'throw' method");
	        }
	        return ContinueSentinel;
	      }
	      var record = tryCatch(method, delegate.iterator, context.arg);
	      if (record.type === "throw") {
	        context.method = "throw";
	        context.arg = record.arg;
	        context.delegate = null;
	        return ContinueSentinel;
	      }
	      var info = record.arg;
	      if (!info) {
	        context.method = "throw";
	        context.arg = new TypeError("iterator result is not an object");
	        context.delegate = null;
	        return ContinueSentinel;
	      }
	      if (info.done) {
	        // Assign the result of the finished delegate to the temporary
	        // variable specified by delegate.resultName (see delegateYield).
	        context[delegate.resultName] = info.value;

	        // Resume execution at the desired location (see delegateYield).
	        context.next = delegate.nextLoc;

	        // If context.method was "throw" but the delegate handled the
	        // exception, let the outer generator proceed normally. If
	        // context.method was "next", forget context.arg since it has been
	        // "consumed" by the delegate iterator. If context.method was
	        // "return", allow the original .return call to continue in the
	        // outer generator.
	        if (context.method !== "return") {
	          context.method = "next";
	          context.arg = undefined$1;
	        }
	      } else {
	        // Re-yield the result returned by the delegate method.
	        return info;
	      }

	      // The delegate iterator is finished, so forget it and continue with
	      // the outer generator.
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    // Define Generator.prototype.{next,throw,return} in terms of the
	    // unified ._invoke helper method.
	    defineIteratorMethods(Gp);
	    define(Gp, toStringTagSymbol, "Generator");

	    // A Generator should always return itself as the iterator object when the
	    // @@iterator function is called on it. Some browsers' implementations of the
	    // iterator prototype chain incorrectly implement this, causing the Generator
	    // object to not be returned from this call. This ensures that doesn't happen.
	    // See https://github.com/facebook/regenerator/issues/274 for more details.
	    Gp[iteratorSymbol] = function () {
	      return this;
	    };
	    Gp.toString = function () {
	      return "[object Generator]";
	    };
	    function pushTryEntry(locs) {
	      var entry = {
	        tryLoc: locs[0]
	      };
	      if (1 in locs) {
	        entry.catchLoc = locs[1];
	      }
	      if (2 in locs) {
	        entry.finallyLoc = locs[2];
	        entry.afterLoc = locs[3];
	      }
	      this.tryEntries.push(entry);
	    }
	    function resetTryEntry(entry) {
	      var record = entry.completion || {};
	      record.type = "normal";
	      delete record.arg;
	      entry.completion = record;
	    }
	    function Context(tryLocsList) {
	      // The root entry object (effectively a try statement without a catch
	      // or a finally block) gives us a place to store values thrown from
	      // locations where there is no enclosing try statement.
	      this.tryEntries = [{
	        tryLoc: "root"
	      }];
	      tryLocsList.forEach(pushTryEntry, this);
	      this.reset(true);
	    }
	    exports.keys = function (object) {
	      var keys = [];
	      for (var key in object) {
	        keys.push(key);
	      }
	      keys.reverse();

	      // Rather than returning an object with a next method, we keep
	      // things simple and return the next function itself.
	      return function next() {
	        while (keys.length) {
	          var key = keys.pop();
	          if (key in object) {
	            next.value = key;
	            next.done = false;
	            return next;
	          }
	        }

	        // To avoid creating an additional object, we just hang the .value
	        // and .done properties off the next function object itself. This
	        // also ensures that the minifier will not anonymize the function.
	        next.done = true;
	        return next;
	      };
	    };
	    function values(iterable) {
	      if (iterable) {
	        var iteratorMethod = iterable[iteratorSymbol];
	        if (iteratorMethod) {
	          return iteratorMethod.call(iterable);
	        }
	        if (typeof iterable.next === "function") {
	          return iterable;
	        }
	        if (!isNaN(iterable.length)) {
	          var i = -1,
	            next = function next() {
	              while (++i < iterable.length) {
	                if (hasOwn.call(iterable, i)) {
	                  next.value = iterable[i];
	                  next.done = false;
	                  return next;
	                }
	              }
	              next.value = undefined$1;
	              next.done = true;
	              return next;
	            };
	          return next.next = next;
	        }
	      }

	      // Return an iterator with no values.
	      return {
	        next: doneResult
	      };
	    }
	    exports.values = values;
	    function doneResult() {
	      return {
	        value: undefined$1,
	        done: true
	      };
	    }
	    Context.prototype = {
	      constructor: Context,
	      reset: function reset(skipTempReset) {
	        this.prev = 0;
	        this.next = 0;
	        // Resetting context._sent for legacy support of Babel's
	        // function.sent implementation.
	        this.sent = this._sent = undefined$1;
	        this.done = false;
	        this.delegate = null;
	        this.method = "next";
	        this.arg = undefined$1;
	        this.tryEntries.forEach(resetTryEntry);
	        if (!skipTempReset) {
	          for (var name in this) {
	            // Not sure about the optimal order of these conditions:
	            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
	              this[name] = undefined$1;
	            }
	          }
	        }
	      },
	      stop: function stop() {
	        this.done = true;
	        var rootEntry = this.tryEntries[0];
	        var rootRecord = rootEntry.completion;
	        if (rootRecord.type === "throw") {
	          throw rootRecord.arg;
	        }
	        return this.rval;
	      },
	      dispatchException: function dispatchException(exception) {
	        if (this.done) {
	          throw exception;
	        }
	        var context = this;
	        function handle(loc, caught) {
	          record.type = "throw";
	          record.arg = exception;
	          context.next = loc;
	          if (caught) {
	            // If the dispatched exception was caught by a catch block,
	            // then let that catch block handle the exception normally.
	            context.method = "next";
	            context.arg = undefined$1;
	          }
	          return !!caught;
	        }
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          var record = entry.completion;
	          if (entry.tryLoc === "root") {
	            // Exception thrown outside of any try block that could handle
	            // it, so set the completion value of the entire function to
	            // throw the exception.
	            return handle("end");
	          }
	          if (entry.tryLoc <= this.prev) {
	            var hasCatch = hasOwn.call(entry, "catchLoc");
	            var hasFinally = hasOwn.call(entry, "finallyLoc");
	            if (hasCatch && hasFinally) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              } else if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else if (hasCatch) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              }
	            } else if (hasFinally) {
	              if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else {
	              throw new Error("try statement without catch or finally");
	            }
	          }
	        }
	      },
	      abrupt: function abrupt(type, arg) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	            var finallyEntry = entry;
	            break;
	          }
	        }
	        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
	          // Ignore the finally entry if control is not jumping to a
	          // location outside the try/catch block.
	          finallyEntry = null;
	        }
	        var record = finallyEntry ? finallyEntry.completion : {};
	        record.type = type;
	        record.arg = arg;
	        if (finallyEntry) {
	          this.method = "next";
	          this.next = finallyEntry.finallyLoc;
	          return ContinueSentinel;
	        }
	        return this.complete(record);
	      },
	      complete: function complete(record, afterLoc) {
	        if (record.type === "throw") {
	          throw record.arg;
	        }
	        if (record.type === "break" || record.type === "continue") {
	          this.next = record.arg;
	        } else if (record.type === "return") {
	          this.rval = this.arg = record.arg;
	          this.method = "return";
	          this.next = "end";
	        } else if (record.type === "normal" && afterLoc) {
	          this.next = afterLoc;
	        }
	        return ContinueSentinel;
	      },
	      finish: function finish(finallyLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          if (entry.finallyLoc === finallyLoc) {
	            this.complete(entry.completion, entry.afterLoc);
	            resetTryEntry(entry);
	            return ContinueSentinel;
	          }
	        }
	      },
	      "catch": function _catch(tryLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          if (entry.tryLoc === tryLoc) {
	            var record = entry.completion;
	            if (record.type === "throw") {
	              var thrown = record.arg;
	              resetTryEntry(entry);
	            }
	            return thrown;
	          }
	        }

	        // The context.catch method must only be called with a location
	        // argument that corresponds to a known catch block.
	        throw new Error("illegal catch attempt");
	      },
	      delegateYield: function delegateYield(iterable, resultName, nextLoc) {
	        this.delegate = {
	          iterator: values(iterable),
	          resultName: resultName,
	          nextLoc: nextLoc
	        };
	        if (this.method === "next") {
	          // Deliberately forget the last sent value so that we don't
	          // accidentally pass it on to the delegate.
	          this.arg = undefined$1;
	        }
	        return ContinueSentinel;
	      }
	    };

	    // Regardless of whether this script is executing as a CommonJS module
	    // or not, return the runtime object so that we can declare the variable
	    // regeneratorRuntime in the outer scope, which allows this module to be
	    // injected easily by `bin/regenerator --include-runtime script.js`.
	    return exports;
	  }(
	  // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	  'object' === "object" ? module.exports : {});
	  try {
	    regeneratorRuntime = runtime;
	  } catch (accidentalStrictMode) {
	    // This module should not be running in strict mode, so the above
	    // assignment should always work unless something is misconfigured. Just
	    // in case runtime.js accidentally runs in strict mode, we can escape
	    // strict mode using a global Function call. This could conceivably fail
	    // if a Content Security Policy forbids using Function, but in that case
	    // the proper solution is to fix the accidental strict mode problem. If
	    // you've misconfigured your bundler to force strict mode and applied a
	    // CSP to forbid Function, and you're not willing to fix either of those
	    // problems, please detail your unique predicament in a GitHub issue.
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	})(runtime$1);
	var runtimeExports = runtime$1.exports;
	var runtime = /*@__PURE__*/getDefaultExportFromCjs(runtimeExports);

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var EPSILON_FLOAT32$1 = 1e-7;
	var EPSILON_FLOAT16$1 = 1e-4;
	/** Convenient class for storing tensor-related data. */
	var DataStorage = /*#__PURE__*/function () {
	  function DataStorage(backend, dataMover) {
	    _classCallCheck(this, DataStorage);
	    this.backend = backend;
	    this.dataMover = dataMover;
	    this.data = new WeakMap();
	    this.dataIdsCount = 0;
	  }
	  _createClass(DataStorage, [{
	    key: "get",
	    value: function get(dataId) {
	      if (!this.data.has(dataId)) {
	        this.dataMover.moveData(this.backend, dataId);
	      }
	      return this.data.get(dataId);
	    }
	  }, {
	    key: "set",
	    value: function set(dataId, value) {
	      this.dataIdsCount++;
	      this.data.set(dataId, value);
	    }
	  }, {
	    key: "has",
	    value: function has(dataId) {
	      return this.data.has(dataId);
	    }
	  }, {
	    key: "delete",
	    value: function _delete(dataId) {
	      this.dataIdsCount--;
	      return this.data.delete(dataId);
	    }
	  }, {
	    key: "numDataIds",
	    value: function numDataIds() {
	      return this.dataIdsCount;
	    }
	  }]);
	  return DataStorage;
	}();
	/**
	 * The interface that defines the kernels that should be implemented when
	 * adding a new backend. New backends don't need to implement every one of the
	 * methods, this can be done gradually (throw an error for unimplemented
	 * methods).
	 */
	var KernelBackend = /*#__PURE__*/function () {
	  function KernelBackend() {
	    _classCallCheck(this, KernelBackend);
	  }
	  _createClass(KernelBackend, [{
	    key: "refCount",
	    value: function refCount(dataId) {
	      return notYetImplemented('refCount');
	    }
	  }, {
	    key: "incRef",
	    value: function incRef(dataId) {
	      return notYetImplemented('incRef');
	    }
	  }, {
	    key: "timerAvailable",
	    value: function timerAvailable() {
	      return true;
	    }
	  }, {
	    key: "time",
	    value: function time(f) {
	      return notYetImplemented('time');
	    }
	  }, {
	    key: "read",
	    value: function read(dataId) {
	      return notYetImplemented('read');
	    }
	  }, {
	    key: "readSync",
	    value: function readSync(dataId) {
	      return notYetImplemented('readSync');
	    }
	  }, {
	    key: "readToGPU",
	    value: function readToGPU(dataId, options) {
	      return notYetImplemented('readToGPU');
	    }
	  }, {
	    key: "numDataIds",
	    value: function numDataIds() {
	      return notYetImplemented('numDataIds');
	    }
	  }, {
	    key: "disposeData",
	    value: function disposeData(dataId, force) {
	      return notYetImplemented('disposeData');
	    }
	  }, {
	    key: "write",
	    value: function write(values, shape, dtype) {
	      return notYetImplemented('write');
	    }
	  }, {
	    key: "move",
	    value: function move(dataId, values, shape, dtype, refCount) {
	      return notYetImplemented('move');
	    }
	  }, {
	    key: "createTensorFromGPUData",
	    value: function createTensorFromGPUData(values, shape, dtype) {
	      return notYetImplemented('createTensorFromGPUData');
	    }
	  }, {
	    key: "memory",
	    value: function memory() {
	      return notYetImplemented('memory');
	    }
	    /** Returns the highest precision for floats in bits (e.g. 16 or 32) */
	  }, {
	    key: "floatPrecision",
	    value: function floatPrecision() {
	      return notYetImplemented('floatPrecision');
	    }
	    /** Returns the smallest representable number.  */
	  }, {
	    key: "epsilon",
	    value: function epsilon() {
	      return this.floatPrecision() === 32 ? EPSILON_FLOAT32$1 : EPSILON_FLOAT16$1;
	    }
	  }, {
	    key: "dispose",
	    value: function dispose() {
	      return notYetImplemented('dispose');
	    }
	  }]);
	  return KernelBackend;
	}();
	function notYetImplemented(kernelName) {
	  throw new Error("'".concat(kernelName, "' not yet implemented or not found in the registry. ") + "This kernel may not be supported by the tfjs backend you have chosen");
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Shuffles the array in-place using Fisher-Yates algorithm.
	 *
	 * ```js
	 * const a = [1, 2, 3, 4, 5];
	 * tf.util.shuffle(a);
	 * console.log(a);
	 * ```
	 *
	 * @param array The array to shuffle in-place.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	// tslint:disable-next-line:no-any
	function shuffle(array) {
	  var counter = array.length;
	  var index = 0;
	  // While there are elements in the array
	  while (counter > 0) {
	    // Pick a random index
	    index = Math.random() * counter | 0;
	    // Decrease counter by 1
	    counter--;
	    // And swap the last element with it
	    swap(array, counter, index);
	  }
	}
	/**
	 * Shuffles two arrays in-place the same way using Fisher-Yates algorithm.
	 *
	 * ```js
	 * const a = [1,2,3,4,5];
	 * const b = [11,22,33,44,55];
	 * tf.util.shuffleCombo(a, b);
	 * console.log(a, b);
	 * ```
	 *
	 * @param array The first array to shuffle in-place.
	 * @param array2 The second array to shuffle in-place with the same permutation
	 *     as the first array.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function shuffleCombo(
	// tslint:disable-next-line:no-any
	array,
	// tslint:disable-next-line:no-any
	array2) {
	  if (array.length !== array2.length) {
	    throw new Error("Array sizes must match to be shuffled together " + "First array length was ".concat(array.length) + "Second array length was ".concat(array2.length));
	  }
	  var counter = array.length;
	  var index = 0;
	  // While there are elements in the array
	  while (counter > 0) {
	    // Pick a random index
	    index = Math.random() * counter | 0;
	    // Decrease counter by 1
	    counter--;
	    // And swap the last element of each array with it
	    swap(array, counter, index);
	    swap(array2, counter, index);
	  }
	}
	/** Clamps a value to a specified range. */
	function clamp(min, x, max) {
	  return Math.max(min, Math.min(x, max));
	}
	function nearestLargerEven(val) {
	  return val % 2 === 0 ? val : val + 1;
	}
	function swap(object, left, right) {
	  var temp = object[left];
	  object[left] = object[right];
	  object[right] = temp;
	}
	function sum$4(arr) {
	  var sum = 0;
	  for (var i = 0; i < arr.length; i++) {
	    sum += arr[i];
	  }
	  return sum;
	}
	/**
	 * Returns a sample from a uniform [a, b) distribution.
	 *
	 * @param a The minimum support (inclusive).
	 * @param b The maximum support (exclusive).
	 * @return A pseudorandom number on the half-open interval [a,b).
	 */
	function randUniform(a, b) {
	  var r = Math.random();
	  return b * r + (1 - r) * a;
	}
	/** Returns the squared Euclidean distance between two vectors. */
	function distSquared(a, b) {
	  var result = 0;
	  for (var i = 0; i < a.length; i++) {
	    var diff = Number(a[i]) - Number(b[i]);
	    result += diff * diff;
	  }
	  return result;
	}
	/**
	 * Asserts that the expression is true. Otherwise throws an error with the
	 * provided message.
	 *
	 * ```js
	 * const x = 2;
	 * tf.util.assert(x === 2, 'x is not 2');
	 * ```
	 *
	 * @param expr The expression to assert (as a boolean).
	 * @param msg A function that returns the message to report when throwing an
	 *     error. We use a function for performance reasons.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function assert$1(expr, msg) {
	  if (!expr) {
	    throw new Error(typeof msg === 'string' ? msg : msg());
	  }
	}
	function assertShapesMatch(shapeA, shapeB) {
	  var errorMessagePrefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
	  assert$1(arraysEqual(shapeA, shapeB), function () {
	    return errorMessagePrefix + " Shapes ".concat(shapeA, " and ").concat(shapeB, " must match");
	  });
	}
	function assertNonNull(a) {
	  assert$1(a != null, function () {
	    return "The input to the tensor constructor must be a non-null value.";
	  });
	}
	/**
	 * Returns the size (number of elements) of the tensor given its shape.
	 *
	 * ```js
	 * const shape = [3, 4, 2];
	 * const size = tf.util.sizeFromShape(shape);
	 * console.log(size);
	 * ```
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function sizeFromShape(shape) {
	  if (shape.length === 0) {
	    // Scalar.
	    return 1;
	  }
	  var size = shape[0];
	  for (var i = 1; i < shape.length; i++) {
	    size *= shape[i];
	  }
	  return size;
	}
	function isScalarShape(shape) {
	  return shape.length === 0;
	}
	function arraysEqualWithNull(n1, n2) {
	  if (n1 === n2) {
	    return true;
	  }
	  if (n1 == null || n2 == null) {
	    return false;
	  }
	  if (n1.length !== n2.length) {
	    return false;
	  }
	  for (var i = 0; i < n1.length; i++) {
	    if (n1[i] !== null && n2[i] !== null && n1[i] !== n2[i]) {
	      return false;
	    }
	  }
	  return true;
	}
	function arraysEqual(n1, n2) {
	  if (n1 === n2) {
	    return true;
	  }
	  if (n1 == null || n2 == null) {
	    return false;
	  }
	  if (n1.length !== n2.length) {
	    return false;
	  }
	  for (var i = 0; i < n1.length; i++) {
	    if (n1[i] !== n2[i]) {
	      return false;
	    }
	  }
	  return true;
	}
	function isInt(a) {
	  return a % 1 === 0;
	}
	function tanh$3(x) {
	  // tslint:disable-next-line:no-any
	  if (Math.tanh != null) {
	    // tslint:disable-next-line:no-any
	    return Math.tanh(x);
	  }
	  if (x === Infinity) {
	    return 1;
	  } else if (x === -Infinity) {
	    return -1;
	  } else {
	    var e2x = Math.exp(2 * x);
	    return (e2x - 1) / (e2x + 1);
	  }
	}
	function sizeToSquarishShape(size) {
	  var width = Math.ceil(Math.sqrt(size));
	  return [width, Math.ceil(size / width)];
	}
	/**
	 * Creates a new array with randomized indices to a given quantity.
	 *
	 * ```js
	 * const randomTen = tf.util.createShuffledIndices(10);
	 * console.log(randomTen);
	 * ```
	 *
	 * @param number Quantity of how many shuffled indices to create.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function createShuffledIndices(n) {
	  var shuffledIndices = new Uint32Array(n);
	  for (var i = 0; i < n; ++i) {
	    shuffledIndices[i] = i;
	  }
	  shuffle(shuffledIndices);
	  return shuffledIndices;
	}
	function rightPad(a, size) {
	  if (size <= a.length) {
	    return a;
	  }
	  return a + ' '.repeat(size - a.length);
	}
	function repeatedTry(checkFn) {
	  var delayFn = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (counter) {
	    return 0;
	  };
	  var maxCounter = arguments.length > 2 ? arguments[2] : undefined;
	  var scheduleFn = arguments.length > 3 ? arguments[3] : undefined;
	  return new Promise(function (resolve, reject) {
	    var tryCount = 0;
	    var tryFn = function tryFn() {
	      if (checkFn()) {
	        resolve();
	        return;
	      }
	      tryCount++;
	      var nextBackoff = delayFn(tryCount);
	      if (maxCounter != null && tryCount >= maxCounter) {
	        reject();
	        return;
	      }
	      if (scheduleFn != null) {
	        scheduleFn(tryFn, nextBackoff);
	      } else {
	        // google3 does not allow assigning another variable to setTimeout.
	        // Don't refactor this so scheduleFn has a default value of setTimeout.
	        setTimeout(tryFn, nextBackoff);
	      }
	    };
	    tryFn();
	  });
	}
	/**
	 * Given the full size of the array and a shape that may contain -1 as the
	 * implicit dimension, returns the inferred shape where -1 is replaced.
	 * E.g. For shape=[2, -1, 3] and size=24, it will return [2, 4, 3].
	 *
	 * @param shape The shape, which may contain -1 in some dimension.
	 * @param size The full size (number of elements) of the array.
	 * @return The inferred shape where -1 is replaced with the inferred size.
	 */
	function inferFromImplicitShape(shape, size) {
	  var shapeProd = 1;
	  var implicitIdx = -1;
	  for (var i = 0; i < shape.length; ++i) {
	    if (shape[i] >= 0) {
	      shapeProd *= shape[i];
	    } else if (shape[i] === -1) {
	      if (implicitIdx !== -1) {
	        throw Error("Shapes can only have 1 implicit size. " + "Found -1 at dim ".concat(implicitIdx, " and dim ").concat(i));
	      }
	      implicitIdx = i;
	    } else if (shape[i] < 0) {
	      throw Error("Shapes can not be < 0. Found ".concat(shape[i], " at dim ").concat(i));
	    }
	  }
	  if (implicitIdx === -1) {
	    if (size > 0 && size !== shapeProd) {
	      throw Error("Size(".concat(size, ") must match the product of shape ").concat(shape));
	    }
	    return shape;
	  }
	  if (shapeProd === 0) {
	    throw Error("Cannot infer the missing size in [".concat(shape, "] when ") + "there are 0 elements");
	  }
	  if (size % shapeProd !== 0) {
	    throw Error("The implicit shape can't be a fractional number. " + "Got ".concat(size, " / ").concat(shapeProd));
	  }
	  var newShape = shape.slice();
	  newShape[implicitIdx] = size / shapeProd;
	  return newShape;
	}
	function parseAxisParam(axis, shape) {
	  var rank = shape.length;
	  // Normalize input
	  axis = axis == null ? shape.map(function (s, i) {
	    return i;
	  }) : [].concat(axis);
	  // Check for valid range
	  assert$1(axis.every(function (ax) {
	    return ax >= -rank && ax < rank;
	  }), function () {
	    return "All values in axis param must be in range [-".concat(rank, ", ").concat(rank, ") but ") + "got axis ".concat(axis);
	  });
	  // Check for only integers
	  assert$1(axis.every(function (ax) {
	    return isInt(ax);
	  }), function () {
	    return "All values in axis param must be integers but " + "got axis ".concat(axis);
	  });
	  // Handle negative axis.
	  return axis.map(function (a) {
	    return a < 0 ? rank + a : a;
	  });
	}
	/** Reduces the shape by removing all dimensions of shape 1. */
	function squeezeShape(shape, axis) {
	  var newShape = [];
	  var keptDims = [];
	  var isEmptyArray = axis != null && Array.isArray(axis) && axis.length === 0;
	  var axes = axis == null || isEmptyArray ? null : parseAxisParam(axis, shape).sort();
	  var j = 0;
	  for (var i = 0; i < shape.length; ++i) {
	    if (axes != null) {
	      if (axes[j] === i && shape[i] !== 1) {
	        throw new Error("Can't squeeze axis ".concat(i, " since its dim '").concat(shape[i], "' is not 1"));
	      }
	      if ((axes[j] == null || axes[j] > i) && shape[i] === 1) {
	        newShape.push(shape[i]);
	        keptDims.push(i);
	      }
	      if (axes[j] <= i) {
	        j++;
	      }
	    }
	    if (shape[i] !== 1) {
	      newShape.push(shape[i]);
	      keptDims.push(i);
	    }
	  }
	  return {
	    newShape: newShape,
	    keptDims: keptDims
	  };
	}
	function getTypedArrayFromDType(dtype, size) {
	  return getArrayFromDType(dtype, size);
	}
	function getArrayFromDType(dtype, size) {
	  var values = null;
	  if (dtype == null || dtype === 'float32') {
	    values = new Float32Array(size);
	  } else if (dtype === 'int32') {
	    values = new Int32Array(size);
	  } else if (dtype === 'bool') {
	    values = new Uint8Array(size);
	  } else if (dtype === 'string') {
	    values = new Array(size);
	  } else {
	    throw new Error("Unknown data type ".concat(dtype));
	  }
	  return values;
	}
	function checkConversionForErrors(vals, dtype) {
	  for (var i = 0; i < vals.length; i++) {
	    var num = vals[i];
	    if (isNaN(num) || !isFinite(num)) {
	      throw Error("A tensor of type ".concat(dtype, " being uploaded contains ").concat(num, "."));
	    }
	  }
	}
	/** Returns true if the dtype is valid. */
	function isValidDtype(dtype) {
	  return dtype === 'bool' || dtype === 'complex64' || dtype === 'float32' || dtype === 'int32' || dtype === 'string';
	}
	/**
	 * Returns true if the new type can't encode the old type without loss of
	 * precision.
	 */
	function hasEncodingLoss(oldType, newType) {
	  if (newType === 'complex64') {
	    return false;
	  }
	  if (newType === 'float32' && oldType !== 'complex64') {
	    return false;
	  }
	  if (newType === 'int32' && oldType !== 'float32' && oldType !== 'complex64') {
	    return false;
	  }
	  if (newType === 'bool' && oldType === 'bool') {
	    return false;
	  }
	  return true;
	}
	function bytesPerElement(dtype) {
	  if (dtype === 'float32' || dtype === 'int32') {
	    return 4;
	  } else if (dtype === 'complex64') {
	    return 8;
	  } else if (dtype === 'bool') {
	    return 1;
	  } else {
	    throw new Error("Unknown dtype ".concat(dtype));
	  }
	}
	/**
	 * Returns the approximate number of bytes allocated in the string array - 2
	 * bytes per character. Computing the exact bytes for a native string in JS
	 * is not possible since it depends on the encoding of the html page that
	 * serves the website.
	 */
	function bytesFromStringArray(arr) {
	  if (arr == null) {
	    return 0;
	  }
	  var bytes = 0;
	  arr.forEach(function (x) {
	    return bytes += x.length;
	  });
	  return bytes;
	}
	/** Returns true if the value is a string. */
	function isString(value) {
	  return typeof value === 'string' || value instanceof String;
	}
	function isBoolean(value) {
	  return typeof value === 'boolean';
	}
	function isNumber(value) {
	  return typeof value === 'number';
	}
	function inferDtype(values) {
	  if (Array.isArray(values)) {
	    return inferDtype(values[0]);
	  }
	  if (values instanceof Float32Array) {
	    return 'float32';
	  } else if (values instanceof Int32Array || values instanceof Uint8Array || values instanceof Uint8ClampedArray) {
	    return 'int32';
	  } else if (isNumber(values)) {
	    return 'float32';
	  } else if (isString(values)) {
	    return 'string';
	  } else if (isBoolean(values)) {
	    return 'bool';
	  }
	  return 'float32';
	}
	function isFunction(f) {
	  return !!(f && f.constructor && f.call && f.apply);
	}
	function nearestDivisor(size, start) {
	  for (var i = start; i < size; ++i) {
	    if (size % i === 0) {
	      return i;
	    }
	  }
	  return size;
	}
	function computeStrides(shape) {
	  var rank = shape.length;
	  if (rank < 2) {
	    return [];
	  }
	  // Last dimension has implicit stride of 1, thus having D-1 (instead of D)
	  // strides.
	  var strides = new Array(rank - 1);
	  strides[rank - 2] = shape[rank - 1];
	  for (var i = rank - 3; i >= 0; --i) {
	    strides[i] = strides[i + 1] * shape[i + 1];
	  }
	  return strides;
	}
	function createNestedArray(offset, shape, a) {
	  var isComplex = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  var ret = new Array();
	  if (shape.length === 1) {
	    var d = shape[0] * (isComplex ? 2 : 1);
	    for (var i = 0; i < d; i++) {
	      ret[i] = a[offset + i];
	    }
	  } else {
	    var _d = shape[0];
	    var rest = shape.slice(1);
	    var len = rest.reduce(function (acc, c) {
	      return acc * c;
	    }) * (isComplex ? 2 : 1);
	    for (var _i = 0; _i < _d; _i++) {
	      ret[_i] = createNestedArray(offset + _i * len, rest, a, isComplex);
	    }
	  }
	  return ret;
	}
	// Provide a nested array of TypedArray in given shape.
	function toNestedArray(shape, a) {
	  var isComplex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  if (shape.length === 0) {
	    // Scalar type should return a single number.
	    return a[0];
	  }
	  var size = shape.reduce(function (acc, c) {
	    return acc * c;
	  }) * (isComplex ? 2 : 1);
	  if (size === 0) {
	    // A tensor with shape zero should be turned into empty list.
	    return [];
	  }
	  if (size !== a.length) {
	    throw new Error("[".concat(shape, "] does not match the input size ").concat(a.length).concat(isComplex ? ' for a complex tensor' : '', "."));
	  }
	  return createNestedArray(0, shape, a, isComplex);
	}
	function convertBackendValuesAndArrayBuffer(data, dtype) {
	  // If is type Uint8Array[], return it directly.
	  if (Array.isArray(data)) {
	    return data;
	  }
	  if (dtype === 'float32') {
	    return data instanceof Float32Array ? data : new Float32Array(data);
	  } else if (dtype === 'int32') {
	    return data instanceof Int32Array ? data : new Int32Array(data);
	  } else if (dtype === 'bool' || dtype === 'string') {
	    return Uint8Array.from(new Int32Array(data));
	  } else {
	    throw new Error("Unknown dtype ".concat(dtype));
	  }
	}
	function makeOnesTypedArray(size, dtype) {
	  var array = makeZerosTypedArray(size, dtype);
	  for (var i = 0; i < array.length; i++) {
	    array[i] = 1;
	  }
	  return array;
	}
	function makeZerosTypedArray(size, dtype) {
	  if (dtype == null || dtype === 'float32' || dtype === 'complex64') {
	    return new Float32Array(size);
	  } else if (dtype === 'int32') {
	    return new Int32Array(size);
	  } else if (dtype === 'bool') {
	    return new Uint8Array(size);
	  } else {
	    throw new Error("Unknown data type ".concat(dtype));
	  }
	}
	/**
	 * Make nested `TypedArray` filled with zeros.
	 * @param shape The shape information for the nested array.
	 * @param dtype dtype of the array element.
	 */
	function makeZerosNestedTypedArray(shape, dtype) {
	  var size = shape.reduce(function (prev, curr) {
	    return prev * curr;
	  }, 1);
	  if (dtype == null || dtype === 'float32') {
	    return toNestedArray(shape, new Float32Array(size));
	  } else if (dtype === 'int32') {
	    return toNestedArray(shape, new Int32Array(size));
	  } else if (dtype === 'bool') {
	    return toNestedArray(shape, new Uint8Array(size));
	  } else {
	    throw new Error("Unknown data type ".concat(dtype));
	  }
	}
	function assertNonNegativeIntegerDimensions(shape) {
	  shape.forEach(function (dimSize) {
	    assert$1(Number.isInteger(dimSize) && dimSize >= 0, function () {
	      return "Tensor must have a shape comprised of positive integers but got " + "shape [".concat(shape, "].");
	    });
	  });
	}
	/**
	 * Computes flat index for a given location (multidimentionsal index) in a
	 * Tensor/multidimensional array.
	 *
	 * @param locs Location in the tensor.
	 * @param rank Rank of the tensor.
	 * @param strides Tensor strides.
	 */
	function locToIndex(locs, rank, strides) {
	  if (rank === 0) {
	    return 0;
	  } else if (rank === 1) {
	    return locs[0];
	  }
	  var index = locs[locs.length - 1];
	  for (var i = 0; i < locs.length - 1; ++i) {
	    index += strides[i] * locs[i];
	  }
	  return index;
	}
	/**
	 * Computes the location (multidimensional index) in a
	 * tensor/multidimentional array for a given flat index.
	 *
	 * @param index Index in flat array.
	 * @param rank Rank of tensor.
	 * @param strides Strides of tensor.
	 */
	function indexToLoc(index, rank, strides) {
	  if (rank === 0) {
	    return [];
	  } else if (rank === 1) {
	    return [index];
	  }
	  var locs = new Array(rank);
	  for (var i = 0; i < locs.length - 1; ++i) {
	    locs[i] = Math.floor(index / strides[i]);
	    index -= locs[i] * strides[i];
	  }
	  locs[locs.length - 1] = index;
	  return locs;
	}
	/**
	 * This method asserts whether an object is a Promise instance.
	 * @param object
	 */
	// tslint:disable-next-line: no-any
	function isPromise(object) {
	  //  We chose to not use 'obj instanceOf Promise' for two reasons:
	  //  1. It only reliably works for es6 Promise, not other Promise
	  //  implementations.
	  //  2. It doesn't work with framework that uses zone.js. zone.js monkey
	  //  patch the async calls, so it is possible the obj (patched) is
	  //  comparing to a pre-patched Promise.
	  return object && object.then && typeof object.then === 'function';
	}

	// Expects flags from URL in the format ?tfjsflags=FLAG1:1,FLAG2:true.
	var TENSORFLOWJS_FLAGS_PREFIX = 'tfjsflags';
	/**
	 * The environment contains evaluated flags as well as the registered platform.
	 * This is always used as a global singleton and can be retrieved with
	 * `tf.env()`.
	 *
	 * @doc {heading: 'Environment'}
	 */
	var Environment = /*#__PURE__*/function () {
	  // tslint:disable-next-line: no-any
	  function Environment(global) {
	    _classCallCheck(this, Environment);
	    this.global = global;
	    this.flags = {};
	    this.flagRegistry = {};
	    this.urlFlags = {};
	    // Jasmine spies on this in 'environment_test.ts'
	    this.getQueryParams = getQueryParams;
	    this.populateURLFlags();
	  }
	  _createClass(Environment, [{
	    key: "setPlatform",
	    value: function setPlatform(platformName, platform) {
	      if (this.platform != null) {
	        if (!(env().getBool('IS_TEST') || env().getBool('PROD'))) {
	          console.warn("Platform ".concat(this.platformName, " has already been set. ") + "Overwriting the platform with ".concat(platformName, "."));
	        }
	      }
	      this.platformName = platformName;
	      this.platform = platform;
	    }
	  }, {
	    key: "registerFlag",
	    value: function registerFlag(flagName, evaluationFn, setHook) {
	      this.flagRegistry[flagName] = {
	        evaluationFn: evaluationFn,
	        setHook: setHook
	      };
	      // Override the flag value from the URL. This has to happen here because
	      // the environment is initialized before flags get registered.
	      if (this.urlFlags[flagName] != null) {
	        var flagValue = this.urlFlags[flagName];
	        if (!(env().getBool('IS_TEST') || env().getBool('PROD'))) {
	          console.warn("Setting feature override from URL ".concat(flagName, ": ").concat(flagValue, "."));
	        }
	        this.set(flagName, flagValue);
	      }
	    }
	  }, {
	    key: "getAsync",
	    value: function () {
	      var _getAsync = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(flagName) {
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              if (!(flagName in this.flags)) {
	                _context.next = 2;
	                break;
	              }
	              return _context.abrupt("return", this.flags[flagName]);
	            case 2:
	              _context.next = 4;
	              return this.evaluateFlag(flagName);
	            case 4:
	              this.flags[flagName] = _context.sent;
	              return _context.abrupt("return", this.flags[flagName]);
	            case 6:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this);
	      }));
	      function getAsync(_x) {
	        return _getAsync.apply(this, arguments);
	      }
	      return getAsync;
	    }()
	  }, {
	    key: "get",
	    value: function get(flagName) {
	      if (flagName in this.flags) {
	        return this.flags[flagName];
	      }
	      var flagValue = this.evaluateFlag(flagName);
	      if (isPromise(flagValue)) {
	        throw new Error("Flag ".concat(flagName, " cannot be synchronously evaluated. ") + "Please use getAsync() instead.");
	      }
	      this.flags[flagName] = flagValue;
	      return this.flags[flagName];
	    }
	  }, {
	    key: "getNumber",
	    value: function getNumber(flagName) {
	      return this.get(flagName);
	    }
	  }, {
	    key: "getBool",
	    value: function getBool(flagName) {
	      return this.get(flagName);
	    }
	  }, {
	    key: "getString",
	    value: function getString(flagName) {
	      return this.get(flagName);
	    }
	  }, {
	    key: "getFlags",
	    value: function getFlags() {
	      return this.flags;
	    }
	    // For backwards compatibility.
	  }, {
	    key: "features",
	    get: function get() {
	      return this.flags;
	    }
	  }, {
	    key: "set",
	    value: function set(flagName, value) {
	      if (this.flagRegistry[flagName] == null) {
	        throw new Error("Cannot set flag ".concat(flagName, " as it has not been registered."));
	      }
	      this.flags[flagName] = value;
	      if (this.flagRegistry[flagName].setHook != null) {
	        this.flagRegistry[flagName].setHook(value);
	      }
	    }
	  }, {
	    key: "evaluateFlag",
	    value: function evaluateFlag(flagName) {
	      if (this.flagRegistry[flagName] == null) {
	        throw new Error("Cannot evaluate flag '".concat(flagName, "': no evaluation function found."));
	      }
	      return this.flagRegistry[flagName].evaluationFn();
	    }
	  }, {
	    key: "setFlags",
	    value: function setFlags(flags) {
	      this.flags = Object.assign({}, flags);
	    }
	  }, {
	    key: "reset",
	    value: function reset() {
	      this.flags = {};
	      this.urlFlags = {};
	      this.populateURLFlags();
	    }
	  }, {
	    key: "populateURLFlags",
	    value: function populateURLFlags() {
	      var _this = this;
	      if (typeof this.global === 'undefined' || typeof this.global.location === 'undefined' || typeof this.global.location.search === 'undefined') {
	        return;
	      }
	      var urlParams = this.getQueryParams(this.global.location.search);
	      if (TENSORFLOWJS_FLAGS_PREFIX in urlParams) {
	        var keyValues = urlParams[TENSORFLOWJS_FLAGS_PREFIX].split(',');
	        keyValues.forEach(function (keyValue) {
	          var _keyValue$split = keyValue.split(':'),
	            _keyValue$split2 = _slicedToArray(_keyValue$split, 2),
	            key = _keyValue$split2[0],
	            value = _keyValue$split2[1];
	          _this.urlFlags[key] = parseValue(key, value);
	        });
	      }
	    }
	  }]);
	  return Environment;
	}();
	function getQueryParams(queryString) {
	  var params = {};
	  queryString.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g, function (s) {
	    for (var _len = arguments.length, t = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      t[_key - 1] = arguments[_key];
	    }
	    decodeParam(params, t[0], t[1]);
	    return t.join('=');
	  });
	  return params;
	}
	function decodeParam(params, name, value) {
	  params[decodeURIComponent(name)] = decodeURIComponent(value || '');
	}
	function parseValue(flagName, value) {
	  var lowerCaseValue = value.toLowerCase();
	  if (lowerCaseValue === 'true' || lowerCaseValue === 'false') {
	    return lowerCaseValue === 'true';
	  } else if ("".concat(+lowerCaseValue) === lowerCaseValue) {
	    return +lowerCaseValue;
	  } else {
	    return value;
	  }
	}
	/**
	 * Returns the current environment (a global singleton).
	 *
	 * The environment object contains the evaluated feature values as well as the
	 * active platform.
	 *
	 * @doc {heading: 'Environment'}
	 */
	function env() {
	  return exports.ENV;
	}
	exports.ENV = null;
	function setEnvironmentGlobal(environment) {
	  exports.ENV = environment;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	// Note that the identifier globalNameSpace is scoped to this module, but will
	// always resolve to the same global object regardless of how the module is
	// resolved.
	// tslint:disable-next-line:no-any
	var globalNameSpace;
	// tslint:disable-next-line:no-any
	function getGlobalNamespace() {
	  if (globalNameSpace == null) {
	    // tslint:disable-next-line:no-any
	    var ns;
	    if (typeof window !== 'undefined') {
	      ns = window;
	    } else if (typeof global !== 'undefined') {
	      ns = global;
	    } else if (typeof process !== 'undefined') {
	      ns = process;
	    } else if (typeof self !== 'undefined') {
	      ns = self;
	    } else {
	      throw new Error('Could not find a global object');
	    }
	    globalNameSpace = ns;
	  }
	  return globalNameSpace;
	}
	// tslint:disable-next-line:no-any
	function getGlobalMap() {
	  var ns = getGlobalNamespace();
	  if (ns._tfGlobals == null) {
	    ns._tfGlobals = new Map();
	  }
	  return ns._tfGlobals;
	}
	/**
	 * Returns a globally accessible 'singleton' object.
	 *
	 * @param key the name of the object
	 * @param init a function to initialize to initialize this object
	 *             the first time it is fetched.
	 */
	function getGlobal(key, init) {
	  var globalMap = getGlobalMap();
	  if (globalMap.has(key)) {
	    return globalMap.get(key);
	  } else {
	    var singleton = init();
	    globalMap.set(key, singleton);
	    return globalMap.get(key);
	  }
	}

	var Abs = 'Abs';
	var Acos = 'Acos';
	var Acosh = 'Acosh';
	var Add$1 = 'Add';
	var AddN = 'AddN';
	var All = 'All';
	var Any = 'Any';
	var ArgMax = 'ArgMax';
	var ArgMin = 'ArgMin';
	var Asin = 'Asin';
	var Asinh = 'Asinh';
	var Atan = 'Atan';
	var Atanh = 'Atanh';
	var Atan2 = 'Atan2';
	var AvgPool = 'AvgPool';
	var AvgPoolGrad = 'AvgPoolGrad';
	var AvgPool3D = 'AvgPool3D';
	var AvgPool3DGrad = 'AvgPool3DGrad';
	var BatchMatMul = 'BatchMatMul';
	var BatchToSpaceND = 'BatchToSpaceND';
	var Bincount = 'Bincount';
	var BitwiseAnd = 'BitwiseAnd';
	var BroadcastTo = 'BroadcastTo';
	var BroadcastArgs = 'BroadcastArgs';
	var Cast = 'Cast';
	var Ceil = 'Ceil';
	var ClipByValue = 'ClipByValue';
	var Complex = 'Complex';
	var ComplexAbs = 'ComplexAbs';
	var Concat = 'Concat';
	var Conv2D$1 = 'Conv2D';
	var Conv2DBackpropFilter = 'Conv2DBackpropFilter';
	var Conv2DBackpropInput = 'Conv2DBackpropInput';
	var Conv3D$1 = 'Conv3D';
	var Conv3DBackpropFilterV2 = 'Conv3DBackpropFilterV2';
	var Conv3DBackpropInputV2 = 'Conv3DBackpropInputV2';
	var Cos = 'Cos';
	var Cosh = 'Cosh';
	var Cumprod = 'Cumprod';
	var Cumsum = 'Cumsum';
	var CropAndResize = 'CropAndResize';
	var DenseBincount = 'DenseBincount';
	var DepthToSpace = 'DepthToSpace';
	var DepthwiseConv2dNative = 'DepthwiseConv2dNative';
	var DepthwiseConv2dNativeBackpropFilter = 'DepthwiseConv2dNativeBackpropFilter';
	var DepthwiseConv2dNativeBackpropInput = 'DepthwiseConv2dNativeBackpropInput';
	var Diag = 'Diag';
	var Dilation2D = 'Dilation2D';
	var Dilation2DBackpropInput = 'Dilation2DBackpropInput';
	var Dilation2DBackpropFilter = 'Dilation2DBackpropFilter';
	var Draw = 'Draw';
	var RealDiv = 'RealDiv';
	var Einsum = 'Einsum';
	var Elu$1 = 'Elu';
	var EluGrad = 'EluGrad';
	var Erf = 'Erf';
	var Equal = 'Equal';
	var Exp = 'Exp';
	var ExpandDims = 'ExpandDims';
	var Expm1 = 'Expm1';
	var FFT = 'FFT';
	var Fill = 'Fill';
	var FlipLeftRight = 'FlipLeftRight';
	var Floor = 'Floor';
	var FloorDiv = 'FloorDiv';
	var FusedBatchNorm = 'FusedBatchNorm';
	var GatherV2 = 'GatherV2';
	var GatherNd = 'GatherNd';
	var Greater = 'Greater';
	var GreaterEqual = 'GreaterEqual';
	var Identity$1 = 'Identity';
	var IFFT = 'IFFT';
	var Imag = 'Imag';
	var IsFinite = 'IsFinite';
	var IsInf = 'IsInf';
	var IsNan = 'IsNan';
	var LeakyRelu = 'LeakyRelu';
	var Less = 'Less';
	var LessEqual = 'LessEqual';
	var LinSpace = 'LinSpace';
	var Log = 'Log';
	var Log1p = 'Log1p';
	var LogicalAnd = 'LogicalAnd';
	var LogicalNot = 'LogicalNot';
	var LogicalOr = 'LogicalOr';
	var LogicalXor = 'LogicalXor';
	var LogSoftmax$1 = 'LogSoftmax';
	var LowerBound = 'LowerBound';
	var LRN = 'LRN';
	var LRNGrad = 'LRNGrad';
	var MatrixBandPart = 'MatrixBandPart';
	var Max = 'Max';
	var Maximum$1 = 'Maximum';
	var MaxPool = 'MaxPool';
	var MaxPoolGrad = 'MaxPoolGrad';
	var MaxPool3D = 'MaxPool3D';
	var MaxPool3DGrad = 'MaxPool3DGrad';
	var MaxPoolWithArgmax = 'MaxPoolWithArgmax';
	var Mean = 'Mean';
	var Min = 'Min';
	var Minimum$1 = 'Minimum';
	var MirrorPad = 'MirrorPad';
	var Mod = 'Mod';
	var Multinomial = 'Multinomial';
	var Multiply$1 = 'Multiply';
	var Neg = 'Neg';
	var NotEqual = 'NotEqual';
	var NonMaxSuppressionV3 = 'NonMaxSuppressionV3';
	var NonMaxSuppressionV4 = 'NonMaxSuppressionV4';
	var NonMaxSuppressionV5 = 'NonMaxSuppressionV5';
	var OnesLike = 'OnesLike';
	var OneHot = 'OneHot';
	var Pack = 'Pack';
	var PadV2 = 'PadV2';
	var Pool = 'Pool';
	var Pow = 'Pow';
	var Prelu = 'Prelu';
	var Prod = 'Prod';
	var RaggedGather = 'RaggedGather';
	var RaggedRange = 'RaggedRange';
	var RaggedTensorToTensor = 'RaggedTensorToTensor';
	var Range = 'Range';
	var Real = 'Real';
	var Reciprocal = 'Reciprocal';
	var Relu$1 = 'Relu';
	var Reshape$1 = 'Reshape';
	var ResizeNearestNeighbor = 'ResizeNearestNeighbor';
	var ResizeNearestNeighborGrad = 'ResizeNearestNeighborGrad';
	var ResizeBilinear = 'ResizeBilinear';
	var ResizeBilinearGrad = 'ResizeBilinearGrad';
	var Relu6$1 = 'Relu6';
	var Reverse = 'Reverse';
	var Round = 'Round';
	var Rsqrt = 'Rsqrt';
	var ScatterNd = 'ScatterNd';
	var TensorScatterUpdate = 'TensorScatterUpdate';
	var SearchSorted = 'SearchSorted';
	var Select = 'Select';
	var Selu$1 = 'Selu';
	var Slice = 'Slice';
	var Sin = 'Sin';
	var Sinh = 'Sinh';
	var Sign = 'Sign';
	var Sigmoid$1 = 'Sigmoid';
	var Softplus$1 = 'Softplus';
	var Sqrt = 'Sqrt';
	var Sum = 'Sum';
	var SpaceToBatchND = 'SpaceToBatchND';
	var SplitV = 'SplitV';
	var Softmax$2 = 'Softmax';
	var SparseFillEmptyRows = 'SparseFillEmptyRows';
	var SparseReshape = 'SparseReshape';
	var SparseSegmentMean = 'SparseSegmentMean';
	var SparseSegmentSum = 'SparseSegmentSum';
	var SparseToDense = 'SparseToDense';
	var SquaredDifference = 'SquaredDifference';
	var Square = 'Square';
	var StaticRegexReplace = 'StaticRegexReplace';
	var StridedSlice = 'StridedSlice';
	var StringNGrams = 'StringNGrams';
	var StringSplit = 'StringSplit';
	var StringToHashBucketFast = 'StringToHashBucketFast';
	var Sub = 'Sub';
	var Tan = 'Tan';
	var Tanh$1 = 'Tanh';
	var Tile = 'Tile';
	var TopK = 'TopK';
	var Transform = 'Transform';
	var Transpose = 'Transpose';
	var Unique = 'Unique';
	var Unpack = 'Unpack';
	var UnsortedSegmentSum = 'UnsortedSegmentSum';
	var UpperBound = 'UpperBound';
	var ZerosLike = 'ZerosLike';
	/**
	 * TensorFlow.js-only kernels
	 */
	var Step = 'Step';
	var FromPixels = 'FromPixels';
	var RotateWithOffset = 'RotateWithOffset';
	var _FusedMatMul = '_FusedMatMul';
	var FusedConv2D = 'FusedConv2D';
	var FusedDepthwiseConv2D = 'FusedDepthwiseConv2D';

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function warn() {
	  if (!(env().getBool('IS_TEST') || env().getBool('PROD'))) {
	    var _console;
	    (_console = console).warn.apply(_console, arguments);
	  }
	}
	function log$3() {
	  if (!(env().getBool('IS_TEST') || env().getBool('PROD'))) {
	    var _console2;
	    (_console2 = console).log.apply(_console2, arguments);
	  }
	}

	var kernelRegistry = getGlobal('kernelRegistry', function () {
	  return new Map();
	});
	var gradRegistry = getGlobal('gradRegistry', function () {
	  return new Map();
	});
	/**
	 * Returns the kernel function (code) associated with the provided names.
	 *
	 * @param kernelName The official name of the kernel.
	 * @param backendName The official name of the backend.
	 */
	function getKernel(kernelName, backendName) {
	  var key = makeKey(kernelName, backendName);
	  return kernelRegistry.get(key);
	}
	/**
	 * Returns the registered gradient info associated with the provided kernel.
	 * @param kernelName The official TF kernel name.
	 */
	function getGradient(kernelName) {
	  return gradRegistry.get(kernelName);
	}
	function getKernelsForBackend(backendName) {
	  var it = kernelRegistry.entries();
	  var result = [];
	  while (true) {
	    var _it$next = it.next(),
	      done = _it$next.done,
	      value = _it$next.value;
	    if (done) {
	      break;
	    }
	    var _value = _slicedToArray(value, 2),
	      key = _value[0],
	      config = _value[1];
	    var _key$split = key.split('_'),
	      _key$split2 = _slicedToArray(_key$split, 1),
	      backend = _key$split2[0];
	    if (backend === backendName) {
	      result.push(config);
	    }
	  }
	  return result;
	}
	/**
	 * Registers the function (forward pass) for the kernel in a global registry.
	 *
	 * @param config A config object with the following properties:
	 * - `kernelName` The official name of the kernel.
	 * - `backendName` The official name of the backend.
	 * - `kernelFunc` The function to run during the forward pass of the kernel.
	 * - `setupFunc` Optional. Gets called once, after the backend initializes.
	 * - `disposeFunc` Optional. Gets called once, right before the backend is
	 * disposed.
	 */
	function registerKernel(config) {
	  var kernelName = config.kernelName,
	    backendName = config.backendName;
	  var key = makeKey(kernelName, backendName);
	  if (kernelRegistry.has(key)) {
	    warn("The kernel '".concat(kernelName, "' for backend ") + "'".concat(backendName, "' is already registered"));
	  }
	  kernelRegistry.set(key, config);
	}
	/**
	 * Registers a gradient function for a given kernel in the global registry,
	 * to be used during the back-propagation of that kernel.
	 *
	 * @param config An object with the following properties:
	 * - `kernelName` The name of the kernel that the gradient function is for.
	 * - `gradFunc` The function to run during back-propagation.
	 */
	function registerGradient(config) {
	  var kernelName = config.kernelName;
	  if (gradRegistry.has(kernelName)) {
	    // TODO (yassogba) after 3.0 assess whether we need to keep this gated
	    // to debug mode.
	    if (env().getBool('DEBUG')) {
	      warn("Overriding the gradient for '".concat(kernelName, "'"));
	    }
	  }
	  gradRegistry.set(kernelName, config);
	}
	/**
	 * Removes the kernel function from the registry.
	 *
	 * @param kernelName The official name of the kernel.
	 * @param backendName The official name of the backend.
	 *
	 */
	function unregisterKernel(kernelName, backendName) {
	  var key = makeKey(kernelName, backendName);
	  if (!kernelRegistry.has(key)) {
	    throw new Error("The kernel '".concat(kernelName, "' for backend ") + "'".concat(backendName, "' is not registered"));
	  }
	  kernelRegistry.delete(key);
	}
	/** Removes the registered gradient from the global registry. */
	function unregisterGradient(kernelName) {
	  if (!gradRegistry.has(kernelName)) {
	    throw new Error("The gradient '".concat(kernelName, "' for backend is not registered"));
	  }
	  gradRegistry.delete(kernelName);
	}
	/**
	 * Finds kernels that have already been registered to a backend and re-registers
	 * them for a new backend. Useful for registering custom backends.
	 * @param registeredBackendName Already registered backend.
	 * @param newBackendName New backend.
	 */
	function copyRegisteredKernels(registeredBackendName, newBackendName) {
	  var kernels = getKernelsForBackend(registeredBackendName);
	  kernels.forEach(function (kernelConfig) {
	    var newKernelConfig = Object.assign({}, kernelConfig, {
	      backendName: newBackendName
	    });
	    registerKernel(newKernelConfig);
	  });
	}
	function makeKey(kernelName, backendName) {
	  return "".concat(backendName, "_").concat(kernelName);
	}

	/**
	 * @license
	 * Copyright 2023 Google LLC.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function isTypedArrayBrowser(a) {
	  return a instanceof Float32Array || a instanceof Int32Array || a instanceof Uint8Array || a instanceof Uint8ClampedArray;
	}

	var long = Long$1;

	/**
	 * wasm optimizations, to do native i64 multiplication and divide
	 */
	var wasm = null;
	try {
	  wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11])), {}).exports;
	} catch (e) {
	  // no wasm support :(
	}

	/**
	 * Constructs a 64 bit two's-complement integer, given its low and high 32 bit values as *signed* integers.
	 *  See the from* functions below for more convenient ways of constructing Longs.
	 * @exports Long
	 * @class A Long class for representing a 64 bit two's-complement integer value.
	 * @param {number} low The low (signed) 32 bits of the long
	 * @param {number} high The high (signed) 32 bits of the long
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @constructor
	 */
	function Long$1(low, high, unsigned) {
	  /**
	   * The low 32 bits as a signed value.
	   * @type {number}
	   */
	  this.low = low | 0;

	  /**
	   * The high 32 bits as a signed value.
	   * @type {number}
	   */
	  this.high = high | 0;

	  /**
	   * Whether unsigned or not.
	   * @type {boolean}
	   */
	  this.unsigned = !!unsigned;
	}

	// The internal representation of a long is the two given signed, 32-bit values.
	// We use 32-bit pieces because these are the size of integers on which
	// Javascript performs bit-operations.  For operations like addition and
	// multiplication, we split each number into 16 bit pieces, which can easily be
	// multiplied within Javascript's floating-point representation without overflow
	// or change in sign.
	//
	// In the algorithms below, we frequently reduce the negative case to the
	// positive case by negating the input(s) and then post-processing the result.
	// Note that we must ALWAYS check specially whether those values are MIN_VALUE
	// (-2^63) because -MIN_VALUE == MIN_VALUE (since 2^63 cannot be represented as
	// a positive number, it overflows back into a negative).  Not handling this
	// case would often result in infinite recursion.
	//
	// Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the from*
	// methods on which they depend.

	/**
	 * An indicator used to reliably determine if an object is a Long or not.
	 * @type {boolean}
	 * @const
	 * @private
	 */
	Long$1.prototype.__isLong__;
	Object.defineProperty(Long$1.prototype, "__isLong__", {
	  value: true
	});

	/**
	 * @function
	 * @param {*} obj Object
	 * @returns {boolean}
	 * @inner
	 */
	function isLong(obj) {
	  return (obj && obj["__isLong__"]) === true;
	}

	/**
	 * Tests if the specified object is a Long.
	 * @function
	 * @param {*} obj Object
	 * @returns {boolean}
	 */
	Long$1.isLong = isLong;

	/**
	 * A cache of the Long representations of small integer values.
	 * @type {!Object}
	 * @inner
	 */
	var INT_CACHE = {};

	/**
	 * A cache of the Long representations of small unsigned integer values.
	 * @type {!Object}
	 * @inner
	 */
	var UINT_CACHE = {};

	/**
	 * @param {number} value
	 * @param {boolean=} unsigned
	 * @returns {!Long}
	 * @inner
	 */
	function fromInt(value, unsigned) {
	  var obj, cachedObj, cache;
	  if (unsigned) {
	    value >>>= 0;
	    if (cache = 0 <= value && value < 256) {
	      cachedObj = UINT_CACHE[value];
	      if (cachedObj) return cachedObj;
	    }
	    obj = fromBits(value, (value | 0) < 0 ? -1 : 0, true);
	    if (cache) UINT_CACHE[value] = obj;
	    return obj;
	  } else {
	    value |= 0;
	    if (cache = -128 <= value && value < 128) {
	      cachedObj = INT_CACHE[value];
	      if (cachedObj) return cachedObj;
	    }
	    obj = fromBits(value, value < 0 ? -1 : 0, false);
	    if (cache) INT_CACHE[value] = obj;
	    return obj;
	  }
	}

	/**
	 * Returns a Long representing the given 32 bit integer value.
	 * @function
	 * @param {number} value The 32 bit integer in question
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {!Long} The corresponding Long value
	 */
	Long$1.fromInt = fromInt;

	/**
	 * @param {number} value
	 * @param {boolean=} unsigned
	 * @returns {!Long}
	 * @inner
	 */
	function fromNumber(value, unsigned) {
	  if (isNaN(value)) return unsigned ? UZERO : ZERO;
	  if (unsigned) {
	    if (value < 0) return UZERO;
	    if (value >= TWO_PWR_64_DBL) return MAX_UNSIGNED_VALUE;
	  } else {
	    if (value <= -TWO_PWR_63_DBL) return MIN_VALUE;
	    if (value + 1 >= TWO_PWR_63_DBL) return MAX_VALUE;
	  }
	  if (value < 0) return fromNumber(-value, unsigned).neg();
	  return fromBits(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
	}

	/**
	 * Returns a Long representing the given value, provided that it is a finite number. Otherwise, zero is returned.
	 * @function
	 * @param {number} value The number in question
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {!Long} The corresponding Long value
	 */
	Long$1.fromNumber = fromNumber;

	/**
	 * @param {number} lowBits
	 * @param {number} highBits
	 * @param {boolean=} unsigned
	 * @returns {!Long}
	 * @inner
	 */
	function fromBits(lowBits, highBits, unsigned) {
	  return new Long$1(lowBits, highBits, unsigned);
	}

	/**
	 * Returns a Long representing the 64 bit integer that comes by concatenating the given low and high bits. Each is
	 *  assumed to use 32 bits.
	 * @function
	 * @param {number} lowBits The low 32 bits
	 * @param {number} highBits The high 32 bits
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {!Long} The corresponding Long value
	 */
	Long$1.fromBits = fromBits;

	/**
	 * @function
	 * @param {number} base
	 * @param {number} exponent
	 * @returns {number}
	 * @inner
	 */
	var pow_dbl = Math.pow; // Used 4 times (4*8 to 15+4)

	/**
	 * @param {string} str
	 * @param {(boolean|number)=} unsigned
	 * @param {number=} radix
	 * @returns {!Long}
	 * @inner
	 */
	function fromString(str, unsigned, radix) {
	  if (str.length === 0) throw Error('empty string');
	  if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity") return ZERO;
	  if (typeof unsigned === 'number') {
	    // For goog.math.long compatibility
	    radix = unsigned, unsigned = false;
	  } else {
	    unsigned = !!unsigned;
	  }
	  radix = radix || 10;
	  if (radix < 2 || 36 < radix) throw RangeError('radix');
	  var p;
	  if ((p = str.indexOf('-')) > 0) throw Error('interior hyphen');else if (p === 0) {
	    return fromString(str.substring(1), unsigned, radix).neg();
	  }

	  // Do several (8) digits each time through the loop, so as to
	  // minimize the calls to the very expensive emulated div.
	  var radixToPower = fromNumber(pow_dbl(radix, 8));
	  var result = ZERO;
	  for (var i = 0; i < str.length; i += 8) {
	    var size = Math.min(8, str.length - i),
	      value = parseInt(str.substring(i, i + size), radix);
	    if (size < 8) {
	      var power = fromNumber(pow_dbl(radix, size));
	      result = result.mul(power).add(fromNumber(value));
	    } else {
	      result = result.mul(radixToPower);
	      result = result.add(fromNumber(value));
	    }
	  }
	  result.unsigned = unsigned;
	  return result;
	}

	/**
	 * Returns a Long representation of the given string, written using the specified radix.
	 * @function
	 * @param {string} str The textual representation of the Long
	 * @param {(boolean|number)=} unsigned Whether unsigned or not, defaults to signed
	 * @param {number=} radix The radix in which the text is written (2-36), defaults to 10
	 * @returns {!Long} The corresponding Long value
	 */
	Long$1.fromString = fromString;

	/**
	 * @function
	 * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val
	 * @param {boolean=} unsigned
	 * @returns {!Long}
	 * @inner
	 */
	function fromValue(val, unsigned) {
	  if (typeof val === 'number') return fromNumber(val, unsigned);
	  if (typeof val === 'string') return fromString(val, unsigned);
	  // Throws for non-objects, converts non-instanceof Long:
	  return fromBits(val.low, val.high, typeof unsigned === 'boolean' ? unsigned : val.unsigned);
	}

	/**
	 * Converts the specified value to a Long using the appropriate from* function for its type.
	 * @function
	 * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val Value
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {!Long}
	 */
	Long$1.fromValue = fromValue;

	// NOTE: the compiler should inline these constant values below and then remove these variables, so there should be
	// no runtime penalty for these.

	/**
	 * @type {number}
	 * @const
	 * @inner
	 */
	var TWO_PWR_16_DBL = 1 << 16;

	/**
	 * @type {number}
	 * @const
	 * @inner
	 */
	var TWO_PWR_24_DBL = 1 << 24;

	/**
	 * @type {number}
	 * @const
	 * @inner
	 */
	var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;

	/**
	 * @type {number}
	 * @const
	 * @inner
	 */
	var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;

	/**
	 * @type {number}
	 * @const
	 * @inner
	 */
	var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;

	/**
	 * @type {!Long}
	 * @const
	 * @inner
	 */
	var TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);

	/**
	 * @type {!Long}
	 * @inner
	 */
	var ZERO = fromInt(0);

	/**
	 * Signed zero.
	 * @type {!Long}
	 */
	Long$1.ZERO = ZERO;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var UZERO = fromInt(0, true);

	/**
	 * Unsigned zero.
	 * @type {!Long}
	 */
	Long$1.UZERO = UZERO;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var ONE = fromInt(1);

	/**
	 * Signed one.
	 * @type {!Long}
	 */
	Long$1.ONE = ONE;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var UONE = fromInt(1, true);

	/**
	 * Unsigned one.
	 * @type {!Long}
	 */
	Long$1.UONE = UONE;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var NEG_ONE = fromInt(-1);

	/**
	 * Signed negative one.
	 * @type {!Long}
	 */
	Long$1.NEG_ONE = NEG_ONE;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var MAX_VALUE = fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0, false);

	/**
	 * Maximum signed value.
	 * @type {!Long}
	 */
	Long$1.MAX_VALUE = MAX_VALUE;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var MAX_UNSIGNED_VALUE = fromBits(0xFFFFFFFF | 0, 0xFFFFFFFF | 0, true);

	/**
	 * Maximum unsigned value.
	 * @type {!Long}
	 */
	Long$1.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;

	/**
	 * @type {!Long}
	 * @inner
	 */
	var MIN_VALUE = fromBits(0, 0x80000000 | 0, false);

	/**
	 * Minimum signed value.
	 * @type {!Long}
	 */
	Long$1.MIN_VALUE = MIN_VALUE;

	/**
	 * @alias Long.prototype
	 * @inner
	 */
	var LongPrototype = Long$1.prototype;

	/**
	 * Converts the Long to a 32 bit integer, assuming it is a 32 bit integer.
	 * @returns {number}
	 */
	LongPrototype.toInt = function toInt() {
	  return this.unsigned ? this.low >>> 0 : this.low;
	};

	/**
	 * Converts the Long to a the nearest floating-point representation of this value (double, 53 bit mantissa).
	 * @returns {number}
	 */
	LongPrototype.toNumber = function toNumber() {
	  if (this.unsigned) return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
	  return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
	};

	/**
	 * Converts the Long to a string written in the specified radix.
	 * @param {number=} radix Radix (2-36), defaults to 10
	 * @returns {string}
	 * @override
	 * @throws {RangeError} If `radix` is out of range
	 */
	LongPrototype.toString = function toString(radix) {
	  radix = radix || 10;
	  if (radix < 2 || 36 < radix) throw RangeError('radix');
	  if (this.isZero()) return '0';
	  if (this.isNegative()) {
	    // Unsigned Longs are never negative
	    if (this.eq(MIN_VALUE)) {
	      // We need to change the Long value before it can be negated, so we remove
	      // the bottom-most digit in this base and then recurse to do the rest.
	      var radixLong = fromNumber(radix),
	        div = this.div(radixLong),
	        rem1 = div.mul(radixLong).sub(this);
	      return div.toString(radix) + rem1.toInt().toString(radix);
	    } else return '-' + this.neg().toString(radix);
	  }

	  // Do several (6) digits each time through the loop, so as to
	  // minimize the calls to the very expensive emulated div.
	  var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned),
	    rem = this;
	  var result = '';
	  while (true) {
	    var remDiv = rem.div(radixToPower),
	      intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0,
	      digits = intval.toString(radix);
	    rem = remDiv;
	    if (rem.isZero()) return digits + result;else {
	      while (digits.length < 6) digits = '0' + digits;
	      result = '' + digits + result;
	    }
	  }
	};

	/**
	 * Gets the high 32 bits as a signed integer.
	 * @returns {number} Signed high bits
	 */
	LongPrototype.getHighBits = function getHighBits() {
	  return this.high;
	};

	/**
	 * Gets the high 32 bits as an unsigned integer.
	 * @returns {number} Unsigned high bits
	 */
	LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
	  return this.high >>> 0;
	};

	/**
	 * Gets the low 32 bits as a signed integer.
	 * @returns {number} Signed low bits
	 */
	LongPrototype.getLowBits = function getLowBits() {
	  return this.low;
	};

	/**
	 * Gets the low 32 bits as an unsigned integer.
	 * @returns {number} Unsigned low bits
	 */
	LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
	  return this.low >>> 0;
	};

	/**
	 * Gets the number of bits needed to represent the absolute value of this Long.
	 * @returns {number}
	 */
	LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
	  if (this.isNegative())
	    // Unsigned Longs are never negative
	    return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
	  var val = this.high != 0 ? this.high : this.low;
	  for (var bit = 31; bit > 0; bit--) if ((val & 1 << bit) != 0) break;
	  return this.high != 0 ? bit + 33 : bit + 1;
	};

	/**
	 * Tests if this Long's value equals zero.
	 * @returns {boolean}
	 */
	LongPrototype.isZero = function isZero() {
	  return this.high === 0 && this.low === 0;
	};

	/**
	 * Tests if this Long's value equals zero. This is an alias of {@link Long#isZero}.
	 * @returns {boolean}
	 */
	LongPrototype.eqz = LongPrototype.isZero;

	/**
	 * Tests if this Long's value is negative.
	 * @returns {boolean}
	 */
	LongPrototype.isNegative = function isNegative() {
	  return !this.unsigned && this.high < 0;
	};

	/**
	 * Tests if this Long's value is positive.
	 * @returns {boolean}
	 */
	LongPrototype.isPositive = function isPositive() {
	  return this.unsigned || this.high >= 0;
	};

	/**
	 * Tests if this Long's value is odd.
	 * @returns {boolean}
	 */
	LongPrototype.isOdd = function isOdd() {
	  return (this.low & 1) === 1;
	};

	/**
	 * Tests if this Long's value is even.
	 * @returns {boolean}
	 */
	LongPrototype.isEven = function isEven() {
	  return (this.low & 1) === 0;
	};

	/**
	 * Tests if this Long's value equals the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.equals = function equals(other) {
	  if (!isLong(other)) other = fromValue(other);
	  if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1) return false;
	  return this.high === other.high && this.low === other.low;
	};

	/**
	 * Tests if this Long's value equals the specified's. This is an alias of {@link Long#equals}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.eq = LongPrototype.equals;

	/**
	 * Tests if this Long's value differs from the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.notEquals = function notEquals(other) {
	  return !this.eq( /* validates */other);
	};

	/**
	 * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.neq = LongPrototype.notEquals;

	/**
	 * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.ne = LongPrototype.notEquals;

	/**
	 * Tests if this Long's value is less than the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.lessThan = function lessThan(other) {
	  return this.comp( /* validates */other) < 0;
	};

	/**
	 * Tests if this Long's value is less than the specified's. This is an alias of {@link Long#lessThan}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.lt = LongPrototype.lessThan;

	/**
	 * Tests if this Long's value is less than or equal the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
	  return this.comp( /* validates */other) <= 0;
	};

	/**
	 * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.lte = LongPrototype.lessThanOrEqual;

	/**
	 * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.le = LongPrototype.lessThanOrEqual;

	/**
	 * Tests if this Long's value is greater than the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.greaterThan = function greaterThan(other) {
	  return this.comp( /* validates */other) > 0;
	};

	/**
	 * Tests if this Long's value is greater than the specified's. This is an alias of {@link Long#greaterThan}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.gt = LongPrototype.greaterThan;

	/**
	 * Tests if this Long's value is greater than or equal the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
	  return this.comp( /* validates */other) >= 0;
	};

	/**
	 * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.gte = LongPrototype.greaterThanOrEqual;

	/**
	 * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {boolean}
	 */
	LongPrototype.ge = LongPrototype.greaterThanOrEqual;

	/**
	 * Compares this Long's value with the specified's.
	 * @param {!Long|number|string} other Other value
	 * @returns {number} 0 if they are the same, 1 if the this is greater and -1
	 *  if the given one is greater
	 */
	LongPrototype.compare = function compare(other) {
	  if (!isLong(other)) other = fromValue(other);
	  if (this.eq(other)) return 0;
	  var thisNeg = this.isNegative(),
	    otherNeg = other.isNegative();
	  if (thisNeg && !otherNeg) return -1;
	  if (!thisNeg && otherNeg) return 1;
	  // At this point the sign bits are the same
	  if (!this.unsigned) return this.sub(other).isNegative() ? -1 : 1;
	  // Both are positive if at least one is unsigned
	  return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
	};

	/**
	 * Compares this Long's value with the specified's. This is an alias of {@link Long#compare}.
	 * @function
	 * @param {!Long|number|string} other Other value
	 * @returns {number} 0 if they are the same, 1 if the this is greater and -1
	 *  if the given one is greater
	 */
	LongPrototype.comp = LongPrototype.compare;

	/**
	 * Negates this Long's value.
	 * @returns {!Long} Negated Long
	 */
	LongPrototype.negate = function negate() {
	  if (!this.unsigned && this.eq(MIN_VALUE)) return MIN_VALUE;
	  return this.not().add(ONE);
	};

	/**
	 * Negates this Long's value. This is an alias of {@link Long#negate}.
	 * @function
	 * @returns {!Long} Negated Long
	 */
	LongPrototype.neg = LongPrototype.negate;

	/**
	 * Returns the sum of this and the specified Long.
	 * @param {!Long|number|string} addend Addend
	 * @returns {!Long} Sum
	 */
	LongPrototype.add = function add(addend) {
	  if (!isLong(addend)) addend = fromValue(addend);

	  // Divide each number into 4 chunks of 16 bits, and then sum the chunks.

	  var a48 = this.high >>> 16;
	  var a32 = this.high & 0xFFFF;
	  var a16 = this.low >>> 16;
	  var a00 = this.low & 0xFFFF;
	  var b48 = addend.high >>> 16;
	  var b32 = addend.high & 0xFFFF;
	  var b16 = addend.low >>> 16;
	  var b00 = addend.low & 0xFFFF;
	  var c48 = 0,
	    c32 = 0,
	    c16 = 0,
	    c00 = 0;
	  c00 += a00 + b00;
	  c16 += c00 >>> 16;
	  c00 &= 0xFFFF;
	  c16 += a16 + b16;
	  c32 += c16 >>> 16;
	  c16 &= 0xFFFF;
	  c32 += a32 + b32;
	  c48 += c32 >>> 16;
	  c32 &= 0xFFFF;
	  c48 += a48 + b48;
	  c48 &= 0xFFFF;
	  return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
	};

	/**
	 * Returns the difference of this and the specified Long.
	 * @param {!Long|number|string} subtrahend Subtrahend
	 * @returns {!Long} Difference
	 */
	LongPrototype.subtract = function subtract(subtrahend) {
	  if (!isLong(subtrahend)) subtrahend = fromValue(subtrahend);
	  return this.add(subtrahend.neg());
	};

	/**
	 * Returns the difference of this and the specified Long. This is an alias of {@link Long#subtract}.
	 * @function
	 * @param {!Long|number|string} subtrahend Subtrahend
	 * @returns {!Long} Difference
	 */
	LongPrototype.sub = LongPrototype.subtract;

	/**
	 * Returns the product of this and the specified Long.
	 * @param {!Long|number|string} multiplier Multiplier
	 * @returns {!Long} Product
	 */
	LongPrototype.multiply = function multiply(multiplier) {
	  if (this.isZero()) return ZERO;
	  if (!isLong(multiplier)) multiplier = fromValue(multiplier);

	  // use wasm support if present
	  if (wasm) {
	    var low = wasm.mul(this.low, this.high, multiplier.low, multiplier.high);
	    return fromBits(low, wasm.get_high(), this.unsigned);
	  }
	  if (multiplier.isZero()) return ZERO;
	  if (this.eq(MIN_VALUE)) return multiplier.isOdd() ? MIN_VALUE : ZERO;
	  if (multiplier.eq(MIN_VALUE)) return this.isOdd() ? MIN_VALUE : ZERO;
	  if (this.isNegative()) {
	    if (multiplier.isNegative()) return this.neg().mul(multiplier.neg());else return this.neg().mul(multiplier).neg();
	  } else if (multiplier.isNegative()) return this.mul(multiplier.neg()).neg();

	  // If both longs are small, use float multiplication
	  if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24)) return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);

	  // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.
	  // We can skip products that would overflow.

	  var a48 = this.high >>> 16;
	  var a32 = this.high & 0xFFFF;
	  var a16 = this.low >>> 16;
	  var a00 = this.low & 0xFFFF;
	  var b48 = multiplier.high >>> 16;
	  var b32 = multiplier.high & 0xFFFF;
	  var b16 = multiplier.low >>> 16;
	  var b00 = multiplier.low & 0xFFFF;
	  var c48 = 0,
	    c32 = 0,
	    c16 = 0,
	    c00 = 0;
	  c00 += a00 * b00;
	  c16 += c00 >>> 16;
	  c00 &= 0xFFFF;
	  c16 += a16 * b00;
	  c32 += c16 >>> 16;
	  c16 &= 0xFFFF;
	  c16 += a00 * b16;
	  c32 += c16 >>> 16;
	  c16 &= 0xFFFF;
	  c32 += a32 * b00;
	  c48 += c32 >>> 16;
	  c32 &= 0xFFFF;
	  c32 += a16 * b16;
	  c48 += c32 >>> 16;
	  c32 &= 0xFFFF;
	  c32 += a00 * b32;
	  c48 += c32 >>> 16;
	  c32 &= 0xFFFF;
	  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
	  c48 &= 0xFFFF;
	  return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
	};

	/**
	 * Returns the product of this and the specified Long. This is an alias of {@link Long#multiply}.
	 * @function
	 * @param {!Long|number|string} multiplier Multiplier
	 * @returns {!Long} Product
	 */
	LongPrototype.mul = LongPrototype.multiply;

	/**
	 * Returns this Long divided by the specified. The result is signed if this Long is signed or
	 *  unsigned if this Long is unsigned.
	 * @param {!Long|number|string} divisor Divisor
	 * @returns {!Long} Quotient
	 */
	LongPrototype.divide = function divide(divisor) {
	  if (!isLong(divisor)) divisor = fromValue(divisor);
	  if (divisor.isZero()) throw Error('division by zero');

	  // use wasm support if present
	  if (wasm) {
	    // guard against signed division overflow: the largest
	    // negative number / -1 would be 1 larger than the largest
	    // positive number, due to two's complement.
	    if (!this.unsigned && this.high === -0x80000000 && divisor.low === -1 && divisor.high === -1) {
	      // be consistent with non-wasm code path
	      return this;
	    }
	    var low = (this.unsigned ? wasm.div_u : wasm.div_s)(this.low, this.high, divisor.low, divisor.high);
	    return fromBits(low, wasm.get_high(), this.unsigned);
	  }
	  if (this.isZero()) return this.unsigned ? UZERO : ZERO;
	  var approx, rem, res;
	  if (!this.unsigned) {
	    // This section is only relevant for signed longs and is derived from the
	    // closure library as a whole.
	    if (this.eq(MIN_VALUE)) {
	      if (divisor.eq(ONE) || divisor.eq(NEG_ONE)) return MIN_VALUE; // recall that -MIN_VALUE == MIN_VALUE
	      else if (divisor.eq(MIN_VALUE)) return ONE;else {
	        // At this point, we have |other| >= 2, so |this/other| < |MIN_VALUE|.
	        var halfThis = this.shr(1);
	        approx = halfThis.div(divisor).shl(1);
	        if (approx.eq(ZERO)) {
	          return divisor.isNegative() ? ONE : NEG_ONE;
	        } else {
	          rem = this.sub(divisor.mul(approx));
	          res = approx.add(rem.div(divisor));
	          return res;
	        }
	      }
	    } else if (divisor.eq(MIN_VALUE)) return this.unsigned ? UZERO : ZERO;
	    if (this.isNegative()) {
	      if (divisor.isNegative()) return this.neg().div(divisor.neg());
	      return this.neg().div(divisor).neg();
	    } else if (divisor.isNegative()) return this.div(divisor.neg()).neg();
	    res = ZERO;
	  } else {
	    // The algorithm below has not been made for unsigned longs. It's therefore
	    // required to take special care of the MSB prior to running it.
	    if (!divisor.unsigned) divisor = divisor.toUnsigned();
	    if (divisor.gt(this)) return UZERO;
	    if (divisor.gt(this.shru(1)))
	      // 15 >>> 1 = 7 ; with divisor = 8 ; true
	      return UONE;
	    res = UZERO;
	  }

	  // Repeat the following until the remainder is less than other:  find a
	  // floating-point that approximates remainder / other *from below*, add this
	  // into the result, and subtract it from the remainder.  It is critical that
	  // the approximate value is less than or equal to the real value so that the
	  // remainder never becomes negative.
	  rem = this;
	  while (rem.gte(divisor)) {
	    // Approximate the result of division. This may be a little greater or
	    // smaller than the actual value.
	    approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));

	    // We will tweak the approximate result by changing it in the 48-th digit or
	    // the smallest non-fractional digit, whichever is larger.
	    var log2 = Math.ceil(Math.log(approx) / Math.LN2),
	      delta = log2 <= 48 ? 1 : pow_dbl(2, log2 - 48),
	      // Decrease the approximation until it is smaller than the remainder.  Note
	      // that if it is too large, the product overflows and is negative.
	      approxRes = fromNumber(approx),
	      approxRem = approxRes.mul(divisor);
	    while (approxRem.isNegative() || approxRem.gt(rem)) {
	      approx -= delta;
	      approxRes = fromNumber(approx, this.unsigned);
	      approxRem = approxRes.mul(divisor);
	    }

	    // We know the answer can't be zero... and actually, zero would cause
	    // infinite recursion since we would make no progress.
	    if (approxRes.isZero()) approxRes = ONE;
	    res = res.add(approxRes);
	    rem = rem.sub(approxRem);
	  }
	  return res;
	};

	/**
	 * Returns this Long divided by the specified. This is an alias of {@link Long#divide}.
	 * @function
	 * @param {!Long|number|string} divisor Divisor
	 * @returns {!Long} Quotient
	 */
	LongPrototype.div = LongPrototype.divide;

	/**
	 * Returns this Long modulo the specified.
	 * @param {!Long|number|string} divisor Divisor
	 * @returns {!Long} Remainder
	 */
	LongPrototype.modulo = function modulo(divisor) {
	  if (!isLong(divisor)) divisor = fromValue(divisor);

	  // use wasm support if present
	  if (wasm) {
	    var low = (this.unsigned ? wasm.rem_u : wasm.rem_s)(this.low, this.high, divisor.low, divisor.high);
	    return fromBits(low, wasm.get_high(), this.unsigned);
	  }
	  return this.sub(this.div(divisor).mul(divisor));
	};

	/**
	 * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
	 * @function
	 * @param {!Long|number|string} divisor Divisor
	 * @returns {!Long} Remainder
	 */
	LongPrototype.mod = LongPrototype.modulo;

	/**
	 * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
	 * @function
	 * @param {!Long|number|string} divisor Divisor
	 * @returns {!Long} Remainder
	 */
	LongPrototype.rem = LongPrototype.modulo;

	/**
	 * Returns the bitwise NOT of this Long.
	 * @returns {!Long}
	 */
	LongPrototype.not = function not() {
	  return fromBits(~this.low, ~this.high, this.unsigned);
	};

	/**
	 * Returns the bitwise AND of this Long and the specified.
	 * @param {!Long|number|string} other Other Long
	 * @returns {!Long}
	 */
	LongPrototype.and = function and(other) {
	  if (!isLong(other)) other = fromValue(other);
	  return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
	};

	/**
	 * Returns the bitwise OR of this Long and the specified.
	 * @param {!Long|number|string} other Other Long
	 * @returns {!Long}
	 */
	LongPrototype.or = function or(other) {
	  if (!isLong(other)) other = fromValue(other);
	  return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
	};

	/**
	 * Returns the bitwise XOR of this Long and the given one.
	 * @param {!Long|number|string} other Other Long
	 * @returns {!Long}
	 */
	LongPrototype.xor = function xor(other) {
	  if (!isLong(other)) other = fromValue(other);
	  return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
	};

	/**
	 * Returns this Long with bits shifted to the left by the given amount.
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shiftLeft = function shiftLeft(numBits) {
	  if (isLong(numBits)) numBits = numBits.toInt();
	  if ((numBits &= 63) === 0) return this;else if (numBits < 32) return fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);else return fromBits(0, this.low << numBits - 32, this.unsigned);
	};

	/**
	 * Returns this Long with bits shifted to the left by the given amount. This is an alias of {@link Long#shiftLeft}.
	 * @function
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shl = LongPrototype.shiftLeft;

	/**
	 * Returns this Long with bits arithmetically shifted to the right by the given amount.
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shiftRight = function shiftRight(numBits) {
	  if (isLong(numBits)) numBits = numBits.toInt();
	  if ((numBits &= 63) === 0) return this;else if (numBits < 32) return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);else return fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
	};

	/**
	 * Returns this Long with bits arithmetically shifted to the right by the given amount. This is an alias of {@link Long#shiftRight}.
	 * @function
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shr = LongPrototype.shiftRight;

	/**
	 * Returns this Long with bits logically shifted to the right by the given amount.
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
	  if (isLong(numBits)) numBits = numBits.toInt();
	  numBits &= 63;
	  if (numBits === 0) return this;else {
	    var high = this.high;
	    if (numBits < 32) {
	      var low = this.low;
	      return fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits, this.unsigned);
	    } else if (numBits === 32) return fromBits(high, 0, this.unsigned);else return fromBits(high >>> numBits - 32, 0, this.unsigned);
	  }
	};

	/**
	 * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
	 * @function
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shru = LongPrototype.shiftRightUnsigned;

	/**
	 * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
	 * @function
	 * @param {number|!Long} numBits Number of bits
	 * @returns {!Long} Shifted Long
	 */
	LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;

	/**
	 * Converts this Long to signed.
	 * @returns {!Long} Signed long
	 */
	LongPrototype.toSigned = function toSigned() {
	  if (!this.unsigned) return this;
	  return fromBits(this.low, this.high, false);
	};

	/**
	 * Converts this Long to unsigned.
	 * @returns {!Long} Unsigned long
	 */
	LongPrototype.toUnsigned = function toUnsigned() {
	  if (this.unsigned) return this;
	  return fromBits(this.low, this.high, true);
	};

	/**
	 * Converts this Long to its byte representation.
	 * @param {boolean=} le Whether little or big endian, defaults to big endian
	 * @returns {!Array.<number>} Byte representation
	 */
	LongPrototype.toBytes = function toBytes(le) {
	  return le ? this.toBytesLE() : this.toBytesBE();
	};

	/**
	 * Converts this Long to its little endian byte representation.
	 * @returns {!Array.<number>} Little endian byte representation
	 */
	LongPrototype.toBytesLE = function toBytesLE() {
	  var hi = this.high,
	    lo = this.low;
	  return [lo & 0xff, lo >>> 8 & 0xff, lo >>> 16 & 0xff, lo >>> 24, hi & 0xff, hi >>> 8 & 0xff, hi >>> 16 & 0xff, hi >>> 24];
	};

	/**
	 * Converts this Long to its big endian byte representation.
	 * @returns {!Array.<number>} Big endian byte representation
	 */
	LongPrototype.toBytesBE = function toBytesBE() {
	  var hi = this.high,
	    lo = this.low;
	  return [hi >>> 24, hi >>> 16 & 0xff, hi >>> 8 & 0xff, hi & 0xff, lo >>> 24, lo >>> 16 & 0xff, lo >>> 8 & 0xff, lo & 0xff];
	};

	/**
	 * Creates a Long from its byte representation.
	 * @param {!Array.<number>} bytes Byte representation
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @param {boolean=} le Whether little or big endian, defaults to big endian
	 * @returns {Long} The corresponding Long value
	 */
	Long$1.fromBytes = function fromBytes(bytes, unsigned, le) {
	  return le ? Long$1.fromBytesLE(bytes, unsigned) : Long$1.fromBytesBE(bytes, unsigned);
	};

	/**
	 * Creates a Long from its little endian byte representation.
	 * @param {!Array.<number>} bytes Little endian byte representation
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {Long} The corresponding Long value
	 */
	Long$1.fromBytesLE = function fromBytesLE(bytes, unsigned) {
	  return new Long$1(bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24, bytes[4] | bytes[5] << 8 | bytes[6] << 16 | bytes[7] << 24, unsigned);
	};

	/**
	 * Creates a Long from its big endian byte representation.
	 * @param {!Array.<number>} bytes Big endian byte representation
	 * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
	 * @returns {Long} The corresponding Long value
	 */
	Long$1.fromBytesBE = function fromBytesBE(bytes, unsigned) {
	  return new Long$1(bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], unsigned);
	};
	var long$1 = /*@__PURE__*/getDefaultExportFromCjs(long);

	var LongExports = /*#__PURE__*/_mergeNamespaces({
		__proto__: null,
		default: long$1
	}, [long]);

	/**
	 * @license
	 * Copyright 2021 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	// tslint:disable-next-line
	var Long =
	// tslint:disable-next-line
	long$1 || LongExports;
	function hexToLong(hex) {
	  return Long.fromString(hex, true, 16);
	}
	// Some primes between 2^63 and 2^64 for various uses.
	// Hex 0xc3a5c85c97cb3127
	var k0 = hexToLong('c3a5c85c97cb3127');
	// Hex 0xb492b66fbe98f273
	var k1 = hexToLong('b492b66fbe98f273');
	// Hex 0x9ae16a3b2f90404f
	var k2 = hexToLong('9ae16a3b2f90404f');
	function shiftMix(val) {
	  return val.xor(val.shru(47));
	}
	function fetch$2(s, offset, numBytes) {
	  var bytes = s.slice(offset, offset + numBytes);
	  return Long.fromBytes(Array.from(bytes), true, true);
	}
	function fetch64(s, offset) {
	  return fetch$2(s, offset, 8);
	}
	function fetch32(s, offset) {
	  return fetch$2(s, offset, 4);
	}
	function rotate64(val, shift) {
	  // Avoid shifting by 64: doing so yields an undefined result.
	  return shift === 0 ? val : val.shru(shift).or(val.shl(64 - shift));
	}
	function hashLen16(u, v) {
	  var mul = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : hexToLong('9ddfea08eb382d69');
	  // Murmur-inspired hashing.
	  var a = u.xor(v).mul(mul);
	  a = a.xor(a.shru(47));
	  var b = v.xor(a).mul(mul);
	  b = b.xor(b.shru(47));
	  b = b.mul(mul);
	  return b;
	}
	// Return a 16-byte hash for 48 bytes.  Quick and dirty.
	// Callers do best to use "random-looking" values for a and b.
	function weakHashLen32WithSeeds(w, x, y, z, a, b) {
	  a = a.add(w);
	  b = rotate64(b.add(a).add(z), 21);
	  var c = a;
	  a = a.add(x);
	  a = a.add(y);
	  b = b.add(rotate64(a, 44));
	  return [a.add(z), b.add(c)];
	}
	function weakHashLen32WithSeedsStr(s, offset, a, b) {
	  return weakHashLen32WithSeeds(fetch64(s, offset), fetch64(s, offset + 8), fetch64(s, offset + 16), fetch64(s, offset + 24), a, b);
	}
	function hashLen0to16(s) {
	  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : s.length;
	  if (len >= 8) {
	    var mul = k2.add(len * 2);
	    var a = fetch64(s, 0).add(k2);
	    var b = fetch64(s, len - 8);
	    var c = rotate64(b, 37).mul(mul).add(a);
	    var d = rotate64(a, 25).add(b).mul(mul);
	    return hashLen16(c, d, mul);
	  }
	  if (len >= 4) {
	    var _mul = k2.add(len * 2);
	    var _a = fetch32(s, 0);
	    return hashLen16(_a.shl(3).add(len), fetch32(s, len - 4), _mul);
	  }
	  if (len > 0) {
	    var _a2 = s[0];
	    var _b = s[len >> 1];
	    var _c = s[len - 1];
	    var y = _a2 + (_b << 8);
	    var z = len + (_c << 2);
	    return shiftMix(k2.mul(y).xor(k0.mul(z))).mul(k2);
	  }
	  return k2;
	}
	function hashLen17to32(s) {
	  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : s.length;
	  var mul = k2.add(len * 2);
	  var a = fetch64(s, 0).mul(k1);
	  var b = fetch64(s, 8);
	  var c = fetch64(s, len - 8).mul(mul);
	  var d = fetch64(s, len - 16).mul(k2);
	  return hashLen16(rotate64(a.add(b), 43).add(rotate64(c, 30)).add(d), a.add(rotate64(b.add(k2), 18)).add(c), mul);
	}
	function hashLen33to64(s) {
	  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : s.length;
	  var mul = k2.add(len * 2);
	  var a = fetch64(s, 0).mul(k2);
	  var b = fetch64(s, 8);
	  var c = fetch64(s, len - 8).mul(mul);
	  var d = fetch64(s, len - 16).mul(k2);
	  var y = rotate64(a.add(b), 43).add(rotate64(c, 30)).add(d);
	  var z = hashLen16(y, a.add(rotate64(b.add(k2), 18)).add(c), mul);
	  var e = fetch64(s, 16).mul(mul);
	  var f = fetch64(s, 24);
	  var g = y.add(fetch64(s, len - 32)).mul(mul);
	  var h = z.add(fetch64(s, len - 24)).mul(mul);
	  return hashLen16(rotate64(e.add(f), 43).add(rotate64(g, 30)).add(h), e.add(rotate64(f.add(a), 18)).add(g), mul);
	}
	function fingerPrint64(s) {
	  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : s.length;
	  var seed = Long.fromNumber(81, true);
	  if (len <= 32) {
	    if (len <= 16) {
	      return hashLen0to16(s, len);
	    } else {
	      return hashLen17to32(s, len);
	    }
	  } else if (len <= 64) {
	    return hashLen33to64(s, len);
	  }
	  // For strings over 64 bytes we loop.  Internal state consists of
	  // 56 bytes: v, w, x, y, and z.
	  var x = seed;
	  var y = seed.mul(k1).add(113);
	  var z = shiftMix(y.mul(k2).add(113)).mul(k2);
	  var v = [Long.UZERO, Long.UZERO];
	  var w = [Long.UZERO, Long.UZERO];
	  x = x.mul(k2).add(fetch64(s, 0));
	  var offset = 0;
	  // Set end so that after the loop we have 1 to 64 bytes left to process.
	  var end = (len - 1 >> 6) * 64;
	  var last64 = end + (len - 1 & 63) - 63;
	  do {
	    x = rotate64(x.add(y).add(v[0]).add(fetch64(s, offset + 8)), 37).mul(k1);
	    y = rotate64(y.add(v[1]).add(fetch64(s, offset + 48)), 42).mul(k1);
	    x = x.xor(w[1]);
	    y = y.add(v[0]).add(fetch64(s, offset + 40));
	    z = rotate64(z.add(w[0]), 33).mul(k1);
	    v = weakHashLen32WithSeedsStr(s, offset, v[1].mul(k1), x.add(w[0]));
	    w = weakHashLen32WithSeedsStr(s, offset + 32, z.add(w[1]), y.add(fetch64(s, offset + 16)));
	    var _ref = [x, z];
	    z = _ref[0];
	    x = _ref[1];
	    offset += 64;
	  } while (offset !== end);
	  var mul = k1.add(z.and(0xff).shl(1));
	  // Point to the last 64 bytes of input.
	  offset = last64;
	  w[0] = w[0].add(len - 1 & 63);
	  v[0] = v[0].add(w[0]);
	  w[0] = w[0].add(v[0]);
	  x = rotate64(x.add(y).add(v[0]).add(fetch64(s, offset + 8)), 37).mul(mul);
	  y = rotate64(y.add(v[1]).add(fetch64(s, offset + 48)), 42).mul(mul);
	  x = x.xor(w[1].mul(9));
	  y = y.add(v[0].mul(9).add(fetch64(s, offset + 40)));
	  z = rotate64(z.add(w[0]), 33).mul(mul);
	  v = weakHashLen32WithSeedsStr(s, offset, v[1].mul(mul), x.add(w[0]));
	  w = weakHashLen32WithSeedsStr(s, offset + 32, z.add(w[1]), y.add(fetch64(s, offset + 16)));
	  var _ref2 = [x, z];
	  z = _ref2[0];
	  x = _ref2[1];
	  return hashLen16(hashLen16(v[0], w[0], mul).add(shiftMix(y).mul(k0)).add(z), hashLen16(v[1], w[1], mul).add(x), mul);
	}

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Create typed array for scalar value. Used for storing in `DataStorage`.
	 */
	function createScalarValue(value, dtype) {
	  if (dtype === 'string') {
	    return encodeString(value);
	  }
	  return toTypedArray([value], dtype);
	}
	function noConversionNeeded(a, dtype) {
	  return a instanceof Float32Array && dtype === 'float32' || a instanceof Int32Array && dtype === 'int32' || a instanceof Uint8Array && dtype === 'bool';
	}
	function toTypedArray(a, dtype) {
	  if (dtype === 'string') {
	    throw new Error('Cannot convert a string[] to a TypedArray');
	  }
	  if (Array.isArray(a)) {
	    a = flatten$2(a);
	  }
	  if (env().getBool('DEBUG')) {
	    checkConversionForErrors(a, dtype);
	  }
	  if (noConversionNeeded(a, dtype)) {
	    return a;
	  }
	  if (dtype == null || dtype === 'float32' || dtype === 'complex64') {
	    return new Float32Array(a);
	  } else if (dtype === 'int32') {
	    return new Int32Array(a);
	  } else if (dtype === 'bool') {
	    var bool = new Uint8Array(a.length);
	    for (var i = 0; i < bool.length; ++i) {
	      if (Math.round(a[i]) !== 0) {
	        bool[i] = 1;
	      }
	    }
	    return bool;
	  } else {
	    throw new Error("Unknown data type ".concat(dtype));
	  }
	}
	/**
	 * Returns the current high-resolution time in milliseconds relative to an
	 * arbitrary time in the past. It works across different platforms (node.js,
	 * browsers).
	 *
	 * ```js
	 * console.log(tf.util.now());
	 * ```
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function now() {
	  return env().platform.now();
	}
	/**
	 * Returns a platform-specific implementation of
	 * [`fetch`](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API).
	 *
	 * If `fetch` is defined on the global object (`window`, `process`, etc.),
	 * `tf.util.fetch` returns that function.
	 *
	 * If not, `tf.util.fetch` returns a platform-specific solution.
	 *
	 * ```js
	 * const resource = await tf.util.fetch('https://cdn.jsdelivr.net/npm/@tensorflow/tfjs');
	 * // handle response
	 * ```
	 *
	 * @doc {heading: 'Util'}
	 */
	function fetch$1(path, requestInits) {
	  return env().platform.fetch(path, requestInits);
	}
	/**
	 * Encodes the provided string into bytes using the provided encoding scheme.
	 *
	 * @param s The string to encode.
	 * @param encoding The encoding scheme. Defaults to utf-8.
	 *
	 * @doc {heading: 'Util'}
	 */
	function encodeString(s) {
	  var encoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'utf-8';
	  encoding = encoding || 'utf-8';
	  return env().platform.encode(s, encoding);
	}
	/**
	 * Decodes the provided bytes into a string using the provided encoding scheme.
	 * @param bytes The bytes to decode.
	 *
	 * @param encoding The encoding scheme. Defaults to utf-8.
	 *
	 * @doc {heading: 'Util'}
	 */
	function decodeString(bytes) {
	  var encoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'utf-8';
	  encoding = encoding || 'utf-8';
	  return env().platform.decode(bytes, encoding);
	}
	function isTypedArray(a) {
	  // TODO(mattsoulanille): Remove this fallback in 5.0.0
	  if (env().platform.isTypedArray != null) {
	    return env().platform.isTypedArray(a);
	  } else {
	    return isTypedArrayBrowser(a);
	  }
	}
	// NOTE: We explicitly type out what T extends instead of any so that
	// util.flatten on a nested array of number doesn't try to infer T as a
	// number[][], causing us to explicitly type util.flatten<number>().
	/**
	 *  Flattens an arbitrarily nested array.
	 *
	 * ```js
	 * const a = [[1, 2], [3, 4], [5, [6, [7]]]];
	 * const flat = tf.util.flatten(a);
	 * console.log(flat);
	 * ```
	 *
	 *  @param arr The nested array to flatten.
	 *  @param result The destination array which holds the elements.
	 *  @param skipTypedArray If true, avoids flattening the typed arrays. Defaults
	 *      to false.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	function flatten$2(arr) {
	  var result = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
	  var skipTypedArray = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  if (result == null) {
	    result = [];
	  }
	  if (typeof arr === 'boolean' || typeof arr === 'number' || typeof arr === 'string' || isPromise(arr) || arr == null || isTypedArray(arr) && skipTypedArray) {
	    result.push(arr);
	  } else if (Array.isArray(arr) || isTypedArray(arr)) {
	    for (var i = 0; i < arr.length; ++i) {
	      flatten$2(arr[i], result, skipTypedArray);
	    }
	  } else {
	    var maxIndex = -1;
	    for (var _i = 0, _Object$keys = Object.keys(arr); _i < _Object$keys.length; _i++) {
	      var key = _Object$keys[_i];
	      // 0 or positive integer.
	      if (/^([1-9]+[0-9]*|0)$/.test(key)) {
	        maxIndex = Math.max(maxIndex, Number(key));
	      }
	    }
	    for (var _i2 = 0; _i2 <= maxIndex; _i2++) {
	      // tslint:disable-next-line: no-unnecessary-type-assertion
	      flatten$2(arr[_i2], result, skipTypedArray);
	    }
	  }
	  return result;
	}

	var util = {
		__proto__: null,
		arraysEqual: arraysEqual,
		arraysEqualWithNull: arraysEqualWithNull,
		assert: assert$1,
		assertNonNegativeIntegerDimensions: assertNonNegativeIntegerDimensions,
		assertNonNull: assertNonNull,
		assertShapesMatch: assertShapesMatch,
		bytesFromStringArray: bytesFromStringArray,
		bytesPerElement: bytesPerElement,
		checkConversionForErrors: checkConversionForErrors,
		clamp: clamp,
		computeStrides: computeStrides,
		convertBackendValuesAndArrayBuffer: convertBackendValuesAndArrayBuffer,
		createScalarValue: createScalarValue,
		createShuffledIndices: createShuffledIndices,
		decodeString: decodeString,
		distSquared: distSquared,
		encodeString: encodeString,
		fetch: fetch$1,
		fingerPrint64: fingerPrint64,
		flatten: flatten$2,
		getArrayFromDType: getArrayFromDType,
		getTypedArrayFromDType: getTypedArrayFromDType,
		hasEncodingLoss: hasEncodingLoss,
		hexToLong: hexToLong,
		indexToLoc: indexToLoc,
		inferDtype: inferDtype,
		inferFromImplicitShape: inferFromImplicitShape,
		isBoolean: isBoolean,
		isFunction: isFunction,
		isInt: isInt,
		isNumber: isNumber,
		isPromise: isPromise,
		isScalarShape: isScalarShape,
		isString: isString,
		isTypedArray: isTypedArray,
		isValidDtype: isValidDtype,
		locToIndex: locToIndex,
		makeOnesTypedArray: makeOnesTypedArray,
		makeZerosNestedTypedArray: makeZerosNestedTypedArray,
		makeZerosTypedArray: makeZerosTypedArray,
		nearestDivisor: nearestDivisor,
		nearestLargerEven: nearestLargerEven,
		now: now,
		parseAxisParam: parseAxisParam,
		randUniform: randUniform,
		repeatedTry: repeatedTry,
		rightPad: rightPad,
		shuffle: shuffle,
		shuffleCombo: shuffleCombo,
		sizeFromShape: sizeFromShape,
		sizeToSquarishShape: sizeToSquarishShape,
		squeezeShape: squeezeShape,
		sum: sum$4,
		swap: swap,
		tanh: tanh$3,
		toNestedArray: toNestedArray,
		toTypedArray: toTypedArray
	};

	var Profiler = /*#__PURE__*/function () {
	  function Profiler(backendTimer, logger) {
	    _classCallCheck(this, Profiler);
	    this.backendTimer = backendTimer;
	    this.logger = logger;
	    if (logger == null) {
	      this.logger = new Logger();
	    }
	  }
	  _createClass(Profiler, [{
	    key: "profileKernel",
	    value: function profileKernel(kernelName, inputs, f) {
	      var outputs;
	      var holdResultWrapperFn = function holdResultWrapperFn() {
	        outputs = f();
	      };
	      var timer;
	      var start = now();
	      if (this.backendTimer.timerAvailable()) {
	        timer = this.backendTimer.time(holdResultWrapperFn);
	      } else {
	        holdResultWrapperFn();
	        var _iterator = _createForOfIteratorHelper(outputs),
	          _step;
	        try {
	          for (_iterator.s(); !(_step = _iterator.n()).done;) {
	            var output = _step.value;
	            output.dataSync();
	          }
	        } catch (err) {
	          _iterator.e(err);
	        } finally {
	          _iterator.f();
	        }
	        timer = Promise.resolve({
	          kernelMs: now() - start
	        });
	      }
	      if (env().getBool('CHECK_COMPUTATION_FOR_ERRORS')) {
	        var _loop = function _loop() {
	          var output = outputs[i];
	          // Dangling promise here because we don't want to propagate up
	          // asynchronicity.
	          output.data().then(function (tensorVals) {
	            checkComputationForErrors(tensorVals, output.dtype, kernelName);
	          });
	        };
	        for (var i = 0; i < outputs.length; i++) {
	          _loop();
	        }
	      }
	      var kernelProfile = {
	        kernelName: kernelName,
	        outputs: outputs,
	        inputs: inputs,
	        timeMs: timer.then(function (timing) {
	          return timing.kernelMs;
	        }),
	        extraInfo: timer.then(function (timing) {
	          return timing.getExtraProfileInfo != null ? timing.getExtraProfileInfo() : '';
	        })
	      };
	      return kernelProfile;
	    }
	  }, {
	    key: "logKernelProfile",
	    value: function logKernelProfile(kernelProfile) {
	      var _this = this;
	      var kernelName = kernelProfile.kernelName,
	        outputs = kernelProfile.outputs,
	        timeMs = kernelProfile.timeMs,
	        inputs = kernelProfile.inputs,
	        extraInfo = kernelProfile.extraInfo;
	      outputs.forEach(function (result) {
	        Promise.all([result.data(), timeMs, extraInfo]).then(function (valueContainer) {
	          _this.logger.logKernelProfile(kernelName, result, valueContainer[0], valueContainer[1], inputs, valueContainer[2]);
	        });
	      });
	    }
	  }]);
	  return Profiler;
	}();
	function checkComputationForErrors(vals, dtype, kernelName) {
	  if (dtype !== 'float32') {
	    // Only floating point computations will generate NaN values
	    return false;
	  }
	  for (var i = 0; i < vals.length; i++) {
	    var num = vals[i];
	    if (isNaN(num) || !isFinite(num)) {
	      // Throwing custom exception so behavior is testable.
	      console.warn("Found ".concat(num, " in the result of '").concat(kernelName, "'"));
	      return true;
	    }
	  }
	  return false;
	}
	var Logger = /*#__PURE__*/function () {
	  function Logger() {
	    _classCallCheck(this, Logger);
	  }
	  _createClass(Logger, [{
	    key: "logKernelProfile",
	    value: function logKernelProfile(name, result, vals, timeMs, inputs, extraInfo) {
	      var time = typeof timeMs === 'number' ? rightPad("".concat(timeMs, "ms"), 9) : timeMs['error'];
	      var paddedName = rightPad(name, 25);
	      var rank = result.rank;
	      var size = result.size;
	      var shape = rightPad(result.shape.toString(), 14);
	      var inputShapesDescription = '';
	      for (var _name in inputs) {
	        var input = inputs[_name];
	        if (input != null) {
	          // The input might be a non-tensor (e.g HTMLImageElement), in which case
	          // we claim the output shape as input shape.
	          var inputShape = input.shape || result.shape;
	          var inputRank = inputShape.length;
	          inputShapesDescription += "".concat(_name, ": ").concat(inputRank, "D ").concat(inputRank > 0 ? inputShape : '', " ");
	        }
	      }
	      console.log("%c".concat(paddedName, "\t%c").concat(time, "\t%c").concat(rank, "D ").concat(shape, "\t%c").concat(size, "\t%c").concat(inputShapesDescription, "\t%c").concat(extraInfo), 'font-weight:bold', 'color:red', 'color:blue', 'color: orange', 'color: green', 'color: steelblue');
	    }
	  }]);
	  return Logger;
	}();

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes a list of TapeNodes that connect x to y, filtering everything else
	 * out and preserving the order of the original tape elements.
	 *
	 * @param tape The tape elements to filter.
	 * @param xs The input Tensors.
	 * @param y The output Tensor.
	 */
	function getFilteredNodesXToY(tape, xs, y) {
	  // Forward pass to compute all the nodes and Tensors that are transitively a
	  // function of x.
	  var tensorsFromX = {};
	  var nodesFromX = {};
	  for (var i = 0; i < xs.length; i++) {
	    tensorsFromX[xs[i].id] = true;
	  }
	  for (var _i = 0; _i < tape.length; _i++) {
	    var node = tape[_i];
	    var nodeInputs = node.inputs;
	    for (var inputName in nodeInputs) {
	      var input = nodeInputs[inputName];
	      var anyInputFromX = false;
	      for (var j = 0; j < xs.length; j++) {
	        if (tensorsFromX[input.id]) {
	          node.outputs.forEach(function (output) {
	            return tensorsFromX[output.id] = true;
	          });
	          anyInputFromX = true;
	          nodesFromX[node.id] = true;
	          break;
	        }
	      }
	      if (anyInputFromX) {
	        break;
	      }
	    }
	  }
	  // Backward pass to find all of the nodes and Tensors that lead to y.
	  var tensorsLeadToY = {};
	  tensorsLeadToY[y.id] = true;
	  var nodesToY = {};
	  for (var _i2 = tape.length - 1; _i2 >= 0; _i2--) {
	    var _node = tape[_i2];
	    var _nodeInputs = _node.inputs;
	    // If any of the outputs lead to y, mark all of the inputs as leading to y.
	    for (var _j = 0; _j < _node.outputs.length; _j++) {
	      if (tensorsLeadToY[_node.outputs[_j].id]) {
	        for (var _inputName in _nodeInputs) {
	          tensorsLeadToY[_nodeInputs[_inputName].id] = true;
	          nodesToY[_node.id] = true;
	        }
	        break;
	      }
	    }
	  }
	  // Return the paths that come from x and lead to y.
	  var filteredTape = [];
	  for (var _i3 = 0; _i3 < tape.length; _i3++) {
	    var _node2 = tape[_i3];
	    if (nodesFromX[_node2.id] && nodesToY[_node2.id]) {
	      // Prune the inputs from the node that aren't a function of x.
	      var prunedInputs = {};
	      for (var _inputName2 in _node2.inputs) {
	        var nodeInput = _node2.inputs[_inputName2];
	        if (tensorsFromX[nodeInput.id]) {
	          prunedInputs[_inputName2] = nodeInput;
	        }
	      }
	      // Copy the node and overwrite inputsAndArgs to the pruned version.
	      var prunedNode = Object.assign({}, _node2);
	      prunedNode.inputs = prunedInputs;
	      prunedNode.outputs = _node2.outputs;
	      filteredTape.push(prunedNode);
	    }
	  }
	  return filteredTape;
	}
	/**
	 * Backpropagate gradients through the filtered TapeNodes.
	 *
	 * @param tensorAccumulatedGradientMap A map of Tensor to its gradient. This map
	 * is mutated by this method.
	 * @param filteredTape The filtered TapeNodes to backprop through.
	 */
	function backpropagateGradients(tensorAccumulatedGradientMap, filteredTape, tidy, add) {
	  var _loop = function _loop() {
	    var node = filteredTape[i];
	    var dys = [];
	    node.outputs.forEach(function (o) {
	      var gradTensor = tensorAccumulatedGradientMap[o.id];
	      if (gradTensor != null) {
	        dys.push(gradTensor);
	      } else {
	        // This particular output is not in the back-propagation subgraph, so it
	        // does not affect the final output, thus we put null for its dy.
	        dys.push(null);
	      }
	    });
	    if (node.gradient == null) {
	      throw new Error("Cannot compute gradient: gradient function not found " + "for ".concat(node.kernelName, "."));
	    }
	    // Backprop dy through this node and accumulate gradients over the inputs.
	    var inputGradients = node.gradient(dys);
	    var _loop2 = function _loop2(inputName) {
	      if (!(inputName in inputGradients)) {
	        throw new Error("Cannot backprop through input ".concat(inputName, ". ") + "Available gradients found: ".concat(Object.keys(inputGradients), "."));
	      }
	      // Call the gradient function.
	      var dx = tidy(function () {
	        return inputGradients[inputName]();
	      });
	      if (dx.dtype !== 'float32') {
	        throw new Error("Error in gradient for op ".concat(node.kernelName, ". The gradient of input ") + "".concat(inputName, " must have 'float32' dtype, but has '").concat(dx.dtype, "'"));
	      }
	      var x = node.inputs[inputName];
	      if (!arraysEqual(dx.shape, x.shape)) {
	        throw new Error("Error in gradient for op ".concat(node.kernelName, ". The gradient of input ") + "'".concat(inputName, "' has shape '").concat(dx.shape, "', which does not match ") + "the shape of the input '".concat(x.shape, "'"));
	      }
	      if (tensorAccumulatedGradientMap[x.id] == null) {
	        tensorAccumulatedGradientMap[x.id] = dx;
	      } else {
	        var curGradient = tensorAccumulatedGradientMap[x.id];
	        tensorAccumulatedGradientMap[x.id] = add(curGradient, dx);
	        curGradient.dispose();
	      }
	    };
	    for (var inputName in node.inputs) {
	      _loop2(inputName);
	    }
	  };
	  // Walk the tape backward and keep a map of Tensor to its gradient.
	  for (var i = filteredTape.length - 1; i >= 0; i--) {
	    _loop();
	  }
	}

	// Maximum number of values before we decide to show ellipsis.
	var FORMAT_LIMIT_NUM_VALS = 20;
	// Number of first and last values to show when displaying a, b,...,y, z.
	var FORMAT_NUM_FIRST_LAST_VALS = 3;
	// Number of significant digits to show.
	var FORMAT_NUM_SIG_DIGITS = 7;
	function tensorToString(vals, shape, dtype, verbose) {
	  var strides = computeStrides(shape);
	  var padPerCol = computeMaxSizePerColumn(vals, shape, dtype, strides);
	  var rank = shape.length;
	  var valsLines = subTensorToString(vals, shape, dtype, strides, padPerCol);
	  var lines = ['Tensor'];
	  if (verbose) {
	    lines.push("  dtype: ".concat(dtype));
	    lines.push("  rank: ".concat(rank));
	    lines.push("  shape: [".concat(shape, "]"));
	    lines.push("  values:");
	  }
	  lines.push(valsLines.map(function (l) {
	    return '    ' + l;
	  }).join('\n'));
	  return lines.join('\n');
	}
	function computeMaxSizePerColumn(vals, shape, dtype, strides) {
	  var n = sizeFromShape(shape);
	  var numCols = strides[strides.length - 1];
	  var padPerCol = new Array(numCols).fill(0);
	  var rank = shape.length;
	  var valuesOrTuples = dtype === 'complex64' ? createComplexTuples(vals) : vals;
	  if (rank > 1) {
	    for (var row = 0; row < n / numCols; row++) {
	      var offset = row * numCols;
	      for (var j = 0; j < numCols; j++) {
	        padPerCol[j] = Math.max(padPerCol[j], valToString(valuesOrTuples[offset + j], 0, dtype).length);
	      }
	    }
	  }
	  return padPerCol;
	}
	function valToString(val, pad, dtype) {
	  var valStr;
	  if (Array.isArray(val)) {
	    valStr = "".concat(parseFloat(val[0].toFixed(FORMAT_NUM_SIG_DIGITS)), " + ") + "".concat(parseFloat(val[1].toFixed(FORMAT_NUM_SIG_DIGITS)), "j");
	  } else if (isString(val)) {
	    valStr = "'".concat(val, "'");
	  } else if (dtype === 'bool') {
	    valStr = boolNumToString(val);
	  } else {
	    valStr = parseFloat(val.toFixed(FORMAT_NUM_SIG_DIGITS)).toString();
	  }
	  return rightPad(valStr, pad);
	}
	function boolNumToString(v) {
	  return v === 0 ? 'false' : 'true';
	}
	function subTensorToString(vals, shape, dtype, strides, padPerCol) {
	  var isLast = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
	  var storagePerElement = dtype === 'complex64' ? 2 : 1;
	  var size = shape[0];
	  var rank = shape.length;
	  if (rank === 0) {
	    if (dtype === 'complex64') {
	      var complexTuple = createComplexTuples(vals);
	      return [valToString(complexTuple[0], 0, dtype)];
	    }
	    if (dtype === 'bool') {
	      return [boolNumToString(vals[0])];
	    }
	    return [vals[0].toString()];
	  }
	  if (rank === 1) {
	    if (size > FORMAT_LIMIT_NUM_VALS) {
	      var firstValsSize = FORMAT_NUM_FIRST_LAST_VALS * storagePerElement;
	      var firstVals = Array.from(vals.slice(0, firstValsSize));
	      var lastVals = Array.from(vals.slice((size - FORMAT_NUM_FIRST_LAST_VALS) * storagePerElement, size * storagePerElement));
	      if (dtype === 'complex64') {
	        firstVals = createComplexTuples(firstVals);
	        lastVals = createComplexTuples(lastVals);
	      }
	      return ['[' + firstVals.map(function (x, i) {
	        return valToString(x, padPerCol[i], dtype);
	      }).join(', ') + ', ..., ' + lastVals.map(function (x, i) {
	        return valToString(x, padPerCol[size - FORMAT_NUM_FIRST_LAST_VALS + i], dtype);
	      }).join(', ') + ']'];
	    }
	    var displayVals = dtype === 'complex64' ? createComplexTuples(vals) : Array.from(vals);
	    return ['[' + displayVals.map(function (x, i) {
	      return valToString(x, padPerCol[i], dtype);
	    }).join(', ') + ']'];
	  }
	  // The array is rank 2 or more.
	  var subshape = shape.slice(1);
	  var substrides = strides.slice(1);
	  var stride = strides[0] * storagePerElement;
	  var lines = [];
	  if (size > FORMAT_LIMIT_NUM_VALS) {
	    for (var i = 0; i < FORMAT_NUM_FIRST_LAST_VALS; i++) {
	      var start = i * stride;
	      var end = start + stride;
	      lines.push.apply(lines, _toConsumableArray(subTensorToString(vals.slice(start, end), subshape, dtype, substrides, padPerCol, false /* isLast */)));
	    }

	    lines.push('...');
	    for (var _i = size - FORMAT_NUM_FIRST_LAST_VALS; _i < size; _i++) {
	      var _start = _i * stride;
	      var _end = _start + stride;
	      lines.push.apply(lines, _toConsumableArray(subTensorToString(vals.slice(_start, _end), subshape, dtype, substrides, padPerCol, _i === size - 1 /* isLast */)));
	    }
	  } else {
	    for (var _i2 = 0; _i2 < size; _i2++) {
	      var _start2 = _i2 * stride;
	      var _end2 = _start2 + stride;
	      lines.push.apply(lines, _toConsumableArray(subTensorToString(vals.slice(_start2, _end2), subshape, dtype, substrides, padPerCol, _i2 === size - 1 /* isLast */)));
	    }
	  }

	  var sep = rank === 2 ? ',' : '';
	  lines[0] = '[' + (size > 0 ? lines[0] + sep : '');
	  for (var _i3 = 1; _i3 < lines.length - 1; _i3++) {
	    lines[_i3] = ' ' + lines[_i3] + sep;
	  }
	  var newLineSep = ',\n';
	  for (var _i4 = 2; _i4 < rank; _i4++) {
	    newLineSep += '\n';
	  }
	  lines[lines.length - 1] = ' ' + lines[lines.length - 1] + ']' + (isLast ? '' : newLineSep);
	  return lines;
	}
	function createComplexTuples(vals) {
	  var complexTuples = [];
	  for (var i = 0; i < vals.length; i += 2) {
	    complexTuples.push([vals[i], vals[i + 1]]);
	  }
	  return complexTuples;
	}

	/**
	 * A mutable object, similar to `tf.Tensor`, that allows users to set values
	 * at locations before converting to an immutable `tf.Tensor`.
	 *
	 * See `tf.buffer` for creating a tensor buffer.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */
	var TensorBuffer = /*#__PURE__*/function () {
	  function TensorBuffer(shape, dtype, values) {
	    var _this = this;
	    _classCallCheck(this, TensorBuffer);
	    this.dtype = dtype;
	    this.shape = shape.slice();
	    this.size = sizeFromShape(shape);
	    if (values != null) {
	      var n = values.length;
	      assert$1(n === this.size, function () {
	        return "Length of values '".concat(n, "' does not match the size ") + "inferred by the shape '".concat(_this.size, "'.");
	      });
	    }
	    if (dtype === 'complex64') {
	      throw new Error("complex64 dtype TensorBuffers are not supported. Please create " + "a TensorBuffer for the real and imaginary parts separately and " + "call tf.complex(real, imag).");
	    }
	    this.values = values || getArrayFromDType(dtype, this.size);
	    this.strides = computeStrides(shape);
	  }
	  /**
	   * Sets a value in the buffer at a given location.
	   *
	   * @param value The value to set.
	   * @param locs  The location indices.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Creation'}
	   */
	  _createClass(TensorBuffer, [{
	    key: "set",
	    value: function set(value) {
	      var _this2 = this;
	      for (var _len = arguments.length, locs = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        locs[_key - 1] = arguments[_key];
	      }
	      if (locs.length === 0) {
	        locs = [0];
	      }
	      assert$1(locs.length === this.rank, function () {
	        return "The number of provided coordinates (".concat(locs.length, ") must ") + "match the rank (".concat(_this2.rank, ")");
	      });
	      var index = this.locToIndex(locs);
	      this.values[index] = value;
	    }
	    /**
	     * Returns the value in the buffer at the provided location.
	     *
	     * @param locs The location indices.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Creation'}
	     */
	  }, {
	    key: "get",
	    value: function get() {
	      for (var _len2 = arguments.length, locs = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	        locs[_key2] = arguments[_key2];
	      }
	      if (locs.length === 0) {
	        locs = [0];
	      }
	      var i = 0;
	      for (var _i = 0, _locs = locs; _i < _locs.length; _i++) {
	        var loc = _locs[_i];
	        if (loc < 0 || loc >= this.shape[i]) {
	          var msg = "Requested out of range element at ".concat(locs, ". ") + "  Buffer shape=".concat(this.shape);
	          throw new Error(msg);
	        }
	        i++;
	      }
	      var index = locs[locs.length - 1];
	      for (var _i2 = 0; _i2 < locs.length - 1; ++_i2) {
	        index += this.strides[_i2] * locs[_i2];
	      }
	      return this.values[index];
	    }
	  }, {
	    key: "locToIndex",
	    value: function locToIndex(locs) {
	      if (this.rank === 0) {
	        return 0;
	      } else if (this.rank === 1) {
	        return locs[0];
	      }
	      var index = locs[locs.length - 1];
	      for (var i = 0; i < locs.length - 1; ++i) {
	        index += this.strides[i] * locs[i];
	      }
	      return index;
	    }
	  }, {
	    key: "indexToLoc",
	    value: function indexToLoc(index) {
	      if (this.rank === 0) {
	        return [];
	      } else if (this.rank === 1) {
	        return [index];
	      }
	      var locs = new Array(this.shape.length);
	      for (var i = 0; i < locs.length - 1; ++i) {
	        locs[i] = Math.floor(index / this.strides[i]);
	        index -= locs[i] * this.strides[i];
	      }
	      locs[locs.length - 1] = index;
	      return locs;
	    }
	  }, {
	    key: "rank",
	    get: function get() {
	      return this.shape.length;
	    }
	    /**
	     * Creates an immutable `tf.Tensor` object from the buffer.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Creation'}
	     */
	  }, {
	    key: "toTensor",
	    value: function toTensor() {
	      return trackerFn().makeTensor(this.values, this.shape, this.dtype);
	    }
	  }]);
	  return TensorBuffer;
	}();
	// For tracking tensor creation and disposal.
	var trackerFn = null;
	// Used by chaining methods to call into ops.
	var opHandler$1 = null;
	// Used to warn about deprecated methods.
	var deprecationWarningFn = null;
	// This here so that we can use this method on dev branches and keep the
	// functionality at master.
	// tslint:disable-next-line:no-unused-expression
	[deprecationWarningFn];
	/**
	 * An external consumer can register itself as the tensor tracker. This way
	 * the Tensor class can notify the tracker for every tensor created and
	 * disposed.
	 */
	function setTensorTracker(fn) {
	  trackerFn = fn;
	}
	/**
	 * An external consumer can register itself as the op handler. This way the
	 * Tensor class can have chaining methods that call into ops via the op
	 * handler.
	 */
	function setOpHandler(handler) {
	  opHandler$1 = handler;
	}
	/**
	 * Sets the deprecation warning function to be used by this file. This way the
	 * Tensor class can be a leaf but still use the environment.
	 */
	function setDeprecationWarningFn(fn) {
	  deprecationWarningFn = fn;
	}
	/**
	 * A `tf.Tensor` object represents an immutable, multidimensional array of
	 * numbers that has a shape and a data type.
	 *
	 * For performance reasons, functions that create tensors do not necessarily
	 * perform a copy of the data passed to them (e.g. if the data is passed as a
	 * `Float32Array`), and changes to the data will change the tensor. This is not
	 * a feature and is not supported. To avoid this behavior, use the tensor before
	 * changing the input data or create a copy with `copy = tf.add(yourTensor, 0)`.
	 *
	 * See `tf.tensor` for details on how to create a `tf.Tensor`.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */
	var Tensor = /*#__PURE__*/function () {
	  function Tensor(shape, dtype, dataId, id) {
	    _classCallCheck(this, Tensor);
	    /** Whether this tensor has been globally kept. */
	    this.kept = false;
	    this.isDisposedInternal = false;
	    this.shape = shape.slice();
	    this.dtype = dtype || 'float32';
	    this.size = sizeFromShape(shape);
	    this.strides = computeStrides(shape);
	    this.dataId = dataId;
	    this.id = id;
	    this.rankType = this.rank < 5 ? this.rank.toString() : 'higher';
	  }
	  _createClass(Tensor, [{
	    key: "rank",
	    get: function get() {
	      return this.shape.length;
	    }
	    /**
	     * Returns a promise of `tf.TensorBuffer` that holds the underlying data.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "buffer",
	    value: function () {
	      var _buffer = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
	        var vals;
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              _context.next = 2;
	              return this.data();
	            case 2:
	              vals = _context.sent;
	              return _context.abrupt("return", opHandler$1.buffer(this.shape, this.dtype, vals));
	            case 4:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this);
	      }));
	      function buffer() {
	        return _buffer.apply(this, arguments);
	      }
	      return buffer;
	    }()
	    /**
	     * Returns a `tf.TensorBuffer` that holds the underlying data.
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "bufferSync",
	    value: function bufferSync() {
	      return opHandler$1.buffer(this.shape, this.dtype, this.dataSync());
	    }
	    /**
	     * Returns the tensor data as a nested array. The transfer of data is done
	     * asynchronously.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "array",
	    value: function () {
	      var _array = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
	        var vals;
	        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
	          while (1) switch (_context2.prev = _context2.next) {
	            case 0:
	              _context2.next = 2;
	              return this.data();
	            case 2:
	              vals = _context2.sent;
	              return _context2.abrupt("return", toNestedArray(this.shape, vals, this.dtype === 'complex64'));
	            case 4:
	            case "end":
	              return _context2.stop();
	          }
	        }, _callee2, this);
	      }));
	      function array() {
	        return _array.apply(this, arguments);
	      }
	      return array;
	    }()
	    /**
	     * Returns the tensor data as a nested array. The transfer of data is done
	     * synchronously.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "arraySync",
	    value: function arraySync() {
	      return toNestedArray(this.shape, this.dataSync(), this.dtype === 'complex64');
	    }
	    /**
	     * Asynchronously downloads the values from the `tf.Tensor`. Returns a
	     * promise of `TypedArray` that resolves when the computation has finished.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "data",
	    value: function () {
	      var _data = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
	        var data, bytes;
	        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
	          while (1) switch (_context3.prev = _context3.next) {
	            case 0:
	              this.throwIfDisposed();
	              data = trackerFn().read(this.dataId);
	              if (!(this.dtype === 'string')) {
	                _context3.next = 13;
	                break;
	              }
	              _context3.next = 5;
	              return data;
	            case 5:
	              bytes = _context3.sent;
	              _context3.prev = 6;
	              return _context3.abrupt("return", bytes.map(function (b) {
	                return decodeString(b);
	              }));
	            case 10:
	              _context3.prev = 10;
	              _context3.t0 = _context3["catch"](6);
	              throw new Error('Failed to decode the string bytes into utf-8. ' + 'To get the original bytes, call tensor.bytes().');
	            case 13:
	              return _context3.abrupt("return", data);
	            case 14:
	            case "end":
	              return _context3.stop();
	          }
	        }, _callee3, this, [[6, 10]]);
	      }));
	      function data() {
	        return _data.apply(this, arguments);
	      }
	      return data;
	    }()
	    /**
	     * Copy the tensor's data to a new GPU resource. Comparing to the `dataSync()`
	     * and `data()`, this method prevents data from being downloaded to CPU.
	     *
	     * For WebGL backend, the data will be stored on a densely packed texture.
	     * This means that the texture will use the RGBA channels to store value.
	     *
	     * For WebGPU backend, the data will be stored on a buffer. There is no
	     * parameter, so can not use a user-defined size to create the buffer.
	     *
	     * @param options:
	     *     For WebGL,
	     *         - customTexShape: Optional. If set, will use the user defined
	     *     texture shape to create the texture.
	     *
	     * @returns For WebGL backend, a GPUData contains the new texture and
	     *     its information.
	     *     {
	     *        tensorRef: The tensor that is associated with this texture,
	     *        texture: WebGLTexture,
	     *        texShape: [number, number] // [height, width]
	     *     }
	     *
	     *     For WebGPU backend, a GPUData contains the new buffer.
	     *     {
	     *        tensorRef: The tensor that is associated with this buffer,
	     *        buffer: GPUBuffer,
	     *     }
	     *
	     *     Remember to dispose the GPUData after it is used by
	     *     `res.tensorRef.dispose()`.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "dataToGPU",
	    value: function dataToGPU(options) {
	      this.throwIfDisposed();
	      return trackerFn().readToGPU(this.dataId, options);
	    }
	    /**
	     * Synchronously downloads the values from the `tf.Tensor`. This blocks the
	     * UI thread until the values are ready, which can cause performance issues.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "dataSync",
	    value: function dataSync() {
	      this.throwIfDisposed();
	      var data = trackerFn().readSync(this.dataId);
	      if (this.dtype === 'string') {
	        try {
	          return data.map(function (b) {
	            return decodeString(b);
	          });
	        } catch (_a) {
	          throw new Error('Failed to decode the string bytes into utf-8. ' + 'To get the original bytes, call tensor.bytes().');
	        }
	      }
	      return data;
	    }
	    /** Returns the underlying bytes of the tensor's data. */
	  }, {
	    key: "bytes",
	    value: function () {
	      var _bytes = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
	        var data;
	        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
	          while (1) switch (_context4.prev = _context4.next) {
	            case 0:
	              this.throwIfDisposed();
	              _context4.next = 3;
	              return trackerFn().read(this.dataId);
	            case 3:
	              data = _context4.sent;
	              if (!(this.dtype === 'string')) {
	                _context4.next = 8;
	                break;
	              }
	              return _context4.abrupt("return", data);
	            case 8:
	              return _context4.abrupt("return", new Uint8Array(data.buffer));
	            case 9:
	            case "end":
	              return _context4.stop();
	          }
	        }, _callee4, this);
	      }));
	      function bytes() {
	        return _bytes.apply(this, arguments);
	      }
	      return bytes;
	    }()
	    /**
	     * Disposes `tf.Tensor` from memory.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "dispose",
	    value: function dispose() {
	      if (this.isDisposed) {
	        return;
	      }
	      if (this.kerasMask) {
	        this.kerasMask.dispose();
	      }
	      trackerFn().disposeTensor(this);
	      this.isDisposedInternal = true;
	    }
	  }, {
	    key: "isDisposed",
	    get: function get() {
	      return this.isDisposedInternal;
	    }
	  }, {
	    key: "throwIfDisposed",
	    value: function throwIfDisposed() {
	      if (this.isDisposed) {
	        throw new Error("Tensor is disposed.");
	      }
	    }
	    /**
	     * Prints the `tf.Tensor`. See `tf.print` for details.
	     *
	     * @param verbose Whether to print verbose information about the tensor,
	     *    including dtype and size.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "print",
	    value: function print() {
	      var verbose = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      return opHandler$1.print(this, verbose);
	    }
	    /**
	     * Returns a copy of the tensor. See `tf.clone` for details.
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "clone",
	    value: function clone() {
	      this.throwIfDisposed();
	      return opHandler$1.clone(this);
	    }
	    /**
	     * Returns a human-readable description of the tensor. Useful for logging.
	     *
	     * @doc {heading: 'Tensors', subheading: 'Classes'}
	     */
	  }, {
	    key: "toString",
	    value: function toString() {
	      var verbose = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      var vals = this.dataSync();
	      return tensorToString(vals, this.shape, this.dtype, verbose);
	    }
	  }, {
	    key: "cast",
	    value: function cast(dtype) {
	      this.throwIfDisposed();
	      return opHandler$1.cast(this, dtype);
	    }
	  }, {
	    key: "variable",
	    value: function variable() {
	      var trainable = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      var name = arguments.length > 1 ? arguments[1] : undefined;
	      var dtype = arguments.length > 2 ? arguments[2] : undefined;
	      this.throwIfDisposed();
	      return trackerFn().makeVariable(this, trainable, name, dtype);
	    }
	  }]);
	  return Tensor;
	}();
	Object.defineProperty(Tensor, Symbol.hasInstance, {
	  value: function value(instance) {
	    // Implementation note: we should use properties of the object that will be
	    // defined before the constructor body has finished executing (methods).
	    // This is because when this code is transpiled by babel, babel will call
	    // classCallCheck before the constructor body is run.
	    // See https://github.com/tensorflow/tfjs/issues/3384 for backstory.
	    return !!instance && instance.data != null && instance.dataSync != null && instance.throwIfDisposed != null;
	  }
	});
	function getGlobalTensorClass() {
	  // Use getGlobal so that we can augment the Tensor class across package
	  // boundaries because the node resolution alg may result in different modules
	  // being returned for this file depending on the path they are loaded from.
	  return getGlobal('Tensor', function () {
	    return Tensor;
	  });
	}
	// Global side effect. Cache global reference to Tensor class
	getGlobalTensorClass();
	/**
	 * A mutable `tf.Tensor`, useful for persisting state, e.g. for training.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */
	var Variable = /*#__PURE__*/function (_Tensor) {
	  _inherits(Variable, _Tensor);
	  var _super = _createSuper(Variable);
	  function Variable(initialValue, trainable, name, tensorId) {
	    var _this3;
	    _classCallCheck(this, Variable);
	    _this3 = _super.call(this, initialValue.shape, initialValue.dtype, initialValue.dataId, tensorId);
	    _this3.trainable = trainable;
	    _this3.name = name;
	    return _this3;
	  }
	  /**
	   * Assign a new `tf.Tensor` to this variable. The new `tf.Tensor` must have
	   * the same shape and dtype as the old `tf.Tensor`.
	   *
	   * @param newValue New tensor to be assigned to this variable.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  _createClass(Variable, [{
	    key: "assign",
	    value: function assign(newValue) {
	      if (newValue.dtype !== this.dtype) {
	        throw new Error("dtype of the new value (".concat(newValue.dtype, ") and ") + "previous value (".concat(this.dtype, ") must match"));
	      }
	      if (!arraysEqual(newValue.shape, this.shape)) {
	        throw new Error("shape of the new value (".concat(newValue.shape, ") and ") + "previous value (".concat(this.shape, ") must match"));
	      }
	      trackerFn().disposeTensor(this);
	      this.dataId = newValue.dataId;
	      trackerFn().incRef(this, null /* backend */);
	    }
	  }, {
	    key: "dispose",
	    value: function dispose() {
	      trackerFn().disposeVariable(this);
	      this.isDisposedInternal = true;
	    }
	  }]);
	  return Variable;
	}(Tensor);
	Object.defineProperty(Variable, Symbol.hasInstance, {
	  value: function value(instance) {
	    return instance instanceof Tensor && instance.assign != null && instance.assign instanceof Function;
	  }
	});

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	exports.Rank = void 0;
	(function (Rank) {
	  Rank["R0"] = "R0";
	  Rank["R1"] = "R1";
	  Rank["R2"] = "R2";
	  Rank["R3"] = "R3";
	  Rank["R4"] = "R4";
	  Rank["R5"] = "R5";
	  Rank["R6"] = "R6";
	})(exports.Rank || (exports.Rank = {}));
	// Looks for upcasting types. Used, for example, in operations with mixed dtype
	// inputs.
	var UpcastInt32AndMap;
	(function (UpcastInt32AndMap) {
	  UpcastInt32AndMap["float32"] = "float32";
	  UpcastInt32AndMap["int32"] = "int32";
	  UpcastInt32AndMap["bool"] = "int32";
	  UpcastInt32AndMap["complex64"] = "complex64";
	})(UpcastInt32AndMap || (UpcastInt32AndMap = {}));
	var UpcastBoolAndMap;
	(function (UpcastBoolAndMap) {
	  UpcastBoolAndMap["float32"] = "float32";
	  UpcastBoolAndMap["int32"] = "int32";
	  UpcastBoolAndMap["bool"] = "bool";
	  UpcastBoolAndMap["complex64"] = "complex64";
	})(UpcastBoolAndMap || (UpcastBoolAndMap = {}));
	var UpcastFloat32AndMap;
	(function (UpcastFloat32AndMap) {
	  UpcastFloat32AndMap["float32"] = "float32";
	  UpcastFloat32AndMap["int32"] = "float32";
	  UpcastFloat32AndMap["bool"] = "float32";
	  UpcastFloat32AndMap["complex64"] = "complex64";
	})(UpcastFloat32AndMap || (UpcastFloat32AndMap = {}));
	var UpcastComplex64AndMap;
	(function (UpcastComplex64AndMap) {
	  UpcastComplex64AndMap["float32"] = "complex64";
	  UpcastComplex64AndMap["int32"] = "complex64";
	  UpcastComplex64AndMap["bool"] = "complex64";
	  UpcastComplex64AndMap["complex64"] = "complex64";
	})(UpcastComplex64AndMap || (UpcastComplex64AndMap = {}));
	var upcastTypeMap = {
	  'float32': UpcastFloat32AndMap,
	  'int32': UpcastInt32AndMap,
	  'bool': UpcastBoolAndMap,
	  'complex64': UpcastComplex64AndMap
	};
	function upcastType(typeA, typeB) {
	  if (typeA === 'string' || typeB === 'string') {
	    if (typeA === 'string' && typeB === 'string') {
	      return 'string';
	    }
	    throw new Error("Can not upcast ".concat(typeA, " with ").concat(typeB));
	  }
	  return upcastTypeMap[typeA][typeB];
	}
	/** Returns the output type after summation. */
	function sumOutType(type) {
	  return upcastType(type, 'int32');
	}
	function isWebGLData(values) {
	  return values != null && _typeof(values) === 'object' && 'texture' in values && values.texture instanceof WebGLTexture;
	}
	function isWebGPUData(values) {
	  return typeof GPUBuffer !== 'undefined' && values != null && _typeof(values) === 'object' && 'buffer' in values && values.buffer instanceof GPUBuffer;
	}

	function makeTypesMatch(a, b) {
	  if (a.dtype === b.dtype) {
	    return [a, b];
	  }
	  var dtype = upcastType(a.dtype, b.dtype);
	  return [a.cast(dtype), b.cast(dtype)];
	}
	function assertTypesMatch(a, b) {
	  assert$1(a.dtype === b.dtype, function () {
	    return "The dtypes of the first(".concat(a.dtype, ") and") + " second(".concat(b.dtype, ") input must match");
	  });
	}
	function isTensorInList(tensor, tensorList) {
	  return tensorList.some(function (x) {
	    return x.id === tensor.id;
	  });
	}
	/**
	 * Extracts any `Tensor`s found within the provided object.
	 *
	 * @param container an object that may be a `Tensor` or may directly contain
	 *   `Tensor`s, such as a `Tensor[]` or `{key: Tensor, ...}`. In general it
	 *   is safe to pass any object here, except that `Promise`s are not
	 *   supported.
	 * @returns An array of `Tensors` found within the passed object. If the
	 *   argument is simply a `Tensor', a list containing that `Tensor` is
	 *   returned. If the object is not a `Tensor` or does not
	 *   contain `Tensors`, an empty list is returned.
	 */
	function getTensorsInContainer(result) {
	  var list = [];
	  var seen = new Set();
	  walkTensorContainer(result, list, seen);
	  return list;
	}
	function walkTensorContainer(container, list, seen) {
	  if (container == null) {
	    return;
	  }
	  if (container instanceof Tensor) {
	    list.push(container);
	    return;
	  }
	  if (!isIterable$1(container)) {
	    return;
	  }
	  // Iteration over keys works also for arrays.
	  var iterable = container;
	  for (var k in iterable) {
	    var val = iterable[k];
	    if (!seen.has(val)) {
	      seen.add(val);
	      walkTensorContainer(val, list, seen);
	    }
	  }
	}
	// tslint:disable-next-line:no-any
	function isIterable$1(obj) {
	  return Array.isArray(obj) || _typeof(obj) === 'object';
	}

	var tensor_util = {
		__proto__: null,
		assertTypesMatch: assertTypesMatch,
		getTensorsInContainer: getTensorsInContainer,
		isTensorInList: isTensorInList,
		makeTypesMatch: makeTypesMatch
	};

	function isRegisteredKernelInvocation(kernelInvocation) {
	  return kernelInvocation.kernelName != null;
	}
	var EngineState = /*#__PURE__*/function () {
	  function EngineState() {
	    _classCallCheck(this, EngineState);
	    // Public since optimizers will use it.
	    this.registeredVariables = {};
	    this.nextTapeNodeId = 0;
	    this.numBytes = 0;
	    this.numTensors = 0;
	    this.numStringTensors = 0;
	    this.numDataBuffers = 0;
	    // Number of nested tf.grad() statements when computing higher-order
	    // gradients. E.g. `1` for first-order gradients and `2` for second-order
	    // gradients. Used to track if the tape should be removed after a backprop.
	    this.gradientDepth = 0;
	    // Number of nested kernel calls. When kernel depth is greater than 1, we turn
	    // off the tape.
	    this.kernelDepth = 0;
	    this.scopeStack = [];
	    /**
	     * Keeps track of the number of data moves during a kernel execution. We
	     * maintain a stack since kernels can call other kernels, recursively.
	     */
	    this.numDataMovesStack = [];
	    this.nextScopeId = 0;
	    this.tensorInfo = new WeakMap();
	    this.profiling = false;
	    this.activeProfile = {
	      newBytes: 0,
	      newTensors: 0,
	      peakBytes: 0,
	      kernels: [],
	      result: null,
	      get kernelNames() {
	        return Array.from(new Set(this.kernels.map(function (k) {
	          return k.name;
	        })));
	      }
	    };
	  }
	  _createClass(EngineState, [{
	    key: "dispose",
	    value: function dispose() {
	      for (var variableName in this.registeredVariables) {
	        this.registeredVariables[variableName].dispose();
	      }
	    }
	  }]);
	  return EngineState;
	}();
	var Engine = /*#__PURE__*/function () {
	  function Engine(ENV) {
	    _classCallCheck(this, Engine);
	    this.ENV = ENV;
	    this.registry = {};
	    this.registryFactory = {};
	    this.pendingBackendInitId = 0;
	    this.state = new EngineState();
	  }
	  _createClass(Engine, [{
	    key: "ready",
	    value: function () {
	      var _ready = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
	        var sortedBackends, i, backendName, success;
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              if (!(this.pendingBackendInit != null)) {
	                _context.next = 2;
	                break;
	              }
	              return _context.abrupt("return", this.pendingBackendInit.then(function () {}));
	            case 2:
	              if (!(this.backendInstance != null)) {
	                _context.next = 4;
	                break;
	              }
	              return _context.abrupt("return");
	            case 4:
	              sortedBackends = this.getSortedBackends();
	              i = 0;
	            case 6:
	              if (!(i < sortedBackends.length)) {
	                _context.next = 18;
	                break;
	              }
	              backendName = sortedBackends[i];
	              _context.next = 10;
	              return this.initializeBackend(backendName).success;
	            case 10:
	              success = _context.sent;
	              if (!success) {
	                _context.next = 15;
	                break;
	              }
	              _context.next = 14;
	              return this.setBackend(backendName);
	            case 14:
	              return _context.abrupt("return");
	            case 15:
	              i++;
	              _context.next = 6;
	              break;
	            case 18:
	              throw new Error("Could not initialize any backends, all backend initializations " + "failed.");
	            case 19:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this);
	      }));
	      function ready() {
	        return _ready.apply(this, arguments);
	      }
	      return ready;
	    }()
	  }, {
	    key: "backend",
	    get: function get() {
	      if (this.pendingBackendInit != null) {
	        throw new Error("Backend '".concat(this.backendName, "' has not yet been initialized. Make ") + "sure to await tf.ready() or await tf.setBackend() before calling " + "other methods");
	      }
	      if (this.backendInstance == null) {
	        var _this$initializeBacke = this.initializeBackendsAndReturnBest(),
	          name = _this$initializeBacke.name,
	          asyncInit = _this$initializeBacke.asyncInit;
	        if (asyncInit) {
	          throw new Error("The highest priority backend '".concat(name, "' has not yet been ") + "initialized. Make sure to await tf.ready() or " + "await tf.setBackend() before calling other methods");
	        }
	        this.setBackend(name);
	      }
	      return this.backendInstance;
	    }
	  }, {
	    key: "backendNames",
	    value: function backendNames() {
	      return Object.keys(this.registryFactory);
	    }
	  }, {
	    key: "findBackend",
	    value: function findBackend(backendName) {
	      if (!(backendName in this.registry)) {
	        // If the backend hasn't been initialized but we have a registry entry for
	        // it, initialize it and return it.
	        if (backendName in this.registryFactory) {
	          var _this$initializeBacke2 = this.initializeBackend(backendName),
	            asyncInit = _this$initializeBacke2.asyncInit;
	          if (asyncInit) {
	            // Backend is not ready yet.
	            return null;
	          }
	        } else {
	          return null;
	        }
	      }
	      return this.registry[backendName];
	    }
	  }, {
	    key: "findBackendFactory",
	    value: function findBackendFactory(backendName) {
	      if (!(backendName in this.registryFactory)) {
	        return null;
	      }
	      return this.registryFactory[backendName].factory;
	    }
	  }, {
	    key: "registerBackend",
	    value: function registerBackend(backendName, factory) {
	      var priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
	      if (backendName in this.registryFactory) {
	        warn("".concat(backendName, " backend was already registered. ") + "Reusing existing backend factory.");
	        return false;
	      }
	      this.registryFactory[backendName] = {
	        factory: factory,
	        priority: priority
	      };
	      return true;
	    }
	  }, {
	    key: "setBackend",
	    value: function () {
	      var _setBackend = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(backendName) {
	        var _this$initializeBacke3, success, asyncInit, result;
	        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
	          while (1) switch (_context2.prev = _context2.next) {
	            case 0:
	              if (!(this.registryFactory[backendName] == null)) {
	                _context2.next = 2;
	                break;
	              }
	              throw new Error("Backend name '".concat(backendName, "' not found in registry"));
	            case 2:
	              this.backendName = backendName;
	              if (!(this.registry[backendName] == null)) {
	                _context2.next = 16;
	                break;
	              }
	              this.backendInstance = null;
	              _this$initializeBacke3 = this.initializeBackend(backendName), success = _this$initializeBacke3.success, asyncInit = _this$initializeBacke3.asyncInit;
	              if (!asyncInit) {
	                _context2.next = 12;
	                break;
	              }
	              _context2.next = 9;
	              return success;
	            case 9:
	              _context2.t0 = _context2.sent;
	              _context2.next = 13;
	              break;
	            case 12:
	              _context2.t0 = success;
	            case 13:
	              result = _context2.t0;
	              if (result) {
	                _context2.next = 16;
	                break;
	              }
	              return _context2.abrupt("return", false);
	            case 16:
	              this.backendInstance = this.registry[backendName];
	              this.setupRegisteredKernels();
	              // Reset the profiler.
	              this.profiler = new Profiler(this.backendInstance);
	              return _context2.abrupt("return", true);
	            case 20:
	            case "end":
	              return _context2.stop();
	          }
	        }, _callee2, this);
	      }));
	      function setBackend(_x) {
	        return _setBackend.apply(this, arguments);
	      }
	      return setBackend;
	    }()
	  }, {
	    key: "setupRegisteredKernels",
	    value: function setupRegisteredKernels() {
	      var _this = this;
	      var kernels = getKernelsForBackend(this.backendName);
	      kernels.forEach(function (kernel) {
	        if (kernel.setupFunc != null) {
	          kernel.setupFunc(_this.backendInstance);
	        }
	      });
	    }
	  }, {
	    key: "disposeRegisteredKernels",
	    value: function disposeRegisteredKernels(backendName) {
	      var _this2 = this;
	      var kernels = getKernelsForBackend(backendName);
	      kernels.forEach(function (kernel) {
	        if (kernel.disposeFunc != null) {
	          kernel.disposeFunc(_this2.registry[backendName]);
	        }
	      });
	    }
	    /**
	     * Initializes a backend by looking up the backend name in the factory
	     * registry and calling the factory method. Returns a boolean representing
	     * whether the initialization of the backend succeeded. Throws an error if
	     * there is no backend in the factory registry.
	     */
	  }, {
	    key: "initializeBackend",
	    value: function initializeBackend(backendName) {
	      var _this3 = this;
	      var registryFactoryEntry = this.registryFactory[backendName];
	      if (registryFactoryEntry == null) {
	        throw new Error("Cannot initialize backend ".concat(backendName, ", no registration found."));
	      }
	      try {
	        var backend = registryFactoryEntry.factory();
	        /* Test if the factory returns a promise.
	        Done in a more liberal way than
	        previous 'Promise.resolve(backend)===backend'
	        as we needed to account for custom Promise
	        implementations (e.g. Angular) */
	        if (backend && !(backend instanceof KernelBackend) && typeof backend.then === 'function') {
	          var promiseId = ++this.pendingBackendInitId;
	          var success = backend.then(function (backendInstance) {
	            // Outdated promise. Another backend was set in the meantime.
	            if (promiseId < _this3.pendingBackendInitId) {
	              return false;
	            }
	            _this3.registry[backendName] = backendInstance;
	            _this3.pendingBackendInit = null;
	            return true;
	          }).catch(function (err) {
	            // Outdated promise. Another backend was set in the meantime.
	            if (promiseId < _this3.pendingBackendInitId) {
	              return false;
	            }
	            _this3.pendingBackendInit = null;
	            warn("Initialization of backend ".concat(backendName, " failed"));
	            warn(err.stack || err.message);
	            return false;
	          });
	          this.pendingBackendInit = success;
	          return {
	            success: success,
	            asyncInit: true
	          };
	        } else {
	          this.registry[backendName] = backend;
	          return {
	            success: true,
	            asyncInit: false
	          };
	        }
	      } catch (err) {
	        warn("Initialization of backend ".concat(backendName, " failed"));
	        warn(err.stack || err.message);
	        return {
	          success: false,
	          asyncInit: false
	        };
	      }
	    }
	  }, {
	    key: "removeBackend",
	    value: function removeBackend(backendName) {
	      if (!(backendName in this.registryFactory)) {
	        throw new Error("".concat(backendName, " backend not found in registry"));
	      }
	      if (this.backendName === backendName && this.pendingBackendInit != null) {
	        // There is a pending promise of the backend we want to remove. Make it
	        // obsolete.
	        this.pendingBackendInitId++;
	      }
	      if (backendName in this.registry) {
	        this.disposeRegisteredKernels(backendName);
	        this.registry[backendName].dispose();
	        delete this.registry[backendName];
	      }
	      delete this.registryFactory[backendName];
	      // Unset the backend if it is active.
	      if (this.backendName === backendName) {
	        this.pendingBackendInit = null;
	        this.backendName = null;
	        this.backendInstance = null;
	      }
	    }
	  }, {
	    key: "getSortedBackends",
	    value: function getSortedBackends() {
	      var _this4 = this;
	      if (Object.keys(this.registryFactory).length === 0) {
	        throw new Error('No backend found in registry.');
	      }
	      return Object.keys(this.registryFactory).sort(function (a, b) {
	        // Highest priority comes first.
	        return _this4.registryFactory[b].priority - _this4.registryFactory[a].priority;
	      });
	    }
	  }, {
	    key: "initializeBackendsAndReturnBest",
	    value: function initializeBackendsAndReturnBest() {
	      var sortedBackends = this.getSortedBackends();
	      for (var i = 0; i < sortedBackends.length; i++) {
	        var backendName = sortedBackends[i];
	        var _this$initializeBacke4 = this.initializeBackend(backendName),
	          success = _this$initializeBacke4.success,
	          asyncInit = _this$initializeBacke4.asyncInit;
	        if (asyncInit || success) {
	          return {
	            name: backendName,
	            asyncInit: asyncInit
	          };
	        }
	      }
	      throw new Error("Could not initialize any backends, all backend initializations " + "failed.");
	    }
	  }, {
	    key: "moveData",
	    value: function moveData(backend, dataId) {
	      var info = this.state.tensorInfo.get(dataId);
	      var srcBackend = info.backend;
	      var values = this.readSync(dataId);
	      var refCount = srcBackend.refCount(dataId);
	      // Delete the tensor from the old backend and move it to the new
	      // backend.
	      srcBackend.disposeData(dataId, true);
	      info.backend = backend;
	      backend.move(dataId, values, info.shape, info.dtype, refCount);
	      if (this.shouldCheckForMemLeaks()) {
	        // Track the number of moves during a kernel execution to correctly
	        // detect memory leaks.
	        this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1]++;
	      }
	    }
	  }, {
	    key: "tidy",
	    value: function tidy(nameOrFn, fn) {
	      var _this5 = this;
	      var name = null;
	      if (fn == null) {
	        // Called with only 1 argument.
	        if (typeof nameOrFn !== 'function') {
	          throw new Error('Please provide a function to tidy()');
	        }
	        fn = nameOrFn;
	      } else {
	        // Called with 2 arguments.
	        if (typeof nameOrFn !== 'string' && !(nameOrFn instanceof String)) {
	          throw new Error('When calling with two arguments, the first argument ' + 'to tidy() must be a string');
	        }
	        if (typeof fn !== 'function') {
	          throw new Error('When calling with two arguments, the 2nd argument ' + 'to tidy() must be a function');
	        }
	        name = nameOrFn;
	        // TODO(nsthorat,smilkov): Do operation logging and performance
	        // profiling.
	      }

	      var result;
	      return this.scopedRun(function () {
	        return _this5.startScope(name);
	      }, function () {
	        return _this5.endScope(result);
	      }, function () {
	        result = fn();
	        if (result instanceof Promise) {
	          console.error('Cannot return a Promise inside of tidy.');
	        }
	        return result;
	      });
	    }
	  }, {
	    key: "scopedRun",
	    value: function scopedRun(start, end, f) {
	      start();
	      try {
	        var res = f();
	        end();
	        return res;
	      } catch (ex) {
	        end();
	        throw ex;
	      }
	    }
	  }, {
	    key: "nextTensorId",
	    value: function nextTensorId() {
	      return Engine.nextTensorId++;
	    }
	  }, {
	    key: "nextVariableId",
	    value: function nextVariableId() {
	      return Engine.nextVariableId++;
	    }
	    /**
	     * This method is called instead of the public-facing tensor.clone() when
	     * saving a tensor for backwards pass. It makes sure to add the clone
	     * operation to the tape regardless of being called inside a kernel
	     * execution.
	     */
	  }, {
	    key: "clone",
	    value: function clone(x) {
	      var y = ENGINE.runKernel(Identity$1, {
	        x: x
	      });
	      var inputs = {
	        x: x
	      };
	      var grad = function grad(dy) {
	        return {
	          x: function x() {
	            var dtype = 'float32';
	            var gradInputs = {
	              x: dy
	            };
	            var attrs = {
	              dtype: dtype
	            };
	            return ENGINE.runKernel(Cast, gradInputs,
	            // tslint:disable-next-line: no-unnecessary-type-assertion
	            attrs);
	          }
	        };
	      };
	      var saved = [];
	      this.addTapeNode(this.state.activeScope.name, inputs, [y], grad, saved, {});
	      return y;
	    }
	    /**
	     * Execute a kernel with the given name and return the output tensor.
	     *
	     * @param kernelName The name of the kernel to execute.
	     * @param inputs A map of input names to tensors.
	     * @param attrs A map of attribute names to their values. An attribute is a
	     *     primitive (non-tensor) input to the kernel.
	     * @param inputsToSave A list of tensors, inputs to save for the backprop
	     *     computation.
	     * @param outputsToSave A list of booleans, specifying which output to save
	     *     for the backprop computation. These are booleans since the output
	     * tensors are not visible to the user.
	     */
	  }, {
	    key: "runKernel",
	    value: function runKernel(kernelName, inputs, attrs) {
	      if (this.backendName == null) {
	        // backend has not been initialized yet (backend initialization is lazy
	        // can be deferred until an op/ kernel is run).
	        // The below getter has side effects that will try to initialize the
	        // backend and set properties like this.backendName
	        // tslint:disable-next-line: no-unused-expression
	        this.backend;
	      }
	      var hasKernel = getKernel(kernelName, this.backendName) != null;
	      if (!hasKernel) {
	        throw new Error("Kernel '".concat(kernelName, "' not registered for backend '").concat(this.backendName, "'"));
	      }
	      return this.runKernelFunc({
	        kernelName: kernelName,
	        inputs: inputs,
	        attrs: attrs
	      });
	    }
	  }, {
	    key: "shouldCheckForMemLeaks",
	    value: function shouldCheckForMemLeaks() {
	      return this.ENV.getBool('IS_TEST');
	    }
	  }, {
	    key: "checkKernelForMemLeak",
	    value: function checkKernelForMemLeak(kernelName, numDataIdsBefore, outInfos) {
	      var numDataIdsAfter = this.backend.numDataIds();
	      // Count the number of data ids associated with the result of the kernel.
	      var numOutputDataIds = 0;
	      outInfos.forEach(function (info) {
	        // Complex numbers allocate 3 data ids, one for 'real', one for
	        // 'imaginary', and one for the container that holds the former two.
	        numOutputDataIds += info.dtype === 'complex64' ? 3 : 1;
	      });
	      // Account for the number of moves during kernel execution. A "data move"
	      // can happen in the middle of a kernel execution, placing a new (key,value)
	      // pair in the data storage. Since data moves have net zero effect (we
	      // always remove the data from the old backend), we have to cancel them out
	      // when detecting memory leaks.
	      var numMoves = this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1];
	      var dataIdsLeaked = numDataIdsAfter - numDataIdsBefore - numOutputDataIds - numMoves;
	      if (dataIdsLeaked > 0) {
	        throw new Error("Backend '".concat(this.backendName, "' has an internal memory leak ") + "(".concat(dataIdsLeaked, " data ids) after running '").concat(kernelName, "'"));
	      }
	    }
	    /**
	     * Internal helper method to execute a kernel Func
	     *
	     * Use `runKernel` to execute kernels from outside of engine.
	     */
	  }, {
	    key: "runKernelFunc",
	    value: function runKernelFunc(kernelParams) {
	      var _this6 = this;
	      var outputs;
	      var saved = [];
	      var isTapeOn = this.isTapeOn();
	      var startingBytecount = this.state.numBytes;
	      var startingNumTensors = this.state.numTensors;
	      if (this.shouldCheckForMemLeaks()) {
	        this.state.numDataMovesStack.push(0);
	      }
	      var kernelFunc;
	      if (this.backendName == null) {
	        // backend has not been initialized yet (backend initialization is lazy
	        // can be deferred until an op/ kernel is run).
	        // The below getter has side effects that will try to initialize the
	        // backend and set properties like this.backendName
	        // tslint:disable-next-line: no-unused-expression
	        this.backend;
	      }
	      var out;
	      var kernelOrScopeName = isRegisteredKernelInvocation(kernelParams) ? kernelParams.kernelName : this.state.activeScope != null ? this.state.activeScope.name : '';
	      // Create the kernelFunc from either a registered kernel OR passed in
	      // forward/backward functions (used by custom grad). In this context a
	      // kernelFunc wraps a kernel implementation with some bookkeeping.
	      if (isRegisteredKernelInvocation(kernelParams)) {
	        var kernelName = kernelParams.kernelName,
	          _inputs = kernelParams.inputs,
	          _attrs = kernelParams.attrs;
	        if (this.backendName == null) {
	          // backend has not been initialized yet (backend initialization is lazy
	          // can be deferred until an op/ kernel is run).
	          // The below getter has side effects that will try to initialize the
	          // backend and set properties like this.backendName
	          // tslint:disable-next-line: no-unused-expression
	          this.backend;
	        }
	        var kernel = getKernel(kernelName, this.backendName);
	        assert$1(kernel != null, function () {
	          return "Cannot find registered kernel '".concat(kernelName, "' for backend '").concat(_this6.backendName, "'");
	        });
	        kernelFunc = function kernelFunc() {
	          var numDataIdsBefore = _this6.backend.numDataIds();
	          out = kernel.kernelFunc({
	            inputs: _inputs,
	            attrs: _attrs,
	            backend: _this6.backend
	          });
	          var outInfos = Array.isArray(out) ? out : [out];
	          if (_this6.shouldCheckForMemLeaks()) {
	            _this6.checkKernelForMemLeak(kernelName, numDataIdsBefore, outInfos);
	          }
	          var outTensors = outInfos.map(function (outInfo) {
	            // todo (yassogba) remove this option (Tensor) when node backend
	            // methods have been modularized and they all return tensorInfo.
	            // TensorInfos do not have a rank attribute.
	            if (outInfo.rank != null) {
	              return outInfo;
	            }
	            return _this6.makeTensorFromTensorInfo(outInfo);
	          });
	          // Save any required inputs and outputs.
	          // Do not save unless we are recording to the tape. Otherwise it would
	          // cause a mem leak since there would be no backprop for these tensors
	          // (which would otherwise dispose them).
	          if (isTapeOn) {
	            var tensorsToSave = _this6.getTensorsForGradient(kernelName, _inputs, outTensors);
	            saved = _this6.saveTensorsForBackwardMode(tensorsToSave);
	          }
	          return outTensors;
	        };
	      } else {
	        var forwardFunc = kernelParams.forwardFunc;
	        // Running a customGrad op.
	        var saveFunc = function saveFunc(tensors) {
	          // Do not save unless we are recording to the tape. Otherwise it would
	          // cause a mem leak since we would never run backprop, which disposes
	          // the kept tensors.
	          if (!isTapeOn) {
	            return;
	          }
	          saved = tensors.map(function (tensor) {
	            return _this6.keep(_this6.clone(tensor));
	          });
	        };
	        kernelFunc = function kernelFunc() {
	          var numDataIdsBefore = _this6.backend.numDataIds();
	          out = _this6.tidy(function () {
	            return forwardFunc(_this6.backend, saveFunc);
	          });
	          var outs = Array.isArray(out) ? out : [out];
	          if (_this6.shouldCheckForMemLeaks()) {
	            // Scope name is used to print a more helpful error message if needed.
	            _this6.checkKernelForMemLeak(kernelOrScopeName, numDataIdsBefore, outs);
	          }
	          return outs;
	        };
	      }
	      //
	      // Run the kernelFunc. Optionally profiling it.
	      //
	      var inputs = kernelParams.inputs,
	        attrs = kernelParams.attrs;
	      var backwardsFunc = isRegisteredKernelInvocation(kernelParams) ? null : kernelParams.backwardsFunc;
	      var kernelProfile;
	      this.scopedRun(
	      // Stop recording to a tape when running a kernel.
	      function () {
	        return _this6.state.kernelDepth++;
	      }, function () {
	        return _this6.state.kernelDepth--;
	      }, function () {
	        if (!_this6.ENV.getBool('DEBUG') && !_this6.state.profiling) {
	          outputs = kernelFunc();
	        } else {
	          kernelProfile = _this6.profiler.profileKernel(kernelOrScopeName, inputs, function () {
	            return kernelFunc();
	          });
	          if (_this6.ENV.getBool('DEBUG')) {
	            _this6.profiler.logKernelProfile(kernelProfile);
	          }
	          outputs = kernelProfile.outputs;
	        }
	      });
	      if (isTapeOn) {
	        this.addTapeNode(kernelOrScopeName, inputs, outputs, backwardsFunc, saved, attrs);
	      }
	      if (this.state.profiling) {
	        this.state.activeProfile.kernels.push({
	          name: kernelOrScopeName,
	          bytesAdded: this.state.numBytes - startingBytecount,
	          totalBytesSnapshot: this.state.numBytes,
	          tensorsAdded: this.state.numTensors - startingNumTensors,
	          totalTensorsSnapshot: this.state.numTensors,
	          inputShapes: Object.keys(inputs).map(function (key) {
	            return inputs[key] != null ? inputs[key].shape : null;
	          }),
	          outputShapes: outputs.map(function (item) {
	            return item.shape;
	          }),
	          kernelTimeMs: kernelProfile.timeMs,
	          extraInfo: kernelProfile.extraInfo
	        });
	      }
	      return Array.isArray(out) ? outputs : outputs[0];
	    }
	    /**
	     * Saves tensors used in forward mode for use in backward mode.
	     *
	     * @param tensors the list of tensors to save.
	     */
	  }, {
	    key: "saveTensorsForBackwardMode",
	    value: function saveTensorsForBackwardMode(tensors) {
	      var _this7 = this;
	      var saved = tensors.map(function (tensor) {
	        return _this7.keep(_this7.clone(tensor));
	      });
	      return saved;
	    }
	    /**
	     * Returns a list of tensors to save for a given gradient calculation.
	     *
	     * @param kernelName name of kernel to look up gradient for.
	     * @param inputs a map of input tensors.
	     * @param outputs an array of output tensors from forward mode of kernel.
	     */
	  }, {
	    key: "getTensorsForGradient",
	    value: function getTensorsForGradient(kernelName, inputs, outputs) {
	      var gradConfig = getGradient(kernelName);
	      if (gradConfig != null) {
	        var inputsToSave = gradConfig.inputsToSave || [];
	        var outputsToSave = gradConfig.outputsToSave || [];
	        // If saveAllInputs is true, all inputs will be saved. Otherwise, inputs
	        // specified in inputsToSave will be saved.
	        var inputTensorsToSave;
	        if (gradConfig.saveAllInputs) {
	          assert$1(Array.isArray(inputs), function () {
	            return 'saveAllInputs is true, expected inputs to be an array.';
	          });
	          inputTensorsToSave = Object.keys(inputs).map(function (key) {
	            return inputs[key];
	          });
	        } else {
	          inputTensorsToSave = inputsToSave.map(function (inputName) {
	            return inputs[inputName];
	          });
	        }
	        var outputTensorsToSave = outputs.filter(function (_, i) {
	          return outputsToSave[i];
	        });
	        return inputTensorsToSave.concat(outputTensorsToSave);
	      }
	      // We return an empty list rather than throw an error because the kernel we
	      // are looking up may not actually be relevant to backproping through the
	      // overall function
	      //
	      // See 'does not error if irrelevant (pruned) ops are missing grads' test
	      // in gradients_test.ts for an example.
	      return [];
	    }
	    /**
	     * Internal method used by public APIs for tensor creation. Makes a new
	     * tensor with the provided shape, dtype and values. It always
	     * creates a new data id and writes the values to the underlying backend.
	     */
	  }, {
	    key: "makeTensor",
	    value: function makeTensor(values, shape, dtype, backend) {
	      if (values == null) {
	        throw new Error('Values passed to engine.makeTensor() are null');
	      }
	      dtype = dtype || 'float32';
	      backend = backend || this.backend;
	      var backendVals = values;
	      if (dtype === 'string' && isString(values[0])) {
	        backendVals = values.map(function (d) {
	          return encodeString(d);
	        });
	      }
	      var dataId = backend.write(backendVals, shape, dtype);
	      var t = new Tensor(shape, dtype, dataId, this.nextTensorId());
	      this.trackTensor(t, backend);
	      // Count bytes for string tensors.
	      if (dtype === 'string') {
	        var info = this.state.tensorInfo.get(dataId);
	        var newBytes = bytesFromStringArray(backendVals);
	        this.state.numBytes += newBytes - info.bytes;
	        info.bytes = newBytes;
	      }
	      return t;
	    }
	    /**
	     * Internal method used by backends. Makes a new tensor
	     * that is a wrapper around an existing data id. It doesn't create
	     * a new data id, only increments the ref count used in memory tracking.
	     * @deprecated
	     */
	  }, {
	    key: "makeTensorFromDataId",
	    value: function makeTensorFromDataId(dataId, shape, dtype, backend) {
	      dtype = dtype || 'float32';
	      var tensorInfo = {
	        dataId: dataId,
	        shape: shape,
	        dtype: dtype
	      };
	      return this.makeTensorFromTensorInfo(tensorInfo, backend);
	    }
	    /**
	     * Internal method used by backends. Makes a new tensor that is a wrapper
	     * around an existing data id in TensorInfo. It doesn't create a new data id,
	     * only increments the ref count used in memory tracking.
	     */
	  }, {
	    key: "makeTensorFromTensorInfo",
	    value: function makeTensorFromTensorInfo(tensorInfo, backend) {
	      var dataId = tensorInfo.dataId,
	        shape = tensorInfo.shape,
	        dtype = tensorInfo.dtype;
	      var t = new Tensor(shape, dtype, dataId, this.nextTensorId());
	      this.trackTensor(t, backend);
	      return t;
	    }
	  }, {
	    key: "makeVariable",
	    value: function makeVariable(initialValue) {
	      var trainable = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      var name = arguments.length > 2 ? arguments[2] : undefined;
	      var dtype = arguments.length > 3 ? arguments[3] : undefined;
	      name = name || this.nextVariableId().toString();
	      if (dtype != null && dtype !== initialValue.dtype) {
	        initialValue = initialValue.cast(dtype);
	      }
	      var v = new Variable(initialValue, trainable, name, this.nextTensorId());
	      if (this.state.registeredVariables[v.name] != null) {
	        throw new Error("Variable with name ".concat(v.name, " was already registered"));
	      }
	      this.state.registeredVariables[v.name] = v;
	      this.incRef(v, this.backend);
	      return v;
	    }
	  }, {
	    key: "trackTensor",
	    value: function trackTensor(a, backend) {
	      this.state.numTensors++;
	      if (a.dtype === 'string') {
	        this.state.numStringTensors++;
	      }
	      // Bytes for complex numbers are counted by their components. Bytes for
	      // string tensors are counted when writing values.
	      var bytes = 0;
	      if (a.dtype !== 'complex64' && a.dtype !== 'string') {
	        bytes = a.size * bytesPerElement(a.dtype);
	      }
	      this.state.numBytes += bytes;
	      if (!this.state.tensorInfo.has(a.dataId)) {
	        this.state.numDataBuffers++;
	        this.state.tensorInfo.set(a.dataId, {
	          backend: backend || this.backend,
	          dtype: a.dtype,
	          shape: a.shape,
	          bytes: bytes
	        });
	      }
	      if (!(a instanceof Variable)) {
	        this.track(a);
	      }
	    }
	    // Track the tensor by dataId and increase the refCount for the dataId in the
	    // backend.
	    // TODO(pyu10055): This is currently used by makeVariable method, to increase
	    // refCount on the backend for the dataId. It can potentially be replaced with
	    // Identity op indead of calling backend directly.
	  }, {
	    key: "incRef",
	    value: function incRef(a, backend) {
	      this.trackTensor(a, backend);
	      this.backend.incRef(a.dataId);
	    }
	  }, {
	    key: "removeDataId",
	    value: function removeDataId(dataId, backend) {
	      if (this.state.tensorInfo.has(dataId) && this.state.tensorInfo.get(dataId).backend === backend) {
	        this.state.tensorInfo.delete(dataId);
	        this.state.numDataBuffers--;
	      }
	    }
	  }, {
	    key: "disposeTensor",
	    value: function disposeTensor(a) {
	      if (!this.state.tensorInfo.has(a.dataId)) {
	        return;
	      }
	      var info = this.state.tensorInfo.get(a.dataId);
	      this.state.numTensors--;
	      if (a.dtype === 'string') {
	        this.state.numStringTensors--;
	        this.state.numBytes -= info.bytes;
	      }
	      // Don't count bytes for complex numbers as they are counted by their
	      // components.
	      if (a.dtype !== 'complex64' && a.dtype !== 'string') {
	        var bytes = a.size * bytesPerElement(a.dtype);
	        this.state.numBytes -= bytes;
	      }
	      // Remove the reference to dataId if backend dispose the data successfully
	      if (info.backend.disposeData(a.dataId)) {
	        this.removeDataId(a.dataId, info.backend);
	      }
	      // TODO(nsthorat): Construct an error and save the stack trace for
	      // debugging when in debug mode. Creating a stack trace is too expensive
	      // to do unconditionally.
	    }
	  }, {
	    key: "disposeVariables",
	    value: function disposeVariables() {
	      for (var varName in this.state.registeredVariables) {
	        var v = this.state.registeredVariables[varName];
	        this.disposeVariable(v);
	      }
	    }
	  }, {
	    key: "disposeVariable",
	    value: function disposeVariable(v) {
	      this.disposeTensor(v);
	      if (this.state.registeredVariables[v.name] != null) {
	        delete this.state.registeredVariables[v.name];
	      }
	    }
	  }, {
	    key: "memory",
	    value: function memory() {
	      var info = this.backend.memory();
	      info.numTensors = this.state.numTensors;
	      info.numDataBuffers = this.state.numDataBuffers;
	      info.numBytes = this.state.numBytes;
	      if (this.state.numStringTensors > 0) {
	        info.unreliable = true;
	        if (info.reasons == null) {
	          info.reasons = [];
	        }
	        info.reasons.push('Memory usage by string tensors is approximate ' + '(2 bytes per character)');
	      }
	      return info;
	    }
	  }, {
	    key: "profile",
	    value: function () {
	      var _profile = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(query) {
	        var startBytes, startNumTensors, _iterator, _step, kernel;
	        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
	          while (1) switch (_context3.prev = _context3.next) {
	            case 0:
	              this.state.profiling = true;
	              startBytes = this.state.numBytes;
	              startNumTensors = this.state.numTensors;
	              this.state.activeProfile.kernels = [];
	              _context3.next = 6;
	              return query();
	            case 6:
	              this.state.activeProfile.result = _context3.sent;
	              this.state.profiling = false;
	              this.state.activeProfile.peakBytes = Math.max.apply(Math, _toConsumableArray(this.state.activeProfile.kernels.map(function (d) {
	                return d.totalBytesSnapshot;
	              })));
	              this.state.activeProfile.newBytes = this.state.numBytes - startBytes;
	              this.state.activeProfile.newTensors = this.state.numTensors - startNumTensors;
	              _iterator = _createForOfIteratorHelper(this.state.activeProfile.kernels);
	              _context3.prev = 12;
	              _iterator.s();
	            case 14:
	              if ((_step = _iterator.n()).done) {
	                _context3.next = 24;
	                break;
	              }
	              kernel = _step.value;
	              _context3.next = 18;
	              return kernel.kernelTimeMs;
	            case 18:
	              kernel.kernelTimeMs = _context3.sent;
	              _context3.next = 21;
	              return kernel.extraInfo;
	            case 21:
	              kernel.extraInfo = _context3.sent;
	            case 22:
	              _context3.next = 14;
	              break;
	            case 24:
	              _context3.next = 29;
	              break;
	            case 26:
	              _context3.prev = 26;
	              _context3.t0 = _context3["catch"](12);
	              _iterator.e(_context3.t0);
	            case 29:
	              _context3.prev = 29;
	              _iterator.f();
	              return _context3.finish(29);
	            case 32:
	              return _context3.abrupt("return", this.state.activeProfile);
	            case 33:
	            case "end":
	              return _context3.stop();
	          }
	        }, _callee3, this, [[12, 26, 29, 32]]);
	      }));
	      function profile(_x2) {
	        return _profile.apply(this, arguments);
	      }
	      return profile;
	    }()
	  }, {
	    key: "isTapeOn",
	    value: function isTapeOn() {
	      return this.state.gradientDepth > 0 && this.state.kernelDepth === 0;
	    }
	  }, {
	    key: "addTapeNode",
	    value: function addTapeNode(kernelName, inputs, outputs, gradientsFunc, saved, attrs) {
	      var _this8 = this;
	      var tapeNode = {
	        id: this.state.nextTapeNodeId++,
	        kernelName: kernelName,
	        inputs: inputs,
	        outputs: outputs,
	        saved: saved
	      };
	      var gradConfig = getGradient(kernelName);
	      if (gradConfig != null) {
	        gradientsFunc = gradConfig.gradFunc;
	      }
	      if (gradientsFunc != null) {
	        tapeNode.gradient = function (dys) {
	          // TODO(smilkov): To optimize back-prop, pass dys that are not used in
	          // the backprop graph to the user as null instead of zeros
	          dys = dys.map(function (dy, i) {
	            if (dy == null) {
	              var output = outputs[i];
	              var vals = makeZerosTypedArray(output.size, output.dtype);
	              return _this8.makeTensor(vals, output.shape, output.dtype);
	            }
	            return dy;
	          });
	          // Grad functions of ops with single outputs expect a dy, while ops
	          // with multiple outputs expect dys (array of dy).
	          return gradientsFunc(dys.length > 1 ? dys : dys[0], saved, attrs);
	        };
	      }
	      this.state.activeTape.push(tapeNode);
	    }
	  }, {
	    key: "keep",
	    value: function keep(result) {
	      result.kept = true;
	      return result;
	    }
	  }, {
	    key: "startTape",
	    value: function startTape() {
	      if (this.state.gradientDepth === 0) {
	        this.state.activeTape = [];
	      }
	      this.state.gradientDepth++;
	    }
	  }, {
	    key: "endTape",
	    value: function endTape() {
	      this.state.gradientDepth--;
	    }
	    /**
	     * Start a scope. Use this with endScope() to achieve the same functionality
	     * as scope() without the need for a function closure.
	     */
	  }, {
	    key: "startScope",
	    value: function startScope(name) {
	      var scopeInfo = {
	        track: [],
	        name: 'unnamed scope',
	        id: this.state.nextScopeId++
	      };
	      if (name) {
	        scopeInfo.name = name;
	      }
	      this.state.scopeStack.push(scopeInfo);
	      this.state.activeScope = scopeInfo;
	    }
	    /**
	     * End a scope. Use this with startScope() to achieve the same functionality
	     * as scope() without the need for a function closure.
	     */
	  }, {
	    key: "endScope",
	    value: function endScope(result) {
	      var _this9 = this;
	      var tensorsToTrackInParent = getTensorsInContainer(result);
	      var tensorsToTrackInParentSet = new Set(tensorsToTrackInParent.map(function (t) {
	        return t.id;
	      }));
	      // Dispose the arrays tracked in this scope.
	      for (var i = 0; i < this.state.activeScope.track.length; i++) {
	        var tensor = this.state.activeScope.track[i];
	        if (!tensor.kept && !tensorsToTrackInParentSet.has(tensor.id)) {
	          tensor.dispose();
	        }
	      }
	      var oldScope = this.state.scopeStack.pop();
	      this.state.activeScope = this.state.scopeStack.length === 0 ? null : this.state.scopeStack[this.state.scopeStack.length - 1];
	      // Track the current result in the parent scope.
	      tensorsToTrackInParent.forEach(function (tensor) {
	        // Only track the tensor if was allocated in the inner scope and is not
	        // globally kept.
	        if (!tensor.kept && tensor.scopeId === oldScope.id) {
	          _this9.track(tensor);
	        }
	      });
	    }
	    /**
	     * Returns gradients of `f` with respect to each of the `xs`. The gradients
	     * returned are of the same length as `xs`, but some might be null if `f`
	     * was not a function of that `x`. It also takes optional dy to multiply the
	     * gradient, which defaults to `1`.
	     */
	  }, {
	    key: "gradients",
	    value: function gradients(f, xs, dy) {
	      var _this10 = this;
	      var allowNoGradients = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      assert$1(xs.length > 0, function () {
	        return 'gradients() received an empty list of xs.';
	      });
	      if (dy != null && dy.dtype !== 'float32') {
	        throw new Error("dy must have 'float32' dtype, but has '".concat(dy.dtype, "'"));
	      }
	      var y = this.scopedRun(function () {
	        return _this10.startTape();
	      }, function () {
	        return _this10.endTape();
	      }, function () {
	        return _this10.tidy('forward', f);
	      });
	      assert$1(y instanceof Tensor, function () {
	        return 'The result y returned by f() must be a tensor.';
	      });
	      // Filter out the nodes that don't connect x => y.
	      var filteredTape = getFilteredNodesXToY(this.state.activeTape, xs, y);
	      if (!allowNoGradients && filteredTape.length === 0 && xs.length > 0) {
	        throw new Error('Cannot compute gradient of y=f(x) with respect to x. Make sure ' + 'that the f you passed encloses all operations that lead from x ' + 'to y.');
	      }
	      return this.tidy('backward', function () {
	        var accumulatedGradientMap = {};
	        accumulatedGradientMap[y.id] = dy == null ? ones$2(y.shape) : dy;
	        // Backprop gradients through the filtered nodes.
	        backpropagateGradients(accumulatedGradientMap, filteredTape,
	        // Pass the tidy function to avoid circular dep with `tape.ts`.
	        function (f) {
	          return _this10.tidy(f);
	        },
	        // Pass an add function to avoide a circular dep with `tape.ts`.
	        add$4);
	        var grads = xs.map(function (x) {
	          return accumulatedGradientMap[x.id];
	        });
	        if (_this10.state.gradientDepth === 0) {
	          // This means that we are not computing higher-order gradients
	          // and can clean up the tape.
	          _this10.state.activeTape.forEach(function (node) {
	            var _iterator2 = _createForOfIteratorHelper(node.saved),
	              _step2;
	            try {
	              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	                var tensor = _step2.value;
	                tensor.dispose();
	              }
	            } catch (err) {
	              _iterator2.e(err);
	            } finally {
	              _iterator2.f();
	            }
	          });
	          _this10.state.activeTape = null;
	        }
	        return {
	          value: y,
	          grads: grads
	        };
	      });
	    }
	  }, {
	    key: "customGrad",
	    value: function customGrad(f) {
	      var _this11 = this;
	      assert$1(isFunction(f), function () {
	        return 'The f passed in customGrad(f) must be a function.';
	      });
	      return function () {
	        for (var _len = arguments.length, inputs = new Array(_len), _key = 0; _key < _len; _key++) {
	          inputs[_key] = arguments[_key];
	        }
	        assert$1(inputs.every(function (t) {
	          return t instanceof Tensor;
	        }), function () {
	          return 'The args passed in customGrad(f)(x1, x2,...) must all be ' + 'tensors';
	        });
	        var res;
	        var inputMap = {};
	        inputs.forEach(function (input, i) {
	          inputMap[i] = input;
	        });
	        var forwardFunc = function forwardFunc(_, save) {
	          res = f.apply(void 0, [].concat(inputs, [save]));
	          assert$1(res.value instanceof Tensor, function () {
	            return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.value` is a tensor';
	          });
	          assert$1(isFunction(res.gradFunc), function () {
	            return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function.';
	          });
	          return res.value;
	        };
	        var backwardsFunc = function backwardsFunc(dy, saved) {
	          var gradRes = res.gradFunc(dy, saved);
	          var grads = Array.isArray(gradRes) ? gradRes : [gradRes];
	          assert$1(grads.length === inputs.length, function () {
	            return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function that returns ' + 'the same number of tensors as inputs passed to f(...).';
	          });
	          assert$1(grads.every(function (t) {
	            return t instanceof Tensor;
	          }), function () {
	            return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function that returns ' + 'a list of only tensors.';
	          });
	          var gradMap = {};
	          grads.forEach(function (grad, i) {
	            gradMap[i] = function () {
	              return grad;
	            };
	          });
	          return gradMap;
	        };
	        return _this11.runKernelFunc({
	          forwardFunc: forwardFunc,
	          backwardsFunc: backwardsFunc,
	          inputs: inputMap
	        });
	      };
	    }
	  }, {
	    key: "readSync",
	    value: function readSync(dataId) {
	      // Route the read to the correct backend.
	      var info = this.state.tensorInfo.get(dataId);
	      return info.backend.readSync(dataId);
	    }
	  }, {
	    key: "read",
	    value: function read(dataId) {
	      // Route the read to the correct backend.
	      var info = this.state.tensorInfo.get(dataId);
	      return info.backend.read(dataId);
	    }
	  }, {
	    key: "readToGPU",
	    value: function readToGPU(dataId, options) {
	      // Route the read to the correct backend.
	      var info = this.state.tensorInfo.get(dataId);
	      return info.backend.readToGPU(dataId, options);
	    }
	  }, {
	    key: "time",
	    value: function () {
	      var _time = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(query) {
	        var start, timingInfo;
	        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
	          while (1) switch (_context4.prev = _context4.next) {
	            case 0:
	              start = now();
	              _context4.next = 3;
	              return this.backend.time(query);
	            case 3:
	              timingInfo = _context4.sent;
	              timingInfo.wallMs = now() - start;
	              return _context4.abrupt("return", timingInfo);
	            case 6:
	            case "end":
	              return _context4.stop();
	          }
	        }, _callee4, this);
	      }));
	      function time(_x3) {
	        return _time.apply(this, arguments);
	      }
	      return time;
	    }()
	    /**
	     * Tracks a Tensor in the current scope to be automatically cleaned up
	     * when the current scope ends, and returns the value.
	     *
	     * @param result The Tensor to track in the current scope.
	     */
	  }, {
	    key: "track",
	    value: function track(result) {
	      if (this.state.activeScope != null) {
	        result.scopeId = this.state.activeScope.id;
	        this.state.activeScope.track.push(result);
	      }
	      return result;
	    }
	  }, {
	    key: "registeredVariables",
	    get: function get() {
	      return this.state.registeredVariables;
	    }
	    /**
	     * Resets the engine state. Removes all backends but does not remove
	     * registered backend factories.
	     */
	  }, {
	    key: "reset",
	    value: function reset() {
	      // Make any pending promise obsolete.
	      this.pendingBackendInitId++;
	      this.state.dispose();
	      this.ENV.reset();
	      this.state = new EngineState();
	      for (var backendName in this.registry) {
	        this.disposeRegisteredKernels(backendName);
	        this.registry[backendName].dispose();
	        delete this.registry[backendName];
	      }
	      this.backendName = null;
	      this.backendInstance = null;
	      this.pendingBackendInit = null;
	    }
	  }]);
	  return Engine;
	}();
	Engine.nextTensorId = 0;
	Engine.nextVariableId = 0;
	function ones$2(shape) {
	  var values = makeOnesTypedArray(sizeFromShape(shape), 'float32');
	  return ENGINE.makeTensor(values, shape, 'float32');
	}
	function getOrMakeEngine() {
	  var ns = getGlobalNamespace();
	  if (ns._tfengine == null) {
	    var environment = new Environment(ns);
	    ns._tfengine = new Engine(environment);
	  }
	  setEnvironmentGlobal(ns._tfengine.ENV);
	  // Tell the current tensor interface that the global engine is responsible
	  // for tracking.
	  setTensorTracker(function () {
	    return ns._tfengine;
	  });
	  return ns._tfengine;
	}
	var ENGINE = getOrMakeEngine();
	/**
	 * A implementation of the add op for use within engine and tape.
	 *
	 * This allows us to avoid a circular dependency between add.ts and engine.
	 * It is exported to be available in tape tests.
	 */
	function add$4(a, b) {
	  // We duplicate Add here to avoid a circular dependency with add.ts.
	  var inputs = {
	    a: a,
	    b: b
	  };
	  return ENGINE.runKernel(Add$1, inputs);
	}

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	// tslint:disable-next-line:no-any
	function _isNavigatorDefined() {
	  return typeof navigator !== 'undefined' && navigator != null;
	}
	var isMobileMockValue;
	function mockIsMobile(value) {
	  isMobileMockValue = value;
	}
	function isMobile(nav) {
	  if (isMobileMockValue !== undefined) {
	    return isMobileMockValue;
	  }
	  if (nav || _isNavigatorDefined()) {
	    if (!nav) {
	      nav = navigator;
	    }
	    if (nav.product === 'ReactNative') {
	      return true;
	    }
	    var a = nav.userAgent || nav.vendor || (
	    // tslint:disable-next-line:no-any
	    typeof window !== 'undefined' ? window.opera : '');
	    // Use `navigator.userAgentData.mobile` as fallback.
	    if (!a) {
	      // tslint:disable-next-line:no-any
	      var navAny = nav;
	      return navAny.userAgentData && navAny.userAgentData.mobile;
	    }
	    // tslint:disable-next-line:max-line-length
	    return /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
	    // tslint:disable-next-line:max-line-length
	    /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4));
	  }
	  return false;
	}
	function isBrowser() {
	  return typeof window !== 'undefined' && window.document != null ||
	  //@ts-ignore
	  typeof WorkerGlobalScope !== 'undefined';
	}

	var device_util = {
		__proto__: null,
		isBrowser: isBrowser,
		isMobile: isMobile,
		mockIsMobile: mockIsMobile
	};

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var ENV$3 = env();
	/**
	 * This file contains environment-related flag registrations.
	 */
	/** Whether to enable debug mode. */
	ENV$3.registerFlag('DEBUG', function () {
	  return false;
	}, function (debugValue) {
	  if (debugValue) {
	    console.warn('Debugging mode is ON. The output of every math call will ' + 'be downloaded to CPU and checked for NaNs. ' + 'This significantly impacts performance.');
	  }
	});
	/** Whether we are in a browser (as versus, say, node.js) environment. */
	ENV$3.registerFlag('IS_BROWSER', function () {
	  return isBrowser();
	});
	/** Whether we are in a browser (as versus, say, node.js) environment. */
	ENV$3.registerFlag('IS_NODE', function () {
	  return typeof process !== 'undefined' && typeof process.versions !== 'undefined' && typeof process.versions.node !== 'undefined';
	});
	/** Whether this browser is Chrome. */
	ENV$3.registerFlag('IS_CHROME', function () {
	  return typeof navigator !== 'undefined' && navigator != null && navigator.userAgent != null && /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
	});
	/** Whether this browser is Safari. */
	ENV$3.registerFlag('IS_SAFARI', function () {
	  return typeof navigator !== 'undefined' && navigator != null && navigator.userAgent != null && /Safari/.test(navigator.userAgent) && /Apple/.test(navigator.vendor);
	});
	/**
	 * True when the environment is "production" where we disable safety checks
	 * to gain performance.
	 */
	ENV$3.registerFlag('PROD', function () {
	  return false;
	});
	/**
	 * Whether to do sanity checks when inferring a shape from user-provided
	 * values, used when creating a new tensor.
	 */
	ENV$3.registerFlag('TENSORLIKE_CHECK_SHAPE_CONSISTENCY', function () {
	  return ENV$3.getBool('DEBUG');
	});
	/** Whether deprecation warnings are enabled. */
	ENV$3.registerFlag('DEPRECATION_WARNINGS_ENABLED', function () {
	  return true;
	});
	/** True if running unit tests. */
	ENV$3.registerFlag('IS_TEST', function () {
	  return false;
	});
	/** Whether to check computation result for errors. */
	ENV$3.registerFlag('CHECK_COMPUTATION_FOR_ERRORS', function () {
	  return ENV$3.getBool('DEBUG');
	});
	/** Whether the backend needs to wrap input to imageBitmap. */
	ENV$3.registerFlag('WRAP_TO_IMAGEBITMAP', function () {
	  return false;
	});
	/** Whether to enable canvas2d willReadFrequently for GPU backends */
	ENV$3.registerFlag('CANVAS2D_WILL_READ_FREQUENTLY_FOR_GPU', function () {
	  return false;
	});
	/** Whether to use setTimeoutCustom */
	ENV$3.registerFlag('USE_SETTIMEOUTCUSTOM', function () {
	  return false;
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function inferShape(val, dtype) {
	  var firstElem = val;
	  if (isTypedArray(val)) {
	    return dtype === 'string' ? [] : [val.length];
	  }
	  if (isWebGLData(val)) {
	    var usedChannels = val.channels || 'RGBA';
	    return [val.height, val.width * usedChannels.length];
	  } else if (isWebGPUData(val)) {
	    return [val.buffer.size / (dtype == null ? 4 : bytesPerElement(dtype))];
	  }
	  if (!Array.isArray(val)) {
	    return []; // Scalar.
	  }

	  var shape = [];
	  while (Array.isArray(firstElem) || isTypedArray(firstElem) && dtype !== 'string') {
	    shape.push(firstElem.length);
	    firstElem = firstElem[0];
	  }
	  if (Array.isArray(val) && env().getBool('TENSORLIKE_CHECK_SHAPE_CONSISTENCY')) {
	    deepAssertShapeConsistency(val, shape, []);
	  }
	  return shape;
	}
	function deepAssertShapeConsistency(val, shape, indices) {
	  indices = indices || [];
	  if (!Array.isArray(val) && !isTypedArray(val)) {
	    assert$1(shape.length === 0, function () {
	      return "Element arr[".concat(indices.join(']['), "] is a primitive, ") + "but should be an array/TypedArray of ".concat(shape[0], " elements");
	    });
	    return;
	  }
	  assert$1(shape.length > 0, function () {
	    return "Element arr[".concat(indices.join(']['), "] should be a primitive, ") + "but is an array of ".concat(val.length, " elements");
	  });
	  assert$1(val.length === shape[0], function () {
	    return "Element arr[".concat(indices.join(']['), "] should have ").concat(shape[0], " ") + "elements, but has ".concat(val.length, " elements");
	  });
	  var subShape = shape.slice(1);
	  for (var i = 0; i < val.length; ++i) {
	    deepAssertShapeConsistency(val[i], subShape, indices.concat(i));
	  }
	}
	function assertDtype(expectedDtype, actualDType, argName, functionName) {
	  if (expectedDtype === 'string_or_numeric') {
	    return;
	  }
	  if (expectedDtype == null) {
	    throw new Error("Expected dtype cannot be null.");
	  }
	  if (expectedDtype !== 'numeric' && expectedDtype !== actualDType || expectedDtype === 'numeric' && actualDType === 'string') {
	    throw new Error("Argument '".concat(argName, "' passed to '").concat(functionName, "' must ") + "be ".concat(expectedDtype, " tensor, but got ").concat(actualDType, " tensor"));
	  }
	}
	function convertToTensor(x, argName, functionName) {
	  var parseAsDtype = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'numeric';
	  if (x instanceof getGlobalTensorClass()) {
	    assertDtype(parseAsDtype, x.dtype, argName, functionName);
	    return x;
	  }
	  var inferredDtype = inferDtype(x);
	  // If the user expects a bool/int/float, use that info to update the
	  // inferredDtype when it is not a string.
	  if (inferredDtype !== 'string' && ['bool', 'int32', 'float32'].indexOf(parseAsDtype) >= 0) {
	    inferredDtype = parseAsDtype;
	  }
	  assertDtype(parseAsDtype, inferredDtype, argName, functionName);
	  if (x == null || !isTypedArray(x) && !Array.isArray(x) && typeof x !== 'number' && typeof x !== 'boolean' && typeof x !== 'string') {
	    var type = x == null ? 'null' : x.constructor.name;
	    throw new Error("Argument '".concat(argName, "' passed to '").concat(functionName, "' must be a ") + "Tensor or TensorLike, but got '".concat(type, "'"));
	  }
	  var inferredShape = inferShape(x, inferredDtype);
	  if (!isTypedArray(x) && !Array.isArray(x)) {
	    x = [x];
	  }
	  var skipTypedArray = true;
	  var values = inferredDtype !== 'string' ? toTypedArray(x, inferredDtype) : flatten$2(x, [], skipTypedArray);
	  return ENGINE.makeTensor(values, inferredShape, inferredDtype);
	}
	function convertToTensorArray(arg, argName, functionName) {
	  var parseAsDtype = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'numeric';
	  if (!Array.isArray(arg)) {
	    throw new Error("Argument ".concat(argName, " passed to ").concat(functionName, " must be a ") + '`Tensor[]` or `TensorLike[]`');
	  }
	  var tensors = arg;
	  return tensors.map(function (t, i) {
	    return convertToTensor(t, "".concat(argName, "[").concat(i, "]"), functionName, parseAsDtype);
	  });
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var OP_SCOPE_SUFFIX = '__op';
	/**
	 * Used for wrapping functions that perform math operations on
	 * Tensors. The function will be wrapped in a named scope that cleans all
	 * memory usage after the function is done.
	 */
	function op(f) {
	  var keys = Object.keys(f);
	  if (keys.length !== 1) {
	    throw new Error("Please provide an object with a single key " + "(operation name) mapping to a function. Got an object with " + "".concat(keys.length, " keys."));
	  }
	  var opName = keys[0];
	  var fn = f[opName];
	  // Strip the underscore from the end of the function name.
	  if (opName.endsWith('_')) {
	    opName = opName.substring(0, opName.length - 1);
	  }
	  // add an __op suffix to distinguish ops from kernels in tf.profile
	  opName = opName + OP_SCOPE_SUFFIX;
	  // tslint:disable-next-line:no-any
	  var f2 = function f2() {
	    ENGINE.startScope(opName);
	    try {
	      var result = fn.apply(void 0, arguments);
	      if (isPromise(result)) {
	        console.error('Cannot return a Promise inside of tidy.');
	      }
	      ENGINE.endScope(result);
	      return result;
	    } catch (ex) {
	      ENGINE.endScope(null);
	      throw ex;
	    }
	  };
	  Object.defineProperty(f2, 'name', {
	    value: opName,
	    configurable: true
	  });
	  // tslint:disable-next-line:no-any
	  return f2;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Converts two real numbers to a complex number.
	 *
	 * Given a tensor `real` representing the real part of a complex number, and a
	 * tensor `imag` representing the imaginary part of a complex number, this
	 * operation returns complex numbers elementwise of the form [r0, i0, r1, i1],
	 * where r represents the real part and i represents the imag part.
	 *
	 * The input tensors real and imag must have the same shape.
	 *
	 * ```js
	 * const real = tf.tensor1d([2.25, 3.25]);
	 * const imag = tf.tensor1d([4.75, 5.75]);
	 * const complex = tf.complex(real, imag);
	 *
	 * complex.print();
	 * ```
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */
	function complex_(real, imag) {
	  var $real = convertToTensor(real, 'real', 'complex');
	  var $imag = convertToTensor(imag, 'imag', 'complex');
	  assertShapesMatch($real.shape, $imag.shape, "real and imag shapes, ".concat($real.shape, " and ").concat($imag.shape, ", ") + "must match in call to tf.complex().");
	  var inputs = {
	    real: $real,
	    imag: $imag
	  };
	  return ENGINE.runKernel(Complex, inputs);
	}
	var complex$2 = /* @__PURE__ */op({
	  complex_: complex_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/** This is shared code across all tensor creation methods. */
	function makeTensor(values, shape, inferredShape, dtype) {
	  if (dtype == null) {
	    dtype = inferDtype(values);
	  } else if (dtype === 'complex64') {
	    throw new Error("Cannot construct a complex64 tensor directly. " + "Please use tf.complex(real, imag).");
	  }
	  if (isWebGPUData(values) || isWebGLData(values)) {
	    if (dtype !== 'float32' && dtype !== 'int32') {
	      throw new Error("Creating tensor from GPU data only supports " + "'float32'|'int32' dtype, while the dtype is ".concat(dtype, "."));
	    }
	    return ENGINE.backend.createTensorFromGPUData(values, shape || inferredShape, dtype);
	  }
	  if (!isTypedArray(values) && !Array.isArray(values) && typeof values !== 'number' && typeof values !== 'boolean' && typeof values !== 'string') {
	    throw new Error('values passed to tensor(values) must be a number/boolean/string or ' + 'an array of numbers/booleans/strings, or a TypedArray');
	  }
	  // Verify that the shape matches the inferred shape.
	  if (shape != null) {
	    assertNonNegativeIntegerDimensions(shape);
	    var providedSize = sizeFromShape(shape);
	    var inferredSize = sizeFromShape(inferredShape);
	    assert$1(providedSize === inferredSize, function () {
	      return "Based on the provided shape, [".concat(shape, "], the tensor should have ") + "".concat(providedSize, " values but has ").concat(inferredSize);
	    });
	    for (var i = 0; i < inferredShape.length; ++i) {
	      var inferred = inferredShape[i];
	      var flatDimsDontMatch = i === inferredShape.length - 1 ? inferred !== sizeFromShape(shape.slice(i)) : true;
	      assert$1(inferredShape[i] === shape[i] || !flatDimsDontMatch, function () {
	        return "Error creating a new Tensor. Inferred shape " + "(".concat(inferredShape, ") does not match the provided ") + "shape (".concat(shape, "). ");
	      });
	    }
	  }
	  if (!isTypedArray(values) && !Array.isArray(values)) {
	    values = [values];
	  }
	  shape = shape || inferredShape;
	  values = dtype !== 'string' ? toTypedArray(values, dtype) : flatten$2(values, [], true);
	  return ENGINE.makeTensor(values, shape, dtype);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a `tf.Tensor` with the provided values, shape and dtype.
	 *
	 * ```js
	 * // Pass an array of values to create a vector.
	 * tf.tensor([1, 2, 3, 4]).print();
	 * ```
	 *
	 * ```js
	 * // Pass a nested array of values to make a matrix or a higher
	 * // dimensional tensor.
	 * tf.tensor([[1, 2], [3, 4]]).print();
	 * ```
	 *
	 * ```js
	 * // Pass a flat array and specify a shape yourself.
	 * tf.tensor([1, 2, 3, 4], [2, 2]).print();
	 * ```
	 *
	 * ```js
	 * // Pass a `WebGLData` object and specify a shape yourself.
	 *
	 * // This makes it possible for TF.js applications to avoid GPU / CPU sync.
	 * // For example, if your application includes a preprocessing step on the GPU,
	 * // you could upload the GPU output directly to TF.js, rather than first
	 * // downloading the values.
	 *
	 * // Example for WebGL2:
	 * if (tf.findBackend('custom-webgl') == null) {
	 *   const customCanvas = document.createElement('canvas');
	 *   const customBackend = new tf.MathBackendWebGL(customCanvas);
	 *   tf.registerBackend('custom-webgl', () => customBackend);
	 * }
	 * const savedBackend = tf.getBackend();
	 * await tf.setBackend('custom-webgl');
	 * const gl = tf.backend().gpgpu.gl;
	 * const texture = gl.createTexture();
	 * const tex2d = gl.TEXTURE_2D;
	 * const width = 2;
	 * const height = 2;
	 *
	 * gl.bindTexture(tex2d, texture);
	 * gl.texParameteri(tex2d, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
	 * gl.texParameteri(tex2d, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
	 * gl.texParameteri(tex2d, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
	 * gl.texParameteri(tex2d, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
	 * gl.texImage2D(
	 *   tex2d, 0, gl.RGBA32F, // internalFormat
	 *   width, height, 0,
	 *   gl.RGBA, // textureFormat
	 *   gl.FLOAT, // textureType
	 *   new Float32Array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
	 * );
	 *
	 * // Currently, the `texture` has 4 pixels:
	 * // Pixel0 is {R:0, G:1, B:2, A:3}
	 * // Pixel1 is {R:4, G:5, B:6, A:7}
	 * // Pixel2 is {R:8, G:9, B:10, A:11}
	 * // Pixel3 is {R:12, G:13, B:14, A:15}
	 *
	 * const logicalShape = [height * width * 2];
	 * const a = tf.tensor({texture, height, width, channels: 'BR'}, logicalShape);
	 * a.print();
	 * // Tensor value will be [2, 0, 6, 4, 10, 8, 14, 12], since [2, 0] is the
	 * // values of 'B' and 'R' channels of Pixel0, [6, 4] is the values of 'B' and
	 * 'R'
	 * // channels of Pixel1...
	 *
	 * // For postprocessing on the GPU, it's possible to retrieve the texture
	 * // backing any tensor by calling the tensor's `dataToGPU` method like
	 * // so:
	 *
	 * const tex = a.dataToGPU();
	 * await tf.setBackend(savedBackend);
	 * ```
	 *
	 * ```js
	 * // Pass a `WebGPUData` object and specify a shape yourself.
	 *
	 * // This makes it possible for TF.js applications to avoid GPU / CPU sync.
	 * // For example, if your application includes a preprocessing step on the GPU,
	 * // you could upload the GPU output directly to TF.js, rather than first
	 * // downloading the values. Unlike WebGL, this optionally supports zero copy
	 * // by WebGPUData.zeroCopy. When zeroCopy is false or undefined(default), this
	 * // passing GPUBuffer can be destroyed after tensor is created. When zeroCopy
	 * // is true, this GPUBuffer is bound directly by the tensor, so do not destroy
	 * // this GPUBuffer until all access is done.
	 *
	 * // Example for WebGPU:
	 * function createGPUBufferFromData(device, data, dtype) {
	 *   const bytesPerElement = 4;
	 *   const sizeInBytes = data.length * bytesPerElement;
	 *
	 *   const gpuWriteBuffer = device.createBuffer({
	 *     mappedAtCreation: true,
	 *     size: sizeInBytes,
	 *     usage: GPUBufferUsage.MAP_WRITE | GPUBufferUsage.COPY_SRC
	 *   });
	 *   const arrayBuffer = gpuWriteBuffer.getMappedRange();
	 *   if (dtype === 'float32') {
	 *     new Float32Array(arrayBuffer).set(data);
	 *   } else if (dtype === 'int32') {
	 *     new Int32Array(arrayBuffer).set(data);
	 *   } else {
	 *     throw new Error(
	 *         `Creating tensor from GPUBuffer only supports` +
	 *         `'float32'|'int32' dtype, while the dtype is ${dtype}.`);
	 *   }
	 *   gpuWriteBuffer.unmap();
	 *
	 *   const gpuReadBuffer = device.createBuffer({
	 *     mappedAtCreation: false,
	 *     size: sizeInBytes,
	 *     usage: GPUBufferUsage.COPY_DST | GPUBufferUsage.STORAGE |
	 *         GPUBufferUsage.COPY_SRC
	 *   });
	 *
	 *   const copyEncoder = device.createCommandEncoder();
	 *   copyEncoder.copyBufferToBuffer(
	 *       gpuWriteBuffer, 0, gpuReadBuffer, 0, sizeInBytes);
	 *   const copyCommands = copyEncoder.finish();
	 *   device.queue.submit([copyCommands]);
	 *   gpuWriteBuffer.destroy();
	 *   return gpuReadBuffer;
	 * }
	 *
	 * const savedBackend = tf.getBackend();
	 * await tf.setBackend('webgpu').catch(
	 *     () => {throw new Error(
	 *         'Failed to use WebGPU backend. Please use Chrome Canary to run.')});
	 * const dtype = 'float32';
	 * const device = tf.backend().device;
	 * const aData = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];
	 * const bData = [1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4];
	 * const expected = [2, 4, 6, 8, 6, 8, 10, 12, 10, 12, 14, 16, 14, 16, 18, 20];
	 * const aBuffer = createGPUBufferFromData(device, aData, dtype);
	 * const shape = [aData.length];
	 * // To use zeroCopy, use {buffer: aBuffer, zeroCopy: true} instead and destroy
	 * // aBuffer untill all access is done.
	 * const a = tf.tensor({buffer: aBuffer}, shape, dtype);
	 * const b = tf.tensor(bData, shape, dtype);
	 * const result = tf.add(a, b);
	 * result.print();
	 * a.dispose();
	 * b.dispose();
	 * result.dispose();
	 * aBuffer.destroy();
	 * await tf.setBackend(savedBackend);
	 * ```
	 * @param values The values of the tensor. Can be nested array of numbers,
	 * or a flat array, or a `TypedArray`(At the moment it supports Uint8Array,
	 * Uint8ClampedArray, Int32Array, Float32Array) data types, or a `WebGLData`
	 * object, or a `WebGPUData` object. If the values are strings, they will be
	 * encoded as utf-8 and kept as `Uint8Array[]`. If the values is a `WebGLData`
	 * object, the dtype could only be 'float32' or 'int32' and the object has to
	 * have: 1. texture, a `WebGLTexture`, the texture must share the same
	 * `WebGLRenderingContext` with TFJS's WebGL backend (you could create a custom
	 * WebGL backend from your texture's canvas) and the internal texture format
	 * for the input texture must be floating point or normalized integer; 2.
	 * height, the height of the texture; 3. width, the width of the texture; 4.
	 * channels, a non-empty subset of 'RGBA', indicating the values of which
	 * channels will be passed to the tensor, such as 'R' or 'BR' (The order of the
	 * channels affect the order of tensor values. ). (If the values passed from
	 * texture is less than the tensor size, zeros will be padded at the rear.). If
	 * the values is a `WebGPUData` object, the dtype could only be 'float32' or
	 * 'int32 and the object has to have: buffer, a `GPUBuffer`. The buffer must:
	 * 1. share the same `GPUDevice` with TFJS's WebGPU backend; 2. buffer.usage
	 * should at least support GPUBufferUsage.STORAGE | GPUBufferUsage.COPY_SRC; 3.
	 * buffer.size should not be smaller than the byte size of tensor shape.
	 * WebGPUData optionally supports zero copy by flag zeroCopy. When zeroCopy is
	 * false or undefined(default),this passing GPUBuffer can be destroyed after
	 * tensor is created. When zeroCopy is true, this GPUBuffer is bound directly
	 * by the tensor, so do not destroy this GPUBuffer until all access is done.
	 * @param shape The shape of the tensor. Optional. If not provided,
	 *   it is inferred from `values`.
	 * @param dtype The data type.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */
	function tensor(values, shape, dtype) {
	  var inferredShape = inferShape(values, dtype);
	  return makeTensor(values, shape, inferredShape, dtype);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/* Type definitions for exporting and importing of models. */
	/**
	 * A map from Tensor dtype to number of bytes per element of the Tensor.
	 */
	var DTYPE_VALUE_SIZE_MAP = {
	  'float32': 4,
	  'float16': 2,
	  'int32': 4,
	  'uint16': 2,
	  'uint8': 1,
	  'bool': 1,
	  'complex64': 8
	};

	/**
	 * Wraps a list of ArrayBuffers into a `slice()`-able object without allocating
	 * a large ArrayBuffer.
	 *
	 * Allocating large ArrayBuffers (~2GB) can be unstable on Chrome. TFJS loads
	 * its weights as a list of (usually) 4MB ArrayBuffers and then slices the
	 * weight tensors out of them. For small models, it's safe to concatenate all
	 * the weight buffers into a single ArrayBuffer and then slice the weight
	 * tensors out of it, but for large models, a different approach is needed.
	 */
	var CompositeArrayBuffer = /*#__PURE__*/function () {
	  function CompositeArrayBuffer(buffers) {
	    _classCallCheck(this, CompositeArrayBuffer);
	    this.shards = [];
	    this.previousShardIndex = 0;
	    if (buffers == null) {
	      return;
	    }
	    // Normalize the `buffers` input to be `ArrayBuffer[]`.
	    if (!(buffers instanceof Array)) {
	      buffers = [buffers];
	    }
	    buffers = buffers.map(function (bufferOrTypedArray) {
	      if (isTypedArray(bufferOrTypedArray)) {
	        return bufferOrTypedArray.buffer;
	      }
	      return bufferOrTypedArray;
	    });
	    // Skip setting up shards if there are no buffers.
	    if (buffers.length === 0) {
	      return;
	    }
	    this.bufferUniformSize = buffers[0].byteLength;
	    var start = 0;
	    for (var i = 0; i < buffers.length; i++) {
	      var buffer = buffers[i];
	      // Check that all buffers except the last one have the same length.
	      if (i !== buffers.length - 1 && buffer.byteLength !== this.bufferUniformSize) {
	        // Unset the buffer uniform size, since the buffer sizes are not
	        // uniform.
	        this.bufferUniformSize = undefined;
	      }
	      // Create the shards, including their start and end points.
	      var end = start + buffer.byteLength;
	      this.shards.push({
	        buffer: buffer,
	        start: start,
	        end: end
	      });
	      start = end;
	    }
	    // Set the byteLength
	    if (this.shards.length === 0) {
	      this.byteLength = 0;
	    }
	    this.byteLength = this.shards[this.shards.length - 1].end;
	  }
	  _createClass(CompositeArrayBuffer, [{
	    key: "slice",
	    value: function slice() {
	      var start = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
	      var end = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.byteLength;
	      // If there are no shards, then the CompositeArrayBuffer was initialized
	      // with no data.
	      if (this.shards.length === 0) {
	        return new ArrayBuffer(0);
	      }
	      // NaN is treated as zero for slicing. This matches ArrayBuffer's behavior.
	      start = isNaN(Number(start)) ? 0 : start;
	      end = isNaN(Number(end)) ? 0 : end;
	      // Fix the bounds to within the array.
	      start = Math.max(0, start);
	      end = Math.min(this.byteLength, end);
	      if (end <= start) {
	        return new ArrayBuffer(0);
	      }
	      var startShardIndex = this.findShardForByte(start);
	      if (startShardIndex === -1) {
	        // This should not happen since the start and end indices are always
	        // within 0 and the composite array's length.
	        throw new Error("Could not find start shard for byte ".concat(start));
	      }
	      var size = end - start;
	      var outputBuffer = new ArrayBuffer(size);
	      var outputArray = new Uint8Array(outputBuffer);
	      var sliced = 0;
	      for (var i = startShardIndex; i < this.shards.length; i++) {
	        var shard = this.shards[i];
	        var globalStart = start + sliced;
	        var localStart = globalStart - shard.start;
	        var outputStart = sliced;
	        var globalEnd = Math.min(end, shard.end);
	        var localEnd = globalEnd - shard.start;
	        var outputSlice = new Uint8Array(shard.buffer, localStart, localEnd - localStart);
	        outputArray.set(outputSlice, outputStart);
	        sliced += outputSlice.length;
	        if (end < shard.end) {
	          break;
	        }
	      }
	      return outputBuffer;
	    }
	    /**
	     * Get the index of the shard that contains the byte at `byteIndex`.
	     */
	  }, {
	    key: "findShardForByte",
	    value: function findShardForByte(byteIndex) {
	      if (this.shards.length === 0 || byteIndex < 0 || byteIndex >= this.byteLength) {
	        return -1;
	      }
	      // If the buffers have a uniform size, compute the shard directly.
	      if (this.bufferUniformSize != null) {
	        this.previousShardIndex = Math.floor(byteIndex / this.bufferUniformSize);
	        return this.previousShardIndex;
	      }
	      // If the buffers don't have a uniform size, we need to search for the
	      // shard. That means we need a function to check where the byteIndex lies
	      // relative to a given shard.
	      function check(shard) {
	        if (byteIndex < shard.start) {
	          return -1;
	        }
	        if (byteIndex >= shard.end) {
	          return 1;
	        }
	        return 0;
	      }
	      // For efficiency, try the previous shard first.
	      if (check(this.shards[this.previousShardIndex]) === 0) {
	        return this.previousShardIndex;
	      }
	      // Otherwise, use a generic search function.
	      // This should almost never end up being used in practice since the weight
	      // entries should always be in order.
	      var index = search(this.shards, check);
	      if (index === -1) {
	        return -1;
	      }
	      this.previousShardIndex = index;
	      return this.previousShardIndex;
	    }
	  }], [{
	    key: "join",
	    value:
	    /**
	     * Concatenate a number of ArrayBuffers into one.
	     *
	     * @param buffers An array of ArrayBuffers to concatenate, or a single
	     *     ArrayBuffer.
	     * @returns Result of concatenating `buffers` in order.
	     */
	    function join(buffers) {
	      return new CompositeArrayBuffer(buffers).slice();
	    }
	  }]);
	  return CompositeArrayBuffer;
	}();
	/**
	 * Search for an element of a sorted array.
	 *
	 * @param sortedArray The sorted array to search
	 * @param compare A function to compare the current value against the searched
	 *     value. Return 0 on a match, negative if the searched value is less than
	 *     the value passed to the function, and positive if the searched value is
	 *     greater than the value passed to the function.
	 * @returns The index of the element, or -1 if it's not in the array.
	 */
	function search(sortedArray, compare) {
	  // Binary search
	  var min = 0;
	  var max = sortedArray.length;
	  while (min <= max) {
	    var middle = Math.floor((max - min) / 2) + min;
	    var side = compare(sortedArray[middle]);
	    if (side === 0) {
	      return middle;
	    } else if (side < 0) {
	      max = middle;
	    } else {
	      min = middle + 1;
	    }
	  }
	  return -1;
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Enables production mode which disables correctness checks in favor of
	 * performance.
	 *
	 * @doc {heading: 'Environment'}
	 */
	function enableProdMode() {
	  env().set('PROD', true);
	}
	/**
	 * Enables debug mode which will log information about all executed kernels:
	 * the elapsed time of the kernel execution, as well as the rank, shape, and
	 * size of the output tensor.
	 *
	 * Debug mode will significantly slow down your application as it will
	 * download the result of every operation to the CPU. This should not be used in
	 * production. Debug mode does not affect the timing information of the kernel
	 * execution as we do not measure download time in the kernel execution time.
	 *
	 * See also: `tf.profile`, `tf.memory`.
	 *
	 * @doc {heading: 'Environment'}
	 */
	function enableDebugMode() {
	  env().set('DEBUG', true);
	}
	/** Globally disables deprecation warnings */
	function disableDeprecationWarnings() {
	  env().set('DEPRECATION_WARNINGS_ENABLED', false);
	  console.warn("TensorFlow.js deprecation warnings have been disabled.");
	}
	/** Warn users about deprecated functionality. */
	function deprecationWarn(msg) {
	  if (env().getBool('DEPRECATION_WARNINGS_ENABLED')) {
	    console.warn(msg + ' You can disable deprecation warnings with ' + 'tf.disableDeprecationWarnings().');
	  }
	}
	setDeprecationWarningFn(deprecationWarn);
	/**
	 * Dispose all variables kept in backend engine.
	 *
	 * @doc {heading: 'Environment'}
	 */
	function disposeVariables() {
	  ENGINE.disposeVariables();
	}
	/**
	 * It returns the global engine that keeps track of all tensors and backends.
	 *
	 * @doc {heading: 'Environment'}
	 */
	function engine() {
	  return ENGINE;
	}
	/**
	 * Returns memory info at the current time in the program. The result is an
	 * object with the following properties:
	 *
	 * - `numBytes`: Number of bytes allocated (undisposed) at this time.
	 * - `numTensors`: Number of unique tensors allocated.
	 * - `numDataBuffers`: Number of unique data buffers allocated
	 *   (undisposed) at this time, which is ≤ the number of tensors
	 *   (e.g. `a.reshape(newShape)` makes a new Tensor that shares the same
	 *   data buffer with `a`).
	 * - `unreliable`: True if the memory usage is unreliable. See `reasons` when
	 *    `unreliable` is true.
	 * - `reasons`: `string[]`, reasons why the memory is unreliable, present if
	 *    `unreliable` is true.
	 *
	 * WebGL Properties:
	 * - `numBytesInGPU`: Number of bytes allocated (undisposed) in the GPU only at
	 *     this time.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */
	function memory() {
	  return ENGINE.memory();
	}
	/**
	 * Executes the provided function `f()` and returns a promise that resolves
	 * with information about the function's memory use:
	 * - `newBytes`: the number of new bytes allocated
	 * - `newTensors`: the number of new tensors created
	 * - `peakBytes`: the peak number of bytes allocated
	 * - `kernels`: an array of objects for each kernel involved that reports
	 * their input and output shapes, number of bytes used, and number of new
	 * tensors created.
	 * - `kernelNames`: an array of unique strings with just the names of the
	 * kernels in the `kernels` array.
	 *
	 * ```js
	 * const profile = await tf.profile(() => {
	 *   const x = tf.tensor1d([1, 2, 3]);
	 *   let x2 = x.square();
	 *   x2.dispose();
	 *   x2 = x.square();
	 *   x2.dispose();
	 *   return x;
	 * });
	 *
	 * console.log(`newBytes: ${profile.newBytes}`);
	 * console.log(`newTensors: ${profile.newTensors}`);
	 * console.log(`byte usage over all kernels: ${profile.kernels.map(k =>
	 * k.totalBytesSnapshot)}`);
	 * ```
	 *
	 *
	 * @doc {heading: 'Performance', subheading: 'Profile'}
	 */
	function profile(f) {
	  return ENGINE.profile(f);
	}
	/**
	 * Executes the provided function `fn` and after it is executed, cleans up all
	 * intermediate tensors allocated by `fn` except those returned by `fn`.
	 * `fn` must not return a Promise (async functions not allowed). The returned
	 * result can be a complex object.
	 *
	 * Using this method helps avoid memory leaks. In general, wrap calls to
	 * operations in `tf.tidy` for automatic memory cleanup.
	 *
	 * NOTE: Variables do *not* get cleaned up when inside a tidy(). If you want to
	 * dispose variables, please use `tf.disposeVariables` or call dispose()
	 * directly on variables.
	 *
	 * ```js
	 * // y = 2 ^ 2 + 1
	 * const y = tf.tidy(() => {
	 *   // a, b, and one will be cleaned up when the tidy ends.
	 *   const one = tf.scalar(1);
	 *   const a = tf.scalar(2);
	 *   const b = a.square();
	 *
	 *   console.log('numTensors (in tidy): ' + tf.memory().numTensors);
	 *
	 *   // The value returned inside the tidy function will return
	 *   // through the tidy, in this case to the variable y.
	 *   return b.add(one);
	 * });
	 *
	 * console.log('numTensors (outside tidy): ' + tf.memory().numTensors);
	 * y.print();
	 * ```
	 *
	 * @param nameOrFn The name of the closure, or the function to execute.
	 *     If a name is provided, the 2nd argument should be the function.
	 *     If debug mode is on, the timing and the memory usage of the function
	 *     will be tracked and displayed on the console using the provided name.
	 * @param fn The function to execute.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */
	function tidy(nameOrFn, fn) {
	  return ENGINE.tidy(nameOrFn, fn);
	}
	/**
	 * Disposes any `tf.Tensor`s found within the provided object.
	 *
	 * @param container an object that may be a `tf.Tensor` or may directly
	 *     contain `tf.Tensor`s, such as a `Tensor[]` or `{key: Tensor, ...}`. If
	 *     the object is not a `tf.Tensor` or does not contain `Tensors`, nothing
	 *     happens. In general it is safe to pass any object here, except that
	 *     `Promise`s are not supported.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */
	function dispose(container) {
	  var tensors = getTensorsInContainer(container);
	  tensors.forEach(function (tensor) {
	    return tensor.dispose();
	  });
	}
	/**
	 * Keeps a `tf.Tensor` generated inside a `tf.tidy` from being disposed
	 * automatically.
	 *
	 * ```js
	 * let b;
	 * const y = tf.tidy(() => {
	 *   const one = tf.scalar(1);
	 *   const a = tf.scalar(2);
	 *
	 *   // b will not be cleaned up by the tidy. a and one will be cleaned up
	 *   // when the tidy ends.
	 *   b = tf.keep(a.square());
	 *
	 *   console.log('numTensors (in tidy): ' + tf.memory().numTensors);
	 *
	 *   // The value returned inside the tidy function will return
	 *   // through the tidy, in this case to the variable y.
	 *   return b.add(one);
	 * });
	 *
	 * console.log('numTensors (outside tidy): ' + tf.memory().numTensors);
	 * console.log('y:');
	 * y.print();
	 * console.log('b:');
	 * b.print();
	 * ```
	 *
	 * @param result The tensor to keep from being disposed.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */
	function keep(result) {
	  return ENGINE.keep(result);
	}
	/**
	 * Executes `f()` and returns a promise that resolves with timing
	 * information.
	 *
	 * The result is an object with the following properties:
	 *
	 * - `wallMs`: Wall execution time.
	 * - `kernelMs`: Kernel execution time, ignoring data transfer. If using the
	 * WebGL backend and the query timer extension is not available, this will
	 * return an error object.
	 * - On `WebGL` The following additional properties exist:
	 *   - `uploadWaitMs`: CPU blocking time on texture uploads.
	 *   - `downloadWaitMs`: CPU blocking time on texture downloads (readPixels).
	 *
	 * ```js
	 * const x = tf.randomNormal([20, 20]);
	 * const time = await tf.time(() => x.matMul(x));
	 *
	 * console.log(`kernelMs: ${time.kernelMs}, wallTimeMs: ${time.wallMs}`);
	 * ```
	 *
	 * @param f The function to execute and time.
	 *
	 * @doc {heading: 'Performance', subheading: 'Timing'}
	 */
	function time(f) {
	  return ENGINE.time(f);
	}
	/**
	 * Sets the backend (cpu, webgl, wasm, etc) responsible for creating tensors and
	 * executing operations on those tensors. Returns a promise that resolves
	 * to a boolean if the backend initialization was successful.
	 *
	 * Note this disposes the current backend, if any, as well as any tensors
	 * associated with it. A new backend is initialized, even if it is of the
	 * same type as the previous one.
	 *
	 * @param backendName The name of the backend. Currently supports
	 *     `'webgl'|'cpu'` in the browser, `'tensorflow'` under node.js
	 *     (requires tfjs-node), and `'wasm'` (requires tfjs-backend-wasm).
	 *
	 * @doc {heading: 'Backends'}
	 */
	function setBackend$1(backendName) {
	  return ENGINE.setBackend(backendName);
	}
	/**
	 * Returns a promise that resolves when the currently selected backend (or the
	 * highest priority one) has initialized. Await this promise when you are using
	 * a backend that has async initialization.
	 *
	 * @doc {heading: 'Backends'}
	 */
	function ready() {
	  return ENGINE.ready();
	}
	/**
	 * Returns the current backend name (cpu, webgl, etc). The backend is
	 * responsible for creating tensors and executing operations on those tensors.
	 *
	 * @doc {heading: 'Backends'}
	 */
	function getBackend$1() {
	  return ENGINE.backendName;
	}
	/**
	 * Removes a backend and the registered factory.
	 *
	 * @doc {heading: 'Backends'}
	 */
	function removeBackend(name) {
	  ENGINE.removeBackend(name);
	}
	/**
	 * Finds the backend registered under the provided name. Returns null if the
	 * name is not in the registry, or the registration hasn't finished yet.
	 */
	function findBackend(name) {
	  return ENGINE.findBackend(name);
	}
	/**
	 * Finds the backend factory registered under the provided name. Returns a
	 * function that produces a new backend when called. Returns null if the name
	 * is not in the registry.
	 */
	function findBackendFactory(name) {
	  return ENGINE.findBackendFactory(name);
	}
	/**
	 * Registers a global backend. The registration should happen when importing
	 * a module file (e.g. when importing `backend_webgl.ts`), and is used for
	 * modular builds (e.g. custom tfjs bundle with only webgl support).
	 *
	 * @param factory The backend factory function. When called, it should
	 * return a backend instance, or a promise of an instance.
	 * @param priority The priority of the backend (higher = more important).
	 *     In case multiple backends are registered, the priority is used to find
	 *     the best backend. Defaults to 1.
	 * @return False if there is already a registered backend under this name, true
	 *     if not.
	 *
	 * @doc {heading: 'Backends'}
	 */
	function registerBackend(name, factory) {
	  var priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
	  return ENGINE.registerBackend(name, factory, priority);
	}
	/**
	 * Gets the current backend. If no backends have been initialized, this will
	 * attempt to initialize the best backend. Will throw an error if the highest
	 * priority backend has async initialization, in which case you should call
	 * 'await tf.ready()' before running other code.
	 *
	 * @doc {heading: 'Backends'}
	 */
	function backend$1() {
	  return ENGINE.backend;
	}
	/**
	 * Sets the global platform.
	 *
	 * @param platformName The name of this platform.
	 * @param platform A platform implementation.
	 */
	function setPlatform(platformName, platform) {
	  env().setPlatform(platformName, platform);
	}

	/** Number of bytes reserved for the length of the string. (32bit integer). */
	var NUM_BYTES_STRING_LENGTH = 4;
	/**
	 * Encode a map from names to weight values as an ArrayBuffer, along with an
	 * `Array` of `WeightsManifestEntry` as specification of the encoded weights.
	 *
	 * This function does not perform sharding.
	 *
	 * This function is the reverse of `decodeWeights`.
	 *
	 * @param tensors A map ("dict") from names to tensors.
	 * @param group Group to which the weights belong (optional).
	 * @returns A `Promise` of
	 *   - A flat `ArrayBuffer` with all the binary values of the `Tensor`s
	 *     concatenated.
	 *   - An `Array` of `WeightManifestEntry`s, carrying information including
	 *     tensor names, `dtype`s and shapes.
	 * @throws Error: on unsupported tensor `dtype`.
	 */
	function encodeWeights(_x, _x2) {
	  return _encodeWeights.apply(this, arguments);
	}
	/**
	 * Decode flat ArrayBuffer as weights.
	 *
	 * This function does not handle sharding.
	 *
	 * This function is the reverse of `encodeWeights`.
	 *
	 * @param weightData A flat ArrayBuffer or an array of ArrayBuffers carrying the
	 *   binary values of the tensors concatenated in the order specified in
	 *   `specs`.
	 * @param specs Specifications of the names, dtypes and shapes of the tensors
	 *   whose value are encoded by `buffer`.
	 * @return A map from tensor name to tensor value, with the names corresponding
	 *   to names in `specs`.
	 * @throws Error, if any of the tensors has unsupported dtype.
	 */
	function _encodeWeights() {
	  _encodeWeights = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(tensors, group) {
	    var specs, dataPromises, names, _loop, i, tensorValues;
	    return _regeneratorRuntime().wrap(function _callee2$(_context3) {
	      while (1) switch (_context3.prev = _context3.next) {
	        case 0:
	          // TODO(adarob, cais): Support quantization.
	          specs = [];
	          dataPromises = [];
	          names = Array.isArray(tensors) ? tensors.map(function (tensor) {
	            return tensor.name;
	          }) : Object.keys(tensors);
	          _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
	            var name, t, spec, utf8bytes;
	            return _regeneratorRuntime().wrap(function _loop$(_context2) {
	              while (1) switch (_context2.prev = _context2.next) {
	                case 0:
	                  name = names[i];
	                  t = Array.isArray(tensors) ? tensors[i].tensor : tensors[name];
	                  if (!(t.dtype !== 'float32' && t.dtype !== 'int32' && t.dtype !== 'bool' && t.dtype !== 'string' && t.dtype !== 'complex64')) {
	                    _context2.next = 4;
	                    break;
	                  }
	                  throw new Error("Unsupported dtype in weight '".concat(name, "': ").concat(t.dtype));
	                case 4:
	                  spec = {
	                    name: name,
	                    shape: t.shape,
	                    dtype: t.dtype
	                  };
	                  if (t.dtype === 'string') {
	                    utf8bytes = new Promise( /*#__PURE__*/function () {
	                      var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(resolve) {
	                        var vals, totalNumBytes, bytes, offset, _i6, val, bytesOfLength;
	                        return _regeneratorRuntime().wrap(function _callee$(_context) {
	                          while (1) switch (_context.prev = _context.next) {
	                            case 0:
	                              _context.next = 2;
	                              return t.bytes();
	                            case 2:
	                              vals = _context.sent;
	                              totalNumBytes = vals.reduce(function (p, c) {
	                                return p + c.length;
	                              }, 0) + NUM_BYTES_STRING_LENGTH * vals.length;
	                              bytes = new Uint8Array(totalNumBytes);
	                              offset = 0;
	                              for (_i6 = 0; _i6 < vals.length; _i6++) {
	                                val = vals[_i6];
	                                bytesOfLength = new Uint8Array(new Uint32Array([val.length]).buffer);
	                                bytes.set(bytesOfLength, offset);
	                                offset += NUM_BYTES_STRING_LENGTH;
	                                bytes.set(val, offset);
	                                offset += val.length;
	                              }
	                              resolve(bytes);
	                            case 8:
	                            case "end":
	                              return _context.stop();
	                          }
	                        }, _callee);
	                      }));
	                      return function (_x12) {
	                        return _ref.apply(this, arguments);
	                      };
	                    }());
	                    dataPromises.push(utf8bytes);
	                  } else {
	                    dataPromises.push(t.data());
	                  }
	                  if (group != null) {
	                    spec.group = group;
	                  }
	                  specs.push(spec);
	                case 8:
	                case "end":
	                  return _context2.stop();
	              }
	            }, _loop);
	          });
	          i = 0;
	        case 5:
	          if (!(i < names.length)) {
	            _context3.next = 10;
	            break;
	          }
	          return _context3.delegateYield(_loop(), "t0", 7);
	        case 7:
	          ++i;
	          _context3.next = 5;
	          break;
	        case 10:
	          _context3.next = 12;
	          return Promise.all(dataPromises);
	        case 12:
	          tensorValues = _context3.sent;
	          return _context3.abrupt("return", {
	            data: concatenateTypedArrays(tensorValues),
	            specs: specs
	          });
	        case 14:
	        case "end":
	          return _context3.stop();
	      }
	    }, _callee2);
	  }));
	  return _encodeWeights.apply(this, arguments);
	}
	function decodeWeights(weightData, specs) {
	  // TODO(adarob, cais): Support quantization.
	  var compositeBuffer = new CompositeArrayBuffer(weightData);
	  var out = {};
	  var offset = 0;
	  var _iterator = _createForOfIteratorHelper(specs),
	    _step;
	  try {
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      var spec = _step.value;
	      var byteLength = getWeightBytelength(spec, function (start, end) {
	        return compositeBuffer.slice(offset + start, offset + end);
	      });
	      out[spec.name] = decodeWeight(spec, compositeBuffer.slice(offset, offset + byteLength));
	      offset += byteLength;
	    }
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }
	  return out;
	}
	function getWeightBytelength(spec, slice) {
	  var size = sizeFromShape(spec.shape);
	  var bytesPerValue;
	  if ('quantization' in spec) {
	    var quantization = spec.quantization;
	    bytesPerValue = DTYPE_VALUE_SIZE_MAP[quantization.dtype];
	  } else if (spec.dtype === 'string') {
	    // Can not statically determine string length.
	    var byteLength = 0;
	    for (var i = 0; i < size; i++) {
	      byteLength += NUM_BYTES_STRING_LENGTH + new Uint32Array(slice(byteLength, byteLength + NUM_BYTES_STRING_LENGTH))[0];
	    }
	    return byteLength;
	  } else {
	    bytesPerValue = DTYPE_VALUE_SIZE_MAP[spec.dtype];
	  }
	  return size * bytesPerValue;
	}
	function getWeightBytelengthAsync(_x3, _x4) {
	  return _getWeightBytelengthAsync.apply(this, arguments);
	}
	function _getWeightBytelengthAsync() {
	  _getWeightBytelengthAsync = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(spec, slice) {
	    var size, bytesPerValue, quantization, byteLength, i;
	    return _regeneratorRuntime().wrap(function _callee3$(_context4) {
	      while (1) switch (_context4.prev = _context4.next) {
	        case 0:
	          size = sizeFromShape(spec.shape);
	          if (!('quantization' in spec)) {
	            _context4.next = 6;
	            break;
	          }
	          quantization = spec.quantization;
	          bytesPerValue = DTYPE_VALUE_SIZE_MAP[quantization.dtype];
	          _context4.next = 25;
	          break;
	        case 6:
	          if (!(spec.dtype === 'string')) {
	            _context4.next = 24;
	            break;
	          }
	          // Can not statically determine string length.
	          byteLength = 0;
	          i = 0;
	        case 9:
	          if (!(i < size)) {
	            _context4.next = 21;
	            break;
	          }
	          _context4.t0 = byteLength;
	          _context4.t1 = NUM_BYTES_STRING_LENGTH;
	          _context4.t2 = Uint32Array;
	          _context4.next = 15;
	          return slice(byteLength, byteLength + NUM_BYTES_STRING_LENGTH);
	        case 15:
	          _context4.t3 = _context4.sent;
	          _context4.t4 = new _context4.t2(_context4.t3)[0];
	          byteLength = _context4.t0 += _context4.t1 + _context4.t4;
	        case 18:
	          i++;
	          _context4.next = 9;
	          break;
	        case 21:
	          return _context4.abrupt("return", byteLength);
	        case 24:
	          bytesPerValue = DTYPE_VALUE_SIZE_MAP[spec.dtype];
	        case 25:
	          return _context4.abrupt("return", size * bytesPerValue);
	        case 26:
	        case "end":
	          return _context4.stop();
	      }
	    }, _callee3);
	  }));
	  return _getWeightBytelengthAsync.apply(this, arguments);
	}
	function decodeWeight(spec, byteBuffer) {
	  var name = spec.name;
	  var dtype = spec.dtype;
	  var shape = spec.shape;
	  var size = sizeFromShape(shape);
	  var values;
	  var offset = 0;
	  if ('quantization' in spec) {
	    var quantization = spec.quantization;
	    if (quantization.dtype === 'uint8' || quantization.dtype === 'uint16') {
	      if (!('min' in quantization && 'scale' in quantization)) {
	        throw new Error("Weight ".concat(spec.name, " with quantization ").concat(quantization.dtype, " ") + "doesn't have corresponding metadata min and scale.");
	      }
	    } else if (quantization.dtype === 'float16') {
	      if (dtype !== 'float32') {
	        throw new Error("Weight ".concat(spec.name, " is quantized with ").concat(quantization.dtype, " ") + "which only supports weights of type float32 not ".concat(dtype, "."));
	      }
	    } else {
	      throw new Error("Weight ".concat(spec.name, " has unknown ") + "quantization dtype ".concat(quantization.dtype, ". ") + "Supported quantization dtypes are: " + "'uint8', 'uint16', and 'float16'.");
	    }
	    var quantizationSizeFactor = DTYPE_VALUE_SIZE_MAP[quantization.dtype];
	    var quantizedArray = quantization.dtype === 'uint8' ? new Uint8Array(byteBuffer) : new Uint16Array(byteBuffer);
	    if (dtype === 'float32') {
	      if (quantization.dtype === 'uint8' || quantization.dtype === 'uint16') {
	        values = new Float32Array(quantizedArray.length);
	        for (var i = 0; i < quantizedArray.length; i++) {
	          var v = quantizedArray[i];
	          values[i] = v * quantization.scale + quantization.min;
	        }
	      } else if (quantization.dtype === 'float16') {
	        // TODO: This is inefficient. Make getFloat16Decoder efficient.
	        var float16Decode = getFloat16Decoder();
	        values = float16Decode(quantizedArray);
	      } else {
	        throw new Error("Unsupported quantization type ".concat(quantization.dtype, " ") + "for weight type float32.");
	      }
	    } else if (dtype === 'int32') {
	      if (quantization.dtype !== 'uint8' && quantization.dtype !== 'uint16') {
	        throw new Error("Unsupported quantization type ".concat(quantization.dtype, " ") + "for weight type int32.");
	      }
	      values = new Int32Array(quantizedArray.length);
	      for (var _i = 0; _i < quantizedArray.length; _i++) {
	        var _v = quantizedArray[_i];
	        values[_i] = Math.round(_v * quantization.scale + quantization.min);
	      }
	    } else {
	      throw new Error("Unsupported dtype in weight '".concat(name, "': ").concat(dtype));
	    }
	    offset += size * quantizationSizeFactor;
	  } else if (dtype === 'string') {
	    var _size = sizeFromShape(spec.shape);
	    values = [];
	    for (var _i2 = 0; _i2 < _size; _i2++) {
	      var byteLength = new Uint32Array(byteBuffer.slice(offset, offset + NUM_BYTES_STRING_LENGTH))[0];
	      offset += NUM_BYTES_STRING_LENGTH;
	      var bytes = new Uint8Array(byteBuffer.slice(offset, offset + byteLength));
	      values.push(bytes);
	      offset += byteLength;
	    }
	  } else {
	    var dtypeFactor = DTYPE_VALUE_SIZE_MAP[dtype];
	    if (dtype === 'float32') {
	      values = new Float32Array(byteBuffer);
	    } else if (dtype === 'int32') {
	      values = new Int32Array(byteBuffer);
	    } else if (dtype === 'bool') {
	      values = new Uint8Array(byteBuffer);
	    } else if (dtype === 'complex64') {
	      values = new Float32Array(byteBuffer);
	      var real = new Float32Array(values.length / 2);
	      var image = new Float32Array(values.length / 2);
	      for (var _i3 = 0; _i3 < real.length; _i3++) {
	        real[_i3] = values[_i3 * 2];
	        image[_i3] = values[_i3 * 2 + 1];
	      }
	      var realTensor = tensor(real, shape, 'float32');
	      var imageTensor = tensor(image, shape, 'float32');
	      var complexTensor = complex$2(realTensor, imageTensor);
	      realTensor.dispose();
	      imageTensor.dispose();
	      return complexTensor;
	    } else {
	      throw new Error("Unsupported dtype in weight '".concat(name, "': ").concat(dtype));
	    }
	    offset += size * dtypeFactor;
	  }
	  return tensor(values, shape, dtype);
	}
	function readToLength(_x5, _x6, _x7) {
	  return _readToLength.apply(this, arguments);
	}
	function _readToLength() {
	  _readToLength = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(reader, initialData, length) {
	    var data, _yield$reader$read, done, value, missing, newData;
	    return _regeneratorRuntime().wrap(function _callee4$(_context5) {
	      while (1) switch (_context5.prev = _context5.next) {
	        case 0:
	          data = new Uint8Array(initialData);
	        case 1:
	          if (!(data.byteLength < length)) {
	            _context5.next = 16;
	            break;
	          }
	          _context5.next = 4;
	          return reader.read();
	        case 4:
	          _yield$reader$read = _context5.sent;
	          done = _yield$reader$read.done;
	          value = _yield$reader$read.value;
	          if (!(done && value == null)) {
	            _context5.next = 10;
	            break;
	          }
	          missing = length - data.byteLength;
	          throw new Error("Reader is done but ".concat(missing, " bytes are still expected"));
	        case 10:
	          // TODO: Don't create a new array every loop.
	          newData = new Uint8Array(data.length + value.byteLength);
	          newData.set(data, 0);
	          newData.set(new Uint8Array(value), data.length);
	          data = newData;
	          _context5.next = 1;
	          break;
	        case 16:
	          return _context5.abrupt("return", data.buffer);
	        case 17:
	        case "end":
	          return _context5.stop();
	      }
	    }, _callee4);
	  }));
	  return _readToLength.apply(this, arguments);
	}
	function decodeWeightsStream(_x8, _x9) {
	  return _decodeWeightsStream.apply(this, arguments);
	}
	/**
	 * Concatenate TypedArrays into an ArrayBuffer.
	 */
	function _decodeWeightsStream() {
	  _decodeWeightsStream = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee6(weightStream, specs) {
	    var tensors, reader, data, _iterator3, _step3, spec, byteLength, tensorData, weightTensor, b;
	    return _regeneratorRuntime().wrap(function _callee6$(_context7) {
	      while (1) switch (_context7.prev = _context7.next) {
	        case 0:
	          tensors = {};
	          reader = weightStream.getReader();
	          data = new ArrayBuffer(0);
	          _iterator3 = _createForOfIteratorHelper(specs);
	          _context7.prev = 4;
	          _iterator3.s();
	        case 6:
	          if ((_step3 = _iterator3.n()).done) {
	            _context7.next = 21;
	            break;
	          }
	          spec = _step3.value;
	          _context7.next = 10;
	          return getWeightBytelengthAsync(spec, /*#__PURE__*/function () {
	            var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee5(start, end) {
	              return _regeneratorRuntime().wrap(function _callee5$(_context6) {
	                while (1) switch (_context6.prev = _context6.next) {
	                  case 0:
	                    _context6.next = 2;
	                    return readToLength(reader, data, end);
	                  case 2:
	                    data = _context6.sent;
	                    return _context6.abrupt("return", data.slice(start, end));
	                  case 4:
	                  case "end":
	                    return _context6.stop();
	                }
	              }, _callee5);
	            }));
	            return function (_x13, _x14) {
	              return _ref2.apply(this, arguments);
	            };
	          }());
	        case 10:
	          byteLength = _context7.sent;
	          _context7.next = 13;
	          return readToLength(reader, data, byteLength);
	        case 13:
	          data = _context7.sent;
	          // Slice the tensor out
	          tensorData = data.slice(0, byteLength);
	          data = data.slice(byteLength);
	          weightTensor = decodeWeight(spec, tensorData);
	          tensors[spec.name] = weightTensor;
	          // TODO(mattsoulanille): Better way to call uploadToGPU.
	          // TODO(mattsoulanille): Make this work for webgl too.
	          if (getBackend$1() === 'webgpu') {
	            b = backend$1();
	            if ('uploadToGPU' in b && sizeFromShape(weightTensor.shape) >= env().get('WEBGPU_CPU_HANDOFF_SIZE_THRESHOLD')) {
	              b.uploadToGPU(weightTensor.dataId);
	            }
	          }
	        case 19:
	          _context7.next = 6;
	          break;
	        case 21:
	          _context7.next = 26;
	          break;
	        case 23:
	          _context7.prev = 23;
	          _context7.t0 = _context7["catch"](4);
	          _iterator3.e(_context7.t0);
	        case 26:
	          _context7.prev = 26;
	          _iterator3.f();
	          return _context7.finish(26);
	        case 29:
	          return _context7.abrupt("return", tensors);
	        case 30:
	        case "end":
	          return _context7.stop();
	      }
	    }, _callee6, null, [[4, 23, 26, 29]]);
	  }));
	  return _decodeWeightsStream.apply(this, arguments);
	}
	function concatenateTypedArrays(xs) {
	  // TODO(adarob, cais): Support quantization.
	  if (xs === null) {
	    throw new Error("Invalid input value: ".concat(JSON.stringify(xs)));
	  }
	  var totalByteLength = 0;
	  // `normalizedXs` is here for this reason: a `TypedArray`'s `buffer'
	  // can have a different byte length from that of the `TypedArray` itself,
	  // for example, when the `TypedArray` is created from an offset in an
	  // `ArrayBuffer`. `normliazedXs` holds `TypedArray`s whose `buffer`s match
	  // the `TypedArray` in byte length. If an element of `xs` does not show
	  // this property, a new `TypedArray` that satisfy this property will be
	  // constructed and pushed into `normalizedXs`.
	  var normalizedXs = [];
	  xs.forEach(function (x) {
	    totalByteLength += x.byteLength;
	    // tslint:disable:no-any
	    normalizedXs.push(x.byteLength === x.buffer.byteLength ? x : new x.constructor(x));
	    if (!(x instanceof Float32Array || x instanceof Int32Array || x instanceof Uint8Array)) {
	      throw new Error("Unsupported TypedArray subtype: ".concat(x.constructor.name));
	    }
	    // tslint:enable:no-any
	  });

	  var y = new Uint8Array(totalByteLength);
	  var offset = 0;
	  normalizedXs.forEach(function (x) {
	    y.set(new Uint8Array(x.buffer), offset);
	    offset += x.byteLength;
	  });
	  return y.buffer;
	}
	// Use Buffer on Node.js instead of Blob/atob/btoa
	var useNodeBuffer = typeof Buffer !== 'undefined' && (typeof Blob === 'undefined' || typeof atob === 'undefined' || typeof btoa === 'undefined');
	/**
	 * Calculate the byte length of a JavaScript string.
	 *
	 * Note that a JavaScript string can contain wide characters, therefore the
	 * length of the string is not necessarily equal to the byte length.
	 *
	 * @param str Input string.
	 * @returns Byte length.
	 */
	function stringByteLength(str) {
	  if (useNodeBuffer) {
	    return Buffer.byteLength(str, 'utf8');
	  }
	  return new Blob([str]).size;
	}
	/**
	 * Encode an ArrayBuffer as a base64 encoded string.
	 *
	 * @param buffer `ArrayBuffer` to be converted.
	 * @returns A string that base64-encodes `buffer`.
	 */
	function arrayBufferToBase64String(buffer) {
	  if (useNodeBuffer) {
	    return Buffer.from(buffer).toString('base64');
	  }
	  var buf = new Uint8Array(buffer);
	  var s = '';
	  for (var i = 0, l = buf.length; i < l; i++) {
	    s += String.fromCharCode(buf[i]);
	  }
	  return btoa(s);
	}
	/**
	 * Decode a base64 string as an ArrayBuffer.
	 *
	 * @param str Base64 string.
	 * @returns Decoded `ArrayBuffer`.
	 */
	function base64StringToArrayBuffer(str) {
	  if (useNodeBuffer) {
	    var buf = Buffer.from(str, 'base64');
	    return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength);
	  }
	  var s = atob(str);
	  var buffer = new Uint8Array(s.length);
	  for (var i = 0; i < s.length; ++i) {
	    buffer.set([s.charCodeAt(i)], i);
	  }
	  return buffer.buffer;
	}
	/**
	 * Concatenate a number of ArrayBuffers into one.
	 *
	 * @param buffers An array of ArrayBuffers to concatenate, or a single
	 *     ArrayBuffer.
	 * @returns Result of concatenating `buffers` in order.
	 *
	 * @deprecated Use tf.io.CompositeArrayBuffer.join() instead.
	 */
	function concatenateArrayBuffers(buffers) {
	  return CompositeArrayBuffer.join(buffers);
	}
	/**
	 * Get the basename of a path.
	 *
	 * Behaves in a way analogous to Linux's basename command.
	 *
	 * @param path
	 */
	function basename(path) {
	  var SEPARATOR = '/';
	  path = path.trim();
	  while (path.endsWith(SEPARATOR)) {
	    path = path.slice(0, path.length - 1);
	  }
	  var items = path.split(SEPARATOR);
	  return items[items.length - 1];
	}
	/**
	 * Create `ModelJSON` from `ModelArtifacts`.
	 *
	 * @param artifacts Model artifacts, describing the model and its weights.
	 * @param manifest Weight manifest, describing where the weights of the
	 *     `ModelArtifacts` are stored, and some metadata about them.
	 * @returns Object representing the `model.json` file describing the model
	 *     artifacts and weights
	 */
	function getModelJSONForModelArtifacts(artifacts, manifest) {
	  var result = {
	    modelTopology: artifacts.modelTopology,
	    format: artifacts.format,
	    generatedBy: artifacts.generatedBy,
	    convertedBy: artifacts.convertedBy,
	    weightsManifest: manifest
	  };
	  if (artifacts.signature != null) {
	    result.signature = artifacts.signature;
	  }
	  if (artifacts.userDefinedMetadata != null) {
	    result.userDefinedMetadata = artifacts.userDefinedMetadata;
	  }
	  if (artifacts.modelInitializer != null) {
	    result.modelInitializer = artifacts.modelInitializer;
	  }
	  if (artifacts.initializerSignature != null) {
	    result.initializerSignature = artifacts.initializerSignature;
	  }
	  if (artifacts.trainingConfig != null) {
	    result.trainingConfig = artifacts.trainingConfig;
	  }
	  return result;
	}
	/**
	 * Create `ModelArtifacts` from a JSON file and weights.
	 *
	 * @param modelJSON Object containing the parsed JSON of `model.json`
	 * @param weightSpecs The list of WeightsManifestEntry for the model. Must be
	 *     passed if the modelJSON has a weightsManifest.
	 * @param weightData An ArrayBuffer or array of ArrayBuffers of weight data for
	 *     the model corresponding to the weights in weightSpecs. Must be passed if
	 *     the modelJSON has a weightsManifest.
	 * @returns A Promise of the `ModelArtifacts`, as described by the JSON file.
	 */
	function getModelArtifactsForJSONSync(modelJSON, weightSpecs, weightData) {
	  var modelArtifacts = {
	    modelTopology: modelJSON.modelTopology,
	    format: modelJSON.format,
	    generatedBy: modelJSON.generatedBy,
	    convertedBy: modelJSON.convertedBy
	  };
	  if (modelJSON.trainingConfig != null) {
	    modelArtifacts.trainingConfig = modelJSON.trainingConfig;
	  }
	  if (modelJSON.weightsManifest != null) {
	    if (!weightSpecs) {
	      throw new Error('modelJSON has weightsManifest but weightSpecs is null');
	    }
	    if (!weightData) {
	      throw new Error('modelJSON has weightsManifest but weightData is null');
	    }
	    modelArtifacts.weightSpecs = weightSpecs;
	    modelArtifacts.weightData = weightData;
	  }
	  if (modelJSON.signature != null) {
	    modelArtifacts.signature = modelJSON.signature;
	  }
	  if (modelJSON.userDefinedMetadata != null) {
	    modelArtifacts.userDefinedMetadata = modelJSON.userDefinedMetadata;
	  }
	  if (modelJSON.modelInitializer != null) {
	    modelArtifacts.modelInitializer = modelJSON.modelInitializer;
	  }
	  if (modelJSON.initializerSignature != null) {
	    modelArtifacts.initializerSignature = modelJSON.initializerSignature;
	  }
	  return modelArtifacts;
	}
	/**
	 * Create `ModelArtifacts` from a JSON file.
	 *
	 * @param modelJSON Object containing the parsed JSON of `model.json`
	 * @param loadWeights Function that takes the JSON file's weights manifest,
	 *     reads weights from the listed path(s), and returns a Promise of the
	 *     weight manifest entries along with the weights data.
	 * @returns A Promise of the `ModelArtifacts`, as described by the JSON file.
	 */
	function getModelArtifactsForJSON(_x10, _x11) {
	  return _getModelArtifactsForJSON.apply(this, arguments);
	}
	/**
	 * Populate ModelArtifactsInfo fields for a model with JSON topology.
	 * @param modelArtifacts
	 * @returns A ModelArtifactsInfo object.
	 */
	function _getModelArtifactsForJSON() {
	  _getModelArtifactsForJSON = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee7(modelJSON, loadWeights) {
	    var weightSpecs, weightData, _yield$loadWeights, _yield$loadWeights2;
	    return _regeneratorRuntime().wrap(function _callee7$(_context8) {
	      while (1) switch (_context8.prev = _context8.next) {
	        case 0:
	          if (!(modelJSON.weightsManifest != null)) {
	            _context8.next = 7;
	            break;
	          }
	          _context8.next = 3;
	          return loadWeights(modelJSON.weightsManifest);
	        case 3:
	          _yield$loadWeights = _context8.sent;
	          _yield$loadWeights2 = _slicedToArray(_yield$loadWeights, 2);
	          weightSpecs = _yield$loadWeights2[0];
	          weightData = _yield$loadWeights2[1];
	        case 7:
	          return _context8.abrupt("return", getModelArtifactsForJSONSync(modelJSON, weightSpecs, weightData));
	        case 8:
	        case "end":
	          return _context8.stop();
	      }
	    }, _callee7);
	  }));
	  return _getModelArtifactsForJSON.apply(this, arguments);
	}
	function getModelArtifactsInfoForJSON(modelArtifacts) {
	  if (modelArtifacts.modelTopology instanceof ArrayBuffer) {
	    throw new Error('Expected JSON model topology, received ArrayBuffer.');
	  }
	  return {
	    dateSaved: new Date(),
	    modelTopologyType: 'JSON',
	    modelTopologyBytes: modelArtifacts.modelTopology == null ? 0 : stringByteLength(JSON.stringify(modelArtifacts.modelTopology)),
	    weightSpecsBytes: modelArtifacts.weightSpecs == null ? 0 : stringByteLength(JSON.stringify(modelArtifacts.weightSpecs)),
	    weightDataBytes: modelArtifacts.weightData == null ? 0 : new CompositeArrayBuffer(modelArtifacts.weightData).byteLength
	  };
	}
	/**
	 * Concatenate the weights stored in a WeightsManifestConfig into a list of
	 * WeightsManifestEntry
	 *
	 * @param weightsManifest The WeightsManifestConfig to extract weights from.
	 * @returns A list of WeightsManifestEntry of the weights in the weightsManifest
	 */
	function getWeightSpecs(weightsManifest) {
	  var weightSpecs = [];
	  var _iterator2 = _createForOfIteratorHelper(weightsManifest),
	    _step2;
	  try {
	    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	      var entry = _step2.value;
	      weightSpecs.push.apply(weightSpecs, _toConsumableArray(entry.weights));
	    }
	  } catch (err) {
	    _iterator2.e(err);
	  } finally {
	    _iterator2.f();
	  }
	  return weightSpecs;
	}
	/**
	 * Computes mantisa table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 2048 mantissa lookup values.
	 */
	function computeFloat16MantisaTable() {
	  var convertMantissa = function convertMantissa(i) {
	    var m = i << 13;
	    var e = 0;
	    while ((m & 0x00800000) === 0) {
	      e -= 0x00800000;
	      m <<= 1;
	    }
	    m &= ~0x00800000;
	    e += 0x38800000;
	    return m | e;
	  };
	  var mantisaTable = new Uint32Array(2048);
	  mantisaTable[0] = 0;
	  for (var i = 1; i < 1024; i++) {
	    mantisaTable[i] = convertMantissa(i);
	  }
	  for (var _i4 = 1024; _i4 < 2048; _i4++) {
	    mantisaTable[_i4] = 0x38000000 + (_i4 - 1024 << 13);
	  }
	  return mantisaTable;
	}
	/**
	 * Computes exponent table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 64 exponent lookup values.
	 */
	function computeFloat16ExponentTable() {
	  var exponentTable = new Uint32Array(64);
	  exponentTable[0] = 0;
	  exponentTable[31] = 0x47800000;
	  exponentTable[32] = 0x80000000;
	  exponentTable[63] = 0xc7800000;
	  for (var i = 1; i < 31; i++) {
	    exponentTable[i] = i << 23;
	  }
	  for (var _i5 = 33; _i5 < 63; _i5++) {
	    exponentTable[_i5] = 0x80000000 + (_i5 - 32 << 23);
	  }
	  return exponentTable;
	}
	/**
	 * Computes offset table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 6d offset values.
	 */
	function computeFloat16OffsetTable() {
	  var offsetTable = new Uint32Array(64);
	  for (var i = 0; i < 64; i++) {
	    offsetTable[i] = 1024;
	  }
	  offsetTable[0] = offsetTable[32] = 0;
	  return offsetTable;
	}
	/**
	 * Retrieve a Float16 decoder which will decode a ByteArray of Float16 values
	 * to a Float32Array.
	 *
	 * @returns Function (buffer: Uint16Array) => Float32Array which decodes
	 *          the Uint16Array of Float16 bytes to a Float32Array.
	 */
	function getFloat16Decoder() {
	  // Algorithm is based off of
	  // http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	  // Cache lookup tables
	  var mantisaTable = computeFloat16MantisaTable();
	  var exponentTable = computeFloat16ExponentTable();
	  var offsetTable = computeFloat16OffsetTable();
	  return function (quantizedArray) {
	    var buffer = new ArrayBuffer(4 * quantizedArray.length);
	    var bufferUint32View = new Uint32Array(buffer);
	    for (var index = 0; index < quantizedArray.length; index++) {
	      var float16Bits = quantizedArray[index];
	      var float32Bits = mantisaTable[offsetTable[float16Bits >> 10] + (float16Bits & 0x3ff)] + exponentTable[float16Bits >> 10];
	      bufferUint32View[index] = float32Bits;
	    }
	    return new Float32Array(buffer);
	  };
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var IORouterRegistry = /*#__PURE__*/function () {
	  function IORouterRegistry() {
	    _classCallCheck(this, IORouterRegistry);
	    this.saveRouters = [];
	    this.loadRouters = [];
	  }
	  _createClass(IORouterRegistry, null, [{
	    key: "getInstance",
	    value: function getInstance() {
	      if (IORouterRegistry.instance == null) {
	        IORouterRegistry.instance = new IORouterRegistry();
	      }
	      return IORouterRegistry.instance;
	    }
	    /**
	     * Register a save-handler router.
	     *
	     * @param saveRouter A function that maps a URL-like string onto an instance
	     * of `IOHandler` with the `save` method defined or `null`.
	     */
	  }, {
	    key: "registerSaveRouter",
	    value: function registerSaveRouter(saveRouter) {
	      IORouterRegistry.getInstance().saveRouters.push(saveRouter);
	    }
	    /**
	     * Register a load-handler router.
	     *
	     * @param loadRouter A function that maps a URL-like string onto an instance
	     * of `IOHandler` with the `load` method defined or `null`.
	     */
	  }, {
	    key: "registerLoadRouter",
	    value: function registerLoadRouter(loadRouter) {
	      IORouterRegistry.getInstance().loadRouters.push(loadRouter);
	    }
	    /**
	     * Look up IOHandler for saving, given a URL-like string.
	     *
	     * @param url
	     * @returns If only one match is found, an instance of IOHandler with the
	     * `save` method defined. If no match is found, `null`.
	     * @throws Error, if more than one match is found.
	     */
	  }, {
	    key: "getSaveHandlers",
	    value: function getSaveHandlers(url) {
	      return IORouterRegistry.getHandlers(url, 'save');
	    }
	    /**
	     * Look up IOHandler for loading, given a URL-like string.
	     *
	     * @param url
	     * @param loadOptions Optional, custom load options.
	     * @returns All valid handlers for `url`, given the currently registered
	     *   handler routers.
	     */
	  }, {
	    key: "getLoadHandlers",
	    value: function getLoadHandlers(url, loadOptions) {
	      return IORouterRegistry.getHandlers(url, 'load', loadOptions);
	    }
	  }, {
	    key: "getHandlers",
	    value: function getHandlers(url, handlerType, loadOptions) {
	      var validHandlers = [];
	      var routers = handlerType === 'load' ? IORouterRegistry.getInstance().loadRouters : IORouterRegistry.getInstance().saveRouters;
	      routers.forEach(function (router) {
	        var handler = router(url, loadOptions);
	        if (handler !== null) {
	          validHandlers.push(handler);
	        }
	      });
	      return validHandlers;
	    }
	  }]);
	  return IORouterRegistry;
	}();
	var registerSaveRouter = function registerSaveRouter(loudRouter) {
	  return IORouterRegistry.registerSaveRouter(loudRouter);
	};
	var registerLoadRouter = function registerLoadRouter(loudRouter) {
	  return IORouterRegistry.registerLoadRouter(loudRouter);
	};
	var getSaveHandlers = function getSaveHandlers(url) {
	  return IORouterRegistry.getSaveHandlers(url);
	};
	var getLoadHandlers = function getLoadHandlers(url, loadOptions) {
	  return IORouterRegistry.getLoadHandlers(url, loadOptions);
	};

	var DATABASE_NAME = 'tensorflowjs';
	var DATABASE_VERSION = 1;
	// Model data and ModelArtifactsInfo (metadata) are stored in two separate
	// stores for efficient access of the list of stored models and their metadata.
	// 1. The object store for model data: topology, weights and weight manifests.
	var MODEL_STORE_NAME = 'models_store';
	// 2. The object store for ModelArtifactsInfo, including meta-information such
	//    as the type of topology (JSON vs binary), byte size of the topology, byte
	//    size of the weights, etc.
	var INFO_STORE_NAME = 'model_info_store';
	/**
	 * Delete the entire database for tensorflow.js, including the models store.
	 */
	function deleteDatabase() {
	  return _deleteDatabase.apply(this, arguments);
	}
	function _deleteDatabase() {
	  _deleteDatabase = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
	    var idbFactory;
	    return _regeneratorRuntime().wrap(function _callee5$(_context5) {
	      while (1) switch (_context5.prev = _context5.next) {
	        case 0:
	          idbFactory = getIndexedDBFactory();
	          return _context5.abrupt("return", new Promise(function (resolve, reject) {
	            var deleteRequest = idbFactory.deleteDatabase(DATABASE_NAME);
	            deleteRequest.onsuccess = function () {
	              return resolve();
	            };
	            deleteRequest.onerror = function (error) {
	              return reject(error);
	            };
	          }));
	        case 2:
	        case "end":
	          return _context5.stop();
	      }
	    }, _callee5);
	  }));
	  return _deleteDatabase.apply(this, arguments);
	}
	function getIndexedDBFactory() {
	  if (!env().getBool('IS_BROWSER')) {
	    // TODO(cais): Add more info about what IOHandler subtypes are available.
	    //   Maybe point to a doc page on the web and/or automatically determine
	    //   the available IOHandlers and print them in the error message.
	    throw new Error('Failed to obtain IndexedDB factory because the current environment' + 'is not a web browser.');
	  }
	  // tslint:disable-next-line:no-any
	  var theWindow = typeof window === 'undefined' ? self : window;
	  var factory = theWindow.indexedDB || theWindow.mozIndexedDB || theWindow.webkitIndexedDB || theWindow.msIndexedDB || theWindow.shimIndexedDB;
	  if (factory == null) {
	    throw new Error('The current browser does not appear to support IndexedDB.');
	  }
	  return factory;
	}
	function setUpDatabase(openRequest) {
	  var db = openRequest.result;
	  db.createObjectStore(MODEL_STORE_NAME, {
	    keyPath: 'modelPath'
	  });
	  db.createObjectStore(INFO_STORE_NAME, {
	    keyPath: 'modelPath'
	  });
	}
	/**
	 * IOHandler subclass: Browser IndexedDB.
	 *
	 * See the doc string of `browserIndexedDB` for more details.
	 */
	var BrowserIndexedDB = /*#__PURE__*/function () {
	  function BrowserIndexedDB(modelPath) {
	    _classCallCheck(this, BrowserIndexedDB);
	    this.indexedDB = getIndexedDBFactory();
	    if (modelPath == null || !modelPath) {
	      throw new Error('For IndexedDB, modelPath must not be null, undefined or empty.');
	    }
	    this.modelPath = modelPath;
	  }
	  _createClass(BrowserIndexedDB, [{
	    key: "save",
	    value: function () {
	      var _save = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(modelArtifacts) {
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 2;
	                break;
	              }
	              throw new Error('BrowserLocalStorage.save() does not support saving model topology ' + 'in binary formats yet.');
	            case 2:
	              return _context.abrupt("return", this.databaseAction(this.modelPath, modelArtifacts));
	            case 3:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this);
	      }));
	      function save(_x) {
	        return _save.apply(this, arguments);
	      }
	      return save;
	    }()
	  }, {
	    key: "load",
	    value: function () {
	      var _load = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
	        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
	          while (1) switch (_context2.prev = _context2.next) {
	            case 0:
	              return _context2.abrupt("return", this.databaseAction(this.modelPath));
	            case 1:
	            case "end":
	              return _context2.stop();
	          }
	        }, _callee2, this);
	      }));
	      function load() {
	        return _load.apply(this, arguments);
	      }
	      return load;
	    }()
	    /**
	     * Perform database action to put model artifacts into or read model artifacts
	     * from IndexedDB object store.
	     *
	     * Whether the action is put or get depends on whether `modelArtifacts` is
	     * specified. If it is specified, the action will be put; otherwise the action
	     * will be get.
	     *
	     * @param modelPath A unique string path for the model.
	     * @param modelArtifacts If specified, it will be the model artifacts to be
	     *   stored in IndexedDB.
	     * @returns A `Promise` of `SaveResult`, if the action is put, or a `Promise`
	     *   of `ModelArtifacts`, if the action is get.
	     */
	  }, {
	    key: "databaseAction",
	    value: function databaseAction(modelPath, modelArtifacts) {
	      var _this = this;
	      return new Promise(function (resolve, reject) {
	        var openRequest = _this.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);
	        openRequest.onupgradeneeded = function () {
	          return setUpDatabase(openRequest);
	        };
	        openRequest.onsuccess = function () {
	          var db = openRequest.result;
	          if (modelArtifacts == null) {
	            // Read model out from object store.
	            var modelTx = db.transaction(MODEL_STORE_NAME, 'readonly');
	            var modelStore = modelTx.objectStore(MODEL_STORE_NAME);
	            var getRequest = modelStore.get(_this.modelPath);
	            getRequest.onsuccess = function () {
	              if (getRequest.result == null) {
	                db.close();
	                return reject(new Error("Cannot find model with path '".concat(_this.modelPath, "' ") + "in IndexedDB."));
	              } else {
	                resolve(getRequest.result.modelArtifacts);
	              }
	            };
	            getRequest.onerror = function (error) {
	              db.close();
	              return reject(getRequest.error);
	            };
	            modelTx.oncomplete = function () {
	              return db.close();
	            };
	          } else {
	            // Put model into object store.
	            // Concatenate all the model weights into a single ArrayBuffer. Large
	            // models (~1GB) have problems saving if they are not concatenated.
	            // TODO(mattSoulanille): Save large models to multiple indexeddb
	            // records.
	            modelArtifacts.weightData = CompositeArrayBuffer.join(modelArtifacts.weightData);
	            var modelArtifactsInfo = getModelArtifactsInfoForJSON(modelArtifacts);
	            // First, put ModelArtifactsInfo into info store.
	            var infoTx = db.transaction(INFO_STORE_NAME, 'readwrite');
	            var infoStore = infoTx.objectStore(INFO_STORE_NAME);
	            var putInfoRequest;
	            try {
	              putInfoRequest = infoStore.put({
	                modelPath: _this.modelPath,
	                modelArtifactsInfo: modelArtifactsInfo
	              });
	            } catch (error) {
	              return reject(error);
	            }
	            var _modelTx;
	            putInfoRequest.onsuccess = function () {
	              // Second, put model data into model store.
	              _modelTx = db.transaction(MODEL_STORE_NAME, 'readwrite');
	              var modelStore = _modelTx.objectStore(MODEL_STORE_NAME);
	              var putModelRequest;
	              try {
	                putModelRequest = modelStore.put({
	                  modelPath: _this.modelPath,
	                  modelArtifacts: modelArtifacts,
	                  modelArtifactsInfo: modelArtifactsInfo
	                });
	              } catch (error) {
	                // Sometimes, the serialized value is too large to store.
	                return reject(error);
	              }
	              putModelRequest.onsuccess = function () {
	                return resolve({
	                  modelArtifactsInfo: modelArtifactsInfo
	                });
	              };
	              putModelRequest.onerror = function (error) {
	                // If the put-model request fails, roll back the info entry as
	                // well.
	                infoStore = infoTx.objectStore(INFO_STORE_NAME);
	                var deleteInfoRequest = infoStore.delete(_this.modelPath);
	                deleteInfoRequest.onsuccess = function () {
	                  db.close();
	                  return reject(putModelRequest.error);
	                };
	                deleteInfoRequest.onerror = function (error) {
	                  db.close();
	                  return reject(putModelRequest.error);
	                };
	              };
	            };
	            putInfoRequest.onerror = function (error) {
	              db.close();
	              return reject(putInfoRequest.error);
	            };
	            infoTx.oncomplete = function () {
	              if (_modelTx == null) {
	                db.close();
	              } else {
	                _modelTx.oncomplete = function () {
	                  return db.close();
	                };
	              }
	            };
	          }
	        };
	        openRequest.onerror = function (error) {
	          return reject(openRequest.error);
	        };
	      });
	    }
	  }]);
	  return BrowserIndexedDB;
	}();
	BrowserIndexedDB.URL_SCHEME = 'indexeddb://';
	var indexedDBRouter = function indexedDBRouter(url) {
	  if (!env().getBool('IS_BROWSER')) {
	    return null;
	  } else {
	    if (!Array.isArray(url) && url.startsWith(BrowserIndexedDB.URL_SCHEME)) {
	      return browserIndexedDB(url.slice(BrowserIndexedDB.URL_SCHEME.length));
	    } else {
	      return null;
	    }
	  }
	};
	IORouterRegistry.registerSaveRouter(indexedDBRouter);
	IORouterRegistry.registerLoadRouter(indexedDBRouter);
	/**
	 * Creates a browser IndexedDB IOHandler for saving and loading models.
	 *
	 * ```js
	 * const model = tf.sequential();
	 * model.add(
	 *     tf.layers.dense({units: 1, inputShape: [100], activation: 'sigmoid'}));
	 *
	 * const saveResult = await model.save('indexeddb://MyModel'));
	 * console.log(saveResult);
	 * ```
	 *
	 * @param modelPath A unique identifier for the model to be saved. Must be a
	 *   non-empty string.
	 * @returns An instance of `BrowserIndexedDB` (subclass of `IOHandler`),
	 *   which can be used with, e.g., `tf.Model.save`.
	 */
	function browserIndexedDB(modelPath) {
	  return new BrowserIndexedDB(modelPath);
	}
	function maybeStripScheme$1(key) {
	  return key.startsWith(BrowserIndexedDB.URL_SCHEME) ? key.slice(BrowserIndexedDB.URL_SCHEME.length) : key;
	}
	var BrowserIndexedDBManager = /*#__PURE__*/function () {
	  function BrowserIndexedDBManager() {
	    _classCallCheck(this, BrowserIndexedDBManager);
	    this.indexedDB = getIndexedDBFactory();
	  }
	  _createClass(BrowserIndexedDBManager, [{
	    key: "listModels",
	    value: function () {
	      var _listModels = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
	        var _this2 = this;
	        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
	          while (1) switch (_context3.prev = _context3.next) {
	            case 0:
	              return _context3.abrupt("return", new Promise(function (resolve, reject) {
	                var openRequest = _this2.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);
	                openRequest.onupgradeneeded = function () {
	                  return setUpDatabase(openRequest);
	                };
	                openRequest.onsuccess = function () {
	                  var db = openRequest.result;
	                  var tx = db.transaction(INFO_STORE_NAME, 'readonly');
	                  var store = tx.objectStore(INFO_STORE_NAME);
	                  // tslint:disable:max-line-length
	                  // Need to cast `store` as `any` here because TypeScript's DOM
	                  // library does not have the `getAll()` method even though the
	                  // method is supported in the latest version of most mainstream
	                  // browsers:
	                  // https://developer.mozilla.org/en-US/docs/Web/API/IDBObjectStore/getAll
	                  // tslint:enable:max-line-length
	                  // tslint:disable-next-line:no-any
	                  var getAllInfoRequest = store.getAll();
	                  getAllInfoRequest.onsuccess = function () {
	                    var out = {};
	                    var _iterator = _createForOfIteratorHelper(getAllInfoRequest.result),
	                      _step;
	                    try {
	                      for (_iterator.s(); !(_step = _iterator.n()).done;) {
	                        var item = _step.value;
	                        out[item.modelPath] = item.modelArtifactsInfo;
	                      }
	                    } catch (err) {
	                      _iterator.e(err);
	                    } finally {
	                      _iterator.f();
	                    }
	                    resolve(out);
	                  };
	                  getAllInfoRequest.onerror = function (error) {
	                    db.close();
	                    return reject(getAllInfoRequest.error);
	                  };
	                  tx.oncomplete = function () {
	                    return db.close();
	                  };
	                };
	                openRequest.onerror = function (error) {
	                  return reject(openRequest.error);
	                };
	              }));
	            case 1:
	            case "end":
	              return _context3.stop();
	          }
	        }, _callee3);
	      }));
	      function listModels() {
	        return _listModels.apply(this, arguments);
	      }
	      return listModels;
	    }()
	  }, {
	    key: "removeModel",
	    value: function () {
	      var _removeModel = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(path) {
	        var _this3 = this;
	        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
	          while (1) switch (_context4.prev = _context4.next) {
	            case 0:
	              path = maybeStripScheme$1(path);
	              return _context4.abrupt("return", new Promise(function (resolve, reject) {
	                var openRequest = _this3.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);
	                openRequest.onupgradeneeded = function () {
	                  return setUpDatabase(openRequest);
	                };
	                openRequest.onsuccess = function () {
	                  var db = openRequest.result;
	                  var infoTx = db.transaction(INFO_STORE_NAME, 'readwrite');
	                  var infoStore = infoTx.objectStore(INFO_STORE_NAME);
	                  var getInfoRequest = infoStore.get(path);
	                  var modelTx;
	                  getInfoRequest.onsuccess = function () {
	                    if (getInfoRequest.result == null) {
	                      db.close();
	                      return reject(new Error("Cannot find model with path '".concat(path, "' ") + "in IndexedDB."));
	                    } else {
	                      // First, delete the entry in the info store.
	                      var deleteInfoRequest = infoStore.delete(path);
	                      var deleteModelData = function deleteModelData() {
	                        // Second, delete the entry in the model store.
	                        modelTx = db.transaction(MODEL_STORE_NAME, 'readwrite');
	                        var modelStore = modelTx.objectStore(MODEL_STORE_NAME);
	                        var deleteModelRequest = modelStore.delete(path);
	                        deleteModelRequest.onsuccess = function () {
	                          return resolve(getInfoRequest.result.modelArtifactsInfo);
	                        };
	                        deleteModelRequest.onerror = function (error) {
	                          return reject(getInfoRequest.error);
	                        };
	                      };
	                      // Proceed with deleting model data regardless of whether deletion
	                      // of info data succeeds or not.
	                      deleteInfoRequest.onsuccess = deleteModelData;
	                      deleteInfoRequest.onerror = function (error) {
	                        deleteModelData();
	                        db.close();
	                        return reject(getInfoRequest.error);
	                      };
	                    }
	                  };
	                  getInfoRequest.onerror = function (error) {
	                    db.close();
	                    return reject(getInfoRequest.error);
	                  };
	                  infoTx.oncomplete = function () {
	                    if (modelTx == null) {
	                      db.close();
	                    } else {
	                      modelTx.oncomplete = function () {
	                        return db.close();
	                      };
	                    }
	                  };
	                };
	                openRequest.onerror = function (error) {
	                  return reject(openRequest.error);
	                };
	              }));
	            case 2:
	            case "end":
	              return _context4.stop();
	          }
	        }, _callee4);
	      }));
	      function removeModel(_x2) {
	        return _removeModel.apply(this, arguments);
	      }
	      return removeModel;
	    }()
	  }]);
	  return BrowserIndexedDBManager;
	}();

	var PATH_SEPARATOR = '/';
	var PATH_PREFIX = 'tensorflowjs_models';
	var INFO_SUFFIX = 'info';
	var MODEL_TOPOLOGY_SUFFIX = 'model_topology';
	var WEIGHT_SPECS_SUFFIX = 'weight_specs';
	var WEIGHT_DATA_SUFFIX = 'weight_data';
	var MODEL_METADATA_SUFFIX = 'model_metadata';
	/**
	 * Purge all tensorflow.js-saved model artifacts from local storage.
	 *
	 * @returns Paths of the models purged.
	 */
	function purgeLocalStorageArtifacts() {
	  if (!env().getBool('IS_BROWSER') || typeof window === 'undefined' || typeof window.localStorage === 'undefined') {
	    throw new Error('purgeLocalStorageModels() cannot proceed because local storage is ' + 'unavailable in the current environment.');
	  }
	  var LS = window.localStorage;
	  var purgedModelPaths = [];
	  for (var i = 0; i < LS.length; ++i) {
	    var key = LS.key(i);
	    var prefix = PATH_PREFIX + PATH_SEPARATOR;
	    if (key.startsWith(prefix) && key.length > prefix.length) {
	      LS.removeItem(key);
	      var modelName = getModelPathFromKey(key);
	      if (purgedModelPaths.indexOf(modelName) === -1) {
	        purgedModelPaths.push(modelName);
	      }
	    }
	  }
	  return purgedModelPaths;
	}
	function getModelKeys(path) {
	  return {
	    info: [PATH_PREFIX, path, INFO_SUFFIX].join(PATH_SEPARATOR),
	    topology: [PATH_PREFIX, path, MODEL_TOPOLOGY_SUFFIX].join(PATH_SEPARATOR),
	    weightSpecs: [PATH_PREFIX, path, WEIGHT_SPECS_SUFFIX].join(PATH_SEPARATOR),
	    weightData: [PATH_PREFIX, path, WEIGHT_DATA_SUFFIX].join(PATH_SEPARATOR),
	    modelMetadata: [PATH_PREFIX, path, MODEL_METADATA_SUFFIX].join(PATH_SEPARATOR)
	  };
	}
	function removeItems(keys) {
	  for (var _i = 0, _Object$values = Object.values(keys); _i < _Object$values.length; _i++) {
	    var key = _Object$values[_i];
	    window.localStorage.removeItem(key);
	  }
	}
	/**
	 * Get model path from a local-storage key.
	 *
	 * E.g., 'tensorflowjs_models/my/model/1/info' --> 'my/model/1'
	 *
	 * @param key
	 */
	function getModelPathFromKey(key) {
	  var items = key.split(PATH_SEPARATOR);
	  if (items.length < 3) {
	    throw new Error("Invalid key format: ".concat(key));
	  }
	  return items.slice(1, items.length - 1).join(PATH_SEPARATOR);
	}
	function maybeStripScheme(key) {
	  return key.startsWith(BrowserLocalStorage.URL_SCHEME) ? key.slice(BrowserLocalStorage.URL_SCHEME.length) : key;
	}
	/**
	 * IOHandler subclass: Browser Local Storage.
	 *
	 * See the doc string to `browserLocalStorage` for more details.
	 */
	var BrowserLocalStorage = /*#__PURE__*/function () {
	  function BrowserLocalStorage(modelPath) {
	    _classCallCheck(this, BrowserLocalStorage);
	    if (!env().getBool('IS_BROWSER') || typeof window === 'undefined' || typeof window.localStorage === 'undefined') {
	      // TODO(cais): Add more info about what IOHandler subtypes are
	      // available.
	      //   Maybe point to a doc page on the web and/or automatically determine
	      //   the available IOHandlers and print them in the error message.
	      throw new Error('The current environment does not support local storage.');
	    }
	    this.LS = window.localStorage;
	    if (modelPath == null || !modelPath) {
	      throw new Error('For local storage, modelPath must not be null, undefined or empty.');
	    }
	    this.modelPath = modelPath;
	    this.keys = getModelKeys(this.modelPath);
	  }
	  /**
	   * Save model artifacts to browser local storage.
	   *
	   * See the documentation to `browserLocalStorage` for details on the saved
	   * artifacts.
	   *
	   * @param modelArtifacts The model artifacts to be stored.
	   * @returns An instance of SaveResult.
	   */
	  _createClass(BrowserLocalStorage, [{
	    key: "save",
	    value: function () {
	      var _save = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(modelArtifacts) {
	        var topology, weightSpecs, modelArtifactsInfo, weightBuffer, metadata;
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 4;
	                break;
	              }
	              throw new Error('BrowserLocalStorage.save() does not support saving model topology ' + 'in binary formats yet.');
	            case 4:
	              topology = JSON.stringify(modelArtifacts.modelTopology);
	              weightSpecs = JSON.stringify(modelArtifacts.weightSpecs);
	              modelArtifactsInfo = getModelArtifactsInfoForJSON(modelArtifacts); // TODO(mattsoulanille): Support saving models over 2GB that exceed
	              // Chrome's ArrayBuffer size limit.
	              weightBuffer = CompositeArrayBuffer.join(modelArtifacts.weightData);
	              _context.prev = 8;
	              this.LS.setItem(this.keys.info, JSON.stringify(modelArtifactsInfo));
	              this.LS.setItem(this.keys.topology, topology);
	              this.LS.setItem(this.keys.weightSpecs, weightSpecs);
	              this.LS.setItem(this.keys.weightData, arrayBufferToBase64String(weightBuffer));
	              // Note that JSON.stringify doesn't write out keys that have undefined
	              // values, so for some keys, we set undefined instead of a null-ish
	              // value.
	              metadata = {
	                format: modelArtifacts.format,
	                generatedBy: modelArtifacts.generatedBy,
	                convertedBy: modelArtifacts.convertedBy,
	                signature: modelArtifacts.signature != null ? modelArtifacts.signature : undefined,
	                userDefinedMetadata: modelArtifacts.userDefinedMetadata != null ? modelArtifacts.userDefinedMetadata : undefined,
	                modelInitializer: modelArtifacts.modelInitializer != null ? modelArtifacts.modelInitializer : undefined,
	                initializerSignature: modelArtifacts.initializerSignature != null ? modelArtifacts.initializerSignature : undefined,
	                trainingConfig: modelArtifacts.trainingConfig != null ? modelArtifacts.trainingConfig : undefined
	              };
	              this.LS.setItem(this.keys.modelMetadata, JSON.stringify(metadata));
	              return _context.abrupt("return", {
	                modelArtifactsInfo: modelArtifactsInfo
	              });
	            case 18:
	              _context.prev = 18;
	              _context.t0 = _context["catch"](8);
	              // If saving failed, clean up all items saved so far.
	              removeItems(this.keys);
	              throw new Error("Failed to save model '".concat(this.modelPath, "' to local storage: ") + "size quota being exceeded is a possible cause of this failure: " + "modelTopologyBytes=".concat(modelArtifactsInfo.modelTopologyBytes, ", ") + "weightSpecsBytes=".concat(modelArtifactsInfo.weightSpecsBytes, ", ") + "weightDataBytes=".concat(modelArtifactsInfo.weightDataBytes, "."));
	            case 22:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this, [[8, 18]]);
	      }));
	      function save(_x) {
	        return _save.apply(this, arguments);
	      }
	      return save;
	    }()
	    /**
	     * Load a model from local storage.
	     *
	     * See the documentation to `browserLocalStorage` for details on the saved
	     * artifacts.
	     *
	     * @returns The loaded model (if loading succeeds).
	     */
	  }, {
	    key: "load",
	    value: function () {
	      var _load = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
	        var info, out, topology, weightSpecs, metadataString, metadata, weightDataBase64;
	        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
	          while (1) switch (_context2.prev = _context2.next) {
	            case 0:
	              info = JSON.parse(this.LS.getItem(this.keys.info));
	              if (!(info == null)) {
	                _context2.next = 3;
	                break;
	              }
	              throw new Error("In local storage, there is no model with name '".concat(this.modelPath, "'"));
	            case 3:
	              if (!(info.modelTopologyType !== 'JSON')) {
	                _context2.next = 5;
	                break;
	              }
	              throw new Error('BrowserLocalStorage does not support loading non-JSON model ' + 'topology yet.');
	            case 5:
	              out = {}; // Load topology.
	              topology = JSON.parse(this.LS.getItem(this.keys.topology));
	              if (!(topology == null)) {
	                _context2.next = 9;
	                break;
	              }
	              throw new Error("In local storage, the topology of model '".concat(this.modelPath, "' ") + "is missing.");
	            case 9:
	              out.modelTopology = topology;
	              // Load weight specs.
	              weightSpecs = JSON.parse(this.LS.getItem(this.keys.weightSpecs));
	              if (!(weightSpecs == null)) {
	                _context2.next = 13;
	                break;
	              }
	              throw new Error("In local storage, the weight specs of model '".concat(this.modelPath, "' ") + "are missing.");
	            case 13:
	              out.weightSpecs = weightSpecs;
	              // Load meta-data fields.
	              metadataString = this.LS.getItem(this.keys.modelMetadata);
	              if (metadataString != null) {
	                metadata = JSON.parse(metadataString);
	                out.format = metadata.format;
	                out.generatedBy = metadata.generatedBy;
	                out.convertedBy = metadata.convertedBy;
	                if (metadata.signature != null) {
	                  out.signature = metadata.signature;
	                }
	                if (metadata.userDefinedMetadata != null) {
	                  out.userDefinedMetadata = metadata.userDefinedMetadata;
	                }
	                if (metadata.modelInitializer != null) {
	                  out.modelInitializer = metadata.modelInitializer;
	                }
	                if (metadata.initializerSignature != null) {
	                  out.initializerSignature = metadata.initializerSignature;
	                }
	                if (metadata.trainingConfig != null) {
	                  out.trainingConfig = metadata.trainingConfig;
	                }
	              }
	              // Load weight data.
	              weightDataBase64 = this.LS.getItem(this.keys.weightData);
	              if (!(weightDataBase64 == null)) {
	                _context2.next = 19;
	                break;
	              }
	              throw new Error("In local storage, the binary weight values of model " + "'".concat(this.modelPath, "' are missing."));
	            case 19:
	              out.weightData = base64StringToArrayBuffer(weightDataBase64);
	              return _context2.abrupt("return", out);
	            case 21:
	            case "end":
	              return _context2.stop();
	          }
	        }, _callee2, this);
	      }));
	      function load() {
	        return _load.apply(this, arguments);
	      }
	      return load;
	    }()
	  }]);
	  return BrowserLocalStorage;
	}();
	BrowserLocalStorage.URL_SCHEME = 'localstorage://';
	var localStorageRouter = function localStorageRouter(url) {
	  if (!env().getBool('IS_BROWSER')) {
	    return null;
	  } else {
	    if (!Array.isArray(url) && url.startsWith(BrowserLocalStorage.URL_SCHEME)) {
	      return browserLocalStorage(url.slice(BrowserLocalStorage.URL_SCHEME.length));
	    } else {
	      return null;
	    }
	  }
	};
	IORouterRegistry.registerSaveRouter(localStorageRouter);
	IORouterRegistry.registerLoadRouter(localStorageRouter);
	/**
	 * Factory function for local storage IOHandler.
	 *
	 * This `IOHandler` supports both `save` and `load`.
	 *
	 * For each model's saved artifacts, four items are saved to local storage.
	 *   - `${PATH_SEPARATOR}/${modelPath}/info`: Contains meta-info about the
	 *     model, such as date saved, type of the topology, size in bytes, etc.
	 *   - `${PATH_SEPARATOR}/${modelPath}/topology`: Model topology. For Keras-
	 *     style models, this is a stringized JSON.
	 *   - `${PATH_SEPARATOR}/${modelPath}/weight_specs`: Weight specs of the
	 *     model, can be used to decode the saved binary weight values (see
	 *     item below).
	 *   - `${PATH_SEPARATOR}/${modelPath}/weight_data`: Concatenated binary
	 *     weight values, stored as a base64-encoded string.
	 *
	 * Saving may throw an `Error` if the total size of the artifacts exceed the
	 * browser-specific quota.
	 *
	 * @param modelPath A unique identifier for the model to be saved. Must be a
	 *   non-empty string.
	 * @returns An instance of `IOHandler`, which can be used with, e.g.,
	 *   `tf.Model.save`.
	 */
	function browserLocalStorage(modelPath) {
	  return new BrowserLocalStorage(modelPath);
	}
	var BrowserLocalStorageManager = /*#__PURE__*/function () {
	  function BrowserLocalStorageManager() {
	    _classCallCheck(this, BrowserLocalStorageManager);
	    assert$1(env().getBool('IS_BROWSER'), function () {
	      return 'Current environment is not a web browser';
	    });
	    assert$1(typeof window === 'undefined' || typeof window.localStorage !== 'undefined', function () {
	      return 'Current browser does not appear to support localStorage';
	    });
	    this.LS = window.localStorage;
	  }
	  _createClass(BrowserLocalStorageManager, [{
	    key: "listModels",
	    value: function () {
	      var _listModels = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
	        var out, prefix, suffix, i, key, modelPath;
	        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
	          while (1) switch (_context3.prev = _context3.next) {
	            case 0:
	              out = {};
	              prefix = PATH_PREFIX + PATH_SEPARATOR;
	              suffix = PATH_SEPARATOR + INFO_SUFFIX;
	              for (i = 0; i < this.LS.length; ++i) {
	                key = this.LS.key(i);
	                if (key.startsWith(prefix) && key.endsWith(suffix)) {
	                  modelPath = getModelPathFromKey(key);
	                  out[modelPath] = JSON.parse(this.LS.getItem(key));
	                }
	              }
	              return _context3.abrupt("return", out);
	            case 5:
	            case "end":
	              return _context3.stop();
	          }
	        }, _callee3, this);
	      }));
	      function listModels() {
	        return _listModels.apply(this, arguments);
	      }
	      return listModels;
	    }()
	  }, {
	    key: "removeModel",
	    value: function () {
	      var _removeModel = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(path) {
	        var keys, info;
	        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
	          while (1) switch (_context4.prev = _context4.next) {
	            case 0:
	              path = maybeStripScheme(path);
	              keys = getModelKeys(path);
	              if (!(this.LS.getItem(keys.info) == null)) {
	                _context4.next = 4;
	                break;
	              }
	              throw new Error("Cannot find model at path '".concat(path, "'"));
	            case 4:
	              info = JSON.parse(this.LS.getItem(keys.info));
	              removeItems(keys);
	              return _context4.abrupt("return", info);
	            case 7:
	            case "end":
	              return _context4.stop();
	          }
	        }, _callee4, this);
	      }));
	      function removeModel(_x2) {
	        return _removeModel.apply(this, arguments);
	      }
	      return removeModel;
	    }()
	  }]);
	  return BrowserLocalStorageManager;
	}();

	var URL_SCHEME_SUFFIX = '://';
	var ModelStoreManagerRegistry = /*#__PURE__*/function () {
	  function ModelStoreManagerRegistry() {
	    _classCallCheck(this, ModelStoreManagerRegistry);
	    this.managers = {};
	  }
	  _createClass(ModelStoreManagerRegistry, null, [{
	    key: "getInstance",
	    value: function getInstance() {
	      if (ModelStoreManagerRegistry.instance == null) {
	        ModelStoreManagerRegistry.instance = new ModelStoreManagerRegistry();
	      }
	      return ModelStoreManagerRegistry.instance;
	    }
	    /**
	     * Register a save-handler router.
	     *
	     * @param saveRouter A function that maps a URL-like string onto an instance
	     * of `IOHandler` with the `save` method defined or `null`.
	     */
	  }, {
	    key: "registerManager",
	    value: function registerManager(scheme, manager) {
	      assert$1(scheme != null, function () {
	        return 'scheme must not be undefined or null.';
	      });
	      if (scheme.endsWith(URL_SCHEME_SUFFIX)) {
	        scheme = scheme.slice(0, scheme.indexOf(URL_SCHEME_SUFFIX));
	      }
	      assert$1(scheme.length > 0, function () {
	        return 'scheme must not be an empty string.';
	      });
	      var registry = ModelStoreManagerRegistry.getInstance();
	      assert$1(registry.managers[scheme] == null, function () {
	        return "A model store manager is already registered for scheme '".concat(scheme, "'.");
	      });
	      registry.managers[scheme] = manager;
	    }
	  }, {
	    key: "getManager",
	    value: function getManager(scheme) {
	      var manager = ModelStoreManagerRegistry.getInstance().managers[scheme];
	      if (manager == null) {
	        throw new Error("Cannot find model manager for scheme '".concat(scheme, "'"));
	      }
	      return manager;
	    }
	  }, {
	    key: "getSchemes",
	    value: function getSchemes() {
	      return Object.keys(ModelStoreManagerRegistry.getInstance().managers);
	    }
	  }]);
	  return ModelStoreManagerRegistry;
	}();
	/**
	 * Helper method for parsing a URL string into a scheme and a path.
	 *
	 * @param url E.g., 'localstorage://my-model'
	 * @returns A dictionary with two fields: scheme and path.
	 *   Scheme: e.g., 'localstorage' in the example above.
	 *   Path: e.g., 'my-model' in the example above.
	 */
	function parseURL(url) {
	  if (url.indexOf(URL_SCHEME_SUFFIX) === -1) {
	    throw new Error("The url string provided does not contain a scheme. " + "Supported schemes are: " + "".concat(ModelStoreManagerRegistry.getSchemes().join(',')));
	  }
	  return {
	    scheme: url.split(URL_SCHEME_SUFFIX)[0],
	    path: url.split(URL_SCHEME_SUFFIX)[1]
	  };
	}
	function cloneModelInternal(_x, _x2) {
	  return _cloneModelInternal.apply(this, arguments);
	}
	/**
	 * List all models stored in registered storage mediums.
	 *
	 * For a web browser environment, the registered mediums are Local Storage and
	 * IndexedDB.
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * // Then list existing models.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Delete the model.
	 * await tf.io.removeModel('localstorage://demo/management/model1');
	 *
	 * // List models again.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 * ```
	 *
	 * @returns A `Promise` of a dictionary mapping URLs of existing models to
	 * their model artifacts info. URLs include medium-specific schemes, e.g.,
	 *   'indexeddb://my/model/1'. Model artifacts info include type of the
	 * model's topology, byte sizes of the topology, weights, etc.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Management',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */
	function _cloneModelInternal() {
	  _cloneModelInternal = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(sourceURL, destURL) {
	    var deleteSource,
	      loadHandlers,
	      loadHandler,
	      saveHandlers,
	      saveHandler,
	      sourceScheme,
	      sourcePath,
	      sameMedium,
	      modelArtifacts,
	      saveResult,
	      _args = arguments;
	    return _regeneratorRuntime().wrap(function _callee$(_context) {
	      while (1) switch (_context.prev = _context.next) {
	        case 0:
	          deleteSource = _args.length > 2 && _args[2] !== undefined ? _args[2] : false;
	          assert$1(sourceURL !== destURL, function () {
	            return "Old path and new path are the same: '".concat(sourceURL, "'");
	          });
	          loadHandlers = IORouterRegistry.getLoadHandlers(sourceURL);
	          assert$1(loadHandlers.length > 0, function () {
	            return "Copying failed because no load handler is found for source URL ".concat(sourceURL, ".");
	          });
	          assert$1(loadHandlers.length < 2, function () {
	            return "Copying failed because more than one (".concat(loadHandlers.length, ") ") + "load handlers for source URL ".concat(sourceURL, ".");
	          });
	          loadHandler = loadHandlers[0];
	          saveHandlers = IORouterRegistry.getSaveHandlers(destURL);
	          assert$1(saveHandlers.length > 0, function () {
	            return "Copying failed because no save handler is found for destination " + "URL ".concat(destURL, ".");
	          });
	          assert$1(saveHandlers.length < 2, function () {
	            return "Copying failed because more than one (".concat(loadHandlers.length, ") ") + "save handlers for destination URL ".concat(destURL, ".");
	          });
	          saveHandler = saveHandlers[0];
	          sourceScheme = parseURL(sourceURL).scheme;
	          sourcePath = parseURL(sourceURL).path;
	          sameMedium = sourceScheme === parseURL(sourceURL).scheme;
	          _context.next = 15;
	          return loadHandler.load();
	        case 15:
	          modelArtifacts = _context.sent;
	          if (!(deleteSource && sameMedium)) {
	            _context.next = 19;
	            break;
	          }
	          _context.next = 19;
	          return ModelStoreManagerRegistry.getManager(sourceScheme).removeModel(sourcePath);
	        case 19:
	          _context.next = 21;
	          return saveHandler.save(modelArtifacts);
	        case 21:
	          saveResult = _context.sent;
	          if (!(deleteSource && !sameMedium)) {
	            _context.next = 25;
	            break;
	          }
	          _context.next = 25;
	          return ModelStoreManagerRegistry.getManager(sourceScheme).removeModel(sourcePath);
	        case 25:
	          return _context.abrupt("return", saveResult.modelArtifactsInfo);
	        case 26:
	        case "end":
	          return _context.stop();
	      }
	    }, _callee);
	  }));
	  return _cloneModelInternal.apply(this, arguments);
	}
	function listModels() {
	  return _listModels.apply(this, arguments);
	}
	/**
	 * Remove a model specified by URL from a registered storage medium.
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * //